/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.AbstractBandMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.Vector;
import org.netlib.util.intW;

abstract class AbstractTriangBandMatrix
extends AbstractBandMatrix {
    private UpLo uplo;
    private Diag diag;
    int kd;

    AbstractTriangBandMatrix(int n2, int kl, int ku, UpLo uplo, Diag diag) {
        super(n2, kl, ku);
        this.kd = Math.max(kl, ku);
        this.uplo = uplo;
        this.diag = diag;
    }

    AbstractTriangBandMatrix(Matrix A2, int kl, int ku, UpLo uplo, Diag diag) {
        this(A2, kl, ku, true, uplo, diag);
    }

    AbstractTriangBandMatrix(Matrix A2, int kl, int ku, boolean deep, UpLo uplo, Diag diag) {
        super(A2, kl, ku, deep);
        this.kd = Math.max(kl, ku);
        this.uplo = uplo;
        this.diag = diag;
    }

    @Override
    public Vector mult(double alpha, Vector x2, Vector y2) {
        if (!(y2 instanceof DenseVector)) {
            return super.mult(alpha, x2, y2);
        }
        this.checkMultAdd(x2, y2);
        double[] yd = ((DenseVector)y2).getData();
        y2.set(alpha, x2);
        BLAS.getInstance().dtbmv(this.uplo.netlib(), Transpose.NoTranspose.netlib(), this.diag.netlib(), this.numRows, this.kd, this.data, this.kd + 1, yd, 1);
        return y2;
    }

    @Override
    public Vector transMult(double alpha, Vector x2, Vector y2) {
        if (!(y2 instanceof DenseVector)) {
            return super.transMult(alpha, x2, y2);
        }
        this.checkTransMultAdd(x2, y2);
        double[] yd = ((DenseVector)y2).getData();
        y2.set(alpha, x2);
        BLAS.getInstance().dtbmv(this.uplo.netlib(), Transpose.Transpose.netlib(), this.diag.netlib(), this.numRows, this.kd, this.data, this.kd + 1, yd, 1);
        return y2;
    }

    @Override
    public Matrix solve(Matrix B2, Matrix X) {
        return this.solve(B2, X, Transpose.NoTranspose);
    }

    @Override
    public Vector solve(Vector b2, Vector x2) {
        DenseMatrix B2 = new DenseMatrix(b2, false);
        DenseMatrix X = new DenseMatrix(x2, false);
        this.solve(B2, X);
        return x2;
    }

    @Override
    public Matrix transSolve(Matrix B2, Matrix X) {
        return this.solve(B2, X, Transpose.Transpose);
    }

    @Override
    public Vector transSolve(Vector b2, Vector x2) {
        DenseMatrix B2 = new DenseMatrix(b2, false);
        DenseMatrix X = new DenseMatrix(x2, false);
        this.transSolve(B2, X);
        return x2;
    }

    Matrix solve(Matrix B2, Matrix X, Transpose trans) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B2, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B2);
        intW info = new intW(0);
        LAPACK.getInstance().dtbtrs(this.uplo.netlib(), trans.netlib(), this.diag.netlib(), this.numRows, this.kd, X.numColumns(), this.data, Matrices.ld(this.kd + 1), Xd, Matrices.ld(this.n), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }
}

