/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.LAPACK;
import java.util.Iterator;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.AbstractPackMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.Vector;
import org.netlib.util.intW;

abstract class AbstractTriangPackMatrix
extends AbstractPackMatrix {
    UpLo uplo;
    Diag diag;

    AbstractTriangPackMatrix(int n2, UpLo uplo, Diag diag) {
        super(n2);
        this.uplo = uplo;
        this.diag = diag;
    }

    AbstractTriangPackMatrix(Matrix A2, UpLo uplo, Diag diag) {
        this(A2, false, uplo, diag);
    }

    AbstractTriangPackMatrix(Matrix A2, boolean deep, UpLo uplo, Diag diag) {
        super(A2, deep);
        this.uplo = uplo;
        this.diag = diag;
    }

    @Override
    public Vector mult(double alpha, Vector x2, Vector y2) {
        if (!(y2 instanceof DenseVector)) {
            return super.mult(alpha, x2, y2);
        }
        this.checkMultAdd(x2, y2);
        double[] yd = ((DenseVector)y2).getData();
        y2.set(alpha, x2);
        BLAS.getInstance().dtpmv(this.uplo.netlib(), Transpose.NoTranspose.netlib(), this.diag.netlib(), this.numRows, this.data, yd, 1);
        return y2;
    }

    @Override
    public Vector transMult(double alpha, Vector x2, Vector y2) {
        if (!(y2 instanceof DenseVector)) {
            return super.transMult(alpha, x2, y2);
        }
        this.checkTransMultAdd(x2, y2);
        double[] yd = ((DenseVector)y2).getData();
        y2.set(alpha, x2);
        BLAS.getInstance().dtpmv(this.uplo.netlib(), Transpose.Transpose.netlib(), this.diag.netlib(), this.numRows, this.data, yd, 1);
        return y2;
    }

    @Override
    public Matrix solve(Matrix B2, Matrix X) {
        return this.solve(B2, X, Transpose.NoTranspose);
    }

    @Override
    public Vector solve(Vector b2, Vector x2) {
        DenseMatrix B2 = new DenseMatrix(b2, false);
        DenseMatrix X = new DenseMatrix(x2, false);
        this.solve(B2, X);
        return x2;
    }

    @Override
    public Matrix transSolve(Matrix B2, Matrix X) {
        return this.solve(B2, X, Transpose.Transpose);
    }

    @Override
    public Vector transSolve(Vector b2, Vector x2) {
        DenseMatrix B2 = new DenseMatrix(b2, false);
        DenseMatrix X = new DenseMatrix(x2, false);
        this.transSolve(B2, X);
        return x2;
    }

    Matrix solve(Matrix B2, Matrix X, Transpose trans) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B2, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B2);
        intW info = new intW(0);
        LAPACK.getInstance().dtptrs(this.uplo.netlib(), trans.netlib(), this.diag.netlib(), this.numRows, X.numColumns(), this.data, Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new TriangPackMatrixIterator();
    }

    private class TriangPackMatrixIterator
    extends AbstractMatrix.RefMatrixIterator {
        private TriangPackMatrixIterator() {
        }

        @Override
        public MatrixEntry next() {
            this.entry.update(this.row, this.column);
            if (AbstractTriangPackMatrix.this.uplo == UpLo.Lower) {
                if (this.row < AbstractTriangPackMatrix.this.numRows - 1) {
                    ++this.row;
                } else {
                    ++this.column;
                    this.row = this.column;
                }
            } else if (this.row < this.column) {
                ++this.row;
            } else {
                ++this.column;
                this.row = 0;
            }
            return this.entry;
        }
    }
}

