/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.LAPACK;
import java.util.Arrays;
import no.uib.cipr.matrix.AbstractBandMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.Vector;
import org.netlib.util.intW;

public class BandMatrix
extends AbstractBandMatrix {
    public BandMatrix(int n2, int kl, int ku) {
        super(n2, kl, ku);
    }

    public BandMatrix(Matrix A2, int kl, int ku) {
        super(A2, kl, ku);
    }

    public BandMatrix(Matrix A2, int kl, int ku, boolean deep) {
        super(A2, kl, ku, deep);
    }

    @Override
    public BandMatrix copy() {
        return new BandMatrix(this, this.kl, this.ku);
    }

    @Override
    public Matrix zero() {
        Arrays.fill(this.data, 0.0);
        return this;
    }

    @Override
    public Vector multAdd(double alpha, Vector x2, Vector y2) {
        if (!(x2 instanceof DenseVector) || !(y2 instanceof DenseVector)) {
            return super.multAdd(alpha, x2, y2);
        }
        this.checkMultAdd(x2, y2);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y2).getData();
        BLAS.getInstance().dgbmv(Transpose.NoTranspose.netlib(), this.numRows, this.numColumns, this.kl, this.ku, alpha, this.data, this.kl + this.ku + 1, xd, 1, 1.0, yd, 1);
        return y2;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x2, Vector y2) {
        if (!(x2 instanceof DenseVector) || !(y2 instanceof DenseVector)) {
            return super.transMultAdd(alpha, x2, y2);
        }
        this.checkTransMultAdd(x2, y2);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y2).getData();
        BLAS.getInstance().dgbmv(Transpose.Transpose.netlib(), this.numRows, this.numColumns, this.kl, this.ku, alpha, this.data, this.kl + this.ku + 1, xd, 1, 1.0, yd, 1);
        return y2;
    }

    @Override
    public Matrix solve(Matrix B2, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B2, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B2);
        BandMatrix Af = new BandMatrix(this, this.kl, this.ku + this.kl);
        int[] ipiv = new int[this.numRows];
        intW info = new intW(0);
        LAPACK.getInstance().dgbsv(this.numRows, this.kl, this.ku, X.numColumns(), Af.getData(), Matrices.ld(2 * this.kl + this.ku + 1), ipiv, Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    public Vector solve(Vector b2, Vector x2) {
        DenseMatrix B2 = new DenseMatrix(b2, false);
        DenseMatrix X = new DenseMatrix(x2, false);
        this.solve(B2, X);
        return x2;
    }

    @Override
    public Matrix transpose() {
        this.checkTranspose();
        if (this.kl != this.ku) {
            throw new IllegalArgumentException("kl != ku");
        }
        for (int j2 = 0; j2 < this.numColumns; ++j2) {
            for (int i2 = j2 + 1; i2 < Math.min(j2 + this.kl + 1, this.numRows); ++i2) {
                double value = this.get(i2, j2);
                this.set(i2, j2, this.get(j2, i2));
                this.set(j2, i2, value);
            }
        }
        return this;
    }
}

