/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.PermutationMatrix;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.UnitLowerTriangDenseMatrix;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class DenseLU {
    private DenseMatrix LU;
    private int[] piv;
    private boolean singular;

    public DenseLU(int m4, int n2) {
        this.LU = new DenseMatrix(m4, n2);
        this.piv = new int[Math.min(m4, n2)];
    }

    public static DenseLU factorize(Matrix A2) {
        return new DenseLU(A2.numRows(), A2.numColumns()).factor(new DenseMatrix(A2));
    }

    public DenseLU factor(DenseMatrix A2) {
        this.singular = false;
        intW info = new intW(0);
        LAPACK.getInstance().dgetrf(A2.numRows(), A2.numColumns(), A2.getData(), Matrices.ld(A2.numRows()), this.piv, info);
        if (info.val > 0) {
            this.singular = true;
        } else if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        this.LU.set(A2);
        return this;
    }

    public PermutationMatrix getP() {
        PermutationMatrix perm = PermutationMatrix.fromPartialPivots(this.piv);
        perm.transpose();
        return perm;
    }

    public UnitLowerTriangDenseMatrix getL() {
        return new UnitLowerTriangDenseMatrix((Matrix)this.getLU(), false);
    }

    public UpperTriangDenseMatrix getU() {
        return new UpperTriangDenseMatrix((Matrix)this.getLU(), false);
    }

    protected DenseMatrix getLU() {
        return this.LU;
    }

    public double rcond(Matrix A2, Matrix.Norm norm) {
        if (norm != Matrix.Norm.One && norm != Matrix.Norm.Infinity) {
            throw new IllegalArgumentException("Only the 1 or the Infinity norms are supported");
        }
        double anorm = A2.norm(norm);
        int n2 = A2.numRows();
        intW info = new intW(0);
        doubleW rcond = new doubleW(0.0);
        LAPACK.getInstance().dgecon(norm.netlib(), n2, this.LU.getData(), Matrices.ld(n2), anorm, rcond, new double[4 * n2], new int[n2], info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return rcond.val;
    }

    public int[] getPivots() {
        return this.piv;
    }

    public boolean isSingular() {
        return this.singular;
    }

    public DenseMatrix solve(DenseMatrix B2) throws MatrixSingularException {
        return this.solve(B2, Transpose.NoTranspose);
    }

    public DenseMatrix transSolve(DenseMatrix B2) throws MatrixSingularException {
        return this.solve(B2, Transpose.Transpose);
    }

    private DenseMatrix solve(DenseMatrix B2, Transpose trans) throws MatrixSingularException {
        if (this.singular) {
            throw new MatrixSingularException();
        }
        if (B2.numRows() != this.LU.numRows()) {
            throw new IllegalArgumentException("B.numRows() != LU.numRows()");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dgetrs(trans.netlib(), this.LU.numRows(), B2.numColumns(), this.LU.getData(), Matrices.ld(this.LU.numRows()), this.piv, B2.getData(), Matrices.ld(this.LU.numRows()), info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return B2;
    }
}

