/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import no.uib.cipr.matrix.AbstractVector;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.io.MatrixVectorReader;
import no.uib.cipr.matrix.io.VectorInfo;
import no.uib.cipr.matrix.io.VectorSize;

public class DenseVector
extends AbstractVector
implements Serializable {
    private static final long serialVersionUID = 5358813524094629362L;
    private final double[] data;

    public DenseVector(MatrixVectorReader r2) throws IOException {
        super(0);
        VectorInfo info = null;
        info = r2.hasInfo() ? r2.readVectorInfo() : new VectorInfo(true, VectorInfo.VectorField.Real);
        VectorSize size = r2.readVectorSize(info);
        this.size = size.size();
        this.data = new double[size.size()];
        if (info.isPattern()) {
            throw new UnsupportedOperationException("Pattern vectors are not supported");
        }
        if (info.isComplex()) {
            throw new UnsupportedOperationException("Complex vectors are not supported");
        }
        if (info.isCoordinate()) {
            int nz = size.numEntries();
            int[] index = new int[nz];
            double[] entry = new double[nz];
            r2.readCoordinate(index, entry);
            r2.add(-1, index);
            for (int i2 = 0; i2 < nz; ++i2) {
                this.set(index[i2], entry[i2]);
            }
        } else {
            r2.readArray(this.data);
        }
    }

    public DenseVector(int size) {
        super(size);
        this.data = new double[size];
    }

    public DenseVector(Vector x2) {
        this(x2, true);
    }

    public DenseVector(Vector x2, boolean deep) {
        super(x2);
        if (deep) {
            this.data = new double[this.size];
            this.set(x2);
        } else {
            this.data = ((DenseVector)x2).getData();
        }
    }

    public DenseVector(double[] x2, boolean deep) {
        super(x2.length);
        this.data = deep ? (double[])x2.clone() : x2;
    }

    public DenseVector(double[] x2) {
        this(x2, true);
    }

    @Override
    public void set(int index, double value) {
        this.check(index);
        this.data[index] = value;
    }

    @Override
    public void add(int index, double value) {
        this.check(index);
        int n2 = index;
        this.data[n2] = this.data[n2] + value;
    }

    @Override
    public double get(int index) {
        this.check(index);
        return this.data[index];
    }

    @Override
    public DenseVector copy() {
        return new DenseVector(this);
    }

    @Override
    public DenseVector zero() {
        Arrays.fill(this.data, 0.0);
        return this;
    }

    @Override
    public DenseVector scale(double alpha) {
        int i2 = 0;
        while (i2 < this.size) {
            int n2 = i2++;
            this.data[n2] = this.data[n2] * alpha;
        }
        return this;
    }

    @Override
    public Vector set(Vector y2) {
        if (!(y2 instanceof DenseVector)) {
            return super.set(y2);
        }
        this.checkSize(y2);
        double[] yd = ((DenseVector)y2).getData();
        System.arraycopy(yd, 0, this.data, 0, this.size);
        return this;
    }

    @Override
    public Vector set(double alpha, Vector y2) {
        if (!(y2 instanceof DenseVector)) {
            return super.set(alpha, y2);
        }
        this.checkSize(y2);
        if (alpha == 0.0) {
            return this.zero();
        }
        double[] yd = ((DenseVector)y2).getData();
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.data[i2] = alpha * yd[i2];
        }
        return this;
    }

    @Override
    public Vector add(Vector y2) {
        if (!(y2 instanceof DenseVector)) {
            return super.add(y2);
        }
        this.checkSize(y2);
        double[] yd = ((DenseVector)y2).getData();
        for (int i2 = 0; i2 < this.size; ++i2) {
            int n2 = i2;
            this.data[n2] = this.data[n2] + yd[i2];
        }
        return this;
    }

    @Override
    public Vector add(double alpha, Vector y2) {
        if (!(y2 instanceof DenseVector)) {
            return super.add(alpha, y2);
        }
        this.checkSize(y2);
        if (alpha == 0.0) {
            return this;
        }
        double[] yd = ((DenseVector)y2).getData();
        for (int i2 = 0; i2 < this.size; ++i2) {
            int n2 = i2;
            this.data[n2] = this.data[n2] + alpha * yd[i2];
        }
        return this;
    }

    @Override
    public double dot(Vector y2) {
        if (!(y2 instanceof DenseVector)) {
            return super.dot(y2);
        }
        this.checkSize(y2);
        double[] yd = ((DenseVector)y2).getData();
        double dot = 0.0;
        for (int i2 = 0; i2 < this.size; ++i2) {
            dot += this.data[i2] * yd[i2];
        }
        return dot;
    }

    @Override
    protected double norm1() {
        double sum = 0.0;
        for (int i2 = 0; i2 < this.size; ++i2) {
            sum += Math.abs(this.data[i2]);
        }
        return sum;
    }

    @Override
    protected double norm2() {
        double norm = 0.0;
        for (int i2 = 0; i2 < this.size; ++i2) {
            norm += this.data[i2] * this.data[i2];
        }
        return Math.sqrt(norm);
    }

    @Override
    protected double norm2_robust() {
        double scale = 0.0;
        double ssq = 1.0;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.data[i2] == 0.0) continue;
            double absxi = Math.abs(this.data[i2]);
            if (scale < absxi) {
                ssq = 1.0 + ssq * (scale / absxi) * (scale / absxi);
                scale = absxi;
                continue;
            }
            ssq += absxi / scale * (absxi / scale);
        }
        return scale * Math.sqrt(ssq);
    }

    @Override
    protected double normInf() {
        double max = 0.0;
        for (int i2 = 0; i2 < this.size; ++i2) {
            max = Math.max(Math.abs(this.data[i2]), max);
        }
        return max;
    }

    public double[] getData() {
        return this.data;
    }
}

