/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.LowerTriangDenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.OrthogonalComputer;
import org.netlib.util.intW;

public class LQ
extends OrthogonalComputer {
    public LQ(int m4, int n2) {
        super(m4, n2, false);
        if (n2 < m4) {
            throw new IllegalArgumentException("n < m");
        }
        this.work = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dgelqf(m4, n2, new double[0], Matrices.ld(m4), new double[0], this.work, -1, info);
        int lwork = info.val != 0 ? m4 : (int)this.work[0];
        lwork = Math.max(1, lwork);
        this.work = new double[lwork];
        this.workGen = new double[1];
        info = new intW(0);
        LAPACK.getInstance().dorglq(m4, n2, m4, new double[0], Matrices.ld(m4), new double[0], this.workGen, -1, info);
        lwork = info.val != 0 ? m4 : (int)this.workGen[0];
        lwork = Math.max(1, lwork);
        this.workGen = new double[lwork];
    }

    public static LQ factorize(Matrix A2) {
        return new LQ(A2.numRows(), A2.numColumns()).factor(new DenseMatrix(A2));
    }

    @Override
    public LQ factor(DenseMatrix A2) {
        if (this.Q.numRows() != A2.numRows()) {
            throw new IllegalArgumentException("Q.numRows() != A.numRows()");
        }
        if (this.Q.numColumns() != A2.numColumns()) {
            throw new IllegalArgumentException("Q.numColumns() != A.numColumns()");
        }
        if (this.L == null) {
            throw new IllegalArgumentException("L == null");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dgelqf(this.m, this.n, A2.getData(), Matrices.ld(this.m), this.tau, this.work, this.work.length, info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        this.L.zero();
        for (MatrixEntry e2 : A2) {
            if (e2.row() < e2.column()) continue;
            this.L.set(e2.row(), e2.column(), e2.get());
        }
        info.val = 0;
        LAPACK.getInstance().dorglq(this.m, this.n, this.k, A2.getData(), Matrices.ld(this.m), this.tau, this.workGen, this.workGen.length, info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        this.Q.set(A2);
        return this;
    }

    public LowerTriangDenseMatrix getL() {
        return this.L;
    }
}

