/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractSymmDenseMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpLo;

public class LowerSymmDenseMatrix
extends AbstractSymmDenseMatrix {
    public LowerSymmDenseMatrix(int n2) {
        super(n2, UpLo.Lower);
    }

    public LowerSymmDenseMatrix(Matrix A2) {
        this(A2, true);
    }

    public LowerSymmDenseMatrix(Matrix A2, boolean deep) {
        super(A2, deep, UpLo.Lower);
    }

    @Override
    public void add(int row, int column, double value) {
        if (column <= row) {
            super.add(row, column, value);
        }
    }

    @Override
    public double get(int row, int column) {
        if (column > row) {
            return super.get(column, row);
        }
        return super.get(row, column);
    }

    @Override
    public void set(int row, int column, double value) {
        if (column <= row) {
            super.set(row, column, value);
        }
    }

    @Override
    public LowerSymmDenseMatrix copy() {
        return new LowerSymmDenseMatrix(this);
    }

    @Override
    void copy(Matrix A2) {
        for (MatrixEntry e2 : A2) {
            if (e2.row() < e2.column()) continue;
            this.set(e2.row(), e2.column(), e2.get());
        }
    }
}

