/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractSymmPackMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpLo;

public class LowerSymmPackMatrix
extends AbstractSymmPackMatrix {
    public LowerSymmPackMatrix(int n2) {
        super(n2, UpLo.Lower);
    }

    public LowerSymmPackMatrix(Matrix A2) {
        this(A2, true);
    }

    public LowerSymmPackMatrix(Matrix A2, boolean deep) {
        super(A2, deep, UpLo.Lower);
    }

    @Override
    public void add(int row, int column, double value) {
        if (column <= row) {
            int n2 = this.getIndex(row, column);
            this.data[n2] = this.data[n2] + value;
        }
    }

    @Override
    public void set(int row, int column, double value) {
        if (column <= row) {
            this.data[this.getIndex((int)row, (int)column)] = value;
        }
    }

    @Override
    public double get(int row, int column) {
        if (column <= row) {
            return this.data[this.getIndex(row, column)];
        }
        return this.data[this.getIndex(column, row)];
    }

    int getIndex(int row, int column) {
        this.check(row, column);
        return row + (2 * this.n - (column + 1)) * column / 2;
    }

    @Override
    void copy(Matrix A2) {
        for (MatrixEntry e2 : A2) {
            if (e2.row() < e2.column()) continue;
            this.set(e2.row(), e2.column(), e2.get());
        }
    }

    @Override
    public LowerSymmPackMatrix copy() {
        return new LowerSymmPackMatrix(this);
    }
}

