/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.OrthogonalComputer;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;
import org.netlib.util.intW;

public class QR
extends OrthogonalComputer {
    public QR(int m4, int n2) {
        super(m4, n2, true);
        if (n2 > m4) {
            throw new IllegalArgumentException("n > m");
        }
        this.work = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dgeqrf(m4, n2, new double[0], Matrices.ld(m4), new double[0], this.work, -1, info);
        int lwork = info.val != 0 ? n2 : (int)this.work[0];
        lwork = Math.max(1, lwork);
        this.work = new double[lwork];
        this.workGen = new double[1];
        info = new intW(0);
        LAPACK.getInstance().dorgqr(m4, n2, this.k, new double[0], Matrices.ld(m4), new double[0], this.workGen, -1, info);
        lwork = info.val != 0 ? n2 : (int)this.workGen[0];
        lwork = Math.max(1, lwork);
        this.workGen = new double[lwork];
    }

    public static QR factorize(Matrix A2) {
        return new QR(A2.numRows(), A2.numColumns()).factor(new DenseMatrix(A2));
    }

    @Override
    public QR factor(DenseMatrix A2) {
        if (this.Q.numRows() != A2.numRows()) {
            throw new IllegalArgumentException("Q.numRows() != A.numRows()");
        }
        if (this.Q.numColumns() != A2.numColumns()) {
            throw new IllegalArgumentException("Q.numColumns() != A.numColumns()");
        }
        if (this.R == null) {
            throw new IllegalArgumentException("R == null");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dgeqrf(this.m, this.n, A2.getData(), Matrices.ld(this.m), this.tau, this.work, this.work.length, info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        this.R.zero();
        for (MatrixEntry e2 : A2) {
            if (e2.row() > e2.column()) continue;
            this.R.set(e2.row(), e2.column(), e2.get());
        }
        info.val = 0;
        LAPACK.getInstance().dorgqr(this.m, this.n, this.k, A2.getData(), Matrices.ld(this.m), this.tau, this.workGen, this.workGen.length, info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        this.Q.set(A2);
        return this;
    }

    public UpperTriangDenseMatrix getR() {
        return this.R;
    }
}

