/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.JobSVD;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import org.netlib.util.intW;

public class SVD {
    private final double[] work;
    private final int[] iwork;
    private final int m;
    private final int n;
    private final boolean vectors;
    private final JobSVD job;
    private final double[] S;
    private final DenseMatrix U;
    private final DenseMatrix Vt;

    public SVD(int m4, int n2) {
        this(m4, n2, true);
    }

    public SVD(int m4, int n2, boolean vectors) {
        this.m = m4;
        this.n = n2;
        this.vectors = vectors;
        this.S = new double[Math.min(m4, n2)];
        if (vectors) {
            this.U = new DenseMatrix(m4, m4);
            this.Vt = new DenseMatrix(n2, n2);
        } else {
            this.Vt = null;
            this.U = null;
        }
        this.job = vectors ? JobSVD.All : JobSVD.None;
        this.iwork = new int[8 * Math.min(m4, n2)];
        double[] worksize = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dgesdd(this.job.netlib(), m4, n2, new double[0], Matrices.ld(m4), new double[0], new double[0], Matrices.ld(m4), new double[0], Matrices.ld(n2), worksize, -1, this.iwork, info);
        int lwork = -1;
        lwork = info.val != 0 ? (vectors ? 3 * Math.min(m4, n2) * Math.min(m4, n2) + Math.max(Math.max(m4, n2), 4 * Math.min(m4, n2) * Math.min(m4, n2) + 4 * Math.min(m4, n2)) : 3 * Math.min(m4, n2) * Math.min(m4, n2) + Math.max(Math.max(m4, n2), 5 * Math.min(m4, n2) * Math.min(m4, n2) + 4 * Math.min(m4, n2))) : (int)worksize[0];
        lwork = Math.max(lwork, 1);
        this.work = new double[lwork];
    }

    public static SVD factorize(Matrix A2) throws NotConvergedException {
        return new SVD(A2.numRows(), A2.numColumns()).factor(new DenseMatrix(A2));
    }

    public SVD factor(DenseMatrix A2) throws NotConvergedException {
        if (A2.numRows() != this.m) {
            throw new IllegalArgumentException("A.numRows() != m");
        }
        if (A2.numColumns() != this.n) {
            throw new IllegalArgumentException("A.numColumns() != n");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dgesdd(this.job.netlib(), this.m, this.n, A2.getData(), Matrices.ld(this.m), this.S, this.vectors ? this.U.getData() : new double[]{}, Matrices.ld(this.m), this.vectors ? this.Vt.getData() : new double[]{}, Matrices.ld(this.n), this.work, this.work.length, this.iwork, info);
        if (info.val > 0) {
            throw new NotConvergedException(NotConvergedException.Reason.Iterations);
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return this;
    }

    public boolean hasSingularVectors() {
        return this.U != null;
    }

    public DenseMatrix getU() {
        return this.U;
    }

    public DenseMatrix getVt() {
        return this.Vt;
    }

    public double[] getS() {
        return this.S;
    }
}

