/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import java.util.Arrays;
import java.util.Iterator;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Vector;
import org.netlib.util.intW;

public class SymmTridiagMatrix
extends AbstractMatrix {
    double[] diag;
    double[] offDiag;
    int n;

    public SymmTridiagMatrix(double[] diag, double[] offDiag, int n2) {
        super(n2, n2);
        this.n = n2;
        if (n2 < 1) {
            throw new IllegalArgumentException("n must be >= 1");
        }
        if (diag.length < n2) {
            throw new IllegalArgumentException("diag.length < n");
        }
        if (offDiag.length < n2 - 1) {
            throw new IllegalArgumentException("offDiag.length < n - 1");
        }
        this.diag = diag;
        this.offDiag = offDiag;
    }

    public SymmTridiagMatrix(double[] diag, double[] offDiag) {
        this(diag, offDiag, diag.length);
    }

    public SymmTridiagMatrix(int n2) {
        super(n2, n2);
        if (n2 < 1) {
            throw new IllegalArgumentException("n must be >= 1");
        }
        this.n = this.numRows;
        this.diag = new double[n2];
        this.offDiag = new double[n2 - 1];
    }

    public SymmTridiagMatrix(Matrix A2) {
        this(A2, true);
    }

    public SymmTridiagMatrix(Matrix A2, boolean deep) {
        super(A2);
        if (!this.isSquare()) {
            throw new IllegalArgumentException("Symmetric matrix must be square");
        }
        if (A2.numRows() < 1) {
            throw new IllegalArgumentException("numRows must be >= 1");
        }
        this.n = this.numRows;
        if (deep) {
            this.diag = new double[this.n];
            this.offDiag = new double[Math.max(this.n - 1, 0)];
            for (MatrixEntry e2 : A2) {
                if (e2.row() != e2.column() && e2.row() != e2.column() + 1) continue;
                this.set(e2.row(), e2.column(), e2.get());
            }
        } else {
            SymmTridiagMatrix B2 = (SymmTridiagMatrix)A2;
            this.diag = B2.getDiagonal();
            this.offDiag = B2.getOffDiagonal();
        }
    }

    public double[] getDiagonal() {
        return this.diag;
    }

    public double[] getOffDiagonal() {
        return this.offDiag;
    }

    @Override
    public void add(int row, int column, double value) {
        this.check(row, column);
        if (row == column) {
            int n2 = row;
            this.diag[n2] = this.diag[n2] + value;
        } else if (row == column + 1) {
            int n3 = column;
            this.offDiag[n3] = this.offDiag[n3] + value;
        } else if (row != column - 1) {
            throw new IndexOutOfBoundsException("Insertion index outside of band");
        }
    }

    @Override
    public double get(int row, int column) {
        this.check(row, column);
        if (row == column) {
            return this.diag[row];
        }
        if (row == column + 1) {
            return this.offDiag[column];
        }
        if (row == column - 1) {
            return this.offDiag[row];
        }
        return 0.0;
    }

    @Override
    public void set(int row, int column, double value) {
        this.check(row, column);
        if (row == column) {
            this.diag[row] = value;
        } else if (row == column + 1) {
            this.offDiag[column] = value;
        } else if (row != column - 1) {
            throw new IndexOutOfBoundsException("Insertion index outside of band");
        }
    }

    @Override
    public SymmTridiagMatrix copy() {
        return new SymmTridiagMatrix(this);
    }

    @Override
    public SymmTridiagMatrix zero() {
        Arrays.fill(this.diag, 0.0);
        Arrays.fill(this.offDiag, 0.0);
        return this;
    }

    @Override
    public Matrix solve(Matrix B2, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B2, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B2);
        intW info = new intW(0);
        LAPACK.getInstance().dgtsv(this.numRows, X.numColumns(), (double[])this.offDiag.clone(), (double[])this.diag.clone(), (double[])this.offDiag.clone(), Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    public Vector solve(Vector b2, Vector x2) {
        DenseMatrix B2 = new DenseMatrix(b2, false);
        DenseMatrix X = new DenseMatrix(x2, false);
        this.solve(B2, X);
        return x2;
    }

    @Override
    public Matrix transSolve(Matrix B2, Matrix X) {
        return this.solve(B2, X);
    }

    @Override
    public Vector transSolve(Vector b2, Vector x2) {
        return this.solve(b2, x2);
    }

    @Override
    public Matrix transpose() {
        return this;
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new SymmTridiagMatrixIterator();
    }

    private class SymmTridiagMatrixIterator
    extends AbstractMatrix.RefMatrixIterator {
        private double[] band;
        private int bandIndex;
        private int whichBand;

        private SymmTridiagMatrixIterator() {
            super(SymmTridiagMatrix.this);
            this.band = SymmTridiagMatrix.this.diag;
        }

        @Override
        public boolean hasNext() {
            return this.whichBand < 3;
        }

        @Override
        public MatrixEntry next() {
            this.entry.update(this.row, this.column);
            if (this.bandIndex < this.band.length - 1) {
                ++this.bandIndex;
            } else {
                this.bandIndex = 0;
                ++this.whichBand;
                this.band = SymmTridiagMatrix.this.offDiag;
                if (this.band.length == 0) {
                    this.whichBand = 3;
                }
            }
            this.row = this.whichBand == 1 ? this.bandIndex + 1 : this.bandIndex;
            this.column = this.whichBand == 2 ? this.bandIndex + 1 : this.bandIndex;
            return this.entry;
        }
    }
}

