/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.LowerTriangDenseMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;

public class UnitLowerTriangDenseMatrix
extends LowerTriangDenseMatrix {
    public UnitLowerTriangDenseMatrix(int n2) {
        super(n2, Diag.Unit);
    }

    public UnitLowerTriangDenseMatrix(Matrix A2) {
        this(A2, true);
    }

    public UnitLowerTriangDenseMatrix(Matrix A2, boolean deep) {
        super(A2, deep, Diag.Unit);
    }

    @Override
    public void add(int row, int column, double value) {
        if (column == row) {
            throw new IllegalArgumentException("column == row");
        }
        super.add(row, column, value);
    }

    @Override
    public double get(int row, int column) {
        if (column == row) {
            return 1.0;
        }
        return super.get(row, column);
    }

    @Override
    public void set(int row, int column, double value) {
        if (column == row) {
            throw new IllegalArgumentException("column == row");
        }
        super.set(row, column, value);
    }

    @Override
    void copy(Matrix A2) {
        for (MatrixEntry e2 : A2) {
            if (e2.row() <= e2.column()) continue;
            this.set(e2.row(), e2.column(), e2.get());
        }
    }

    @Override
    public UnitLowerTriangDenseMatrix copy() {
        return new UnitLowerTriangDenseMatrix(this);
    }

    @Override
    public Matrix zero() {
        throw new UnsupportedOperationException();
    }
}

