/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractSymmDenseMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpLo;

public class UpperSymmDenseMatrix
extends AbstractSymmDenseMatrix {
    public UpperSymmDenseMatrix(int n2) {
        super(n2, UpLo.Upper);
    }

    public UpperSymmDenseMatrix(Matrix A2) {
        this(A2, true);
    }

    public UpperSymmDenseMatrix(Matrix A2, boolean deep) {
        super(A2, deep, UpLo.Upper);
    }

    @Override
    public void add(int row, int column, double value) {
        if (row <= column) {
            super.add(row, column, value);
        }
    }

    @Override
    public double get(int row, int column) {
        if (row > column) {
            return super.get(column, row);
        }
        return super.get(row, column);
    }

    @Override
    public void set(int row, int column, double value) {
        if (row <= column) {
            super.set(row, column, value);
        }
    }

    @Override
    public UpperSymmDenseMatrix copy() {
        return new UpperSymmDenseMatrix(this);
    }

    @Override
    void copy(Matrix A2) {
        for (MatrixEntry e2 : A2) {
            if (e2.row() > e2.column()) continue;
            this.set(e2.row(), e2.column(), e2.get());
        }
    }
}

