/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.Preconditioner;

public class DiagonalPreconditioner
implements Preconditioner {
    private double[] invdiag;

    public DiagonalPreconditioner(int n2) {
        this.invdiag = new double[n2];
    }

    @Override
    public Vector apply(Vector b2, Vector x2) {
        if (!(x2 instanceof DenseVector) || !(b2 instanceof DenseVector)) {
            throw new IllegalArgumentException("Vector must be DenseVectors");
        }
        double[] xd = ((DenseVector)x2).getData();
        double[] bd = ((DenseVector)b2).getData();
        for (int i2 = 0; i2 < this.invdiag.length; ++i2) {
            xd[i2] = bd[i2] * this.invdiag[i2];
        }
        return x2;
    }

    @Override
    public Vector transApply(Vector b2, Vector x2) {
        return this.apply(b2, x2);
    }

    @Override
    public void setMatrix(Matrix A2) {
        if (A2.numRows() != this.invdiag.length) {
            throw new IllegalArgumentException("Matrix size differs from preconditioner size");
        }
        for (int i2 = 0; i2 < this.invdiag.length; ++i2) {
            this.invdiag[i2] = A2.get(i2, i2);
            if (this.invdiag[i2] == 0.0) {
                throw new RuntimeException("Zero diagonal on row " + (i2 + 1));
            }
            this.invdiag[i2] = 1.0 / this.invdiag[i2];
        }
    }
}

