/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.util.Arrays;
import java.util.Iterator;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.SparseVector;
import no.uib.cipr.matrix.sparse.SuperIterator;

public class FlexCompColMatrix
extends AbstractMatrix {
    SparseVector[] colD;

    public FlexCompColMatrix(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.colD = new SparseVector[numColumns];
        for (int i2 = 0; i2 < numColumns; ++i2) {
            this.colD[i2] = new SparseVector(numRows);
        }
    }

    public FlexCompColMatrix(Matrix A2, boolean deep) {
        super(A2);
        this.colD = new SparseVector[this.numColumns];
        if (deep) {
            for (int i2 = 0; i2 < this.numColumns; ++i2) {
                this.colD[i2] = new SparseVector(this.numRows);
            }
            this.set(A2);
        } else {
            FlexCompColMatrix Ar = (FlexCompColMatrix)A2;
            for (int i3 = 0; i3 < this.numColumns; ++i3) {
                this.colD[i3] = Ar.getColumn(i3);
            }
        }
    }

    public FlexCompColMatrix(Matrix A2) {
        this(A2, true);
    }

    public SparseVector getColumn(int i2) {
        return this.colD[i2];
    }

    public void setColumn(int i2, SparseVector x2) {
        if (x2.size() != this.numRows) {
            throw new IllegalArgumentException("New column must be of the same size as existing column");
        }
        this.colD[i2] = x2;
    }

    @Override
    public Vector multAdd(double alpha, Vector x2, Vector y2) {
        if (!(x2 instanceof DenseVector) || !(y2 instanceof DenseVector)) {
            return super.multAdd(alpha, x2, y2);
        }
        this.checkMultAdd(x2, y2);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y2).getData();
        y2.scale(1.0 / alpha);
        for (int i2 = 0; i2 < this.numColumns; ++i2) {
            SparseVector v2 = this.colD[i2];
            int[] index = v2.getIndex();
            double[] data = v2.getData();
            int length = v2.getUsed();
            for (int j2 = 0; j2 < length; ++j2) {
                int n2 = index[j2];
                yd[n2] = yd[n2] + data[j2] * xd[i2];
            }
        }
        return y2.scale(alpha);
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x2, Vector y2) {
        this.checkTransMultAdd(x2, y2);
        for (int i2 = 0; i2 < this.numColumns; ++i2) {
            y2.add(i2, alpha * this.colD[i2].dot(x2));
        }
        return y2;
    }

    @Override
    public void add(int row, int column, double value) {
        this.colD[column].add(row, value);
    }

    @Override
    public void set(int row, int column, double value) {
        this.colD[column].set(row, value);
    }

    @Override
    public double get(int row, int column) {
        return this.colD[column].get(row);
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new ColMatrixIterator();
    }

    @Override
    public FlexCompColMatrix copy() {
        return new FlexCompColMatrix(this);
    }

    @Override
    public FlexCompColMatrix zero() {
        for (int i2 = 0; i2 < this.numColumns; ++i2) {
            this.colD[i2].zero();
        }
        return this;
    }

    public void compact() {
        for (SparseVector v2 : this.colD) {
            v2.compact();
        }
    }

    private static class ColMatrixEntry
    implements MatrixEntry {
        private int column;
        private VectorEntry entry;

        private ColMatrixEntry() {
        }

        public void update(int column, VectorEntry entry) {
            this.column = column;
            this.entry = entry;
        }

        @Override
        public int row() {
            return this.entry.index();
        }

        @Override
        public int column() {
            return this.column;
        }

        @Override
        public double get() {
            return this.entry.get();
        }

        @Override
        public void set(double value) {
            this.entry.set(value);
        }
    }

    private class ColMatrixIterator
    implements Iterator<MatrixEntry> {
        private SuperIterator<SparseVector, VectorEntry> iterator;
        private ColMatrixEntry entry;

        private ColMatrixIterator() {
            this.iterator = new SuperIterator(Arrays.asList(FlexCompColMatrix.this.colD));
            this.entry = new ColMatrixEntry();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public MatrixEntry next() {
            Object se = this.iterator.next();
            this.entry.update(((SuperIterator.SuperIteratorEntry)se).index(), (VectorEntry)((SuperIterator.SuperIteratorEntry)se).get());
            return this.entry;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

