/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.util.Arrays;
import java.util.Iterator;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.SparseVector;
import no.uib.cipr.matrix.sparse.SuperIterator;

public class FlexCompRowMatrix
extends AbstractMatrix {
    SparseVector[] rowD;

    public FlexCompRowMatrix(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.rowD = new SparseVector[numRows];
        for (int i2 = 0; i2 < numRows; ++i2) {
            this.rowD[i2] = new SparseVector(numColumns);
        }
    }

    public FlexCompRowMatrix(Matrix A2, boolean deep) {
        super(A2);
        this.rowD = new SparseVector[this.numRows];
        if (deep) {
            for (int i2 = 0; i2 < this.numRows; ++i2) {
                this.rowD[i2] = new SparseVector(this.numColumns);
            }
            this.set(A2);
        } else {
            FlexCompRowMatrix Ar = (FlexCompRowMatrix)A2;
            for (int i3 = 0; i3 < this.numRows; ++i3) {
                this.rowD[i3] = Ar.getRow(i3);
            }
        }
    }

    public FlexCompRowMatrix(Matrix A2) {
        this(A2, true);
    }

    public SparseVector getRow(int i2) {
        return this.rowD[i2];
    }

    public void setRow(int i2, SparseVector x2) {
        if (x2.size() != this.numColumns) {
            throw new IllegalArgumentException("New row must be of the same size as existing row");
        }
        this.rowD[i2] = x2;
    }

    @Override
    public Vector multAdd(double alpha, Vector x2, Vector y2) {
        this.checkMultAdd(x2, y2);
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            y2.add(i2, alpha * this.rowD[i2].dot(x2));
        }
        return y2;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x2, Vector y2) {
        if (!(x2 instanceof DenseVector) || !(y2 instanceof DenseVector)) {
            return super.transMultAdd(alpha, x2, y2);
        }
        this.checkTransMultAdd(x2, y2);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y2).getData();
        y2.scale(1.0 / alpha);
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            SparseVector v2 = this.rowD[i2];
            int[] index = v2.getIndex();
            double[] data = v2.getData();
            int length = v2.getUsed();
            for (int j2 = 0; j2 < length; ++j2) {
                int n2 = index[j2];
                yd[n2] = yd[n2] + data[j2] * xd[i2];
            }
        }
        return y2.scale(alpha);
    }

    @Override
    public void add(int row, int column, double value) {
        this.rowD[row].add(column, value);
    }

    @Override
    public void set(int row, int column, double value) {
        this.rowD[row].set(column, value);
    }

    @Override
    public double get(int row, int column) {
        return this.rowD[row].get(column);
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new RowMatrixIterator();
    }

    @Override
    public Matrix copy() {
        return new FlexCompRowMatrix(this);
    }

    @Override
    public FlexCompRowMatrix zero() {
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            this.rowD[i2].zero();
        }
        return this;
    }

    @Override
    public Matrix set(Matrix B2) {
        if (!(B2 instanceof FlexCompRowMatrix)) {
            return super.set(B2);
        }
        this.checkSize(B2);
        FlexCompRowMatrix Bc = (FlexCompRowMatrix)B2;
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            this.rowD[i2].set(Bc.rowD[i2]);
        }
        return this;
    }

    public void compact() {
        for (SparseVector v2 : this.rowD) {
            v2.compact();
        }
    }

    private static class RowMatrixEntry
    implements MatrixEntry {
        private int row;
        private VectorEntry entry;

        private RowMatrixEntry() {
        }

        public void update(int row, VectorEntry entry) {
            this.row = row;
            this.entry = entry;
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public int column() {
            return this.entry.index();
        }

        @Override
        public double get() {
            return this.entry.get();
        }

        @Override
        public void set(double value) {
            this.entry.set(value);
        }
    }

    private class RowMatrixIterator
    implements Iterator<MatrixEntry> {
        private SuperIterator<SparseVector, VectorEntry> iterator;
        private RowMatrixEntry entry;

        private RowMatrixIterator() {
            this.iterator = new SuperIterator(Arrays.asList(FlexCompRowMatrix.this.rowD));
            this.entry = new RowMatrixEntry();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public MatrixEntry next() {
            Object se = this.iterator.next();
            this.entry.update(((SuperIterator.SuperIteratorEntry)se).index(), (VectorEntry)((SuperIterator.SuperIteratorEntry)se).get());
            return this.entry;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

