/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.Arrays;
import no.uib.cipr.matrix.sparse.CompRowMatrix;
import no.uib.cipr.matrix.sparse.Preconditioner;
import no.uib.cipr.matrix.sparse.UnitLowerCompRowMatrix;
import no.uib.cipr.matrix.sparse.UpperCompRowMatrix;

public class ILU
implements Preconditioner {
    private final CompRowMatrix LU;
    private Matrix L;
    private Matrix U;
    private final Vector y;

    public ILU(CompRowMatrix LU) {
        if (!LU.isSquare()) {
            throw new IllegalArgumentException("ILU only applies to square matrices");
        }
        this.LU = LU;
        int n2 = LU.numRows();
        this.y = new DenseVector(n2);
    }

    @Override
    public Vector apply(Vector b2, Vector x2) {
        this.L.solve(b2, this.y);
        return this.U.solve(this.y, x2);
    }

    @Override
    public Vector transApply(Vector b2, Vector x2) {
        this.U.transSolve(b2, this.y);
        return this.L.transSolve(this.y, x2);
    }

    @Override
    public void setMatrix(Matrix A2) {
        this.LU.set(A2);
        this.factor();
    }

    private void factor() {
        int n2 = this.LU.numRows();
        int[] colind = this.LU.getColumnIndices();
        int[] rowptr = this.LU.getRowPointers();
        double[] data = this.LU.getData();
        int[] diagind = this.findDiagonalIndices(n2, colind, rowptr);
        for (int k2 = 1; k2 < n2; ++k2) {
            for (int i2 = rowptr[k2]; i2 < diagind[k2]; ++i2) {
                int index = colind[i2];
                double LUii = data[diagind[index]];
                if (LUii == 0.0) {
                    throw new RuntimeException("Zero pivot encountered on row " + (i2 + 1) + " during ILU process");
                }
                int n3 = i2;
                double d2 = data[n3] / LUii;
                data[n3] = d2;
                double LUki = d2;
                int l2 = rowptr[k2] + 1;
                for (int j2 = diagind[index] + 1; j2 < rowptr[index + 1]; ++j2) {
                    while (l2 < rowptr[k2 + 1] && colind[l2] < colind[j2]) {
                        ++l2;
                    }
                    if (colind[l2] != colind[j2]) continue;
                    int n4 = l2;
                    data[n4] = data[n4] - LUki * data[j2];
                }
            }
        }
        this.L = new UnitLowerCompRowMatrix(this.LU, diagind);
        this.U = new UpperCompRowMatrix(this.LU, diagind);
    }

    private int[] findDiagonalIndices(int m4, int[] colind, int[] rowptr) {
        int[] diagind = new int[m4];
        for (int k2 = 0; k2 < m4; ++k2) {
            diagind[k2] = Arrays.binarySearch(colind, k2, rowptr[k2], rowptr[k2 + 1]);
            if (diagind[k2] >= 0) continue;
            throw new RuntimeException("Missing diagonal entry on row " + (k2 + 1));
        }
        return diagind;
    }
}

