/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.DefaultIterationMonitor;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;

public class MatrixIterationMonitor
extends DefaultIterationMonitor {
    private double normA;
    private double normb;

    public MatrixIterationMonitor(double normA, double normb, int maxIter, double rtol, double atol, double dtol) {
        this.normA = normA;
        this.normb = normb;
        this.maxIter = maxIter;
        this.rtol = rtol;
        this.atol = atol;
        this.dtol = dtol;
    }

    public MatrixIterationMonitor(double normA, double normb) {
        this.normA = normA;
        this.normb = normb;
    }

    public void setMatrixNorm(double normA) {
        this.normA = normA;
    }

    public void setVectorNorm(double normb) {
        this.normb = normb;
    }

    @Override
    protected boolean convergedI(double r2, Vector x2) throws IterativeSolverNotConvergedException {
        if (this.isFirst()) {
            this.initR = r2;
        }
        if (r2 < Math.max(this.rtol * (this.normA * x2.norm(this.normType) + this.normb), this.atol)) {
            return true;
        }
        if (r2 > this.dtol * this.initR) {
            throw new IterativeSolverNotConvergedException(NotConvergedException.Reason.Divergence, this);
        }
        if (this.iter >= this.maxIter) {
            throw new IterativeSolverNotConvergedException(NotConvergedException.Reason.Iterations, this);
        }
        if (Double.isNaN(r2)) {
            throw new IterativeSolverNotConvergedException(NotConvergedException.Reason.Divergence, this);
        }
        return false;
    }

    @Override
    protected boolean convergedI(double r2) {
        throw new UnsupportedOperationException();
    }
}

