/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.util.Iterator;
import no.uib.cipr.matrix.AbstractVector;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.Arrays;
import no.uib.cipr.matrix.sparse.ISparseVector;

public class SparseVector
extends AbstractVector
implements ISparseVector {
    double[] data;
    int[] index;
    int used;

    public SparseVector(int size, int nz) {
        super(size);
        this.data = new double[nz];
        this.index = new int[nz];
    }

    public SparseVector(Vector x2, boolean deep) {
        super(x2);
        if (deep) {
            int nz = Matrices.cardinality(x2);
            this.data = new double[nz];
            this.index = new int[nz];
            this.set(x2);
        } else {
            SparseVector xs = (SparseVector)x2;
            this.data = xs.getData();
            this.index = xs.getIndex();
            this.used = xs.getUsed();
        }
    }

    public SparseVector(Vector x2) {
        this(x2, true);
    }

    public SparseVector(int size) {
        this(size, 0);
    }

    public SparseVector(int size, int[] index, double[] data, boolean deep) {
        super(size);
        if (index.length != data.length) {
            throw new IllegalArgumentException("index.length != data.length");
        }
        if (deep) {
            this.used = index.length;
            this.index = (int[])index.clone();
            this.data = (double[])data.clone();
        } else {
            this.index = index;
            this.data = data;
            this.used = index.length;
        }
    }

    public SparseVector(int size, int[] index, double[] data) {
        this(size, index, data, true);
    }

    @Override
    public void set(int index, double value) {
        this.check(index);
        int i2 = this.getIndex(index);
        this.data[i2] = value;
    }

    @Override
    public void add(int index, double value) {
        int i2;
        this.check(index);
        int n2 = i2 = this.getIndex(index);
        this.data[n2] = this.data[n2] + value;
    }

    @Override
    public double get(int index) {
        this.check(index);
        int in = Arrays.binarySearch(this.index, index, 0, this.used);
        if (in >= 0) {
            return this.data[in];
        }
        return 0.0;
    }

    private int getIndex(int ind) {
        int i2 = Arrays.binarySearchGreater(this.index, ind, 0, this.used);
        if (i2 < this.used && this.index[i2] == ind) {
            return i2;
        }
        int[] newIndex = this.index;
        double[] newData = this.data;
        if (++this.used > this.data.length) {
            int newLength = this.data.length != 0 ? this.data.length << 1 : 1;
            newLength = Math.min(newLength, this.size);
            newIndex = new int[newLength];
            newData = new double[newLength];
            System.arraycopy(this.index, 0, newIndex, 0, i2);
            System.arraycopy(this.data, 0, newData, 0, i2);
        }
        System.arraycopy(this.index, i2, newIndex, i2 + 1, this.used - i2 - 1);
        System.arraycopy(this.data, i2, newData, i2 + 1, this.used - i2 - 1);
        newIndex[i2] = ind;
        newData[i2] = 0.0;
        this.index = newIndex;
        this.data = newData;
        return i2;
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(this);
    }

    @Override
    public SparseVector zero() {
        java.util.Arrays.fill(this.data, 0.0);
        this.used = 0;
        return this;
    }

    @Override
    public SparseVector scale(double alpha) {
        if (alpha == 0.0) {
            return this.zero();
        }
        if (alpha == 1.0) {
            return this;
        }
        int i2 = 0;
        while (i2 < this.used) {
            int n2 = i2++;
            this.data[n2] = this.data[n2] * alpha;
        }
        return this;
    }

    @Override
    public double dot(Vector y2) {
        if (!(y2 instanceof DenseVector)) {
            return super.dot(y2);
        }
        this.checkSize(y2);
        double[] yd = ((DenseVector)y2).getData();
        double ret = 0.0;
        for (int i2 = 0; i2 < this.used; ++i2) {
            ret += this.data[i2] * yd[this.index[i2]];
        }
        return ret;
    }

    @Override
    protected double norm1() {
        double sum = 0.0;
        for (int i2 = 0; i2 < this.used; ++i2) {
            sum += Math.abs(this.data[i2]);
        }
        return sum;
    }

    @Override
    protected double norm2() {
        double norm = 0.0;
        for (int i2 = 0; i2 < this.used; ++i2) {
            norm += this.data[i2] * this.data[i2];
        }
        return Math.sqrt(norm);
    }

    @Override
    protected double norm2_robust() {
        double scale = 0.0;
        double ssq = 1.0;
        for (int i2 = 0; i2 < this.used; ++i2) {
            if (this.data[i2] == 0.0) continue;
            double absxi = Math.abs(this.data[i2]);
            if (scale < absxi) {
                ssq = 1.0 + ssq * Math.pow(scale / absxi, 2.0);
                scale = absxi;
                continue;
            }
            ssq += Math.pow(absxi / scale, 2.0);
        }
        return scale * Math.sqrt(ssq);
    }

    @Override
    protected double normInf() {
        double max = 0.0;
        for (int i2 = 0; i2 < this.used; ++i2) {
            max = Math.max(Math.abs(this.data[i2]), max);
        }
        return max;
    }

    public double[] getData() {
        return this.data;
    }

    @Override
    public int[] getIndex() {
        if (this.used == this.index.length) {
            return this.index;
        }
        int[] indices = new int[this.used];
        System.arraycopy(this.index, 0, indices, 0, this.used);
        return indices;
    }

    public int[] getRawIndex() {
        return this.index;
    }

    public double[] getRawData() {
        return this.data;
    }

    @Override
    public int getUsed() {
        return this.used;
    }

    public void compact() {
        int nz = Matrices.cardinality(this);
        if (nz < this.data.length) {
            int[] newIndex = new int[nz];
            double[] newData = new double[nz];
            int j2 = 0;
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                if (this.data[i2] == 0.0) continue;
                newIndex[j2] = this.index[i2];
                newData[j2] = this.data[i2];
                ++j2;
            }
            this.data = newData;
            this.index = newIndex;
            this.used = this.data.length;
        }
    }

    @Override
    public Iterator<VectorEntry> iterator() {
        return new SparseVectorIterator();
    }

    @Override
    public Vector set(Vector y2) {
        if (!(y2 instanceof SparseVector)) {
            return super.set(y2);
        }
        this.checkSize(y2);
        SparseVector yc = (SparseVector)y2;
        if (yc.index.length != this.index.length) {
            this.data = new double[yc.data.length];
            this.index = new int[yc.data.length];
        }
        System.arraycopy(yc.data, 0, this.data, 0, this.data.length);
        System.arraycopy(yc.index, 0, this.index, 0, this.index.length);
        this.used = yc.used;
        return this;
    }

    private class SparseVectorEntry
    implements VectorEntry {
        private int cursor;

        private SparseVectorEntry() {
        }

        public void update(int cursor) {
            this.cursor = cursor;
        }

        @Override
        public int index() {
            return SparseVector.this.index[this.cursor];
        }

        @Override
        public double get() {
            return SparseVector.this.data[this.cursor];
        }

        @Override
        public void set(double value) {
            SparseVector.this.data[this.cursor] = value;
        }
    }

    private class SparseVectorIterator
    implements Iterator<VectorEntry> {
        private int cursor;
        private final SparseVectorEntry entry;

        private SparseVectorIterator() {
            this.entry = new SparseVectorEntry();
        }

        @Override
        public boolean hasNext() {
            return this.cursor < SparseVector.this.used;
        }

        @Override
        public VectorEntry next() {
            this.entry.update(this.cursor);
            ++this.cursor;
            return this.entry;
        }

        @Override
        public void remove() {
            this.entry.set(0.0);
        }
    }
}

