/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.util.Iterator;
import java.util.List;

class SuperIterator<T extends Iterable<E>, E>
implements Iterator<SuperIteratorEntry> {
    private List<T> iterable;
    private Iterator<E> current;
    private Iterator<E> next;
    private int currentIndex = 0;
    private int nextIndex = 0;
    private SuperIteratorEntry<E> entry;

    public SuperIterator(List<T> iterable) {
        this.iterable = iterable;
        this.entry = new SuperIteratorEntry();
        if (iterable.size() == 0) {
            this.current = new DummyIterator();
            this.next = new DummyIterator();
        } else {
            this.next = ((Iterable)iterable.get(this.nextIndex)).iterator();
            this.moveNext();
            this.current = ((Iterable)iterable.get(this.currentIndex)).iterator();
            this.moveCurrent();
            if (this.next.hasNext()) {
                this.next.next();
            }
        }
    }

    private void moveNext() {
        while (this.nextIndex < this.iterable.size() - 1 && !this.next.hasNext()) {
            this.next = ((Iterable)this.iterable.get(++this.nextIndex)).iterator();
        }
    }

    private void moveCurrent() {
        while (this.currentIndex < this.iterable.size() - 1 && !this.current.hasNext()) {
            this.current = ((Iterable)this.iterable.get(++this.currentIndex)).iterator();
        }
    }

    @Override
    public boolean hasNext() {
        return this.current.hasNext() || this.next.hasNext();
    }

    @Override
    public SuperIteratorEntry<E> next() {
        this.entry.update(this.currentIndex, this.current.next());
        this.moveCurrent();
        this.moveNext();
        if (this.next.hasNext()) {
            this.next.next();
        }
        return this.entry;
    }

    @Override
    public void remove() {
        this.current.remove();
    }

    public static class SuperIteratorEntry<F> {
        private int i;
        private F o;

        void update(int i2, F o2) {
            this.i = i2;
            this.o = o2;
        }

        public int index() {
            return this.i;
        }

        public F get() {
            return this.o;
        }
    }

    private class DummyIterator
    implements Iterator<E> {
        private DummyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

