/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.h2o.backends.internal;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OContext;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.h2o.backends.internal.RpcReferenceCache$;
import org.apache.spark.h2o.backends.internal.SpreadRDDBuilder$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.local.LocalSchedulerBackend;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005}c!B\u0001\u0003\u0001!q!\u0001E*qe\u0016\fGM\u0015#E\u0005VLG\u000eZ3s\u0015\t\u0019A!\u0001\u0005j]R,'O\\1m\u0015\t)a!\u0001\u0005cC\u000e\\WM\u001c3t\u0015\t9\u0001\"A\u0002ie=T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0004\u0001=)\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u001735\tqC\u0003\u0002\u0019\u0011\u00051Q\r\u001f9pg\u0016L!AG\f\u0003\u000f1{wmZ5oO\"AA\u0004\u0001BC\u0002\u0013%a$\u0001\u0002iG\u000e\u0001Q#A\u0010\u0011\u0005\u00012S\"A\u0011\u000b\u0005\t\u001a\u0013!C:qCJ\\G.\u001b8h\u0015\t9AEC\u0001&\u0003\t\t\u0017.\u0003\u0002(C\tQ\u0001JM(D_:$X\r\u001f;\t\u0011%\u0002!\u0011!Q\u0001\n}\t1\u0001[2!Q\tA3\u0006\u0005\u0002\u0011Y%\u0011Q&\u0005\u0002\niJ\fgn]5f]RD\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\u0010]VlW\t_3dkR|'\u000fS5oiB\u0019\u0001#M\u001a\n\u0005I\n\"AB(qi&|g\u000e\u0005\u0002\u0011i%\u0011Q'\u0005\u0002\u0004\u0013:$\b\"B\u001c\u0001\t\u0003A\u0014A\u0002\u001fj]&$h\bF\u0002:wq\u0002\"A\u000f\u0001\u000e\u0003\tAQ\u0001\b\u001cA\u0002}Aqa\f\u001c\u0011\u0002\u0003\u0007\u0001\u0007C\u0004?\u0001\t\u0007I\u0011B \u0002\t\r|gNZ\u000b\u0002\u0001B\u0011\u0001%Q\u0005\u0003\u0005\u0006\u0012q\u0001\u0013\u001aP\u0007>tg\r\u0003\u0004E\u0001\u0001\u0006I\u0001Q\u0001\u0006G>tg\r\t\u0005\b\r\u0002\u0011\r\u0011\"\u0003H\u0003\u001dI7\u000fT8dC2,\u0012\u0001\u0013\t\u0003!%K!AS\t\u0003\u000f\t{w\u000e\\3b]\"1A\n\u0001Q\u0001\n!\u000b\u0001\"[:M_\u000e\fG\u000e\t\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001P\u0003%\u0019\b/\u0019:l\u0007>tg-F\u0001Q!\t\t&+D\u0001\t\u0013\t\u0019\u0006BA\u0005Ta\u0006\u00148nQ8oM\"1Q\u000b\u0001Q\u0001\nA\u000b!b\u001d9be.\u001cuN\u001c4!\u0011\u001d9\u0006A1A\u0005\na\u000bAB\\;n\u000bb,7-\u001e;peN,\u0012\u0001\r\u0005\u00075\u0002\u0001\u000b\u0011\u0002\u0019\u0002\u001b9,X.\u0012=fGV$xN]:!\u0011\u0015a\u0006\u0001\"\u0001^\u0003\u0015\u0011W/\u001b7e)\u0005q\u0006c\u0001\t`C&\u0011\u0001-\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I\"\t1A\u001d9d\u0013\t17M\u0001\bSa\u000e,e\u000e\u001a9pS:$(+\u001a4\t\u000bq\u0003A\u0011\u00025\u0015\tyK7.\u001c\u0005\u0006U\u001e\u0004\raM\u0001\t]J,GO]5fg\")An\u001aa\u0001g\u00059QNZ1di>\u0014\b\"\u00028h\u0001\u0004\u0019\u0014\u0001\u00048v[R\u0013\u0018.Z:TC6,\u0007FA4q!\t\tH/D\u0001s\u0015\t\u0019\u0018#\u0001\u0006b]:|G/\u0019;j_:L!!\u001e:\u0003\u000fQ\f\u0017\u000e\u001c:fG\")q\u000f\u0001C\u0005q\u0006qA/[7f_V$X\t\u001f9je\u0016$Gc\u0001%z}\")!P\u001ea\u0001w\u0006I1\u000f^1siRKW.\u001a\t\u0003!qL!!`\t\u0003\t1{gn\u001a\u0005\u0006\u007fZ\u0004\raM\u0001\bi&lWm\\;u\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000b\t1C\\;n\u001f\u001a\u001c\u0006/\u0019:l\u000bb,7-\u001e;peN,\u0012a\r\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u00039I7OQ1dW\u0016tGMU3bIf$\u0012\u0001\u0013\u0005\n\u0003\u001f\u0001!\u0019!C\u0005\u0003#\t!a]2\u0016\u0005\u0005M\u0001cA)\u0002\u0016%\u0019\u0011q\u0003\u0005\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u0011\u0005m\u0001\u0001)A\u0005\u0003'\t1a]2!Q\r\tIbK\u0004\u000b\u0003C\u0011\u0011\u0011!E\u0001\u0011\u0005\r\u0012\u0001E*qe\u0016\fGM\u0015#E\u0005VLG\u000eZ3s!\rQ\u0014Q\u0005\u0004\n\u0003\t\t\t\u0011#\u0001\t\u0003O\u0019R!!\n\u0010\u0003S\u00012\u0001EA\u0016\u0013\r\ti#\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\bo\u0005\u0015B\u0011AA\u0019)\t\t\u0019\u0003\u0003\u0006\u00026\u0005\u0015\u0012\u0013!C\u0001\u0003o\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCAA\u001dU\r\u0001\u00141H\u0016\u0003\u0003{\u0001B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007\u0012\u0018!C;oG\",7m[3e\u0013\u0011\t9%!\u0011\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0002L\u0005\u0015\u0012\u0011!C\u0005\u0003\u001b\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\n\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0013\u0001\u00026bm\u0006LA!!\u0018\u0002T\t1qJ\u00196fGR\u0004")
public class SpreadRDDBuilder
implements org.apache.spark.expose.Logging {
    private final transient H2OContext hc;
    public final Option<Object> org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$numExecutorHint;
    private final H2OConf org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$conf;
    private final boolean isLocal;
    private final SparkConf sparkConf;
    private final Option<Object> org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$numExecutors;
    private final transient SparkContext sc;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Object> $lessinit$greater$default$2() {
        return SpreadRDDBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private H2OContext hc() {
        return this.hc;
    }

    private SparkContext sc() {
        return this.sc;
    }

    public H2OConf org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$conf() {
        return this.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$conf;
    }

    private boolean isLocal() {
        return this.isLocal;
    }

    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    public Option<Object> org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$numExecutors() {
        return this.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$numExecutors;
    }

    public RpcEndpointRef[] build() {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpreadRDDBuilder $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Building SpreadRDD: numExecutors=", ", numExecutorHint=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$numExecutors(), this.$outer.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$numExecutorHint}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return this.build(this.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$conf().numRddRetries(), this.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$conf().drddMulFactor(), 0);
    }

    private RpcEndpointRef[] build(int nretries, int mfactor, int numTriesSame) {
        while (true) {
            this.logDebug((Function0<String>)new Serializable(this, nretries, mfactor, numTriesSame){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SpreadRDDBuilder $outer;
                private final int nretries$1;
                private final int mfactor$1;
                private final int numTriesSame$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating RDD for launching H2O nodes (mretries=", ", mfactor=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.nretries$1), BoxesRunTime.boxToInteger((int)this.mfactor$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numTriesSame=", ", backend#isReady=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numTriesSame$1), BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$isBackendReady())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.nretries$1 = nretries$1;
                    this.mfactor$1 = mfactor$1;
                    this.numTriesSame$1 = numTriesSame$1;
                }
            });
            int nSparkExecBefore = this.numOfSparkExecutors();
            int expectedWorkers = BoxesRunTime.unboxToInt((Object)this.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$numExecutors().orElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SpreadRDDBuilder $outer;

                public final Option<Object> apply() {
                    return this.$outer.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$numExecutorHint;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).getOrElse((Function0)new Serializable(this, nSparkExecBefore){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SpreadRDDBuilder $outer;
                private final int nSparkExecBefore$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return this.nSparkExecBefore$1 > 0 ? this.nSparkExecBefore$1 : this.$outer.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$conf().defaultCloudSize();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.nSparkExecBefore$1 = nSparkExecBefore$1;
                }
            }));
            RDD spreadRDD = this.sc().parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), mfactor * expectedWorkers), mfactor * expectedWorkers + 1, ClassTag$.MODULE$.Int());
            RpcEndpointRef[] endpoints = (RpcEndpointRef[])spreadRDD.mapPartitions((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SpreadRDDBuilder $outer;

                public final Iterator<RpcEndpointRef> apply(Iterator<Object> x$1) {
                    return package$.MODULE$.Iterator().single((Object)RpcReferenceCache$.MODULE$.getRef(this.$outer.sparkConf()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, spreadRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(RpcEndpointRef.class)).distinct().collect();
            int currentWorkers = endpoints.length;
            int nSparkExecAfter = this.numOfSparkExecutors();
            int timeout = this.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$conf().spreadRddRetriesTimeout();
            long startTime = System.currentTimeMillis();
            if ((currentWorkers < expectedWorkers || nSparkExecAfter != nSparkExecBefore) && nretries <= 0 && this.timeoutExpired(startTime, timeout)) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot execute H2O on all Spark executors:\n           | Expected number of H2O workers is ", "\n           | Detected number of Spark workers is ", "\n           | Num of Spark executors before is ", "\n           | Num of Spark executors after is ", "\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$numExecutorHint, BoxesRunTime.boxToInteger((int)currentWorkers), BoxesRunTime.boxToInteger((int)nSparkExecBefore), BoxesRunTime.boxToInteger((int)nSparkExecAfter)})))).stripMargin());
            }
            if (nSparkExecAfter != nSparkExecBefore || nSparkExecAfter != currentWorkers) {
                this.logInfo((Function0<String>)new Serializable(this, nSparkExecBefore, nSparkExecAfter){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SpreadRDDBuilder $outer;
                    private final int nSparkExecBefore$1;
                    private final int nSparkExecAfter$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected ", " before, and ", " Spark executors after, backend#isReady=", "! Retrying again..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.nSparkExecBefore$1), BoxesRunTime.boxToInteger((int)this.nSparkExecAfter$1), BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$isBackendReady())}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.nSparkExecBefore$1 = nSparkExecBefore$1;
                        this.nSparkExecAfter$1 = nSparkExecAfter$1;
                    }
                });
                numTriesSame = 0;
                mfactor = 2 * mfactor;
                --nretries;
                continue;
            }
            if (numTriesSame >= this.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$conf().subseqTries() && this.timeoutExpired(startTime, timeout) || this.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$numExecutors().isEmpty() && currentWorkers == expectedWorkers || this.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$numExecutors().isDefined() && BoxesRunTime.unboxToInt((Object)this.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$numExecutors().get()) == currentWorkers) {
                this.logInfo((Function0<String>)new Serializable(this, expectedWorkers, currentWorkers){
                    public static final long serialVersionUID = 0L;
                    private final int expectedWorkers$1;
                    private final int currentWorkers$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected ", " spark executors for ", " H2O workers!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.currentWorkers$1), BoxesRunTime.boxToInteger((int)this.expectedWorkers$1)}));
                    }
                    {
                        this.expectedWorkers$1 = expectedWorkers$1;
                        this.currentWorkers$1 = currentWorkers$1;
                    }
                });
                return endpoints;
            }
            this.logInfo((Function0<String>)new Serializable(this, expectedWorkers, currentWorkers){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SpreadRDDBuilder $outer;
                private final int expectedWorkers$1;
                private final int currentWorkers$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected ", " spark executors for ", " H2O workers, backend#isReady=", "! Retrying again..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.currentWorkers$1), BoxesRunTime.boxToInteger((int)this.expectedWorkers$1), BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$isBackendReady())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.expectedWorkers$1 = expectedWorkers$1;
                    this.currentWorkers$1 = currentWorkers$1;
                }
            });
            ++numTriesSame;
            --nretries;
        }
    }

    private boolean timeoutExpired(long startTime, int timeout) {
        return System.currentTimeMillis() - startTime > (long)timeout;
    }

    private int numOfSparkExecutors() {
        int n2;
        if (this.isLocal()) {
            n2 = 1;
        } else {
            int n3;
            SchedulerBackend sb = this.sc().schedulerBackend();
            SchedulerBackend schedulerBackend = sb;
            if (schedulerBackend instanceof LocalSchedulerBackend) {
                n3 = 1;
            } else if (schedulerBackend instanceof CoarseGrainedSchedulerBackend) {
                CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = (CoarseGrainedSchedulerBackend)schedulerBackend;
                n3 = coarseGrainedSchedulerBackend.getExecutorIds().length();
            } else {
                n3 = SparkEnv$.MODULE$.get().blockManager().master().getStorageStatus().length - 1;
            }
            n2 = n3;
        }
        return n2;
    }

    public boolean org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$isBackendReady() {
        return this.sc().schedulerBackend().isReady();
    }

    public SpreadRDDBuilder(H2OContext hc2, Option<Object> numExecutorHint) {
        this.hc = hc2;
        this.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$numExecutorHint = numExecutorHint;
        Logging.class.$init$((Logging)this);
        this.sc = hc2.sparkContext();
        this.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$conf = hc2.getConf();
        this.isLocal = this.sc().isLocal();
        this.sparkConf = this.sc().conf();
        this.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$numExecutors = this.org$apache$spark$h2o$backends$internal$SpreadRDDBuilder$$conf().numH2OWorkers();
    }
}

