/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.FromPointerBuilder;
import org.capnproto.FromPointerBuilderBlobDefault;
import org.capnproto.FromPointerBuilderRefDefault;
import org.capnproto.SegmentBuilder;
import org.capnproto.SegmentReader;
import org.capnproto.SetPointerBuilder;
import org.capnproto.StructSize;
import org.capnproto.WireHelpers;

public class StructBuilder {
    protected final SegmentBuilder segment;
    protected final int data;
    protected final int pointers;
    protected final int dataSize;
    protected final short pointerCount;

    public StructBuilder(SegmentBuilder segmentBuilder, int n2, int n3, int n4, short s2) {
        this.segment = segmentBuilder;
        this.data = n2;
        this.pointers = n3;
        this.dataSize = n4;
        this.pointerCount = s2;
    }

    protected final boolean _getBooleanField(int n2) {
        int n3 = n2;
        int n4 = this.data + n3 / 8;
        return (this.segment.buffer.get(n4) & 1 << n3 % 8) != 0;
    }

    protected final boolean _getBooleanField(int n2, boolean bl) {
        return this._getBooleanField(n2) ^ bl;
    }

    protected final void _setBooleanField(int n2, boolean bl) {
        int n3 = n2;
        byte by2 = (byte)(n3 % 8);
        int n4 = this.data + n3 / 8;
        byte by3 = this.segment.buffer.get(n4);
        this.segment.buffer.put(n4, (byte)(by3 & ~(1 << by2) | (bl ? (byte)1 : 0) << by2));
    }

    protected final void _setBooleanField(int n2, boolean bl, boolean bl2) {
        this._setBooleanField(n2, bl ^ bl2);
    }

    protected final byte _getByteField(int n2) {
        return this.segment.buffer.get(this.data + n2);
    }

    protected final byte _getByteField(int n2, byte by2) {
        return (byte)(this._getByteField(n2) ^ by2);
    }

    protected final void _setByteField(int n2, byte by2) {
        this.segment.buffer.put(this.data + n2, by2);
    }

    protected final void _setByteField(int n2, byte by2, byte by3) {
        this._setByteField(n2, (byte)(by2 ^ by3));
    }

    protected final short _getShortField(int n2) {
        return this.segment.buffer.getShort(this.data + n2 * 2);
    }

    protected final short _getShortField(int n2, short s2) {
        return (short)(this._getShortField(n2) ^ s2);
    }

    protected final void _setShortField(int n2, short s2) {
        this.segment.buffer.putShort(this.data + n2 * 2, s2);
    }

    protected final void _setShortField(int n2, short s2, short s3) {
        this._setShortField(n2, (short)(s2 ^ s3));
    }

    protected final int _getIntField(int n2) {
        return this.segment.buffer.getInt(this.data + n2 * 4);
    }

    protected final int _getIntField(int n2, int n3) {
        return this._getIntField(n2) ^ n3;
    }

    protected final void _setIntField(int n2, int n3) {
        this.segment.buffer.putInt(this.data + n2 * 4, n3);
    }

    protected final void _setIntField(int n2, int n3, int n4) {
        this._setIntField(n2, n3 ^ n4);
    }

    protected final long _getLongField(int n2) {
        return this.segment.buffer.getLong(this.data + n2 * 8);
    }

    protected final long _getLongField(int n2, long l2) {
        return this._getLongField(n2) ^ l2;
    }

    protected final void _setLongField(int n2, long l2) {
        this.segment.buffer.putLong(this.data + n2 * 8, l2);
    }

    protected final void _setLongField(int n2, long l2, long l3) {
        this._setLongField(n2, l2 ^ l3);
    }

    protected final float _getFloatField(int n2) {
        return this.segment.buffer.getFloat(this.data + n2 * 4);
    }

    protected final float _getFloatField(int n2, int n3) {
        return Float.intBitsToFloat(this.segment.buffer.getInt(this.data + n2 * 4) ^ n3);
    }

    protected final void _setFloatField(int n2, float f2) {
        this.segment.buffer.putFloat(this.data + n2 * 4, f2);
    }

    protected final void _setFloatField(int n2, float f2, int n3) {
        this.segment.buffer.putInt(this.data + n2 * 4, Float.floatToIntBits(f2) ^ n3);
    }

    protected final double _getDoubleField(int n2) {
        return this.segment.buffer.getDouble(this.data + n2 * 8);
    }

    protected final double _getDoubleField(int n2, long l2) {
        return Double.longBitsToDouble(this.segment.buffer.getLong(this.data + n2 * 8) ^ l2);
    }

    protected final void _setDoubleField(int n2, double d2) {
        this.segment.buffer.putDouble(this.data + n2 * 8, d2);
    }

    protected final void _setDoubleField(int n2, double d2, long l2) {
        this.segment.buffer.putLong(this.data + n2 * 8, Double.doubleToLongBits(d2) ^ l2);
    }

    protected final boolean _pointerFieldIsNull(int n2) {
        return n2 >= this.pointerCount || this.segment.buffer.getLong((this.pointers + n2) * 8) == 0L;
    }

    protected final void _clearPointerField(int n2) {
        int n3 = this.pointers + n2;
        WireHelpers.zeroObject(this.segment, n3);
        this.segment.buffer.putLong(n3 * 8, 0L);
    }

    protected final <T> T _getPointerField(FromPointerBuilder<T> fromPointerBuilder, int n2) {
        return fromPointerBuilder.fromPointerBuilder(this.segment, this.pointers + n2);
    }

    protected final <T> T _getPointerField(FromPointerBuilderRefDefault<T> fromPointerBuilderRefDefault, int n2, SegmentReader segmentReader, int n3) {
        return fromPointerBuilderRefDefault.fromPointerBuilderRefDefault(this.segment, this.pointers + n2, segmentReader, n3);
    }

    protected final <T> T _getPointerField(FromPointerBuilderBlobDefault<T> fromPointerBuilderBlobDefault, int n2, ByteBuffer byteBuffer, int n3, int n4) {
        return fromPointerBuilderBlobDefault.fromPointerBuilderBlobDefault(this.segment, this.pointers + n2, byteBuffer, n3, n4);
    }

    protected final <T> T _initPointerField(FromPointerBuilder<T> fromPointerBuilder, int n2, int n3) {
        return fromPointerBuilder.initFromPointerBuilder(this.segment, this.pointers + n2, n3);
    }

    protected final <Builder, Reader> void _setPointerField(SetPointerBuilder<Builder, Reader> setPointerBuilder, int n2, Reader Reader2) {
        setPointerBuilder.setPointerBuilder(this.segment, this.pointers + n2, Reader2);
    }

    public static interface Factory<T> {
        public T constructBuilder(SegmentBuilder var1, int var2, int var3, int var4, short var5);

        public StructSize structSize();
    }
}

