/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.BuilderArena;
import org.capnproto.Data;
import org.capnproto.DecodeException;
import org.capnproto.ElementSize;
import org.capnproto.FarPointer;
import org.capnproto.ListBuilder;
import org.capnproto.ListPointer;
import org.capnproto.ListReader;
import org.capnproto.SegmentBuilder;
import org.capnproto.SegmentReader;
import org.capnproto.StructBuilder;
import org.capnproto.StructPointer;
import org.capnproto.StructReader;
import org.capnproto.StructSize;
import org.capnproto.Text;
import org.capnproto.WirePointer;

final class WireHelpers {
    WireHelpers() {
    }

    static int roundBytesUpToWords(int n2) {
        return (n2 + 7) / 8;
    }

    static int roundBitsUpToBytes(int n2) {
        return (n2 + 7) / 8;
    }

    static int roundBitsUpToWords(long l2) {
        return (int)((l2 + 63L) / 64L);
    }

    static AllocateResult allocate(int n2, SegmentBuilder segmentBuilder, int n3, byte by2) {
        long l2 = segmentBuilder.get(n2);
        if (!WirePointer.isNull(l2)) {
            WireHelpers.zeroObject(segmentBuilder, n2);
        }
        if (n3 == 0 && by2 == 0) {
            WirePointer.setKindAndTargetForEmptyStruct(segmentBuilder.buffer, n2);
            return new AllocateResult(n2, n2, segmentBuilder);
        }
        int n4 = segmentBuilder.allocate(n3);
        if (n4 == -1) {
            int n5 = n3 + 1;
            BuilderArena.AllocateResult allocateResult = segmentBuilder.getArena().allocate(n5);
            FarPointer.set(segmentBuilder.buffer, n2, false, allocateResult.offset);
            FarPointer.setSegmentId(segmentBuilder.buffer, n2, allocateResult.segment.id);
            int n6 = allocateResult.offset;
            int n7 = allocateResult.offset + 1;
            WirePointer.setKindAndTarget(allocateResult.segment.buffer, n6, by2, n7);
            return new AllocateResult(n7, n6, allocateResult.segment);
        }
        WirePointer.setKindAndTarget(segmentBuilder.buffer, n2, by2, n4);
        return new AllocateResult(n4, n2, segmentBuilder);
    }

    static FollowBuilderFarsResult followBuilderFars(long l2, int n2, SegmentBuilder segmentBuilder) {
        if (WirePointer.kind(l2) == 2) {
            SegmentBuilder segmentBuilder2 = segmentBuilder.getArena().getSegment(FarPointer.getSegmentId(l2));
            int n3 = FarPointer.positionInSegment(l2);
            long l3 = segmentBuilder2.get(n3);
            if (!FarPointer.isDoubleFar(l2)) {
                return new FollowBuilderFarsResult(WirePointer.target(n3, l3), l3, segmentBuilder2);
            }
            int n4 = n3 + 1;
            l2 = segmentBuilder2.get(n4);
            segmentBuilder2 = segmentBuilder2.getArena().getSegment(FarPointer.getSegmentId(l3));
            return new FollowBuilderFarsResult(FarPointer.positionInSegment(l3), l2, segmentBuilder2);
        }
        return new FollowBuilderFarsResult(n2, l2, segmentBuilder);
    }

    static FollowFarsResult followFars(long l2, int n2, SegmentReader segmentReader) {
        if (segmentReader != null && WirePointer.kind(l2) == 2) {
            int n3;
            SegmentReader segmentReader2 = segmentReader.arena.tryGetSegment(FarPointer.getSegmentId(l2));
            int n4 = FarPointer.positionInSegment(l2);
            long l3 = segmentReader2.get(n4);
            int n5 = n3 = FarPointer.isDoubleFar(l2) ? 2 : 1;
            if (!FarPointer.isDoubleFar(l2)) {
                return new FollowFarsResult(WirePointer.target(n4, l3), l3, segmentReader2);
            }
            long l4 = segmentReader2.get(n4 + 1);
            segmentReader2 = segmentReader2.arena.tryGetSegment(FarPointer.getSegmentId(l3));
            return new FollowFarsResult(FarPointer.positionInSegment(l3), l4, segmentReader2);
        }
        return new FollowFarsResult(n2, l2, segmentReader);
    }

    static void zeroObject(SegmentBuilder segmentBuilder, int n2) {
        if (!segmentBuilder.isWritable()) {
            return;
        }
        long l2 = segmentBuilder.get(n2);
        switch (WirePointer.kind(l2)) {
            case 0: 
            case 1: {
                WireHelpers.zeroObject(segmentBuilder, l2, WirePointer.target(n2, l2));
                break;
            }
            case 2: {
                segmentBuilder = segmentBuilder.getArena().getSegment(FarPointer.getSegmentId(l2));
                if (!segmentBuilder.isWritable()) break;
                int n3 = FarPointer.positionInSegment(l2);
                long l3 = segmentBuilder.get(n3);
                if (FarPointer.isDoubleFar(l2)) {
                    SegmentBuilder segmentBuilder2 = segmentBuilder.getArena().getSegment(FarPointer.getSegmentId(l2));
                    if (segmentBuilder2.isWritable()) {
                        WireHelpers.zeroObject(segmentBuilder2, n3 + 1, FarPointer.positionInSegment(l3));
                    }
                    segmentBuilder.buffer.putLong(n3 * 8, 0L);
                    segmentBuilder.buffer.putLong((n3 + 1) * 8, 0L);
                    break;
                }
                WireHelpers.zeroObject(segmentBuilder, n3);
                segmentBuilder.buffer.putLong(n3 * 8, 0L);
                break;
            }
        }
    }

    static void zeroObject(SegmentBuilder segmentBuilder, long l2, int n2) {
        if (!segmentBuilder.isWritable()) {
            return;
        }
        block0 : switch (WirePointer.kind(l2)) {
            case 0: {
                int n3 = n2 + StructPointer.dataSize(l2);
                int n4 = StructPointer.ptrCount(l2);
                for (int i2 = 0; i2 < n4; ++i2) {
                    WireHelpers.zeroObject(segmentBuilder, n3 + i2);
                }
                WireHelpers.memset(segmentBuilder.buffer, n2 * 8, (byte)0, StructPointer.wordSize(l2) * 8);
                break;
            }
            case 1: {
                switch (ListPointer.elementSize(l2)) {
                    case 0: {
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        WireHelpers.memset(segmentBuilder.buffer, n2 * 8, (byte)0, WireHelpers.roundBitsUpToWords(ListPointer.elementCount(l2) * ElementSize.dataBitsPerElement(ListPointer.elementSize(l2))) * 8);
                        break block0;
                    }
                    case 6: {
                        int n5 = ListPointer.elementCount(l2);
                        for (int i3 = 0; i3 < n5; ++i3) {
                            WireHelpers.zeroObject(segmentBuilder, n2 + i3);
                        }
                        WireHelpers.memset(segmentBuilder.buffer, n2 * 8, (byte)0, n5 * 8);
                        break block0;
                    }
                    case 7: {
                        long l3 = segmentBuilder.get(n2);
                        if (WirePointer.kind(l3) != 0) {
                            throw new Error("Don't know how to handle non-STRUCT inline composite.");
                        }
                        short s2 = StructPointer.dataSize(l3);
                        int n6 = StructPointer.ptrCount(l3);
                        int n7 = n2 + 1;
                        int n8 = WirePointer.inlineCompositeListElementCount(l3);
                        for (int i4 = 0; i4 < n8; ++i4) {
                            n7 += s2;
                            for (int i5 = 0; i5 < n6; ++i5) {
                                WireHelpers.zeroObject(segmentBuilder, n7);
                                ++n7;
                            }
                        }
                        WireHelpers.memset(segmentBuilder.buffer, n2 * 8, (byte)0, (StructPointer.wordSize(l3) * n8 + 1) * 8);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                throw new Error("Unexpected FAR pointer.");
            }
            case 3: {
                throw new Error("Unexpected OTHER pointer.");
            }
        }
    }

    static void zeroPointerAndFars(SegmentBuilder segmentBuilder, int n2) {
        SegmentBuilder segmentBuilder2;
        long l2 = segmentBuilder.get(n2);
        if (WirePointer.kind(l2) == 2 && (segmentBuilder2 = segmentBuilder.getArena().getSegment(FarPointer.getSegmentId(l2))).isWritable()) {
            int n3 = FarPointer.positionInSegment(l2);
            segmentBuilder2.buffer.putLong(n3 * 8, 0L);
            if (FarPointer.isDoubleFar(l2)) {
                segmentBuilder2.buffer.putLong(n3 * 8 + 1, 0L);
            }
        }
        segmentBuilder.put(n2, 0L);
    }

    static void transferPointer(SegmentBuilder segmentBuilder, int n2, SegmentBuilder segmentBuilder2, int n3) {
        long l2 = segmentBuilder2.get(n3);
        if (WirePointer.isNull(l2)) {
            segmentBuilder.put(n2, 0L);
        } else if (WirePointer.kind(l2) == 2) {
            segmentBuilder.put(n2, segmentBuilder2.get(n3));
        } else {
            WireHelpers.transferPointer(segmentBuilder, n2, segmentBuilder2, n3, WirePointer.target(n3, l2));
        }
    }

    static void transferPointer(SegmentBuilder segmentBuilder, int n2, SegmentBuilder segmentBuilder2, int n3, int n4) {
        long l2 = segmentBuilder2.get(n3);
        long l3 = segmentBuilder2.get(n4);
        if (segmentBuilder == segmentBuilder2) {
            if (WirePointer.kind(l2) == 0 && StructPointer.wordSize(l2) == 0) {
                WirePointer.setKindAndTargetForEmptyStruct(segmentBuilder.buffer, n2);
            } else {
                WirePointer.setKindAndTarget(segmentBuilder.buffer, n2, WirePointer.kind(l2), n4);
            }
            segmentBuilder.buffer.putInt(n2 * 8 + 4, segmentBuilder2.buffer.getInt(n3 * 8 + 4));
        } else {
            int n5 = segmentBuilder2.allocate(1);
            if (n5 == -1) {
                BuilderArena.AllocateResult allocateResult = segmentBuilder2.getArena().allocate(2);
                SegmentBuilder segmentBuilder3 = allocateResult.segment;
                n5 = allocateResult.offset;
                FarPointer.set(segmentBuilder3.buffer, n5, false, n4);
                FarPointer.setSegmentId(segmentBuilder3.buffer, n5, segmentBuilder2.id);
                WirePointer.setKindWithZeroOffset(segmentBuilder3.buffer, n5 + 1, WirePointer.kind(l2));
                segmentBuilder3.buffer.putInt((n5 + 1) * 8 + 4, segmentBuilder2.buffer.getInt(n3 * 8 + 4));
                FarPointer.set(segmentBuilder.buffer, n2, true, n5);
                FarPointer.setSegmentId(segmentBuilder.buffer, n2, segmentBuilder3.id);
            } else {
                WirePointer.setKindAndTarget(segmentBuilder2.buffer, n5, WirePointer.kind(l3), n4);
                segmentBuilder2.buffer.putInt(n5 * 8 + 4, segmentBuilder2.buffer.getInt(n3 * 8 + 4));
                FarPointer.set(segmentBuilder.buffer, n2, false, n5);
                FarPointer.setSegmentId(segmentBuilder.buffer, n2, segmentBuilder2.id);
            }
        }
    }

    static <T> T initStructPointer(StructBuilder.Factory<T> factory, int n2, SegmentBuilder segmentBuilder, StructSize structSize) {
        AllocateResult allocateResult = WireHelpers.allocate(n2, segmentBuilder, structSize.total(), (byte)0);
        StructPointer.setFromStructSize(allocateResult.segment.buffer, allocateResult.refOffset, structSize);
        return factory.constructBuilder(allocateResult.segment, allocateResult.ptr * 8, allocateResult.ptr + structSize.data, structSize.data * 64, structSize.pointers);
    }

    static <T> T getWritableStructPointer(StructBuilder.Factory<T> factory, int n2, SegmentBuilder segmentBuilder, StructSize structSize, SegmentReader segmentReader, int n3) {
        long l2 = segmentBuilder.get(n2);
        int n4 = WirePointer.target(n2, l2);
        if (WirePointer.isNull(l2)) {
            if (segmentReader == null) {
                return WireHelpers.initStructPointer(factory, n2, segmentBuilder, structSize);
            }
            throw new Error("unimplemented");
        }
        FollowBuilderFarsResult followBuilderFarsResult = WireHelpers.followBuilderFars(l2, n4, segmentBuilder);
        short s2 = StructPointer.dataSize(followBuilderFarsResult.ref);
        int n5 = StructPointer.ptrCount(followBuilderFarsResult.ref);
        int n6 = followBuilderFarsResult.ptr + s2;
        if (s2 < structSize.data || n5 < structSize.pointers) {
            short s3 = (short)Math.max(s2, structSize.data);
            short s4 = (short)Math.max(n5, structSize.pointers);
            int n7 = s3 + s4 * 1;
            WireHelpers.zeroPointerAndFars(segmentBuilder, n2);
            AllocateResult allocateResult = WireHelpers.allocate(n2, segmentBuilder, n7, (byte)0);
            StructPointer.set(allocateResult.segment.buffer, allocateResult.refOffset, s3, s4);
            WireHelpers.memcpy(allocateResult.segment.buffer, allocateResult.ptr * 8, followBuilderFarsResult.segment.buffer, followBuilderFarsResult.ptr * 8, s2 * 8);
            int n8 = allocateResult.ptr + s3;
            for (int i2 = 0; i2 < n5; ++i2) {
                WireHelpers.transferPointer(allocateResult.segment, n8 + i2, followBuilderFarsResult.segment, n6 + i2);
            }
            WireHelpers.memset(followBuilderFarsResult.segment.buffer, followBuilderFarsResult.ptr * 8, (byte)0, (s2 + n5 * 1) * 8);
            return factory.constructBuilder(allocateResult.segment, allocateResult.ptr * 8, n8, s3 * 64, s4);
        }
        return factory.constructBuilder(followBuilderFarsResult.segment, followBuilderFarsResult.ptr * 8, n6, s2 * 64, (short)n5);
    }

    static <T> T initListPointer(ListBuilder.Factory<T> factory, int n2, SegmentBuilder segmentBuilder, int n3, byte by2) {
        assert (by2 != 7) : "Should have called initStructListPointer instead";
        int n4 = ElementSize.dataBitsPerElement(by2);
        short s2 = ElementSize.pointersPerElement(by2);
        int n5 = n4 + s2 * 64;
        int n6 = WireHelpers.roundBitsUpToWords((long)n3 * (long)n5);
        AllocateResult allocateResult = WireHelpers.allocate(n2, segmentBuilder, n6, (byte)1);
        ListPointer.set(allocateResult.segment.buffer, allocateResult.refOffset, by2, n3);
        return factory.constructBuilder(allocateResult.segment, allocateResult.ptr * 8, n3, n5, n4, s2);
    }

    static <T> T initStructListPointer(ListBuilder.Factory<T> factory, int n2, SegmentBuilder segmentBuilder, int n3, StructSize structSize) {
        int n4 = structSize.total();
        int n5 = n3 * n4;
        AllocateResult allocateResult = WireHelpers.allocate(n2, segmentBuilder, 1 + n5, (byte)1);
        ListPointer.setInlineComposite(allocateResult.segment.buffer, allocateResult.refOffset, n5);
        WirePointer.setKindAndInlineCompositeListElementCount(allocateResult.segment.buffer, allocateResult.ptr, (byte)0, n3);
        StructPointer.setFromStructSize(allocateResult.segment.buffer, allocateResult.ptr, structSize);
        return factory.constructBuilder(allocateResult.segment, (allocateResult.ptr + 1) * 8, n3, n4 * 64, structSize.data * 64, structSize.pointers);
    }

    static <T> T getWritableListPointer(ListBuilder.Factory<T> factory, int n2, SegmentBuilder segmentBuilder, byte by2, SegmentReader segmentReader, int n3) {
        assert (by2 != 7) : "Use getWritableStructListPointer() for struct lists";
        long l2 = segmentBuilder.get(n2);
        int n4 = WirePointer.target(n2, l2);
        if (WirePointer.isNull(l2)) {
            throw new Error("unimplemented");
        }
        FollowBuilderFarsResult followBuilderFarsResult = WireHelpers.followBuilderFars(l2, n4, segmentBuilder);
        if (WirePointer.kind(followBuilderFarsResult.ref) != 1) {
            throw new DecodeException("Called getList{Field,Element}() but existing pointer is not a list");
        }
        byte by3 = ListPointer.elementSize(followBuilderFarsResult.ref);
        if (by3 == 7) {
            throw new Error("unimplemented");
        }
        int n5 = ElementSize.dataBitsPerElement(by3);
        short s2 = ElementSize.pointersPerElement(by3);
        if (n5 < ElementSize.dataBitsPerElement(by2)) {
            throw new DecodeException("Existing list value is incompatible with expected type.");
        }
        if (s2 < ElementSize.pointersPerElement(by2)) {
            throw new DecodeException("Existing list value is incompatible with expected type.");
        }
        int n6 = n5 + s2 * 64;
        return factory.constructBuilder(followBuilderFarsResult.segment, followBuilderFarsResult.ptr * 8, ListPointer.elementCount(followBuilderFarsResult.ref), n6, n5, s2);
    }

    static <T> T getWritableStructListPointer(ListBuilder.Factory<T> factory, int n2, SegmentBuilder segmentBuilder, StructSize structSize, SegmentReader segmentReader, int n3) {
        long l2 = segmentBuilder.get(n2);
        int n4 = WirePointer.target(n2, l2);
        if (WirePointer.isNull(l2)) {
            throw new Error("unimplemented");
        }
        FollowBuilderFarsResult followBuilderFarsResult = WireHelpers.followBuilderFars(l2, n4, segmentBuilder);
        if (WirePointer.kind(followBuilderFarsResult.ref) != 1) {
            throw new DecodeException("Called getList{Field,Element}() but existing pointer is not a list");
        }
        byte by2 = ListPointer.elementSize(followBuilderFarsResult.ref);
        if (by2 == 7) {
            long l3 = followBuilderFarsResult.segment.get(followBuilderFarsResult.ptr);
            int n5 = followBuilderFarsResult.ptr + 1;
            if (WirePointer.kind(l3) != 0) {
                throw new DecodeException("INLINE_COMPOSITE list with non-STRUCT elements not supported.");
            }
            short s2 = StructPointer.dataSize(l3);
            int n6 = StructPointer.ptrCount(l3);
            int n7 = s2 + n6 * 1;
            int n8 = WirePointer.inlineCompositeListElementCount(l3);
            if (s2 >= structSize.data && n6 >= structSize.pointers) {
                return factory.constructBuilder(followBuilderFarsResult.segment, n5 * 8, n8, n7 * 64, s2 * 64, (short)n6);
            }
            short s3 = (short)Math.max(s2, structSize.data);
            short s4 = (short)Math.max(n6, structSize.pointers);
            int n9 = s3 + s4 * 1;
            int n10 = n9 * n8;
            WireHelpers.zeroPointerAndFars(segmentBuilder, n2);
            AllocateResult allocateResult = WireHelpers.allocate(n2, segmentBuilder, n10 + 1, (byte)1);
            ListPointer.setInlineComposite(allocateResult.segment.buffer, allocateResult.refOffset, n10);
            long l4 = allocateResult.segment.get(allocateResult.ptr);
            WirePointer.setKindAndInlineCompositeListElementCount(allocateResult.segment.buffer, allocateResult.ptr, (byte)0, n8);
            StructPointer.set(allocateResult.segment.buffer, allocateResult.ptr, s3, s4);
            int n11 = allocateResult.ptr + 1;
            int n12 = n5;
            int n13 = n11;
            for (int i2 = 0; i2 < n8; ++i2) {
                WireHelpers.memcpy(allocateResult.segment.buffer, n13 * 8, followBuilderFarsResult.segment.buffer, n12 * 8, s2 * 8);
                int n14 = n13 + s3;
                int n15 = n12 + s2;
                for (int i3 = 0; i3 < n6; ++i3) {
                    WireHelpers.transferPointer(allocateResult.segment, n14 + i3, followBuilderFarsResult.segment, n15 + i3);
                }
                n13 += n9;
                n12 += n7;
            }
            WireHelpers.memset(followBuilderFarsResult.segment.buffer, followBuilderFarsResult.ptr * 8, (byte)0, (1 + n7 * n8) * 8);
            return factory.constructBuilder(allocateResult.segment, n11 * 8, n8, n9 * 64, s3 * 64, s4);
        }
        int n16 = ElementSize.dataBitsPerElement(by2);
        short s5 = ElementSize.pointersPerElement(by2);
        int n17 = n16 + s5 * 64;
        int n18 = ListPointer.elementCount(l2);
        if (by2 == 0) {
            return WireHelpers.initStructListPointer(factory, n2, segmentBuilder, n18, structSize);
        }
        if (by2 == 1) {
            throw new Error("Found bit list where struct list was expected; upgrading boolean lists to struct is no longer supported.");
        }
        short s6 = structSize.data;
        short s7 = structSize.pointers;
        if (by2 == 6) {
            s7 = (short)Math.max(s7, 1);
        } else {
            s6 = (short)Math.max(s6, 1);
        }
        int n19 = s6 + s7 * 1;
        int n20 = n18 * n19;
        WireHelpers.zeroPointerAndFars(segmentBuilder, n2);
        AllocateResult allocateResult = WireHelpers.allocate(n2, segmentBuilder, n20 + 1, (byte)1);
        ListPointer.setInlineComposite(allocateResult.segment.buffer, allocateResult.refOffset, n20);
        long l5 = allocateResult.segment.get(allocateResult.ptr);
        WirePointer.setKindAndInlineCompositeListElementCount(allocateResult.segment.buffer, allocateResult.ptr, (byte)0, n18);
        StructPointer.set(allocateResult.segment.buffer, allocateResult.ptr, s6, s7);
        int n21 = allocateResult.ptr + 1;
        if (by2 == 6) {
            int n22 = n21 + s6;
            int n23 = followBuilderFarsResult.ptr;
            for (int i4 = 0; i4 < n18; ++i4) {
                WireHelpers.transferPointer(segmentBuilder, n22, followBuilderFarsResult.segment, n23);
                n22 += n19 / 1;
                ++n23;
            }
        } else {
            int n24 = n21;
            int n25 = followBuilderFarsResult.ptr * 8;
            int n26 = n16 / 8;
            for (int i5 = 0; i5 < n18; ++i5) {
                WireHelpers.memcpy(allocateResult.segment.buffer, n24 * 8, followBuilderFarsResult.segment.buffer, n25, n26);
                n25 += n26;
                n24 += n19;
            }
        }
        WireHelpers.memset(followBuilderFarsResult.segment.buffer, followBuilderFarsResult.ptr * 8, (byte)0, WireHelpers.roundBitsUpToBytes(n17 * n18));
        return factory.constructBuilder(allocateResult.segment, n21 * 8, n18, n19 * 64, s6 * 64, s7);
    }

    static Text.Builder initTextPointer(int n2, SegmentBuilder segmentBuilder, int n3) {
        int n4 = n3 + 1;
        AllocateResult allocateResult = WireHelpers.allocate(n2, segmentBuilder, WireHelpers.roundBytesUpToWords(n4), (byte)1);
        ListPointer.set(allocateResult.segment.buffer, allocateResult.refOffset, (byte)2, n4);
        return new Text.Builder(allocateResult.segment.buffer, allocateResult.ptr * 8, n3);
    }

    static Text.Builder setTextPointer(int n2, SegmentBuilder segmentBuilder, Text.Reader reader) {
        Text.Builder builder = WireHelpers.initTextPointer(n2, segmentBuilder, reader.size);
        ByteBuffer byteBuffer = reader.buffer.duplicate();
        byteBuffer.position(reader.offset);
        byteBuffer.limit(reader.offset + reader.size);
        builder.buffer.position(builder.offset);
        builder.buffer.put(byteBuffer);
        return builder;
    }

    static Text.Builder getWritableTextPointer(int n2, SegmentBuilder segmentBuilder, ByteBuffer byteBuffer, int n3, int n4) {
        long l2 = segmentBuilder.get(n2);
        if (WirePointer.isNull(l2)) {
            if (byteBuffer == null) {
                return new Text.Builder();
            }
            Text.Builder builder = WireHelpers.initTextPointer(n2, segmentBuilder, n4);
            for (int i2 = 0; i2 < builder.size; ++i2) {
                builder.buffer.put(builder.offset + i2, byteBuffer.get(n3 * 8 + i2));
            }
            return builder;
        }
        int n5 = WirePointer.target(n2, l2);
        FollowBuilderFarsResult followBuilderFarsResult = WireHelpers.followBuilderFars(l2, n5, segmentBuilder);
        if (WirePointer.kind(followBuilderFarsResult.ref) != 1) {
            throw new DecodeException("Called getText{Field,Element} but existing pointer is not a list.");
        }
        if (ListPointer.elementSize(followBuilderFarsResult.ref) != 2) {
            throw new DecodeException("Called getText{Field,Element} but existing list pointer is not byte-sized.");
        }
        int n6 = ListPointer.elementCount(followBuilderFarsResult.ref);
        if (n6 == 0 || followBuilderFarsResult.segment.buffer.get(followBuilderFarsResult.ptr * 8 + n6 - 1) != 0) {
            throw new DecodeException("Text blob missing NUL terminator.");
        }
        return new Text.Builder(followBuilderFarsResult.segment.buffer, followBuilderFarsResult.ptr * 8, n6 - 1);
    }

    static Data.Builder initDataPointer(int n2, SegmentBuilder segmentBuilder, int n3) {
        AllocateResult allocateResult = WireHelpers.allocate(n2, segmentBuilder, WireHelpers.roundBytesUpToWords(n3), (byte)1);
        ListPointer.set(allocateResult.segment.buffer, allocateResult.refOffset, (byte)2, n3);
        return new Data.Builder(allocateResult.segment.buffer, allocateResult.ptr * 8, n3);
    }

    static Data.Builder setDataPointer(int n2, SegmentBuilder segmentBuilder, Data.Reader reader) {
        Data.Builder builder = WireHelpers.initDataPointer(n2, segmentBuilder, reader.size);
        for (int i2 = 0; i2 < builder.size; ++i2) {
            builder.buffer.put(builder.offset + i2, reader.buffer.get(reader.offset + i2));
        }
        return builder;
    }

    static Data.Builder getWritableDataPointer(int n2, SegmentBuilder segmentBuilder, ByteBuffer byteBuffer, int n3, int n4) {
        long l2 = segmentBuilder.get(n2);
        if (WirePointer.isNull(l2)) {
            if (byteBuffer == null) {
                return new Data.Builder();
            }
            Data.Builder builder = WireHelpers.initDataPointer(n2, segmentBuilder, n4);
            for (int i2 = 0; i2 < builder.size; ++i2) {
                builder.buffer.put(builder.offset + i2, byteBuffer.get(n3 * 8 + i2));
            }
            return builder;
        }
        int n5 = WirePointer.target(n2, l2);
        FollowBuilderFarsResult followBuilderFarsResult = WireHelpers.followBuilderFars(l2, n5, segmentBuilder);
        if (WirePointer.kind(followBuilderFarsResult.ref) != 1) {
            throw new DecodeException("Called getData{Field,Element} but existing pointer is not a list.");
        }
        if (ListPointer.elementSize(followBuilderFarsResult.ref) != 2) {
            throw new DecodeException("Called getData{Field,Element} but existing list pointer is not byte-sized.");
        }
        return new Data.Builder(followBuilderFarsResult.segment.buffer, followBuilderFarsResult.ptr * 8, ListPointer.elementCount(followBuilderFarsResult.ref));
    }

    static <T> T readStructPointer(StructReader.Factory<T> factory, SegmentReader segmentReader, int n2, SegmentReader segmentReader2, int n3, int n4) {
        long l2 = segmentReader.get(n2);
        if (WirePointer.isNull(l2)) {
            if (segmentReader2 == null) {
                return factory.constructReader(SegmentReader.EMPTY, 0, 0, 0, (short)0, Integer.MAX_VALUE);
            }
            segmentReader = segmentReader2;
            n2 = n3;
            l2 = segmentReader.get(n2);
        }
        if (n4 <= 0) {
            throw new DecodeException("Message is too deeply nested or contains cycles.");
        }
        int n5 = WirePointer.target(n2, l2);
        FollowFarsResult followFarsResult = WireHelpers.followFars(l2, n5, segmentReader);
        short s2 = StructPointer.dataSize(followFarsResult.ref);
        if (WirePointer.kind(followFarsResult.ref) != 0) {
            throw new DecodeException("Message contains non-struct pointer where struct pointer was expected.");
        }
        followFarsResult.segment.arena.checkReadLimit(StructPointer.wordSize(followFarsResult.ref));
        return factory.constructReader(followFarsResult.segment, followFarsResult.ptr * 8, followFarsResult.ptr + s2, s2 * 64, StructPointer.ptrCount(followFarsResult.ref), n4 - 1);
    }

    static SegmentBuilder setStructPointer(SegmentBuilder segmentBuilder, int n2, StructReader structReader) {
        short s2 = (short)WireHelpers.roundBitsUpToWords(structReader.dataSize);
        int n3 = s2 + structReader.pointerCount * 1;
        AllocateResult allocateResult = WireHelpers.allocate(n2, segmentBuilder, n3, (byte)0);
        StructPointer.set(allocateResult.segment.buffer, allocateResult.refOffset, s2, structReader.pointerCount);
        if (structReader.dataSize == 1) {
            throw new Error("single bit case not handled");
        }
        WireHelpers.memcpy(allocateResult.segment.buffer, allocateResult.ptr * 8, structReader.segment.buffer, structReader.data, structReader.dataSize / 8);
        int n4 = allocateResult.ptr + s2;
        for (int i2 = 0; i2 < structReader.pointerCount; ++i2) {
            WireHelpers.copyPointer(allocateResult.segment, n4 + i2, structReader.segment, structReader.pointers + i2, structReader.nestingLimit);
        }
        return allocateResult.segment;
    }

    static SegmentBuilder setListPointer(SegmentBuilder segmentBuilder, int n2, ListReader listReader) {
        int n3 = WireHelpers.roundBitsUpToWords(listReader.elementCount * listReader.step);
        if (listReader.step <= 64) {
            AllocateResult allocateResult = WireHelpers.allocate(n2, segmentBuilder, n3, (byte)1);
            if (listReader.structPointerCount == 1) {
                ListPointer.set(allocateResult.segment.buffer, allocateResult.refOffset, (byte)6, listReader.elementCount);
                for (int i2 = 0; i2 < listReader.elementCount; ++i2) {
                    WireHelpers.copyPointer(allocateResult.segment, allocateResult.ptr + i2, listReader.segment, listReader.ptr / 8 + i2, listReader.nestingLimit);
                }
            } else {
                byte by2 = 0;
                switch (listReader.step) {
                    case 0: {
                        by2 = 0;
                        break;
                    }
                    case 1: {
                        by2 = 1;
                        break;
                    }
                    case 8: {
                        by2 = 2;
                        break;
                    }
                    case 16: {
                        by2 = 3;
                        break;
                    }
                    case 32: {
                        by2 = 4;
                        break;
                    }
                    case 64: {
                        by2 = 5;
                        break;
                    }
                    default: {
                        throw new Error("invalid list step size: " + listReader.step);
                    }
                }
                ListPointer.set(allocateResult.segment.buffer, allocateResult.refOffset, by2, listReader.elementCount);
                WireHelpers.memcpy(allocateResult.segment.buffer, allocateResult.ptr * 8, listReader.segment.buffer, listReader.ptr, n3 * 8);
            }
            return allocateResult.segment;
        }
        AllocateResult allocateResult = WireHelpers.allocate(n2, segmentBuilder, n3 + 1, (byte)1);
        ListPointer.setInlineComposite(allocateResult.segment.buffer, allocateResult.refOffset, n3);
        short s2 = (short)WireHelpers.roundBitsUpToWords(listReader.structDataSize);
        int n4 = listReader.structPointerCount;
        WirePointer.setKindAndInlineCompositeListElementCount(allocateResult.segment.buffer, allocateResult.ptr, (byte)0, listReader.elementCount);
        StructPointer.set(allocateResult.segment.buffer, allocateResult.ptr, s2, (short)n4);
        int n5 = allocateResult.ptr + 1;
        int n6 = listReader.ptr / 8;
        for (int i3 = 0; i3 < listReader.elementCount; ++i3) {
            WireHelpers.memcpy(allocateResult.segment.buffer, n5 * 8, listReader.segment.buffer, n6 * 8, listReader.structDataSize / 8);
            n5 += s2;
            n6 += s2;
            for (int i4 = 0; i4 < n4; ++i4) {
                WireHelpers.copyPointer(allocateResult.segment, n5, listReader.segment, n6, listReader.nestingLimit);
                ++n5;
                ++n6;
            }
        }
        return allocateResult.segment;
    }

    static void memset(ByteBuffer byteBuffer, int n2, byte by2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            byteBuffer.put(i2, by2);
        }
    }

    static void memcpy(ByteBuffer byteBuffer, int n2, ByteBuffer byteBuffer2, int n3, int n4) {
        ByteBuffer byteBuffer3 = byteBuffer.duplicate();
        byteBuffer3.position(n2);
        byteBuffer3.limit(n2 + n4);
        ByteBuffer byteBuffer4 = byteBuffer2.duplicate();
        byteBuffer4.position(n3);
        byteBuffer4.limit(n3 + n4);
        byteBuffer3.put(byteBuffer4);
    }

    static SegmentBuilder copyPointer(SegmentBuilder segmentBuilder, int n2, SegmentReader segmentReader, int n3, int n4) {
        long l2 = segmentReader.get(n3);
        if (WirePointer.isNull(l2)) {
            segmentBuilder.buffer.putLong(n2 * 8, 0L);
            return segmentBuilder;
        }
        int n5 = WirePointer.target(n3, l2);
        FollowFarsResult followFarsResult = WireHelpers.followFars(l2, n5, segmentReader);
        switch (WirePointer.kind(followFarsResult.ref)) {
            case 0: {
                if (n4 <= 0) {
                    throw new DecodeException("Message is too deeply nested or contains cycles. See org.capnproto.ReaderOptions.");
                }
                followFarsResult.segment.arena.checkReadLimit(StructPointer.wordSize(followFarsResult.ref));
                return WireHelpers.setStructPointer(segmentBuilder, n2, new StructReader(followFarsResult.segment, followFarsResult.ptr * 8, followFarsResult.ptr + StructPointer.dataSize(followFarsResult.ref), StructPointer.dataSize(followFarsResult.ref) * 64, StructPointer.ptrCount(followFarsResult.ref), n4 - 1));
            }
            case 1: {
                byte by2 = ListPointer.elementSize(followFarsResult.ref);
                if (n4 <= 0) {
                    throw new DecodeException("Message is too deeply nested or contains cycles. See org.capnproto.ReaderOptions.");
                }
                if (by2 == 7) {
                    int n6 = ListPointer.inlineCompositeWordCount(followFarsResult.ref);
                    long l3 = followFarsResult.segment.get(followFarsResult.ptr);
                    int n7 = followFarsResult.ptr + 1;
                    followFarsResult.segment.arena.checkReadLimit(n6 + 1);
                    if (WirePointer.kind(l3) != 0) {
                        throw new DecodeException("INLINE_COMPOSITE lists of non-STRUCT type are not supported.");
                    }
                    int n8 = WirePointer.inlineCompositeListElementCount(l3);
                    int n9 = StructPointer.wordSize(l3);
                    if ((long)n9 * (long)n8 > (long)n6) {
                        throw new DecodeException("INLINE_COMPOSITE list's elements overrun its word count.");
                    }
                    if (n9 == 0) {
                        followFarsResult.segment.arena.checkReadLimit(n8);
                    }
                    return WireHelpers.setListPointer(segmentBuilder, n2, new ListReader(followFarsResult.segment, n7 * 8, n8, n9 * 64, StructPointer.dataSize(l3) * 64, StructPointer.ptrCount(l3), n4 - 1));
                }
                int n10 = ElementSize.dataBitsPerElement(by2);
                short s2 = ElementSize.pointersPerElement(by2);
                int n11 = n10 + s2 * 64;
                int n12 = ListPointer.elementCount(followFarsResult.ref);
                int n13 = WireHelpers.roundBitsUpToWords((long)n12 * (long)n11);
                followFarsResult.segment.arena.checkReadLimit(n13);
                if (by2 == 0) {
                    followFarsResult.segment.arena.checkReadLimit(n12);
                }
                return WireHelpers.setListPointer(segmentBuilder, n2, new ListReader(followFarsResult.segment, followFarsResult.ptr * 8, n12, n11, n10, s2, n4 - 1));
            }
            case 2: {
                throw new DecodeException("Unexpected FAR pointer.");
            }
            case 3: {
                throw new Error("copyPointer is unimplemented for OTHER pointers");
            }
        }
        throw new Error("unreachable");
    }

    static <T> T readListPointer(ListReader.Factory<T> factory, SegmentReader segmentReader, int n2, SegmentReader segmentReader2, int n3, byte by2, int n4) {
        long l2 = segmentReader.get(n2);
        if (WirePointer.isNull(l2)) {
            if (segmentReader2 == null) {
                return factory.constructReader(SegmentReader.EMPTY, 0, 0, 0, 0, (short)0, Integer.MAX_VALUE);
            }
            segmentReader = segmentReader2;
            n2 = n3;
            l2 = segmentReader.get(n2);
        }
        if (n4 <= 0) {
            throw new Error("nesting limit exceeded");
        }
        int n5 = WirePointer.target(n2, l2);
        FollowFarsResult followFarsResult = WireHelpers.followFars(l2, n5, segmentReader);
        byte by3 = ListPointer.elementSize(followFarsResult.ref);
        switch (by3) {
            case 7: {
                int n6 = ListPointer.inlineCompositeWordCount(followFarsResult.ref);
                long l3 = followFarsResult.segment.get(followFarsResult.ptr);
                int n7 = followFarsResult.ptr + 1;
                followFarsResult.segment.arena.checkReadLimit(n6 + 1);
                int n8 = WirePointer.inlineCompositeListElementCount(l3);
                int n9 = StructPointer.wordSize(l3);
                if ((long)n8 * (long)n9 > (long)n6) {
                    throw new DecodeException("INLINE_COMPOSITE list's elements overrun its word count.");
                }
                if (n9 == 0) {
                    followFarsResult.segment.arena.checkReadLimit(n8);
                }
                return factory.constructReader(followFarsResult.segment, n7 * 8, n8, n9 * 64, StructPointer.dataSize(l3) * 64, StructPointer.ptrCount(l3), n4 - 1);
            }
        }
        int n10 = ElementSize.dataBitsPerElement(ListPointer.elementSize(followFarsResult.ref));
        short s2 = ElementSize.pointersPerElement(ListPointer.elementSize(followFarsResult.ref));
        int n11 = ListPointer.elementCount(followFarsResult.ref);
        int n12 = n10 + s2 * 64;
        followFarsResult.segment.arena.checkReadLimit(WireHelpers.roundBitsUpToWords(n11 * n12));
        if (by3 == 0) {
            followFarsResult.segment.arena.checkReadLimit(n11);
        }
        int n13 = ElementSize.dataBitsPerElement(by2);
        short s3 = ElementSize.pointersPerElement(by2);
        if (n13 > n10) {
            throw new DecodeException("Message contains list with incompatible element type.");
        }
        if (s3 > s2) {
            throw new DecodeException("Message contains list with incompatible element type.");
        }
        return factory.constructReader(followFarsResult.segment, followFarsResult.ptr * 8, ListPointer.elementCount(followFarsResult.ref), n12, n10, s2, n4 - 1);
    }

    static Text.Reader readTextPointer(SegmentReader segmentReader, int n2, ByteBuffer byteBuffer, int n3, int n4) {
        long l2 = segmentReader.get(n2);
        if (WirePointer.isNull(l2)) {
            if (byteBuffer == null) {
                return new Text.Reader();
            }
            return new Text.Reader(byteBuffer, n3, n4);
        }
        int n5 = WirePointer.target(n2, l2);
        FollowFarsResult followFarsResult = WireHelpers.followFars(l2, n5, segmentReader);
        int n6 = ListPointer.elementCount(followFarsResult.ref);
        if (WirePointer.kind(followFarsResult.ref) != 1) {
            throw new DecodeException("Message contains non-list pointer where text was expected.");
        }
        if (ListPointer.elementSize(followFarsResult.ref) != 2) {
            throw new DecodeException("Message contains list pointer of non-bytes where text was expected.");
        }
        followFarsResult.segment.arena.checkReadLimit(WireHelpers.roundBytesUpToWords(n6));
        if (n6 == 0 || followFarsResult.segment.buffer.get(8 * followFarsResult.ptr + n6 - 1) != 0) {
            throw new DecodeException("Message contains text that is not NUL-terminated.");
        }
        return new Text.Reader(followFarsResult.segment.buffer, followFarsResult.ptr, n6 - 1);
    }

    static Data.Reader readDataPointer(SegmentReader segmentReader, int n2, ByteBuffer byteBuffer, int n3, int n4) {
        long l2 = segmentReader.get(n2);
        if (WirePointer.isNull(l2)) {
            if (byteBuffer == null) {
                return new Data.Reader();
            }
            return new Data.Reader(byteBuffer, n3, n4);
        }
        int n5 = WirePointer.target(n2, l2);
        FollowFarsResult followFarsResult = WireHelpers.followFars(l2, n5, segmentReader);
        int n6 = ListPointer.elementCount(followFarsResult.ref);
        if (WirePointer.kind(followFarsResult.ref) != 1) {
            throw new DecodeException("Message contains non-list pointer where data was expected.");
        }
        if (ListPointer.elementSize(followFarsResult.ref) != 2) {
            throw new DecodeException("Message contains list pointer of non-bytes where data was expected.");
        }
        followFarsResult.segment.arena.checkReadLimit(WireHelpers.roundBytesUpToWords(n6));
        return new Data.Reader(followFarsResult.segment.buffer, followFarsResult.ptr, n6);
    }

    static class FollowFarsResult {
        public final int ptr;
        public final long ref;
        public final SegmentReader segment;

        FollowFarsResult(int n2, long l2, SegmentReader segmentReader) {
            this.ptr = n2;
            this.ref = l2;
            this.segment = segmentReader;
        }
    }

    static class FollowBuilderFarsResult {
        public final int ptr;
        public final long ref;
        public final SegmentBuilder segment;

        FollowBuilderFarsResult(int n2, long l2, SegmentBuilder segmentBuilder) {
            this.ptr = n2;
            this.ref = l2;
            this.segment = segmentBuilder;
        }
    }

    static class AllocateResult {
        public final int ptr;
        public final int refOffset;
        public final SegmentBuilder segment;

        AllocateResult(int n2, int n3, SegmentBuilder segmentBuilder) {
            this.ptr = n2;
            this.refOffset = n3;
            this.segment = segmentBuilder;
        }
    }
}

