/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest.httpclient;

import ai.h2o.org.apache.http.Header;
import ai.h2o.org.apache.http.HttpEntity;
import ai.h2o.org.apache.http.message.BasicHeader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.io.InputStreamWrapper;
import org.jets3t.service.io.ProgressMonitoredInputStream;
import org.jets3t.service.io.RepeatableInputStream;
import org.jets3t.service.utils.ServiceUtils;

public class RepeatableRequestEntity
implements HttpEntity {
    public static final int DEFAULT_BUFFER_SIZE = 131072;
    private static final Log log = LogFactory.getLog(RepeatableRequestEntity.class);
    private String name = null;
    private InputStream is = null;
    private String contentType = null;
    private long contentLength = 0L;
    private long bytesWritten = 0L;
    private InputStream repeatableInputStream = null;
    private ProgressMonitoredInputStream progressMonitoredIS = null;
    protected static long MAX_BYTES_PER_SECOND = 0L;
    private static volatile long bytesWrittenThisSecond = 0L;
    private static volatile long currentSecondMonitored = 0L;
    private static final Random random = new Random();
    private boolean isLiveMD5HashingEnabled = true;
    private byte[] dataMD5Hash = null;
    boolean consumed = false;
    protected Header mContentEncoding;
    protected boolean mChunked;

    public RepeatableRequestEntity(String name, InputStream is, String contentType, long contentLength, Jets3tProperties jets3tProperties, boolean enableLiveMD5Hashing) {
        int bufferSize;
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        this.is = is;
        this.name = name;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.isLiveMD5HashingEnabled = enableLiveMD5Hashing;
        InputStream inputStream = is;
        while (true) {
            if (inputStream instanceof ProgressMonitoredInputStream) {
                this.progressMonitoredIS = (ProgressMonitoredInputStream)inputStream;
            }
            if (inputStream.markSupported()) {
                this.repeatableInputStream = inputStream;
                bufferSize = -1;
                if (this.repeatableInputStream instanceof BufferedInputStream) {
                    bufferSize = jets3tProperties.getIntProperty("uploads.stream-retry-buffer-size", 131072);
                    log.debug((Object)("Setting conservative read-ahead mark limit for BufferedInputStream since it keeps read data in-memory and can cause memory starvation: " + bufferSize + " (from property 'uploads.stream-retry-buffer-size')"));
                } else {
                    bufferSize = (int)Math.min(contentLength, Integer.MAX_VALUE);
                    log.debug((Object)("Setting maximal read-ahead mark limit for markable input stream " + this.repeatableInputStream.getClass().getName() + " assuming it doesn't use in-memory storage: " + bufferSize));
                }
                this.repeatableInputStream.mark(bufferSize);
            }
            if (!(inputStream instanceof InputStreamWrapper)) break;
            inputStream = ((InputStreamWrapper)((Object)inputStream)).getWrappedInputStream();
        }
        if (this.repeatableInputStream == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Wrapping non-repeatable input stream in a RepeatableInputStream");
            }
            bufferSize = jets3tProperties.getIntProperty("uploads.stream-retry-buffer-size", 131072);
            this.repeatableInputStream = this.is = new RepeatableInputStream(is, bufferSize);
        }
        MAX_BYTES_PER_SECOND = 1024L * jets3tProperties.getLongProperty("httpclient.read-throttle", 0L);
    }

    public Header getContentEncoding() {
        return this.mContentEncoding;
    }

    public boolean isChunked() {
        return this.mChunked;
    }

    public InputStream getContent() {
        return this.is;
    }

    public void consumeContent() {
        this.consumed = true;
        try {
            this.is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isStreaming() {
        return !this.consumed;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public Header getContentType() {
        return new BasicHeader("Content-Type", this.contentType);
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeTo(OutputStream out) throws IOException {
        MessageDigest messageDigest;
        block9: {
            if (this.bytesWritten > 0L) {
                this.repeatableInputStream.reset();
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Repeating transmission of " + this.bytesWritten + " bytes"));
                }
                if (this.progressMonitoredIS != null) {
                    this.progressMonitoredIS.resetProgressMonitor();
                }
                this.bytesWritten = 0L;
            }
            messageDigest = null;
            if (this.isLiveMD5HashingEnabled) {
                try {
                    messageDigest = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e2) {
                    if (!log.isWarnEnabled()) break block9;
                    log.warn((Object)"Unable to calculate MD5 hash of data sent as algorithm is not available", (Throwable)e2);
                }
            }
        }
        byte[] tmp = new byte[131072];
        int count2 = 0;
        while ((count2 = this.is.read(tmp)) >= 0) {
            RepeatableRequestEntity.throttle(count2);
            this.bytesWritten += (long)count2;
            out.write(tmp, 0, count2);
            if (messageDigest == null) continue;
            messageDigest.update(tmp, 0, count2);
        }
        if (messageDigest != null) {
            this.dataMD5Hash = messageDigest.digest();
            if (log.isDebugEnabled()) {
                log.debug((Object)("MD5 digest of data sent for '" + this.name + "' - B64:" + ServiceUtils.toBase64(this.dataMD5Hash) + " Hex:" + ServiceUtils.toHex(this.dataMD5Hash)));
            }
        }
    }

    public byte[] getMD5DigestOfData() {
        if (this.dataMD5Hash != null) {
            return this.dataMD5Hash;
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void throttle(int bytesToWrite) throws IOException {
        boolean willExceedThrottle;
        if (MAX_BYTES_PER_SECOND <= 0L) {
            return;
        }
        long currentSecond = System.currentTimeMillis() / 1000L;
        Random random = RepeatableRequestEntity.random;
        synchronized (random) {
            boolean isCurrentSecond = currentSecond == currentSecondMonitored;
            boolean bl = willExceedThrottle = isCurrentSecond && bytesWrittenThisSecond + (long)bytesToWrite > MAX_BYTES_PER_SECOND;
            if (!isCurrentSecond) {
                currentSecondMonitored = currentSecond;
                bytesWrittenThisSecond = bytesToWrite;
            }
            if (!willExceedThrottle) {
                bytesWrittenThisSecond += (long)bytesToWrite;
            }
        }
        if (willExceedThrottle) {
            try {
                Thread.sleep(RepeatableRequestEntity.random.nextInt(250));
            }
            catch (InterruptedException e2) {
                throw new IOException("Throttling of transmission was interrupted");
            }
            RepeatableRequestEntity.throttle(bytesToWrite);
        }
    }
}

