/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multi.event;

import org.jets3t.service.multi.ThreadWatcher;

public abstract class ServiceEvent {
    public static final int EVENT_ERROR = 0;
    public static final int EVENT_STARTED = 1;
    public static final int EVENT_COMPLETED = 2;
    public static final int EVENT_IN_PROGRESS = 3;
    public static final int EVENT_CANCELLED = 4;
    public static final int EVENT_IGNORED_ERRORS = 5;
    private int eventCode = 0;
    private Object uniqueOperationId = null;
    private Throwable t = null;
    private ThreadWatcher threadWatcher = null;
    private Throwable[] ignoredErrors = null;

    protected ServiceEvent(int eventCode, Object uniqueOperationId) {
        this.eventCode = eventCode;
        this.uniqueOperationId = uniqueOperationId;
    }

    protected void setThreadWatcher(ThreadWatcher threadWatcher) {
        this.threadWatcher = threadWatcher;
    }

    protected void setErrorCause(Throwable t2) {
        this.t = t2;
    }

    protected void setIgnoredErrors(Throwable[] ignoredErrors) {
        this.ignoredErrors = ignoredErrors;
    }

    public Object getUniqueOperationId() {
        return this.uniqueOperationId;
    }

    public int getEventCode() {
        return this.eventCode;
    }

    public Throwable getErrorCause() throws IllegalStateException {
        if (this.eventCode != 0) {
            throw new IllegalStateException("Error Cause is only available from EVENT_ERROR events");
        }
        return this.t;
    }

    public Throwable[] getIgnoredErrors() throws IllegalStateException {
        if (this.eventCode != 5) {
            throw new IllegalStateException("Ignored errors are only available from EVENT_IGNORED_ERRORS events");
        }
        return this.ignoredErrors;
    }

    public ThreadWatcher getThreadWatcher() throws IllegalStateException {
        if (this.eventCode != 1 && this.eventCode != 3) {
            throw new IllegalStateException("Thread Watcher is only available from EVENT_STARTED or EVENT_IN_PROGRESS events");
        }
        return this.threadWatcher;
    }

    public String toString() {
        String eventText;
        String string = this.eventCode == 0 ? "EVENT_ERROR" : (this.eventCode == 1 ? "EVENT_STARTED" : (this.eventCode == 2 ? "EVENT_COMPLETED" : (this.eventCode == 3 ? "EVENT_IN_PROGRESS" : (this.eventCode == 4 ? "EVENT_CANCELLED" : (eventText = this.eventCode == 5 ? "EVENT_IGNORED_ERRORS" : "Unrecognised event status code: " + this.eventCode)))));
        if (this.eventCode == 0 && this.getErrorCause() != null) {
            return eventText + " " + this.getErrorCause();
        }
        return eventText;
    }
}

