/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multi.s3;

import org.jets3t.service.model.MultipartCompleted;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.multi.ThreadWatcher;
import org.jets3t.service.multi.event.ServiceEvent;

public class MultipartCompletesEvent
extends ServiceEvent {
    private MultipartUpload[] incompleteUploads = null;
    private MultipartCompleted[] completedUploads = null;

    private MultipartCompletesEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static MultipartCompletesEvent newErrorEvent(Throwable t2, Object uniqueOperationId) {
        MultipartCompletesEvent event = new MultipartCompletesEvent(0, uniqueOperationId);
        event.setErrorCause(t2);
        return event;
    }

    public static MultipartCompletesEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        MultipartCompletesEvent event = new MultipartCompletesEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static MultipartCompletesEvent newInProgressEvent(ThreadWatcher threadWatcher, MultipartCompleted[] completedUploads, Object uniqueOperationId) {
        MultipartCompletesEvent event = new MultipartCompletesEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setCompleteUploads(completedUploads);
        return event;
    }

    public static MultipartCompletesEvent newCompletedEvent(Object uniqueOperationId) {
        MultipartCompletesEvent event = new MultipartCompletesEvent(2, uniqueOperationId);
        return event;
    }

    public static MultipartCompletesEvent newCancelledEvent(MultipartUpload[] incompletedUploads, Object uniqueOperationId) {
        MultipartCompletesEvent event = new MultipartCompletesEvent(4, uniqueOperationId);
        event.setIncompleteUploads(incompletedUploads);
        return event;
    }

    public static MultipartCompletesEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        MultipartCompletesEvent event = new MultipartCompletesEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setIncompleteUploads(MultipartUpload[] uploads) {
        this.incompleteUploads = uploads;
    }

    private void setCompleteUploads(MultipartCompleted[] completed) {
        this.completedUploads = completed;
    }

    public MultipartCompleted[] getCompletedUploads() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Started Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.completedUploads;
    }

    public MultipartUpload[] getCancelledUploads() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.incompleteUploads;
    }
}

