/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.utils.ServiceUtils;

public class EncryptionUtil {
    private static final Log log;
    public static final String DEFAULT_VERSION = "2";
    public static final String DEFAULT_ALGORITHM = "PBEWithMD5AndDES";
    private String algorithm = null;
    private String version = null;
    private SecretKey key = null;
    private AlgorithmParameterSpec algParamSpec = null;
    int ITERATION_COUNT = 5000;
    byte[] salt = new byte[]{-92, 11, -56, 52, -42, -107, -13, 19};

    public EncryptionUtil(String encryptionKey, String algorithm, String version) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException {
        this.algorithm = algorithm;
        this.version = version;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cryptographic properties: algorithm=" + this.algorithm + ", version=" + this.version));
        }
        if (!DEFAULT_VERSION.equals(version)) {
            throw new RuntimeException("Unrecognised crypto version setting: " + version);
        }
        PBEKeySpec keyspec = new PBEKeySpec(encryptionKey.toCharArray(), this.salt, this.ITERATION_COUNT, 32);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithm);
        this.key = skf.generateSecret(keyspec);
        this.algParamSpec = new PBEParameterSpec(this.salt, this.ITERATION_COUNT);
    }

    public EncryptionUtil(String encryptionKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException {
        this(encryptionKey, DEFAULT_ALGORITHM, DEFAULT_VERSION);
    }

    protected Cipher initEncryptModeCipher() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(1, (Key)this.key, this.algParamSpec);
        return cipher;
    }

    protected Cipher initDecryptModeCipher() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(2, (Key)this.key, this.algParamSpec);
        return cipher;
    }

    public byte[] encrypt(String data) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        return cipher.doFinal(data.getBytes(Constants.DEFAULT_ENCODING));
    }

    public String decryptString(byte[] data) throws InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        return new String(cipher.doFinal(data), Constants.DEFAULT_ENCODING);
    }

    public String decryptString(byte[] data, int startIndex, int endIndex) throws InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initDecryptModeCipher();
        return new String(cipher.doFinal(data, startIndex, endIndex), Constants.DEFAULT_ENCODING);
    }

    public byte[] encrypt(byte[] data) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        return cipher.doFinal(data);
    }

    public byte[] decrypt(byte[] data) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initDecryptModeCipher();
        return cipher.doFinal(data);
    }

    public byte[] decrypt(byte[] data, int startIndex, int endIndex) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initDecryptModeCipher();
        return cipher.doFinal(data, startIndex, endIndex);
    }

    public CipherInputStream encrypt(InputStream is) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        return new CipherInputStream(is, cipher);
    }

    public CipherInputStream decrypt(InputStream is) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initDecryptModeCipher();
        return new CipherInputStream(is, cipher);
    }

    public CipherOutputStream encrypt(OutputStream os2) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        return new CipherOutputStream(os2, cipher);
    }

    public CipherOutputStream decrypt(OutputStream os2) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initDecryptModeCipher();
        return new CipherOutputStream(os2, cipher);
    }

    public long getEncryptedOutputSize(long inputSize) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        long outputSize = 0L;
        int maxChunk = 0x7FFFDFFF;
        while (inputSize >= (long)maxChunk) {
            outputSize += (long)cipher.getOutputSize(maxChunk);
            inputSize -= (long)maxChunk;
        }
        return outputSize += (long)cipher.getOutputSize((int)inputSize);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static boolean isCipherAvailableForUse(String cipher) {
        try {
            EncryptionUtil encryptionUtil = new EncryptionUtil("Sample Key", cipher, DEFAULT_VERSION);
            encryptionUtil.encrypt("Testing encryption...");
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Availability test failed for encryption cipher " + cipher));
            }
            return false;
        }
        return true;
    }

    public static String[] listAvailablePbeCiphers(boolean testAvailability) {
        Set<String> ciphers = Security.getAlgorithms("Cipher");
        HashSet<String> pbeCiphers = new HashSet<String>();
        for (String cipher : ciphers) {
            if (!cipher.toLowerCase().startsWith("pbe") || testAvailability && !EncryptionUtil.isCipherAvailableForUse(cipher)) continue;
            pbeCiphers.add(cipher);
        }
        return pbeCiphers.toArray(new String[pbeCiphers.size()]);
    }

    public static Provider[] listAvailableProviders() {
        return Security.getProviders();
    }

    public static byte[] signWithRsaSha1(byte[] derPrivateKeyBytes, byte[] dataToSign) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException, NoSuchProviderException {
        PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(derPrivateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPrivateKey privateKey = (RSAPrivateKey)keyFactory.generatePrivate(privSpec);
        Signature signature = Signature.getInstance("SHA1withRSA", "BC");
        signature.initSign(privateKey, new SecureRandom());
        signature.update(dataToSign);
        byte[] signatureBytes = signature.sign();
        return signatureBytes;
    }

    public static byte[] convertRsaPemToDer(InputStream is) throws IOException {
        String pemData = ServiceUtils.readInputStreamToString(is, "UTF-8");
        int headerEndOffset = pemData.indexOf(10);
        int footerStartOffset = pemData.indexOf("-----END");
        String strippedPemData = pemData.substring(headerEndOffset + 1, footerStartOffset - 1);
        byte[] derBytes = ServiceUtils.fromBase64(strippedPemData);
        return derBytes;
    }

    public static void main(String[] args) throws Exception {
        int i2;
        Provider[] providers = EncryptionUtil.listAvailableProviders();
        System.out.println("Providers:");
        for (int i3 = 0; i3 < providers.length; ++i3) {
            System.out.println(" - " + providers[i3]);
        }
        String[] ciphers = EncryptionUtil.listAvailablePbeCiphers(false);
        System.out.println("PBE Ciphers available (untested):");
        for (i2 = 0; i2 < ciphers.length; ++i2) {
            System.out.println(" - " + ciphers[i2]);
        }
        ciphers = EncryptionUtil.listAvailablePbeCiphers(true);
        System.out.println("PBE Ciphers available (tested):");
        for (i2 = 0; i2 < ciphers.length; ++i2) {
            System.out.println(" - " + ciphers[i2]);
        }
    }

    static {
        block5: {
            log = LogFactory.getLog(EncryptionUtil.class);
            try {
                Class<?> bouncyCastleProviderClass = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                if (bouncyCastleProviderClass != null) {
                    Provider bouncyCastleProvider = (Provider)bouncyCastleProviderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    Security.addProvider(bouncyCastleProvider);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Loaded security provider BouncyCastleProvider");
                }
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)"Unable to load security provider BouncyCastleProvider");
            }
        }
    }
}

