/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.Chronology;
import org.joda.time.chrono.BasicChronology;

abstract class BasicGJChronology
extends BasicChronology {
    private static final long serialVersionUID = 538276888268L;
    private static final int[] MIN_DAYS_PER_MONTH_ARRAY = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] MAX_DAYS_PER_MONTH_ARRAY = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final long[] MIN_TOTAL_MILLIS_BY_MONTH_ARRAY = new long[12];
    private static final long[] MAX_TOTAL_MILLIS_BY_MONTH_ARRAY = new long[12];
    private static final long FEB_29 = 5097600000L;

    BasicGJChronology(Chronology chronology, Object object, int n2) {
        super(chronology, object, n2);
    }

    boolean isLeapDay(long l2) {
        return this.dayOfMonth().get(l2) == 29 && this.monthOfYear().isLeap(l2);
    }

    int getMonthOfYear(long l2, int n2) {
        int n3 = (int)(l2 - this.getYearMillis(n2) >> 10);
        return this.isLeapYear(n2) ? (n3 < 15356250 ? (n3 < 7678125 ? (n3 < 2615625 ? 1 : (n3 < 5062500 ? 2 : 3)) : (n3 < 10209375 ? 4 : (n3 < 12825000 ? 5 : 6))) : (n3 < 23118750 ? (n3 < 17971875 ? 7 : (n3 < 20587500 ? 8 : 9)) : (n3 < 25734375 ? 10 : (n3 < 28265625 ? 11 : 12)))) : (n3 < 15271875 ? (n3 < 7593750 ? (n3 < 2615625 ? 1 : (n3 < 4978125 ? 2 : 3)) : (n3 < 10125000 ? 4 : (n3 < 12740625 ? 5 : 6))) : (n3 < 23034375 ? (n3 < 17887500 ? 7 : (n3 < 20503125 ? 8 : 9)) : (n3 < 25650000 ? 10 : (n3 < 28181250 ? 11 : 12))));
    }

    int getDaysInYearMonth(int n2, int n3) {
        if (this.isLeapYear(n2)) {
            return MAX_DAYS_PER_MONTH_ARRAY[n3 - 1];
        }
        return MIN_DAYS_PER_MONTH_ARRAY[n3 - 1];
    }

    int getDaysInMonthMax(int n2) {
        return MAX_DAYS_PER_MONTH_ARRAY[n2 - 1];
    }

    int getDaysInMonthMaxForSet(long l2, int n2) {
        return n2 > 28 || n2 < 1 ? this.getDaysInMonthMax(l2) : 28;
    }

    long getTotalMillisByYearMonth(int n2, int n3) {
        if (this.isLeapYear(n2)) {
            return MAX_TOTAL_MILLIS_BY_MONTH_ARRAY[n3 - 1];
        }
        return MIN_TOTAL_MILLIS_BY_MONTH_ARRAY[n3 - 1];
    }

    long getYearDifference(long l2, long l3) {
        int n2 = this.getYear(l2);
        int n3 = this.getYear(l3);
        long l4 = l2 - this.getYearMillis(n2);
        long l5 = l3 - this.getYearMillis(n3);
        if (l5 >= 5097600000L) {
            if (this.isLeapYear(n3)) {
                if (!this.isLeapYear(n2)) {
                    l5 -= 86400000L;
                }
            } else if (l4 >= 5097600000L && this.isLeapYear(n2)) {
                l4 -= 86400000L;
            }
        }
        int n4 = n2 - n3;
        if (l4 < l5) {
            --n4;
        }
        return n4;
    }

    long setYear(long l2, int n2) {
        int n3 = this.getYear(l2);
        int n4 = this.getDayOfYear(l2, n3);
        int n5 = this.getMillisOfDay(l2);
        if (n4 > 59) {
            if (this.isLeapYear(n3)) {
                if (!this.isLeapYear(n2)) {
                    --n4;
                }
            } else if (this.isLeapYear(n2)) {
                ++n4;
            }
        }
        l2 = this.getYearMonthDayMillis(n2, 1, n4);
        return l2 += (long)n5;
    }

    static {
        long l2 = 0L;
        long l3 = 0L;
        for (int i2 = 0; i2 < 11; ++i2) {
            long l4 = (long)MIN_DAYS_PER_MONTH_ARRAY[i2] * 86400000L;
            BasicGJChronology.MIN_TOTAL_MILLIS_BY_MONTH_ARRAY[i2 + 1] = l2 += l4;
            l4 = (long)MAX_DAYS_PER_MONTH_ARRAY[i2] * 86400000L;
            BasicGJChronology.MAX_TOTAL_MILLIS_BY_MONTH_ARRAY[i2 + 1] = l3 += l4;
        }
    }
}

