/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.field.FieldUtils;

public final class MillisDurationField
extends DurationField
implements Serializable {
    private static final long serialVersionUID = 2656707858124633367L;
    public static final DurationField INSTANCE = new MillisDurationField();

    private MillisDurationField() {
    }

    public DurationFieldType getType() {
        return DurationFieldType.millis();
    }

    public String getName() {
        return "millis";
    }

    public boolean isSupported() {
        return true;
    }

    public final boolean isPrecise() {
        return true;
    }

    public final long getUnitMillis() {
        return 1L;
    }

    public int getValue(long l2) {
        return FieldUtils.safeToInt(l2);
    }

    public long getValueAsLong(long l2) {
        return l2;
    }

    public int getValue(long l2, long l3) {
        return FieldUtils.safeToInt(l2);
    }

    public long getValueAsLong(long l2, long l3) {
        return l2;
    }

    public long getMillis(int n2) {
        return n2;
    }

    public long getMillis(long l2) {
        return l2;
    }

    public long getMillis(int n2, long l2) {
        return n2;
    }

    public long getMillis(long l2, long l3) {
        return l2;
    }

    public long add(long l2, int n2) {
        return FieldUtils.safeAdd(l2, (long)n2);
    }

    public long add(long l2, long l3) {
        return FieldUtils.safeAdd(l2, l3);
    }

    public int getDifference(long l2, long l3) {
        return FieldUtils.safeToInt(FieldUtils.safeSubtract(l2, l3));
    }

    public long getDifferenceAsLong(long l2, long l3) {
        return FieldUtils.safeSubtract(l2, l3);
    }

    public int compareTo(DurationField durationField) {
        long l2 = durationField.getUnitMillis();
        long l3 = this.getUnitMillis();
        if (l3 == l2) {
            return 0;
        }
        if (l3 < l2) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (object instanceof MillisDurationField) {
            return this.getUnitMillis() == ((MillisDurationField)object).getUnitMillis();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getUnitMillis();
    }

    public String toString() {
        return "DurationField[millis]";
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

