/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.field.DelegatedDateTimeField;
import org.joda.time.field.FieldUtils;

public final class SkipUndoDateTimeField
extends DelegatedDateTimeField {
    private static final long serialVersionUID = -5875876968979L;
    private final Chronology iChronology;
    private final int iSkip;
    private transient int iMinValue;

    public SkipUndoDateTimeField(Chronology chronology, DateTimeField dateTimeField) {
        this(chronology, dateTimeField, 0);
    }

    public SkipUndoDateTimeField(Chronology chronology, DateTimeField dateTimeField, int n2) {
        super(dateTimeField);
        this.iChronology = chronology;
        int n3 = super.getMinimumValue();
        this.iMinValue = n3 < n2 ? n3 + 1 : (n3 == n2 + 1 ? n2 : n3);
        this.iSkip = n2;
    }

    public int get(long l2) {
        int n2 = super.get(l2);
        if (n2 < this.iSkip) {
            ++n2;
        }
        return n2;
    }

    public long set(long l2, int n2) {
        FieldUtils.verifyValueBounds(this, n2, this.iMinValue, this.getMaximumValue());
        if (n2 <= this.iSkip) {
            --n2;
        }
        return super.set(l2, n2);
    }

    public int getMinimumValue() {
        return this.iMinValue;
    }

    private Object readResolve() {
        return this.getType().getField(this.iChronology);
    }
}

