/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dct;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.fft.DoubleFFT_1D;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayUtils;
import pl.edu.icm.jlargearrays.LongLargeArray;

public class DoubleDCT_1D {
    private int n;
    private long nl;
    private int[] ip;
    private LongLargeArray ipl;
    private double[] w;
    private DoubleLargeArray wl;
    private int nw;
    private long nwl;
    private int nc;
    private long ncl;
    private boolean isPowerOfTwo = false;
    private DoubleFFT_1D fft;
    private static final double PI = Math.PI;
    private boolean useLargeArrays;

    public DoubleDCT_1D(long n2) {
        if (n2 < 1L) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        this.useLargeArrays = CommonUtils.isUseLargeArrays() || n2 > (long)LargeArray.getMaxSizeOf32bitArray();
        this.n = (int)n2;
        this.nl = n2;
        if (!this.useLargeArrays) {
            if (n2 > 0x10000000L) {
                throw new IllegalArgumentException("n must be smaller or equal to 268435456 when useLargeArrays argument is set to false");
            }
            if (CommonUtils.isPowerOf2(n2)) {
                this.isPowerOfTwo = true;
                this.ip = new int[(int)FastMath.ceil((double)(2 + (1 << (int)(FastMath.log((double)((double)(n2 / 2L) + 0.5)) / FastMath.log((double)2.0)) / 2)))];
                this.w = new double[this.n * 5 / 4];
                this.nw = this.ip[0];
                if (n2 > (long)(this.nw << 2)) {
                    this.nw = this.n >> 2;
                    CommonUtils.makewt(this.nw, this.ip, this.w);
                }
                this.nc = this.ip[1];
                if (n2 > (long)this.nc) {
                    this.nc = this.n;
                    CommonUtils.makect(this.nc, this.w, this.nw, this.ip);
                }
            } else {
                this.w = this.makect(this.n);
                this.fft = new DoubleFFT_1D(2L * n2);
            }
        } else if (CommonUtils.isPowerOf2(n2)) {
            this.isPowerOfTwo = true;
            this.ipl = new LongLargeArray((long)FastMath.ceil((double)(2L + (1L << (int)((long)(FastMath.log((double)((double)(n2 / 2L) + 0.5)) / FastMath.log((double)2.0)) / 2L)))));
            this.wl = new DoubleLargeArray(this.nl * 5L / 4L);
            this.nwl = this.ipl.getLong(0L);
            if (n2 > this.nwl << 2) {
                this.nwl = this.nl >> 2;
                CommonUtils.makewt(this.nwl, this.ipl, this.wl);
            }
            this.ncl = this.ipl.getLong(1L);
            if (n2 > this.ncl) {
                this.ncl = this.nl;
                CommonUtils.makect(this.ncl, this.wl, this.nwl, this.ipl);
            }
        } else {
            this.wl = this.makect(n2);
            this.fft = new DoubleFFT_1D(2L * n2);
        }
    }

    public void forward(double[] a2, boolean scale) {
        this.forward(a2, 0, scale);
    }

    public void forward(DoubleLargeArray a2, boolean scale) {
        this.forward(a2, 0L, scale);
    }

    public void forward(final double[] a2, final int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.forward(new DoubleLargeArray(a2), (long)offa, scale);
        } else if (this.isPowerOfTwo) {
            double xr = a2[offa + this.n - 1];
            for (int j2 = this.n - 2; j2 >= 2; j2 -= 2) {
                a2[offa + j2 + 1] = a2[offa + j2] - a2[offa + j2 - 1];
                int n2 = offa + j2;
                a2[n2] = a2[n2] + a2[offa + j2 - 1];
            }
            a2[offa + 1] = a2[offa] - xr;
            int n3 = offa;
            a2[n3] = a2[n3] + xr;
            if (this.n > 4) {
                DoubleDCT_1D.rftbsub(this.n, a2, offa, this.nc, this.w, this.nw);
                CommonUtils.cftbsub(this.n, a2, offa, this.ip, this.nw, this.w);
            } else if (this.n == 4) {
                CommonUtils.cftbsub(this.n, a2, offa, this.ip, this.nw, this.w);
            }
            CommonUtils.dctsub(this.n, a2, offa, this.nc, this.w, this.nw);
            if (scale) {
                CommonUtils.scale(this.n, FastMath.sqrt((double)(2.0 / (double)this.n)), a2, offa, false);
                a2[offa] = a2[offa] / FastMath.sqrt((double)2.0);
            }
        } else {
            int i2;
            int twon = 2 * this.n;
            final double[] t2 = new double[twon];
            System.arraycopy(a2, offa, t2, 0, this.n);
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            for (i2 = this.n; i2 < twon; ++i2) {
                t2[i2] = t2[twon - i2 - 1];
            }
            this.fft.realForward(t2);
            if (nthreads > 1 && (long)this.n > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                nthreads = 2;
                int k2 = this.n / nthreads;
                Future[] futures = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final int firstIdx = j3 * k2;
                    final int lastIdx = j3 == nthreads - 1 ? this.n : firstIdx + k2;
                    futures[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                                int twoi = 2 * i2;
                                int idx = offa + i2;
                                a2[idx] = DoubleDCT_1D.this.w[twoi] * t2[twoi] - DoubleDCT_1D.this.w[twoi + 1] * t2[twoi + 1];
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDCT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDCT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (i2 = 0; i2 < this.n; ++i2) {
                    int twoi = 2 * i2;
                    int idx = offa + i2;
                    a2[idx] = this.w[twoi] * t2[twoi] - this.w[twoi + 1] * t2[twoi + 1];
                }
            }
            if (scale) {
                CommonUtils.scale(this.n, 1.0 / FastMath.sqrt((double)twon), a2, offa, false);
                a2[offa] = a2[offa] / FastMath.sqrt((double)2.0);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void forward(final DoubleLargeArray a2, final long offa, boolean scale) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (a2.isLarge() || a2.isConstant() || offa >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.forward(a2.getData(), (int)offa, scale);
            return;
        } else if (this.isPowerOfTwo) {
            double xr = a2.getDouble(offa + this.nl - 1L);
            for (long j2 = this.nl - 2L; j2 >= 2L; j2 -= 2L) {
                a2.setDouble(offa + j2 + 1L, a2.getDouble(offa + j2) - a2.getDouble(offa + j2 - 1L));
                a2.setDouble(offa + j2, a2.getDouble(offa + j2) + a2.getDouble(offa + j2 - 1L));
            }
            a2.setDouble(offa + 1L, a2.getDouble(offa) - xr);
            a2.setDouble(offa, a2.getDouble(offa) + xr);
            if (this.nl > 4L) {
                DoubleDCT_1D.rftbsub(this.nl, a2, offa, this.ncl, this.wl, this.nwl);
                CommonUtils.cftbsub(this.nl, a2, offa, this.ipl, this.nwl, this.wl);
            } else if (this.nl == 4L) {
                CommonUtils.cftbsub(this.nl, a2, offa, this.ipl, this.nwl, this.wl);
            }
            CommonUtils.dctsub(this.nl, a2, offa, this.ncl, this.wl, this.nwl);
            if (!scale) return;
            CommonUtils.scale(this.nl, FastMath.sqrt((double)(2.0 / (double)this.nl)), a2, offa, false);
            a2.setDouble(offa, a2.getDouble(offa) / FastMath.sqrt((double)2.0));
            return;
        } else {
            long i2;
            long twon = 2L * this.nl;
            final DoubleLargeArray t2 = new DoubleLargeArray(twon);
            LargeArrayUtils.arraycopy(a2, offa, t2, 0L, this.nl);
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            for (i2 = this.nl; i2 < twon; ++i2) {
                t2.setDouble(i2, t2.getDouble(twon - i2 - 1L));
            }
            this.fft.realForward(t2);
            if (nthreads > 1 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                nthreads = 2;
                long k2 = this.nl / (long)nthreads;
                Future[] futures = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k2;
                    final long lastIdx = j3 == nthreads - 1 ? this.nl : firstIdx + k2;
                    futures[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                                long twoi = 2L * i2;
                                long idx = offa + i2;
                                a2.setDouble(idx, DoubleDCT_1D.this.wl.getDouble(twoi) * t2.getDouble(twoi) - DoubleDCT_1D.this.wl.getDouble(twoi + 1L) * t2.getDouble(twoi + 1L));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDCT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDCT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (i2 = 0L; i2 < this.nl; ++i2) {
                    long twoi = 2L * i2;
                    long idx = offa + i2;
                    a2.setDouble(idx, this.wl.getDouble(twoi) * t2.getDouble(twoi) - this.wl.getDouble(twoi + 1L) * t2.getDouble(twoi + 1L));
                }
            }
            if (!scale) return;
            CommonUtils.scale(this.nl, 1.0 / FastMath.sqrt((double)twon), a2, offa, false);
            a2.setDouble(offa, a2.getDouble(offa) / FastMath.sqrt((double)2.0));
        }
    }

    public void inverse(double[] a2, boolean scale) {
        this.inverse(a2, 0, scale);
    }

    public void inverse(DoubleLargeArray a2, boolean scale) {
        this.inverse(a2, 0L, scale);
    }

    public void inverse(final double[] a2, final int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.inverse(new DoubleLargeArray(a2), (long)offa, scale);
        } else if (this.isPowerOfTwo) {
            if (scale) {
                CommonUtils.scale(this.n, FastMath.sqrt((double)(2.0 / (double)this.n)), a2, offa, false);
                a2[offa] = a2[offa] / FastMath.sqrt((double)2.0);
            }
            CommonUtils.dctsub(this.n, a2, offa, this.nc, this.w, this.nw);
            if (this.n > 4) {
                CommonUtils.cftfsub(this.n, a2, offa, this.ip, this.nw, this.w);
                DoubleDCT_1D.rftfsub(this.n, a2, offa, this.nc, this.w, this.nw);
            } else if (this.n == 4) {
                CommonUtils.cftfsub(this.n, a2, offa, this.ip, this.nw, this.w);
            }
            double xr = a2[offa] - a2[offa + 1];
            int n2 = offa;
            a2[n2] = a2[n2] + a2[offa + 1];
            for (int j2 = 2; j2 < this.n; j2 += 2) {
                a2[offa + j2 - 1] = a2[offa + j2] - a2[offa + j2 + 1];
                int n3 = offa + j2;
                a2[n3] = a2[n3] + a2[offa + j2 + 1];
            }
            a2[offa + this.n - 1] = xr;
        } else {
            int twon = 2 * this.n;
            if (scale) {
                CommonUtils.scale(this.n, FastMath.sqrt((double)twon), a2, offa, false);
                a2[offa] = a2[offa] * FastMath.sqrt((double)2.0);
            }
            final double[] t2 = new double[twon];
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && (long)this.n > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                nthreads = 2;
                int k2 = this.n / nthreads;
                Future[] futures = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final int firstIdx = j3 * k2;
                    final int lastIdx = j3 == nthreads - 1 ? this.n : firstIdx + k2;
                    futures[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                                int twoi = 2 * i2;
                                double elem = a2[offa + i2];
                                t2[twoi] = DoubleDCT_1D.this.w[twoi] * elem;
                                t2[twoi + 1] = -DoubleDCT_1D.this.w[twoi + 1] * elem;
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDCT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDCT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int i2 = 0; i2 < this.n; ++i2) {
                    int twoi = 2 * i2;
                    double elem = a2[offa + i2];
                    t2[twoi] = this.w[twoi] * elem;
                    t2[twoi + 1] = -this.w[twoi + 1] * elem;
                }
            }
            this.fft.realInverse(t2, true);
            System.arraycopy(t2, 0, a2, offa, this.n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void inverse(final DoubleLargeArray a2, final long offa, boolean scale) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (a2.isLarge() || a2.isConstant() || offa >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.inverse(a2.getData(), (int)offa, scale);
            return;
        } else if (this.isPowerOfTwo) {
            if (scale) {
                CommonUtils.scale(this.nl, FastMath.sqrt((double)(2.0 / (double)this.nl)), a2, offa, false);
                a2.setDouble(offa, a2.getDouble(offa) / FastMath.sqrt((double)2.0));
            }
            CommonUtils.dctsub(this.nl, a2, offa, this.ncl, this.wl, this.nwl);
            if (this.nl > 4L) {
                CommonUtils.cftfsub(this.nl, a2, offa, this.ipl, this.nwl, this.wl);
                DoubleDCT_1D.rftfsub(this.nl, a2, offa, this.ncl, this.wl, this.nwl);
            } else if (this.nl == 4L) {
                CommonUtils.cftfsub(this.nl, a2, offa, this.ipl, this.nwl, this.wl);
            }
            double xr = a2.getDouble(offa) - a2.getDouble(offa + 1L);
            a2.setDouble(offa, a2.getDouble(offa) + a2.getDouble(offa + 1L));
            for (long j2 = 2L; j2 < this.nl; j2 += 2L) {
                a2.setDouble(offa + j2 - 1L, a2.getDouble(offa + j2) - a2.getDouble(offa + j2 + 1L));
                a2.setDouble(offa + j2, a2.getDouble(offa + j2) + a2.getDouble(offa + j2 + 1L));
            }
            a2.setDouble(offa + this.nl - 1L, xr);
            return;
        } else {
            long twon = 2L * this.nl;
            if (scale) {
                CommonUtils.scale(this.nl, FastMath.sqrt((double)twon), a2, offa, false);
                a2.setDouble(offa, a2.getDouble(offa) * FastMath.sqrt((double)2.0));
            }
            final DoubleLargeArray t2 = new DoubleLargeArray(twon);
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                nthreads = 2;
                long k2 = this.nl / (long)nthreads;
                Future[] futures = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k2;
                    final long lastIdx = j3 == nthreads - 1 ? this.nl : firstIdx + k2;
                    futures[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                                long twoi = 2L * i2;
                                double elem = a2.getDouble(offa + i2);
                                t2.setDouble(twoi, DoubleDCT_1D.this.wl.getDouble(twoi) * elem);
                                t2.setDouble(twoi + 1L, -DoubleDCT_1D.this.wl.getDouble(twoi + 1L) * elem);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDCT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDCT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (long i2 = 0L; i2 < this.nl; ++i2) {
                    long twoi = 2L * i2;
                    double elem = a2.getDouble(offa + i2);
                    t2.setDouble(twoi, this.wl.getDouble(twoi) * elem);
                    t2.setDouble(twoi + 1L, -this.wl.getDouble(twoi + 1L) * elem);
                }
            }
            this.fft.realInverse(t2, true);
            LargeArrayUtils.arraycopy(t2, 0L, a2, offa, this.nl);
        }
    }

    private double[] makect(int n2) {
        int twon = 2 * n2;
        double delta = Math.PI / (double)twon;
        double[] c2 = new double[twon];
        c2[0] = 1.0;
        for (int j2 = 1; j2 < n2; ++j2) {
            int idx = 2 * j2;
            double deltaj = delta * (double)j2;
            c2[idx] = FastMath.cos((double)deltaj);
            c2[idx + 1] = -FastMath.sin((double)deltaj);
        }
        return c2;
    }

    private DoubleLargeArray makect(long n2) {
        long twon = 2L * n2;
        double delta = Math.PI / (double)twon;
        DoubleLargeArray c2 = new DoubleLargeArray(twon);
        c2.setDouble(0L, 1.0);
        for (long j2 = 1L; j2 < n2; ++j2) {
            long idx = 2L * j2;
            double deltaj = delta * (double)j2;
            c2.setDouble(idx, FastMath.cos((double)deltaj));
            c2.setDouble(idx + 1L, -FastMath.sin((double)deltaj));
        }
        return c2;
    }

    private static void rftfsub(int n2, double[] a2, int offa, int nc, double[] c2, int startc) {
        int m4 = n2 >> 1;
        int ks = 2 * nc / m4;
        int kk = 0;
        for (int j2 = 2; j2 < m4; j2 += 2) {
            int k2 = n2 - j2;
            double wkr = 0.5 - c2[startc + nc - (kk += ks)];
            double wki = c2[startc + kk];
            int idx1 = offa + j2;
            int idx2 = offa + k2;
            double xr = a2[idx1] - a2[idx2];
            double xi = a2[idx1 + 1] + a2[idx2 + 1];
            double yr = wkr * xr - wki * xi;
            double yi = wkr * xi + wki * xr;
            int n3 = idx1;
            a2[n3] = a2[n3] - yr;
            int n4 = idx1 + 1;
            a2[n4] = a2[n4] - yi;
            int n5 = idx2;
            a2[n5] = a2[n5] + yr;
            int n6 = idx2 + 1;
            a2[n6] = a2[n6] - yi;
        }
    }

    private static void rftfsub(long n2, DoubleLargeArray a2, long offa, long nc, DoubleLargeArray c2, long startc) {
        long m4 = n2 >> 1;
        long ks = 2L * nc / m4;
        long kk = 0L;
        for (long j2 = 2L; j2 < m4; j2 += 2L) {
            long k2 = n2 - j2;
            double wkr = 0.5 - c2.getDouble(startc + nc - (kk += ks));
            double wki = c2.getDouble(startc + kk);
            long idx1 = offa + j2;
            long idx2 = offa + k2;
            double xr = a2.getDouble(idx1) - a2.getDouble(idx2);
            double xi = a2.getDouble(idx1 + 1L) + a2.getDouble(idx2 + 1L);
            double yr = wkr * xr - wki * xi;
            double yi = wkr * xi + wki * xr;
            a2.setDouble(idx1, a2.getDouble(idx1) - yr);
            a2.setDouble(idx1 + 1L, a2.getDouble(idx1 + 1L) - yi);
            a2.setDouble(idx2, a2.getDouble(idx2) + yr);
            a2.setDouble(idx2 + 1L, a2.getDouble(idx2 + 1L) - yi);
        }
    }

    private static void rftbsub(int n2, double[] a2, int offa, int nc, double[] c2, int startc) {
        int m4 = n2 >> 1;
        int ks = 2 * nc / m4;
        int kk = 0;
        for (int j2 = 2; j2 < m4; j2 += 2) {
            int k2 = n2 - j2;
            double wkr = 0.5 - c2[startc + nc - (kk += ks)];
            double wki = c2[startc + kk];
            int idx1 = offa + j2;
            int idx2 = offa + k2;
            double xr = a2[idx1] - a2[idx2];
            double xi = a2[idx1 + 1] + a2[idx2 + 1];
            double yr = wkr * xr + wki * xi;
            double yi = wkr * xi - wki * xr;
            int n3 = idx1;
            a2[n3] = a2[n3] - yr;
            int n4 = idx1 + 1;
            a2[n4] = a2[n4] - yi;
            int n5 = idx2;
            a2[n5] = a2[n5] + yr;
            int n6 = idx2 + 1;
            a2[n6] = a2[n6] - yi;
        }
    }

    private static void rftbsub(long n2, DoubleLargeArray a2, long offa, long nc, DoubleLargeArray c2, long startc) {
        long m4 = n2 >> 1;
        long ks = 2L * nc / m4;
        long kk = 0L;
        for (long j2 = 2L; j2 < m4; j2 += 2L) {
            long k2 = n2 - j2;
            double wkr = 0.5 - c2.getDouble(startc + nc - (kk += ks));
            double wki = c2.getDouble(startc + kk);
            long idx1 = offa + j2;
            long idx2 = offa + k2;
            double xr = a2.getDouble(idx1) - a2.getDouble(idx2);
            double xi = a2.getDouble(idx1 + 1L) + a2.getDouble(idx2 + 1L);
            double yr = wkr * xr + wki * xi;
            double yi = wkr * xi - wki * xr;
            a2.setDouble(idx1, a2.getDouble(idx1) - yr);
            a2.setDouble(idx1 + 1L, a2.getDouble(idx1 + 1L) - yi);
            a2.setDouble(idx2, a2.getDouble(idx2) + yr);
            a2.setDouble(idx2 + 1L, a2.getDouble(idx2 + 1L) - yi);
        }
    }
}

