/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dst;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.dst.DoubleDST_1D;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;

public class DoubleDST_2D {
    private int rows;
    private int columns;
    private long rowsl;
    private long columnsl;
    private DoubleDST_1D dstColumns;
    private DoubleDST_1D dstRows;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleDST_2D(long rows, long columns) {
        if (rows <= 1L || columns <= 1L) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = (int)rows;
        this.columns = (int)columns;
        this.rowsl = rows;
        this.columnsl = columns;
        if (rows * columns >= CommonUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (CommonUtils.isPowerOf2(rows) && CommonUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
        }
        CommonUtils.setUseLargeArrays(rows * columns > (long)LargeArray.getMaxSizeOf32bitArray());
        this.dstRows = new DoubleDST_1D(rows);
        this.dstColumns = rows == columns ? this.dstRows : new DoubleDST_1D(columns);
    }

    public void forward(final double[] a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a2, scale);
                this.ddxt2d0_subth(-1, a2, scale);
            } else {
                this.ddxt2d_sub(-1, a2, scale);
                for (int i2 = 0; i2 < this.rows; ++i2) {
                    this.dstColumns.forward(a2, i2 * this.columns, scale);
                }
            }
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            Future[] futures = new Future[nthreads];
            int p2 = this.rows / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                final int firstRow = l2 * p2;
                final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i2 = firstRow; i2 < lastRow; ++i2) {
                            DoubleDST_2D.this.dstColumns.forward(a2, i2 * DoubleDST_2D.this.columns, scale);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.columns / nthreads;
            for (int l3 = 0; l3 < nthreads; ++l3) {
                final int firstColumn = l3 * p2;
                final int lastColumn = l3 == nthreads - 1 ? this.columns : firstColumn + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_2D.this.rows];
                        for (int c2 = firstColumn; c2 < lastColumn; ++c2) {
                            int r2;
                            for (r2 = 0; r2 < DoubleDST_2D.this.rows; ++r2) {
                                temp[r2] = a2[r2 * DoubleDST_2D.this.columns + c2];
                            }
                            DoubleDST_2D.this.dstRows.forward(temp, scale);
                            for (r2 = 0; r2 < DoubleDST_2D.this.rows; ++r2) {
                                a2[r2 * ((DoubleDST_2D)DoubleDST_2D.this).columns + c2] = temp[r2];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            for (int i3 = 0; i3 < this.rows; ++i3) {
                this.dstColumns.forward(a2, i3 * this.columns, scale);
            }
            double[] temp = new double[this.rows];
            for (int c2 = 0; c2 < this.columns; ++c2) {
                int r2;
                for (r2 = 0; r2 < this.rows; ++r2) {
                    temp[r2] = a2[r2 * this.columns + c2];
                }
                this.dstRows.forward(temp, scale);
                for (r2 = 0; r2 < this.rows; ++r2) {
                    a2[r2 * this.columns + c2] = temp[r2];
                }
            }
        }
    }

    public void forward(final DoubleLargeArray a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a2, scale);
                this.ddxt2d0_subth(-1, a2, scale);
            } else {
                this.ddxt2d_sub(-1, a2, scale);
                for (long i2 = 0L; i2 < this.rowsl; ++i2) {
                    this.dstColumns.forward(a2, i2 * this.columnsl, scale);
                }
            }
        } else if (nthreads > 1 && this.useThreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
            Future[] futures = new Future[nthreads];
            long p2 = this.rowsl / (long)nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                final long firstRow = (long)l2 * p2;
                final long lastRow = l2 == nthreads - 1 ? this.rowsl : firstRow + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i2 = firstRow; i2 < lastRow; ++i2) {
                            DoubleDST_2D.this.dstColumns.forward(a2, i2 * DoubleDST_2D.this.columnsl, scale);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.columnsl / (long)nthreads;
            for (int l3 = 0; l3 < nthreads; ++l3) {
                final long firstColumn = (long)l3 * p2;
                final long lastColumn = l3 == nthreads - 1 ? this.columnsl : firstColumn + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(DoubleDST_2D.this.rowsl, false);
                        for (long c2 = firstColumn; c2 < lastColumn; ++c2) {
                            long r2;
                            for (r2 = 0L; r2 < DoubleDST_2D.this.rowsl; ++r2) {
                                temp.setDouble(r2, a2.getDouble(r2 * DoubleDST_2D.this.columnsl + c2));
                            }
                            DoubleDST_2D.this.dstRows.forward(temp, scale);
                            for (r2 = 0L; r2 < DoubleDST_2D.this.rowsl; ++r2) {
                                a2.setDouble(r2 * DoubleDST_2D.this.columnsl + c2, temp.getDouble(r2));
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            for (long i3 = 0L; i3 < this.rowsl; ++i3) {
                this.dstColumns.forward(a2, i3 * this.columnsl, scale);
            }
            DoubleLargeArray temp = new DoubleLargeArray(this.rowsl, false);
            for (long c2 = 0L; c2 < this.columnsl; ++c2) {
                long r2;
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    temp.setDouble(r2, a2.getDouble(r2 * this.columnsl + c2));
                }
                this.dstRows.forward(temp, scale);
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    a2.setDouble(r2 * this.columnsl + c2, temp.getDouble(r2));
                }
            }
        }
    }

    public void forward(final double[][] a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a2, scale);
                this.ddxt2d0_subth(-1, a2, scale);
            } else {
                this.ddxt2d_sub(-1, a2, scale);
                for (int i2 = 0; i2 < this.rows; ++i2) {
                    this.dstColumns.forward(a2[i2], scale);
                }
            }
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            Future[] futures = new Future[nthreads];
            int p2 = this.rows / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                final int firstRow = l2 * p2;
                final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i2 = firstRow; i2 < lastRow; ++i2) {
                            DoubleDST_2D.this.dstColumns.forward(a2[i2], scale);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.columns / nthreads;
            for (int l3 = 0; l3 < nthreads; ++l3) {
                final int firstColumn = l3 * p2;
                final int lastColumn = l3 == nthreads - 1 ? this.columns : firstColumn + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_2D.this.rows];
                        for (int c2 = firstColumn; c2 < lastColumn; ++c2) {
                            int r2;
                            for (r2 = 0; r2 < DoubleDST_2D.this.rows; ++r2) {
                                temp[r2] = a2[r2][c2];
                            }
                            DoubleDST_2D.this.dstRows.forward(temp, scale);
                            for (r2 = 0; r2 < DoubleDST_2D.this.rows; ++r2) {
                                a2[r2][c2] = temp[r2];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            for (int i3 = 0; i3 < this.rows; ++i3) {
                this.dstColumns.forward(a2[i3], scale);
            }
            double[] temp = new double[this.rows];
            for (int c2 = 0; c2 < this.columns; ++c2) {
                int r2;
                for (r2 = 0; r2 < this.rows; ++r2) {
                    temp[r2] = a2[r2][c2];
                }
                this.dstRows.forward(temp, scale);
                for (r2 = 0; r2 < this.rows; ++r2) {
                    a2[r2][c2] = temp[r2];
                }
            }
        }
    }

    public void inverse(final double[] a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a2, scale);
                this.ddxt2d0_subth(1, a2, scale);
            } else {
                this.ddxt2d_sub(1, a2, scale);
                for (int i2 = 0; i2 < this.rows; ++i2) {
                    this.dstColumns.inverse(a2, i2 * this.columns, scale);
                }
            }
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            Future[] futures = new Future[nthreads];
            int p2 = this.rows / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                final int firstRow = l2 * p2;
                final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i2 = firstRow; i2 < lastRow; ++i2) {
                            DoubleDST_2D.this.dstColumns.inverse(a2, i2 * DoubleDST_2D.this.columns, scale);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.columns / nthreads;
            for (int l3 = 0; l3 < nthreads; ++l3) {
                final int firstColumn = l3 * p2;
                final int lastColumn = l3 == nthreads - 1 ? this.columns : firstColumn + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_2D.this.rows];
                        for (int c2 = firstColumn; c2 < lastColumn; ++c2) {
                            int r2;
                            for (r2 = 0; r2 < DoubleDST_2D.this.rows; ++r2) {
                                temp[r2] = a2[r2 * DoubleDST_2D.this.columns + c2];
                            }
                            DoubleDST_2D.this.dstRows.inverse(temp, scale);
                            for (r2 = 0; r2 < DoubleDST_2D.this.rows; ++r2) {
                                a2[r2 * ((DoubleDST_2D)DoubleDST_2D.this).columns + c2] = temp[r2];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            for (int i3 = 0; i3 < this.rows; ++i3) {
                this.dstColumns.inverse(a2, i3 * this.columns, scale);
            }
            double[] temp = new double[this.rows];
            for (int c2 = 0; c2 < this.columns; ++c2) {
                int r2;
                for (r2 = 0; r2 < this.rows; ++r2) {
                    temp[r2] = a2[r2 * this.columns + c2];
                }
                this.dstRows.inverse(temp, scale);
                for (r2 = 0; r2 < this.rows; ++r2) {
                    a2[r2 * this.columns + c2] = temp[r2];
                }
            }
        }
    }

    public void inverse(final DoubleLargeArray a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a2, scale);
                this.ddxt2d0_subth(1, a2, scale);
            } else {
                this.ddxt2d_sub(1, a2, scale);
                for (long i2 = 0L; i2 < this.rowsl; ++i2) {
                    this.dstColumns.inverse(a2, i2 * this.columnsl, scale);
                }
            }
        } else if (nthreads > 1 && this.useThreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
            Future[] futures = new Future[nthreads];
            long p2 = this.rowsl / (long)nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                final long firstRow = (long)l2 * p2;
                final long lastRow = l2 == nthreads - 1 ? this.rowsl : firstRow + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i2 = firstRow; i2 < lastRow; ++i2) {
                            DoubleDST_2D.this.dstColumns.inverse(a2, i2 * DoubleDST_2D.this.columnsl, scale);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.columnsl / (long)nthreads;
            for (int l3 = 0; l3 < nthreads; ++l3) {
                final long firstColumn = (long)l3 * p2;
                final long lastColumn = l3 == nthreads - 1 ? this.columnsl : firstColumn + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(DoubleDST_2D.this.rowsl, false);
                        for (long c2 = firstColumn; c2 < lastColumn; ++c2) {
                            long r2;
                            for (r2 = 0L; r2 < DoubleDST_2D.this.rowsl; ++r2) {
                                temp.setDouble(r2, a2.getDouble(r2 * DoubleDST_2D.this.columnsl + c2));
                            }
                            DoubleDST_2D.this.dstRows.inverse(temp, scale);
                            for (r2 = 0L; r2 < DoubleDST_2D.this.rowsl; ++r2) {
                                a2.setDouble(r2 * DoubleDST_2D.this.columnsl + c2, temp.getDouble(r2));
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            for (long i3 = 0L; i3 < this.rowsl; ++i3) {
                this.dstColumns.inverse(a2, i3 * this.columnsl, scale);
            }
            DoubleLargeArray temp = new DoubleLargeArray(this.rowsl, false);
            for (long c2 = 0L; c2 < this.columnsl; ++c2) {
                long r2;
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    temp.setDouble(r2, a2.getDouble(r2 * this.columnsl + c2));
                }
                this.dstRows.inverse(temp, scale);
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    a2.setDouble(r2 * this.columnsl + c2, temp.getDouble(r2));
                }
            }
        }
    }

    public void inverse(final double[][] a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a2, scale);
                this.ddxt2d0_subth(1, a2, scale);
            } else {
                this.ddxt2d_sub(1, a2, scale);
                for (int i2 = 0; i2 < this.rows; ++i2) {
                    this.dstColumns.inverse(a2[i2], scale);
                }
            }
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            Future[] futures = new Future[nthreads];
            int p2 = this.rows / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                final int firstRow = l2 * p2;
                final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i2 = firstRow; i2 < lastRow; ++i2) {
                            DoubleDST_2D.this.dstColumns.inverse(a2[i2], scale);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.columns / nthreads;
            for (int l3 = 0; l3 < nthreads; ++l3) {
                final int firstColumn = l3 * p2;
                final int lastColumn = l3 == nthreads - 1 ? this.columns : firstColumn + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_2D.this.rows];
                        for (int c2 = firstColumn; c2 < lastColumn; ++c2) {
                            int r2;
                            for (r2 = 0; r2 < DoubleDST_2D.this.rows; ++r2) {
                                temp[r2] = a2[r2][c2];
                            }
                            DoubleDST_2D.this.dstRows.inverse(temp, scale);
                            for (r2 = 0; r2 < DoubleDST_2D.this.rows; ++r2) {
                                a2[r2][c2] = temp[r2];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            for (int i3 = 0; i3 < this.rows; ++i3) {
                this.dstColumns.inverse(a2[i3], scale);
            }
            double[] temp = new double[this.rows];
            for (int c2 = 0; c2 < this.columns; ++c2) {
                int r2;
                for (r2 = 0; r2 < this.rows; ++r2) {
                    temp[r2] = a2[r2][c2];
                }
                this.dstRows.inverse(temp, scale);
                for (r2 = 0; r2 < this.rows; ++r2) {
                    a2[r2][c2] = temp[r2];
                }
            }
        }
    }

    private void ddxt2d_subth(final int isgn, final double[] a2, final boolean scale) {
        int nthread = FastMath.min((int)this.columns, (int)ConcurrencyUtils.getNumberOfThreads());
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        } else if (this.columns < 2) {
            nt >>= 2;
        }
        final int ntf = nt;
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        int idx2;
                        int idx1;
                        double[] t2;
                        block12: {
                            t2 = new double[ntf];
                            if (DoubleDST_2D.this.columns <= 2) break block12;
                            if (isgn == -1) {
                                for (int c2 = 4 * n0; c2 < DoubleDST_2D.this.columns; c2 += 4 * nthreads) {
                                    int idx22;
                                    int idx12;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleDST_2D.this.rows; ++r2) {
                                        idx12 = r2 * DoubleDST_2D.this.columns + c2;
                                        idx22 = DoubleDST_2D.this.rows + r2;
                                        t2[r2] = a2[idx12];
                                        t2[idx22] = a2[idx12 + 1];
                                        t2[idx22 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a2[idx12 + 2];
                                        t2[idx22 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).rows] = a2[idx12 + 3];
                                    }
                                    DoubleDST_2D.this.dstRows.forward(t2, 0, scale);
                                    DoubleDST_2D.this.dstRows.forward(t2, DoubleDST_2D.this.rows, scale);
                                    DoubleDST_2D.this.dstRows.forward(t2, 2 * DoubleDST_2D.this.rows, scale);
                                    DoubleDST_2D.this.dstRows.forward(t2, 3 * DoubleDST_2D.this.rows, scale);
                                    for (r2 = 0; r2 < DoubleDST_2D.this.rows; ++r2) {
                                        idx12 = r2 * DoubleDST_2D.this.columns + c2;
                                        idx22 = DoubleDST_2D.this.rows + r2;
                                        a2[idx12] = t2[r2];
                                        a2[idx12 + 1] = t2[idx22];
                                        a2[idx12 + 2] = t2[idx22 + DoubleDST_2D.this.rows];
                                        a2[idx12 + 3] = t2[idx22 + 2 * DoubleDST_2D.this.rows];
                                    }
                                }
                            } else {
                                for (int c3 = 4 * n0; c3 < DoubleDST_2D.this.columns; c3 += 4 * nthreads) {
                                    int idx23;
                                    int idx13;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleDST_2D.this.rows; ++r3) {
                                        idx13 = r3 * DoubleDST_2D.this.columns + c3;
                                        idx23 = DoubleDST_2D.this.rows + r3;
                                        t2[r3] = a2[idx13];
                                        t2[idx23] = a2[idx13 + 1];
                                        t2[idx23 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a2[idx13 + 2];
                                        t2[idx23 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).rows] = a2[idx13 + 3];
                                    }
                                    DoubleDST_2D.this.dstRows.inverse(t2, 0, scale);
                                    DoubleDST_2D.this.dstRows.inverse(t2, DoubleDST_2D.this.rows, scale);
                                    DoubleDST_2D.this.dstRows.inverse(t2, 2 * DoubleDST_2D.this.rows, scale);
                                    DoubleDST_2D.this.dstRows.inverse(t2, 3 * DoubleDST_2D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleDST_2D.this.rows; ++r3) {
                                        idx13 = r3 * DoubleDST_2D.this.columns + c3;
                                        idx23 = DoubleDST_2D.this.rows + r3;
                                        a2[idx13] = t2[r3];
                                        a2[idx13 + 1] = t2[idx23];
                                        a2[idx13 + 2] = t2[idx23 + DoubleDST_2D.this.rows];
                                        a2[idx13 + 3] = t2[idx23 + 2 * DoubleDST_2D.this.rows];
                                    }
                                }
                            }
                            break block13;
                        }
                        if (DoubleDST_2D.this.columns != 2) break block13;
                        int r4 = 0;
                        while (r4 < DoubleDST_2D.this.rows) {
                            idx1 = r4 * DoubleDST_2D.this.columns + 2 * n0;
                            idx2 = r4++;
                            t2[idx2] = a2[idx1];
                            t2[idx2 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a2[idx1 + 1];
                        }
                        if (isgn == -1) {
                            DoubleDST_2D.this.dstRows.forward(t2, 0, scale);
                            DoubleDST_2D.this.dstRows.forward(t2, DoubleDST_2D.this.rows, scale);
                        } else {
                            DoubleDST_2D.this.dstRows.inverse(t2, 0, scale);
                            DoubleDST_2D.this.dstRows.inverse(t2, DoubleDST_2D.this.rows, scale);
                        }
                        r4 = 0;
                        while (r4 < DoubleDST_2D.this.rows) {
                            idx1 = r4 * DoubleDST_2D.this.columns + 2 * n0;
                            idx2 = r4++;
                            a2[idx1] = t2[idx2];
                            a2[idx1 + 1] = t2[idx2 + DoubleDST_2D.this.rows];
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d_subth(final int isgn, final DoubleLargeArray a2, final boolean scale) {
        int nthread = (int)FastMath.min((long)this.columnsl, (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        } else if (this.columnsl < 2L) {
            nt >>= 2;
        }
        final long ntf = nt;
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final long n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        long idx2;
                        long idx1;
                        DoubleLargeArray t2;
                        block12: {
                            t2 = new DoubleLargeArray(ntf);
                            if (DoubleDST_2D.this.columnsl <= 2L) break block12;
                            if (isgn == -1) {
                                for (long c2 = 4L * n0; c2 < DoubleDST_2D.this.columnsl; c2 += (long)(4 * nthreads)) {
                                    long idx22;
                                    long idx12;
                                    long r2;
                                    for (r2 = 0L; r2 < DoubleDST_2D.this.rowsl; ++r2) {
                                        idx12 = r2 * DoubleDST_2D.this.columnsl + c2;
                                        idx22 = DoubleDST_2D.this.rowsl + r2;
                                        t2.setDouble(r2, a2.getDouble(idx12));
                                        t2.setDouble(idx22, a2.getDouble(idx12 + 1L));
                                        t2.setDouble(idx22 + DoubleDST_2D.this.rowsl, a2.getDouble(idx12 + 2L));
                                        t2.setDouble(idx22 + 2L * DoubleDST_2D.this.rowsl, a2.getDouble(idx12 + 3L));
                                    }
                                    DoubleDST_2D.this.dstRows.forward(t2, 0L, scale);
                                    DoubleDST_2D.this.dstRows.forward(t2, DoubleDST_2D.this.rowsl, scale);
                                    DoubleDST_2D.this.dstRows.forward(t2, 2L * DoubleDST_2D.this.rowsl, scale);
                                    DoubleDST_2D.this.dstRows.forward(t2, 3L * DoubleDST_2D.this.rowsl, scale);
                                    for (r2 = 0L; r2 < DoubleDST_2D.this.rowsl; ++r2) {
                                        idx12 = r2 * DoubleDST_2D.this.columnsl + c2;
                                        idx22 = DoubleDST_2D.this.rowsl + r2;
                                        a2.setDouble(idx12, t2.getDouble(r2));
                                        a2.setDouble(idx12 + 1L, t2.getDouble(idx22));
                                        a2.setDouble(idx12 + 2L, t2.getDouble(idx22 + DoubleDST_2D.this.rowsl));
                                        a2.setDouble(idx12 + 3L, t2.getDouble(idx22 + 2L * DoubleDST_2D.this.rowsl));
                                    }
                                }
                            } else {
                                for (long c3 = 4L * n0; c3 < DoubleDST_2D.this.columnsl; c3 += (long)(4 * nthreads)) {
                                    long idx23;
                                    long idx13;
                                    long r3;
                                    for (r3 = 0L; r3 < DoubleDST_2D.this.rowsl; ++r3) {
                                        idx13 = r3 * DoubleDST_2D.this.columnsl + c3;
                                        idx23 = DoubleDST_2D.this.rowsl + r3;
                                        t2.setDouble(r3, a2.getDouble(idx13));
                                        t2.setDouble(idx23, a2.getDouble(idx13 + 1L));
                                        t2.setDouble(idx23 + DoubleDST_2D.this.rowsl, a2.getDouble(idx13 + 2L));
                                        t2.setDouble(idx23 + 2L * DoubleDST_2D.this.rowsl, a2.getDouble(idx13 + 3L));
                                    }
                                    DoubleDST_2D.this.dstRows.inverse(t2, 0L, scale);
                                    DoubleDST_2D.this.dstRows.inverse(t2, DoubleDST_2D.this.rowsl, scale);
                                    DoubleDST_2D.this.dstRows.inverse(t2, 2L * DoubleDST_2D.this.rowsl, scale);
                                    DoubleDST_2D.this.dstRows.inverse(t2, 3L * DoubleDST_2D.this.rowsl, scale);
                                    for (r3 = 0L; r3 < DoubleDST_2D.this.rowsl; ++r3) {
                                        idx13 = r3 * DoubleDST_2D.this.columnsl + c3;
                                        idx23 = DoubleDST_2D.this.rowsl + r3;
                                        a2.setDouble(idx13, t2.getDouble(r3));
                                        a2.setDouble(idx13 + 1L, t2.getDouble(idx23));
                                        a2.setDouble(idx13 + 2L, t2.getDouble(idx23 + DoubleDST_2D.this.rowsl));
                                        a2.setDouble(idx13 + 3L, t2.getDouble(idx23 + 2L * DoubleDST_2D.this.rowsl));
                                    }
                                }
                            }
                            break block13;
                        }
                        if (DoubleDST_2D.this.columnsl != 2L) break block13;
                        long r4 = 0L;
                        while (r4 < DoubleDST_2D.this.rowsl) {
                            idx1 = r4 * DoubleDST_2D.this.columnsl + 2L * n0;
                            idx2 = r4++;
                            t2.setDouble(idx2, a2.getDouble(idx1));
                            t2.setDouble(idx2 + DoubleDST_2D.this.rowsl, a2.getDouble(idx1 + 1L));
                        }
                        if (isgn == -1) {
                            DoubleDST_2D.this.dstRows.forward(t2, 0L, scale);
                            DoubleDST_2D.this.dstRows.forward(t2, DoubleDST_2D.this.rowsl, scale);
                        } else {
                            DoubleDST_2D.this.dstRows.inverse(t2, 0L, scale);
                            DoubleDST_2D.this.dstRows.inverse(t2, DoubleDST_2D.this.rowsl, scale);
                        }
                        r4 = 0L;
                        while (r4 < DoubleDST_2D.this.rowsl) {
                            idx1 = r4 * DoubleDST_2D.this.columnsl + 2L * n0;
                            idx2 = r4++;
                            a2.setDouble(idx1, t2.getDouble(idx2));
                            a2.setDouble(idx1 + 1L, t2.getDouble(idx2 + DoubleDST_2D.this.rowsl));
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d_subth(final int isgn, final double[][] a2, final boolean scale) {
        int nthread = FastMath.min((int)this.columns, (int)ConcurrencyUtils.getNumberOfThreads());
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        } else if (this.columns < 2) {
            nt >>= 2;
        }
        final int ntf = nt;
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        int idx2;
                        int r2;
                        double[] t2;
                        block12: {
                            t2 = new double[ntf];
                            if (DoubleDST_2D.this.columns <= 2) break block12;
                            if (isgn == -1) {
                                for (int c2 = 4 * n0; c2 < DoubleDST_2D.this.columns; c2 += 4 * nthreads) {
                                    int idx22;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleDST_2D.this.rows; ++r3) {
                                        idx22 = DoubleDST_2D.this.rows + r3;
                                        t2[r3] = a2[r3][c2];
                                        t2[idx22] = a2[r3][c2 + 1];
                                        t2[idx22 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a2[r3][c2 + 2];
                                        t2[idx22 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).rows] = a2[r3][c2 + 3];
                                    }
                                    DoubleDST_2D.this.dstRows.forward(t2, 0, scale);
                                    DoubleDST_2D.this.dstRows.forward(t2, DoubleDST_2D.this.rows, scale);
                                    DoubleDST_2D.this.dstRows.forward(t2, 2 * DoubleDST_2D.this.rows, scale);
                                    DoubleDST_2D.this.dstRows.forward(t2, 3 * DoubleDST_2D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleDST_2D.this.rows; ++r3) {
                                        idx22 = DoubleDST_2D.this.rows + r3;
                                        a2[r3][c2] = t2[r3];
                                        a2[r3][c2 + 1] = t2[idx22];
                                        a2[r3][c2 + 2] = t2[idx22 + DoubleDST_2D.this.rows];
                                        a2[r3][c2 + 3] = t2[idx22 + 2 * DoubleDST_2D.this.rows];
                                    }
                                }
                            } else {
                                for (int c3 = 4 * n0; c3 < DoubleDST_2D.this.columns; c3 += 4 * nthreads) {
                                    int idx23;
                                    int r4;
                                    for (r4 = 0; r4 < DoubleDST_2D.this.rows; ++r4) {
                                        idx23 = DoubleDST_2D.this.rows + r4;
                                        t2[r4] = a2[r4][c3];
                                        t2[idx23] = a2[r4][c3 + 1];
                                        t2[idx23 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a2[r4][c3 + 2];
                                        t2[idx23 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).rows] = a2[r4][c3 + 3];
                                    }
                                    DoubleDST_2D.this.dstRows.inverse(t2, 0, scale);
                                    DoubleDST_2D.this.dstRows.inverse(t2, DoubleDST_2D.this.rows, scale);
                                    DoubleDST_2D.this.dstRows.inverse(t2, 2 * DoubleDST_2D.this.rows, scale);
                                    DoubleDST_2D.this.dstRows.inverse(t2, 3 * DoubleDST_2D.this.rows, scale);
                                    for (r4 = 0; r4 < DoubleDST_2D.this.rows; ++r4) {
                                        idx23 = DoubleDST_2D.this.rows + r4;
                                        a2[r4][c3] = t2[r4];
                                        a2[r4][c3 + 1] = t2[idx23];
                                        a2[r4][c3 + 2] = t2[idx23 + DoubleDST_2D.this.rows];
                                        a2[r4][c3 + 3] = t2[idx23 + 2 * DoubleDST_2D.this.rows];
                                    }
                                }
                            }
                            break block13;
                        }
                        if (DoubleDST_2D.this.columns != 2) break block13;
                        for (r2 = 0; r2 < DoubleDST_2D.this.rows; ++r2) {
                            idx2 = r2;
                            t2[idx2] = a2[r2][2 * n0];
                            t2[idx2 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a2[r2][2 * n0 + 1];
                        }
                        if (isgn == -1) {
                            DoubleDST_2D.this.dstRows.forward(t2, 0, scale);
                            DoubleDST_2D.this.dstRows.forward(t2, DoubleDST_2D.this.rows, scale);
                        } else {
                            DoubleDST_2D.this.dstRows.inverse(t2, 0, scale);
                            DoubleDST_2D.this.dstRows.inverse(t2, DoubleDST_2D.this.rows, scale);
                        }
                        for (r2 = 0; r2 < DoubleDST_2D.this.rows; ++r2) {
                            idx2 = r2;
                            a2[r2][2 * n0] = t2[idx2];
                            a2[r2][2 * n0 + 1] = t2[idx2 + DoubleDST_2D.this.rows];
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d0_subth(final int isgn, final double[] a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int r2 = n0; r2 < DoubleDST_2D.this.rows; r2 += nthreads) {
                            DoubleDST_2D.this.dstColumns.forward(a2, r2 * DoubleDST_2D.this.columns, scale);
                        }
                    } else {
                        for (int r3 = n0; r3 < DoubleDST_2D.this.rows; r3 += nthreads) {
                            DoubleDST_2D.this.dstColumns.inverse(a2, r3 * DoubleDST_2D.this.columns, scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d0_subth(final int isgn, final DoubleLargeArray a2, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final long n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (long r2 = n0; r2 < DoubleDST_2D.this.rowsl; r2 += (long)nthreads) {
                            DoubleDST_2D.this.dstColumns.forward(a2, r2 * DoubleDST_2D.this.columnsl, scale);
                        }
                    } else {
                        for (long r3 = n0; r3 < (long)DoubleDST_2D.this.rows; r3 += (long)nthreads) {
                            DoubleDST_2D.this.dstColumns.inverse(a2, r3 * DoubleDST_2D.this.columnsl, scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d0_subth(final int isgn, final double[][] a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int r2 = n0; r2 < DoubleDST_2D.this.rows; r2 += nthreads) {
                            DoubleDST_2D.this.dstColumns.forward(a2[r2], scale);
                        }
                    } else {
                        for (int r3 = n0; r3 < DoubleDST_2D.this.rows; r3 += nthreads) {
                            DoubleDST_2D.this.dstColumns.inverse(a2[r3], scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d_sub(int isgn, double[] a2, boolean scale) {
        block16: {
            int idx1;
            int r2;
            double[] t2;
            block15: {
                int nt = 4 * this.rows;
                if (this.columns == 2) {
                    nt >>= 1;
                } else if (this.columns < 2) {
                    nt >>= 2;
                }
                t2 = new double[nt];
                if (this.columns <= 2) break block15;
                if (isgn == -1) {
                    for (int c2 = 0; c2 < this.columns; c2 += 4) {
                        int idx2;
                        int idx12;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx12 = r3 * this.columns + c2;
                            idx2 = this.rows + r3;
                            t2[r3] = a2[idx12];
                            t2[idx2] = a2[idx12 + 1];
                            t2[idx2 + this.rows] = a2[idx12 + 2];
                            t2[idx2 + 2 * this.rows] = a2[idx12 + 3];
                        }
                        this.dstRows.forward(t2, 0, scale);
                        this.dstRows.forward(t2, this.rows, scale);
                        this.dstRows.forward(t2, 2 * this.rows, scale);
                        this.dstRows.forward(t2, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx12 = r3 * this.columns + c2;
                            idx2 = this.rows + r3;
                            a2[idx12] = t2[r3];
                            a2[idx12 + 1] = t2[idx2];
                            a2[idx12 + 2] = t2[idx2 + this.rows];
                            a2[idx12 + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int c3 = 0; c3 < this.columns; c3 += 4) {
                        int idx2;
                        int idx13;
                        int r4;
                        for (r4 = 0; r4 < this.rows; ++r4) {
                            idx13 = r4 * this.columns + c3;
                            idx2 = this.rows + r4;
                            t2[r4] = a2[idx13];
                            t2[idx2] = a2[idx13 + 1];
                            t2[idx2 + this.rows] = a2[idx13 + 2];
                            t2[idx2 + 2 * this.rows] = a2[idx13 + 3];
                        }
                        this.dstRows.inverse(t2, 0, scale);
                        this.dstRows.inverse(t2, this.rows, scale);
                        this.dstRows.inverse(t2, 2 * this.rows, scale);
                        this.dstRows.inverse(t2, 3 * this.rows, scale);
                        for (r4 = 0; r4 < this.rows; ++r4) {
                            idx13 = r4 * this.columns + c3;
                            idx2 = this.rows + r4;
                            a2[idx13] = t2[r4];
                            a2[idx13 + 1] = t2[idx2];
                            a2[idx13 + 2] = t2[idx2 + this.rows];
                            a2[idx13 + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                }
                break block16;
            }
            if (this.columns != 2) break block16;
            for (r2 = 0; r2 < this.rows; ++r2) {
                idx1 = r2 * this.columns;
                t2[r2] = a2[idx1];
                t2[this.rows + r2] = a2[idx1 + 1];
            }
            if (isgn == -1) {
                this.dstRows.forward(t2, 0, scale);
                this.dstRows.forward(t2, this.rows, scale);
            } else {
                this.dstRows.inverse(t2, 0, scale);
                this.dstRows.inverse(t2, this.rows, scale);
            }
            for (r2 = 0; r2 < this.rows; ++r2) {
                idx1 = r2 * this.columns;
                a2[idx1] = t2[r2];
                a2[idx1 + 1] = t2[this.rows + r2];
            }
        }
    }

    private void ddxt2d_sub(int isgn, DoubleLargeArray a2, boolean scale) {
        block16: {
            long idx1;
            long r2;
            DoubleLargeArray t2;
            block15: {
                long nt = 4L * this.rowsl;
                if (this.columnsl == 2L) {
                    nt >>= 1;
                } else if (this.columnsl < 2L) {
                    nt >>= 2;
                }
                t2 = new DoubleLargeArray(nt);
                if (this.columnsl <= 2L) break block15;
                if (isgn == -1) {
                    for (long c2 = 0L; c2 < this.columnsl; c2 += 4L) {
                        long idx2;
                        long idx12;
                        long r3;
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx12 = r3 * this.columnsl + c2;
                            idx2 = this.rowsl + r3;
                            t2.setDouble(r3, a2.getDouble(idx12));
                            t2.setDouble(idx2, a2.getDouble(idx12 + 1L));
                            t2.setDouble(idx2 + this.rowsl, a2.getDouble(idx12 + 2L));
                            t2.setDouble(idx2 + 2L * this.rowsl, a2.getDouble(idx12 + 3L));
                        }
                        this.dstRows.forward(t2, 0L, scale);
                        this.dstRows.forward(t2, this.rowsl, scale);
                        this.dstRows.forward(t2, 2L * this.rowsl, scale);
                        this.dstRows.forward(t2, 3L * this.rowsl, scale);
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx12 = r3 * this.columnsl + c2;
                            idx2 = this.rowsl + r3;
                            a2.setDouble(idx12, t2.getDouble(r3));
                            a2.setDouble(idx12 + 1L, t2.getDouble(idx2));
                            a2.setDouble(idx12 + 2L, t2.getDouble(idx2 + this.rowsl));
                            a2.setDouble(idx12 + 3L, t2.getDouble(idx2 + 2L * this.rowsl));
                        }
                    }
                } else {
                    for (long c3 = 0L; c3 < this.columnsl; c3 += 4L) {
                        long idx2;
                        long idx13;
                        long r4;
                        for (r4 = 0L; r4 < this.rowsl; ++r4) {
                            idx13 = r4 * this.columnsl + c3;
                            idx2 = this.rowsl + r4;
                            t2.setDouble(r4, a2.getDouble(idx13));
                            t2.setDouble(idx2, a2.getDouble(idx13 + 1L));
                            t2.setDouble(idx2 + this.rowsl, a2.getDouble(idx13 + 2L));
                            t2.setDouble(idx2 + 2L * this.rowsl, a2.getDouble(idx13 + 3L));
                        }
                        this.dstRows.inverse(t2, 0L, scale);
                        this.dstRows.inverse(t2, this.rowsl, scale);
                        this.dstRows.inverse(t2, 2L * this.rowsl, scale);
                        this.dstRows.inverse(t2, 3L * this.rowsl, scale);
                        for (r4 = 0L; r4 < this.rowsl; ++r4) {
                            idx13 = r4 * this.columnsl + c3;
                            idx2 = this.rowsl + r4;
                            a2.setDouble(idx13, t2.getDouble(r4));
                            a2.setDouble(idx13 + 1L, t2.getDouble(idx2));
                            a2.setDouble(idx13 + 2L, t2.getDouble(idx2 + this.rowsl));
                            a2.setDouble(idx13 + 3L, t2.getDouble(idx2 + 2L * this.rowsl));
                        }
                    }
                }
                break block16;
            }
            if (this.columnsl != 2L) break block16;
            for (r2 = 0L; r2 < this.rowsl; ++r2) {
                idx1 = r2 * this.columnsl;
                t2.setDouble(r2, a2.getDouble(idx1));
                t2.setDouble(this.rowsl + r2, a2.getDouble(idx1 + 1L));
            }
            if (isgn == -1) {
                this.dstRows.forward(t2, 0L, scale);
                this.dstRows.forward(t2, this.rowsl, scale);
            } else {
                this.dstRows.inverse(t2, 0L, scale);
                this.dstRows.inverse(t2, this.rowsl, scale);
            }
            for (r2 = 0L; r2 < this.rowsl; ++r2) {
                idx1 = r2 * this.columnsl;
                a2.setDouble(idx1, t2.getDouble(r2));
                a2.setDouble(idx1 + 1L, t2.getDouble(this.rowsl + r2));
            }
        }
    }

    private void ddxt2d_sub(int isgn, double[][] a2, boolean scale) {
        block16: {
            int r2;
            double[] t2;
            block15: {
                int nt = 4 * this.rows;
                if (this.columns == 2) {
                    nt >>= 1;
                } else if (this.columns < 2) {
                    nt >>= 2;
                }
                t2 = new double[nt];
                if (this.columns <= 2) break block15;
                if (isgn == -1) {
                    for (int c2 = 0; c2 < this.columns; c2 += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            t2[r3] = a2[r3][c2];
                            t2[idx2] = a2[r3][c2 + 1];
                            t2[idx2 + this.rows] = a2[r3][c2 + 2];
                            t2[idx2 + 2 * this.rows] = a2[r3][c2 + 3];
                        }
                        this.dstRows.forward(t2, 0, scale);
                        this.dstRows.forward(t2, this.rows, scale);
                        this.dstRows.forward(t2, 2 * this.rows, scale);
                        this.dstRows.forward(t2, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            a2[r3][c2] = t2[r3];
                            a2[r3][c2 + 1] = t2[idx2];
                            a2[r3][c2 + 2] = t2[idx2 + this.rows];
                            a2[r3][c2 + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int c3 = 0; c3 < this.columns; c3 += 4) {
                        int idx2;
                        int r4;
                        for (r4 = 0; r4 < this.rows; ++r4) {
                            idx2 = this.rows + r4;
                            t2[r4] = a2[r4][c3];
                            t2[idx2] = a2[r4][c3 + 1];
                            t2[idx2 + this.rows] = a2[r4][c3 + 2];
                            t2[idx2 + 2 * this.rows] = a2[r4][c3 + 3];
                        }
                        this.dstRows.inverse(t2, 0, scale);
                        this.dstRows.inverse(t2, this.rows, scale);
                        this.dstRows.inverse(t2, 2 * this.rows, scale);
                        this.dstRows.inverse(t2, 3 * this.rows, scale);
                        for (r4 = 0; r4 < this.rows; ++r4) {
                            idx2 = this.rows + r4;
                            a2[r4][c3] = t2[r4];
                            a2[r4][c3 + 1] = t2[idx2];
                            a2[r4][c3 + 2] = t2[idx2 + this.rows];
                            a2[r4][c3 + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                }
                break block16;
            }
            if (this.columns != 2) break block16;
            for (r2 = 0; r2 < this.rows; ++r2) {
                t2[r2] = a2[r2][0];
                t2[this.rows + r2] = a2[r2][1];
            }
            if (isgn == -1) {
                this.dstRows.forward(t2, 0, scale);
                this.dstRows.forward(t2, this.rows, scale);
            } else {
                this.dstRows.inverse(t2, 0, scale);
                this.dstRows.inverse(t2, this.rows, scale);
            }
            for (r2 = 0; r2 < this.rows; ++r2) {
                a2[r2][0] = t2[r2];
                a2[r2][1] = t2[this.rows + r2];
            }
        }
    }
}

