/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dst;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jtransforms.dst.DoubleDST_1D;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;

public class DoubleDST_3D {
    private int slices;
    private long slicesl;
    private int rows;
    private long rowsl;
    private int columns;
    private long columnsl;
    private int sliceStride;
    private long sliceStridel;
    private int rowStride;
    private long rowStridel;
    private DoubleDST_1D dstSlices;
    private DoubleDST_1D dstRows;
    private DoubleDST_1D dstColumns;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleDST_3D(long slices, long rows, long columns) {
        if (slices <= 1L || rows <= 1L || columns <= 1L) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = (int)slices;
        this.rows = (int)rows;
        this.columns = (int)columns;
        this.slicesl = slices;
        this.rowsl = rows;
        this.columnsl = columns;
        this.sliceStride = (int)(rows * columns);
        this.rowStride = (int)columns;
        this.sliceStridel = rows * columns;
        this.rowStridel = columns;
        if (slices * rows * columns >= CommonUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (CommonUtils.isPowerOf2(slices) && CommonUtils.isPowerOf2(rows) && CommonUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
        }
        CommonUtils.setUseLargeArrays(slices * rows * columns > (long)LargeArray.getMaxSizeOf32bitArray());
        this.dstSlices = new DoubleDST_1D(slices);
        this.dstRows = slices == rows ? this.dstSlices : new DoubleDST_1D(rows);
        this.dstColumns = slices == columns ? this.dstSlices : (rows == columns ? this.dstRows : new DoubleDST_1D(columns));
    }

    public void forward(final double[] a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a2, scale);
                this.ddxt3db_subth(-1, a2, scale);
            } else {
                this.ddxt3da_sub(-1, a2, scale);
                this.ddxt3db_sub(-1, a2, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p2 = this.slices / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstSlice = l2 * p2;
                lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * DoubleDST_3D.this.sliceStride;
                            for (int r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                DoubleDST_3D.this.dstColumns.forward(a2, idx1 + r2 * DoubleDST_3D.this.rowStride, scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = l3 * p2;
                lastSlice = l3 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * DoubleDST_3D.this.sliceStride;
                            for (int c2 = 0; c2 < DoubleDST_3D.this.columns; ++c2) {
                                int idx3;
                                int r2;
                                for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                    idx3 = idx1 + r2 * DoubleDST_3D.this.rowStride + c2;
                                    temp[r2] = a2[idx3];
                                }
                                DoubleDST_3D.this.dstRows.forward(temp, scale);
                                for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                    idx3 = idx1 + r2 * DoubleDST_3D.this.rowStride + c2;
                                    a2[idx3] = temp[r2];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.rows / nthreads;
            for (int l4 = 0; l4 < nthreads; ++l4) {
                final int firstRow = l4 * p2;
                final int lastRow = l4 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.slices];
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            int idx1 = r2 * DoubleDST_3D.this.rowStride;
                            for (int c2 = 0; c2 < DoubleDST_3D.this.columns; ++c2) {
                                int idx3;
                                int s2;
                                for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                    idx3 = s2 * DoubleDST_3D.this.sliceStride + idx1 + c2;
                                    temp[s2] = a2[idx3];
                                }
                                DoubleDST_3D.this.dstSlices.forward(temp, scale);
                                for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                    idx3 = s2 * DoubleDST_3D.this.sliceStride + idx1 + c2;
                                    a2[idx3] = temp[s2];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx3;
            int c2;
            int idx1;
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int idx12 = s2 * this.sliceStride;
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    this.dstColumns.forward(a2, idx12 + r2 * this.rowStride, scale);
                }
            }
            double[] temp = new double[this.rows];
            for (int s3 = 0; s3 < this.slices; ++s3) {
                idx1 = s3 * this.sliceStride;
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int r3;
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        idx3 = idx1 + r3 * this.rowStride + c2;
                        temp[r3] = a2[idx3];
                    }
                    this.dstRows.forward(temp, scale);
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        idx3 = idx1 + r3 * this.rowStride + c2;
                        a2[idx3] = temp[r3];
                    }
                }
            }
            temp = new double[this.slices];
            for (int r4 = 0; r4 < this.rows; ++r4) {
                idx1 = r4 * this.rowStride;
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int s4;
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx3 = s4 * this.sliceStride + idx1 + c2;
                        temp[s4] = a2[idx3];
                    }
                    this.dstSlices.forward(temp, scale);
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx3 = s4 * this.sliceStride + idx1 + c2;
                        a2[idx3] = temp[s4];
                    }
                }
            }
        }
    }

    public void forward(final DoubleLargeArray a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a2, scale);
                this.ddxt3db_subth(-1, a2, scale);
            } else {
                this.ddxt3da_sub(-1, a2, scale);
                this.ddxt3db_sub(-1, a2, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
            long lastSlice;
            long firstSlice;
            Future[] futures = new Future[nthreads];
            long p2 = this.slicesl / (long)nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstSlice = (long)l2 * p2;
                lastSlice = l2 == nthreads - 1 ? this.slicesl : firstSlice + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * DoubleDST_3D.this.sliceStridel;
                            for (long r2 = 0L; r2 < DoubleDST_3D.this.rowsl; ++r2) {
                                DoubleDST_3D.this.dstColumns.forward(a2, idx1 + r2 * DoubleDST_3D.this.rowStridel, scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = (long)l3 * p2;
                lastSlice = l3 == nthreads - 1 ? this.slicesl : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(DoubleDST_3D.this.rowsl, false);
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * DoubleDST_3D.this.sliceStridel;
                            for (long c2 = 0L; c2 < DoubleDST_3D.this.columnsl; ++c2) {
                                long idx3;
                                long r2;
                                for (r2 = 0L; r2 < DoubleDST_3D.this.rowsl; ++r2) {
                                    idx3 = idx1 + r2 * DoubleDST_3D.this.rowStridel + c2;
                                    temp.setDouble(r2, a2.getDouble(idx3));
                                }
                                DoubleDST_3D.this.dstRows.forward(temp, scale);
                                for (r2 = 0L; r2 < DoubleDST_3D.this.rowsl; ++r2) {
                                    idx3 = idx1 + r2 * DoubleDST_3D.this.rowStridel + c2;
                                    a2.setDouble(idx3, temp.getDouble(r2));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.rowsl / (long)nthreads;
            for (int l4 = 0; l4 < nthreads; ++l4) {
                final long firstRow = (long)l4 * p2;
                final long lastRow = l4 == nthreads - 1 ? this.rowsl : firstRow + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(DoubleDST_3D.this.slicesl, false);
                        for (long r2 = firstRow; r2 < lastRow; ++r2) {
                            long idx1 = r2 * DoubleDST_3D.this.rowStridel;
                            for (long c2 = 0L; c2 < DoubleDST_3D.this.columnsl; ++c2) {
                                long idx3;
                                long s2;
                                for (s2 = 0L; s2 < DoubleDST_3D.this.slicesl; ++s2) {
                                    idx3 = s2 * DoubleDST_3D.this.sliceStridel + idx1 + c2;
                                    temp.setDouble(s2, a2.getDouble(idx3));
                                }
                                DoubleDST_3D.this.dstSlices.forward(temp, scale);
                                for (s2 = 0L; s2 < DoubleDST_3D.this.slicesl; ++s2) {
                                    idx3 = s2 * DoubleDST_3D.this.sliceStridel + idx1 + c2;
                                    a2.setDouble(idx3, temp.getDouble(s2));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx3;
            long c2;
            long idx1;
            for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                long idx12 = s2 * this.sliceStridel;
                for (long r2 = 0L; r2 < this.rowsl; ++r2) {
                    this.dstColumns.forward(a2, idx12 + r2 * this.rowStridel, scale);
                }
            }
            DoubleLargeArray temp = new DoubleLargeArray(this.rowsl, false);
            for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                idx1 = s3 * this.sliceStridel;
                for (c2 = 0L; c2 < this.columnsl; ++c2) {
                    long r3;
                    for (r3 = 0L; r3 < this.rowsl; ++r3) {
                        idx3 = idx1 + r3 * this.rowStridel + c2;
                        temp.setDouble(r3, a2.getDouble(idx3));
                    }
                    this.dstRows.forward(temp, scale);
                    for (r3 = 0L; r3 < this.rowsl; ++r3) {
                        idx3 = idx1 + r3 * this.rowStridel + c2;
                        a2.setDouble(idx3, temp.getDouble(r3));
                    }
                }
            }
            temp = new DoubleLargeArray(this.slicesl, false);
            for (long r4 = 0L; r4 < this.rowsl; ++r4) {
                idx1 = r4 * this.rowStridel;
                for (c2 = 0L; c2 < this.columnsl; ++c2) {
                    long s4;
                    for (s4 = 0L; s4 < this.slicesl; ++s4) {
                        idx3 = s4 * this.sliceStridel + idx1 + c2;
                        temp.setDouble(s4, a2.getDouble(idx3));
                    }
                    this.dstSlices.forward(temp, scale);
                    for (s4 = 0L; s4 < this.slicesl; ++s4) {
                        idx3 = s4 * this.sliceStridel + idx1 + c2;
                        a2.setDouble(idx3, temp.getDouble(s4));
                    }
                }
            }
        }
    }

    public void forward(final double[][][] a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a2, scale);
                this.ddxt3db_subth(-1, a2, scale);
            } else {
                this.ddxt3da_sub(-1, a2, scale);
                this.ddxt3db_sub(-1, a2, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p2 = this.slices / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstSlice = l2 * p2;
                lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                DoubleDST_3D.this.dstColumns.forward(a2[s2][r2], scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = l3 * p2;
                lastSlice = l3 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int c2 = 0; c2 < DoubleDST_3D.this.columns; ++c2) {
                                int r2;
                                for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                    temp[r2] = a2[s2][r2][c2];
                                }
                                DoubleDST_3D.this.dstRows.forward(temp, scale);
                                for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                    a2[s2][r2][c2] = temp[r2];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.rows / nthreads;
            for (int l4 = 0; l4 < nthreads; ++l4) {
                final int firstRow = l4 * p2;
                final int lastRow = l4 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.slices];
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            for (int c2 = 0; c2 < DoubleDST_3D.this.columns; ++c2) {
                                int s2;
                                for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                    temp[s2] = a2[s2][r2][c2];
                                }
                                DoubleDST_3D.this.dstSlices.forward(temp, scale);
                                for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                    a2[s2][r2][c2] = temp[s2];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int c2;
            int r2;
            for (int s2 = 0; s2 < this.slices; ++s2) {
                for (r2 = 0; r2 < this.rows; ++r2) {
                    this.dstColumns.forward(a2[s2][r2], scale);
                }
            }
            double[] temp = new double[this.rows];
            for (int s3 = 0; s3 < this.slices; ++s3) {
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int r3;
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        temp[r3] = a2[s3][r3][c2];
                    }
                    this.dstRows.forward(temp, scale);
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        a2[s3][r3][c2] = temp[r3];
                    }
                }
            }
            temp = new double[this.slices];
            for (r2 = 0; r2 < this.rows; ++r2) {
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int s4;
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        temp[s4] = a2[s4][r2][c2];
                    }
                    this.dstSlices.forward(temp, scale);
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        a2[s4][r2][c2] = temp[s4];
                    }
                }
            }
        }
    }

    public void inverse(final double[] a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a2, scale);
                this.ddxt3db_subth(1, a2, scale);
            } else {
                this.ddxt3da_sub(1, a2, scale);
                this.ddxt3db_sub(1, a2, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p2 = this.slices / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstSlice = l2 * p2;
                lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * DoubleDST_3D.this.sliceStride;
                            for (int r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                DoubleDST_3D.this.dstColumns.inverse(a2, idx1 + r2 * DoubleDST_3D.this.rowStride, scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = l3 * p2;
                lastSlice = l3 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * DoubleDST_3D.this.sliceStride;
                            for (int c2 = 0; c2 < DoubleDST_3D.this.columns; ++c2) {
                                int idx3;
                                int r2;
                                for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                    idx3 = idx1 + r2 * DoubleDST_3D.this.rowStride + c2;
                                    temp[r2] = a2[idx3];
                                }
                                DoubleDST_3D.this.dstRows.inverse(temp, scale);
                                for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                    idx3 = idx1 + r2 * DoubleDST_3D.this.rowStride + c2;
                                    a2[idx3] = temp[r2];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.rows / nthreads;
            for (int l4 = 0; l4 < nthreads; ++l4) {
                final int firstRow = l4 * p2;
                final int lastRow = l4 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.slices];
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            int idx1 = r2 * DoubleDST_3D.this.rowStride;
                            for (int c2 = 0; c2 < DoubleDST_3D.this.columns; ++c2) {
                                int idx3;
                                int s2;
                                for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                    idx3 = s2 * DoubleDST_3D.this.sliceStride + idx1 + c2;
                                    temp[s2] = a2[idx3];
                                }
                                DoubleDST_3D.this.dstSlices.inverse(temp, scale);
                                for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                    idx3 = s2 * DoubleDST_3D.this.sliceStride + idx1 + c2;
                                    a2[idx3] = temp[s2];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx3;
            int c2;
            int idx1;
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int idx12 = s2 * this.sliceStride;
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    this.dstColumns.inverse(a2, idx12 + r2 * this.rowStride, scale);
                }
            }
            double[] temp = new double[this.rows];
            for (int s3 = 0; s3 < this.slices; ++s3) {
                idx1 = s3 * this.sliceStride;
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int r3;
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        idx3 = idx1 + r3 * this.rowStride + c2;
                        temp[r3] = a2[idx3];
                    }
                    this.dstRows.inverse(temp, scale);
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        idx3 = idx1 + r3 * this.rowStride + c2;
                        a2[idx3] = temp[r3];
                    }
                }
            }
            temp = new double[this.slices];
            for (int r4 = 0; r4 < this.rows; ++r4) {
                idx1 = r4 * this.rowStride;
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int s4;
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx3 = s4 * this.sliceStride + idx1 + c2;
                        temp[s4] = a2[idx3];
                    }
                    this.dstSlices.inverse(temp, scale);
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx3 = s4 * this.sliceStride + idx1 + c2;
                        a2[idx3] = temp[s4];
                    }
                }
            }
        }
    }

    public void inverse(final DoubleLargeArray a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a2, scale);
                this.ddxt3db_subth(1, a2, scale);
            } else {
                this.ddxt3da_sub(1, a2, scale);
                this.ddxt3db_sub(1, a2, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
            long lastSlice;
            long firstSlice;
            Future[] futures = new Future[nthreads];
            long p2 = this.slicesl / (long)nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstSlice = (long)l2 * p2;
                lastSlice = l2 == nthreads - 1 ? this.slicesl : firstSlice + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * (long)DoubleDST_3D.this.sliceStride;
                            for (long r2 = 0L; r2 < DoubleDST_3D.this.rowsl; ++r2) {
                                DoubleDST_3D.this.dstColumns.inverse(a2, idx1 + r2 * (long)DoubleDST_3D.this.rowStride, scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = (long)l3 * p2;
                lastSlice = l3 == nthreads - 1 ? this.slicesl : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(DoubleDST_3D.this.rowsl, false);
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * (long)DoubleDST_3D.this.sliceStride;
                            for (long c2 = 0L; c2 < DoubleDST_3D.this.columnsl; ++c2) {
                                long idx3;
                                long r2;
                                for (r2 = 0L; r2 < DoubleDST_3D.this.rowsl; ++r2) {
                                    idx3 = idx1 + r2 * (long)DoubleDST_3D.this.rowStride + c2;
                                    temp.setDouble(r2, a2.getDouble(idx3));
                                }
                                DoubleDST_3D.this.dstRows.inverse(temp, scale);
                                for (r2 = 0L; r2 < DoubleDST_3D.this.rowsl; ++r2) {
                                    idx3 = idx1 + r2 * (long)DoubleDST_3D.this.rowStride + c2;
                                    a2.setDouble(idx3, temp.getDouble(r2));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.rowsl / (long)nthreads;
            for (int l4 = 0; l4 < nthreads; ++l4) {
                final long firstRow = (long)l4 * p2;
                final long lastRow = l4 == nthreads - 1 ? this.rowsl : firstRow + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(DoubleDST_3D.this.slicesl, false);
                        for (long r2 = firstRow; r2 < lastRow; ++r2) {
                            long idx1 = r2 * (long)DoubleDST_3D.this.rowStride;
                            for (long c2 = 0L; c2 < DoubleDST_3D.this.columnsl; ++c2) {
                                long idx3;
                                long s2;
                                for (s2 = 0L; s2 < DoubleDST_3D.this.slicesl; ++s2) {
                                    idx3 = s2 * (long)DoubleDST_3D.this.sliceStride + idx1 + c2;
                                    temp.setDouble(s2, a2.getDouble(idx3));
                                }
                                DoubleDST_3D.this.dstSlices.inverse(temp, scale);
                                for (s2 = 0L; s2 < DoubleDST_3D.this.slicesl; ++s2) {
                                    idx3 = s2 * (long)DoubleDST_3D.this.sliceStride + idx1 + c2;
                                    a2.setDouble(idx3, temp.getDouble(s2));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx3;
            long c2;
            long idx1;
            for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                long idx12 = s2 * (long)this.sliceStride;
                for (long r2 = 0L; r2 < this.rowsl; ++r2) {
                    this.dstColumns.inverse(a2, idx12 + r2 * (long)this.rowStride, scale);
                }
            }
            DoubleLargeArray temp = new DoubleLargeArray(this.rowsl, false);
            for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                idx1 = s3 * (long)this.sliceStride;
                for (c2 = 0L; c2 < this.columnsl; ++c2) {
                    long r3;
                    for (r3 = 0L; r3 < this.rowsl; ++r3) {
                        idx3 = idx1 + r3 * (long)this.rowStride + c2;
                        temp.setDouble(r3, a2.getDouble(idx3));
                    }
                    this.dstRows.inverse(temp, scale);
                    for (r3 = 0L; r3 < this.rowsl; ++r3) {
                        idx3 = idx1 + r3 * (long)this.rowStride + c2;
                        a2.setDouble(idx3, temp.getDouble(r3));
                    }
                }
            }
            temp = new DoubleLargeArray(this.slicesl, false);
            for (long r4 = 0L; r4 < this.rowsl; ++r4) {
                idx1 = r4 * (long)this.rowStride;
                for (c2 = 0L; c2 < this.columnsl; ++c2) {
                    long s4;
                    for (s4 = 0L; s4 < this.slicesl; ++s4) {
                        idx3 = s4 * (long)this.sliceStride + idx1 + c2;
                        temp.setDouble(s4, a2.getDouble(idx3));
                    }
                    this.dstSlices.inverse(temp, scale);
                    for (s4 = 0L; s4 < this.slicesl; ++s4) {
                        idx3 = s4 * (long)this.sliceStride + idx1 + c2;
                        a2.setDouble(idx3, temp.getDouble(s4));
                    }
                }
            }
        }
    }

    public void inverse(final double[][][] a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a2, scale);
                this.ddxt3db_subth(1, a2, scale);
            } else {
                this.ddxt3da_sub(1, a2, scale);
                this.ddxt3db_sub(1, a2, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p2 = this.slices / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstSlice = l2 * p2;
                lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                DoubleDST_3D.this.dstColumns.inverse(a2[s2][r2], scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = l3 * p2;
                lastSlice = l3 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int c2 = 0; c2 < DoubleDST_3D.this.columns; ++c2) {
                                int r2;
                                for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                    temp[r2] = a2[s2][r2][c2];
                                }
                                DoubleDST_3D.this.dstRows.inverse(temp, scale);
                                for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                    a2[s2][r2][c2] = temp[r2];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.rows / nthreads;
            for (int l4 = 0; l4 < nthreads; ++l4) {
                final int firstRow = l4 * p2;
                final int lastRow = l4 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.slices];
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            for (int c2 = 0; c2 < DoubleDST_3D.this.columns; ++c2) {
                                int s2;
                                for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                    temp[s2] = a2[s2][r2][c2];
                                }
                                DoubleDST_3D.this.dstSlices.inverse(temp, scale);
                                for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                    a2[s2][r2][c2] = temp[s2];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int c2;
            int r2;
            for (int s2 = 0; s2 < this.slices; ++s2) {
                for (r2 = 0; r2 < this.rows; ++r2) {
                    this.dstColumns.inverse(a2[s2][r2], scale);
                }
            }
            double[] temp = new double[this.rows];
            for (int s3 = 0; s3 < this.slices; ++s3) {
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int r3;
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        temp[r3] = a2[s3][r3][c2];
                    }
                    this.dstRows.inverse(temp, scale);
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        a2[s3][r3][c2] = temp[r3];
                    }
                }
            }
            temp = new double[this.slices];
            for (r2 = 0; r2 < this.rows; ++r2) {
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int s4;
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        temp[s4] = a2[s4][r2][c2];
                    }
                    this.dstSlices.inverse(temp, scale);
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        a2[s4][r2][c2] = temp[s4];
                    }
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, double[] a2, boolean scale) {
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        double[] t2 = new double[nt];
        if (isgn == -1) {
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int idx1;
                int r2;
                int idx0 = s2 * this.sliceStride;
                for (r2 = 0; r2 < this.rows; ++r2) {
                    this.dstColumns.forward(a2, idx0 + r2 * this.rowStride, scale);
                }
                if (this.columns > 2) {
                    for (int c2 = 0; c2 < this.columns; c2 += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c2;
                            idx2 = this.rows + r3;
                            t2[r3] = a2[idx1];
                            t2[idx2] = a2[idx1 + 1];
                            t2[idx2 + this.rows] = a2[idx1 + 2];
                            t2[idx2 + 2 * this.rows] = a2[idx1 + 3];
                        }
                        this.dstRows.forward(t2, 0, scale);
                        this.dstRows.forward(t2, this.rows, scale);
                        this.dstRows.forward(t2, 2 * this.rows, scale);
                        this.dstRows.forward(t2, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c2;
                            idx2 = this.rows + r3;
                            a2[idx1] = t2[r3];
                            a2[idx1 + 1] = t2[idx2];
                            a2[idx1 + 2] = t2[idx2 + this.rows];
                            a2[idx1 + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r2 = 0; r2 < this.rows; ++r2) {
                    idx1 = idx0 + r2 * this.rowStride;
                    t2[r2] = a2[idx1];
                    t2[this.rows + r2] = a2[idx1 + 1];
                }
                this.dstRows.forward(t2, 0, scale);
                this.dstRows.forward(t2, this.rows, scale);
                for (r2 = 0; r2 < this.rows; ++r2) {
                    idx1 = idx0 + r2 * this.rowStride;
                    a2[idx1] = t2[r2];
                    a2[idx1 + 1] = t2[this.rows + r2];
                }
            }
        } else {
            for (int s3 = 0; s3 < this.slices; ++s3) {
                int idx1;
                int r4;
                int idx0 = s3 * this.sliceStride;
                for (r4 = 0; r4 < this.rows; ++r4) {
                    this.dstColumns.inverse(a2, idx0 + r4 * this.rowStride, scale);
                }
                if (this.columns > 2) {
                    for (int c3 = 0; c3 < this.columns; c3 += 4) {
                        int idx2;
                        int r5;
                        for (r5 = 0; r5 < this.rows; ++r5) {
                            idx1 = idx0 + r5 * this.rowStride + c3;
                            idx2 = this.rows + r5;
                            t2[r5] = a2[idx1];
                            t2[idx2] = a2[idx1 + 1];
                            t2[idx2 + this.rows] = a2[idx1 + 2];
                            t2[idx2 + 2 * this.rows] = a2[idx1 + 3];
                        }
                        this.dstRows.inverse(t2, 0, scale);
                        this.dstRows.inverse(t2, this.rows, scale);
                        this.dstRows.inverse(t2, 2 * this.rows, scale);
                        this.dstRows.inverse(t2, 3 * this.rows, scale);
                        for (r5 = 0; r5 < this.rows; ++r5) {
                            idx1 = idx0 + r5 * this.rowStride + c3;
                            idx2 = this.rows + r5;
                            a2[idx1] = t2[r5];
                            a2[idx1 + 1] = t2[idx2];
                            a2[idx1 + 2] = t2[idx2 + this.rows];
                            a2[idx1 + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r4 = 0; r4 < this.rows; ++r4) {
                    idx1 = idx0 + r4 * this.rowStride;
                    t2[r4] = a2[idx1];
                    t2[this.rows + r4] = a2[idx1 + 1];
                }
                this.dstRows.inverse(t2, 0, scale);
                this.dstRows.inverse(t2, this.rows, scale);
                for (r4 = 0; r4 < this.rows; ++r4) {
                    idx1 = idx0 + r4 * this.rowStride;
                    a2[idx1] = t2[r4];
                    a2[idx1 + 1] = t2[this.rows + r4];
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, DoubleLargeArray a2, boolean scale) {
        long nt = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        DoubleLargeArray t2 = new DoubleLargeArray(nt);
        if (isgn == -1) {
            for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                long idx1;
                long r2;
                long idx0 = s2 * this.sliceStridel;
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    this.dstColumns.forward(a2, idx0 + r2 * (long)this.rowStride, scale);
                }
                if (this.columnsl > 2L) {
                    for (long c2 = 0L; c2 < this.columnsl; c2 += 4L) {
                        long idx2;
                        long r3;
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c2;
                            idx2 = this.rowsl + r3;
                            t2.setDouble(r3, a2.getDouble(idx1));
                            t2.setDouble(idx2, a2.getDouble(idx1 + 1L));
                            t2.setDouble(idx2 + this.rowsl, a2.getDouble(idx1 + 2L));
                            t2.setDouble(idx2 + 2L * this.rowsl, a2.getDouble(idx1 + 3L));
                        }
                        this.dstRows.forward(t2, 0L, scale);
                        this.dstRows.forward(t2, this.rowsl, scale);
                        this.dstRows.forward(t2, 2L * this.rowsl, scale);
                        this.dstRows.forward(t2, 3L * this.rowsl, scale);
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c2;
                            idx2 = this.rowsl + r3;
                            a2.setDouble(idx1, t2.getDouble(r3));
                            a2.setDouble(idx1 + 1L, t2.getDouble(idx2));
                            a2.setDouble(idx1 + 2L, t2.getDouble(idx2 + this.rowsl));
                            a2.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    idx1 = idx0 + r2 * this.rowStridel;
                    t2.setDouble(r2, a2.getDouble(idx1));
                    t2.setDouble(this.rowsl + r2, a2.getDouble(idx1 + 1L));
                }
                this.dstRows.forward(t2, 0L, scale);
                this.dstRows.forward(t2, this.rowsl, scale);
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    idx1 = idx0 + r2 * this.rowStridel;
                    a2.setDouble(idx1, t2.getDouble(r2));
                    a2.setDouble(idx1 + 1L, t2.getDouble(this.rowsl + r2));
                }
            }
        } else {
            for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                long idx1;
                long r4;
                long idx0 = s3 * this.sliceStridel;
                for (r4 = 0L; r4 < this.rowsl; ++r4) {
                    this.dstColumns.inverse(a2, idx0 + r4 * this.rowStridel, scale);
                }
                if (this.columnsl > 2L) {
                    for (long c3 = 0L; c3 < this.columnsl; c3 += 4L) {
                        long idx2;
                        long r5;
                        for (r5 = 0L; r5 < this.rowsl; ++r5) {
                            idx1 = idx0 + r5 * this.rowStridel + c3;
                            idx2 = this.rowsl + r5;
                            t2.setDouble(r5, a2.getDouble(idx1));
                            t2.setDouble(idx2, a2.getDouble(idx1 + 1L));
                            t2.setDouble(idx2 + this.rowsl, a2.getDouble(idx1 + 2L));
                            t2.setDouble(idx2 + 2L * this.rowsl, a2.getDouble(idx1 + 3L));
                        }
                        this.dstRows.inverse(t2, 0L, scale);
                        this.dstRows.inverse(t2, this.rowsl, scale);
                        this.dstRows.inverse(t2, 2L * this.rowsl, scale);
                        this.dstRows.inverse(t2, 3L * this.rowsl, scale);
                        for (r5 = 0L; r5 < this.rowsl; ++r5) {
                            idx1 = idx0 + r5 * this.rowStridel + c3;
                            idx2 = this.rowsl + r5;
                            a2.setDouble(idx1, t2.getDouble(r5));
                            a2.setDouble(idx1 + 1L, t2.getDouble(idx2));
                            a2.setDouble(idx1 + 2L, t2.getDouble(idx2 + this.rowsl));
                            a2.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r4 = 0L; r4 < this.rowsl; ++r4) {
                    idx1 = idx0 + r4 * this.rowStridel;
                    t2.setDouble(r4, a2.getDouble(idx1));
                    t2.setDouble(this.rowsl + r4, a2.getDouble(idx1 + 1L));
                }
                this.dstRows.inverse(t2, 0L, scale);
                this.dstRows.inverse(t2, this.rowsl, scale);
                for (r4 = 0L; r4 < this.rowsl; ++r4) {
                    idx1 = idx0 + r4 * this.rowStridel;
                    a2.setDouble(idx1, t2.getDouble(r4));
                    a2.setDouble(idx1 + 1L, t2.getDouble(this.rowsl + r4));
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, double[][][] a2, boolean scale) {
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        double[] t2 = new double[nt];
        if (isgn == -1) {
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int r2;
                for (r2 = 0; r2 < this.rows; ++r2) {
                    this.dstColumns.forward(a2[s2][r2], scale);
                }
                if (this.columns > 2) {
                    for (int c2 = 0; c2 < this.columns; c2 += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            t2[r3] = a2[s2][r3][c2];
                            t2[idx2] = a2[s2][r3][c2 + 1];
                            t2[idx2 + this.rows] = a2[s2][r3][c2 + 2];
                            t2[idx2 + 2 * this.rows] = a2[s2][r3][c2 + 3];
                        }
                        this.dstRows.forward(t2, 0, scale);
                        this.dstRows.forward(t2, this.rows, scale);
                        this.dstRows.forward(t2, 2 * this.rows, scale);
                        this.dstRows.forward(t2, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            a2[s2][r3][c2] = t2[r3];
                            a2[s2][r3][c2 + 1] = t2[idx2];
                            a2[s2][r3][c2 + 2] = t2[idx2 + this.rows];
                            a2[s2][r3][c2 + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r2 = 0; r2 < this.rows; ++r2) {
                    t2[r2] = a2[s2][r2][0];
                    t2[this.rows + r2] = a2[s2][r2][1];
                }
                this.dstRows.forward(t2, 0, scale);
                this.dstRows.forward(t2, this.rows, scale);
                for (r2 = 0; r2 < this.rows; ++r2) {
                    a2[s2][r2][0] = t2[r2];
                    a2[s2][r2][1] = t2[this.rows + r2];
                }
            }
        } else {
            for (int s3 = 0; s3 < this.slices; ++s3) {
                int r4;
                for (r4 = 0; r4 < this.rows; ++r4) {
                    this.dstColumns.inverse(a2[s3][r4], scale);
                }
                if (this.columns > 2) {
                    for (int c3 = 0; c3 < this.columns; c3 += 4) {
                        int idx2;
                        int r5;
                        for (r5 = 0; r5 < this.rows; ++r5) {
                            idx2 = this.rows + r5;
                            t2[r5] = a2[s3][r5][c3];
                            t2[idx2] = a2[s3][r5][c3 + 1];
                            t2[idx2 + this.rows] = a2[s3][r5][c3 + 2];
                            t2[idx2 + 2 * this.rows] = a2[s3][r5][c3 + 3];
                        }
                        this.dstRows.inverse(t2, 0, scale);
                        this.dstRows.inverse(t2, this.rows, scale);
                        this.dstRows.inverse(t2, 2 * this.rows, scale);
                        this.dstRows.inverse(t2, 3 * this.rows, scale);
                        for (r5 = 0; r5 < this.rows; ++r5) {
                            idx2 = this.rows + r5;
                            a2[s3][r5][c3] = t2[r5];
                            a2[s3][r5][c3 + 1] = t2[idx2];
                            a2[s3][r5][c3 + 2] = t2[idx2 + this.rows];
                            a2[s3][r5][c3 + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r4 = 0; r4 < this.rows; ++r4) {
                    t2[r4] = a2[s3][r4][0];
                    t2[this.rows + r4] = a2[s3][r4][1];
                }
                this.dstRows.inverse(t2, 0, scale);
                this.dstRows.inverse(t2, this.rows, scale);
                for (r4 = 0; r4 < this.rows; ++r4) {
                    a2[s3][r4][0] = t2[r4];
                    a2[s3][r4][1] = t2[this.rows + r4];
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, double[] a2, boolean scale) {
        block20: {
            double[] t2;
            block18: {
                block19: {
                    int nt = 4 * this.slices;
                    if (this.columns == 2) {
                        nt >>= 1;
                    }
                    t2 = new double[nt];
                    if (isgn != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int r2 = 0; r2 < this.rows; ++r2) {
                        int idx0 = r2 * this.rowStride;
                        for (int c2 = 0; c2 < this.columns; c2 += 4) {
                            int idx2;
                            int idx1;
                            int s2;
                            for (s2 = 0; s2 < this.slices; ++s2) {
                                idx1 = s2 * this.sliceStride + idx0 + c2;
                                idx2 = this.slices + s2;
                                t2[s2] = a2[idx1];
                                t2[idx2] = a2[idx1 + 1];
                                t2[idx2 + this.slices] = a2[idx1 + 2];
                                t2[idx2 + 2 * this.slices] = a2[idx1 + 3];
                            }
                            this.dstSlices.forward(t2, 0, scale);
                            this.dstSlices.forward(t2, this.slices, scale);
                            this.dstSlices.forward(t2, 2 * this.slices, scale);
                            this.dstSlices.forward(t2, 3 * this.slices, scale);
                            for (s2 = 0; s2 < this.slices; ++s2) {
                                idx1 = s2 * this.sliceStride + idx0 + c2;
                                idx2 = this.slices + s2;
                                a2[idx1] = t2[s2];
                                a2[idx1 + 1] = t2[idx2];
                                a2[idx1 + 2] = t2[idx2 + this.slices];
                                a2[idx1 + 3] = t2[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int r3 = 0; r3 < this.rows; ++r3) {
                    int idx1;
                    int s3;
                    int idx0 = r3 * this.rowStride;
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx1 = s3 * this.sliceStride + idx0;
                        t2[s3] = a2[idx1];
                        t2[this.slices + s3] = a2[idx1 + 1];
                    }
                    this.dstSlices.forward(t2, 0, scale);
                    this.dstSlices.forward(t2, this.slices, scale);
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx1 = s3 * this.sliceStride + idx0;
                        a2[idx1] = t2[s3];
                        a2[idx1 + 1] = t2[this.slices + s3];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int r4 = 0; r4 < this.rows; ++r4) {
                    int idx0 = r4 * this.rowStride;
                    for (int c3 = 0; c3 < this.columns; c3 += 4) {
                        int idx2;
                        int idx1;
                        int s4;
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx1 = s4 * this.sliceStride + idx0 + c3;
                            idx2 = this.slices + s4;
                            t2[s4] = a2[idx1];
                            t2[idx2] = a2[idx1 + 1];
                            t2[idx2 + this.slices] = a2[idx1 + 2];
                            t2[idx2 + 2 * this.slices] = a2[idx1 + 3];
                        }
                        this.dstSlices.inverse(t2, 0, scale);
                        this.dstSlices.inverse(t2, this.slices, scale);
                        this.dstSlices.inverse(t2, 2 * this.slices, scale);
                        this.dstSlices.inverse(t2, 3 * this.slices, scale);
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx1 = s4 * this.sliceStride + idx0 + c3;
                            idx2 = this.slices + s4;
                            a2[idx1] = t2[s4];
                            a2[idx1 + 1] = t2[idx2];
                            a2[idx1 + 2] = t2[idx2 + this.slices];
                            a2[idx1 + 3] = t2[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r5 = 0; r5 < this.rows; ++r5) {
                    int idx1;
                    int s5;
                    int idx0 = r5 * this.rowStride;
                    for (s5 = 0; s5 < this.slices; ++s5) {
                        idx1 = s5 * this.sliceStride + idx0;
                        t2[s5] = a2[idx1];
                        t2[this.slices + s5] = a2[idx1 + 1];
                    }
                    this.dstSlices.inverse(t2, 0, scale);
                    this.dstSlices.inverse(t2, this.slices, scale);
                    for (s5 = 0; s5 < this.slices; ++s5) {
                        idx1 = s5 * this.sliceStride + idx0;
                        a2[idx1] = t2[s5];
                        a2[idx1 + 1] = t2[this.slices + s5];
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, DoubleLargeArray a2, boolean scale) {
        block20: {
            DoubleLargeArray t2;
            block18: {
                block19: {
                    long nt = 4L * this.slicesl;
                    if (this.columnsl == 2L) {
                        nt >>= 1;
                    }
                    t2 = new DoubleLargeArray(nt);
                    if (isgn != -1) break block18;
                    if (this.columnsl <= 2L) break block19;
                    for (long r2 = 0L; r2 < this.rowsl; ++r2) {
                        long idx0 = r2 * this.rowStridel;
                        for (long c2 = 0L; c2 < this.columnsl; c2 += 4L) {
                            long idx2;
                            long idx1;
                            long s2;
                            for (s2 = 0L; s2 < this.slicesl; ++s2) {
                                idx1 = s2 * this.sliceStridel + idx0 + c2;
                                idx2 = this.slicesl + s2;
                                t2.setDouble(s2, a2.getDouble(idx1));
                                t2.setDouble(idx2, a2.getDouble(idx1 + 1L));
                                t2.setDouble(idx2 + this.slicesl, a2.getDouble(idx1 + 2L));
                                t2.setDouble(idx2 + 2L * this.slicesl, a2.getDouble(idx1 + 3L));
                            }
                            this.dstSlices.forward(t2, 0L, scale);
                            this.dstSlices.forward(t2, this.slicesl, scale);
                            this.dstSlices.forward(t2, 2L * this.slicesl, scale);
                            this.dstSlices.forward(t2, 3L * this.slicesl, scale);
                            for (s2 = 0L; s2 < this.slicesl; ++s2) {
                                idx1 = s2 * this.sliceStridel + idx0 + c2;
                                idx2 = this.slicesl + s2;
                                a2.setDouble(idx1, t2.getDouble(s2));
                                a2.setDouble(idx1 + 1L, t2.getDouble(idx2));
                                a2.setDouble(idx1 + 2L, t2.getDouble(idx2 + this.slicesl));
                                a2.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * this.slicesl));
                            }
                        }
                    }
                    break block20;
                }
                if (this.columnsl != 2L) break block20;
                for (long r3 = 0L; r3 < this.rowsl; ++r3) {
                    long idx1;
                    long s3;
                    long idx0 = r3 * this.rowStridel;
                    for (s3 = 0L; s3 < this.slicesl; ++s3) {
                        idx1 = s3 * this.sliceStridel + idx0;
                        t2.setDouble(s3, a2.getDouble(idx1));
                        t2.setDouble(this.slicesl + s3, a2.getDouble(idx1 + 1L));
                    }
                    this.dstSlices.forward(t2, 0L, scale);
                    this.dstSlices.forward(t2, this.slicesl, scale);
                    for (s3 = 0L; s3 < this.slicesl; ++s3) {
                        idx1 = s3 * this.sliceStridel + idx0;
                        a2.setDouble(idx1, t2.getDouble(s3));
                        a2.setDouble(idx1 + 1L, t2.getDouble(this.slicesl + s3));
                    }
                }
                break block20;
            }
            if (this.columnsl > 2L) {
                for (long r4 = 0L; r4 < this.rowsl; ++r4) {
                    long idx0 = r4 * this.rowStridel;
                    for (long c3 = 0L; c3 < this.columnsl; c3 += 4L) {
                        long idx2;
                        long idx1;
                        long s4;
                        for (s4 = 0L; s4 < this.slicesl; ++s4) {
                            idx1 = s4 * this.sliceStridel + idx0 + c3;
                            idx2 = this.slicesl + s4;
                            t2.setDouble(s4, a2.getDouble(idx1));
                            t2.setDouble(idx2, a2.getDouble(idx1 + 1L));
                            t2.setDouble(idx2 + this.slicesl, a2.getDouble(idx1 + 2L));
                            t2.setDouble(idx2 + 2L * this.slicesl, a2.getDouble(idx1 + 3L));
                        }
                        this.dstSlices.inverse(t2, 0L, scale);
                        this.dstSlices.inverse(t2, this.slicesl, scale);
                        this.dstSlices.inverse(t2, 2L * this.slicesl, scale);
                        this.dstSlices.inverse(t2, 3L * this.slicesl, scale);
                        for (s4 = 0L; s4 < this.slicesl; ++s4) {
                            idx1 = s4 * this.sliceStridel + idx0 + c3;
                            idx2 = this.slicesl + s4;
                            a2.setDouble(idx1, t2.getDouble(s4));
                            a2.setDouble(idx1 + 1L, t2.getDouble(idx2));
                            a2.setDouble(idx1 + 2L, t2.getDouble(idx2 + this.slicesl));
                            a2.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * this.slicesl));
                        }
                    }
                }
            } else if (this.columnsl == 2L) {
                for (long r5 = 0L; r5 < this.rowsl; ++r5) {
                    long idx1;
                    long s5;
                    long idx0 = r5 * this.rowStridel;
                    for (s5 = 0L; s5 < this.slicesl; ++s5) {
                        idx1 = s5 * this.sliceStridel + idx0;
                        t2.setDouble(s5, a2.getDouble(idx1));
                        t2.setDouble(this.slicesl + s5, a2.getDouble(idx1 + 1L));
                    }
                    this.dstSlices.inverse(t2, 0L, scale);
                    this.dstSlices.inverse(t2, this.slicesl, scale);
                    for (s5 = 0L; s5 < this.slicesl; ++s5) {
                        idx1 = s5 * this.sliceStridel + idx0;
                        a2.setDouble(idx1, t2.getDouble(s5));
                        a2.setDouble(idx1 + 1L, t2.getDouble(this.slicesl + s5));
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, double[][][] a2, boolean scale) {
        block20: {
            double[] t2;
            block18: {
                block19: {
                    int nt = 4 * this.slices;
                    if (this.columns == 2) {
                        nt >>= 1;
                    }
                    t2 = new double[nt];
                    if (isgn != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int r2 = 0; r2 < this.rows; ++r2) {
                        for (int c2 = 0; c2 < this.columns; c2 += 4) {
                            int idx2;
                            int s2;
                            for (s2 = 0; s2 < this.slices; ++s2) {
                                idx2 = this.slices + s2;
                                t2[s2] = a2[s2][r2][c2];
                                t2[idx2] = a2[s2][r2][c2 + 1];
                                t2[idx2 + this.slices] = a2[s2][r2][c2 + 2];
                                t2[idx2 + 2 * this.slices] = a2[s2][r2][c2 + 3];
                            }
                            this.dstSlices.forward(t2, 0, scale);
                            this.dstSlices.forward(t2, this.slices, scale);
                            this.dstSlices.forward(t2, 2 * this.slices, scale);
                            this.dstSlices.forward(t2, 3 * this.slices, scale);
                            for (s2 = 0; s2 < this.slices; ++s2) {
                                idx2 = this.slices + s2;
                                a2[s2][r2][c2] = t2[s2];
                                a2[s2][r2][c2 + 1] = t2[idx2];
                                a2[s2][r2][c2 + 2] = t2[idx2 + this.slices];
                                a2[s2][r2][c2 + 3] = t2[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int r3 = 0; r3 < this.rows; ++r3) {
                    int s3;
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        t2[s3] = a2[s3][r3][0];
                        t2[this.slices + s3] = a2[s3][r3][1];
                    }
                    this.dstSlices.forward(t2, 0, scale);
                    this.dstSlices.forward(t2, this.slices, scale);
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        a2[s3][r3][0] = t2[s3];
                        a2[s3][r3][1] = t2[this.slices + s3];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int r4 = 0; r4 < this.rows; ++r4) {
                    for (int c3 = 0; c3 < this.columns; c3 += 4) {
                        int idx2;
                        int s4;
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx2 = this.slices + s4;
                            t2[s4] = a2[s4][r4][c3];
                            t2[idx2] = a2[s4][r4][c3 + 1];
                            t2[idx2 + this.slices] = a2[s4][r4][c3 + 2];
                            t2[idx2 + 2 * this.slices] = a2[s4][r4][c3 + 3];
                        }
                        this.dstSlices.inverse(t2, 0, scale);
                        this.dstSlices.inverse(t2, this.slices, scale);
                        this.dstSlices.inverse(t2, 2 * this.slices, scale);
                        this.dstSlices.inverse(t2, 3 * this.slices, scale);
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx2 = this.slices + s4;
                            a2[s4][r4][c3] = t2[s4];
                            a2[s4][r4][c3 + 1] = t2[idx2];
                            a2[s4][r4][c3 + 2] = t2[idx2 + this.slices];
                            a2[s4][r4][c3 + 3] = t2[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r5 = 0; r5 < this.rows; ++r5) {
                    int s5;
                    for (s5 = 0; s5 < this.slices; ++s5) {
                        t2[s5] = a2[s5][r5][0];
                        t2[this.slices + s5] = a2[s5][r5][1];
                    }
                    this.dstSlices.inverse(t2, 0, scale);
                    this.dstSlices.inverse(t2, this.slices, scale);
                    for (s5 = 0; s5 < this.slices; ++s5) {
                        a2[s5][r5][0] = t2[s5];
                        a2[s5][r5][1] = t2[this.slices + s5];
                    }
                }
            }
        }
    }

    private void ddxt3da_subth(final int isgn, final double[] a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] t2 = new double[ntf];
                    if (isgn == -1) {
                        for (int s2 = n0; s2 < DoubleDST_3D.this.slices; s2 += nthreads) {
                            int idx1;
                            int r2;
                            int idx0 = s2 * DoubleDST_3D.this.sliceStride;
                            for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                DoubleDST_3D.this.dstColumns.forward(a2, idx0 + r2 * DoubleDST_3D.this.rowStride, scale);
                            }
                            if (DoubleDST_3D.this.columns > 2) {
                                for (int c2 = 0; c2 < DoubleDST_3D.this.columns; c2 += 4) {
                                    int idx2;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleDST_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleDST_3D.this.rowStride + c2;
                                        idx2 = DoubleDST_3D.this.rows + r3;
                                        t2[r3] = a2[idx1];
                                        t2[idx2] = a2[idx1 + 1];
                                        t2[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).rows] = a2[idx1 + 2];
                                        t2[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).rows] = a2[idx1 + 3];
                                    }
                                    DoubleDST_3D.this.dstRows.forward(t2, 0, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, 2 * DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, 3 * DoubleDST_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleDST_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleDST_3D.this.rowStride + c2;
                                        idx2 = DoubleDST_3D.this.rows + r3;
                                        a2[idx1] = t2[r3];
                                        a2[idx1 + 1] = t2[idx2];
                                        a2[idx1 + 2] = t2[idx2 + DoubleDST_3D.this.rows];
                                        a2[idx1 + 3] = t2[idx2 + 2 * DoubleDST_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDST_3D.this.columns != 2) continue;
                            for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                idx1 = idx0 + r2 * DoubleDST_3D.this.rowStride;
                                t2[r2] = a2[idx1];
                                t2[((DoubleDST_3D)DoubleDST_3D.this).rows + r2] = a2[idx1 + 1];
                            }
                            DoubleDST_3D.this.dstRows.forward(t2, 0, scale);
                            DoubleDST_3D.this.dstRows.forward(t2, DoubleDST_3D.this.rows, scale);
                            for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                idx1 = idx0 + r2 * DoubleDST_3D.this.rowStride;
                                a2[idx1] = t2[r2];
                                a2[idx1 + 1] = t2[DoubleDST_3D.this.rows + r2];
                            }
                        }
                    } else {
                        for (int s3 = n0; s3 < DoubleDST_3D.this.slices; s3 += nthreads) {
                            int idx1;
                            int r4;
                            int idx0 = s3 * DoubleDST_3D.this.sliceStride;
                            for (r4 = 0; r4 < DoubleDST_3D.this.rows; ++r4) {
                                DoubleDST_3D.this.dstColumns.inverse(a2, idx0 + r4 * DoubleDST_3D.this.rowStride, scale);
                            }
                            if (DoubleDST_3D.this.columns > 2) {
                                for (int c3 = 0; c3 < DoubleDST_3D.this.columns; c3 += 4) {
                                    int idx2;
                                    int r5;
                                    for (r5 = 0; r5 < DoubleDST_3D.this.rows; ++r5) {
                                        idx1 = idx0 + r5 * DoubleDST_3D.this.rowStride + c3;
                                        idx2 = DoubleDST_3D.this.rows + r5;
                                        t2[r5] = a2[idx1];
                                        t2[idx2] = a2[idx1 + 1];
                                        t2[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).rows] = a2[idx1 + 2];
                                        t2[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).rows] = a2[idx1 + 3];
                                    }
                                    DoubleDST_3D.this.dstRows.inverse(t2, 0, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, 2 * DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, 3 * DoubleDST_3D.this.rows, scale);
                                    for (r5 = 0; r5 < DoubleDST_3D.this.rows; ++r5) {
                                        idx1 = idx0 + r5 * DoubleDST_3D.this.rowStride + c3;
                                        idx2 = DoubleDST_3D.this.rows + r5;
                                        a2[idx1] = t2[r5];
                                        a2[idx1 + 1] = t2[idx2];
                                        a2[idx1 + 2] = t2[idx2 + DoubleDST_3D.this.rows];
                                        a2[idx1 + 3] = t2[idx2 + 2 * DoubleDST_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDST_3D.this.columns != 2) continue;
                            for (r4 = 0; r4 < DoubleDST_3D.this.rows; ++r4) {
                                idx1 = idx0 + r4 * DoubleDST_3D.this.rowStride;
                                t2[r4] = a2[idx1];
                                t2[((DoubleDST_3D)DoubleDST_3D.this).rows + r4] = a2[idx1 + 1];
                            }
                            DoubleDST_3D.this.dstRows.inverse(t2, 0, scale);
                            DoubleDST_3D.this.dstRows.inverse(t2, DoubleDST_3D.this.rows, scale);
                            for (r4 = 0; r4 < DoubleDST_3D.this.rows; ++r4) {
                                idx1 = idx0 + r4 * DoubleDST_3D.this.rowStride;
                                a2[idx1] = t2[r4];
                                a2[idx1 + 1] = t2[DoubleDST_3D.this.rows + r4];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3da_subth(final int isgn, final DoubleLargeArray a2, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.slicesl ? this.slicesl : (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final long n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    DoubleLargeArray t2 = new DoubleLargeArray(ntf);
                    if (isgn == -1) {
                        for (long s2 = n0; s2 < DoubleDST_3D.this.slicesl; s2 += (long)nthreads) {
                            long idx1;
                            long r2;
                            long idx0 = s2 * DoubleDST_3D.this.sliceStridel;
                            for (r2 = 0L; r2 < DoubleDST_3D.this.rowsl; ++r2) {
                                DoubleDST_3D.this.dstColumns.forward(a2, idx0 + r2 * DoubleDST_3D.this.rowStridel, scale);
                            }
                            if (DoubleDST_3D.this.columnsl > 2L) {
                                for (long c2 = 0L; c2 < DoubleDST_3D.this.columnsl; c2 += 4L) {
                                    long idx2;
                                    long r3;
                                    for (r3 = 0L; r3 < DoubleDST_3D.this.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * DoubleDST_3D.this.rowStridel + c2;
                                        idx2 = DoubleDST_3D.this.rowsl + r3;
                                        t2.setDouble(r3, a2.getDouble(idx1));
                                        t2.setDouble(idx2, a2.getDouble(idx1 + 1L));
                                        t2.setDouble(idx2 + DoubleDST_3D.this.rowsl, a2.getDouble(idx1 + 2L));
                                        t2.setDouble(idx2 + 2L * DoubleDST_3D.this.rowsl, a2.getDouble(idx1 + 3L));
                                    }
                                    DoubleDST_3D.this.dstRows.forward(t2, 0L, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, DoubleDST_3D.this.rowsl, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, 2L * DoubleDST_3D.this.rowsl, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, 3L * DoubleDST_3D.this.rowsl, scale);
                                    for (r3 = 0L; r3 < DoubleDST_3D.this.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * DoubleDST_3D.this.rowStridel + c2;
                                        idx2 = DoubleDST_3D.this.rowsl + r3;
                                        a2.setDouble(idx1, t2.getDouble(r3));
                                        a2.setDouble(idx1 + 1L, t2.getDouble(idx2));
                                        a2.setDouble(idx1 + 2L, t2.getDouble(idx2 + DoubleDST_3D.this.rowsl));
                                        a2.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * DoubleDST_3D.this.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (DoubleDST_3D.this.columnsl != 2L) continue;
                            for (r2 = 0L; r2 < DoubleDST_3D.this.rowsl; ++r2) {
                                idx1 = idx0 + r2 * DoubleDST_3D.this.rowStridel;
                                t2.setDouble(r2, a2.getDouble(idx1));
                                t2.setDouble(DoubleDST_3D.this.rowsl + r2, a2.getDouble(idx1 + 1L));
                            }
                            DoubleDST_3D.this.dstRows.forward(t2, 0L, scale);
                            DoubleDST_3D.this.dstRows.forward(t2, DoubleDST_3D.this.rowsl, scale);
                            for (r2 = 0L; r2 < DoubleDST_3D.this.rowsl; ++r2) {
                                idx1 = idx0 + r2 * DoubleDST_3D.this.rowStridel;
                                a2.setDouble(idx1, t2.getDouble(r2));
                                a2.setDouble(idx1 + 1L, t2.getDouble(DoubleDST_3D.this.rowsl + r2));
                            }
                        }
                    } else {
                        for (long s3 = n0; s3 < DoubleDST_3D.this.slicesl; s3 += (long)nthreads) {
                            long idx1;
                            long r4;
                            long idx0 = s3 * DoubleDST_3D.this.sliceStridel;
                            for (r4 = 0L; r4 < DoubleDST_3D.this.rowsl; ++r4) {
                                DoubleDST_3D.this.dstColumns.inverse(a2, idx0 + r4 * DoubleDST_3D.this.rowStridel, scale);
                            }
                            if (DoubleDST_3D.this.columnsl > 2L) {
                                for (long c3 = 0L; c3 < DoubleDST_3D.this.columnsl; c3 += 4L) {
                                    long idx2;
                                    long r5;
                                    for (r5 = 0L; r5 < DoubleDST_3D.this.rowsl; ++r5) {
                                        idx1 = idx0 + r5 * DoubleDST_3D.this.rowStridel + c3;
                                        idx2 = DoubleDST_3D.this.rowsl + r5;
                                        t2.setDouble(r5, a2.getDouble(idx1));
                                        t2.setDouble(idx2, a2.getDouble(idx1 + 1L));
                                        t2.setDouble(idx2 + DoubleDST_3D.this.rowsl, a2.getDouble(idx1 + 2L));
                                        t2.setDouble(idx2 + 2L * DoubleDST_3D.this.rowsl, a2.getDouble(idx1 + 3L));
                                    }
                                    DoubleDST_3D.this.dstRows.inverse(t2, 0L, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, DoubleDST_3D.this.rowsl, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, 2L * DoubleDST_3D.this.rowsl, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, 3L * DoubleDST_3D.this.rowsl, scale);
                                    for (r5 = 0L; r5 < DoubleDST_3D.this.rowsl; ++r5) {
                                        idx1 = idx0 + r5 * DoubleDST_3D.this.rowStridel + c3;
                                        idx2 = DoubleDST_3D.this.rowsl + r5;
                                        a2.setDouble(idx1, t2.getDouble(r5));
                                        a2.setDouble(idx1 + 1L, t2.getDouble(idx2));
                                        a2.setDouble(idx1 + 2L, t2.getDouble(idx2 + DoubleDST_3D.this.rowsl));
                                        a2.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * DoubleDST_3D.this.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (DoubleDST_3D.this.columnsl != 2L) continue;
                            for (r4 = 0L; r4 < DoubleDST_3D.this.rowsl; ++r4) {
                                idx1 = idx0 + r4 * DoubleDST_3D.this.rowStridel;
                                t2.setDouble(r4, a2.getDouble(idx1));
                                t2.setDouble(DoubleDST_3D.this.rowsl + r4, a2.getDouble(idx1 + 1L));
                            }
                            DoubleDST_3D.this.dstRows.inverse(t2, 0L, scale);
                            DoubleDST_3D.this.dstRows.inverse(t2, DoubleDST_3D.this.rowsl, scale);
                            for (r4 = 0L; r4 < DoubleDST_3D.this.rowsl; ++r4) {
                                idx1 = idx0 + r4 * DoubleDST_3D.this.rowStridel;
                                a2.setDouble(idx1, t2.getDouble(r4));
                                a2.setDouble(idx1 + 1L, t2.getDouble(DoubleDST_3D.this.rowsl + r4));
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3da_subth(final int isgn, final double[][][] a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] t2 = new double[ntf];
                    if (isgn == -1) {
                        for (int s2 = n0; s2 < DoubleDST_3D.this.slices; s2 += nthreads) {
                            int r2;
                            for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                DoubleDST_3D.this.dstColumns.forward(a2[s2][r2], scale);
                            }
                            if (DoubleDST_3D.this.columns > 2) {
                                for (int c2 = 0; c2 < DoubleDST_3D.this.columns; c2 += 4) {
                                    int idx2;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleDST_3D.this.rows; ++r3) {
                                        idx2 = DoubleDST_3D.this.rows + r3;
                                        t2[r3] = a2[s2][r3][c2];
                                        t2[idx2] = a2[s2][r3][c2 + 1];
                                        t2[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).rows] = a2[s2][r3][c2 + 2];
                                        t2[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).rows] = a2[s2][r3][c2 + 3];
                                    }
                                    DoubleDST_3D.this.dstRows.forward(t2, 0, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, 2 * DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.forward(t2, 3 * DoubleDST_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleDST_3D.this.rows; ++r3) {
                                        idx2 = DoubleDST_3D.this.rows + r3;
                                        a2[s2][r3][c2] = t2[r3];
                                        a2[s2][r3][c2 + 1] = t2[idx2];
                                        a2[s2][r3][c2 + 2] = t2[idx2 + DoubleDST_3D.this.rows];
                                        a2[s2][r3][c2 + 3] = t2[idx2 + 2 * DoubleDST_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDST_3D.this.columns != 2) continue;
                            for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                t2[r2] = a2[s2][r2][0];
                                t2[((DoubleDST_3D)DoubleDST_3D.this).rows + r2] = a2[s2][r2][1];
                            }
                            DoubleDST_3D.this.dstRows.forward(t2, 0, scale);
                            DoubleDST_3D.this.dstRows.forward(t2, DoubleDST_3D.this.rows, scale);
                            for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                a2[s2][r2][0] = t2[r2];
                                a2[s2][r2][1] = t2[DoubleDST_3D.this.rows + r2];
                            }
                        }
                    } else {
                        for (int s3 = n0; s3 < DoubleDST_3D.this.slices; s3 += nthreads) {
                            int r4;
                            for (r4 = 0; r4 < DoubleDST_3D.this.rows; ++r4) {
                                DoubleDST_3D.this.dstColumns.inverse(a2[s3][r4], scale);
                            }
                            if (DoubleDST_3D.this.columns > 2) {
                                for (int c3 = 0; c3 < DoubleDST_3D.this.columns; c3 += 4) {
                                    int idx2;
                                    int r5;
                                    for (r5 = 0; r5 < DoubleDST_3D.this.rows; ++r5) {
                                        idx2 = DoubleDST_3D.this.rows + r5;
                                        t2[r5] = a2[s3][r5][c3];
                                        t2[idx2] = a2[s3][r5][c3 + 1];
                                        t2[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).rows] = a2[s3][r5][c3 + 2];
                                        t2[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).rows] = a2[s3][r5][c3 + 3];
                                    }
                                    DoubleDST_3D.this.dstRows.inverse(t2, 0, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, 2 * DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.inverse(t2, 3 * DoubleDST_3D.this.rows, scale);
                                    for (r5 = 0; r5 < DoubleDST_3D.this.rows; ++r5) {
                                        idx2 = DoubleDST_3D.this.rows + r5;
                                        a2[s3][r5][c3] = t2[r5];
                                        a2[s3][r5][c3 + 1] = t2[idx2];
                                        a2[s3][r5][c3 + 2] = t2[idx2 + DoubleDST_3D.this.rows];
                                        a2[s3][r5][c3 + 3] = t2[idx2 + 2 * DoubleDST_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDST_3D.this.columns != 2) continue;
                            for (r4 = 0; r4 < DoubleDST_3D.this.rows; ++r4) {
                                t2[r4] = a2[s3][r4][0];
                                t2[((DoubleDST_3D)DoubleDST_3D.this).rows + r4] = a2[s3][r4][1];
                            }
                            DoubleDST_3D.this.dstRows.inverse(t2, 0, scale);
                            DoubleDST_3D.this.dstRows.inverse(t2, DoubleDST_3D.this.rows, scale);
                            for (r4 = 0; r4 < DoubleDST_3D.this.rows; ++r4) {
                                a2[s3][r4][0] = t2[r4];
                                a2[s3][r4][1] = t2[DoubleDST_3D.this.rows + r4];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final double[] a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        double[] t2;
                        block17: {
                            block18: {
                                t2 = new double[ntf];
                                if (isgn != -1) break block17;
                                if (DoubleDST_3D.this.columns <= 2) break block18;
                                for (int r2 = n0; r2 < DoubleDST_3D.this.rows; r2 += nthreads) {
                                    int idx0 = r2 * DoubleDST_3D.this.rowStride;
                                    for (int c2 = 0; c2 < DoubleDST_3D.this.columns; c2 += 4) {
                                        int idx2;
                                        int idx1;
                                        int s2;
                                        for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                            idx1 = s2 * DoubleDST_3D.this.sliceStride + idx0 + c2;
                                            idx2 = DoubleDST_3D.this.slices + s2;
                                            t2[s2] = a2[idx1];
                                            t2[idx2] = a2[idx1 + 1];
                                            t2[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).slices] = a2[idx1 + 2];
                                            t2[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).slices] = a2[idx1 + 3];
                                        }
                                        DoubleDST_3D.this.dstSlices.forward(t2, 0, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, DoubleDST_3D.this.slices, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, 2 * DoubleDST_3D.this.slices, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, 3 * DoubleDST_3D.this.slices, scale);
                                        for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                            idx1 = s2 * DoubleDST_3D.this.sliceStride + idx0 + c2;
                                            idx2 = DoubleDST_3D.this.slices + s2;
                                            a2[idx1] = t2[s2];
                                            a2[idx1 + 1] = t2[idx2];
                                            a2[idx1 + 2] = t2[idx2 + DoubleDST_3D.this.slices];
                                            a2[idx1 + 3] = t2[idx2 + 2 * DoubleDST_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDST_3D.this.columns != 2) break block19;
                            for (int r3 = n0; r3 < DoubleDST_3D.this.rows; r3 += nthreads) {
                                int idx1;
                                int s3;
                                int idx0 = r3 * DoubleDST_3D.this.rowStride;
                                for (s3 = 0; s3 < DoubleDST_3D.this.slices; ++s3) {
                                    idx1 = s3 * DoubleDST_3D.this.sliceStride + idx0;
                                    t2[s3] = a2[idx1];
                                    t2[((DoubleDST_3D)DoubleDST_3D.this).slices + s3] = a2[idx1 + 1];
                                }
                                DoubleDST_3D.this.dstSlices.forward(t2, 0, scale);
                                DoubleDST_3D.this.dstSlices.forward(t2, DoubleDST_3D.this.slices, scale);
                                for (s3 = 0; s3 < DoubleDST_3D.this.slices; ++s3) {
                                    idx1 = s3 * DoubleDST_3D.this.sliceStride + idx0;
                                    a2[idx1] = t2[s3];
                                    a2[idx1 + 1] = t2[DoubleDST_3D.this.slices + s3];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDST_3D.this.columns > 2) {
                            for (int r4 = n0; r4 < DoubleDST_3D.this.rows; r4 += nthreads) {
                                int idx0 = r4 * DoubleDST_3D.this.rowStride;
                                for (int c3 = 0; c3 < DoubleDST_3D.this.columns; c3 += 4) {
                                    int idx2;
                                    int idx1;
                                    int s4;
                                    for (s4 = 0; s4 < DoubleDST_3D.this.slices; ++s4) {
                                        idx1 = s4 * DoubleDST_3D.this.sliceStride + idx0 + c3;
                                        idx2 = DoubleDST_3D.this.slices + s4;
                                        t2[s4] = a2[idx1];
                                        t2[idx2] = a2[idx1 + 1];
                                        t2[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).slices] = a2[idx1 + 2];
                                        t2[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).slices] = a2[idx1 + 3];
                                    }
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 0, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, DoubleDST_3D.this.slices, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 2 * DoubleDST_3D.this.slices, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 3 * DoubleDST_3D.this.slices, scale);
                                    for (s4 = 0; s4 < DoubleDST_3D.this.slices; ++s4) {
                                        idx1 = s4 * DoubleDST_3D.this.sliceStride + idx0 + c3;
                                        idx2 = DoubleDST_3D.this.slices + s4;
                                        a2[idx1] = t2[s4];
                                        a2[idx1 + 1] = t2[idx2];
                                        a2[idx1 + 2] = t2[idx2 + DoubleDST_3D.this.slices];
                                        a2[idx1 + 3] = t2[idx2 + 2 * DoubleDST_3D.this.slices];
                                    }
                                }
                            }
                        } else if (DoubleDST_3D.this.columns == 2) {
                            for (int r5 = n0; r5 < DoubleDST_3D.this.rows; r5 += nthreads) {
                                int idx1;
                                int s5;
                                int idx0 = r5 * DoubleDST_3D.this.rowStride;
                                for (s5 = 0; s5 < DoubleDST_3D.this.slices; ++s5) {
                                    idx1 = s5 * DoubleDST_3D.this.sliceStride + idx0;
                                    t2[s5] = a2[idx1];
                                    t2[((DoubleDST_3D)DoubleDST_3D.this).slices + s5] = a2[idx1 + 1];
                                }
                                DoubleDST_3D.this.dstSlices.inverse(t2, 0, scale);
                                DoubleDST_3D.this.dstSlices.inverse(t2, DoubleDST_3D.this.slices, scale);
                                for (s5 = 0; s5 < DoubleDST_3D.this.slices; ++s5) {
                                    idx1 = s5 * DoubleDST_3D.this.sliceStride + idx0;
                                    a2[idx1] = t2[s5];
                                    a2[idx1 + 1] = t2[DoubleDST_3D.this.slices + s5];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final DoubleLargeArray a2, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 4L * this.slicesl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final long n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        DoubleLargeArray t2;
                        block17: {
                            block18: {
                                t2 = new DoubleLargeArray(ntf);
                                if (isgn != -1) break block17;
                                if (DoubleDST_3D.this.columnsl <= 2L) break block18;
                                for (long r2 = n0; r2 < DoubleDST_3D.this.rowsl; r2 += (long)nthreads) {
                                    long idx0 = r2 * DoubleDST_3D.this.rowStridel;
                                    for (long c2 = 0L; c2 < DoubleDST_3D.this.columnsl; c2 += 4L) {
                                        long idx2;
                                        long idx1;
                                        long s2;
                                        for (s2 = 0L; s2 < DoubleDST_3D.this.slicesl; ++s2) {
                                            idx1 = s2 * DoubleDST_3D.this.sliceStridel + idx0 + c2;
                                            idx2 = DoubleDST_3D.this.slicesl + s2;
                                            t2.setDouble(s2, a2.getDouble(idx1));
                                            t2.setDouble(idx2, a2.getDouble(idx1 + 1L));
                                            t2.setDouble(idx2 + DoubleDST_3D.this.slicesl, a2.getDouble(idx1 + 2L));
                                            t2.setDouble(idx2 + 2L * DoubleDST_3D.this.slicesl, a2.getDouble(idx1 + 3L));
                                        }
                                        DoubleDST_3D.this.dstSlices.forward(t2, 0L, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, DoubleDST_3D.this.slicesl, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, 2L * DoubleDST_3D.this.slicesl, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, 3L * DoubleDST_3D.this.slicesl, scale);
                                        for (s2 = 0L; s2 < DoubleDST_3D.this.slicesl; ++s2) {
                                            idx1 = s2 * DoubleDST_3D.this.sliceStridel + idx0 + c2;
                                            idx2 = DoubleDST_3D.this.slicesl + s2;
                                            a2.setDouble(idx1, t2.getDouble(s2));
                                            a2.setDouble(idx1 + 1L, t2.getDouble(idx2));
                                            a2.setDouble(idx1 + 2L, t2.getDouble(idx2 + DoubleDST_3D.this.slicesl));
                                            a2.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * DoubleDST_3D.this.slicesl));
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDST_3D.this.columnsl != 2L) break block19;
                            for (long r3 = n0; r3 < DoubleDST_3D.this.rowsl; r3 += (long)nthreads) {
                                long idx1;
                                long s3;
                                long idx0 = r3 * DoubleDST_3D.this.rowStridel;
                                for (s3 = 0L; s3 < DoubleDST_3D.this.slicesl; ++s3) {
                                    idx1 = s3 * DoubleDST_3D.this.sliceStridel + idx0;
                                    t2.setDouble(s3, a2.getDouble(idx1));
                                    t2.setDouble(DoubleDST_3D.this.slicesl + s3, a2.getDouble(idx1 + 1L));
                                }
                                DoubleDST_3D.this.dstSlices.forward(t2, 0L, scale);
                                DoubleDST_3D.this.dstSlices.forward(t2, DoubleDST_3D.this.slicesl, scale);
                                for (s3 = 0L; s3 < DoubleDST_3D.this.slicesl; ++s3) {
                                    idx1 = s3 * DoubleDST_3D.this.sliceStridel + idx0;
                                    a2.setDouble(idx1, t2.getDouble(s3));
                                    a2.setDouble(idx1 + 1L, t2.getDouble(DoubleDST_3D.this.slicesl + s3));
                                }
                            }
                            break block19;
                        }
                        if (DoubleDST_3D.this.columnsl > 2L) {
                            for (long r4 = n0; r4 < DoubleDST_3D.this.rowsl; r4 += (long)nthreads) {
                                long idx0 = r4 * DoubleDST_3D.this.rowStridel;
                                for (long c3 = 0L; c3 < DoubleDST_3D.this.columnsl; c3 += 4L) {
                                    long idx2;
                                    long idx1;
                                    long s4;
                                    for (s4 = 0L; s4 < DoubleDST_3D.this.slicesl; ++s4) {
                                        idx1 = s4 * DoubleDST_3D.this.sliceStridel + idx0 + c3;
                                        idx2 = DoubleDST_3D.this.slicesl + s4;
                                        t2.setDouble(s4, a2.getDouble(idx1));
                                        t2.setDouble(idx2, a2.getDouble(idx1 + 1L));
                                        t2.setDouble(idx2 + DoubleDST_3D.this.slicesl, a2.getDouble(idx1 + 2L));
                                        t2.setDouble(idx2 + 2L * DoubleDST_3D.this.slicesl, a2.getDouble(idx1 + 3L));
                                    }
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 0L, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, DoubleDST_3D.this.slicesl, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 2L * DoubleDST_3D.this.slicesl, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 3L * DoubleDST_3D.this.slicesl, scale);
                                    for (s4 = 0L; s4 < DoubleDST_3D.this.slicesl; ++s4) {
                                        idx1 = s4 * DoubleDST_3D.this.sliceStridel + idx0 + c3;
                                        idx2 = DoubleDST_3D.this.slicesl + s4;
                                        a2.setDouble(idx1, t2.getDouble(s4));
                                        a2.setDouble(idx1 + 1L, t2.getDouble(idx2));
                                        a2.setDouble(idx1 + 2L, t2.getDouble(idx2 + DoubleDST_3D.this.slicesl));
                                        a2.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * DoubleDST_3D.this.slicesl));
                                    }
                                }
                            }
                        } else if (DoubleDST_3D.this.columnsl == 2L) {
                            for (long r5 = n0; r5 < DoubleDST_3D.this.rowsl; r5 += (long)nthreads) {
                                long idx1;
                                long s5;
                                long idx0 = r5 * DoubleDST_3D.this.rowStridel;
                                for (s5 = 0L; s5 < DoubleDST_3D.this.slicesl; ++s5) {
                                    idx1 = s5 * DoubleDST_3D.this.sliceStridel + idx0;
                                    t2.setDouble(s5, a2.getDouble(idx1));
                                    t2.setDouble(DoubleDST_3D.this.slicesl + s5, a2.getDouble(idx1 + 1L));
                                }
                                DoubleDST_3D.this.dstSlices.inverse(t2, 0L, scale);
                                DoubleDST_3D.this.dstSlices.inverse(t2, DoubleDST_3D.this.slicesl, scale);
                                for (s5 = 0L; s5 < DoubleDST_3D.this.slicesl; ++s5) {
                                    idx1 = s5 * DoubleDST_3D.this.sliceStridel + idx0;
                                    a2.setDouble(idx1, t2.getDouble(s5));
                                    a2.setDouble(idx1 + 1L, t2.getDouble(DoubleDST_3D.this.slicesl + s5));
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final double[][][] a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        double[] t2;
                        block17: {
                            block18: {
                                t2 = new double[ntf];
                                if (isgn != -1) break block17;
                                if (DoubleDST_3D.this.columns <= 2) break block18;
                                for (int r2 = n0; r2 < DoubleDST_3D.this.rows; r2 += nthreads) {
                                    for (int c2 = 0; c2 < DoubleDST_3D.this.columns; c2 += 4) {
                                        int idx2;
                                        int s2;
                                        for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                            idx2 = DoubleDST_3D.this.slices + s2;
                                            t2[s2] = a2[s2][r2][c2];
                                            t2[idx2] = a2[s2][r2][c2 + 1];
                                            t2[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).slices] = a2[s2][r2][c2 + 2];
                                            t2[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).slices] = a2[s2][r2][c2 + 3];
                                        }
                                        DoubleDST_3D.this.dstSlices.forward(t2, 0, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, DoubleDST_3D.this.slices, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, 2 * DoubleDST_3D.this.slices, scale);
                                        DoubleDST_3D.this.dstSlices.forward(t2, 3 * DoubleDST_3D.this.slices, scale);
                                        for (s2 = 0; s2 < DoubleDST_3D.this.slices; ++s2) {
                                            idx2 = DoubleDST_3D.this.slices + s2;
                                            a2[s2][r2][c2] = t2[s2];
                                            a2[s2][r2][c2 + 1] = t2[idx2];
                                            a2[s2][r2][c2 + 2] = t2[idx2 + DoubleDST_3D.this.slices];
                                            a2[s2][r2][c2 + 3] = t2[idx2 + 2 * DoubleDST_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDST_3D.this.columns != 2) break block19;
                            for (int r3 = n0; r3 < DoubleDST_3D.this.rows; r3 += nthreads) {
                                int s3;
                                for (s3 = 0; s3 < DoubleDST_3D.this.slices; ++s3) {
                                    t2[s3] = a2[s3][r3][0];
                                    t2[((DoubleDST_3D)DoubleDST_3D.this).slices + s3] = a2[s3][r3][1];
                                }
                                DoubleDST_3D.this.dstSlices.forward(t2, 0, scale);
                                DoubleDST_3D.this.dstSlices.forward(t2, DoubleDST_3D.this.slices, scale);
                                for (s3 = 0; s3 < DoubleDST_3D.this.slices; ++s3) {
                                    a2[s3][r3][0] = t2[s3];
                                    a2[s3][r3][1] = t2[DoubleDST_3D.this.slices + s3];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDST_3D.this.columns > 2) {
                            for (int r4 = n0; r4 < DoubleDST_3D.this.rows; r4 += nthreads) {
                                for (int c3 = 0; c3 < DoubleDST_3D.this.columns; c3 += 4) {
                                    int idx2;
                                    int s4;
                                    for (s4 = 0; s4 < DoubleDST_3D.this.slices; ++s4) {
                                        idx2 = DoubleDST_3D.this.slices + s4;
                                        t2[s4] = a2[s4][r4][c3];
                                        t2[idx2] = a2[s4][r4][c3 + 1];
                                        t2[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).slices] = a2[s4][r4][c3 + 2];
                                        t2[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).slices] = a2[s4][r4][c3 + 3];
                                    }
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 0, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, DoubleDST_3D.this.slices, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 2 * DoubleDST_3D.this.slices, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(t2, 3 * DoubleDST_3D.this.slices, scale);
                                    for (s4 = 0; s4 < DoubleDST_3D.this.slices; ++s4) {
                                        idx2 = DoubleDST_3D.this.slices + s4;
                                        a2[s4][r4][c3] = t2[s4];
                                        a2[s4][r4][c3 + 1] = t2[idx2];
                                        a2[s4][r4][c3 + 2] = t2[idx2 + DoubleDST_3D.this.slices];
                                        a2[s4][r4][c3 + 3] = t2[idx2 + 2 * DoubleDST_3D.this.slices];
                                    }
                                }
                            }
                        } else if (DoubleDST_3D.this.columns == 2) {
                            for (int r5 = n0; r5 < DoubleDST_3D.this.rows; r5 += nthreads) {
                                int s5;
                                for (s5 = 0; s5 < DoubleDST_3D.this.slices; ++s5) {
                                    t2[s5] = a2[s5][r5][0];
                                    t2[((DoubleDST_3D)DoubleDST_3D.this).slices + s5] = a2[s5][r5][1];
                                }
                                DoubleDST_3D.this.dstSlices.inverse(t2, 0, scale);
                                DoubleDST_3D.this.dstSlices.inverse(t2, DoubleDST_3D.this.slices, scale);
                                for (s5 = 0; s5 < DoubleDST_3D.this.slices; ++s5) {
                                    a2[s5][r5][0] = t2[s5];
                                    a2[s5][r5][1] = t2[DoubleDST_3D.this.slices + s5];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDST_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

