/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayUtils;
import pl.edu.icm.jlargearrays.LongLargeArray;

public final class FloatFFT_1D {
    private int n;
    private long nl;
    private int nBluestein;
    private long nBluesteinl;
    private int[] ip;
    private LongLargeArray ipl;
    private float[] w;
    private FloatLargeArray wl;
    private int nw;
    private long nwl;
    private int nc;
    private long ncl;
    private float[] wtable;
    private FloatLargeArray wtablel;
    private float[] wtable_r;
    private FloatLargeArray wtable_rl;
    private float[] bk1;
    private FloatLargeArray bk1l;
    private float[] bk2;
    private FloatLargeArray bk2l;
    private Plans plan;
    private boolean useLargeArrays;
    private static final int[] factors = new int[]{4, 2, 3, 5};
    private static final float PI = (float)Math.PI;
    private static final float TWO_PI = (float)Math.PI * 2;

    public FloatFFT_1D(long n2) {
        if (n2 < 1L) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        this.useLargeArrays = CommonUtils.isUseLargeArrays() || 2L * n2 > (long)LargeArray.getMaxSizeOf32bitArray();
        this.n = (int)n2;
        this.nl = n2;
        if (!this.useLargeArrays) {
            if (!CommonUtils.isPowerOf2(n2)) {
                if (CommonUtils.getReminder(n2, factors) >= 211L) {
                    this.plan = Plans.BLUESTEIN;
                    this.nBluestein = CommonUtils.nextPow2(this.n * 2 - 1);
                    this.bk1 = new float[2 * this.nBluestein];
                    this.bk2 = new float[2 * this.nBluestein];
                    this.ip = new int[2 + (int)FastMath.ceil((double)(2 + (1 << (int)(FastMath.log((double)((float)this.nBluestein + 0.5f)) / FastMath.log((double)2.0)) / 2)))];
                    this.w = new float[this.nBluestein];
                    int twon = 2 * this.nBluestein;
                    this.nw = twon >> 2;
                    CommonUtils.makewt(this.nw, this.ip, this.w);
                    this.nc = this.nBluestein >> 2;
                    CommonUtils.makect(this.nc, this.w, this.nw, this.ip);
                    this.bluesteini();
                } else {
                    this.plan = Plans.MIXED_RADIX;
                    this.wtable = new float[4 * this.n + 15];
                    this.wtable_r = new float[2 * this.n + 15];
                    this.cffti();
                    this.rffti();
                }
            } else {
                this.plan = Plans.SPLIT_RADIX;
                this.ip = new int[2 + (int)FastMath.ceil((double)(2 + (1 << (int)(FastMath.log((double)((float)n2 + 0.5f)) / FastMath.log((double)2.0)) / 2)))];
                this.w = new float[this.n];
                int twon = 2 * this.n;
                this.nw = twon >> 2;
                CommonUtils.makewt(this.nw, this.ip, this.w);
                this.nc = this.n >> 2;
                CommonUtils.makect(this.nc, this.w, this.nw, this.ip);
            }
        } else if (!CommonUtils.isPowerOf2(this.nl)) {
            if (CommonUtils.getReminder(this.nl, factors) >= 211L) {
                this.plan = Plans.BLUESTEIN;
                this.nBluesteinl = CommonUtils.nextPow2(this.nl * 2L - 1L);
                this.bk1l = new FloatLargeArray(2L * this.nBluesteinl);
                this.bk2l = new FloatLargeArray(2L * this.nBluesteinl);
                this.ipl = new LongLargeArray(2L + (long)FastMath.ceil((double)(2L + (1L << (int)((long)(FastMath.log((double)((float)this.nBluesteinl + 0.5f)) / FastMath.log((double)2.0)) / 2L)))));
                this.wl = new FloatLargeArray(this.nBluesteinl);
                long twon = 2L * this.nBluesteinl;
                this.nwl = twon >> 2;
                CommonUtils.makewt(this.nwl, this.ipl, this.wl);
                this.ncl = this.nBluesteinl >> 2;
                CommonUtils.makect(this.ncl, this.wl, this.nwl, this.ipl);
                this.bluesteinil();
            } else {
                this.plan = Plans.MIXED_RADIX;
                this.wtablel = new FloatLargeArray(4L * this.nl + 15L);
                this.wtable_rl = new FloatLargeArray(2L * this.nl + 15L);
                this.cfftil();
                this.rfftil();
            }
        } else {
            this.plan = Plans.SPLIT_RADIX;
            this.ipl = new LongLargeArray(2L + (long)FastMath.ceil((double)(2L + (1L << (int)((long)(FastMath.log((double)((float)this.nl + 0.5f)) / FastMath.log((double)2.0)) / 2L)))));
            this.wl = new FloatLargeArray(this.nl);
            long twon = 2L * this.nl;
            this.nwl = twon >> 2;
            CommonUtils.makewt(this.nwl, this.ipl, this.wl);
            this.ncl = this.nl >> 2;
            CommonUtils.makect(this.ncl, this.wl, this.nwl, this.ipl);
        }
    }

    public void complexForward(float[] a2) {
        this.complexForward(a2, 0);
    }

    public void complexForward(FloatLargeArray a2) {
        this.complexForward(a2, 0L);
    }

    public void complexForward(float[] a2, int offa) {
        if (this.useLargeArrays) {
            this.complexForward(new FloatLargeArray(a2), (long)offa);
        } else {
            if (this.n == 1) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    CommonUtils.cftbsub(2 * this.n, a2, offa, this.ip, this.nw, this.w);
                    break;
                }
                case MIXED_RADIX: {
                    this.cfftf(a2, offa, -1);
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_complex(a2, offa, -1);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void complexForward(FloatLargeArray a2, long offa) {
        if (!this.useLargeArrays) {
            if (a2.isLarge() || a2.isConstant() || offa >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.complexForward(a2.getData(), (int)offa);
            return;
        } else {
            if (this.nl == 1L) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    CommonUtils.cftbsub(2L * this.nl, a2, offa, this.ipl, this.nwl, this.wl);
                    return;
                }
                case MIXED_RADIX: {
                    this.cfftf(a2, offa, -1);
                    return;
                }
                case BLUESTEIN: {
                    this.bluestein_complex(a2, offa, -1);
                }
            }
        }
    }

    public void complexInverse(float[] a2, boolean scale) {
        this.complexInverse(a2, 0, scale);
    }

    public void complexInverse(FloatLargeArray a2, boolean scale) {
        this.complexInverse(a2, 0L, scale);
    }

    public void complexInverse(float[] a2, int offa, boolean scale) {
        if (this.useLargeArrays) {
            this.complexInverse(new FloatLargeArray(a2), (long)offa, scale);
        } else {
            if (this.n == 1) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    CommonUtils.cftfsub(2 * this.n, a2, offa, this.ip, this.nw, this.w);
                    break;
                }
                case MIXED_RADIX: {
                    this.cfftf(a2, offa, 1);
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_complex(a2, offa, 1);
                }
            }
            if (scale) {
                CommonUtils.scale(this.n, 1.0f / (float)this.n, a2, offa, true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void complexInverse(FloatLargeArray a2, long offa, boolean scale) {
        if (!this.useLargeArrays) {
            if (a2.isLarge() || a2.isConstant() || offa >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.complexInverse(a2.getData(), (int)offa, scale);
            return;
        } else {
            if (this.nl == 1L) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    CommonUtils.cftfsub(2L * this.nl, a2, offa, this.ipl, this.nwl, this.wl);
                    break;
                }
                case MIXED_RADIX: {
                    this.cfftf(a2, offa, 1);
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_complex(a2, offa, 1);
                }
            }
            if (!scale) return;
            CommonUtils.scale(this.nl, 1.0f / (float)this.nl, a2, offa, true);
        }
    }

    public void realForward(float[] a2) {
        this.realForward(a2, 0);
    }

    public void realForward(FloatLargeArray a2) {
        this.realForward(a2, 0L);
    }

    public void realForward(float[] a2, int offa) {
        if (this.useLargeArrays) {
            this.realForward(new FloatLargeArray(a2), (long)offa);
        } else {
            if (this.n == 1) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    if (this.n > 4) {
                        CommonUtils.cftfsub(this.n, a2, offa, this.ip, this.nw, this.w);
                        CommonUtils.rftfsub(this.n, a2, offa, this.nc, this.w, this.nw);
                    } else if (this.n == 4) {
                        CommonUtils.cftx020(a2, offa);
                    }
                    float xi = a2[offa] - a2[offa + 1];
                    int n2 = offa;
                    a2[n2] = a2[n2] + a2[offa + 1];
                    a2[offa + 1] = xi;
                    break;
                }
                case MIXED_RADIX: {
                    this.rfftf(a2, offa);
                    for (int k2 = this.n - 1; k2 >= 2; --k2) {
                        int idx = offa + k2;
                        float tmp = a2[idx];
                        a2[idx] = a2[idx - 1];
                        a2[idx - 1] = tmp;
                    }
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_real_forward(a2, offa);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void realForward(FloatLargeArray a2, long offa) {
        if (!this.useLargeArrays) {
            if (a2.isLarge() || a2.isConstant() || offa >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.realForward(a2.getData(), (int)offa);
            return;
        } else {
            if (this.nl == 1L) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    if (this.nl > 4L) {
                        CommonUtils.cftfsub(this.nl, a2, offa, this.ipl, this.nwl, this.wl);
                        CommonUtils.rftfsub(this.nl, a2, offa, this.ncl, this.wl, this.nwl);
                    } else if (this.nl == 4L) {
                        CommonUtils.cftx020(a2, offa);
                    }
                    float xi = a2.getFloat(offa) - a2.getFloat(offa + 1L);
                    a2.setFloat(offa, a2.getFloat(offa) + a2.getFloat(offa + 1L));
                    a2.setFloat(offa + 1L, xi);
                    return;
                }
                case MIXED_RADIX: {
                    this.rfftf(a2, offa);
                    for (long k2 = this.nl - 1L; k2 >= 2L; --k2) {
                        long idx = offa + k2;
                        float tmp = a2.getFloat(idx);
                        a2.setFloat(idx, a2.getFloat(idx - 1L));
                        a2.setFloat(idx - 1L, tmp);
                    }
                    return;
                }
                case BLUESTEIN: {
                    this.bluestein_real_forward(a2, offa);
                }
            }
        }
    }

    public void realForwardFull(float[] a2) {
        this.realForwardFull(a2, 0);
    }

    public void realForwardFull(FloatLargeArray a2) {
        this.realForwardFull(a2, 0L);
    }

    public void realForwardFull(final float[] a2, final int offa) {
        if (this.useLargeArrays) {
            this.realForwardFull(new FloatLargeArray(a2), (long)offa);
        } else {
            final int twon = 2 * this.n;
            switch (this.plan) {
                case SPLIT_RADIX: {
                    this.realForward(a2, offa);
                    int nthreads = ConcurrencyUtils.getNumberOfThreads();
                    if (nthreads > 1 && (long)(this.n / 2) > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                        Future[] futures = new Future[nthreads];
                        int k2 = this.n / 2 / nthreads;
                        for (int i2 = 0; i2 < nthreads; ++i2) {
                            final int firstIdx = i2 * k2;
                            final int lastIdx = i2 == nthreads - 1 ? this.n / 2 : firstIdx + k2;
                            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                                @Override
                                public void run() {
                                    for (int k2 = firstIdx; k2 < lastIdx; ++k2) {
                                        int idx1 = 2 * k2;
                                        int idx2 = offa + (twon - idx1) % twon;
                                        a2[idx2] = a2[offa + idx1];
                                        a2[idx2 + 1] = -a2[offa + idx1 + 1];
                                    }
                                }
                            });
                        }
                        try {
                            ConcurrencyUtils.waitForCompletion(futures);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (ExecutionException ex) {
                            Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else {
                        for (int k3 = 0; k3 < this.n / 2; ++k3) {
                            int idx1 = 2 * k3;
                            int idx2 = offa + (twon - idx1) % twon;
                            a2[idx2] = a2[offa + idx1];
                            a2[idx2 + 1] = -a2[offa + idx1 + 1];
                        }
                    }
                    a2[offa + this.n] = -a2[offa + 1];
                    a2[offa + 1] = 0.0f;
                    break;
                }
                case MIXED_RADIX: {
                    int k4;
                    this.rfftf(a2, offa);
                    int m4 = this.n % 2 == 0 ? this.n / 2 : (this.n + 1) / 2;
                    for (k4 = 1; k4 < m4; ++k4) {
                        int idx1 = offa + twon - 2 * k4;
                        int idx2 = offa + 2 * k4;
                        a2[idx1 + 1] = -a2[idx2];
                        a2[idx1] = a2[idx2 - 1];
                    }
                    for (k4 = 1; k4 < this.n; ++k4) {
                        int idx = offa + this.n - k4;
                        float tmp = a2[idx + 1];
                        a2[idx + 1] = a2[idx];
                        a2[idx] = tmp;
                    }
                    a2[offa + 1] = 0.0f;
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_real_full(a2, offa, -1);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void realForwardFull(final FloatLargeArray a2, final long offa) {
        if (!this.useLargeArrays) {
            if (a2.isLarge() || a2.isConstant() || offa >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.realForwardFull(a2.getData(), (int)offa);
            return;
        } else {
            final long twon = 2L * this.nl;
            switch (this.plan) {
                case SPLIT_RADIX: {
                    this.realForward(a2, offa);
                    int nthreads = ConcurrencyUtils.getNumberOfThreads();
                    if (nthreads > 1 && this.nl / 2L > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                        Future[] futures = new Future[nthreads];
                        long k2 = this.nl / 2L / (long)nthreads;
                        for (int i2 = 0; i2 < nthreads; ++i2) {
                            final long firstIdx = (long)i2 * k2;
                            final long lastIdx = i2 == nthreads - 1 ? this.nl / 2L : firstIdx + k2;
                            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                                @Override
                                public void run() {
                                    for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                        long idx1 = 2L * k2;
                                        long idx2 = offa + (twon - idx1) % twon;
                                        a2.setFloat(idx2, a2.getFloat(offa + idx1));
                                        a2.setFloat(idx2 + 1L, -a2.getFloat(offa + idx1 + 1L));
                                    }
                                }
                            });
                        }
                        try {
                            ConcurrencyUtils.waitForCompletion(futures);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (ExecutionException ex) {
                            Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else {
                        for (long k3 = 0L; k3 < this.nl / 2L; ++k3) {
                            long idx1 = 2L * k3;
                            long idx2 = offa + (twon - idx1) % twon;
                            a2.setFloat(idx2, a2.getFloat(offa + idx1));
                            a2.setFloat(idx2 + 1L, -a2.getFloat(offa + idx1 + 1L));
                        }
                    }
                    a2.setFloat(offa + this.nl, -a2.getFloat(offa + 1L));
                    a2.setFloat(offa + 1L, 0.0f);
                    return;
                }
                case MIXED_RADIX: {
                    long k4;
                    this.rfftf(a2, offa);
                    long m4 = this.nl % 2L == 0L ? this.nl / 2L : (this.nl + 1L) / 2L;
                    for (k4 = 1L; k4 < m4; ++k4) {
                        long idx1 = offa + twon - 2L * k4;
                        long idx2 = offa + 2L * k4;
                        a2.setFloat(idx1 + 1L, -a2.getFloat(idx2));
                        a2.setFloat(idx1, a2.getFloat(idx2 - 1L));
                    }
                    for (k4 = 1L; k4 < this.nl; ++k4) {
                        long idx = offa + this.nl - k4;
                        float tmp = a2.getFloat(idx + 1L);
                        a2.setFloat(idx + 1L, a2.getFloat(idx));
                        a2.setFloat(idx, tmp);
                    }
                    a2.setFloat(offa + 1L, 0.0f);
                    return;
                }
                case BLUESTEIN: {
                    this.bluestein_real_full(a2, offa, -1L);
                }
            }
        }
    }

    public void realInverse(float[] a2, boolean scale) {
        this.realInverse(a2, 0, scale);
    }

    public void realInverse(FloatLargeArray a2, boolean scale) {
        this.realInverse(a2, 0L, scale);
    }

    public void realInverse(float[] a2, int offa, boolean scale) {
        if (this.useLargeArrays) {
            this.realInverse(new FloatLargeArray(a2), (long)offa, scale);
        } else {
            if (this.n == 1) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    a2[offa + 1] = 0.5f * (a2[offa] - a2[offa + 1]);
                    int n2 = offa;
                    a2[n2] = a2[n2] - a2[offa + 1];
                    if (this.n > 4) {
                        CommonUtils.rftfsub(this.n, a2, offa, this.nc, this.w, this.nw);
                        CommonUtils.cftbsub(this.n, a2, offa, this.ip, this.nw, this.w);
                    } else if (this.n == 4) {
                        CommonUtils.cftxc020(a2, offa);
                    }
                    if (!scale) break;
                    CommonUtils.scale(this.n, 1.0f / ((float)this.n / 2.0f), a2, offa, false);
                    break;
                }
                case MIXED_RADIX: {
                    for (int k2 = 2; k2 < this.n; ++k2) {
                        int idx = offa + k2;
                        float tmp = a2[idx - 1];
                        a2[idx - 1] = a2[idx];
                        a2[idx] = tmp;
                    }
                    this.rfftb(a2, offa);
                    if (!scale) break;
                    CommonUtils.scale(this.n, 1.0f / (float)this.n, a2, offa, false);
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_real_inverse(a2, offa);
                    if (!scale) break;
                    CommonUtils.scale(this.n, 1.0f / (float)this.n, a2, offa, false);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void realInverse(FloatLargeArray a2, long offa, boolean scale) {
        if (!this.useLargeArrays) {
            if (a2.isLarge() || a2.isConstant() || offa >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.realInverse(a2.getData(), (int)offa, scale);
            return;
        } else {
            if (this.nl == 1L) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    a2.setFloat(offa + 1L, 0.5f * (a2.getFloat(offa) - a2.getFloat(offa + 1L)));
                    a2.setFloat(offa, a2.getFloat(offa) - a2.getFloat(offa + 1L));
                    if (this.nl > 4L) {
                        CommonUtils.rftfsub(this.nl, a2, offa, this.ncl, this.wl, this.nwl);
                        CommonUtils.cftbsub(this.nl, a2, offa, this.ipl, this.nwl, this.wl);
                    } else if (this.nl == 4L) {
                        CommonUtils.cftxc020(a2, offa);
                    }
                    if (!scale) return;
                    CommonUtils.scale(this.nl, 1.0f / ((float)this.nl / 2.0f), a2, offa, false);
                    return;
                }
                case MIXED_RADIX: {
                    for (long k2 = 2L; k2 < this.nl; ++k2) {
                        long idx = offa + k2;
                        float tmp = a2.getFloat(idx - 1L);
                        a2.setFloat(idx - 1L, a2.getFloat(idx));
                        a2.setFloat(idx, tmp);
                    }
                    this.rfftb(a2, offa);
                    if (!scale) return;
                    CommonUtils.scale(this.nl, 1.0f / (float)this.nl, a2, offa, false);
                    return;
                }
                case BLUESTEIN: {
                    this.bluestein_real_inverse(a2, offa);
                    if (!scale) return;
                    CommonUtils.scale(this.nl, 1.0f / (float)this.nl, a2, offa, false);
                }
            }
        }
    }

    public void realInverseFull(float[] a2, boolean scale) {
        this.realInverseFull(a2, 0, scale);
    }

    public void realInverseFull(FloatLargeArray a2, boolean scale) {
        this.realInverseFull(a2, 0L, scale);
    }

    public void realInverseFull(final float[] a2, final int offa, boolean scale) {
        if (this.useLargeArrays) {
            this.realInverseFull(new FloatLargeArray(a2), (long)offa, scale);
        } else {
            final int twon = 2 * this.n;
            switch (this.plan) {
                case SPLIT_RADIX: {
                    this.realInverse2(a2, offa, scale);
                    int nthreads = ConcurrencyUtils.getNumberOfThreads();
                    if (nthreads > 1 && (long)(this.n / 2) > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                        Future[] futures = new Future[nthreads];
                        int k2 = this.n / 2 / nthreads;
                        for (int i2 = 0; i2 < nthreads; ++i2) {
                            final int firstIdx = i2 * k2;
                            final int lastIdx = i2 == nthreads - 1 ? this.n / 2 : firstIdx + k2;
                            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                                @Override
                                public void run() {
                                    for (int k2 = firstIdx; k2 < lastIdx; ++k2) {
                                        int idx1 = 2 * k2;
                                        int idx2 = offa + (twon - idx1) % twon;
                                        a2[idx2] = a2[offa + idx1];
                                        a2[idx2 + 1] = -a2[offa + idx1 + 1];
                                    }
                                }
                            });
                        }
                        try {
                            ConcurrencyUtils.waitForCompletion(futures);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (ExecutionException ex) {
                            Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else {
                        for (int k3 = 0; k3 < this.n / 2; ++k3) {
                            int idx1 = 2 * k3;
                            int idx2 = offa + (twon - idx1) % twon;
                            a2[idx2] = a2[offa + idx1];
                            a2[idx2 + 1] = -a2[offa + idx1 + 1];
                        }
                    }
                    a2[offa + this.n] = -a2[offa + 1];
                    a2[offa + 1] = 0.0f;
                    break;
                }
                case MIXED_RADIX: {
                    int k4;
                    this.rfftf(a2, offa);
                    if (scale) {
                        CommonUtils.scale(this.n, 1.0f / (float)this.n, a2, offa, false);
                    }
                    int m4 = this.n % 2 == 0 ? this.n / 2 : (this.n + 1) / 2;
                    for (k4 = 1; k4 < m4; ++k4) {
                        int idx1 = offa + 2 * k4;
                        int idx2 = offa + twon - 2 * k4;
                        a2[idx1] = -a2[idx1];
                        a2[idx2 + 1] = -a2[idx1];
                        a2[idx2] = a2[idx1 - 1];
                    }
                    for (k4 = 1; k4 < this.n; ++k4) {
                        int idx = offa + this.n - k4;
                        float tmp = a2[idx + 1];
                        a2[idx + 1] = a2[idx];
                        a2[idx] = tmp;
                    }
                    a2[offa + 1] = 0.0f;
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_real_full(a2, offa, 1);
                    if (!scale) break;
                    CommonUtils.scale(this.n, 1.0f / (float)this.n, a2, offa, true);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void realInverseFull(final FloatLargeArray a2, final long offa, boolean scale) {
        if (!this.useLargeArrays) {
            if (a2.isLarge() || a2.isConstant() || offa >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.realInverseFull(a2.getData(), (int)offa, scale);
            return;
        } else {
            final long twon = 2L * this.nl;
            switch (this.plan) {
                case SPLIT_RADIX: {
                    this.realInverse2(a2, offa, scale);
                    int nthreads = ConcurrencyUtils.getNumberOfThreads();
                    if (nthreads > 1 && this.nl / 2L > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                        Future[] futures = new Future[nthreads];
                        long k2 = this.nl / 2L / (long)nthreads;
                        for (int i2 = 0; i2 < nthreads; ++i2) {
                            final long firstIdx = (long)i2 * k2;
                            final long lastIdx = i2 == nthreads - 1 ? this.nl / 2L : firstIdx + k2;
                            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                                @Override
                                public void run() {
                                    for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                        long idx1 = 2L * k2;
                                        long idx2 = offa + (twon - idx1) % twon;
                                        a2.setFloat(idx2, a2.getFloat(offa + idx1));
                                        a2.setFloat(idx2 + 1L, -a2.getFloat(offa + idx1 + 1L));
                                    }
                                }
                            });
                        }
                        try {
                            ConcurrencyUtils.waitForCompletion(futures);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (ExecutionException ex) {
                            Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else {
                        for (long k3 = 0L; k3 < this.nl / 2L; ++k3) {
                            long idx1 = 2L * k3;
                            long idx2 = offa + (twon - idx1) % twon;
                            a2.setFloat(idx2, a2.getFloat(offa + idx1));
                            a2.setFloat(idx2 + 1L, -a2.getFloat(offa + idx1 + 1L));
                        }
                    }
                    a2.setFloat(offa + this.nl, -a2.getFloat(offa + 1L));
                    a2.setFloat(offa + 1L, 0.0f);
                    return;
                }
                case MIXED_RADIX: {
                    long k4;
                    this.rfftf(a2, offa);
                    if (scale) {
                        CommonUtils.scale(this.nl, 1.0f / (float)this.nl, a2, offa, false);
                    }
                    long m4 = this.nl % 2L == 0L ? this.nl / 2L : (this.nl + 1L) / 2L;
                    for (k4 = 1L; k4 < m4; ++k4) {
                        long idx1 = offa + 2L * k4;
                        long idx2 = offa + twon - 2L * k4;
                        a2.setFloat(idx1, -a2.getFloat(idx1));
                        a2.setFloat(idx2 + 1L, -a2.getFloat(idx1));
                        a2.setFloat(idx2, a2.getFloat(idx1 - 1L));
                    }
                    for (k4 = 1L; k4 < this.nl; ++k4) {
                        long idx = offa + this.nl - k4;
                        float tmp = a2.getFloat(idx + 1L);
                        a2.setFloat(idx + 1L, a2.getFloat(idx));
                        a2.setFloat(idx, tmp);
                    }
                    a2.setFloat(offa + 1L, 0.0f);
                    return;
                }
                case BLUESTEIN: {
                    this.bluestein_real_full(a2, offa, 1L);
                    if (!scale) return;
                    CommonUtils.scale(this.nl, 1.0f / (float)this.nl, a2, offa, true);
                }
            }
        }
    }

    protected void realInverse2(float[] a2, int offa, boolean scale) {
        if (this.useLargeArrays) {
            this.realInverse2(new FloatLargeArray(a2), (long)offa, scale);
        } else {
            if (this.n == 1) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    if (this.n > 4) {
                        CommonUtils.cftfsub(this.n, a2, offa, this.ip, this.nw, this.w);
                        CommonUtils.rftbsub(this.n, a2, offa, this.nc, this.w, this.nw);
                    } else if (this.n == 4) {
                        CommonUtils.cftbsub(this.n, a2, offa, this.ip, this.nw, this.w);
                    }
                    float xi = a2[offa] - a2[offa + 1];
                    int n2 = offa;
                    a2[n2] = a2[n2] + a2[offa + 1];
                    a2[offa + 1] = xi;
                    if (!scale) break;
                    CommonUtils.scale(this.n, 1.0f / (float)this.n, a2, offa, false);
                    break;
                }
                case MIXED_RADIX: {
                    int i2;
                    int m4;
                    this.rfftf(a2, offa);
                    for (int k2 = this.n - 1; k2 >= 2; --k2) {
                        int idx = offa + k2;
                        float tmp = a2[idx];
                        a2[idx] = a2[idx - 1];
                        a2[idx - 1] = tmp;
                    }
                    if (scale) {
                        CommonUtils.scale(this.n, 1.0f / (float)this.n, a2, offa, false);
                    }
                    if (this.n % 2 == 0) {
                        m4 = this.n / 2;
                        for (i2 = 1; i2 < m4; ++i2) {
                            int idx = offa + 2 * i2 + 1;
                            a2[idx] = -a2[idx];
                        }
                    } else {
                        m4 = (this.n - 1) / 2;
                        for (i2 = 0; i2 < m4; ++i2) {
                            int idx = offa + 2 * i2 + 1;
                            a2[idx] = -a2[idx];
                        }
                    }
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_real_inverse2(a2, offa);
                    if (!scale) break;
                    CommonUtils.scale(this.n, 1.0f / (float)this.n, a2, offa, false);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void realInverse2(FloatLargeArray a2, long offa, boolean scale) {
        if (!this.useLargeArrays) {
            if (a2.isLarge() || a2.isConstant() || offa >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.realInverse2(a2.getData(), (int)offa, scale);
            return;
        }
        if (this.nl == 1L) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                if (this.nl > 4L) {
                    CommonUtils.cftfsub(this.nl, a2, offa, this.ipl, this.nwl, this.wl);
                    CommonUtils.rftbsub(this.nl, a2, offa, this.ncl, this.wl, this.nwl);
                } else if (this.nl == 4L) {
                    CommonUtils.cftbsub(this.nl, a2, offa, this.ipl, this.nwl, this.wl);
                }
                float xi = a2.getFloat(offa) - a2.getFloat(offa + 1L);
                a2.setFloat(offa, a2.getFloat(offa) + a2.getFloat(offa + 1L));
                a2.setFloat(offa + 1L, xi);
                if (!scale) return;
                CommonUtils.scale(this.nl, 1.0f / (float)this.nl, a2, offa, false);
                return;
            }
            case MIXED_RADIX: {
                long i2;
                long m4;
                this.rfftf(a2, offa);
                for (long k2 = this.nl - 1L; k2 >= 2L; --k2) {
                    long idx = offa + k2;
                    float tmp = a2.getFloat(idx);
                    a2.setFloat(idx, a2.getFloat(idx - 1L));
                    a2.setFloat(idx - 1L, tmp);
                }
                if (scale) {
                    CommonUtils.scale(this.nl, 1.0f / (float)this.nl, a2, offa, false);
                }
                if (this.nl % 2L == 0L) {
                    m4 = this.nl / 2L;
                    for (i2 = 1L; i2 < m4; ++i2) {
                        long idx = offa + 2L * i2 + 1L;
                        a2.setFloat(idx, -a2.getFloat(idx));
                    }
                    return;
                } else {
                    m4 = (this.nl - 1L) / 2L;
                    for (i2 = 0L; i2 < m4; ++i2) {
                        long idx = offa + 2L * i2 + 1L;
                        a2.setFloat(idx, -a2.getFloat(idx));
                    }
                }
                return;
            }
            case BLUESTEIN: {
                this.bluestein_real_inverse2(a2, offa);
                if (!scale) return;
                CommonUtils.scale(this.nl, 1.0f / (float)this.nl, a2, offa, false);
            }
        }
    }

    void cffti(int n2, int offw) {
        int idx;
        int i2;
        if (n2 == 1) {
            return;
        }
        int twon = 2 * n2;
        int fourn = 4 * n2;
        int ntry = 0;
        int nll = n2;
        int nf = 0;
        int j2 = 0;
        block0: while (true) {
            ntry = ++j2 <= 4 ? factors[j2 - 1] : (ntry += 2);
            do {
                int nq;
                int nr;
                if ((nr = nll - ntry * (nq = nll / ntry)) != 0) continue block0;
                this.wtable[offw + ++nf + 1 + fourn] = ntry;
                nll = nq;
                if (ntry != 2 || nf == 1) continue;
                for (i2 = 2; i2 <= nf; ++i2) {
                    int ib = nf - i2 + 2;
                    idx = ib + fourn;
                    this.wtable[offw + idx + 1] = this.wtable[offw + idx];
                }
                this.wtable[offw + 2 + fourn] = 2.0f;
            } while (nll != 1);
            break;
        }
        this.wtable[offw + fourn] = n2;
        this.wtable[offw + 1 + fourn] = nf;
        float argh = (float)Math.PI * 2 / (float)n2;
        i2 = 1;
        int l1 = 1;
        for (int k1 = 1; k1 <= nf; ++k1) {
            int ipll = (int)this.wtable[offw + k1 + 1 + fourn];
            int ld = 0;
            int l2 = l1 * ipll;
            int ido = n2 / l2;
            int idot = ido + ido + 2;
            int ipm = ipll - 1;
            for (j2 = 1; j2 <= ipm; ++j2) {
                int i1 = i2;
                this.wtable[offw + i2 - 1 + twon] = 1.0f;
                this.wtable[offw + i2 + twon] = 0.0f;
                float fi = 0.0f;
                float argld = (float)(ld += l1) * argh;
                for (int ii = 4; ii <= idot; ii += 2) {
                    float arg = (fi += 1.0f) * argld;
                    idx = (i2 += 2) + twon;
                    this.wtable[offw + idx - 1] = (float)FastMath.cos((double)arg);
                    this.wtable[offw + idx] = (float)FastMath.sin((double)arg);
                }
                if (ipll <= 5) continue;
                int idx1 = i1 + twon;
                int idx2 = i2 + twon;
                this.wtable[offw + idx1 - 1] = this.wtable[offw + idx2 - 1];
                this.wtable[offw + idx1] = this.wtable[offw + idx2];
            }
            l1 = l2;
        }
    }

    final void cffti() {
        int idx;
        int i2;
        if (this.n == 1) {
            return;
        }
        int twon = 2 * this.n;
        int fourn = 4 * this.n;
        int ntry = 0;
        int nll = this.n;
        int nf = 0;
        int j2 = 0;
        block0: while (true) {
            ntry = ++j2 <= 4 ? factors[j2 - 1] : (ntry += 2);
            do {
                int nq;
                int nr;
                if ((nr = nll - ntry * (nq = nll / ntry)) != 0) continue block0;
                this.wtable[++nf + 1 + fourn] = ntry;
                nll = nq;
                if (ntry != 2 || nf == 1) continue;
                for (i2 = 2; i2 <= nf; ++i2) {
                    int ib = nf - i2 + 2;
                    idx = ib + fourn;
                    this.wtable[idx + 1] = this.wtable[idx];
                }
                this.wtable[2 + fourn] = 2.0f;
            } while (nll != 1);
            break;
        }
        this.wtable[fourn] = this.n;
        this.wtable[1 + fourn] = nf;
        float argh = (float)Math.PI * 2 / (float)this.n;
        i2 = 1;
        int l1 = 1;
        for (int k1 = 1; k1 <= nf; ++k1) {
            int ipll = (int)this.wtable[k1 + 1 + fourn];
            int ld = 0;
            int l2 = l1 * ipll;
            int ido = this.n / l2;
            int idot = ido + ido + 2;
            int ipm = ipll - 1;
            for (j2 = 1; j2 <= ipm; ++j2) {
                int i1 = i2;
                this.wtable[i2 - 1 + twon] = 1.0f;
                this.wtable[i2 + twon] = 0.0f;
                float fi = 0.0f;
                float argld = (float)(ld += l1) * argh;
                for (int ii = 4; ii <= idot; ii += 2) {
                    float arg = (fi += 1.0f) * argld;
                    idx = (i2 += 2) + twon;
                    this.wtable[idx - 1] = (float)FastMath.cos((double)arg);
                    this.wtable[idx] = (float)FastMath.sin((double)arg);
                }
                if (ipll <= 5) continue;
                int idx1 = i1 + twon;
                int idx2 = i2 + twon;
                this.wtable[idx1 - 1] = this.wtable[idx2 - 1];
                this.wtable[idx1] = this.wtable[idx2];
            }
            l1 = l2;
        }
    }

    final void cfftil() {
        long idx;
        long i2;
        if (this.nl == 1L) {
            return;
        }
        long twon = 2L * this.nl;
        long fourn = 4L * this.nl;
        long ntry = 0L;
        long nl2 = this.nl;
        long nf = 0L;
        long j2 = 0L;
        block0: while (true) {
            ntry = ++j2 <= 4L ? (long)factors[(int)(j2 - 1L)] : (ntry += 2L);
            do {
                long nq;
                long nr;
                if ((nr = nl2 - ntry * (nq = nl2 / ntry)) != 0L) continue block0;
                this.wtablel.setFloat(++nf + 1L + fourn, ntry);
                nl2 = nq;
                if (ntry != 2L || nf == 1L) continue;
                for (i2 = 2L; i2 <= nf; ++i2) {
                    long ib = nf - i2 + 2L;
                    idx = ib + fourn;
                    this.wtablel.setFloat(idx + 1L, this.wtablel.getFloat(idx));
                }
                this.wtablel.setFloat(2L + fourn, 2.0f);
            } while (nl2 != 1L);
            break;
        }
        this.wtablel.setFloat(fourn, this.nl);
        this.wtablel.setFloat(1L + fourn, nf);
        float argh = (float)Math.PI * 2 / (float)this.nl;
        i2 = 1L;
        long l1 = 1L;
        for (long k1 = 1L; k1 <= nf; ++k1) {
            long ipll = (long)this.wtablel.getFloat(k1 + 1L + fourn);
            long ld = 0L;
            long l2 = l1 * ipll;
            long ido = this.nl / l2;
            long idot = ido + ido + 2L;
            long ipm = ipll - 1L;
            for (j2 = 1L; j2 <= ipm; ++j2) {
                long i1 = i2;
                this.wtablel.setFloat(i2 - 1L + twon, 1.0f);
                this.wtablel.setFloat(i2 + twon, 0.0f);
                float fi = 0.0f;
                float argld = (float)(ld += l1) * argh;
                for (long ii = 4L; ii <= idot; ii += 2L) {
                    float arg = (fi += 1.0f) * argld;
                    idx = (i2 += 2L) + twon;
                    this.wtablel.setFloat(idx - 1L, (float)FastMath.cos((double)arg));
                    this.wtablel.setFloat(idx, (float)FastMath.sin((double)arg));
                }
                if (ipll <= 5L) continue;
                long idx1 = i1 + twon;
                long idx2 = i2 + twon;
                this.wtablel.setFloat(idx1 - 1L, this.wtablel.getFloat(idx2 - 1L));
                this.wtablel.setFloat(idx1, this.wtablel.getFloat(idx2));
            }
            l1 = l2;
        }
    }

    void rffti() {
        int idx;
        int i2;
        if (this.n == 1) {
            return;
        }
        int twon = 2 * this.n;
        int ntry = 0;
        int nll = this.n;
        int nf = 0;
        int j2 = 0;
        block0: while (true) {
            ntry = ++j2 <= 4 ? factors[j2 - 1] : (ntry += 2);
            do {
                int nq;
                int nr;
                if ((nr = nll - ntry * (nq = nll / ntry)) != 0) continue block0;
                this.wtable_r[++nf + 1 + twon] = ntry;
                nll = nq;
                if (ntry != 2 || nf == 1) continue;
                for (i2 = 2; i2 <= nf; ++i2) {
                    int ib = nf - i2 + 2;
                    idx = ib + twon;
                    this.wtable_r[idx + 1] = this.wtable_r[idx];
                }
                this.wtable_r[2 + twon] = 2.0f;
            } while (nll != 1);
            break;
        }
        this.wtable_r[twon] = this.n;
        this.wtable_r[1 + twon] = nf;
        float argh = (float)Math.PI * 2 / (float)this.n;
        int is = 0;
        int nfm1 = nf - 1;
        int l1 = 1;
        if (nfm1 == 0) {
            return;
        }
        for (int k1 = 1; k1 <= nfm1; ++k1) {
            int ipll = (int)this.wtable_r[k1 + 1 + twon];
            int ld = 0;
            int l2 = l1 * ipll;
            int ido = this.n / l2;
            int ipm = ipll - 1;
            for (j2 = 1; j2 <= ipm; ++j2) {
                i2 = is;
                float argld = (float)(ld += l1) * argh;
                float fi = 0.0f;
                for (int ii = 3; ii <= ido; ii += 2) {
                    float arg = (fi += 1.0f) * argld;
                    idx = (i2 += 2) + this.n;
                    this.wtable_r[idx - 2] = (float)FastMath.cos((double)arg);
                    this.wtable_r[idx - 1] = (float)FastMath.sin((double)arg);
                }
                is += ido;
            }
            l1 = l2;
        }
    }

    void rfftil() {
        long idx;
        long i2;
        if (this.nl == 1L) {
            return;
        }
        long twon = 2L * this.nl;
        long ntry = 0L;
        long nl2 = this.nl;
        long nf = 0L;
        long j2 = 0L;
        block0: while (true) {
            ntry = ++j2 <= 4L ? (long)factors[(int)(j2 - 1L)] : (ntry += 2L);
            do {
                long nq;
                long nr;
                if ((nr = nl2 - ntry * (nq = nl2 / ntry)) != 0L) continue block0;
                this.wtable_rl.setFloat(++nf + 1L + twon, ntry);
                nl2 = nq;
                if (ntry != 2L || nf == 1L) continue;
                for (i2 = 2L; i2 <= nf; ++i2) {
                    long ib = nf - i2 + 2L;
                    idx = ib + twon;
                    this.wtable_rl.setFloat(idx + 1L, this.wtable_rl.getFloat(idx));
                }
                this.wtable_rl.setFloat(2L + twon, 2.0f);
            } while (nl2 != 1L);
            break;
        }
        this.wtable_rl.setFloat(twon, this.nl);
        this.wtable_rl.setFloat(1L + twon, nf);
        float argh = (float)Math.PI * 2 / (float)this.nl;
        long is = 0L;
        long nfm1 = nf - 1L;
        long l1 = 1L;
        if (nfm1 == 0L) {
            return;
        }
        for (long k1 = 1L; k1 <= nfm1; ++k1) {
            long ipll = (long)this.wtable_rl.getFloat(k1 + 1L + twon);
            long ld = 0L;
            long l2 = l1 * ipll;
            long ido = this.nl / l2;
            long ipm = ipll - 1L;
            for (j2 = 1L; j2 <= ipm; ++j2) {
                i2 = is;
                float argld = (float)(ld += l1) * argh;
                float fi = 0.0f;
                for (long ii = 3L; ii <= ido; ii += 2L) {
                    float arg = (fi += 1.0f) * argld;
                    idx = (i2 += 2L) + this.nl;
                    this.wtable_rl.setFloat(idx - 2L, (float)FastMath.cos((double)arg));
                    this.wtable_rl.setFloat(idx - 1L, (float)FastMath.sin((double)arg));
                }
                is += ido;
            }
            l1 = l2;
        }
    }

    private void bluesteini() {
        int k2 = 0;
        float pi_n = (float)Math.PI / (float)this.n;
        this.bk1[0] = 1.0f;
        this.bk1[1] = 0.0f;
        for (int i2 = 1; i2 < this.n; ++i2) {
            if ((k2 += 2 * i2 - 1) >= 2 * this.n) {
                k2 -= 2 * this.n;
            }
            float arg = pi_n * (float)k2;
            this.bk1[2 * i2] = (float)FastMath.cos((double)arg);
            this.bk1[2 * i2 + 1] = (float)FastMath.sin((double)arg);
        }
        float scale = 1.0f / (float)this.nBluestein;
        this.bk2[0] = this.bk1[0] * scale;
        this.bk2[1] = this.bk1[1] * scale;
        for (int i3 = 2; i3 < 2 * this.n; i3 += 2) {
            this.bk2[i3] = this.bk1[i3] * scale;
            this.bk2[i3 + 1] = this.bk1[i3 + 1] * scale;
            this.bk2[2 * this.nBluestein - i3] = this.bk2[i3];
            this.bk2[2 * this.nBluestein - i3 + 1] = this.bk2[i3 + 1];
        }
        CommonUtils.cftbsub(2 * this.nBluestein, this.bk2, 0, this.ip, this.nw, this.w);
    }

    private void bluesteinil() {
        long k2 = 0L;
        float pi_n = (float)Math.PI / (float)this.nl;
        this.bk1l.setFloat(0L, 1.0f);
        this.bk1l.setFloat(1L, 0.0f);
        int i2 = 1;
        while ((long)i2 < this.nl) {
            if ((k2 += (long)(2 * i2 - 1)) >= 2L * this.nl) {
                k2 -= 2L * this.nl;
            }
            float arg = pi_n * (float)k2;
            this.bk1l.setFloat(2 * i2, (float)FastMath.cos((double)arg));
            this.bk1l.setFloat(2 * i2 + 1, (float)FastMath.sin((double)arg));
            ++i2;
        }
        float scale = 1.0f / (float)this.nBluesteinl;
        this.bk2l.setFloat(0L, this.bk1l.getFloat(0L) * scale);
        this.bk2l.setFloat(1L, this.bk1l.getFloat(1L) * scale);
        int i3 = 2;
        while ((long)i3 < 2L * this.nl) {
            this.bk2l.setFloat(i3, this.bk1l.getFloat(i3) * scale);
            this.bk2l.setFloat(i3 + 1, this.bk1l.getFloat(i3 + 1) * scale);
            this.bk2l.setFloat(2L * this.nBluesteinl - (long)i3, this.bk2l.getFloat(i3));
            this.bk2l.setFloat(2L * this.nBluesteinl - (long)i3 + 1L, this.bk2l.getFloat(i3 + 1));
            i3 += 2;
        }
        CommonUtils.cftbsub(2L * this.nBluesteinl, this.bk2l, 0L, this.ipl, this.nwl, this.wl);
    }

    private void bluestein_complex(final float[] a2, final int offa, final int isign) {
        final float[] ak = new float[2 * this.nBluestein];
        int threads = ConcurrencyUtils.getNumberOfThreads();
        if (threads > 1 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int lastIdx;
            int firstIdx;
            int nthreads = 2;
            if (threads >= 4 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                nthreads = 4;
            }
            Future[] futures = new Future[nthreads];
            int k2 = this.n / nthreads;
            for (int i2 = 0; i2 < nthreads; ++i2) {
                firstIdx = i2 * k2;
                lastIdx = i2 == nthreads - 1 ? this.n : firstIdx + k2;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (isign > 0) {
                            for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                                int idx1 = 2 * i2;
                                int idx2 = idx1 + 1;
                                int idx3 = offa + idx1;
                                int idx4 = offa + idx2;
                                ak[idx1] = a2[idx3] * FloatFFT_1D.this.bk1[idx1] - a2[idx4] * FloatFFT_1D.this.bk1[idx2];
                                ak[idx2] = a2[idx3] * FloatFFT_1D.this.bk1[idx2] + a2[idx4] * FloatFFT_1D.this.bk1[idx1];
                            }
                        } else {
                            for (int i3 = firstIdx; i3 < lastIdx; ++i3) {
                                int idx1 = 2 * i3;
                                int idx2 = idx1 + 1;
                                int idx3 = offa + idx1;
                                int idx4 = offa + idx2;
                                ak[idx1] = a2[idx3] * FloatFFT_1D.this.bk1[idx1] + a2[idx4] * FloatFFT_1D.this.bk1[idx2];
                                ak[idx2] = -a2[idx3] * FloatFFT_1D.this.bk1[idx2] + a2[idx4] * FloatFFT_1D.this.bk1[idx1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            CommonUtils.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            k2 = this.nBluestein / nthreads;
            for (int i3 = 0; i3 < nthreads; ++i3) {
                firstIdx = i3 * k2;
                lastIdx = i3 == nthreads - 1 ? this.nBluestein : firstIdx + k2;
                futures[i3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (isign > 0) {
                            for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                                int idx1 = 2 * i2;
                                int idx2 = idx1 + 1;
                                float im = -ak[idx1] * FloatFFT_1D.this.bk2[idx2] + ak[idx2] * FloatFFT_1D.this.bk2[idx1];
                                ak[idx1] = ak[idx1] * FloatFFT_1D.this.bk2[idx1] + ak[idx2] * FloatFFT_1D.this.bk2[idx2];
                                ak[idx2] = im;
                            }
                        } else {
                            for (int i3 = firstIdx; i3 < lastIdx; ++i3) {
                                int idx1 = 2 * i3;
                                int idx2 = idx1 + 1;
                                float im = ak[idx1] * FloatFFT_1D.this.bk2[idx2] + ak[idx2] * FloatFFT_1D.this.bk2[idx1];
                                ak[idx1] = ak[idx1] * FloatFFT_1D.this.bk2[idx1] - ak[idx2] * FloatFFT_1D.this.bk2[idx2];
                                ak[idx2] = im;
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            CommonUtils.cftfsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            k2 = this.n / nthreads;
            for (int i4 = 0; i4 < nthreads; ++i4) {
                firstIdx = i4 * k2;
                lastIdx = i4 == nthreads - 1 ? this.n : firstIdx + k2;
                futures[i4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (isign > 0) {
                            for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                                int idx1 = 2 * i2;
                                int idx2 = idx1 + 1;
                                int idx3 = offa + idx1;
                                int idx4 = offa + idx2;
                                a2[idx3] = FloatFFT_1D.this.bk1[idx1] * ak[idx1] - FloatFFT_1D.this.bk1[idx2] * ak[idx2];
                                a2[idx4] = FloatFFT_1D.this.bk1[idx2] * ak[idx1] + FloatFFT_1D.this.bk1[idx1] * ak[idx2];
                            }
                        } else {
                            for (int i3 = firstIdx; i3 < lastIdx; ++i3) {
                                int idx1 = 2 * i3;
                                int idx2 = idx1 + 1;
                                int idx3 = offa + idx1;
                                int idx4 = offa + idx2;
                                a2[idx3] = FloatFFT_1D.this.bk1[idx1] * ak[idx1] + FloatFFT_1D.this.bk1[idx2] * ak[idx2];
                                a2[idx4] = -FloatFFT_1D.this.bk1[idx2] * ak[idx1] + FloatFFT_1D.this.bk1[idx1] * ak[idx2];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx4;
            int idx3;
            int idx2;
            int idx1;
            int i5;
            if (isign > 0) {
                for (i5 = 0; i5 < this.n; ++i5) {
                    idx1 = 2 * i5;
                    idx2 = idx1 + 1;
                    idx3 = offa + idx1;
                    idx4 = offa + idx2;
                    ak[idx1] = a2[idx3] * this.bk1[idx1] - a2[idx4] * this.bk1[idx2];
                    ak[idx2] = a2[idx3] * this.bk1[idx2] + a2[idx4] * this.bk1[idx1];
                }
            } else {
                for (i5 = 0; i5 < this.n; ++i5) {
                    idx1 = 2 * i5;
                    idx2 = idx1 + 1;
                    idx3 = offa + idx1;
                    idx4 = offa + idx2;
                    ak[idx1] = a2[idx3] * this.bk1[idx1] + a2[idx4] * this.bk1[idx2];
                    ak[idx2] = -a2[idx3] * this.bk1[idx2] + a2[idx4] * this.bk1[idx1];
                }
            }
            CommonUtils.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            if (isign > 0) {
                for (i5 = 0; i5 < this.nBluestein; ++i5) {
                    idx1 = 2 * i5;
                    idx2 = idx1 + 1;
                    float im = -ak[idx1] * this.bk2[idx2] + ak[idx2] * this.bk2[idx1];
                    ak[idx1] = ak[idx1] * this.bk2[idx1] + ak[idx2] * this.bk2[idx2];
                    ak[idx2] = im;
                }
            } else {
                for (i5 = 0; i5 < this.nBluestein; ++i5) {
                    idx1 = 2 * i5;
                    idx2 = idx1 + 1;
                    float im = ak[idx1] * this.bk2[idx2] + ak[idx2] * this.bk2[idx1];
                    ak[idx1] = ak[idx1] * this.bk2[idx1] - ak[idx2] * this.bk2[idx2];
                    ak[idx2] = im;
                }
            }
            CommonUtils.cftfsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            if (isign > 0) {
                for (i5 = 0; i5 < this.n; ++i5) {
                    idx1 = 2 * i5;
                    idx2 = idx1 + 1;
                    int idx32 = offa + idx1;
                    idx4 = offa + idx2;
                    a2[idx32] = this.bk1[idx1] * ak[idx1] - this.bk1[idx2] * ak[idx2];
                    a2[idx4] = this.bk1[idx2] * ak[idx1] + this.bk1[idx1] * ak[idx2];
                }
            } else {
                for (i5 = 0; i5 < this.n; ++i5) {
                    idx1 = 2 * i5;
                    idx2 = idx1 + 1;
                    int idx33 = offa + idx1;
                    idx4 = offa + idx2;
                    a2[idx33] = this.bk1[idx1] * ak[idx1] + this.bk1[idx2] * ak[idx2];
                    a2[idx4] = -this.bk1[idx2] * ak[idx1] + this.bk1[idx1] * ak[idx2];
                }
            }
        }
    }

    private void bluestein_complex(final FloatLargeArray a2, final long offa, final int isign) {
        final FloatLargeArray ak = new FloatLargeArray(2L * this.nBluesteinl);
        int threads = ConcurrencyUtils.getNumberOfThreads();
        if (threads > 1 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long lastIdx;
            long firstIdx;
            int nthreads = 2;
            if (threads >= 4 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                nthreads = 4;
            }
            Future[] futures = new Future[nthreads];
            long k2 = this.nl / (long)nthreads;
            for (int i2 = 0; i2 < nthreads; ++i2) {
                firstIdx = (long)i2 * k2;
                lastIdx = i2 == nthreads - 1 ? this.nl : firstIdx + k2;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (isign > 0) {
                            for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                                long idx1 = 2L * i2;
                                long idx2 = idx1 + 1L;
                                long idx3 = offa + idx1;
                                long idx4 = offa + idx2;
                                ak.setFloat(idx1, a2.getFloat(idx3) * FloatFFT_1D.this.bk1l.getFloat(idx1) - a2.getFloat(idx4) * FloatFFT_1D.this.bk1l.getFloat(idx2));
                                ak.setFloat(idx2, a2.getFloat(idx3) * FloatFFT_1D.this.bk1l.getFloat(idx2) + a2.getFloat(idx4) * FloatFFT_1D.this.bk1l.getFloat(idx1));
                            }
                        } else {
                            for (long i3 = firstIdx; i3 < lastIdx; ++i3) {
                                long idx1 = 2L * i3;
                                long idx2 = idx1 + 1L;
                                long idx3 = offa + idx1;
                                long idx4 = offa + idx2;
                                ak.setFloat(idx1, a2.getFloat(idx3) * FloatFFT_1D.this.bk1l.getFloat(idx1) + a2.getFloat(idx4) * FloatFFT_1D.this.bk1l.getFloat(idx2));
                                ak.setFloat(idx2, -a2.getFloat(idx3) * FloatFFT_1D.this.bk1l.getFloat(idx2) + a2.getFloat(idx4) * FloatFFT_1D.this.bk1l.getFloat(idx1));
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
            k2 = this.nBluesteinl / (long)nthreads;
            for (int i3 = 0; i3 < nthreads; ++i3) {
                firstIdx = (long)i3 * k2;
                lastIdx = i3 == nthreads - 1 ? this.nBluesteinl : firstIdx + k2;
                futures[i3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (isign > 0) {
                            for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                                long idx1 = 2L * i2;
                                long idx2 = idx1 + 1L;
                                float im = -ak.getFloat(idx1) * FloatFFT_1D.this.bk2l.getFloat(idx2) + ak.getFloat(idx2) * FloatFFT_1D.this.bk2l.getFloat(idx1);
                                ak.setFloat(idx1, ak.getFloat(idx1) * FloatFFT_1D.this.bk2l.getFloat(idx1) + ak.getFloat(idx2) * FloatFFT_1D.this.bk2l.getFloat(idx2));
                                ak.setFloat(idx2, im);
                            }
                        } else {
                            for (long i3 = firstIdx; i3 < lastIdx; ++i3) {
                                long idx1 = 2L * i3;
                                long idx2 = idx1 + 1L;
                                float im = ak.getFloat(idx1) * FloatFFT_1D.this.bk2l.getFloat(idx2) + ak.getFloat(idx2) * FloatFFT_1D.this.bk2l.getFloat(idx1);
                                ak.setFloat(idx1, ak.getFloat(idx1) * FloatFFT_1D.this.bk2l.getFloat(idx1) - ak.getFloat(idx2) * FloatFFT_1D.this.bk2l.getFloat(idx2));
                                ak.setFloat(idx2, im);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
            k2 = this.nl / (long)nthreads;
            for (int i4 = 0; i4 < nthreads; ++i4) {
                firstIdx = (long)i4 * k2;
                lastIdx = i4 == nthreads - 1 ? this.nl : firstIdx + k2;
                futures[i4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (isign > 0) {
                            for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                                long idx1 = 2L * i2;
                                long idx2 = idx1 + 1L;
                                long idx3 = offa + idx1;
                                long idx4 = offa + idx2;
                                a2.setFloat(idx3, FloatFFT_1D.this.bk1l.getFloat(idx1) * ak.getFloat(idx1) - FloatFFT_1D.this.bk1l.getFloat(idx2) * ak.getFloat(idx2));
                                a2.setFloat(idx4, FloatFFT_1D.this.bk1l.getFloat(idx2) * ak.getFloat(idx1) + FloatFFT_1D.this.bk1l.getFloat(idx1) * ak.getFloat(idx2));
                            }
                        } else {
                            for (long i3 = firstIdx; i3 < lastIdx; ++i3) {
                                long idx1 = 2L * i3;
                                long idx2 = idx1 + 1L;
                                long idx3 = offa + idx1;
                                long idx4 = offa + idx2;
                                a2.setFloat(idx3, FloatFFT_1D.this.bk1l.getFloat(idx1) * ak.getFloat(idx1) + FloatFFT_1D.this.bk1l.getFloat(idx2) * ak.getFloat(idx2));
                                a2.setFloat(idx4, -FloatFFT_1D.this.bk1l.getFloat(idx2) * ak.getFloat(idx1) + FloatFFT_1D.this.bk1l.getFloat(idx1) * ak.getFloat(idx2));
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx4;
            long idx3;
            long idx2;
            long idx1;
            long i5;
            if (isign > 0) {
                for (i5 = 0L; i5 < this.nl; ++i5) {
                    idx1 = 2L * i5;
                    idx2 = idx1 + 1L;
                    idx3 = offa + idx1;
                    idx4 = offa + idx2;
                    ak.setFloat(idx1, a2.getFloat(idx3) * this.bk1l.getFloat(idx1) - a2.getFloat(idx4) * this.bk1l.getFloat(idx2));
                    ak.setFloat(idx2, a2.getFloat(idx3) * this.bk1l.getFloat(idx2) + a2.getFloat(idx4) * this.bk1l.getFloat(idx1));
                }
            } else {
                for (i5 = 0L; i5 < this.nl; ++i5) {
                    idx1 = 2L * i5;
                    idx2 = idx1 + 1L;
                    idx3 = offa + idx1;
                    idx4 = offa + idx2;
                    ak.setFloat(idx1, a2.getFloat(idx3) * this.bk1l.getFloat(idx1) + a2.getFloat(idx4) * this.bk1l.getFloat(idx2));
                    ak.setFloat(idx2, -a2.getFloat(idx3) * this.bk1l.getFloat(idx2) + a2.getFloat(idx4) * this.bk1l.getFloat(idx1));
                }
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
            if (isign > 0) {
                for (i5 = 0L; i5 < this.nBluesteinl; ++i5) {
                    idx1 = 2L * i5;
                    idx2 = idx1 + 1L;
                    float im = -ak.getFloat(idx1) * this.bk2l.getFloat(idx2) + ak.getFloat(idx2) * this.bk2l.getFloat(idx1);
                    ak.setFloat(idx1, ak.getFloat(idx1) * this.bk2l.getFloat(idx1) + ak.getFloat(idx2) * this.bk2l.getFloat(idx2));
                    ak.setFloat(idx2, im);
                }
            } else {
                for (i5 = 0L; i5 < this.nBluesteinl; ++i5) {
                    idx1 = 2L * i5;
                    idx2 = idx1 + 1L;
                    float im = ak.getFloat(idx1) * this.bk2l.getFloat(idx2) + ak.getFloat(idx2) * this.bk2l.getFloat(idx1);
                    ak.setFloat(idx1, ak.getFloat(idx1) * this.bk2l.getFloat(idx1) - ak.getFloat(idx2) * this.bk2l.getFloat(idx2));
                    ak.setFloat(idx2, im);
                }
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
            if (isign > 0) {
                for (i5 = 0L; i5 < this.nl; ++i5) {
                    idx1 = 2L * i5;
                    idx2 = idx1 + 1L;
                    long idx32 = offa + idx1;
                    idx4 = offa + idx2;
                    a2.setFloat(idx32, this.bk1l.getFloat(idx1) * ak.getFloat(idx1) - this.bk1l.getFloat(idx2) * ak.getFloat(idx2));
                    a2.setFloat(idx4, this.bk1l.getFloat(idx2) * ak.getFloat(idx1) + this.bk1l.getFloat(idx1) * ak.getFloat(idx2));
                }
            } else {
                for (i5 = 0L; i5 < this.nl; ++i5) {
                    idx1 = 2L * i5;
                    idx2 = idx1 + 1L;
                    long idx33 = offa + idx1;
                    idx4 = offa + idx2;
                    a2.setFloat(idx33, this.bk1l.getFloat(idx1) * ak.getFloat(idx1) + this.bk1l.getFloat(idx2) * ak.getFloat(idx2));
                    a2.setFloat(idx4, -this.bk1l.getFloat(idx2) * ak.getFloat(idx1) + this.bk1l.getFloat(idx1) * ak.getFloat(idx2));
                }
            }
        }
    }

    private void bluestein_real_full(final float[] a2, final int offa, final int isign) {
        final float[] ak = new float[2 * this.nBluestein];
        int threads = ConcurrencyUtils.getNumberOfThreads();
        if (threads > 1 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int lastIdx;
            int firstIdx;
            int nthreads = 2;
            if (threads >= 4 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                nthreads = 4;
            }
            Future[] futures = new Future[nthreads];
            int k2 = this.n / nthreads;
            for (int i2 = 0; i2 < nthreads; ++i2) {
                firstIdx = i2 * k2;
                lastIdx = i2 == nthreads - 1 ? this.n : firstIdx + k2;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (isign > 0) {
                            for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                                int idx1 = 2 * i2;
                                int idx2 = idx1 + 1;
                                int idx3 = offa + i2;
                                ak[idx1] = a2[idx3] * FloatFFT_1D.this.bk1[idx1];
                                ak[idx2] = a2[idx3] * FloatFFT_1D.this.bk1[idx2];
                            }
                        } else {
                            for (int i3 = firstIdx; i3 < lastIdx; ++i3) {
                                int idx1 = 2 * i3;
                                int idx2 = idx1 + 1;
                                int idx3 = offa + i3;
                                ak[idx1] = a2[idx3] * FloatFFT_1D.this.bk1[idx1];
                                ak[idx2] = -a2[idx3] * FloatFFT_1D.this.bk1[idx2];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            CommonUtils.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            k2 = this.nBluestein / nthreads;
            for (int i3 = 0; i3 < nthreads; ++i3) {
                firstIdx = i3 * k2;
                lastIdx = i3 == nthreads - 1 ? this.nBluestein : firstIdx + k2;
                futures[i3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (isign > 0) {
                            for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                                int idx1 = 2 * i2;
                                int idx2 = idx1 + 1;
                                float im = -ak[idx1] * FloatFFT_1D.this.bk2[idx2] + ak[idx2] * FloatFFT_1D.this.bk2[idx1];
                                ak[idx1] = ak[idx1] * FloatFFT_1D.this.bk2[idx1] + ak[idx2] * FloatFFT_1D.this.bk2[idx2];
                                ak[idx2] = im;
                            }
                        } else {
                            for (int i3 = firstIdx; i3 < lastIdx; ++i3) {
                                int idx1 = 2 * i3;
                                int idx2 = idx1 + 1;
                                float im = ak[idx1] * FloatFFT_1D.this.bk2[idx2] + ak[idx2] * FloatFFT_1D.this.bk2[idx1];
                                ak[idx1] = ak[idx1] * FloatFFT_1D.this.bk2[idx1] - ak[idx2] * FloatFFT_1D.this.bk2[idx2];
                                ak[idx2] = im;
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            CommonUtils.cftfsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            k2 = this.n / nthreads;
            for (int i4 = 0; i4 < nthreads; ++i4) {
                firstIdx = i4 * k2;
                lastIdx = i4 == nthreads - 1 ? this.n : firstIdx + k2;
                futures[i4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (isign > 0) {
                            for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                                int idx1 = 2 * i2;
                                int idx2 = idx1 + 1;
                                a2[offa + idx1] = FloatFFT_1D.this.bk1[idx1] * ak[idx1] - FloatFFT_1D.this.bk1[idx2] * ak[idx2];
                                a2[offa + idx2] = FloatFFT_1D.this.bk1[idx2] * ak[idx1] + FloatFFT_1D.this.bk1[idx1] * ak[idx2];
                            }
                        } else {
                            for (int i3 = firstIdx; i3 < lastIdx; ++i3) {
                                int idx1 = 2 * i3;
                                int idx2 = idx1 + 1;
                                a2[offa + idx1] = FloatFFT_1D.this.bk1[idx1] * ak[idx1] + FloatFFT_1D.this.bk1[idx2] * ak[idx2];
                                a2[offa + idx2] = -FloatFFT_1D.this.bk1[idx2] * ak[idx1] + FloatFFT_1D.this.bk1[idx1] * ak[idx2];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx3;
            int idx2;
            int idx1;
            int i5;
            if (isign > 0) {
                for (i5 = 0; i5 < this.n; ++i5) {
                    idx1 = 2 * i5;
                    idx2 = idx1 + 1;
                    idx3 = offa + i5;
                    ak[idx1] = a2[idx3] * this.bk1[idx1];
                    ak[idx2] = a2[idx3] * this.bk1[idx2];
                }
            } else {
                for (i5 = 0; i5 < this.n; ++i5) {
                    idx1 = 2 * i5;
                    idx2 = idx1 + 1;
                    idx3 = offa + i5;
                    ak[idx1] = a2[idx3] * this.bk1[idx1];
                    ak[idx2] = -a2[idx3] * this.bk1[idx2];
                }
            }
            CommonUtils.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            if (isign > 0) {
                for (i5 = 0; i5 < this.nBluestein; ++i5) {
                    idx1 = 2 * i5;
                    idx2 = idx1 + 1;
                    float im = -ak[idx1] * this.bk2[idx2] + ak[idx2] * this.bk2[idx1];
                    ak[idx1] = ak[idx1] * this.bk2[idx1] + ak[idx2] * this.bk2[idx2];
                    ak[idx2] = im;
                }
            } else {
                for (i5 = 0; i5 < this.nBluestein; ++i5) {
                    idx1 = 2 * i5;
                    idx2 = idx1 + 1;
                    float im = ak[idx1] * this.bk2[idx2] + ak[idx2] * this.bk2[idx1];
                    ak[idx1] = ak[idx1] * this.bk2[idx1] - ak[idx2] * this.bk2[idx2];
                    ak[idx2] = im;
                }
            }
            CommonUtils.cftfsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            if (isign > 0) {
                for (i5 = 0; i5 < this.n; ++i5) {
                    idx1 = 2 * i5;
                    idx2 = idx1 + 1;
                    a2[offa + idx1] = this.bk1[idx1] * ak[idx1] - this.bk1[idx2] * ak[idx2];
                    a2[offa + idx2] = this.bk1[idx2] * ak[idx1] + this.bk1[idx1] * ak[idx2];
                }
            } else {
                for (i5 = 0; i5 < this.n; ++i5) {
                    idx1 = 2 * i5;
                    idx2 = idx1 + 1;
                    a2[offa + idx1] = this.bk1[idx1] * ak[idx1] + this.bk1[idx2] * ak[idx2];
                    a2[offa + idx2] = -this.bk1[idx2] * ak[idx1] + this.bk1[idx1] * ak[idx2];
                }
            }
        }
    }

    private void bluestein_real_full(final FloatLargeArray a2, final long offa, final long isign) {
        final FloatLargeArray ak = new FloatLargeArray(2L * this.nBluesteinl);
        int threads = ConcurrencyUtils.getNumberOfThreads();
        if (threads > 1 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long lastIdx;
            long firstIdx;
            int nthreads = 2;
            if (threads >= 4 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                nthreads = 4;
            }
            Future[] futures = new Future[nthreads];
            long k2 = this.nl / (long)nthreads;
            for (int i2 = 0; i2 < nthreads; ++i2) {
                firstIdx = (long)i2 * k2;
                lastIdx = i2 == nthreads - 1 ? this.nl : firstIdx + k2;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (isign > 0L) {
                            for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                                long idx1 = 2L * i2;
                                long idx2 = idx1 + 1L;
                                long idx3 = offa + i2;
                                ak.setFloat(idx1, a2.getFloat(idx3) * FloatFFT_1D.this.bk1l.getFloat(idx1));
                                ak.setFloat(idx2, a2.getFloat(idx3) * FloatFFT_1D.this.bk1l.getFloat(idx2));
                            }
                        } else {
                            for (long i3 = firstIdx; i3 < lastIdx; ++i3) {
                                long idx1 = 2L * i3;
                                long idx2 = idx1 + 1L;
                                long idx3 = offa + i3;
                                ak.setFloat(idx1, a2.getFloat(idx3) * FloatFFT_1D.this.bk1l.getFloat(idx1));
                                ak.setFloat(idx2, -a2.getFloat(idx3) * FloatFFT_1D.this.bk1l.getFloat(idx2));
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
            k2 = this.nBluesteinl / (long)nthreads;
            for (int i3 = 0; i3 < nthreads; ++i3) {
                firstIdx = (long)i3 * k2;
                lastIdx = i3 == nthreads - 1 ? this.nBluesteinl : firstIdx + k2;
                futures[i3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (isign > 0L) {
                            for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                                long idx1 = 2L * i2;
                                long idx2 = idx1 + 1L;
                                float im = -ak.getFloat(idx1) * FloatFFT_1D.this.bk2l.getFloat(idx2) + ak.getFloat(idx2) * FloatFFT_1D.this.bk2l.getFloat(idx1);
                                ak.setFloat(idx1, ak.getFloat(idx1) * FloatFFT_1D.this.bk2l.getFloat(idx1) + ak.getFloat(idx2) * FloatFFT_1D.this.bk2l.getFloat(idx2));
                                ak.setFloat(idx2, im);
                            }
                        } else {
                            for (long i3 = firstIdx; i3 < lastIdx; ++i3) {
                                long idx1 = 2L * i3;
                                long idx2 = idx1 + 1L;
                                float im = ak.getFloat(idx1) * FloatFFT_1D.this.bk2l.getFloat(idx2) + ak.getFloat(idx2) * FloatFFT_1D.this.bk2l.getFloat(idx1);
                                ak.setFloat(idx1, ak.getFloat(idx1) * FloatFFT_1D.this.bk2l.getFloat(idx1) - ak.getFloat(idx2) * FloatFFT_1D.this.bk2l.getFloat(idx2));
                                ak.setFloat(idx2, im);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
            k2 = this.nl / (long)nthreads;
            for (int i4 = 0; i4 < nthreads; ++i4) {
                firstIdx = (long)i4 * k2;
                lastIdx = i4 == nthreads - 1 ? this.nl : firstIdx + k2;
                futures[i4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (isign > 0L) {
                            for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                                long idx1 = 2L * i2;
                                long idx2 = idx1 + 1L;
                                a2.setFloat(offa + idx1, FloatFFT_1D.this.bk1l.getFloat(idx1) * ak.getFloat(idx1) - FloatFFT_1D.this.bk1l.getFloat(idx2) * ak.getFloat(idx2));
                                a2.setFloat(offa + idx2, FloatFFT_1D.this.bk1l.getFloat(idx2) * ak.getFloat(idx1) + FloatFFT_1D.this.bk1l.getFloat(idx1) * ak.getFloat(idx2));
                            }
                        } else {
                            for (long i3 = firstIdx; i3 < lastIdx; ++i3) {
                                long idx1 = 2L * i3;
                                long idx2 = idx1 + 1L;
                                a2.setFloat(offa + idx1, FloatFFT_1D.this.bk1l.getFloat(idx1) * ak.getFloat(idx1) + FloatFFT_1D.this.bk1l.getFloat(idx2) * ak.getFloat(idx2));
                                a2.setFloat(offa + idx2, -FloatFFT_1D.this.bk1l.getFloat(idx2) * ak.getFloat(idx1) + FloatFFT_1D.this.bk1l.getFloat(idx1) * ak.getFloat(idx2));
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx3;
            long idx2;
            long idx1;
            long i5;
            if (isign > 0L) {
                for (i5 = 0L; i5 < this.nl; ++i5) {
                    idx1 = 2L * i5;
                    idx2 = idx1 + 1L;
                    idx3 = offa + i5;
                    ak.setFloat(idx1, a2.getFloat(idx3) * this.bk1l.getFloat(idx1));
                    ak.setFloat(idx2, a2.getFloat(idx3) * this.bk1l.getFloat(idx2));
                }
            } else {
                for (i5 = 0L; i5 < this.nl; ++i5) {
                    idx1 = 2L * i5;
                    idx2 = idx1 + 1L;
                    idx3 = offa + i5;
                    ak.setFloat(idx1, a2.getFloat(idx3) * this.bk1l.getFloat(idx1));
                    ak.setFloat(idx2, -a2.getFloat(idx3) * this.bk1l.getFloat(idx2));
                }
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
            if (isign > 0L) {
                for (i5 = 0L; i5 < this.nBluesteinl; ++i5) {
                    idx1 = 2L * i5;
                    idx2 = idx1 + 1L;
                    float im = -ak.getFloat(idx1) * this.bk2l.getFloat(idx2) + ak.getFloat(idx2) * this.bk2l.getFloat(idx1);
                    ak.setFloat(idx1, ak.getFloat(idx1) * this.bk2l.getFloat(idx1) + ak.getFloat(idx2) * this.bk2l.getFloat(idx2));
                    ak.setFloat(idx2, im);
                }
            } else {
                for (i5 = 0L; i5 < this.nBluesteinl; ++i5) {
                    idx1 = 2L * i5;
                    idx2 = idx1 + 1L;
                    float im = ak.getFloat(idx1) * this.bk2l.getFloat(idx2) + ak.getFloat(idx2) * this.bk2l.getFloat(idx1);
                    ak.setFloat(idx1, ak.getFloat(idx1) * this.bk2l.getFloat(idx1) - ak.getFloat(idx2) * this.bk2l.getFloat(idx2));
                    ak.setFloat(idx2, im);
                }
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
            if (isign > 0L) {
                for (i5 = 0L; i5 < this.nl; ++i5) {
                    idx1 = 2L * i5;
                    idx2 = idx1 + 1L;
                    a2.setFloat(offa + idx1, this.bk1l.getFloat(idx1) * ak.getFloat(idx1) - this.bk1l.getFloat(idx2) * ak.getFloat(idx2));
                    a2.setFloat(offa + idx2, this.bk1l.getFloat(idx2) * ak.getFloat(idx1) + this.bk1l.getFloat(idx1) * ak.getFloat(idx2));
                }
            } else {
                for (i5 = 0L; i5 < this.nl; ++i5) {
                    idx1 = 2L * i5;
                    idx2 = idx1 + 1L;
                    a2.setFloat(offa + idx1, this.bk1l.getFloat(idx1) * ak.getFloat(idx1) + this.bk1l.getFloat(idx2) * ak.getFloat(idx2));
                    a2.setFloat(offa + idx2, -this.bk1l.getFloat(idx2) * ak.getFloat(idx1) + this.bk1l.getFloat(idx1) * ak.getFloat(idx2));
                }
            }
        }
    }

    private void bluestein_real_forward(final float[] a2, final int offa) {
        int idx2;
        int i2;
        final float[] ak = new float[2 * this.nBluestein];
        int threads = ConcurrencyUtils.getNumberOfThreads();
        if (threads > 1 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int lastIdx;
            int firstIdx;
            int nthreads = 2;
            if (threads >= 4 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                nthreads = 4;
            }
            Future[] futures = new Future[nthreads];
            int k2 = this.n / nthreads;
            for (int i3 = 0; i3 < nthreads; ++i3) {
                firstIdx = i3 * k2;
                lastIdx = i3 == nthreads - 1 ? this.n : firstIdx + k2;
                futures[i3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                            int idx1 = 2 * i2;
                            int idx2 = idx1 + 1;
                            int idx3 = offa + i2;
                            ak[idx1] = a2[idx3] * FloatFFT_1D.this.bk1[idx1];
                            ak[idx2] = -a2[idx3] * FloatFFT_1D.this.bk1[idx2];
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            CommonUtils.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            k2 = this.nBluestein / nthreads;
            for (int i4 = 0; i4 < nthreads; ++i4) {
                firstIdx = i4 * k2;
                lastIdx = i4 == nthreads - 1 ? this.nBluestein : firstIdx + k2;
                futures[i4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                            int idx1 = 2 * i2;
                            int idx2 = idx1 + 1;
                            float im = ak[idx1] * FloatFFT_1D.this.bk2[idx2] + ak[idx2] * FloatFFT_1D.this.bk2[idx1];
                            ak[idx1] = ak[idx1] * FloatFFT_1D.this.bk2[idx1] - ak[idx2] * FloatFFT_1D.this.bk2[idx2];
                            ak[idx2] = im;
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx1;
            for (i2 = 0; i2 < this.n; ++i2) {
                idx1 = 2 * i2;
                idx2 = idx1 + 1;
                int idx3 = offa + i2;
                ak[idx1] = a2[idx3] * this.bk1[idx1];
                ak[idx2] = -a2[idx3] * this.bk1[idx2];
            }
            CommonUtils.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            for (i2 = 0; i2 < this.nBluestein; ++i2) {
                idx1 = 2 * i2;
                idx2 = idx1 + 1;
                float im = ak[idx1] * this.bk2[idx2] + ak[idx2] * this.bk2[idx1];
                ak[idx1] = ak[idx1] * this.bk2[idx1] - ak[idx2] * this.bk2[idx2];
                ak[idx2] = im;
            }
        }
        CommonUtils.cftfsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
        if (this.n % 2 == 0) {
            a2[offa] = this.bk1[0] * ak[0] + this.bk1[1] * ak[1];
            a2[offa + 1] = this.bk1[this.n] * ak[this.n] + this.bk1[this.n + 1] * ak[this.n + 1];
            for (i2 = 1; i2 < this.n / 2; ++i2) {
                int idx1 = 2 * i2;
                idx2 = idx1 + 1;
                a2[offa + idx1] = this.bk1[idx1] * ak[idx1] + this.bk1[idx2] * ak[idx2];
                a2[offa + idx2] = -this.bk1[idx2] * ak[idx1] + this.bk1[idx1] * ak[idx2];
            }
        } else {
            a2[offa] = this.bk1[0] * ak[0] + this.bk1[1] * ak[1];
            a2[offa + 1] = -this.bk1[this.n] * ak[this.n - 1] + this.bk1[this.n - 1] * ak[this.n];
            for (i2 = 1; i2 < (this.n - 1) / 2; ++i2) {
                int idx1 = 2 * i2;
                idx2 = idx1 + 1;
                a2[offa + idx1] = this.bk1[idx1] * ak[idx1] + this.bk1[idx2] * ak[idx2];
                a2[offa + idx2] = -this.bk1[idx2] * ak[idx1] + this.bk1[idx1] * ak[idx2];
            }
            a2[offa + this.n - 1] = this.bk1[this.n - 1] * ak[this.n - 1] + this.bk1[this.n] * ak[this.n];
        }
    }

    private void bluestein_real_forward(final FloatLargeArray a2, final long offa) {
        long idx1;
        final FloatLargeArray ak = new FloatLargeArray(2L * this.nBluesteinl);
        int threads = ConcurrencyUtils.getNumberOfThreads();
        if (threads > 1 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long lastIdx;
            long firstIdx;
            int nthreads = 2;
            if (threads >= 4 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                nthreads = 4;
            }
            Future[] futures = new Future[nthreads];
            long k2 = this.nl / (long)nthreads;
            for (int i2 = 0; i2 < nthreads; ++i2) {
                firstIdx = (long)i2 * k2;
                lastIdx = i2 == nthreads - 1 ? this.nl : firstIdx + k2;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                            long idx1 = 2L * i2;
                            long idx2 = idx1 + 1L;
                            long idx3 = offa + i2;
                            ak.setFloat(idx1, a2.getFloat(idx3) * FloatFFT_1D.this.bk1l.getFloat(idx1));
                            ak.setFloat(idx2, -a2.getFloat(idx3) * FloatFFT_1D.this.bk1l.getFloat(idx2));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
            k2 = this.nBluesteinl / (long)nthreads;
            for (int i3 = 0; i3 < nthreads; ++i3) {
                firstIdx = (long)i3 * k2;
                lastIdx = i3 == nthreads - 1 ? this.nBluesteinl : firstIdx + k2;
                futures[i3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                            long idx1 = 2L * i2;
                            long idx2 = idx1 + 1L;
                            float im = ak.getFloat(idx1) * FloatFFT_1D.this.bk2l.getFloat(idx2) + ak.getFloat(idx2) * FloatFFT_1D.this.bk2l.getFloat(idx1);
                            ak.setFloat(idx1, ak.getFloat(idx1) * FloatFFT_1D.this.bk2l.getFloat(idx1) - ak.getFloat(idx2) * FloatFFT_1D.this.bk2l.getFloat(idx2));
                            ak.setFloat(idx2, im);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx2;
            long i4;
            for (i4 = 0L; i4 < this.nl; ++i4) {
                idx1 = 2L * i4;
                idx2 = idx1 + 1L;
                long idx3 = offa + i4;
                ak.setFloat(idx1, a2.getFloat(idx3) * this.bk1l.getFloat(idx1));
                ak.setFloat(idx2, -a2.getFloat(idx3) * this.bk1l.getFloat(idx2));
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
            for (i4 = 0L; i4 < this.nBluesteinl; ++i4) {
                idx1 = 2L * i4;
                idx2 = idx1 + 1L;
                float im = ak.getFloat(idx1) * this.bk2l.getFloat(idx2) + ak.getFloat(idx2) * this.bk2l.getFloat(idx1);
                ak.setFloat(idx1, ak.getFloat(idx1) * this.bk2l.getFloat(idx1) - ak.getFloat(idx2) * this.bk2l.getFloat(idx2));
                ak.setFloat(idx2, im);
            }
        }
        CommonUtils.cftfsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
        if (this.nl % 2L == 0L) {
            a2.setFloat(offa, this.bk1l.getFloat(0L) * ak.getFloat(0L) + this.bk1l.getFloat(1L) * ak.getFloat(1L));
            a2.setFloat(offa + 1L, this.bk1l.getFloat(this.nl) * ak.getFloat(this.nl) + this.bk1l.getFloat(this.nl + 1L) * ak.getFloat(this.nl + 1L));
            for (long i5 = 1L; i5 < this.nl / 2L; ++i5) {
                idx1 = 2L * i5;
                long idx2 = idx1 + 1L;
                a2.setFloat(offa + idx1, this.bk1l.getFloat(idx1) * ak.getFloat(idx1) + this.bk1l.getFloat(idx2) * ak.getFloat(idx2));
                a2.setFloat(offa + idx2, -this.bk1l.getFloat(idx2) * ak.getFloat(idx1) + this.bk1l.getFloat(idx1) * ak.getFloat(idx2));
            }
        } else {
            a2.setFloat(offa, this.bk1l.getFloat(0L) * ak.getFloat(0L) + this.bk1l.getFloat(1L) * ak.getFloat(1L));
            a2.setFloat(offa + 1L, -this.bk1l.getFloat(this.nl) * ak.getFloat(this.nl - 1L) + this.bk1l.getFloat(this.nl - 1L) * ak.getFloat(this.nl));
            for (long i6 = 1L; i6 < (this.nl - 1L) / 2L; ++i6) {
                idx1 = 2L * i6;
                long idx2 = idx1 + 1L;
                a2.setFloat(offa + idx1, this.bk1l.getFloat(idx1) * ak.getFloat(idx1) + this.bk1l.getFloat(idx2) * ak.getFloat(idx2));
                a2.setFloat(offa + idx2, -this.bk1l.getFloat(idx2) * ak.getFloat(idx1) + this.bk1l.getFloat(idx1) * ak.getFloat(idx2));
            }
            a2.setFloat(offa + this.nl - 1L, this.bk1l.getFloat(this.nl - 1L) * ak.getFloat(this.nl - 1L) + this.bk1l.getFloat(this.nl) * ak.getFloat(this.nl));
        }
    }

    private void bluestein_real_inverse(final float[] a2, final int offa) {
        int idx4;
        int idx3;
        int idx2;
        int idx1;
        int i2;
        final float[] ak = new float[2 * this.nBluestein];
        if (this.n % 2 == 0) {
            ak[0] = a2[offa] * this.bk1[0];
            ak[1] = a2[offa] * this.bk1[1];
            for (i2 = 1; i2 < this.n / 2; ++i2) {
                idx1 = 2 * i2;
                idx2 = idx1 + 1;
                idx3 = offa + idx1;
                idx4 = offa + idx2;
                ak[idx1] = a2[idx3] * this.bk1[idx1] - a2[idx4] * this.bk1[idx2];
                ak[idx2] = a2[idx3] * this.bk1[idx2] + a2[idx4] * this.bk1[idx1];
            }
            ak[this.n] = a2[offa + 1] * this.bk1[this.n];
            ak[this.n + 1] = a2[offa + 1] * this.bk1[this.n + 1];
            for (i2 = this.n / 2 + 1; i2 < this.n; ++i2) {
                idx1 = 2 * i2;
                idx2 = idx1 + 1;
                idx3 = offa + 2 * this.n - idx1;
                idx4 = idx3 + 1;
                ak[idx1] = a2[idx3] * this.bk1[idx1] + a2[idx4] * this.bk1[idx2];
                ak[idx2] = a2[idx3] * this.bk1[idx2] - a2[idx4] * this.bk1[idx1];
            }
        } else {
            ak[0] = a2[offa] * this.bk1[0];
            ak[1] = a2[offa] * this.bk1[1];
            for (i2 = 1; i2 < (this.n - 1) / 2; ++i2) {
                idx1 = 2 * i2;
                idx2 = idx1 + 1;
                idx3 = offa + idx1;
                idx4 = offa + idx2;
                ak[idx1] = a2[idx3] * this.bk1[idx1] - a2[idx4] * this.bk1[idx2];
                ak[idx2] = a2[idx3] * this.bk1[idx2] + a2[idx4] * this.bk1[idx1];
            }
            ak[this.n - 1] = a2[offa + this.n - 1] * this.bk1[this.n - 1] - a2[offa + 1] * this.bk1[this.n];
            ak[this.n] = a2[offa + this.n - 1] * this.bk1[this.n] + a2[offa + 1] * this.bk1[this.n - 1];
            ak[this.n + 1] = a2[offa + this.n - 1] * this.bk1[this.n + 1] + a2[offa + 1] * this.bk1[this.n + 2];
            ak[this.n + 2] = a2[offa + this.n - 1] * this.bk1[this.n + 2] - a2[offa + 1] * this.bk1[this.n + 1];
            for (i2 = (this.n - 1) / 2 + 2; i2 < this.n; ++i2) {
                idx1 = 2 * i2;
                idx2 = idx1 + 1;
                idx3 = offa + 2 * this.n - idx1;
                idx4 = idx3 + 1;
                ak[idx1] = a2[idx3] * this.bk1[idx1] + a2[idx4] * this.bk1[idx2];
                ak[idx2] = a2[idx3] * this.bk1[idx2] - a2[idx4] * this.bk1[idx1];
            }
        }
        CommonUtils.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
        int threads = ConcurrencyUtils.getNumberOfThreads();
        if (threads > 1 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int lastIdx;
            int firstIdx;
            int nthreads = 2;
            if (threads >= 4 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                nthreads = 4;
            }
            Future[] futures = new Future[nthreads];
            int k2 = this.nBluestein / nthreads;
            for (int i3 = 0; i3 < nthreads; ++i3) {
                firstIdx = i3 * k2;
                lastIdx = i3 == nthreads - 1 ? this.nBluestein : firstIdx + k2;
                futures[i3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                            int idx1 = 2 * i2;
                            int idx2 = idx1 + 1;
                            float im = -ak[idx1] * FloatFFT_1D.this.bk2[idx2] + ak[idx2] * FloatFFT_1D.this.bk2[idx1];
                            ak[idx1] = ak[idx1] * FloatFFT_1D.this.bk2[idx1] + ak[idx2] * FloatFFT_1D.this.bk2[idx2];
                            ak[idx2] = im;
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            CommonUtils.cftfsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            k2 = this.n / nthreads;
            for (int i4 = 0; i4 < nthreads; ++i4) {
                firstIdx = i4 * k2;
                lastIdx = i4 == nthreads - 1 ? this.n : firstIdx + k2;
                futures[i4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                            int idx1 = 2 * i2;
                            int idx2 = idx1 + 1;
                            a2[offa + i2] = FloatFFT_1D.this.bk1[idx1] * ak[idx1] - FloatFFT_1D.this.bk1[idx2] * ak[idx2];
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx22;
            int idx12;
            int i5;
            for (i5 = 0; i5 < this.nBluestein; ++i5) {
                idx12 = 2 * i5;
                idx22 = idx12 + 1;
                float im = -ak[idx12] * this.bk2[idx22] + ak[idx22] * this.bk2[idx12];
                ak[idx12] = ak[idx12] * this.bk2[idx12] + ak[idx22] * this.bk2[idx22];
                ak[idx22] = im;
            }
            CommonUtils.cftfsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            for (i5 = 0; i5 < this.n; ++i5) {
                idx12 = 2 * i5;
                idx22 = idx12 + 1;
                a2[offa + i5] = this.bk1[idx12] * ak[idx12] - this.bk1[idx22] * ak[idx22];
            }
        }
    }

    private void bluestein_real_inverse(final FloatLargeArray a2, final long offa) {
        long idx4;
        long idx3;
        long idx2;
        long idx1;
        long i2;
        final FloatLargeArray ak = new FloatLargeArray(2L * this.nBluesteinl);
        if (this.nl % 2L == 0L) {
            ak.setFloat(0L, a2.getFloat(offa) * this.bk1l.getFloat(0L));
            ak.setFloat(1L, a2.getFloat(offa) * this.bk1l.getFloat(1L));
            for (i2 = 1L; i2 < this.nl / 2L; ++i2) {
                idx1 = 2L * i2;
                idx2 = idx1 + 1L;
                idx3 = offa + idx1;
                idx4 = offa + idx2;
                ak.setFloat(idx1, a2.getFloat(idx3) * this.bk1l.getFloat(idx1) - a2.getFloat(idx4) * this.bk1l.getFloat(idx2));
                ak.setFloat(idx2, a2.getFloat(idx3) * this.bk1l.getFloat(idx2) + a2.getFloat(idx4) * this.bk1l.getFloat(idx1));
            }
            ak.setFloat(this.nl, a2.getFloat(offa + 1L) * this.bk1l.getFloat(this.nl));
            ak.setFloat(this.nl + 1L, a2.getFloat(offa + 1L) * this.bk1l.getFloat(this.nl + 1L));
            for (i2 = this.nl / 2L + 1L; i2 < this.nl; ++i2) {
                idx1 = 2L * i2;
                idx2 = idx1 + 1L;
                idx3 = offa + 2L * this.nl - idx1;
                idx4 = idx3 + 1L;
                ak.setFloat(idx1, a2.getFloat(idx3) * this.bk1l.getFloat(idx1) + a2.getFloat(idx4) * this.bk1l.getFloat(idx2));
                ak.setFloat(idx2, a2.getFloat(idx3) * this.bk1l.getFloat(idx2) - a2.getFloat(idx4) * this.bk1l.getFloat(idx1));
            }
        } else {
            ak.setFloat(0L, a2.getFloat(offa) * this.bk1l.getFloat(0L));
            ak.setFloat(1L, a2.getFloat(offa) * this.bk1l.getFloat(1L));
            for (i2 = 1L; i2 < (this.nl - 1L) / 2L; ++i2) {
                idx1 = 2L * i2;
                idx2 = idx1 + 1L;
                idx3 = offa + idx1;
                idx4 = offa + idx2;
                ak.setFloat(idx1, a2.getFloat(idx3) * this.bk1l.getFloat(idx1) - a2.getFloat(idx4) * this.bk1l.getFloat(idx2));
                ak.setFloat(idx2, a2.getFloat(idx3) * this.bk1l.getFloat(idx2) + a2.getFloat(idx4) * this.bk1l.getFloat(idx1));
            }
            ak.setFloat(this.nl - 1L, a2.getFloat(offa + this.nl - 1L) * this.bk1l.getFloat(this.nl - 1L) - a2.getFloat(offa + 1L) * this.bk1l.getFloat(this.nl));
            ak.setFloat(this.nl, a2.getFloat(offa + this.nl - 1L) * this.bk1l.getFloat(this.nl) + a2.getFloat(offa + 1L) * this.bk1l.getFloat(this.nl - 1L));
            ak.setFloat(this.nl + 1L, a2.getFloat(offa + this.nl - 1L) * this.bk1l.getFloat(this.nl + 1L) + a2.getFloat(offa + 1L) * this.bk1l.getFloat(this.nl + 2L));
            ak.setFloat(this.nl + 2L, a2.getFloat(offa + this.nl - 1L) * this.bk1l.getFloat(this.nl + 2L) - a2.getFloat(offa + 1L) * this.bk1l.getFloat(this.nl + 1L));
            for (i2 = (this.nl - 1L) / 2L + 2L; i2 < this.nl; ++i2) {
                idx1 = 2L * i2;
                idx2 = idx1 + 1L;
                idx3 = offa + 2L * this.nl - idx1;
                idx4 = idx3 + 1L;
                ak.setFloat(idx1, a2.getFloat(idx3) * this.bk1l.getFloat(idx1) + a2.getFloat(idx4) * this.bk1l.getFloat(idx2));
                ak.setFloat(idx2, a2.getFloat(idx3) * this.bk1l.getFloat(idx2) - a2.getFloat(idx4) * this.bk1l.getFloat(idx1));
            }
        }
        CommonUtils.cftbsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
        int threads = ConcurrencyUtils.getNumberOfThreads();
        if (threads > 1 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long lastIdx;
            long firstIdx;
            int nthreads = 2;
            if (threads >= 4 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                nthreads = 4;
            }
            Future[] futures = new Future[nthreads];
            long k2 = this.nBluesteinl / (long)nthreads;
            for (int i3 = 0; i3 < nthreads; ++i3) {
                firstIdx = (long)i3 * k2;
                lastIdx = i3 == nthreads - 1 ? this.nBluesteinl : firstIdx + k2;
                futures[i3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                            long idx1 = 2L * i2;
                            long idx2 = idx1 + 1L;
                            float im = -ak.getFloat(idx1) * FloatFFT_1D.this.bk2l.getFloat(idx2) + ak.getFloat(idx2) * FloatFFT_1D.this.bk2l.getFloat(idx1);
                            ak.setFloat(idx1, ak.getFloat(idx1) * FloatFFT_1D.this.bk2l.getFloat(idx1) + ak.getFloat(idx2) * FloatFFT_1D.this.bk2l.getFloat(idx2));
                            ak.setFloat(idx2, im);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
            k2 = this.nl / (long)nthreads;
            for (int i4 = 0; i4 < nthreads; ++i4) {
                firstIdx = (long)i4 * k2;
                lastIdx = i4 == nthreads - 1 ? this.nl : firstIdx + k2;
                futures[i4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                            long idx1 = 2L * i2;
                            long idx2 = idx1 + 1L;
                            a2.setFloat(offa + i2, FloatFFT_1D.this.bk1l.getFloat(idx1) * ak.getFloat(idx1) - FloatFFT_1D.this.bk1l.getFloat(idx2) * ak.getFloat(idx2));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx22;
            long idx12;
            long i5;
            for (i5 = 0L; i5 < this.nBluesteinl; ++i5) {
                idx12 = 2L * i5;
                idx22 = idx12 + 1L;
                float im = -ak.getFloat(idx12) * this.bk2l.getFloat(idx22) + ak.getFloat(idx22) * this.bk2l.getFloat(idx12);
                ak.setFloat(idx12, ak.getFloat(idx12) * this.bk2l.getFloat(idx12) + ak.getFloat(idx22) * this.bk2l.getFloat(idx22));
                ak.setFloat(idx22, im);
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
            for (i5 = 0L; i5 < this.nl; ++i5) {
                idx12 = 2L * i5;
                idx22 = idx12 + 1L;
                a2.setFloat(offa + i5, this.bk1l.getFloat(idx12) * ak.getFloat(idx12) - this.bk1l.getFloat(idx22) * ak.getFloat(idx22));
            }
        }
    }

    private void bluestein_real_inverse2(final float[] a2, final int offa) {
        int idx2;
        int i2;
        final float[] ak = new float[2 * this.nBluestein];
        int threads = ConcurrencyUtils.getNumberOfThreads();
        if (threads > 1 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int lastIdx;
            int firstIdx;
            int nthreads = 2;
            if (threads >= 4 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                nthreads = 4;
            }
            Future[] futures = new Future[nthreads];
            int k2 = this.n / nthreads;
            for (int i3 = 0; i3 < nthreads; ++i3) {
                firstIdx = i3 * k2;
                lastIdx = i3 == nthreads - 1 ? this.n : firstIdx + k2;
                futures[i3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                            int idx1 = 2 * i2;
                            int idx2 = idx1 + 1;
                            int idx3 = offa + i2;
                            ak[idx1] = a2[idx3] * FloatFFT_1D.this.bk1[idx1];
                            ak[idx2] = a2[idx3] * FloatFFT_1D.this.bk1[idx2];
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            CommonUtils.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            k2 = this.nBluestein / nthreads;
            for (int i4 = 0; i4 < nthreads; ++i4) {
                firstIdx = i4 * k2;
                lastIdx = i4 == nthreads - 1 ? this.nBluestein : firstIdx + k2;
                futures[i4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                            int idx1 = 2 * i2;
                            int idx2 = idx1 + 1;
                            float im = -ak[idx1] * FloatFFT_1D.this.bk2[idx2] + ak[idx2] * FloatFFT_1D.this.bk2[idx1];
                            ak[idx1] = ak[idx1] * FloatFFT_1D.this.bk2[idx1] + ak[idx2] * FloatFFT_1D.this.bk2[idx2];
                            ak[idx2] = im;
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx1;
            for (i2 = 0; i2 < this.n; ++i2) {
                idx1 = 2 * i2;
                idx2 = idx1 + 1;
                int idx3 = offa + i2;
                ak[idx1] = a2[idx3] * this.bk1[idx1];
                ak[idx2] = a2[idx3] * this.bk1[idx2];
            }
            CommonUtils.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            for (i2 = 0; i2 < this.nBluestein; ++i2) {
                idx1 = 2 * i2;
                idx2 = idx1 + 1;
                float im = -ak[idx1] * this.bk2[idx2] + ak[idx2] * this.bk2[idx1];
                ak[idx1] = ak[idx1] * this.bk2[idx1] + ak[idx2] * this.bk2[idx2];
                ak[idx2] = im;
            }
        }
        CommonUtils.cftfsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
        if (this.n % 2 == 0) {
            a2[offa] = this.bk1[0] * ak[0] - this.bk1[1] * ak[1];
            a2[offa + 1] = this.bk1[this.n] * ak[this.n] - this.bk1[this.n + 1] * ak[this.n + 1];
            for (i2 = 1; i2 < this.n / 2; ++i2) {
                int idx1 = 2 * i2;
                idx2 = idx1 + 1;
                a2[offa + idx1] = this.bk1[idx1] * ak[idx1] - this.bk1[idx2] * ak[idx2];
                a2[offa + idx2] = this.bk1[idx2] * ak[idx1] + this.bk1[idx1] * ak[idx2];
            }
        } else {
            a2[offa] = this.bk1[0] * ak[0] - this.bk1[1] * ak[1];
            a2[offa + 1] = this.bk1[this.n] * ak[this.n - 1] + this.bk1[this.n - 1] * ak[this.n];
            for (i2 = 1; i2 < (this.n - 1) / 2; ++i2) {
                int idx1 = 2 * i2;
                idx2 = idx1 + 1;
                a2[offa + idx1] = this.bk1[idx1] * ak[idx1] - this.bk1[idx2] * ak[idx2];
                a2[offa + idx2] = this.bk1[idx2] * ak[idx1] + this.bk1[idx1] * ak[idx2];
            }
            a2[offa + this.n - 1] = this.bk1[this.n - 1] * ak[this.n - 1] - this.bk1[this.n] * ak[this.n];
        }
    }

    private void bluestein_real_inverse2(final FloatLargeArray a2, final long offa) {
        long idx1;
        final FloatLargeArray ak = new FloatLargeArray(2L * this.nBluesteinl);
        int threads = ConcurrencyUtils.getNumberOfThreads();
        if (threads > 1 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long lastIdx;
            long firstIdx;
            int nthreads = 2;
            if (threads >= 4 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                nthreads = 4;
            }
            Future[] futures = new Future[nthreads];
            long k2 = this.nl / (long)nthreads;
            for (int i2 = 0; i2 < nthreads; ++i2) {
                firstIdx = (long)i2 * k2;
                lastIdx = i2 == nthreads - 1 ? this.nl : firstIdx + k2;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                            long idx1 = 2L * i2;
                            long idx2 = idx1 + 1L;
                            long idx3 = offa + i2;
                            ak.setFloat(idx1, a2.getFloat(idx3) * FloatFFT_1D.this.bk1l.getFloat(idx1));
                            ak.setFloat(idx2, a2.getFloat(idx3) * FloatFFT_1D.this.bk1l.getFloat(idx2));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
            k2 = this.nBluesteinl / (long)nthreads;
            for (int i3 = 0; i3 < nthreads; ++i3) {
                firstIdx = (long)i3 * k2;
                lastIdx = i3 == nthreads - 1 ? this.nBluesteinl : firstIdx + k2;
                futures[i3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                            long idx1 = 2L * i2;
                            long idx2 = idx1 + 1L;
                            float im = -ak.getFloat(idx1) * FloatFFT_1D.this.bk2l.getFloat(idx2) + ak.getFloat(idx2) * FloatFFT_1D.this.bk2l.getFloat(idx1);
                            ak.setFloat(idx1, ak.getFloat(idx1) * FloatFFT_1D.this.bk2l.getFloat(idx1) + ak.getFloat(idx2) * FloatFFT_1D.this.bk2l.getFloat(idx2));
                            ak.setFloat(idx2, im);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx2;
            long i4;
            for (i4 = 0L; i4 < this.nl; ++i4) {
                idx1 = 2L * i4;
                idx2 = idx1 + 1L;
                long idx3 = offa + i4;
                ak.setFloat(idx1, a2.getFloat(idx3) * this.bk1l.getFloat(idx1));
                ak.setFloat(idx2, a2.getFloat(idx3) * this.bk1l.getFloat(idx2));
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
            for (i4 = 0L; i4 < this.nBluesteinl; ++i4) {
                idx1 = 2L * i4;
                idx2 = idx1 + 1L;
                float im = -ak.getFloat(idx1) * this.bk2l.getFloat(idx2) + ak.getFloat(idx2) * this.bk2l.getFloat(idx1);
                ak.setFloat(idx1, ak.getFloat(idx1) * this.bk2l.getFloat(idx1) + ak.getFloat(idx2) * this.bk2l.getFloat(idx2));
                ak.setFloat(idx2, im);
            }
        }
        CommonUtils.cftfsub(2L * this.nBluesteinl, ak, 0L, this.ipl, this.nwl, this.wl);
        if (this.nl % 2L == 0L) {
            a2.setFloat(offa, this.bk1l.getFloat(0L) * ak.getFloat(0L) - this.bk1l.getFloat(1L) * ak.getFloat(1L));
            a2.setFloat(offa + 1L, this.bk1l.getFloat(this.nl) * ak.getFloat(this.nl) - this.bk1l.getFloat(this.nl + 1L) * ak.getFloat(this.nl + 1L));
            for (long i5 = 1L; i5 < this.nl / 2L; ++i5) {
                idx1 = 2L * i5;
                long idx2 = idx1 + 1L;
                a2.setFloat(offa + idx1, this.bk1l.getFloat(idx1) * ak.getFloat(idx1) - this.bk1l.getFloat(idx2) * ak.getFloat(idx2));
                a2.setFloat(offa + idx2, this.bk1l.getFloat(idx2) * ak.getFloat(idx1) + this.bk1l.getFloat(idx1) * ak.getFloat(idx2));
            }
        } else {
            a2.setFloat(offa, this.bk1l.getFloat(0L) * ak.getFloat(0L) - this.bk1l.getFloat(1L) * ak.getFloat(1L));
            a2.setFloat(offa + 1L, this.bk1l.getFloat(this.nl) * ak.getFloat(this.nl - 1L) + this.bk1l.getFloat(this.nl - 1L) * ak.getFloat(this.nl));
            for (long i6 = 1L; i6 < (this.nl - 1L) / 2L; ++i6) {
                idx1 = 2L * i6;
                long idx2 = idx1 + 1L;
                a2.setFloat(offa + idx1, this.bk1l.getFloat(idx1) * ak.getFloat(idx1) - this.bk1l.getFloat(idx2) * ak.getFloat(idx2));
                a2.setFloat(offa + idx2, this.bk1l.getFloat(idx2) * ak.getFloat(idx1) + this.bk1l.getFloat(idx1) * ak.getFloat(idx2));
            }
            a2.setFloat(offa + this.nl - 1L, this.bk1l.getFloat(this.nl - 1L) * ak.getFloat(this.nl - 1L) - this.bk1l.getFloat(this.nl) * ak.getFloat(this.nl));
        }
    }

    void rfftf(float[] a2, int offa) {
        if (this.n == 1) {
            return;
        }
        float[] ch = new float[this.n];
        int twon = 2 * this.n;
        int nf = (int)this.wtable_r[1 + twon];
        int na = 1;
        int l2 = this.n;
        int iw = twon - 1;
        for (int k1 = 1; k1 <= nf; ++k1) {
            int kh = nf - k1;
            int ipll = (int)this.wtable_r[kh + 2 + twon];
            int l1 = l2 / ipll;
            int ido = this.n / l2;
            int idl1 = ido * l1;
            iw -= (ipll - 1) * ido;
            na = 1 - na;
            switch (ipll) {
                case 2: {
                    if (na == 0) {
                        this.radf2(ido, l1, a2, offa, ch, 0, iw);
                        break;
                    }
                    this.radf2(ido, l1, ch, 0, a2, offa, iw);
                    break;
                }
                case 3: {
                    if (na == 0) {
                        this.radf3(ido, l1, a2, offa, ch, 0, iw);
                        break;
                    }
                    this.radf3(ido, l1, ch, 0, a2, offa, iw);
                    break;
                }
                case 4: {
                    if (na == 0) {
                        this.radf4(ido, l1, a2, offa, ch, 0, iw);
                        break;
                    }
                    this.radf4(ido, l1, ch, 0, a2, offa, iw);
                    break;
                }
                case 5: {
                    if (na == 0) {
                        this.radf5(ido, l1, a2, offa, ch, 0, iw);
                        break;
                    }
                    this.radf5(ido, l1, ch, 0, a2, offa, iw);
                    break;
                }
                default: {
                    if (ido == 1) {
                        na = 1 - na;
                    }
                    if (na == 0) {
                        this.radfg(ido, ipll, l1, idl1, a2, offa, ch, 0, iw);
                        na = 1;
                        break;
                    }
                    this.radfg(ido, ipll, l1, idl1, ch, 0, a2, offa, iw);
                    na = 0;
                }
            }
            l2 = l1;
        }
        if (na == 1) {
            return;
        }
        System.arraycopy(ch, 0, a2, offa, this.n);
    }

    void rfftf(FloatLargeArray a2, long offa) {
        if (this.nl == 1L) {
            return;
        }
        FloatLargeArray ch = new FloatLargeArray(this.nl);
        long twon = 2L * this.nl;
        long nf = (long)this.wtable_rl.getFloat(1L + twon);
        long na = 1L;
        long l2 = this.nl;
        long iw = twon - 1L;
        for (long k1 = 1L; k1 <= nf; ++k1) {
            long kh = nf - k1;
            int ipll = (int)this.wtable_rl.getFloat(kh + 2L + twon);
            long l1 = l2 / (long)ipll;
            long ido = this.nl / l2;
            long idl1 = ido * l1;
            iw -= (long)(ipll - 1) * ido;
            na = 1L - na;
            switch (ipll) {
                case 2: {
                    if (na == 0L) {
                        this.radf2(ido, l1, a2, offa, ch, 0L, iw);
                        break;
                    }
                    this.radf2(ido, l1, ch, 0L, a2, offa, iw);
                    break;
                }
                case 3: {
                    if (na == 0L) {
                        this.radf3(ido, l1, a2, offa, ch, 0L, iw);
                        break;
                    }
                    this.radf3(ido, l1, ch, 0L, a2, offa, iw);
                    break;
                }
                case 4: {
                    if (na == 0L) {
                        this.radf4(ido, l1, a2, offa, ch, 0L, iw);
                        break;
                    }
                    this.radf4(ido, l1, ch, 0L, a2, offa, iw);
                    break;
                }
                case 5: {
                    if (na == 0L) {
                        this.radf5(ido, l1, a2, offa, ch, 0L, iw);
                        break;
                    }
                    this.radf5(ido, l1, ch, 0L, a2, offa, iw);
                    break;
                }
                default: {
                    if (ido == 1L) {
                        na = 1L - na;
                    }
                    if (na == 0L) {
                        this.radfg(ido, (long)ipll, l1, idl1, a2, offa, ch, 0L, iw);
                        na = 1L;
                        break;
                    }
                    this.radfg(ido, (long)ipll, l1, idl1, ch, 0L, a2, offa, iw);
                    na = 0L;
                }
            }
            l2 = l1;
        }
        if (na == 1L) {
            return;
        }
        LargeArrayUtils.arraycopy(ch, 0L, a2, offa, this.nl);
    }

    void rfftb(float[] a2, int offa) {
        if (this.n == 1) {
            return;
        }
        float[] ch = new float[this.n];
        int twon = 2 * this.n;
        int nf = (int)this.wtable_r[1 + twon];
        int na = 0;
        int l1 = 1;
        int iw = this.n;
        for (int k1 = 1; k1 <= nf; ++k1) {
            int ipll = (int)this.wtable_r[k1 + 1 + twon];
            int l2 = ipll * l1;
            int ido = this.n / l2;
            int idl1 = ido * l1;
            switch (ipll) {
                case 2: {
                    if (na == 0) {
                        this.radb2(ido, l1, a2, offa, ch, 0, iw);
                    } else {
                        this.radb2(ido, l1, ch, 0, a2, offa, iw);
                    }
                    na = 1 - na;
                    break;
                }
                case 3: {
                    if (na == 0) {
                        this.radb3(ido, l1, a2, offa, ch, 0, iw);
                    } else {
                        this.radb3(ido, l1, ch, 0, a2, offa, iw);
                    }
                    na = 1 - na;
                    break;
                }
                case 4: {
                    if (na == 0) {
                        this.radb4(ido, l1, a2, offa, ch, 0, iw);
                    } else {
                        this.radb4(ido, l1, ch, 0, a2, offa, iw);
                    }
                    na = 1 - na;
                    break;
                }
                case 5: {
                    if (na == 0) {
                        this.radb5(ido, l1, a2, offa, ch, 0, iw);
                    } else {
                        this.radb5(ido, l1, ch, 0, a2, offa, iw);
                    }
                    na = 1 - na;
                    break;
                }
                default: {
                    if (na == 0) {
                        this.radbg(ido, ipll, l1, idl1, a2, offa, ch, 0, iw);
                    } else {
                        this.radbg(ido, ipll, l1, idl1, ch, 0, a2, offa, iw);
                    }
                    if (ido != 1) break;
                    na = 1 - na;
                }
            }
            l1 = l2;
            iw += (ipll - 1) * ido;
        }
        if (na == 0) {
            return;
        }
        System.arraycopy(ch, 0, a2, offa, this.n);
    }

    void rfftb(FloatLargeArray a2, long offa) {
        if (this.nl == 1L) {
            return;
        }
        FloatLargeArray ch = new FloatLargeArray(this.nl);
        long twon = 2L * this.nl;
        long nf = (long)this.wtable_rl.getFloat(1L + twon);
        long na = 0L;
        long l1 = 1L;
        long iw = this.nl;
        for (long k1 = 1L; k1 <= nf; ++k1) {
            int ipll = (int)this.wtable_rl.getFloat(k1 + 1L + twon);
            long l2 = (long)ipll * l1;
            long ido = this.nl / l2;
            long idl1 = ido * l1;
            switch (ipll) {
                case 2: {
                    if (na == 0L) {
                        this.radb2(ido, l1, a2, offa, ch, 0L, iw);
                    } else {
                        this.radb2(ido, l1, ch, 0L, a2, offa, iw);
                    }
                    na = 1L - na;
                    break;
                }
                case 3: {
                    if (na == 0L) {
                        this.radb3(ido, l1, a2, offa, ch, 0L, iw);
                    } else {
                        this.radb3(ido, l1, ch, 0L, a2, offa, iw);
                    }
                    na = 1L - na;
                    break;
                }
                case 4: {
                    if (na == 0L) {
                        this.radb4(ido, l1, a2, offa, ch, 0L, iw);
                    } else {
                        this.radb4(ido, l1, ch, 0L, a2, offa, iw);
                    }
                    na = 1L - na;
                    break;
                }
                case 5: {
                    if (na == 0L) {
                        this.radb5(ido, l1, a2, offa, ch, 0L, iw);
                    } else {
                        this.radb5(ido, l1, ch, 0L, a2, offa, iw);
                    }
                    na = 1L - na;
                    break;
                }
                default: {
                    if (na == 0L) {
                        this.radbg(ido, (long)ipll, l1, idl1, a2, offa, ch, 0L, iw);
                    } else {
                        this.radbg(ido, (long)ipll, l1, idl1, ch, 0L, a2, offa, iw);
                    }
                    if (ido != 1L) break;
                    na = 1L - na;
                }
            }
            l1 = l2;
            iw += (long)(ipll - 1) * ido;
        }
        if (na == 0L) {
            return;
        }
        LargeArrayUtils.arraycopy(ch, 0L, a2, offa, this.nl);
    }

    void radf2(int ido, int l1, float[] in, int in_off, float[] out, int out_off, int offset) {
        int idx2;
        int oidx1;
        int k2;
        int iw1 = offset;
        int idx0 = l1 * ido;
        int idx1 = 2 * ido;
        for (k2 = 0; k2 < l1; ++k2) {
            oidx1 = out_off + k2 * idx1;
            int oidx2 = oidx1 + idx1 - 1;
            int iidx1 = in_off + k2 * ido;
            int iidx2 = iidx1 + idx0;
            float i1r = in[iidx1];
            float i2r = in[iidx2];
            out[oidx1] = i1r + i2r;
            out[oidx2] = i1r - i2r;
        }
        if (ido < 2) {
            return;
        }
        if (ido != 2) {
            for (k2 = 0; k2 < l1; ++k2) {
                idx1 = k2 * ido;
                idx2 = 2 * idx1;
                int idx3 = idx2 + ido;
                int idx4 = idx1 + idx0;
                for (int i2 = 2; i2 < ido; i2 += 2) {
                    int ic = ido - i2;
                    int widx1 = i2 - 1 + iw1;
                    int oidx12 = out_off + i2 + idx2;
                    int oidx2 = out_off + ic + idx3;
                    int iidx1 = in_off + i2 + idx1;
                    int iidx2 = in_off + i2 + idx4;
                    float a1i = in[iidx1 - 1];
                    float a1r = in[iidx1];
                    float a2i = in[iidx2 - 1];
                    float a2r = in[iidx2];
                    float w1r = this.wtable_r[widx1 - 1];
                    float w1i = this.wtable_r[widx1];
                    float t1r = w1r * a2i + w1i * a2r;
                    float t1i = w1r * a2r - w1i * a2i;
                    out[oidx12] = a1r + t1i;
                    out[oidx12 - 1] = a1i + t1r;
                    out[oidx2] = t1i - a1r;
                    out[oidx2 - 1] = a1i - t1r;
                }
            }
            if (ido % 2 == 1) {
                return;
            }
        }
        idx2 = 2 * idx1;
        for (k2 = 0; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            oidx1 = out_off + idx2 + ido;
            int iidx1 = in_off + ido - 1 + idx1;
            out[oidx1] = -in[iidx1 + idx0];
            out[oidx1 - 1] = in[iidx1];
        }
    }

    void radf2(long ido, long l1, FloatLargeArray in, long in_off, FloatLargeArray out, long out_off, long offset) {
        long idx2;
        long oidx1;
        long k2;
        long iw1 = offset;
        long idx0 = l1 * ido;
        long idx1 = 2L * ido;
        for (k2 = 0L; k2 < l1; ++k2) {
            oidx1 = out_off + k2 * idx1;
            long oidx2 = oidx1 + idx1 - 1L;
            long iidx1 = in_off + k2 * ido;
            long iidx2 = iidx1 + idx0;
            float i1r = in.getFloat(iidx1);
            float i2r = in.getFloat(iidx2);
            out.setFloat(oidx1, i1r + i2r);
            out.setFloat(oidx2, i1r - i2r);
        }
        if (ido < 2L) {
            return;
        }
        if (ido != 2L) {
            for (k2 = 0L; k2 < l1; ++k2) {
                idx1 = k2 * ido;
                idx2 = 2L * idx1;
                long idx3 = idx2 + ido;
                long idx4 = idx1 + idx0;
                for (long i2 = 2L; i2 < ido; i2 += 2L) {
                    long ic = ido - i2;
                    long widx1 = i2 - 1L + iw1;
                    long oidx12 = out_off + i2 + idx2;
                    long oidx2 = out_off + ic + idx3;
                    long iidx1 = in_off + i2 + idx1;
                    long iidx2 = in_off + i2 + idx4;
                    float a1i = in.getFloat(iidx1 - 1L);
                    float a1r = in.getFloat(iidx1);
                    float a2i = in.getFloat(iidx2 - 1L);
                    float a2r = in.getFloat(iidx2);
                    float w1r = this.wtable_rl.getFloat(widx1 - 1L);
                    float w1i = this.wtable_rl.getFloat(widx1);
                    float t1r = w1r * a2i + w1i * a2r;
                    float t1i = w1r * a2r - w1i * a2i;
                    out.setFloat(oidx12, a1r + t1i);
                    out.setFloat(oidx12 - 1L, a1i + t1r);
                    out.setFloat(oidx2, t1i - a1r);
                    out.setFloat(oidx2 - 1L, a1i - t1r);
                }
            }
            if (ido % 2L == 1L) {
                return;
            }
        }
        idx2 = 2L * idx1;
        for (k2 = 0L; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            oidx1 = out_off + idx2 + ido;
            long iidx1 = in_off + ido - 1L + idx1;
            out.setFloat(oidx1, -in.getFloat(iidx1 + idx0));
            out.setFloat(oidx1 - 1L, in.getFloat(iidx1));
        }
    }

    void radb2(int ido, int l1, float[] in, int in_off, float[] out, int out_off, int offset) {
        int idx3;
        int idx2;
        int idx1;
        int k2;
        int iw1 = offset;
        int idx0 = l1 * ido;
        for (k2 = 0; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 2 * idx1;
            idx3 = idx2 + ido;
            int oidx1 = out_off + idx1;
            int iidx1 = in_off + idx2;
            int iidx2 = in_off + ido - 1 + idx3;
            float i1r = in[iidx1];
            float i2r = in[iidx2];
            out[oidx1] = i1r + i2r;
            out[oidx1 + idx0] = i1r - i2r;
        }
        if (ido < 2) {
            return;
        }
        if (ido != 2) {
            for (k2 = 0; k2 < l1; ++k2) {
                idx1 = k2 * ido;
                idx2 = 2 * idx1;
                idx3 = idx2 + ido;
                int idx4 = idx1 + idx0;
                for (int i2 = 2; i2 < ido; i2 += 2) {
                    int ic = ido - i2;
                    int idx5 = i2 - 1 + iw1;
                    int idx6 = out_off + i2;
                    int idx7 = in_off + i2;
                    int idx8 = in_off + ic;
                    float w1r = this.wtable_r[idx5 - 1];
                    float w1i = this.wtable_r[idx5];
                    int iidx1 = idx7 + idx2;
                    int iidx2 = idx8 + idx3;
                    int oidx1 = idx6 + idx1;
                    int oidx2 = idx6 + idx4;
                    float t1r = in[iidx1 - 1] - in[iidx2 - 1];
                    float t1i = in[iidx1] + in[iidx2];
                    float i1i = in[iidx1];
                    float i1r = in[iidx1 - 1];
                    float i2i = in[iidx2];
                    float i2r = in[iidx2 - 1];
                    out[oidx1 - 1] = i1r + i2r;
                    out[oidx1] = i1i - i2i;
                    out[oidx2 - 1] = w1r * t1r - w1i * t1i;
                    out[oidx2] = w1r * t1i + w1i * t1r;
                }
            }
            if (ido % 2 == 1) {
                return;
            }
        }
        for (k2 = 0; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 2 * idx1;
            int oidx1 = out_off + ido - 1 + idx1;
            int iidx1 = in_off + idx2 + ido;
            out[oidx1] = 2.0f * in[iidx1 - 1];
            out[oidx1 + idx0] = -2.0f * in[iidx1];
        }
    }

    void radb2(long ido, long l1, FloatLargeArray in, long in_off, FloatLargeArray out, long out_off, long offset) {
        long idx3;
        long idx2;
        long idx1;
        long k2;
        long iw1 = offset;
        long idx0 = l1 * ido;
        for (k2 = 0L; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 2L * idx1;
            idx3 = idx2 + ido;
            long oidx1 = out_off + idx1;
            long iidx1 = in_off + idx2;
            long iidx2 = in_off + ido - 1L + idx3;
            float i1r = in.getFloat(iidx1);
            float i2r = in.getFloat(iidx2);
            out.setFloat(oidx1, i1r + i2r);
            out.setFloat(oidx1 + idx0, i1r - i2r);
        }
        if (ido < 2L) {
            return;
        }
        if (ido != 2L) {
            for (k2 = 0L; k2 < l1; ++k2) {
                idx1 = k2 * ido;
                idx2 = 2L * idx1;
                idx3 = idx2 + ido;
                long idx4 = idx1 + idx0;
                for (long i2 = 2L; i2 < ido; i2 += 2L) {
                    long ic = ido - i2;
                    long idx5 = i2 - 1L + iw1;
                    long idx6 = out_off + i2;
                    long idx7 = in_off + i2;
                    long idx8 = in_off + ic;
                    float w1r = this.wtable_rl.getFloat(idx5 - 1L);
                    float w1i = this.wtable_rl.getFloat(idx5);
                    long iidx1 = idx7 + idx2;
                    long iidx2 = idx8 + idx3;
                    long oidx1 = idx6 + idx1;
                    long oidx2 = idx6 + idx4;
                    float t1r = in.getFloat(iidx1 - 1L) - in.getFloat(iidx2 - 1L);
                    float t1i = in.getFloat(iidx1) + in.getFloat(iidx2);
                    float i1i = in.getFloat(iidx1);
                    float i1r = in.getFloat(iidx1 - 1L);
                    float i2i = in.getFloat(iidx2);
                    float i2r = in.getFloat(iidx2 - 1L);
                    out.setFloat(oidx1 - 1L, i1r + i2r);
                    out.setFloat(oidx1, i1i - i2i);
                    out.setFloat(oidx2 - 1L, w1r * t1r - w1i * t1i);
                    out.setFloat(oidx2, w1r * t1i + w1i * t1r);
                }
            }
            if (ido % 2L == 1L) {
                return;
            }
        }
        for (k2 = 0L; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 2L * idx1;
            long oidx1 = out_off + ido - 1L + idx1;
            long iidx1 = in_off + idx2 + ido;
            out.setFloat(oidx1, 2.0f * in.getFloat(iidx1 - 1L));
            out.setFloat(oidx1 + idx0, -2.0f * in.getFloat(iidx1));
        }
    }

    void radf3(int ido, int l1, float[] in, int in_off, float[] out, int out_off, int offset) {
        float cr2;
        int k2;
        float taur = -0.5f;
        float taui = 0.8660254f;
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int idx0 = l1 * ido;
        for (k2 = 0; k2 < l1; ++k2) {
            int idx1 = k2 * ido;
            int idx3 = 2 * idx0;
            int idx4 = (3 * k2 + 1) * ido;
            int iidx1 = in_off + idx1;
            int iidx2 = iidx1 + idx0;
            int iidx3 = iidx1 + idx3;
            float i1r = in[iidx1];
            float i2r = in[iidx2];
            float i3r = in[iidx3];
            cr2 = i2r + i3r;
            out[out_off + 3 * idx1] = i1r + cr2;
            out[out_off + idx4 + ido] = 0.8660254f * (i3r - i2r);
            out[out_off + ido - 1 + idx4] = i1r + -0.5f * cr2;
        }
        if (ido == 1) {
            return;
        }
        for (k2 = 0; k2 < l1; ++k2) {
            int idx3 = k2 * ido;
            int idx4 = 3 * idx3;
            int idx5 = idx3 + idx0;
            int idx6 = idx5 + idx0;
            int idx7 = idx4 + ido;
            int idx8 = idx7 + ido;
            for (int i2 = 2; i2 < ido; i2 += 2) {
                int ic = ido - i2;
                int widx1 = i2 - 1 + iw1;
                int widx2 = i2 - 1 + iw2;
                float w1r = this.wtable_r[widx1 - 1];
                float w1i = this.wtable_r[widx1];
                float w2r = this.wtable_r[widx2 - 1];
                float w2i = this.wtable_r[widx2];
                int idx9 = in_off + i2;
                int idx10 = out_off + i2;
                int idx11 = out_off + ic;
                int iidx1 = idx9 + idx3;
                int iidx2 = idx9 + idx5;
                int iidx3 = idx9 + idx6;
                float i1i = in[iidx1 - 1];
                float i1r = in[iidx1];
                float i2i = in[iidx2 - 1];
                float i2r = in[iidx2];
                float i3i = in[iidx3 - 1];
                float i3r = in[iidx3];
                float dr2 = w1r * i2i + w1i * i2r;
                float di2 = w1r * i2r - w1i * i2i;
                float dr3 = w2r * i3i + w2i * i3r;
                float di3 = w2r * i3r - w2i * i3i;
                cr2 = dr2 + dr3;
                float ci2 = di2 + di3;
                float tr2 = i1i + -0.5f * cr2;
                float ti2 = i1r + -0.5f * ci2;
                float tr3 = 0.8660254f * (di2 - di3);
                float ti3 = 0.8660254f * (dr3 - dr2);
                int oidx1 = idx10 + idx4;
                int oidx2 = idx11 + idx7;
                int oidx3 = idx10 + idx8;
                out[oidx1 - 1] = i1i + cr2;
                out[oidx1] = i1r + ci2;
                out[oidx2 - 1] = tr2 - tr3;
                out[oidx2] = ti3 - ti2;
                out[oidx3 - 1] = tr2 + tr3;
                out[oidx3] = ti2 + ti3;
            }
        }
    }

    void radf3(long ido, long l1, FloatLargeArray in, long in_off, FloatLargeArray out, long out_off, long offset) {
        float cr2;
        long k2;
        float taur = -0.5f;
        float taui = 0.8660254f;
        long iw1 = offset;
        long iw2 = iw1 + ido;
        long idx0 = l1 * ido;
        for (k2 = 0L; k2 < l1; ++k2) {
            long idx1 = k2 * ido;
            long idx3 = 2L * idx0;
            long idx4 = (3L * k2 + 1L) * ido;
            long iidx1 = in_off + idx1;
            long iidx2 = iidx1 + idx0;
            long iidx3 = iidx1 + idx3;
            float i1r = in.getFloat(iidx1);
            float i2r = in.getFloat(iidx2);
            float i3r = in.getFloat(iidx3);
            cr2 = i2r + i3r;
            out.setFloat(out_off + 3L * idx1, i1r + cr2);
            out.setFloat(out_off + idx4 + ido, 0.8660254f * (i3r - i2r));
            out.setFloat(out_off + ido - 1L + idx4, i1r + -0.5f * cr2);
        }
        if (ido == 1L) {
            return;
        }
        for (k2 = 0L; k2 < l1; ++k2) {
            long idx3 = k2 * ido;
            long idx4 = 3L * idx3;
            long idx5 = idx3 + idx0;
            long idx6 = idx5 + idx0;
            long idx7 = idx4 + ido;
            long idx8 = idx7 + ido;
            for (long i2 = 2L; i2 < ido; i2 += 2L) {
                long ic = ido - i2;
                long widx1 = i2 - 1L + iw1;
                long widx2 = i2 - 1L + iw2;
                float w1r = this.wtable_rl.getFloat(widx1 - 1L);
                float w1i = this.wtable_rl.getFloat(widx1);
                float w2r = this.wtable_rl.getFloat(widx2 - 1L);
                float w2i = this.wtable_rl.getFloat(widx2);
                long idx9 = in_off + i2;
                long idx10 = out_off + i2;
                long idx11 = out_off + ic;
                long iidx1 = idx9 + idx3;
                long iidx2 = idx9 + idx5;
                long iidx3 = idx9 + idx6;
                float i1i = in.getFloat(iidx1 - 1L);
                float i1r = in.getFloat(iidx1);
                float i2i = in.getFloat(iidx2 - 1L);
                float i2r = in.getFloat(iidx2);
                float i3i = in.getFloat(iidx3 - 1L);
                float i3r = in.getFloat(iidx3);
                float dr2 = w1r * i2i + w1i * i2r;
                float di2 = w1r * i2r - w1i * i2i;
                float dr3 = w2r * i3i + w2i * i3r;
                float di3 = w2r * i3r - w2i * i3i;
                cr2 = dr2 + dr3;
                float ci2 = di2 + di3;
                float tr2 = i1i + -0.5f * cr2;
                float ti2 = i1r + -0.5f * ci2;
                float tr3 = 0.8660254f * (di2 - di3);
                float ti3 = 0.8660254f * (dr3 - dr2);
                long oidx1 = idx10 + idx4;
                long oidx2 = idx11 + idx7;
                long oidx3 = idx10 + idx8;
                out.setFloat(oidx1 - 1L, i1i + cr2);
                out.setFloat(oidx1, i1r + ci2);
                out.setFloat(oidx2 - 1L, tr2 - tr3);
                out.setFloat(oidx2, ti3 - ti2);
                out.setFloat(oidx3 - 1L, tr2 + tr3);
                out.setFloat(oidx3, ti2 + ti3);
            }
        }
    }

    void radb3(int ido, int l1, float[] in, int in_off, float[] out, int out_off, int offset) {
        float ci3;
        float cr2;
        float tr2;
        float taur = -0.5f;
        float taui = 0.8660254f;
        int iw1 = offset;
        int iw2 = iw1 + ido;
        for (int k2 = 0; k2 < l1; ++k2) {
            int idx1 = k2 * ido;
            int iidx1 = in_off + 3 * idx1;
            int iidx2 = iidx1 + 2 * ido;
            float i1i = in[iidx1];
            tr2 = 2.0f * in[iidx2 - 1];
            cr2 = i1i + -0.5f * tr2;
            ci3 = 1.7320508f * in[iidx2];
            out[out_off + idx1] = i1i + tr2;
            out[out_off + (k2 + l1) * ido] = cr2 - ci3;
            out[out_off + (k2 + 2 * l1) * ido] = cr2 + ci3;
        }
        if (ido == 1) {
            return;
        }
        int idx0 = l1 * ido;
        for (int k3 = 0; k3 < l1; ++k3) {
            int idx1 = k3 * ido;
            int idx2 = 3 * idx1;
            int idx3 = idx2 + ido;
            int idx4 = idx3 + ido;
            int idx5 = idx1 + idx0;
            int idx6 = idx5 + idx0;
            for (int i2 = 2; i2 < ido; i2 += 2) {
                int ic = ido - i2;
                int idx7 = in_off + i2;
                int idx8 = in_off + ic;
                int idx9 = out_off + i2;
                int iidx1 = idx7 + idx2;
                int iidx2 = idx7 + idx4;
                int iidx3 = idx8 + idx3;
                float i1i = in[iidx1 - 1];
                float i1r = in[iidx1];
                float i2i = in[iidx2 - 1];
                float i2r = in[iidx2];
                float i3i = in[iidx3 - 1];
                float i3r = in[iidx3];
                tr2 = i2i + i3i;
                cr2 = i1i + -0.5f * tr2;
                float ti2 = i2r - i3r;
                float ci2 = i1r + -0.5f * ti2;
                float cr3 = 0.8660254f * (i2i - i3i);
                ci3 = 0.8660254f * (i2r + i3r);
                float dr2 = cr2 - ci3;
                float dr3 = cr2 + ci3;
                float di2 = ci2 + cr3;
                float di3 = ci2 - cr3;
                int widx1 = i2 - 1 + iw1;
                int widx2 = i2 - 1 + iw2;
                float w1r = this.wtable_r[widx1 - 1];
                float w1i = this.wtable_r[widx1];
                float w2r = this.wtable_r[widx2 - 1];
                float w2i = this.wtable_r[widx2];
                int oidx1 = idx9 + idx1;
                int oidx2 = idx9 + idx5;
                int oidx3 = idx9 + idx6;
                out[oidx1 - 1] = i1i + tr2;
                out[oidx1] = i1r + ti2;
                out[oidx2 - 1] = w1r * dr2 - w1i * di2;
                out[oidx2] = w1r * di2 + w1i * dr2;
                out[oidx3 - 1] = w2r * dr3 - w2i * di3;
                out[oidx3] = w2r * di3 + w2i * dr3;
            }
        }
    }

    void radb3(long ido, long l1, FloatLargeArray in, long in_off, FloatLargeArray out, long out_off, long offset) {
        float ci3;
        float cr2;
        float tr2;
        float taur = -0.5f;
        float taui = 0.8660254f;
        long iw1 = offset;
        long iw2 = iw1 + ido;
        for (long k2 = 0L; k2 < l1; ++k2) {
            long idx1 = k2 * ido;
            long iidx1 = in_off + 3L * idx1;
            long iidx2 = iidx1 + 2L * ido;
            float i1i = in.getFloat(iidx1);
            tr2 = 2.0f * in.getFloat(iidx2 - 1L);
            cr2 = i1i + -0.5f * tr2;
            ci3 = 1.7320508f * in.getFloat(iidx2);
            out.setFloat(out_off + idx1, i1i + tr2);
            out.setFloat(out_off + (k2 + l1) * ido, cr2 - ci3);
            out.setFloat(out_off + (k2 + 2L * l1) * ido, cr2 + ci3);
        }
        if (ido == 1L) {
            return;
        }
        long idx0 = l1 * ido;
        for (long k3 = 0L; k3 < l1; ++k3) {
            long idx1 = k3 * ido;
            long idx2 = 3L * idx1;
            long idx3 = idx2 + ido;
            long idx4 = idx3 + ido;
            long idx5 = idx1 + idx0;
            long idx6 = idx5 + idx0;
            for (long i2 = 2L; i2 < ido; i2 += 2L) {
                long ic = ido - i2;
                long idx7 = in_off + i2;
                long idx8 = in_off + ic;
                long idx9 = out_off + i2;
                long iidx1 = idx7 + idx2;
                long iidx2 = idx7 + idx4;
                long iidx3 = idx8 + idx3;
                float i1i = in.getFloat(iidx1 - 1L);
                float i1r = in.getFloat(iidx1);
                float i2i = in.getFloat(iidx2 - 1L);
                float i2r = in.getFloat(iidx2);
                float i3i = in.getFloat(iidx3 - 1L);
                float i3r = in.getFloat(iidx3);
                tr2 = i2i + i3i;
                cr2 = i1i + -0.5f * tr2;
                float ti2 = i2r - i3r;
                float ci2 = i1r + -0.5f * ti2;
                float cr3 = 0.8660254f * (i2i - i3i);
                ci3 = 0.8660254f * (i2r + i3r);
                float dr2 = cr2 - ci3;
                float dr3 = cr2 + ci3;
                float di2 = ci2 + cr3;
                float di3 = ci2 - cr3;
                long widx1 = i2 - 1L + iw1;
                long widx2 = i2 - 1L + iw2;
                float w1r = this.wtable_rl.getFloat(widx1 - 1L);
                float w1i = this.wtable_rl.getFloat(widx1);
                float w2r = this.wtable_rl.getFloat(widx2 - 1L);
                float w2i = this.wtable_rl.getFloat(widx2);
                long oidx1 = idx9 + idx1;
                long oidx2 = idx9 + idx5;
                long oidx3 = idx9 + idx6;
                out.setFloat(oidx1 - 1L, i1i + tr2);
                out.setFloat(oidx1, i1r + ti2);
                out.setFloat(oidx2 - 1L, w1r * dr2 - w1i * di2);
                out.setFloat(oidx2, w1r * di2 + w1i * dr2);
                out.setFloat(oidx3 - 1L, w2r * dr3 - w2i * di3);
                out.setFloat(oidx3, w2r * di3 + w2i * dr3);
            }
        }
    }

    void radf4(int ido, int l1, float[] in, int in_off, float[] out, int out_off, int offset) {
        float ti1;
        float tr2;
        float tr1;
        int idx6;
        int idx5;
        int idx4;
        int idx3;
        int idx2;
        int idx1;
        int k2;
        float hsqt2 = 0.70710677f;
        int iw1 = offset;
        int iw2 = offset + ido;
        int iw3 = iw2 + ido;
        int idx0 = l1 * ido;
        for (k2 = 0; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 4 * idx1;
            idx3 = idx1 + idx0;
            idx4 = idx3 + idx0;
            idx5 = idx4 + idx0;
            idx6 = idx2 + ido;
            float i1r = in[in_off + idx1];
            float i2r = in[in_off + idx3];
            float i3r = in[in_off + idx4];
            float i4r = in[in_off + idx5];
            tr1 = i2r + i4r;
            tr2 = i1r + i3r;
            int oidx1 = out_off + idx2;
            int oidx2 = out_off + idx6 + ido;
            out[oidx1] = tr1 + tr2;
            out[oidx2 - 1 + ido + ido] = tr2 - tr1;
            out[oidx2 - 1] = i1r - i3r;
            out[oidx2] = i4r - i2r;
        }
        if (ido < 2) {
            return;
        }
        if (ido != 2) {
            for (k2 = 0; k2 < l1; ++k2) {
                idx1 = k2 * ido;
                idx2 = idx1 + idx0;
                idx3 = idx2 + idx0;
                idx4 = idx3 + idx0;
                idx5 = 4 * idx1;
                idx6 = idx5 + ido;
                int idx7 = idx6 + ido;
                int idx8 = idx7 + ido;
                for (int i2 = 2; i2 < ido; i2 += 2) {
                    int ic = ido - i2;
                    int widx1 = i2 - 1 + iw1;
                    int widx2 = i2 - 1 + iw2;
                    int widx3 = i2 - 1 + iw3;
                    float w1r = this.wtable_r[widx1 - 1];
                    float w1i = this.wtable_r[widx1];
                    float w2r = this.wtable_r[widx2 - 1];
                    float w2i = this.wtable_r[widx2];
                    float w3r = this.wtable_r[widx3 - 1];
                    float w3i = this.wtable_r[widx3];
                    int idx9 = in_off + i2;
                    int idx10 = out_off + i2;
                    int idx11 = out_off + ic;
                    int iidx1 = idx9 + idx1;
                    int iidx2 = idx9 + idx2;
                    int iidx3 = idx9 + idx3;
                    int iidx4 = idx9 + idx4;
                    float i1i = in[iidx1 - 1];
                    float i1r = in[iidx1];
                    float i2i = in[iidx2 - 1];
                    float i2r = in[iidx2];
                    float i3i = in[iidx3 - 1];
                    float i3r = in[iidx3];
                    float i4i = in[iidx4 - 1];
                    float i4r = in[iidx4];
                    float cr2 = w1r * i2i + w1i * i2r;
                    float ci2 = w1r * i2r - w1i * i2i;
                    float cr3 = w2r * i3i + w2i * i3r;
                    float ci3 = w2r * i3r - w2i * i3i;
                    float cr4 = w3r * i4i + w3i * i4r;
                    float ci4 = w3r * i4r - w3i * i4i;
                    tr1 = cr2 + cr4;
                    float tr4 = cr4 - cr2;
                    ti1 = ci2 + ci4;
                    float ti4 = ci2 - ci4;
                    float ti2 = i1r + ci3;
                    float ti3 = i1r - ci3;
                    tr2 = i1i + cr3;
                    float tr3 = i1i - cr3;
                    int oidx1 = idx10 + idx5;
                    int oidx2 = idx11 + idx6;
                    int oidx3 = idx10 + idx7;
                    int oidx4 = idx11 + idx8;
                    out[oidx1 - 1] = tr1 + tr2;
                    out[oidx4 - 1] = tr2 - tr1;
                    out[oidx1] = ti1 + ti2;
                    out[oidx4] = ti1 - ti2;
                    out[oidx3 - 1] = ti4 + tr3;
                    out[oidx2 - 1] = tr3 - ti4;
                    out[oidx3] = tr4 + ti3;
                    out[oidx2] = tr4 - ti3;
                }
            }
            if (ido % 2 == 1) {
                return;
            }
        }
        for (k2 = 0; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 4 * idx1;
            idx3 = idx1 + idx0;
            idx4 = idx3 + idx0;
            idx5 = idx4 + idx0;
            idx6 = idx2 + ido;
            int idx7 = idx6 + ido;
            int idx8 = idx7 + ido;
            int idx9 = in_off + ido;
            int idx10 = out_off + ido;
            float i1i = in[idx9 - 1 + idx1];
            float i2i = in[idx9 - 1 + idx3];
            float i3i = in[idx9 - 1 + idx4];
            float i4i = in[idx9 - 1 + idx5];
            ti1 = -0.70710677f * (i2i + i4i);
            tr1 = 0.70710677f * (i2i - i4i);
            out[idx10 - 1 + idx2] = tr1 + i1i;
            out[idx10 - 1 + idx7] = i1i - tr1;
            out[out_off + idx6] = ti1 - i3i;
            out[out_off + idx8] = ti1 + i3i;
        }
    }

    void radf4(long ido, long l1, FloatLargeArray in, long in_off, FloatLargeArray out, long out_off, long offset) {
        float ti1;
        float tr2;
        float tr1;
        long idx6;
        long idx5;
        long idx4;
        long idx3;
        long idx2;
        long idx1;
        long k2;
        float hsqt2 = 0.70710677f;
        long iw1 = offset;
        long iw2 = offset + ido;
        long iw3 = iw2 + ido;
        long idx0 = l1 * ido;
        for (k2 = 0L; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 4L * idx1;
            idx3 = idx1 + idx0;
            idx4 = idx3 + idx0;
            idx5 = idx4 + idx0;
            idx6 = idx2 + ido;
            float i1r = in.getFloat(in_off + idx1);
            float i2r = in.getFloat(in_off + idx3);
            float i3r = in.getFloat(in_off + idx4);
            float i4r = in.getFloat(in_off + idx5);
            tr1 = i2r + i4r;
            tr2 = i1r + i3r;
            long oidx1 = out_off + idx2;
            long oidx2 = out_off + idx6 + ido;
            out.setFloat(oidx1, tr1 + tr2);
            out.setFloat(oidx2 - 1L + ido + ido, tr2 - tr1);
            out.setFloat(oidx2 - 1L, i1r - i3r);
            out.setFloat(oidx2, i4r - i2r);
        }
        if (ido < 2L) {
            return;
        }
        if (ido != 2L) {
            for (k2 = 0L; k2 < l1; ++k2) {
                idx1 = k2 * ido;
                idx2 = idx1 + idx0;
                idx3 = idx2 + idx0;
                idx4 = idx3 + idx0;
                idx5 = 4L * idx1;
                idx6 = idx5 + ido;
                long idx7 = idx6 + ido;
                long idx8 = idx7 + ido;
                for (long i2 = 2L; i2 < ido; i2 += 2L) {
                    long ic = ido - i2;
                    long widx1 = i2 - 1L + iw1;
                    long widx2 = i2 - 1L + iw2;
                    long widx3 = i2 - 1L + iw3;
                    float w1r = this.wtable_rl.getFloat(widx1 - 1L);
                    float w1i = this.wtable_rl.getFloat(widx1);
                    float w2r = this.wtable_rl.getFloat(widx2 - 1L);
                    float w2i = this.wtable_rl.getFloat(widx2);
                    float w3r = this.wtable_rl.getFloat(widx3 - 1L);
                    float w3i = this.wtable_rl.getFloat(widx3);
                    long idx9 = in_off + i2;
                    long idx10 = out_off + i2;
                    long idx11 = out_off + ic;
                    long iidx1 = idx9 + idx1;
                    long iidx2 = idx9 + idx2;
                    long iidx3 = idx9 + idx3;
                    long iidx4 = idx9 + idx4;
                    float i1i = in.getFloat(iidx1 - 1L);
                    float i1r = in.getFloat(iidx1);
                    float i2i = in.getFloat(iidx2 - 1L);
                    float i2r = in.getFloat(iidx2);
                    float i3i = in.getFloat(iidx3 - 1L);
                    float i3r = in.getFloat(iidx3);
                    float i4i = in.getFloat(iidx4 - 1L);
                    float i4r = in.getFloat(iidx4);
                    float cr2 = w1r * i2i + w1i * i2r;
                    float ci2 = w1r * i2r - w1i * i2i;
                    float cr3 = w2r * i3i + w2i * i3r;
                    float ci3 = w2r * i3r - w2i * i3i;
                    float cr4 = w3r * i4i + w3i * i4r;
                    float ci4 = w3r * i4r - w3i * i4i;
                    tr1 = cr2 + cr4;
                    float tr4 = cr4 - cr2;
                    ti1 = ci2 + ci4;
                    float ti4 = ci2 - ci4;
                    float ti2 = i1r + ci3;
                    float ti3 = i1r - ci3;
                    tr2 = i1i + cr3;
                    float tr3 = i1i - cr3;
                    long oidx1 = idx10 + idx5;
                    long oidx2 = idx11 + idx6;
                    long oidx3 = idx10 + idx7;
                    long oidx4 = idx11 + idx8;
                    out.setFloat(oidx1 - 1L, tr1 + tr2);
                    out.setFloat(oidx4 - 1L, tr2 - tr1);
                    out.setFloat(oidx1, ti1 + ti2);
                    out.setFloat(oidx4, ti1 - ti2);
                    out.setFloat(oidx3 - 1L, ti4 + tr3);
                    out.setFloat(oidx2 - 1L, tr3 - ti4);
                    out.setFloat(oidx3, tr4 + ti3);
                    out.setFloat(oidx2, tr4 - ti3);
                }
            }
            if (ido % 2L == 1L) {
                return;
            }
        }
        for (k2 = 0L; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 4L * idx1;
            idx3 = idx1 + idx0;
            idx4 = idx3 + idx0;
            idx5 = idx4 + idx0;
            idx6 = idx2 + ido;
            long idx7 = idx6 + ido;
            long idx8 = idx7 + ido;
            long idx9 = in_off + ido;
            long idx10 = out_off + ido;
            float i1i = in.getFloat(idx9 - 1L + idx1);
            float i2i = in.getFloat(idx9 - 1L + idx3);
            float i3i = in.getFloat(idx9 - 1L + idx4);
            float i4i = in.getFloat(idx9 - 1L + idx5);
            ti1 = -0.70710677f * (i2i + i4i);
            tr1 = 0.70710677f * (i2i - i4i);
            out.setFloat(idx10 - 1L + idx2, tr1 + i1i);
            out.setFloat(idx10 - 1L + idx7, i1i - tr1);
            out.setFloat(out_off + idx6, ti1 - i3i);
            out.setFloat(out_off + idx8, ti1 + i3i);
        }
    }

    void radb4(int ido, int l1, float[] in, int in_off, float[] out, int out_off, int offset) {
        float ti2;
        float ti1;
        float tr4;
        float tr3;
        float tr2;
        float tr1;
        int idx8;
        int idx7;
        int idx6;
        int idx5;
        int idx4;
        int idx3;
        int idx2;
        int idx1;
        int k2;
        float sqrt2 = 1.4142135f;
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int iw3 = iw2 + ido;
        int idx0 = l1 * ido;
        for (k2 = 0; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 4 * idx1;
            idx3 = idx1 + idx0;
            idx4 = idx3 + idx0;
            idx5 = idx4 + idx0;
            idx6 = idx2 + ido;
            idx7 = idx6 + ido;
            idx8 = idx7 + ido;
            float i1r = in[in_off + idx2];
            float i2r = in[in_off + idx7];
            float i3r = in[in_off + ido - 1 + idx8];
            float i4r = in[in_off + ido - 1 + idx6];
            tr1 = i1r - i3r;
            tr2 = i1r + i3r;
            tr3 = i4r + i4r;
            tr4 = i2r + i2r;
            out[out_off + idx1] = tr2 + tr3;
            out[out_off + idx3] = tr1 - tr4;
            out[out_off + idx4] = tr2 - tr3;
            out[out_off + idx5] = tr1 + tr4;
        }
        if (ido < 2) {
            return;
        }
        if (ido != 2) {
            for (k2 = 0; k2 < l1; ++k2) {
                idx1 = k2 * ido;
                idx2 = idx1 + idx0;
                idx3 = idx2 + idx0;
                idx4 = idx3 + idx0;
                idx5 = 4 * idx1;
                idx6 = idx5 + ido;
                idx7 = idx6 + ido;
                idx8 = idx7 + ido;
                for (int i2 = 2; i2 < ido; i2 += 2) {
                    int ic = ido - i2;
                    int widx1 = i2 - 1 + iw1;
                    int widx2 = i2 - 1 + iw2;
                    int widx3 = i2 - 1 + iw3;
                    float w1r = this.wtable_r[widx1 - 1];
                    float w1i = this.wtable_r[widx1];
                    float w2r = this.wtable_r[widx2 - 1];
                    float w2i = this.wtable_r[widx2];
                    float w3r = this.wtable_r[widx3 - 1];
                    float w3i = this.wtable_r[widx3];
                    int idx12 = in_off + i2;
                    int idx13 = in_off + ic;
                    int idx14 = out_off + i2;
                    int iidx1 = idx12 + idx5;
                    int iidx2 = idx13 + idx6;
                    int iidx3 = idx12 + idx7;
                    int iidx4 = idx13 + idx8;
                    float i1i = in[iidx1 - 1];
                    float i1r = in[iidx1];
                    float i2i = in[iidx2 - 1];
                    float i2r = in[iidx2];
                    float i3i = in[iidx3 - 1];
                    float i3r = in[iidx3];
                    float i4i = in[iidx4 - 1];
                    float i4r = in[iidx4];
                    ti1 = i1r + i4r;
                    ti2 = i1r - i4r;
                    float ti3 = i3r - i2r;
                    tr4 = i3r + i2r;
                    tr1 = i1i - i4i;
                    tr2 = i1i + i4i;
                    float ti4 = i3i - i2i;
                    tr3 = i3i + i2i;
                    float cr3 = tr2 - tr3;
                    float ci3 = ti2 - ti3;
                    float cr2 = tr1 - tr4;
                    float cr4 = tr1 + tr4;
                    float ci2 = ti1 + ti4;
                    float ci4 = ti1 - ti4;
                    int oidx1 = idx14 + idx1;
                    int oidx2 = idx14 + idx2;
                    int oidx3 = idx14 + idx3;
                    int oidx4 = idx14 + idx4;
                    out[oidx1 - 1] = tr2 + tr3;
                    out[oidx1] = ti2 + ti3;
                    out[oidx2 - 1] = w1r * cr2 - w1i * ci2;
                    out[oidx2] = w1r * ci2 + w1i * cr2;
                    out[oidx3 - 1] = w2r * cr3 - w2i * ci3;
                    out[oidx3] = w2r * ci3 + w2i * cr3;
                    out[oidx4 - 1] = w3r * cr4 - w3i * ci4;
                    out[oidx4] = w3r * ci4 + w3i * cr4;
                }
            }
            if (ido % 2 == 1) {
                return;
            }
        }
        for (k2 = 0; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 4 * idx1;
            idx3 = idx1 + idx0;
            idx4 = idx3 + idx0;
            idx5 = idx4 + idx0;
            idx6 = idx2 + ido;
            idx7 = idx6 + ido;
            idx8 = idx7 + ido;
            int idx9 = in_off + ido;
            int idx10 = out_off + ido;
            float i1r = in[idx9 - 1 + idx2];
            float i2r = in[idx9 - 1 + idx7];
            float i3r = in[in_off + idx6];
            float i4r = in[in_off + idx8];
            ti1 = i3r + i4r;
            ti2 = i4r - i3r;
            tr1 = i1r - i2r;
            tr2 = i1r + i2r;
            out[idx10 - 1 + idx1] = tr2 + tr2;
            out[idx10 - 1 + idx3] = 1.4142135f * (tr1 - ti1);
            out[idx10 - 1 + idx4] = ti2 + ti2;
            out[idx10 - 1 + idx5] = -1.4142135f * (tr1 + ti1);
        }
    }

    void radb4(long ido, long l1, FloatLargeArray in, long in_off, FloatLargeArray out, long out_off, long offset) {
        float ti2;
        float ti1;
        float tr4;
        float tr3;
        float tr2;
        float tr1;
        long idx8;
        long idx7;
        long idx6;
        long idx5;
        long idx4;
        long idx3;
        long idx2;
        long idx1;
        long k2;
        float sqrt2 = 1.4142135f;
        long iw1 = offset;
        long iw2 = iw1 + ido;
        long iw3 = iw2 + ido;
        long idx0 = l1 * ido;
        for (k2 = 0L; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 4L * idx1;
            idx3 = idx1 + idx0;
            idx4 = idx3 + idx0;
            idx5 = idx4 + idx0;
            idx6 = idx2 + ido;
            idx7 = idx6 + ido;
            idx8 = idx7 + ido;
            float i1r = in.getFloat(in_off + idx2);
            float i2r = in.getFloat(in_off + idx7);
            float i3r = in.getFloat(in_off + ido - 1L + idx8);
            float i4r = in.getFloat(in_off + ido - 1L + idx6);
            tr1 = i1r - i3r;
            tr2 = i1r + i3r;
            tr3 = i4r + i4r;
            tr4 = i2r + i2r;
            out.setFloat(out_off + idx1, tr2 + tr3);
            out.setFloat(out_off + idx3, tr1 - tr4);
            out.setFloat(out_off + idx4, tr2 - tr3);
            out.setFloat(out_off + idx5, tr1 + tr4);
        }
        if (ido < 2L) {
            return;
        }
        if (ido != 2L) {
            for (k2 = 0L; k2 < l1; ++k2) {
                idx1 = k2 * ido;
                idx2 = idx1 + idx0;
                idx3 = idx2 + idx0;
                idx4 = idx3 + idx0;
                idx5 = 4L * idx1;
                idx6 = idx5 + ido;
                idx7 = idx6 + ido;
                idx8 = idx7 + ido;
                for (long i2 = 2L; i2 < ido; i2 += 2L) {
                    long ic = ido - i2;
                    long widx1 = i2 - 1L + iw1;
                    long widx2 = i2 - 1L + iw2;
                    long widx3 = i2 - 1L + iw3;
                    float w1r = this.wtable_rl.getFloat(widx1 - 1L);
                    float w1i = this.wtable_rl.getFloat(widx1);
                    float w2r = this.wtable_rl.getFloat(widx2 - 1L);
                    float w2i = this.wtable_rl.getFloat(widx2);
                    float w3r = this.wtable_rl.getFloat(widx3 - 1L);
                    float w3i = this.wtable_rl.getFloat(widx3);
                    long idx12 = in_off + i2;
                    long idx13 = in_off + ic;
                    long idx14 = out_off + i2;
                    long iidx1 = idx12 + idx5;
                    long iidx2 = idx13 + idx6;
                    long iidx3 = idx12 + idx7;
                    long iidx4 = idx13 + idx8;
                    float i1i = in.getFloat(iidx1 - 1L);
                    float i1r = in.getFloat(iidx1);
                    float i2i = in.getFloat(iidx2 - 1L);
                    float i2r = in.getFloat(iidx2);
                    float i3i = in.getFloat(iidx3 - 1L);
                    float i3r = in.getFloat(iidx3);
                    float i4i = in.getFloat(iidx4 - 1L);
                    float i4r = in.getFloat(iidx4);
                    ti1 = i1r + i4r;
                    ti2 = i1r - i4r;
                    float ti3 = i3r - i2r;
                    tr4 = i3r + i2r;
                    tr1 = i1i - i4i;
                    tr2 = i1i + i4i;
                    float ti4 = i3i - i2i;
                    tr3 = i3i + i2i;
                    float cr3 = tr2 - tr3;
                    float ci3 = ti2 - ti3;
                    float cr2 = tr1 - tr4;
                    float cr4 = tr1 + tr4;
                    float ci2 = ti1 + ti4;
                    float ci4 = ti1 - ti4;
                    long oidx1 = idx14 + idx1;
                    long oidx2 = idx14 + idx2;
                    long oidx3 = idx14 + idx3;
                    long oidx4 = idx14 + idx4;
                    out.setFloat(oidx1 - 1L, tr2 + tr3);
                    out.setFloat(oidx1, ti2 + ti3);
                    out.setFloat(oidx2 - 1L, w1r * cr2 - w1i * ci2);
                    out.setFloat(oidx2, w1r * ci2 + w1i * cr2);
                    out.setFloat(oidx3 - 1L, w2r * cr3 - w2i * ci3);
                    out.setFloat(oidx3, w2r * ci3 + w2i * cr3);
                    out.setFloat(oidx4 - 1L, w3r * cr4 - w3i * ci4);
                    out.setFloat(oidx4, w3r * ci4 + w3i * cr4);
                }
            }
            if (ido % 2L == 1L) {
                return;
            }
        }
        for (k2 = 0L; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 4L * idx1;
            idx3 = idx1 + idx0;
            idx4 = idx3 + idx0;
            idx5 = idx4 + idx0;
            idx6 = idx2 + ido;
            idx7 = idx6 + ido;
            idx8 = idx7 + ido;
            long idx9 = in_off + ido;
            long idx10 = out_off + ido;
            float i1r = in.getFloat(idx9 - 1L + idx2);
            float i2r = in.getFloat(idx9 - 1L + idx7);
            float i3r = in.getFloat(in_off + idx6);
            float i4r = in.getFloat(in_off + idx8);
            ti1 = i3r + i4r;
            ti2 = i4r - i3r;
            tr1 = i1r - i2r;
            tr2 = i1r + i2r;
            out.setFloat(idx10 - 1L + idx1, tr2 + tr2);
            out.setFloat(idx10 - 1L + idx3, 1.4142135f * (tr1 - ti1));
            out.setFloat(idx10 - 1L + idx4, ti2 + ti2);
            out.setFloat(idx10 - 1L + idx5, -1.4142135f * (tr1 + ti1));
        }
    }

    void radf5(int ido, int l1, float[] in, int in_off, float[] out, int out_off, int offset) {
        float ci4;
        float cr3;
        float ci5;
        float cr2;
        int idx10;
        int idx9;
        int idx8;
        int idx7;
        int idx6;
        int idx5;
        int idx4;
        int idx3;
        int idx2;
        int idx1;
        int k2;
        float tr11 = 0.309017f;
        float ti11 = 0.95105654f;
        float tr12 = -0.809017f;
        float ti12 = 0.58778524f;
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int iw3 = iw2 + ido;
        int iw4 = iw3 + ido;
        int idx0 = l1 * ido;
        for (k2 = 0; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 5 * idx1;
            idx3 = idx2 + ido;
            idx4 = idx3 + ido;
            idx5 = idx4 + ido;
            idx6 = idx5 + ido;
            idx7 = idx1 + idx0;
            idx8 = idx7 + idx0;
            idx9 = idx8 + idx0;
            idx10 = idx9 + idx0;
            int idx11 = out_off + ido - 1;
            float i1r = in[in_off + idx1];
            float i2r = in[in_off + idx7];
            float i3r = in[in_off + idx8];
            float i4r = in[in_off + idx9];
            float i5r = in[in_off + idx10];
            cr2 = i5r + i2r;
            ci5 = i5r - i2r;
            cr3 = i4r + i3r;
            ci4 = i4r - i3r;
            out[out_off + idx2] = i1r + cr2 + cr3;
            out[idx11 + idx3] = i1r + 0.309017f * cr2 + -0.809017f * cr3;
            out[out_off + idx4] = 0.95105654f * ci5 + 0.58778524f * ci4;
            out[idx11 + idx5] = i1r + -0.809017f * cr2 + 0.309017f * cr3;
            out[out_off + idx6] = 0.58778524f * ci5 - 0.95105654f * ci4;
        }
        if (ido == 1) {
            return;
        }
        for (k2 = 0; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 5 * idx1;
            idx3 = idx2 + ido;
            idx4 = idx3 + ido;
            idx5 = idx4 + ido;
            idx6 = idx5 + ido;
            idx7 = idx1 + idx0;
            idx8 = idx7 + idx0;
            idx9 = idx8 + idx0;
            idx10 = idx9 + idx0;
            for (int i2 = 2; i2 < ido; i2 += 2) {
                int widx1 = i2 - 1 + iw1;
                int widx2 = i2 - 1 + iw2;
                int widx3 = i2 - 1 + iw3;
                int widx4 = i2 - 1 + iw4;
                float w1r = this.wtable_r[widx1 - 1];
                float w1i = this.wtable_r[widx1];
                float w2r = this.wtable_r[widx2 - 1];
                float w2i = this.wtable_r[widx2];
                float w3r = this.wtable_r[widx3 - 1];
                float w3i = this.wtable_r[widx3];
                float w4r = this.wtable_r[widx4 - 1];
                float w4i = this.wtable_r[widx4];
                int ic = ido - i2;
                int idx15 = in_off + i2;
                int idx16 = out_off + i2;
                int idx17 = out_off + ic;
                int iidx1 = idx15 + idx1;
                int iidx2 = idx15 + idx7;
                int iidx3 = idx15 + idx8;
                int iidx4 = idx15 + idx9;
                int iidx5 = idx15 + idx10;
                float i1i = in[iidx1 - 1];
                float i1r = in[iidx1];
                float i2i = in[iidx2 - 1];
                float i2r = in[iidx2];
                float i3i = in[iidx3 - 1];
                float i3r = in[iidx3];
                float i4i = in[iidx4 - 1];
                float i4r = in[iidx4];
                float i5i = in[iidx5 - 1];
                float i5r = in[iidx5];
                float dr2 = w1r * i2i + w1i * i2r;
                float di2 = w1r * i2r - w1i * i2i;
                float dr3 = w2r * i3i + w2i * i3r;
                float di3 = w2r * i3r - w2i * i3i;
                float dr4 = w3r * i4i + w3i * i4r;
                float di4 = w3r * i4r - w3i * i4i;
                float dr5 = w4r * i5i + w4i * i5r;
                float di5 = w4r * i5r - w4i * i5i;
                cr2 = dr2 + dr5;
                ci5 = dr5 - dr2;
                float cr5 = di2 - di5;
                float ci2 = di2 + di5;
                cr3 = dr3 + dr4;
                ci4 = dr4 - dr3;
                float cr4 = di3 - di4;
                float ci3 = di3 + di4;
                float tr2 = i1i + 0.309017f * cr2 + -0.809017f * cr3;
                float ti2 = i1r + 0.309017f * ci2 + -0.809017f * ci3;
                float tr3 = i1i + -0.809017f * cr2 + 0.309017f * cr3;
                float ti3 = i1r + -0.809017f * ci2 + 0.309017f * ci3;
                float tr5 = 0.95105654f * cr5 + 0.58778524f * cr4;
                float ti5 = 0.95105654f * ci5 + 0.58778524f * ci4;
                float tr4 = 0.58778524f * cr5 - 0.95105654f * cr4;
                float ti4 = 0.58778524f * ci5 - 0.95105654f * ci4;
                int oidx1 = idx16 + idx2;
                int oidx2 = idx17 + idx3;
                int oidx3 = idx16 + idx4;
                int oidx4 = idx17 + idx5;
                int oidx5 = idx16 + idx6;
                out[oidx1 - 1] = i1i + cr2 + cr3;
                out[oidx1] = i1r + ci2 + ci3;
                out[oidx3 - 1] = tr2 + tr5;
                out[oidx2 - 1] = tr2 - tr5;
                out[oidx3] = ti2 + ti5;
                out[oidx2] = ti5 - ti2;
                out[oidx5 - 1] = tr3 + tr4;
                out[oidx4 - 1] = tr3 - tr4;
                out[oidx5] = ti3 + ti4;
                out[oidx4] = ti4 - ti3;
            }
        }
    }

    void radf5(long ido, long l1, FloatLargeArray in, long in_off, FloatLargeArray out, long out_off, long offset) {
        float ci4;
        float cr3;
        float ci5;
        float cr2;
        long idx10;
        long idx9;
        long idx8;
        long idx7;
        long idx6;
        long idx5;
        long idx4;
        long idx3;
        long idx2;
        long idx1;
        long k2;
        float tr11 = 0.309017f;
        float ti11 = 0.95105654f;
        float tr12 = -0.809017f;
        float ti12 = 0.58778524f;
        long iw1 = offset;
        long iw2 = iw1 + ido;
        long iw3 = iw2 + ido;
        long iw4 = iw3 + ido;
        long idx0 = l1 * ido;
        for (k2 = 0L; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 5L * idx1;
            idx3 = idx2 + ido;
            idx4 = idx3 + ido;
            idx5 = idx4 + ido;
            idx6 = idx5 + ido;
            idx7 = idx1 + idx0;
            idx8 = idx7 + idx0;
            idx9 = idx8 + idx0;
            idx10 = idx9 + idx0;
            long idx11 = out_off + ido - 1L;
            float i1r = in.getFloat(in_off + idx1);
            float i2r = in.getFloat(in_off + idx7);
            float i3r = in.getFloat(in_off + idx8);
            float i4r = in.getFloat(in_off + idx9);
            float i5r = in.getFloat(in_off + idx10);
            cr2 = i5r + i2r;
            ci5 = i5r - i2r;
            cr3 = i4r + i3r;
            ci4 = i4r - i3r;
            out.setFloat(out_off + idx2, i1r + cr2 + cr3);
            out.setFloat(idx11 + idx3, i1r + 0.309017f * cr2 + -0.809017f * cr3);
            out.setFloat(out_off + idx4, 0.95105654f * ci5 + 0.58778524f * ci4);
            out.setFloat(idx11 + idx5, i1r + -0.809017f * cr2 + 0.309017f * cr3);
            out.setFloat(out_off + idx6, 0.58778524f * ci5 - 0.95105654f * ci4);
        }
        if (ido == 1L) {
            return;
        }
        for (k2 = 0L; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 5L * idx1;
            idx3 = idx2 + ido;
            idx4 = idx3 + ido;
            idx5 = idx4 + ido;
            idx6 = idx5 + ido;
            idx7 = idx1 + idx0;
            idx8 = idx7 + idx0;
            idx9 = idx8 + idx0;
            idx10 = idx9 + idx0;
            for (long i2 = 2L; i2 < ido; i2 += 2L) {
                long widx1 = i2 - 1L + iw1;
                long widx2 = i2 - 1L + iw2;
                long widx3 = i2 - 1L + iw3;
                long widx4 = i2 - 1L + iw4;
                float w1r = this.wtable_rl.getFloat(widx1 - 1L);
                float w1i = this.wtable_rl.getFloat(widx1);
                float w2r = this.wtable_rl.getFloat(widx2 - 1L);
                float w2i = this.wtable_rl.getFloat(widx2);
                float w3r = this.wtable_rl.getFloat(widx3 - 1L);
                float w3i = this.wtable_rl.getFloat(widx3);
                float w4r = this.wtable_rl.getFloat(widx4 - 1L);
                float w4i = this.wtable_rl.getFloat(widx4);
                long ic = ido - i2;
                long idx15 = in_off + i2;
                long idx16 = out_off + i2;
                long idx17 = out_off + ic;
                long iidx1 = idx15 + idx1;
                long iidx2 = idx15 + idx7;
                long iidx3 = idx15 + idx8;
                long iidx4 = idx15 + idx9;
                long iidx5 = idx15 + idx10;
                float i1i = in.getFloat(iidx1 - 1L);
                float i1r = in.getFloat(iidx1);
                float i2i = in.getFloat(iidx2 - 1L);
                float i2r = in.getFloat(iidx2);
                float i3i = in.getFloat(iidx3 - 1L);
                float i3r = in.getFloat(iidx3);
                float i4i = in.getFloat(iidx4 - 1L);
                float i4r = in.getFloat(iidx4);
                float i5i = in.getFloat(iidx5 - 1L);
                float i5r = in.getFloat(iidx5);
                float dr2 = w1r * i2i + w1i * i2r;
                float di2 = w1r * i2r - w1i * i2i;
                float dr3 = w2r * i3i + w2i * i3r;
                float di3 = w2r * i3r - w2i * i3i;
                float dr4 = w3r * i4i + w3i * i4r;
                float di4 = w3r * i4r - w3i * i4i;
                float dr5 = w4r * i5i + w4i * i5r;
                float di5 = w4r * i5r - w4i * i5i;
                cr2 = dr2 + dr5;
                ci5 = dr5 - dr2;
                float cr5 = di2 - di5;
                float ci2 = di2 + di5;
                cr3 = dr3 + dr4;
                ci4 = dr4 - dr3;
                float cr4 = di3 - di4;
                float ci3 = di3 + di4;
                float tr2 = i1i + 0.309017f * cr2 + -0.809017f * cr3;
                float ti2 = i1r + 0.309017f * ci2 + -0.809017f * ci3;
                float tr3 = i1i + -0.809017f * cr2 + 0.309017f * cr3;
                float ti3 = i1r + -0.809017f * ci2 + 0.309017f * ci3;
                float tr5 = 0.95105654f * cr5 + 0.58778524f * cr4;
                float ti5 = 0.95105654f * ci5 + 0.58778524f * ci4;
                float tr4 = 0.58778524f * cr5 - 0.95105654f * cr4;
                float ti4 = 0.58778524f * ci5 - 0.95105654f * ci4;
                long oidx1 = idx16 + idx2;
                long oidx2 = idx17 + idx3;
                long oidx3 = idx16 + idx4;
                long oidx4 = idx17 + idx5;
                long oidx5 = idx16 + idx6;
                out.setFloat(oidx1 - 1L, i1i + cr2 + cr3);
                out.setFloat(oidx1, i1r + ci2 + ci3);
                out.setFloat(oidx3 - 1L, tr2 + tr5);
                out.setFloat(oidx2 - 1L, tr2 - tr5);
                out.setFloat(oidx3, ti2 + ti5);
                out.setFloat(oidx2, ti5 - ti2);
                out.setFloat(oidx5 - 1L, tr3 + tr4);
                out.setFloat(oidx4 - 1L, tr3 - tr4);
                out.setFloat(oidx5, ti3 + ti4);
                out.setFloat(oidx4, ti4 - ti3);
            }
        }
    }

    void radb5(int ido, int l1, float[] in, int in_off, float[] out, int out_off, int offset) {
        float ci4;
        float ci5;
        float cr3;
        float cr2;
        float tr3;
        float tr2;
        float ti4;
        float ti5;
        int idx10;
        int idx9;
        int idx8;
        int idx7;
        int idx6;
        int idx5;
        int idx4;
        int idx3;
        int idx2;
        int idx1;
        int k2;
        float tr11 = 0.309017f;
        float ti11 = 0.95105654f;
        float tr12 = -0.809017f;
        float ti12 = 0.58778524f;
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int iw3 = iw2 + ido;
        int iw4 = iw3 + ido;
        int idx0 = l1 * ido;
        for (k2 = 0; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 5 * idx1;
            idx3 = idx2 + ido;
            idx4 = idx3 + ido;
            idx5 = idx4 + ido;
            idx6 = idx5 + ido;
            idx7 = idx1 + idx0;
            idx8 = idx7 + idx0;
            idx9 = idx8 + idx0;
            idx10 = idx9 + idx0;
            int idx11 = in_off + ido - 1;
            float i1r = in[in_off + idx2];
            ti5 = 2.0f * in[in_off + idx4];
            ti4 = 2.0f * in[in_off + idx6];
            tr2 = 2.0f * in[idx11 + idx3];
            tr3 = 2.0f * in[idx11 + idx5];
            cr2 = i1r + 0.309017f * tr2 + -0.809017f * tr3;
            cr3 = i1r + -0.809017f * tr2 + 0.309017f * tr3;
            ci5 = 0.95105654f * ti5 + 0.58778524f * ti4;
            ci4 = 0.58778524f * ti5 - 0.95105654f * ti4;
            out[out_off + idx1] = i1r + tr2 + tr3;
            out[out_off + idx7] = cr2 - ci5;
            out[out_off + idx8] = cr3 - ci4;
            out[out_off + idx9] = cr3 + ci4;
            out[out_off + idx10] = cr2 + ci5;
        }
        if (ido == 1) {
            return;
        }
        for (k2 = 0; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 5 * idx1;
            idx3 = idx2 + ido;
            idx4 = idx3 + ido;
            idx5 = idx4 + ido;
            idx6 = idx5 + ido;
            idx7 = idx1 + idx0;
            idx8 = idx7 + idx0;
            idx9 = idx8 + idx0;
            idx10 = idx9 + idx0;
            for (int i2 = 2; i2 < ido; i2 += 2) {
                int ic = ido - i2;
                int widx1 = i2 - 1 + iw1;
                int widx2 = i2 - 1 + iw2;
                int widx3 = i2 - 1 + iw3;
                int widx4 = i2 - 1 + iw4;
                float w1r = this.wtable_r[widx1 - 1];
                float w1i = this.wtable_r[widx1];
                float w2r = this.wtable_r[widx2 - 1];
                float w2i = this.wtable_r[widx2];
                float w3r = this.wtable_r[widx3 - 1];
                float w3i = this.wtable_r[widx3];
                float w4r = this.wtable_r[widx4 - 1];
                float w4i = this.wtable_r[widx4];
                int idx15 = in_off + i2;
                int idx16 = in_off + ic;
                int idx17 = out_off + i2;
                int iidx1 = idx15 + idx2;
                int iidx2 = idx16 + idx3;
                int iidx3 = idx15 + idx4;
                int iidx4 = idx16 + idx5;
                int iidx5 = idx15 + idx6;
                float i1i = in[iidx1 - 1];
                float i1r = in[iidx1];
                float i2i = in[iidx2 - 1];
                float i2r = in[iidx2];
                float i3i = in[iidx3 - 1];
                float i3r = in[iidx3];
                float i4i = in[iidx4 - 1];
                float i4r = in[iidx4];
                float i5i = in[iidx5 - 1];
                float i5r = in[iidx5];
                ti5 = i3r + i2r;
                float ti2 = i3r - i2r;
                ti4 = i5r + i4r;
                float ti3 = i5r - i4r;
                float tr5 = i3i - i2i;
                tr2 = i3i + i2i;
                float tr4 = i5i - i4i;
                tr3 = i5i + i4i;
                cr2 = i1i + 0.309017f * tr2 + -0.809017f * tr3;
                float ci2 = i1r + 0.309017f * ti2 + -0.809017f * ti3;
                cr3 = i1i + -0.809017f * tr2 + 0.309017f * tr3;
                float ci3 = i1r + -0.809017f * ti2 + 0.309017f * ti3;
                float cr5 = 0.95105654f * tr5 + 0.58778524f * tr4;
                ci5 = 0.95105654f * ti5 + 0.58778524f * ti4;
                float cr4 = 0.58778524f * tr5 - 0.95105654f * tr4;
                ci4 = 0.58778524f * ti5 - 0.95105654f * ti4;
                float dr3 = cr3 - ci4;
                float dr4 = cr3 + ci4;
                float di3 = ci3 + cr4;
                float di4 = ci3 - cr4;
                float dr5 = cr2 + ci5;
                float dr2 = cr2 - ci5;
                float di5 = ci2 - cr5;
                float di2 = ci2 + cr5;
                int oidx1 = idx17 + idx1;
                int oidx2 = idx17 + idx7;
                int oidx3 = idx17 + idx8;
                int oidx4 = idx17 + idx9;
                int oidx5 = idx17 + idx10;
                out[oidx1 - 1] = i1i + tr2 + tr3;
                out[oidx1] = i1r + ti2 + ti3;
                out[oidx2 - 1] = w1r * dr2 - w1i * di2;
                out[oidx2] = w1r * di2 + w1i * dr2;
                out[oidx3 - 1] = w2r * dr3 - w2i * di3;
                out[oidx3] = w2r * di3 + w2i * dr3;
                out[oidx4 - 1] = w3r * dr4 - w3i * di4;
                out[oidx4] = w3r * di4 + w3i * dr4;
                out[oidx5 - 1] = w4r * dr5 - w4i * di5;
                out[oidx5] = w4r * di5 + w4i * dr5;
            }
        }
    }

    void radb5(long ido, long l1, FloatLargeArray in, long in_off, FloatLargeArray out, long out_off, long offset) {
        float ci4;
        float ci5;
        float cr3;
        float cr2;
        float tr3;
        float tr2;
        float ti4;
        float ti5;
        long idx10;
        long idx9;
        long idx8;
        long idx7;
        long idx6;
        long idx5;
        long idx4;
        long idx3;
        long idx2;
        long idx1;
        long k2;
        float tr11 = 0.309017f;
        float ti11 = 0.95105654f;
        float tr12 = -0.809017f;
        float ti12 = 0.58778524f;
        long iw1 = offset;
        long iw2 = iw1 + ido;
        long iw3 = iw2 + ido;
        long iw4 = iw3 + ido;
        long idx0 = l1 * ido;
        for (k2 = 0L; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 5L * idx1;
            idx3 = idx2 + ido;
            idx4 = idx3 + ido;
            idx5 = idx4 + ido;
            idx6 = idx5 + ido;
            idx7 = idx1 + idx0;
            idx8 = idx7 + idx0;
            idx9 = idx8 + idx0;
            idx10 = idx9 + idx0;
            long idx11 = in_off + ido - 1L;
            float i1r = in.getFloat(in_off + idx2);
            ti5 = 2.0f * in.getFloat(in_off + idx4);
            ti4 = 2.0f * in.getFloat(in_off + idx6);
            tr2 = 2.0f * in.getFloat(idx11 + idx3);
            tr3 = 2.0f * in.getFloat(idx11 + idx5);
            cr2 = i1r + 0.309017f * tr2 + -0.809017f * tr3;
            cr3 = i1r + -0.809017f * tr2 + 0.309017f * tr3;
            ci5 = 0.95105654f * ti5 + 0.58778524f * ti4;
            ci4 = 0.58778524f * ti5 - 0.95105654f * ti4;
            out.setFloat(out_off + idx1, i1r + tr2 + tr3);
            out.setFloat(out_off + idx7, cr2 - ci5);
            out.setFloat(out_off + idx8, cr3 - ci4);
            out.setFloat(out_off + idx9, cr3 + ci4);
            out.setFloat(out_off + idx10, cr2 + ci5);
        }
        if (ido == 1L) {
            return;
        }
        for (k2 = 0L; k2 < l1; ++k2) {
            idx1 = k2 * ido;
            idx2 = 5L * idx1;
            idx3 = idx2 + ido;
            idx4 = idx3 + ido;
            idx5 = idx4 + ido;
            idx6 = idx5 + ido;
            idx7 = idx1 + idx0;
            idx8 = idx7 + idx0;
            idx9 = idx8 + idx0;
            idx10 = idx9 + idx0;
            for (long i2 = 2L; i2 < ido; i2 += 2L) {
                long ic = ido - i2;
                long widx1 = i2 - 1L + iw1;
                long widx2 = i2 - 1L + iw2;
                long widx3 = i2 - 1L + iw3;
                long widx4 = i2 - 1L + iw4;
                float w1r = this.wtable_rl.getFloat(widx1 - 1L);
                float w1i = this.wtable_rl.getFloat(widx1);
                float w2r = this.wtable_rl.getFloat(widx2 - 1L);
                float w2i = this.wtable_rl.getFloat(widx2);
                float w3r = this.wtable_rl.getFloat(widx3 - 1L);
                float w3i = this.wtable_rl.getFloat(widx3);
                float w4r = this.wtable_rl.getFloat(widx4 - 1L);
                float w4i = this.wtable_rl.getFloat(widx4);
                long idx15 = in_off + i2;
                long idx16 = in_off + ic;
                long idx17 = out_off + i2;
                long iidx1 = idx15 + idx2;
                long iidx2 = idx16 + idx3;
                long iidx3 = idx15 + idx4;
                long iidx4 = idx16 + idx5;
                long iidx5 = idx15 + idx6;
                float i1i = in.getFloat(iidx1 - 1L);
                float i1r = in.getFloat(iidx1);
                float i2i = in.getFloat(iidx2 - 1L);
                float i2r = in.getFloat(iidx2);
                float i3i = in.getFloat(iidx3 - 1L);
                float i3r = in.getFloat(iidx3);
                float i4i = in.getFloat(iidx4 - 1L);
                float i4r = in.getFloat(iidx4);
                float i5i = in.getFloat(iidx5 - 1L);
                float i5r = in.getFloat(iidx5);
                ti5 = i3r + i2r;
                float ti2 = i3r - i2r;
                ti4 = i5r + i4r;
                float ti3 = i5r - i4r;
                float tr5 = i3i - i2i;
                tr2 = i3i + i2i;
                float tr4 = i5i - i4i;
                tr3 = i5i + i4i;
                cr2 = i1i + 0.309017f * tr2 + -0.809017f * tr3;
                float ci2 = i1r + 0.309017f * ti2 + -0.809017f * ti3;
                cr3 = i1i + -0.809017f * tr2 + 0.309017f * tr3;
                float ci3 = i1r + -0.809017f * ti2 + 0.309017f * ti3;
                float cr5 = 0.95105654f * tr5 + 0.58778524f * tr4;
                ci5 = 0.95105654f * ti5 + 0.58778524f * ti4;
                float cr4 = 0.58778524f * tr5 - 0.95105654f * tr4;
                ci4 = 0.58778524f * ti5 - 0.95105654f * ti4;
                float dr3 = cr3 - ci4;
                float dr4 = cr3 + ci4;
                float di3 = ci3 + cr4;
                float di4 = ci3 - cr4;
                float dr5 = cr2 + ci5;
                float dr2 = cr2 - ci5;
                float di5 = ci2 - cr5;
                float di2 = ci2 + cr5;
                long oidx1 = idx17 + idx1;
                long oidx2 = idx17 + idx7;
                long oidx3 = idx17 + idx8;
                long oidx4 = idx17 + idx9;
                long oidx5 = idx17 + idx10;
                out.setFloat(oidx1 - 1L, i1i + tr2 + tr3);
                out.setFloat(oidx1, i1r + ti2 + ti3);
                out.setFloat(oidx2 - 1L, w1r * dr2 - w1i * di2);
                out.setFloat(oidx2, w1r * di2 + w1i * dr2);
                out.setFloat(oidx3 - 1L, w2r * dr3 - w2i * di3);
                out.setFloat(oidx3, w2r * di3 + w2i * dr3);
                out.setFloat(oidx4 - 1L, w3r * dr4 - w3i * di4);
                out.setFloat(oidx4, w3r * di4 + w3i * dr4);
                out.setFloat(oidx5 - 1L, w4r * dr5 - w4i * di5);
                out.setFloat(oidx5, w4r * di5 + w4i * dr5);
            }
        }
    }

    void radfg(int ido, int ip, int l1, int idl1, float[] in, int in_off, float[] out, int out_off, int offset) {
        int idx4;
        int idx2;
        int j2;
        int j3;
        int idx1;
        int idx3;
        int idx12;
        int i2;
        int idx42;
        int idx32;
        int k2;
        int idx22;
        int jc;
        int oidx1;
        int i3;
        int k3;
        int idx23;
        int k4;
        int idx13;
        int j4;
        int iw1 = offset;
        float arg = (float)Math.PI * 2 / (float)ip;
        float dcp = (float)FastMath.cos((double)arg);
        float dsp = (float)FastMath.sin((double)arg);
        int ipph = (ip + 1) / 2;
        int nbd = (ido - 1) / 2;
        if (ido != 1) {
            float o2r;
            float o2i;
            float o1r;
            float o1i;
            int oidx2;
            int iidx1;
            int idx33;
            float w1i;
            float w1r;
            int idij;
            int is;
            for (int ik = 0; ik < idl1; ++ik) {
                out[out_off + ik] = in[in_off + ik];
            }
            for (j4 = 1; j4 < ip; ++j4) {
                idx13 = j4 * l1 * ido;
                for (k4 = 0; k4 < l1; ++k4) {
                    idx23 = k4 * ido + idx13;
                    out[out_off + idx23] = in[in_off + idx23];
                }
            }
            if (nbd <= l1) {
                is = -ido;
                for (j4 = 1; j4 < ip; ++j4) {
                    idij = (is += ido) - 1;
                    idx13 = j4 * l1 * ido;
                    for (int i4 = 2; i4 < ido; i4 += 2) {
                        idx23 = (idij += 2) + iw1;
                        int idx43 = in_off + i4;
                        int idx5 = out_off + i4;
                        w1r = this.wtable_r[idx23 - 1];
                        w1i = this.wtable_r[idx23];
                        for (k3 = 0; k3 < l1; ++k3) {
                            idx33 = k3 * ido + idx13;
                            int oidx12 = idx5 + idx33;
                            iidx1 = idx43 + idx33;
                            float i1i = in[iidx1 - 1];
                            float i1r = in[iidx1];
                            out[oidx12 - 1] = w1r * i1i + w1i * i1r;
                            out[oidx12] = w1r * i1r - w1i * i1i;
                        }
                    }
                }
            } else {
                is = -ido;
                for (j4 = 1; j4 < ip; ++j4) {
                    is += ido;
                    idx13 = j4 * l1 * ido;
                    for (k4 = 0; k4 < l1; ++k4) {
                        idij = is - 1;
                        int idx34 = k4 * ido + idx13;
                        for (i3 = 2; i3 < ido; i3 += 2) {
                            int idx24 = (idij += 2) + iw1;
                            w1r = this.wtable_r[idx24 - 1];
                            w1i = this.wtable_r[idx24];
                            oidx1 = out_off + i3 + idx34;
                            int iidx12 = in_off + i3 + idx34;
                            float i1i = in[iidx12 - 1];
                            float i1r = in[iidx12];
                            out[oidx1 - 1] = w1r * i1i + w1i * i1r;
                            out[oidx1] = w1r * i1r - w1i * i1i;
                        }
                    }
                }
            }
            if (nbd >= l1) {
                for (j4 = 1; j4 < ipph; ++j4) {
                    jc = ip - j4;
                    idx13 = j4 * l1 * ido;
                    idx22 = jc * l1 * ido;
                    for (k2 = 0; k2 < l1; ++k2) {
                        idx32 = k2 * ido + idx13;
                        idx42 = k2 * ido + idx22;
                        for (i2 = 2; i2 < ido; i2 += 2) {
                            int idx5 = in_off + i2;
                            int idx6 = out_off + i2;
                            iidx1 = idx5 + idx32;
                            int iidx2 = idx5 + idx42;
                            int oidx13 = idx6 + idx32;
                            oidx2 = idx6 + idx42;
                            o1i = out[oidx13 - 1];
                            o1r = out[oidx13];
                            o2i = out[oidx2 - 1];
                            o2r = out[oidx2];
                            in[iidx1 - 1] = o1i + o2i;
                            in[iidx1] = o1r + o2r;
                            in[iidx2 - 1] = o1r - o2r;
                            in[iidx2] = o2i - o1i;
                        }
                    }
                }
            } else {
                for (j4 = 1; j4 < ipph; ++j4) {
                    jc = ip - j4;
                    idx13 = j4 * l1 * ido;
                    idx22 = jc * l1 * ido;
                    for (int i5 = 2; i5 < ido; i5 += 2) {
                        int idx5 = in_off + i5;
                        int idx6 = out_off + i5;
                        for (k3 = 0; k3 < l1; ++k3) {
                            idx33 = k3 * ido + idx13;
                            int idx44 = k3 * ido + idx22;
                            iidx1 = idx5 + idx33;
                            int iidx2 = idx5 + idx44;
                            int oidx14 = idx6 + idx33;
                            oidx2 = idx6 + idx44;
                            o1i = out[oidx14 - 1];
                            o1r = out[oidx14];
                            o2i = out[oidx2 - 1];
                            o2r = out[oidx2];
                            in[iidx1 - 1] = o1i + o2i;
                            in[iidx1] = o1r + o2r;
                            in[iidx2 - 1] = o1r - o2r;
                            in[iidx2] = o2i - o1i;
                        }
                    }
                }
            }
        } else {
            System.arraycopy(out, out_off, in, in_off, idl1);
        }
        for (j4 = 1; j4 < ipph; ++j4) {
            jc = ip - j4;
            idx13 = j4 * l1 * ido;
            idx22 = jc * l1 * ido;
            for (k2 = 0; k2 < l1; ++k2) {
                idx32 = k2 * ido + idx13;
                idx42 = k2 * ido + idx22;
                oidx1 = out_off + idx32;
                int oidx2 = out_off + idx42;
                float o1r = out[oidx1];
                float o2r = out[oidx2];
                in[in_off + idx32] = o1r + o2r;
                in[in_off + idx42] = o2r - o1r;
            }
        }
        float ar1 = 1.0f;
        float ai1 = 0.0f;
        int idx0 = (ip - 1) * idl1;
        for (int l2 = 1; l2 < ipph; ++l2) {
            int idx45;
            int lc = ip - l2;
            float ar1h = dcp * ar1 - dsp * ai1;
            ai1 = dcp * ai1 + dsp * ar1;
            ar1 = ar1h;
            idx12 = l2 * idl1;
            idx23 = lc * idl1;
            for (int ik = 0; ik < idl1; ++ik) {
                idx3 = out_off + ik;
                idx45 = in_off + ik;
                out[idx3 + idx12] = in[idx45] + ar1 * in[idx45 + idl1];
                out[idx3 + idx23] = ai1 * in[idx45 + idx0];
            }
            float dc2 = ar1;
            float ds2 = ai1;
            float ar2 = ar1;
            float ai2 = ai1;
            for (int j5 = 2; j5 < ipph; ++j5) {
                jc = ip - j5;
                float ar2h = dc2 * ar2 - ds2 * ai2;
                ai2 = dc2 * ai2 + ds2 * ar2;
                ar2 = ar2h;
                idx3 = j5 * idl1;
                idx45 = jc * idl1;
                for (int ik = 0; ik < idl1; ++ik) {
                    int idx5 = out_off + ik;
                    int idx6 = in_off + ik;
                    int n2 = idx5 + idx12;
                    out[n2] = out[n2] + ar2 * in[idx6 + idx3];
                    int n3 = idx5 + idx23;
                    out[n3] = out[n3] + ai2 * in[idx6 + idx45];
                }
            }
        }
        for (int j6 = 1; j6 < ipph; ++j6) {
            idx12 = j6 * idl1;
            for (int ik = 0; ik < idl1; ++ik) {
                int n4 = out_off + ik;
                out[n4] = out[n4] + in[in_off + ik + idx12];
            }
        }
        if (ido >= l1) {
            for (int k5 = 0; k5 < l1; ++k5) {
                idx12 = k5 * ido;
                idx23 = idx12 * ip;
                for (i3 = 0; i3 < ido; ++i3) {
                    in[in_off + i3 + idx23] = out[out_off + i3 + idx12];
                }
            }
        } else {
            for (int i6 = 0; i6 < ido; ++i6) {
                for (k4 = 0; k4 < l1; ++k4) {
                    idx1 = k4 * ido;
                    in[in_off + i6 + idx1 * ip] = out[out_off + i6 + idx1];
                }
            }
        }
        int idx01 = ip * ido;
        for (j3 = 1; j3 < ipph; ++j3) {
            jc = ip - j3;
            j2 = 2 * j3;
            idx1 = j3 * l1 * ido;
            idx2 = jc * l1 * ido;
            idx3 = j2 * ido;
            for (k3 = 0; k3 < l1; ++k3) {
                idx4 = k3 * ido;
                int idx5 = idx4 + idx1;
                int idx6 = idx4 + idx2;
                int idx7 = k3 * idx01;
                in[in_off + ido - 1 + idx3 - ido + idx7] = out[out_off + idx5];
                in[in_off + idx3 + idx7] = out[out_off + idx6];
            }
        }
        if (ido == 1) {
            return;
        }
        if (nbd >= l1) {
            for (j3 = 1; j3 < ipph; ++j3) {
                jc = ip - j3;
                j2 = 2 * j3;
                idx1 = j3 * l1 * ido;
                idx2 = jc * l1 * ido;
                idx3 = j2 * ido;
                for (k3 = 0; k3 < l1; ++k3) {
                    idx4 = k3 * idx01;
                    int idx5 = k3 * ido;
                    for (int i7 = 2; i7 < ido; i7 += 2) {
                        int ic = ido - i7;
                        int idx6 = in_off + i7;
                        int idx7 = in_off + ic;
                        int idx8 = out_off + i7;
                        int iidx1 = idx6 + idx3 + idx4;
                        int iidx2 = idx7 + idx3 - ido + idx4;
                        int oidx15 = idx8 + idx5 + idx1;
                        int oidx2 = idx8 + idx5 + idx2;
                        float o1i = out[oidx15 - 1];
                        float o1r = out[oidx15];
                        float o2i = out[oidx2 - 1];
                        float o2r = out[oidx2];
                        in[iidx1 - 1] = o1i + o2i;
                        in[iidx2 - 1] = o1i - o2i;
                        in[iidx1] = o1r + o2r;
                        in[iidx2] = o2r - o1r;
                    }
                }
            }
        } else {
            for (j3 = 1; j3 < ipph; ++j3) {
                jc = ip - j3;
                j2 = 2 * j3;
                idx1 = j3 * l1 * ido;
                idx2 = jc * l1 * ido;
                idx3 = j2 * ido;
                for (i2 = 2; i2 < ido; i2 += 2) {
                    int ic = ido - i2;
                    int idx6 = in_off + i2;
                    int idx7 = in_off + ic;
                    int idx8 = out_off + i2;
                    for (int k6 = 0; k6 < l1; ++k6) {
                        int idx46 = k6 * idx01;
                        int idx5 = k6 * ido;
                        int iidx1 = idx6 + idx3 + idx46;
                        int iidx2 = idx7 + idx3 - ido + idx46;
                        int oidx16 = idx8 + idx5 + idx1;
                        int oidx2 = idx8 + idx5 + idx2;
                        float o1i = out[oidx16 - 1];
                        float o1r = out[oidx16];
                        float o2i = out[oidx2 - 1];
                        float o2r = out[oidx2];
                        in[iidx1 - 1] = o1i + o2i;
                        in[iidx2 - 1] = o1i - o2i;
                        in[iidx1] = o1r + o2r;
                        in[iidx2] = o2r - o1r;
                    }
                }
            }
        }
    }

    void radfg(long ido, long ip, long l1, long idl1, FloatLargeArray in, long in_off, FloatLargeArray out, long out_off, long offset) {
        long idx4;
        long idx2;
        long j2;
        long j3;
        long idx1;
        long idx6;
        long idx3;
        long idx12;
        long i2;
        long idx42;
        long idx32;
        long k2;
        long idx22;
        long jc;
        long oidx1;
        long i3;
        long k3;
        long idx23;
        long k4;
        long idx13;
        long j4;
        long iw1 = offset;
        float arg = (float)Math.PI * 2 / (float)ip;
        float dcp = (float)FastMath.cos((double)arg);
        float dsp = (float)FastMath.sin((double)arg);
        long ipph = (ip + 1L) / 2L;
        long nbd = (ido - 1L) / 2L;
        if (ido != 1L) {
            float o2r;
            float o2i;
            float o1r;
            float o1i;
            long oidx2;
            long oidx12;
            long iidx1;
            long idx33;
            float w1i;
            float w1r;
            long idij;
            long is;
            for (long ik = 0L; ik < idl1; ++ik) {
                out.setFloat(out_off + ik, in.getFloat(in_off + ik));
            }
            for (j4 = 1L; j4 < ip; ++j4) {
                idx13 = j4 * l1 * ido;
                for (k4 = 0L; k4 < l1; ++k4) {
                    idx23 = k4 * ido + idx13;
                    out.setFloat(out_off + idx23, in.getFloat(in_off + idx23));
                }
            }
            if (nbd <= l1) {
                is = -ido;
                for (j4 = 1L; j4 < ip; ++j4) {
                    idij = (is += ido) - 1L;
                    idx13 = j4 * l1 * ido;
                    for (long i4 = 2L; i4 < ido; i4 += 2L) {
                        idx23 = (idij += 2L) + iw1;
                        long idx43 = in_off + i4;
                        long idx5 = out_off + i4;
                        w1r = this.wtable_rl.getFloat(idx23 - 1L);
                        w1i = this.wtable_rl.getFloat(idx23);
                        for (k3 = 0L; k3 < l1; ++k3) {
                            idx33 = k3 * ido + idx13;
                            long oidx13 = idx5 + idx33;
                            iidx1 = idx43 + idx33;
                            float i1i = in.getFloat(iidx1 - 1L);
                            float i1r = in.getFloat(iidx1);
                            out.setFloat(oidx13 - 1L, w1r * i1i + w1i * i1r);
                            out.setFloat(oidx13, w1r * i1r - w1i * i1i);
                        }
                    }
                }
            } else {
                is = -ido;
                for (j4 = 1L; j4 < ip; ++j4) {
                    is += ido;
                    idx13 = j4 * l1 * ido;
                    for (k4 = 0L; k4 < l1; ++k4) {
                        idij = is - 1L;
                        long idx34 = k4 * ido + idx13;
                        for (i3 = 2L; i3 < ido; i3 += 2L) {
                            long idx24 = (idij += 2L) + iw1;
                            w1r = this.wtable_rl.getFloat(idx24 - 1L);
                            w1i = this.wtable_rl.getFloat(idx24);
                            oidx1 = out_off + i3 + idx34;
                            long iidx12 = in_off + i3 + idx34;
                            float i1i = in.getFloat(iidx12 - 1L);
                            float i1r = in.getFloat(iidx12);
                            out.setFloat(oidx1 - 1L, w1r * i1i + w1i * i1r);
                            out.setFloat(oidx1, w1r * i1r - w1i * i1i);
                        }
                    }
                }
            }
            if (nbd >= l1) {
                for (j4 = 1L; j4 < ipph; ++j4) {
                    jc = ip - j4;
                    idx13 = j4 * l1 * ido;
                    idx22 = jc * l1 * ido;
                    for (k2 = 0L; k2 < l1; ++k2) {
                        idx32 = k2 * ido + idx13;
                        idx42 = k2 * ido + idx22;
                        for (i2 = 2L; i2 < ido; i2 += 2L) {
                            long idx5 = in_off + i2;
                            long idx62 = out_off + i2;
                            iidx1 = idx5 + idx32;
                            long iidx2 = idx5 + idx42;
                            oidx12 = idx62 + idx32;
                            oidx2 = idx62 + idx42;
                            o1i = out.getFloat(oidx12 - 1L);
                            o1r = out.getFloat(oidx12);
                            o2i = out.getFloat(oidx2 - 1L);
                            o2r = out.getFloat(oidx2);
                            in.setFloat(iidx1 - 1L, o1i + o2i);
                            in.setFloat(iidx1, o1r + o2r);
                            in.setFloat(iidx2 - 1L, o1r - o2r);
                            in.setFloat(iidx2, o2i - o1i);
                        }
                    }
                }
            } else {
                for (j4 = 1L; j4 < ipph; ++j4) {
                    jc = ip - j4;
                    idx13 = j4 * l1 * ido;
                    idx22 = jc * l1 * ido;
                    for (long i5 = 2L; i5 < ido; i5 += 2L) {
                        long idx5 = in_off + i5;
                        long idx63 = out_off + i5;
                        for (k3 = 0L; k3 < l1; ++k3) {
                            idx33 = k3 * ido + idx13;
                            long idx44 = k3 * ido + idx22;
                            iidx1 = idx5 + idx33;
                            long iidx2 = idx5 + idx44;
                            oidx12 = idx63 + idx33;
                            oidx2 = idx63 + idx44;
                            o1i = out.getFloat(oidx12 - 1L);
                            o1r = out.getFloat(oidx12);
                            o2i = out.getFloat(oidx2 - 1L);
                            o2r = out.getFloat(oidx2);
                            in.setFloat(iidx1 - 1L, o1i + o2i);
                            in.setFloat(iidx1, o1r + o2r);
                            in.setFloat(iidx2 - 1L, o1r - o2r);
                            in.setFloat(iidx2, o2i - o1i);
                        }
                    }
                }
            }
        } else {
            LargeArrayUtils.arraycopy(out, out_off, in, in_off, idl1);
        }
        for (j4 = 1L; j4 < ipph; ++j4) {
            jc = ip - j4;
            idx13 = j4 * l1 * ido;
            idx22 = jc * l1 * ido;
            for (k2 = 0L; k2 < l1; ++k2) {
                idx32 = k2 * ido + idx13;
                idx42 = k2 * ido + idx22;
                oidx1 = out_off + idx32;
                long oidx2 = out_off + idx42;
                float o1r = out.getFloat(oidx1);
                float o2r = out.getFloat(oidx2);
                in.setFloat(in_off + idx32, o1r + o2r);
                in.setFloat(in_off + idx42, o2r - o1r);
            }
        }
        float ar1 = 1.0f;
        float ai1 = 0.0f;
        long idx0 = (ip - 1L) * idl1;
        for (long l2 = 1L; l2 < ipph; ++l2) {
            long idx45;
            long lc = ip - l2;
            float ar1h = dcp * ar1 - dsp * ai1;
            ai1 = dcp * ai1 + dsp * ar1;
            ar1 = ar1h;
            idx12 = l2 * idl1;
            idx23 = lc * idl1;
            for (long ik = 0L; ik < idl1; ++ik) {
                idx3 = out_off + ik;
                idx45 = in_off + ik;
                out.setFloat(idx3 + idx12, in.getFloat(idx45) + ar1 * in.getFloat(idx45 + idl1));
                out.setFloat(idx3 + idx23, ai1 * in.getFloat(idx45 + idx0));
            }
            float dc2 = ar1;
            float ds2 = ai1;
            float ar2 = ar1;
            float ai2 = ai1;
            for (long j5 = 2L; j5 < ipph; ++j5) {
                jc = ip - j5;
                float ar2h = dc2 * ar2 - ds2 * ai2;
                ai2 = dc2 * ai2 + ds2 * ar2;
                ar2 = ar2h;
                idx3 = j5 * idl1;
                idx45 = jc * idl1;
                for (long ik = 0L; ik < idl1; ++ik) {
                    long idx5 = out_off + ik;
                    idx6 = in_off + ik;
                    out.setFloat(idx5 + idx12, out.getFloat(idx5 + idx12) + ar2 * in.getFloat(idx6 + idx3));
                    out.setFloat(idx5 + idx23, out.getFloat(idx5 + idx23) + ai2 * in.getFloat(idx6 + idx45));
                }
            }
        }
        for (long j6 = 1L; j6 < ipph; ++j6) {
            idx12 = j6 * idl1;
            for (long ik = 0L; ik < idl1; ++ik) {
                out.setFloat(out_off + ik, out.getFloat(out_off + ik) + in.getFloat(in_off + ik + idx12));
            }
        }
        if (ido >= l1) {
            for (long k5 = 0L; k5 < l1; ++k5) {
                idx12 = k5 * ido;
                idx23 = idx12 * ip;
                for (i3 = 0L; i3 < ido; ++i3) {
                    in.setFloat(in_off + i3 + idx23, out.getFloat(out_off + i3 + idx12));
                }
            }
        } else {
            for (long i6 = 0L; i6 < ido; ++i6) {
                for (k4 = 0L; k4 < l1; ++k4) {
                    idx1 = k4 * ido;
                    in.setFloat(in_off + i6 + idx1 * ip, out.getFloat(out_off + i6 + idx1));
                }
            }
        }
        long idx01 = ip * ido;
        for (j3 = 1L; j3 < ipph; ++j3) {
            jc = ip - j3;
            j2 = 2L * j3;
            idx1 = j3 * l1 * ido;
            idx2 = jc * l1 * ido;
            idx3 = j2 * ido;
            for (k3 = 0L; k3 < l1; ++k3) {
                idx4 = k3 * ido;
                long idx5 = idx4 + idx1;
                idx6 = idx4 + idx2;
                long idx7 = k3 * idx01;
                in.setFloat(in_off + ido - 1L + idx3 - ido + idx7, out.getFloat(out_off + idx5));
                in.setFloat(in_off + idx3 + idx7, out.getFloat(out_off + idx6));
            }
        }
        if (ido == 1L) {
            return;
        }
        if (nbd >= l1) {
            for (j3 = 1L; j3 < ipph; ++j3) {
                jc = ip - j3;
                j2 = 2L * j3;
                idx1 = j3 * l1 * ido;
                idx2 = jc * l1 * ido;
                idx3 = j2 * ido;
                for (k3 = 0L; k3 < l1; ++k3) {
                    idx4 = k3 * idx01;
                    long idx5 = k3 * ido;
                    for (long i7 = 2L; i7 < ido; i7 += 2L) {
                        long ic = ido - i7;
                        long idx64 = in_off + i7;
                        long idx7 = in_off + ic;
                        long idx8 = out_off + i7;
                        long iidx1 = idx64 + idx3 + idx4;
                        long iidx2 = idx7 + idx3 - ido + idx4;
                        long oidx14 = idx8 + idx5 + idx1;
                        long oidx2 = idx8 + idx5 + idx2;
                        float o1i = out.getFloat(oidx14 - 1L);
                        float o1r = out.getFloat(oidx14);
                        float o2i = out.getFloat(oidx2 - 1L);
                        float o2r = out.getFloat(oidx2);
                        in.setFloat(iidx1 - 1L, o1i + o2i);
                        in.setFloat(iidx2 - 1L, o1i - o2i);
                        in.setFloat(iidx1, o1r + o2r);
                        in.setFloat(iidx2, o2r - o1r);
                    }
                }
            }
        } else {
            for (j3 = 1L; j3 < ipph; ++j3) {
                jc = ip - j3;
                j2 = 2L * j3;
                idx1 = j3 * l1 * ido;
                idx2 = jc * l1 * ido;
                idx3 = j2 * ido;
                for (i2 = 2L; i2 < ido; i2 += 2L) {
                    long ic = ido - i2;
                    long idx65 = in_off + i2;
                    long idx7 = in_off + ic;
                    long idx8 = out_off + i2;
                    for (long k6 = 0L; k6 < l1; ++k6) {
                        long idx46 = k6 * idx01;
                        long idx5 = k6 * ido;
                        long iidx1 = idx65 + idx3 + idx46;
                        long iidx2 = idx7 + idx3 - ido + idx46;
                        long oidx15 = idx8 + idx5 + idx1;
                        long oidx2 = idx8 + idx5 + idx2;
                        float o1i = out.getFloat(oidx15 - 1L);
                        float o1r = out.getFloat(oidx15);
                        float o2i = out.getFloat(oidx2 - 1L);
                        float o2r = out.getFloat(oidx2);
                        in.setFloat(iidx1 - 1L, o1i + o2i);
                        in.setFloat(iidx2 - 1L, o1i - o2i);
                        in.setFloat(iidx1, o1r + o2r);
                        in.setFloat(iidx2, o2r - o1r);
                    }
                }
            }
        }
    }

    void radbg(int ido, int ip, int l1, int idl1, float[] in, int in_off, float[] out, int out_off, int offset) {
        int k2;
        int idx3;
        int k3;
        float i2r;
        int iidx2;
        int iidx1;
        int idx5;
        int idx4;
        int idx2;
        int j2;
        int idx32;
        int idx22;
        int idx1;
        int i2;
        float i2r2;
        int iidx22;
        int iidx12;
        int idx52;
        int idx42;
        int k4;
        int idx33;
        int idx23;
        int idx12;
        int jc;
        int j3;
        int idx24;
        int idx13;
        int iw1 = offset;
        float arg = (float)Math.PI * 2 / (float)ip;
        float dcp = (float)FastMath.cos((double)arg);
        float dsp = (float)FastMath.sin((double)arg);
        int nbd = (ido - 1) / 2;
        int ipph = (ip + 1) / 2;
        int idx0 = ip * ido;
        if (ido >= l1) {
            for (int k5 = 0; k5 < l1; ++k5) {
                idx13 = k5 * ido;
                idx24 = k5 * idx0;
                for (int i3 = 0; i3 < ido; ++i3) {
                    out[out_off + i3 + idx13] = in[in_off + i3 + idx24];
                }
            }
        } else {
            for (int i4 = 0; i4 < ido; ++i4) {
                idx13 = out_off + i4;
                idx24 = in_off + i4;
                for (int k6 = 0; k6 < l1; ++k6) {
                    out[idx13 + k6 * ido] = in[idx24 + k6 * idx0];
                }
            }
        }
        int iidx0 = in_off + ido - 1;
        for (j3 = 1; j3 < ipph; ++j3) {
            jc = ip - j3;
            int j22 = 2 * j3;
            idx12 = j3 * l1 * ido;
            idx23 = jc * l1 * ido;
            idx33 = j22 * ido;
            for (k4 = 0; k4 < l1; ++k4) {
                idx42 = k4 * ido;
                idx52 = idx42 * ip;
                iidx12 = iidx0 + idx33 + idx52 - ido;
                iidx22 = in_off + idx33 + idx52;
                float i1r = in[iidx12];
                i2r2 = in[iidx22];
                out[out_off + idx42 + idx12] = i1r + i1r;
                out[out_off + idx42 + idx23] = i2r2 + i2r2;
            }
        }
        if (ido != 1) {
            float a2r;
            float a2i;
            float a1r;
            float a1i;
            int iidx23;
            int iidx13;
            int oidx2;
            int oidx1;
            int ic;
            if (nbd >= l1) {
                for (j3 = 1; j3 < ipph; ++j3) {
                    jc = ip - j3;
                    idx12 = j3 * l1 * ido;
                    idx23 = jc * l1 * ido;
                    idx33 = 2 * j3 * ido;
                    for (k4 = 0; k4 < l1; ++k4) {
                        idx42 = k4 * ido + idx12;
                        idx52 = k4 * ido + idx23;
                        int idx6 = k4 * ip * ido + idx33;
                        for (int i5 = 2; i5 < ido; i5 += 2) {
                            ic = ido - i5;
                            int idx7 = out_off + i5;
                            int idx8 = in_off + ic;
                            int idx9 = in_off + i5;
                            oidx1 = idx7 + idx42;
                            oidx2 = idx7 + idx52;
                            iidx13 = idx9 + idx6;
                            iidx23 = idx8 + idx6 - ido;
                            a1i = in[iidx13 - 1];
                            a1r = in[iidx13];
                            a2i = in[iidx23 - 1];
                            a2r = in[iidx23];
                            out[oidx1 - 1] = a1i + a2i;
                            out[oidx2 - 1] = a1i - a2i;
                            out[oidx1] = a1r - a2r;
                            out[oidx2] = a1r + a2r;
                        }
                    }
                }
            } else {
                for (j3 = 1; j3 < ipph; ++j3) {
                    jc = ip - j3;
                    idx12 = j3 * l1 * ido;
                    idx23 = jc * l1 * ido;
                    idx33 = 2 * j3 * ido;
                    for (i2 = 2; i2 < ido; i2 += 2) {
                        ic = ido - i2;
                        int idx7 = out_off + i2;
                        int idx8 = in_off + ic;
                        int idx9 = in_off + i2;
                        for (int k7 = 0; k7 < l1; ++k7) {
                            int idx43 = k7 * ido + idx12;
                            int idx53 = k7 * ido + idx23;
                            int idx6 = k7 * ip * ido + idx33;
                            oidx1 = idx7 + idx43;
                            oidx2 = idx7 + idx53;
                            iidx13 = idx9 + idx6;
                            iidx23 = idx8 + idx6 - ido;
                            a1i = in[iidx13 - 1];
                            a1r = in[iidx13];
                            a2i = in[iidx23 - 1];
                            a2r = in[iidx23];
                            out[oidx1 - 1] = a1i + a2i;
                            out[oidx2 - 1] = a1i - a2i;
                            out[oidx1] = a1r - a2r;
                            out[oidx2] = a1r + a2r;
                        }
                    }
                }
            }
        }
        float ar1 = 1.0f;
        float ai1 = 0.0f;
        int idx01 = (ip - 1) * idl1;
        for (int l2 = 1; l2 < ipph; ++l2) {
            int lc = ip - l2;
            float ar1h = dcp * ar1 - dsp * ai1;
            ai1 = dcp * ai1 + dsp * ar1;
            ar1 = ar1h;
            idx1 = l2 * idl1;
            idx22 = lc * idl1;
            for (int ik = 0; ik < idl1; ++ik) {
                idx32 = in_off + ik;
                int idx44 = out_off + ik;
                in[idx32 + idx1] = out[idx44] + ar1 * out[idx44 + idl1];
                in[idx32 + idx22] = ai1 * out[idx44 + idx01];
            }
            float dc2 = ar1;
            float ds2 = ai1;
            float ar2 = ar1;
            float ai2 = ai1;
            for (int j4 = 2; j4 < ipph; ++j4) {
                jc = ip - j4;
                float ar2h = dc2 * ar2 - ds2 * ai2;
                ai2 = dc2 * ai2 + ds2 * ar2;
                ar2 = ar2h;
                int idx54 = j4 * idl1;
                int idx6 = jc * idl1;
                for (int ik = 0; ik < idl1; ++ik) {
                    int idx7 = in_off + ik;
                    int idx8 = out_off + ik;
                    int n2 = idx7 + idx1;
                    in[n2] = in[n2] + ar2 * out[idx8 + idx54];
                    int n3 = idx7 + idx22;
                    in[n3] = in[n3] + ai2 * out[idx8 + idx6];
                }
            }
        }
        for (j2 = 1; j2 < ipph; ++j2) {
            idx1 = j2 * idl1;
            for (int ik = 0; ik < idl1; ++ik) {
                int n4 = idx2 = out_off + ik;
                out[n4] = out[n4] + out[idx2 + idx1];
            }
        }
        for (j2 = 1; j2 < ipph; ++j2) {
            jc = ip - j2;
            idx1 = j2 * l1 * ido;
            idx22 = jc * l1 * ido;
            for (k4 = 0; k4 < l1; ++k4) {
                idx32 = k4 * ido;
                int oidx1 = out_off + idx32;
                iidx12 = in_off + idx32 + idx1;
                iidx22 = in_off + idx32 + idx22;
                float i1r = in[iidx12];
                i2r2 = in[iidx22];
                out[oidx1 + idx1] = i1r - i2r2;
                out[oidx1 + idx22] = i1r + i2r2;
            }
        }
        if (ido == 1) {
            return;
        }
        if (nbd >= l1) {
            for (j2 = 1; j2 < ipph; ++j2) {
                jc = ip - j2;
                idx1 = j2 * l1 * ido;
                idx22 = jc * l1 * ido;
                for (k4 = 0; k4 < l1; ++k4) {
                    idx32 = k4 * ido;
                    for (int i6 = 2; i6 < ido; i6 += 2) {
                        idx4 = out_off + i6;
                        idx5 = in_off + i6;
                        int oidx1 = idx4 + idx32 + idx1;
                        int oidx2 = idx4 + idx32 + idx22;
                        iidx1 = idx5 + idx32 + idx1;
                        iidx2 = idx5 + idx32 + idx22;
                        float i1i = in[iidx1 - 1];
                        float i1r = in[iidx1];
                        float i2i = in[iidx2 - 1];
                        i2r = in[iidx2];
                        out[oidx1 - 1] = i1i - i2r;
                        out[oidx2 - 1] = i1i + i2r;
                        out[oidx1] = i1r + i2i;
                        out[oidx2] = i1r - i2i;
                    }
                }
            }
        } else {
            for (j2 = 1; j2 < ipph; ++j2) {
                jc = ip - j2;
                idx1 = j2 * l1 * ido;
                idx22 = jc * l1 * ido;
                for (i2 = 2; i2 < ido; i2 += 2) {
                    idx42 = out_off + i2;
                    idx52 = in_off + i2;
                    for (k3 = 0; k3 < l1; ++k3) {
                        idx3 = k3 * ido;
                        int oidx1 = idx42 + idx3 + idx1;
                        int oidx2 = idx42 + idx3 + idx22;
                        iidx1 = idx52 + idx3 + idx1;
                        iidx2 = idx52 + idx3 + idx22;
                        float i1i = in[iidx1 - 1];
                        float i1r = in[iidx1];
                        float i2i = in[iidx2 - 1];
                        i2r = in[iidx2];
                        out[oidx1 - 1] = i1i - i2r;
                        out[oidx2 - 1] = i1i + i2r;
                        out[oidx1] = i1r + i2i;
                        out[oidx2] = i1r - i2i;
                    }
                }
            }
        }
        System.arraycopy(out, out_off, in, in_off, idl1);
        for (j2 = 1; j2 < ip; ++j2) {
            idx1 = j2 * l1 * ido;
            for (k2 = 0; k2 < l1; ++k2) {
                idx2 = k2 * ido + idx1;
                in[in_off + idx2] = out[out_off + idx2];
            }
        }
        if (nbd <= l1) {
            int is = -ido;
            for (j2 = 1; j2 < ip; ++j2) {
                int idij = (is += ido) - 1;
                idx1 = j2 * l1 * ido;
                for (int i7 = 2; i7 < ido; i7 += 2) {
                    idx2 = (idij += 2) + iw1;
                    float w1r = this.wtable_r[idx2 - 1];
                    float w1i = this.wtable_r[idx2];
                    idx42 = in_off + i7;
                    idx52 = out_off + i7;
                    for (k3 = 0; k3 < l1; ++k3) {
                        idx3 = k3 * ido + idx1;
                        int iidx14 = idx42 + idx3;
                        int oidx1 = idx52 + idx3;
                        float o1i = out[oidx1 - 1];
                        float o1r = out[oidx1];
                        in[iidx14 - 1] = w1r * o1i - w1i * o1r;
                        in[iidx14] = w1r * o1r + w1i * o1i;
                    }
                }
            }
        } else {
            int is = -ido;
            for (j2 = 1; j2 < ip; ++j2) {
                is += ido;
                idx1 = j2 * l1 * ido;
                for (k2 = 0; k2 < l1; ++k2) {
                    int idij = is - 1;
                    int idx34 = k2 * ido + idx1;
                    for (int i8 = 2; i8 < ido; i8 += 2) {
                        int idx25 = (idij += 2) + iw1;
                        float w1r = this.wtable_r[idx25 - 1];
                        float w1i = this.wtable_r[idx25];
                        idx4 = in_off + i8;
                        idx5 = out_off + i8;
                        int iidx15 = idx4 + idx34;
                        int oidx1 = idx5 + idx34;
                        float o1i = out[oidx1 - 1];
                        float o1r = out[oidx1];
                        in[iidx15 - 1] = w1r * o1i - w1i * o1r;
                        in[iidx15] = w1r * o1r + w1i * o1i;
                    }
                }
            }
        }
    }

    void radbg(long ido, long ip, long l1, long idl1, FloatLargeArray in, long in_off, FloatLargeArray out, long out_off, long offset) {
        long oidx1;
        long k2;
        long idx3;
        long k3;
        float i2r;
        float i1r;
        long iidx2;
        long iidx1;
        long oidx2;
        long idx5;
        long idx4;
        long idx2;
        long j2;
        long idx32;
        long idx22;
        long idx1;
        long i2;
        float i2r2;
        long iidx22;
        long iidx12;
        long idx52;
        long idx42;
        long k4;
        long idx33;
        long idx23;
        long idx12;
        long jc;
        long j3;
        long idx24;
        long idx13;
        long iw1 = offset;
        float arg = (float)Math.PI * 2 / (float)ip;
        float dcp = (float)FastMath.cos((double)arg);
        float dsp = (float)FastMath.sin((double)arg);
        long nbd = (ido - 1L) / 2L;
        long ipph = (ip + 1L) / 2L;
        long idx0 = ip * ido;
        if (ido >= l1) {
            for (long k5 = 0L; k5 < l1; ++k5) {
                idx13 = k5 * ido;
                idx24 = k5 * idx0;
                for (long i3 = 0L; i3 < ido; ++i3) {
                    out.setFloat(out_off + i3 + idx13, in.getFloat(in_off + i3 + idx24));
                }
            }
        } else {
            for (long i4 = 0L; i4 < ido; ++i4) {
                idx13 = out_off + i4;
                idx24 = in_off + i4;
                for (long k6 = 0L; k6 < l1; ++k6) {
                    out.setFloat(idx13 + k6 * ido, in.getFloat(idx24 + k6 * idx0));
                }
            }
        }
        long iidx0 = in_off + ido - 1L;
        for (j3 = 1L; j3 < ipph; ++j3) {
            jc = ip - j3;
            long j22 = 2L * j3;
            idx12 = j3 * l1 * ido;
            idx23 = jc * l1 * ido;
            idx33 = j22 * ido;
            for (k4 = 0L; k4 < l1; ++k4) {
                idx42 = k4 * ido;
                idx52 = idx42 * ip;
                iidx12 = iidx0 + idx33 + idx52 - ido;
                iidx22 = in_off + idx33 + idx52;
                float i1r2 = in.getFloat(iidx12);
                i2r2 = in.getFloat(iidx22);
                out.setFloat(out_off + idx42 + idx12, i1r2 + i1r2);
                out.setFloat(out_off + idx42 + idx23, i2r2 + i2r2);
            }
        }
        if (ido != 1L) {
            float a2r;
            float a2i;
            float a1r;
            float a1i;
            long iidx23;
            long iidx13;
            long oidx22;
            long oidx12;
            long ic;
            if (nbd >= l1) {
                for (j3 = 1L; j3 < ipph; ++j3) {
                    jc = ip - j3;
                    idx12 = j3 * l1 * ido;
                    idx23 = jc * l1 * ido;
                    idx33 = 2L * j3 * ido;
                    for (k4 = 0L; k4 < l1; ++k4) {
                        idx42 = k4 * ido + idx12;
                        idx52 = k4 * ido + idx23;
                        long idx6 = k4 * ip * ido + idx33;
                        for (long i5 = 2L; i5 < ido; i5 += 2L) {
                            ic = ido - i5;
                            long idx7 = out_off + i5;
                            long idx8 = in_off + ic;
                            long idx9 = in_off + i5;
                            oidx12 = idx7 + idx42;
                            oidx22 = idx7 + idx52;
                            iidx13 = idx9 + idx6;
                            iidx23 = idx8 + idx6 - ido;
                            a1i = in.getFloat(iidx13 - 1L);
                            a1r = in.getFloat(iidx13);
                            a2i = in.getFloat(iidx23 - 1L);
                            a2r = in.getFloat(iidx23);
                            out.setFloat(oidx12 - 1L, a1i + a2i);
                            out.setFloat(oidx22 - 1L, a1i - a2i);
                            out.setFloat(oidx12, a1r - a2r);
                            out.setFloat(oidx22, a1r + a2r);
                        }
                    }
                }
            } else {
                for (j3 = 1L; j3 < ipph; ++j3) {
                    jc = ip - j3;
                    idx12 = j3 * l1 * ido;
                    idx23 = jc * l1 * ido;
                    idx33 = 2L * j3 * ido;
                    for (i2 = 2L; i2 < ido; i2 += 2L) {
                        ic = ido - i2;
                        long idx7 = out_off + i2;
                        long idx8 = in_off + ic;
                        long idx9 = in_off + i2;
                        for (long k7 = 0L; k7 < l1; ++k7) {
                            long idx43 = k7 * ido + idx12;
                            long idx53 = k7 * ido + idx23;
                            long idx6 = k7 * ip * ido + idx33;
                            oidx12 = idx7 + idx43;
                            oidx22 = idx7 + idx53;
                            iidx13 = idx9 + idx6;
                            iidx23 = idx8 + idx6 - ido;
                            a1i = in.getFloat(iidx13 - 1L);
                            a1r = in.getFloat(iidx13);
                            a2i = in.getFloat(iidx23 - 1L);
                            a2r = in.getFloat(iidx23);
                            out.setFloat(oidx12 - 1L, a1i + a2i);
                            out.setFloat(oidx22 - 1L, a1i - a2i);
                            out.setFloat(oidx12, a1r - a2r);
                            out.setFloat(oidx22, a1r + a2r);
                        }
                    }
                }
            }
        }
        float ar1 = 1.0f;
        float ai1 = 0.0f;
        long idx01 = (ip - 1L) * idl1;
        for (long l2 = 1L; l2 < ipph; ++l2) {
            long lc = ip - l2;
            float ar1h = dcp * ar1 - dsp * ai1;
            ai1 = dcp * ai1 + dsp * ar1;
            ar1 = ar1h;
            idx1 = l2 * idl1;
            idx22 = lc * idl1;
            for (long ik = 0L; ik < idl1; ++ik) {
                idx32 = in_off + ik;
                long idx44 = out_off + ik;
                in.setFloat(idx32 + idx1, out.getFloat(idx44) + ar1 * out.getFloat(idx44 + idl1));
                in.setFloat(idx32 + idx22, ai1 * out.getFloat(idx44 + idx01));
            }
            float dc2 = ar1;
            float ds2 = ai1;
            float ar2 = ar1;
            float ai2 = ai1;
            for (long j4 = 2L; j4 < ipph; ++j4) {
                jc = ip - j4;
                float ar2h = dc2 * ar2 - ds2 * ai2;
                ai2 = dc2 * ai2 + ds2 * ar2;
                ar2 = ar2h;
                long idx54 = j4 * idl1;
                long idx6 = jc * idl1;
                for (long ik = 0L; ik < idl1; ++ik) {
                    long idx7 = in_off + ik;
                    long idx8 = out_off + ik;
                    in.setFloat(idx7 + idx1, in.getFloat(idx7 + idx1) + ar2 * out.getFloat(idx8 + idx54));
                    in.setFloat(idx7 + idx22, in.getFloat(idx7 + idx22) + ai2 * out.getFloat(idx8 + idx6));
                }
            }
        }
        for (j2 = 1L; j2 < ipph; ++j2) {
            idx1 = j2 * idl1;
            for (long ik = 0L; ik < idl1; ++ik) {
                idx2 = out_off + ik;
                out.setFloat(idx2, out.getFloat(idx2) + out.getFloat(idx2 + idx1));
            }
        }
        for (j2 = 1L; j2 < ipph; ++j2) {
            jc = ip - j2;
            idx1 = j2 * l1 * ido;
            idx22 = jc * l1 * ido;
            for (k4 = 0L; k4 < l1; ++k4) {
                idx32 = k4 * ido;
                long oidx13 = out_off + idx32;
                iidx12 = in_off + idx32 + idx1;
                iidx22 = in_off + idx32 + idx22;
                float i1r3 = in.getFloat(iidx12);
                i2r2 = in.getFloat(iidx22);
                out.setFloat(oidx13 + idx1, i1r3 - i2r2);
                out.setFloat(oidx13 + idx22, i1r3 + i2r2);
            }
        }
        if (ido == 1L) {
            return;
        }
        if (nbd >= l1) {
            for (j2 = 1L; j2 < ipph; ++j2) {
                jc = ip - j2;
                idx1 = j2 * l1 * ido;
                idx22 = jc * l1 * ido;
                for (k4 = 0L; k4 < l1; ++k4) {
                    idx32 = k4 * ido;
                    for (long i6 = 2L; i6 < ido; i6 += 2L) {
                        idx4 = out_off + i6;
                        idx5 = in_off + i6;
                        long oidx14 = idx4 + idx32 + idx1;
                        oidx2 = idx4 + idx32 + idx22;
                        iidx1 = idx5 + idx32 + idx1;
                        iidx2 = idx5 + idx32 + idx22;
                        float i1i = in.getFloat(iidx1 - 1L);
                        i1r = in.getFloat(iidx1);
                        float i2i = in.getFloat(iidx2 - 1L);
                        i2r = in.getFloat(iidx2);
                        out.setFloat(oidx14 - 1L, i1i - i2r);
                        out.setFloat(oidx2 - 1L, i1i + i2r);
                        out.setFloat(oidx14, i1r + i2i);
                        out.setFloat(oidx2, i1r - i2i);
                    }
                }
            }
        } else {
            for (j2 = 1L; j2 < ipph; ++j2) {
                jc = ip - j2;
                idx1 = j2 * l1 * ido;
                idx22 = jc * l1 * ido;
                for (i2 = 2L; i2 < ido; i2 += 2L) {
                    idx42 = out_off + i2;
                    idx52 = in_off + i2;
                    for (k3 = 0L; k3 < l1; ++k3) {
                        idx3 = k3 * ido;
                        long oidx15 = idx42 + idx3 + idx1;
                        oidx2 = idx42 + idx3 + idx22;
                        iidx1 = idx52 + idx3 + idx1;
                        iidx2 = idx52 + idx3 + idx22;
                        float i1i = in.getFloat(iidx1 - 1L);
                        i1r = in.getFloat(iidx1);
                        float i2i = in.getFloat(iidx2 - 1L);
                        i2r = in.getFloat(iidx2);
                        out.setFloat(oidx15 - 1L, i1i - i2r);
                        out.setFloat(oidx2 - 1L, i1i + i2r);
                        out.setFloat(oidx15, i1r + i2i);
                        out.setFloat(oidx2, i1r - i2i);
                    }
                }
            }
        }
        LargeArrayUtils.arraycopy(out, out_off, in, in_off, idl1);
        for (j2 = 1L; j2 < ip; ++j2) {
            idx1 = j2 * l1 * ido;
            for (k2 = 0L; k2 < l1; ++k2) {
                idx2 = k2 * ido + idx1;
                in.setFloat(in_off + idx2, out.getFloat(out_off + idx2));
            }
        }
        if (nbd <= l1) {
            long is = -ido;
            for (j2 = 1L; j2 < ip; ++j2) {
                long idij = (is += ido) - 1L;
                idx1 = j2 * l1 * ido;
                for (long i7 = 2L; i7 < ido; i7 += 2L) {
                    idx2 = (idij += 2L) + iw1;
                    float w1r = this.wtable_rl.getFloat(idx2 - 1L);
                    float w1i = this.wtable_rl.getFloat(idx2);
                    idx42 = in_off + i7;
                    idx52 = out_off + i7;
                    for (k3 = 0L; k3 < l1; ++k3) {
                        idx3 = k3 * ido + idx1;
                        long iidx14 = idx42 + idx3;
                        oidx1 = idx52 + idx3;
                        float o1i = out.getFloat(oidx1 - 1L);
                        float o1r = out.getFloat(oidx1);
                        in.setFloat(iidx14 - 1L, w1r * o1i - w1i * o1r);
                        in.setFloat(iidx14, w1r * o1r + w1i * o1i);
                    }
                }
            }
        } else {
            long is = -ido;
            for (j2 = 1L; j2 < ip; ++j2) {
                is += ido;
                idx1 = j2 * l1 * ido;
                for (k2 = 0L; k2 < l1; ++k2) {
                    long idij = is - 1L;
                    long idx34 = k2 * ido + idx1;
                    for (long i8 = 2L; i8 < ido; i8 += 2L) {
                        long idx25 = (idij += 2L) + iw1;
                        float w1r = this.wtable_rl.getFloat(idx25 - 1L);
                        float w1i = this.wtable_rl.getFloat(idx25);
                        idx4 = in_off + i8;
                        idx5 = out_off + i8;
                        long iidx15 = idx4 + idx34;
                        oidx1 = idx5 + idx34;
                        float o1i = out.getFloat(oidx1 - 1L);
                        float o1r = out.getFloat(oidx1);
                        in.setFloat(iidx15 - 1L, w1r * o1i - w1i * o1r);
                        in.setFloat(iidx15, w1r * o1r + w1i * o1i);
                    }
                }
            }
        }
    }

    void cfftf(float[] a2, int offa, int isign) {
        int[] nac = new int[1];
        int twon = 2 * this.n;
        float[] ch = new float[twon];
        int iw1 = twon;
        int iw2 = 4 * this.n;
        nac[0] = 0;
        int nf = (int)this.wtable[1 + iw2];
        int na = 0;
        int l1 = 1;
        int iw = iw1;
        for (int k1 = 2; k1 <= nf + 1; ++k1) {
            int ipll = (int)this.wtable[k1 + iw2];
            int l2 = ipll * l1;
            int ido = this.n / l2;
            int idot = ido + ido;
            int idl1 = idot * l1;
            switch (ipll) {
                case 4: {
                    if (na == 0) {
                        this.passf4(idot, l1, a2, offa, ch, 0, iw, isign);
                    } else {
                        this.passf4(idot, l1, ch, 0, a2, offa, iw, isign);
                    }
                    na = 1 - na;
                    break;
                }
                case 2: {
                    if (na == 0) {
                        this.passf2(idot, l1, a2, offa, ch, 0, iw, isign);
                    } else {
                        this.passf2(idot, l1, ch, 0, a2, offa, iw, isign);
                    }
                    na = 1 - na;
                    break;
                }
                case 3: {
                    if (na == 0) {
                        this.passf3(idot, l1, a2, offa, ch, 0, iw, isign);
                    } else {
                        this.passf3(idot, l1, ch, 0, a2, offa, iw, isign);
                    }
                    na = 1 - na;
                    break;
                }
                case 5: {
                    if (na == 0) {
                        this.passf5(idot, l1, a2, offa, ch, 0, iw, isign);
                    } else {
                        this.passf5(idot, l1, ch, 0, a2, offa, iw, isign);
                    }
                    na = 1 - na;
                    break;
                }
                default: {
                    if (na == 0) {
                        this.passfg(nac, idot, ipll, l1, idl1, a2, offa, ch, 0, iw, isign);
                    } else {
                        this.passfg(nac, idot, ipll, l1, idl1, ch, 0, a2, offa, iw, isign);
                    }
                    if (nac[0] == 0) break;
                    na = 1 - na;
                }
            }
            l1 = l2;
            iw += (ipll - 1) * idot;
        }
        if (na == 0) {
            return;
        }
        System.arraycopy(ch, 0, a2, offa, twon);
    }

    void cfftf(FloatLargeArray a2, long offa, int isign) {
        int[] nac = new int[1];
        long twon = 2L * this.nl;
        FloatLargeArray ch = new FloatLargeArray(twon);
        long iw1 = twon;
        long iw2 = 4L * this.nl;
        nac[0] = 0;
        long nf = (long)this.wtablel.getFloat(1L + iw2);
        long na = 0L;
        long l1 = 1L;
        long iw = iw1;
        for (long k1 = 2L; k1 <= nf + 1L; ++k1) {
            int ipll = (int)this.wtablel.getFloat(k1 + iw2);
            long l2 = (long)ipll * l1;
            long ido = this.nl / l2;
            long idot = ido + ido;
            long idl1 = idot * l1;
            switch (ipll) {
                case 4: {
                    if (na == 0L) {
                        this.passf4(idot, l1, a2, offa, ch, 0L, iw, isign);
                    } else {
                        this.passf4(idot, l1, ch, 0L, a2, offa, iw, isign);
                    }
                    na = 1L - na;
                    break;
                }
                case 2: {
                    if (na == 0L) {
                        this.passf2(idot, l1, a2, offa, ch, 0L, iw, (long)isign);
                    } else {
                        this.passf2(idot, l1, ch, 0L, a2, offa, iw, (long)isign);
                    }
                    na = 1L - na;
                    break;
                }
                case 3: {
                    if (na == 0L) {
                        this.passf3(idot, l1, a2, offa, ch, 0L, iw, (long)isign);
                    } else {
                        this.passf3(idot, l1, ch, 0L, a2, offa, iw, (long)isign);
                    }
                    na = 1L - na;
                    break;
                }
                case 5: {
                    if (na == 0L) {
                        this.passf5(idot, l1, a2, offa, ch, 0L, iw, (long)isign);
                    } else {
                        this.passf5(idot, l1, ch, 0L, a2, offa, iw, (long)isign);
                    }
                    na = 1L - na;
                    break;
                }
                default: {
                    if (na == 0L) {
                        this.passfg(nac, idot, (long)ipll, l1, idl1, a2, offa, ch, 0L, iw, (long)isign);
                    } else {
                        this.passfg(nac, idot, (long)ipll, l1, idl1, ch, 0L, a2, offa, iw, (long)isign);
                    }
                    if (nac[0] == 0) break;
                    na = 1L - na;
                }
            }
            l1 = l2;
            iw += (long)(ipll - 1) * idot;
        }
        if (na == 0L) {
            return;
        }
        LargeArrayUtils.arraycopy(ch, 0L, a2, offa, twon);
    }

    void passf2(int ido, int l1, float[] in, int in_off, float[] out, int out_off, int offset, int isign) {
        int iw1 = offset;
        int idx = ido * l1;
        if (ido <= 2) {
            for (int k2 = 0; k2 < l1; ++k2) {
                int idx0 = k2 * ido;
                int iidx1 = in_off + 2 * idx0;
                int iidx2 = iidx1 + ido;
                float a1r = in[iidx1];
                float a1i = in[iidx1 + 1];
                float a2r = in[iidx2];
                float a2i = in[iidx2 + 1];
                int oidx1 = out_off + idx0;
                int oidx2 = oidx1 + idx;
                out[oidx1] = a1r + a2r;
                out[oidx1 + 1] = a1i + a2i;
                out[oidx2] = a1r - a2r;
                out[oidx2 + 1] = a1i - a2i;
            }
        } else {
            for (int k3 = 0; k3 < l1; ++k3) {
                for (int i2 = 0; i2 < ido - 1; i2 += 2) {
                    int idx0 = k3 * ido;
                    int iidx1 = in_off + i2 + 2 * idx0;
                    int iidx2 = iidx1 + ido;
                    float i1r = in[iidx1];
                    float i1i = in[iidx1 + 1];
                    float i2r = in[iidx2];
                    float i2i = in[iidx2 + 1];
                    int widx1 = i2 + iw1;
                    float w1r = this.wtable[widx1];
                    float w1i = (float)isign * this.wtable[widx1 + 1];
                    float t1r = i1r - i2r;
                    float t1i = i1i - i2i;
                    int oidx1 = out_off + i2 + idx0;
                    int oidx2 = oidx1 + idx;
                    out[oidx1] = i1r + i2r;
                    out[oidx1 + 1] = i1i + i2i;
                    out[oidx2] = w1r * t1r - w1i * t1i;
                    out[oidx2 + 1] = w1r * t1i + w1i * t1r;
                }
            }
        }
    }

    void passf2(long ido, long l1, FloatLargeArray in, long in_off, FloatLargeArray out, long out_off, long offset, long isign) {
        long iw1 = offset;
        long idx = ido * l1;
        if (ido <= 2L) {
            for (long k2 = 0L; k2 < l1; ++k2) {
                long idx0 = k2 * ido;
                long iidx1 = in_off + 2L * idx0;
                long iidx2 = iidx1 + ido;
                float a1r = in.getFloat(iidx1);
                float a1i = in.getFloat(iidx1 + 1L);
                float a2r = in.getFloat(iidx2);
                float a2i = in.getFloat(iidx2 + 1L);
                long oidx1 = out_off + idx0;
                long oidx2 = oidx1 + idx;
                out.setFloat(oidx1, a1r + a2r);
                out.setFloat(oidx1 + 1L, a1i + a2i);
                out.setFloat(oidx2, a1r - a2r);
                out.setFloat(oidx2 + 1L, a1i - a2i);
            }
        } else {
            for (long k3 = 0L; k3 < l1; ++k3) {
                for (long i2 = 0L; i2 < ido - 1L; i2 += 2L) {
                    long idx0 = k3 * ido;
                    long iidx1 = in_off + i2 + 2L * idx0;
                    long iidx2 = iidx1 + ido;
                    float i1r = in.getFloat(iidx1);
                    float i1i = in.getFloat(iidx1 + 1L);
                    float i2r = in.getFloat(iidx2);
                    float i2i = in.getFloat(iidx2 + 1L);
                    long widx1 = i2 + iw1;
                    float w1r = this.wtablel.getFloat(widx1);
                    float w1i = (float)isign * this.wtablel.getFloat(widx1 + 1L);
                    float t1r = i1r - i2r;
                    float t1i = i1i - i2i;
                    long oidx1 = out_off + i2 + idx0;
                    long oidx2 = oidx1 + idx;
                    out.setFloat(oidx1, i1r + i2r);
                    out.setFloat(oidx1 + 1L, i1i + i2i);
                    out.setFloat(oidx2, w1r * t1r - w1i * t1i);
                    out.setFloat(oidx2 + 1L, w1r * t1i + w1i * t1r);
                }
            }
        }
    }

    void passf3(int ido, int l1, float[] in, int in_off, float[] out, int out_off, int offset, int isign) {
        float taur = -0.5f;
        float taui = 0.8660254f;
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int idxt = l1 * ido;
        if (ido == 2) {
            for (int k2 = 1; k2 <= l1; ++k2) {
                int iidx1 = in_off + (3 * k2 - 2) * ido;
                int iidx2 = iidx1 + ido;
                int iidx3 = iidx1 - ido;
                float i1r = in[iidx1];
                float i1i = in[iidx1 + 1];
                float i2r = in[iidx2];
                float i2i = in[iidx2 + 1];
                float i3r = in[iidx3];
                float i3i = in[iidx3 + 1];
                float tr2 = i1r + i2r;
                float cr2 = i3r + -0.5f * tr2;
                float ti2 = i1i + i2i;
                float ci2 = i3i + -0.5f * ti2;
                float cr3 = (float)isign * 0.8660254f * (i1r - i2r);
                float ci3 = (float)isign * 0.8660254f * (i1i - i2i);
                int oidx1 = out_off + (k2 - 1) * ido;
                int oidx2 = oidx1 + idxt;
                int oidx3 = oidx2 + idxt;
                out[oidx1] = in[iidx3] + tr2;
                out[oidx1 + 1] = i3i + ti2;
                out[oidx2] = cr2 - ci3;
                out[oidx2 + 1] = ci2 + cr3;
                out[oidx3] = cr2 + ci3;
                out[oidx3 + 1] = ci2 - cr3;
            }
        } else {
            for (int k3 = 1; k3 <= l1; ++k3) {
                int idx1 = in_off + (3 * k3 - 2) * ido;
                int idx2 = out_off + (k3 - 1) * ido;
                for (int i2 = 0; i2 < ido - 1; i2 += 2) {
                    int iidx1 = i2 + idx1;
                    int iidx2 = iidx1 + ido;
                    int iidx3 = iidx1 - ido;
                    float a1r = in[iidx1];
                    float a1i = in[iidx1 + 1];
                    float a2r = in[iidx2];
                    float a2i = in[iidx2 + 1];
                    float a3r = in[iidx3];
                    float a3i = in[iidx3 + 1];
                    float tr2 = a1r + a2r;
                    float cr2 = a3r + -0.5f * tr2;
                    float ti2 = a1i + a2i;
                    float ci2 = a3i + -0.5f * ti2;
                    float cr3 = (float)isign * 0.8660254f * (a1r - a2r);
                    float ci3 = (float)isign * 0.8660254f * (a1i - a2i);
                    float dr2 = cr2 - ci3;
                    float dr3 = cr2 + ci3;
                    float di2 = ci2 + cr3;
                    float di3 = ci2 - cr3;
                    int widx1 = i2 + iw1;
                    int widx2 = i2 + iw2;
                    float w1r = this.wtable[widx1];
                    float w1i = (float)isign * this.wtable[widx1 + 1];
                    float w2r = this.wtable[widx2];
                    float w2i = (float)isign * this.wtable[widx2 + 1];
                    int oidx1 = i2 + idx2;
                    int oidx2 = oidx1 + idxt;
                    int oidx3 = oidx2 + idxt;
                    out[oidx1] = a3r + tr2;
                    out[oidx1 + 1] = a3i + ti2;
                    out[oidx2] = w1r * dr2 - w1i * di2;
                    out[oidx2 + 1] = w1r * di2 + w1i * dr2;
                    out[oidx3] = w2r * dr3 - w2i * di3;
                    out[oidx3 + 1] = w2r * di3 + w2i * dr3;
                }
            }
        }
    }

    void passf3(long ido, long l1, FloatLargeArray in, long in_off, FloatLargeArray out, long out_off, long offset, long isign) {
        float taur = -0.5f;
        float taui = 0.8660254f;
        long iw1 = offset;
        long iw2 = iw1 + ido;
        long idxt = l1 * ido;
        if (ido == 2L) {
            for (long k2 = 1L; k2 <= l1; ++k2) {
                long iidx1 = in_off + (3L * k2 - 2L) * ido;
                long iidx2 = iidx1 + ido;
                long iidx3 = iidx1 - ido;
                float i1r = in.getFloat(iidx1);
                float i1i = in.getFloat(iidx1 + 1L);
                float i2r = in.getFloat(iidx2);
                float i2i = in.getFloat(iidx2 + 1L);
                float i3r = in.getFloat(iidx3);
                float i3i = in.getFloat(iidx3 + 1L);
                float tr2 = i1r + i2r;
                float cr2 = i3r + -0.5f * tr2;
                float ti2 = i1i + i2i;
                float ci2 = i3i + -0.5f * ti2;
                float cr3 = (float)isign * 0.8660254f * (i1r - i2r);
                float ci3 = (float)isign * 0.8660254f * (i1i - i2i);
                long oidx1 = out_off + (k2 - 1L) * ido;
                long oidx2 = oidx1 + idxt;
                long oidx3 = oidx2 + idxt;
                out.setFloat(oidx1, in.getFloat(iidx3) + tr2);
                out.setFloat(oidx1 + 1L, i3i + ti2);
                out.setFloat(oidx2, cr2 - ci3);
                out.setFloat(oidx2 + 1L, ci2 + cr3);
                out.setFloat(oidx3, cr2 + ci3);
                out.setFloat(oidx3 + 1L, ci2 - cr3);
            }
        } else {
            for (long k3 = 1L; k3 <= l1; ++k3) {
                long idx1 = in_off + (3L * k3 - 2L) * ido;
                long idx2 = out_off + (k3 - 1L) * ido;
                for (long i2 = 0L; i2 < ido - 1L; i2 += 2L) {
                    long iidx1 = i2 + idx1;
                    long iidx2 = iidx1 + ido;
                    long iidx3 = iidx1 - ido;
                    float a1r = in.getFloat(iidx1);
                    float a1i = in.getFloat(iidx1 + 1L);
                    float a2r = in.getFloat(iidx2);
                    float a2i = in.getFloat(iidx2 + 1L);
                    float a3r = in.getFloat(iidx3);
                    float a3i = in.getFloat(iidx3 + 1L);
                    float tr2 = a1r + a2r;
                    float cr2 = a3r + -0.5f * tr2;
                    float ti2 = a1i + a2i;
                    float ci2 = a3i + -0.5f * ti2;
                    float cr3 = (float)isign * 0.8660254f * (a1r - a2r);
                    float ci3 = (float)isign * 0.8660254f * (a1i - a2i);
                    float dr2 = cr2 - ci3;
                    float dr3 = cr2 + ci3;
                    float di2 = ci2 + cr3;
                    float di3 = ci2 - cr3;
                    long widx1 = i2 + iw1;
                    long widx2 = i2 + iw2;
                    float w1r = this.wtablel.getFloat(widx1);
                    float w1i = (float)isign * this.wtablel.getFloat(widx1 + 1L);
                    float w2r = this.wtablel.getFloat(widx2);
                    float w2i = (float)isign * this.wtablel.getFloat(widx2 + 1L);
                    long oidx1 = i2 + idx2;
                    long oidx2 = oidx1 + idxt;
                    long oidx3 = oidx2 + idxt;
                    out.setFloat(oidx1, a3r + tr2);
                    out.setFloat(oidx1 + 1L, a3i + ti2);
                    out.setFloat(oidx2, w1r * dr2 - w1i * di2);
                    out.setFloat(oidx2 + 1L, w1r * di2 + w1i * dr2);
                    out.setFloat(oidx3, w2r * dr3 - w2i * di3);
                    out.setFloat(oidx3 + 1L, w2r * di3 + w2i * dr3);
                }
            }
        }
    }

    void passf4(int ido, int l1, float[] in, int in_off, float[] out, int out_off, int offset, int isign) {
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int iw3 = iw2 + ido;
        int idx0 = l1 * ido;
        if (ido == 2) {
            for (int k2 = 0; k2 < l1; ++k2) {
                int idxt1 = k2 * ido;
                int iidx1 = in_off + 4 * idxt1 + 1;
                int iidx2 = iidx1 + ido;
                int iidx3 = iidx2 + ido;
                int iidx4 = iidx3 + ido;
                float i1i = in[iidx1 - 1];
                float i1r = in[iidx1];
                float i2i = in[iidx2 - 1];
                float i2r = in[iidx2];
                float i3i = in[iidx3 - 1];
                float i3r = in[iidx3];
                float i4i = in[iidx4 - 1];
                float i4r = in[iidx4];
                float ti1 = i1r - i3r;
                float ti2 = i1r + i3r;
                float tr4 = i4r - i2r;
                float ti3 = i2r + i4r;
                float tr1 = i1i - i3i;
                float tr2 = i1i + i3i;
                float ti4 = i2i - i4i;
                float tr3 = i2i + i4i;
                int oidx1 = out_off + idxt1;
                int oidx2 = oidx1 + idx0;
                int oidx3 = oidx2 + idx0;
                int oidx4 = oidx3 + idx0;
                out[oidx1] = tr2 + tr3;
                out[oidx1 + 1] = ti2 + ti3;
                out[oidx2] = tr1 + (float)isign * tr4;
                out[oidx2 + 1] = ti1 + (float)isign * ti4;
                out[oidx3] = tr2 - tr3;
                out[oidx3 + 1] = ti2 - ti3;
                out[oidx4] = tr1 - (float)isign * tr4;
                out[oidx4 + 1] = ti1 - (float)isign * ti4;
            }
        } else {
            for (int k3 = 0; k3 < l1; ++k3) {
                int idx1 = k3 * ido;
                int idx2 = in_off + 1 + 4 * idx1;
                for (int i2 = 0; i2 < ido - 1; i2 += 2) {
                    int iidx1 = i2 + idx2;
                    int iidx2 = iidx1 + ido;
                    int iidx3 = iidx2 + ido;
                    int iidx4 = iidx3 + ido;
                    float i1i = in[iidx1 - 1];
                    float i1r = in[iidx1];
                    float i2i = in[iidx2 - 1];
                    float i2r = in[iidx2];
                    float i3i = in[iidx3 - 1];
                    float i3r = in[iidx3];
                    float i4i = in[iidx4 - 1];
                    float i4r = in[iidx4];
                    float ti1 = i1r - i3r;
                    float ti2 = i1r + i3r;
                    float ti3 = i2r + i4r;
                    float tr4 = i4r - i2r;
                    float tr1 = i1i - i3i;
                    float tr2 = i1i + i3i;
                    float ti4 = i2i - i4i;
                    float tr3 = i2i + i4i;
                    float cr3 = tr2 - tr3;
                    float ci3 = ti2 - ti3;
                    float cr2 = tr1 + (float)isign * tr4;
                    float cr4 = tr1 - (float)isign * tr4;
                    float ci2 = ti1 + (float)isign * ti4;
                    float ci4 = ti1 - (float)isign * ti4;
                    int widx1 = i2 + iw1;
                    int widx2 = i2 + iw2;
                    int widx3 = i2 + iw3;
                    float w1r = this.wtable[widx1];
                    float w1i = (float)isign * this.wtable[widx1 + 1];
                    float w2r = this.wtable[widx2];
                    float w2i = (float)isign * this.wtable[widx2 + 1];
                    float w3r = this.wtable[widx3];
                    float w3i = (float)isign * this.wtable[widx3 + 1];
                    int oidx1 = out_off + i2 + idx1;
                    int oidx2 = oidx1 + idx0;
                    int oidx3 = oidx2 + idx0;
                    int oidx4 = oidx3 + idx0;
                    out[oidx1] = tr2 + tr3;
                    out[oidx1 + 1] = ti2 + ti3;
                    out[oidx2] = w1r * cr2 - w1i * ci2;
                    out[oidx2 + 1] = w1r * ci2 + w1i * cr2;
                    out[oidx3] = w2r * cr3 - w2i * ci3;
                    out[oidx3 + 1] = w2r * ci3 + w2i * cr3;
                    out[oidx4] = w3r * cr4 - w3i * ci4;
                    out[oidx4 + 1] = w3r * ci4 + w3i * cr4;
                }
            }
        }
    }

    void passf4(long ido, long l1, FloatLargeArray in, long in_off, FloatLargeArray out, long out_off, long offset, int isign) {
        long iw1 = offset;
        long iw2 = iw1 + ido;
        long iw3 = iw2 + ido;
        long idx0 = l1 * ido;
        if (ido == 2L) {
            for (long k2 = 0L; k2 < l1; ++k2) {
                long idxt1 = k2 * ido;
                long iidx1 = in_off + 4L * idxt1 + 1L;
                long iidx2 = iidx1 + ido;
                long iidx3 = iidx2 + ido;
                long iidx4 = iidx3 + ido;
                float i1i = in.getFloat(iidx1 - 1L);
                float i1r = in.getFloat(iidx1);
                float i2i = in.getFloat(iidx2 - 1L);
                float i2r = in.getFloat(iidx2);
                float i3i = in.getFloat(iidx3 - 1L);
                float i3r = in.getFloat(iidx3);
                float i4i = in.getFloat(iidx4 - 1L);
                float i4r = in.getFloat(iidx4);
                float ti1 = i1r - i3r;
                float ti2 = i1r + i3r;
                float tr4 = i4r - i2r;
                float ti3 = i2r + i4r;
                float tr1 = i1i - i3i;
                float tr2 = i1i + i3i;
                float ti4 = i2i - i4i;
                float tr3 = i2i + i4i;
                long oidx1 = out_off + idxt1;
                long oidx2 = oidx1 + idx0;
                long oidx3 = oidx2 + idx0;
                long oidx4 = oidx3 + idx0;
                out.setFloat(oidx1, tr2 + tr3);
                out.setFloat(oidx1 + 1L, ti2 + ti3);
                out.setFloat(oidx2, tr1 + (float)isign * tr4);
                out.setFloat(oidx2 + 1L, ti1 + (float)isign * ti4);
                out.setFloat(oidx3, tr2 - tr3);
                out.setFloat(oidx3 + 1L, ti2 - ti3);
                out.setFloat(oidx4, tr1 - (float)isign * tr4);
                out.setFloat(oidx4 + 1L, ti1 - (float)isign * ti4);
            }
        } else {
            for (long k3 = 0L; k3 < l1; ++k3) {
                long idx1 = k3 * ido;
                long idx2 = in_off + 1L + 4L * idx1;
                for (long i2 = 0L; i2 < ido - 1L; i2 += 2L) {
                    long iidx1 = i2 + idx2;
                    long iidx2 = iidx1 + ido;
                    long iidx3 = iidx2 + ido;
                    long iidx4 = iidx3 + ido;
                    float i1i = in.getFloat(iidx1 - 1L);
                    float i1r = in.getFloat(iidx1);
                    float i2i = in.getFloat(iidx2 - 1L);
                    float i2r = in.getFloat(iidx2);
                    float i3i = in.getFloat(iidx3 - 1L);
                    float i3r = in.getFloat(iidx3);
                    float i4i = in.getFloat(iidx4 - 1L);
                    float i4r = in.getFloat(iidx4);
                    float ti1 = i1r - i3r;
                    float ti2 = i1r + i3r;
                    float ti3 = i2r + i4r;
                    float tr4 = i4r - i2r;
                    float tr1 = i1i - i3i;
                    float tr2 = i1i + i3i;
                    float ti4 = i2i - i4i;
                    float tr3 = i2i + i4i;
                    float cr3 = tr2 - tr3;
                    float ci3 = ti2 - ti3;
                    float cr2 = tr1 + (float)isign * tr4;
                    float cr4 = tr1 - (float)isign * tr4;
                    float ci2 = ti1 + (float)isign * ti4;
                    float ci4 = ti1 - (float)isign * ti4;
                    long widx1 = i2 + iw1;
                    long widx2 = i2 + iw2;
                    long widx3 = i2 + iw3;
                    float w1r = this.wtablel.getFloat(widx1);
                    float w1i = (float)isign * this.wtablel.getFloat(widx1 + 1L);
                    float w2r = this.wtablel.getFloat(widx2);
                    float w2i = (float)isign * this.wtablel.getFloat(widx2 + 1L);
                    float w3r = this.wtablel.getFloat(widx3);
                    float w3i = (float)isign * this.wtablel.getFloat(widx3 + 1L);
                    long oidx1 = out_off + i2 + idx1;
                    long oidx2 = oidx1 + idx0;
                    long oidx3 = oidx2 + idx0;
                    long oidx4 = oidx3 + idx0;
                    out.setFloat(oidx1, tr2 + tr3);
                    out.setFloat(oidx1 + 1L, ti2 + ti3);
                    out.setFloat(oidx2, w1r * cr2 - w1i * ci2);
                    out.setFloat(oidx2 + 1L, w1r * ci2 + w1i * cr2);
                    out.setFloat(oidx3, w2r * cr3 - w2i * ci3);
                    out.setFloat(oidx3 + 1L, w2r * ci3 + w2i * cr3);
                    out.setFloat(oidx4, w3r * cr4 - w3i * ci4);
                    out.setFloat(oidx4 + 1L, w3r * ci4 + w3i * cr4);
                }
            }
        }
    }

    void passf5(int ido, int l1, float[] in, int in_off, float[] out, int out_off, int offset, int isign) {
        float tr11 = 0.309017f;
        float ti11 = 0.95105654f;
        float tr12 = -0.809017f;
        float ti12 = 0.58778524f;
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int iw3 = iw2 + ido;
        int iw4 = iw3 + ido;
        int idx0 = l1 * ido;
        if (ido == 2) {
            for (int k2 = 1; k2 <= l1; ++k2) {
                int iidx1 = in_off + (5 * k2 - 4) * ido + 1;
                int iidx2 = iidx1 + ido;
                int iidx3 = iidx1 - ido;
                int iidx4 = iidx2 + ido;
                int iidx5 = iidx4 + ido;
                float i1i = in[iidx1 - 1];
                float i1r = in[iidx1];
                float i2i = in[iidx2 - 1];
                float i2r = in[iidx2];
                float i3i = in[iidx3 - 1];
                float i3r = in[iidx3];
                float i4i = in[iidx4 - 1];
                float i4r = in[iidx4];
                float i5i = in[iidx5 - 1];
                float i5r = in[iidx5];
                float ti5 = i1r - i5r;
                float ti2 = i1r + i5r;
                float ti4 = i2r - i4r;
                float ti3 = i2r + i4r;
                float tr5 = i1i - i5i;
                float tr2 = i1i + i5i;
                float tr4 = i2i - i4i;
                float tr3 = i2i + i4i;
                float cr2 = i3i + 0.309017f * tr2 + -0.809017f * tr3;
                float ci2 = i3r + 0.309017f * ti2 + -0.809017f * ti3;
                float cr3 = i3i + -0.809017f * tr2 + 0.309017f * tr3;
                float ci3 = i3r + -0.809017f * ti2 + 0.309017f * ti3;
                float cr5 = (float)isign * (0.95105654f * tr5 + 0.58778524f * tr4);
                float ci5 = (float)isign * (0.95105654f * ti5 + 0.58778524f * ti4);
                float cr4 = (float)isign * (0.58778524f * tr5 - 0.95105654f * tr4);
                float ci4 = (float)isign * (0.58778524f * ti5 - 0.95105654f * ti4);
                int oidx1 = out_off + (k2 - 1) * ido;
                int oidx2 = oidx1 + idx0;
                int oidx3 = oidx2 + idx0;
                int oidx4 = oidx3 + idx0;
                int oidx5 = oidx4 + idx0;
                out[oidx1] = i3i + tr2 + tr3;
                out[oidx1 + 1] = i3r + ti2 + ti3;
                out[oidx2] = cr2 - ci5;
                out[oidx2 + 1] = ci2 + cr5;
                out[oidx3] = cr3 - ci4;
                out[oidx3 + 1] = ci3 + cr4;
                out[oidx4] = cr3 + ci4;
                out[oidx4 + 1] = ci3 - cr4;
                out[oidx5] = cr2 + ci5;
                out[oidx5 + 1] = ci2 - cr5;
            }
        } else {
            for (int k3 = 1; k3 <= l1; ++k3) {
                int idx1 = in_off + 1 + (k3 * 5 - 4) * ido;
                int idx2 = out_off + (k3 - 1) * ido;
                for (int i2 = 0; i2 < ido - 1; i2 += 2) {
                    int iidx1 = i2 + idx1;
                    int iidx2 = iidx1 + ido;
                    int iidx3 = iidx1 - ido;
                    int iidx4 = iidx2 + ido;
                    int iidx5 = iidx4 + ido;
                    float i1i = in[iidx1 - 1];
                    float i1r = in[iidx1];
                    float i2i = in[iidx2 - 1];
                    float i2r = in[iidx2];
                    float i3i = in[iidx3 - 1];
                    float i3r = in[iidx3];
                    float i4i = in[iidx4 - 1];
                    float i4r = in[iidx4];
                    float i5i = in[iidx5 - 1];
                    float i5r = in[iidx5];
                    float ti5 = i1r - i5r;
                    float ti2 = i1r + i5r;
                    float ti4 = i2r - i4r;
                    float ti3 = i2r + i4r;
                    float tr5 = i1i - i5i;
                    float tr2 = i1i + i5i;
                    float tr4 = i2i - i4i;
                    float tr3 = i2i + i4i;
                    float cr2 = i3i + 0.309017f * tr2 + -0.809017f * tr3;
                    float ci2 = i3r + 0.309017f * ti2 + -0.809017f * ti3;
                    float cr3 = i3i + -0.809017f * tr2 + 0.309017f * tr3;
                    float ci3 = i3r + -0.809017f * ti2 + 0.309017f * ti3;
                    float cr5 = (float)isign * (0.95105654f * tr5 + 0.58778524f * tr4);
                    float ci5 = (float)isign * (0.95105654f * ti5 + 0.58778524f * ti4);
                    float cr4 = (float)isign * (0.58778524f * tr5 - 0.95105654f * tr4);
                    float ci4 = (float)isign * (0.58778524f * ti5 - 0.95105654f * ti4);
                    float dr3 = cr3 - ci4;
                    float dr4 = cr3 + ci4;
                    float di3 = ci3 + cr4;
                    float di4 = ci3 - cr4;
                    float dr5 = cr2 + ci5;
                    float dr2 = cr2 - ci5;
                    float di5 = ci2 - cr5;
                    float di2 = ci2 + cr5;
                    int widx1 = i2 + iw1;
                    int widx2 = i2 + iw2;
                    int widx3 = i2 + iw3;
                    int widx4 = i2 + iw4;
                    float w1r = this.wtable[widx1];
                    float w1i = (float)isign * this.wtable[widx1 + 1];
                    float w2r = this.wtable[widx2];
                    float w2i = (float)isign * this.wtable[widx2 + 1];
                    float w3r = this.wtable[widx3];
                    float w3i = (float)isign * this.wtable[widx3 + 1];
                    float w4r = this.wtable[widx4];
                    float w4i = (float)isign * this.wtable[widx4 + 1];
                    int oidx1 = i2 + idx2;
                    int oidx2 = oidx1 + idx0;
                    int oidx3 = oidx2 + idx0;
                    int oidx4 = oidx3 + idx0;
                    int oidx5 = oidx4 + idx0;
                    out[oidx1] = i3i + tr2 + tr3;
                    out[oidx1 + 1] = i3r + ti2 + ti3;
                    out[oidx2] = w1r * dr2 - w1i * di2;
                    out[oidx2 + 1] = w1r * di2 + w1i * dr2;
                    out[oidx3] = w2r * dr3 - w2i * di3;
                    out[oidx3 + 1] = w2r * di3 + w2i * dr3;
                    out[oidx4] = w3r * dr4 - w3i * di4;
                    out[oidx4 + 1] = w3r * di4 + w3i * dr4;
                    out[oidx5] = w4r * dr5 - w4i * di5;
                    out[oidx5 + 1] = w4r * di5 + w4i * dr5;
                }
            }
        }
    }

    void passf5(long ido, long l1, FloatLargeArray in, long in_off, FloatLargeArray out, long out_off, long offset, long isign) {
        float tr11 = 0.309017f;
        float ti11 = 0.95105654f;
        float tr12 = -0.809017f;
        float ti12 = 0.58778524f;
        long iw1 = offset;
        long iw2 = iw1 + ido;
        long iw3 = iw2 + ido;
        long iw4 = iw3 + ido;
        long idx0 = l1 * ido;
        if (ido == 2L) {
            for (long k2 = 1L; k2 <= l1; ++k2) {
                long iidx1 = in_off + (5L * k2 - 4L) * ido + 1L;
                long iidx2 = iidx1 + ido;
                long iidx3 = iidx1 - ido;
                long iidx4 = iidx2 + ido;
                long iidx5 = iidx4 + ido;
                float i1i = in.getFloat(iidx1 - 1L);
                float i1r = in.getFloat(iidx1);
                float i2i = in.getFloat(iidx2 - 1L);
                float i2r = in.getFloat(iidx2);
                float i3i = in.getFloat(iidx3 - 1L);
                float i3r = in.getFloat(iidx3);
                float i4i = in.getFloat(iidx4 - 1L);
                float i4r = in.getFloat(iidx4);
                float i5i = in.getFloat(iidx5 - 1L);
                float i5r = in.getFloat(iidx5);
                float ti5 = i1r - i5r;
                float ti2 = i1r + i5r;
                float ti4 = i2r - i4r;
                float ti3 = i2r + i4r;
                float tr5 = i1i - i5i;
                float tr2 = i1i + i5i;
                float tr4 = i2i - i4i;
                float tr3 = i2i + i4i;
                float cr2 = i3i + 0.309017f * tr2 + -0.809017f * tr3;
                float ci2 = i3r + 0.309017f * ti2 + -0.809017f * ti3;
                float cr3 = i3i + -0.809017f * tr2 + 0.309017f * tr3;
                float ci3 = i3r + -0.809017f * ti2 + 0.309017f * ti3;
                float cr5 = (float)isign * (0.95105654f * tr5 + 0.58778524f * tr4);
                float ci5 = (float)isign * (0.95105654f * ti5 + 0.58778524f * ti4);
                float cr4 = (float)isign * (0.58778524f * tr5 - 0.95105654f * tr4);
                float ci4 = (float)isign * (0.58778524f * ti5 - 0.95105654f * ti4);
                long oidx1 = out_off + (k2 - 1L) * ido;
                long oidx2 = oidx1 + idx0;
                long oidx3 = oidx2 + idx0;
                long oidx4 = oidx3 + idx0;
                long oidx5 = oidx4 + idx0;
                out.setFloat(oidx1, i3i + tr2 + tr3);
                out.setFloat(oidx1 + 1L, i3r + ti2 + ti3);
                out.setFloat(oidx2, cr2 - ci5);
                out.setFloat(oidx2 + 1L, ci2 + cr5);
                out.setFloat(oidx3, cr3 - ci4);
                out.setFloat(oidx3 + 1L, ci3 + cr4);
                out.setFloat(oidx4, cr3 + ci4);
                out.setFloat(oidx4 + 1L, ci3 - cr4);
                out.setFloat(oidx5, cr2 + ci5);
                out.setFloat(oidx5 + 1L, ci2 - cr5);
            }
        } else {
            for (long k3 = 1L; k3 <= l1; ++k3) {
                long idx1 = in_off + 1L + (k3 * 5L - 4L) * ido;
                long idx2 = out_off + (k3 - 1L) * ido;
                for (long i2 = 0L; i2 < ido - 1L; i2 += 2L) {
                    long iidx1 = i2 + idx1;
                    long iidx2 = iidx1 + ido;
                    long iidx3 = iidx1 - ido;
                    long iidx4 = iidx2 + ido;
                    long iidx5 = iidx4 + ido;
                    float i1i = in.getFloat(iidx1 - 1L);
                    float i1r = in.getFloat(iidx1);
                    float i2i = in.getFloat(iidx2 - 1L);
                    float i2r = in.getFloat(iidx2);
                    float i3i = in.getFloat(iidx3 - 1L);
                    float i3r = in.getFloat(iidx3);
                    float i4i = in.getFloat(iidx4 - 1L);
                    float i4r = in.getFloat(iidx4);
                    float i5i = in.getFloat(iidx5 - 1L);
                    float i5r = in.getFloat(iidx5);
                    float ti5 = i1r - i5r;
                    float ti2 = i1r + i5r;
                    float ti4 = i2r - i4r;
                    float ti3 = i2r + i4r;
                    float tr5 = i1i - i5i;
                    float tr2 = i1i + i5i;
                    float tr4 = i2i - i4i;
                    float tr3 = i2i + i4i;
                    float cr2 = i3i + 0.309017f * tr2 + -0.809017f * tr3;
                    float ci2 = i3r + 0.309017f * ti2 + -0.809017f * ti3;
                    float cr3 = i3i + -0.809017f * tr2 + 0.309017f * tr3;
                    float ci3 = i3r + -0.809017f * ti2 + 0.309017f * ti3;
                    float cr5 = (float)isign * (0.95105654f * tr5 + 0.58778524f * tr4);
                    float ci5 = (float)isign * (0.95105654f * ti5 + 0.58778524f * ti4);
                    float cr4 = (float)isign * (0.58778524f * tr5 - 0.95105654f * tr4);
                    float ci4 = (float)isign * (0.58778524f * ti5 - 0.95105654f * ti4);
                    float dr3 = cr3 - ci4;
                    float dr4 = cr3 + ci4;
                    float di3 = ci3 + cr4;
                    float di4 = ci3 - cr4;
                    float dr5 = cr2 + ci5;
                    float dr2 = cr2 - ci5;
                    float di5 = ci2 - cr5;
                    float di2 = ci2 + cr5;
                    long widx1 = i2 + iw1;
                    long widx2 = i2 + iw2;
                    long widx3 = i2 + iw3;
                    long widx4 = i2 + iw4;
                    float w1r = this.wtablel.getFloat(widx1);
                    float w1i = (float)isign * this.wtablel.getFloat(widx1 + 1L);
                    float w2r = this.wtablel.getFloat(widx2);
                    float w2i = (float)isign * this.wtablel.getFloat(widx2 + 1L);
                    float w3r = this.wtablel.getFloat(widx3);
                    float w3i = (float)isign * this.wtablel.getFloat(widx3 + 1L);
                    float w4r = this.wtablel.getFloat(widx4);
                    float w4i = (float)isign * this.wtablel.getFloat(widx4 + 1L);
                    long oidx1 = i2 + idx2;
                    long oidx2 = oidx1 + idx0;
                    long oidx3 = oidx2 + idx0;
                    long oidx4 = oidx3 + idx0;
                    long oidx5 = oidx4 + idx0;
                    out.setFloat(oidx1, i3i + tr2 + tr3);
                    out.setFloat(oidx1 + 1L, i3r + ti2 + ti3);
                    out.setFloat(oidx2, w1r * dr2 - w1i * di2);
                    out.setFloat(oidx2 + 1L, w1r * di2 + w1i * dr2);
                    out.setFloat(oidx3, w2r * dr3 - w2i * di3);
                    out.setFloat(oidx3 + 1L, w2r * di3 + w2i * dr3);
                    out.setFloat(oidx4, w3r * dr4 - w3i * di4);
                    out.setFloat(oidx4 + 1L, w3r * di4 + w3i * dr4);
                    out.setFloat(oidx5, w4r * dr5 - w4i * di5);
                    out.setFloat(oidx5 + 1L, w4r * di5 + w4i * dr5);
                }
            }
        }
    }

    void passfg(int[] nac, int ido, int ip, int l1, int idl1, float[] in, int in_off, float[] out, int out_off, int offset, int isign) {
        int idx2;
        int k2;
        int idx1;
        int j2;
        int iidx1;
        int idx3;
        int j3;
        int ik;
        float w1i;
        float w1r;
        int idx12;
        float i2r;
        int idxt3;
        int idxt2;
        int idxt1;
        int jc;
        int j4;
        int iw1 = offset;
        int idot = ido / 2;
        int ipph = (ip + 1) / 2;
        int idp = ip * ido;
        if (ido >= l1) {
            for (j4 = 1; j4 < ipph; ++j4) {
                jc = ip - j4;
                int idx13 = j4 * ido;
                int idx22 = jc * ido;
                for (int k3 = 0; k3 < l1; ++k3) {
                    int idx32 = k3 * ido;
                    int idx4 = idx32 + idx13 * l1;
                    int idx5 = idx32 + idx22 * l1;
                    int idx6 = idx32 * ip;
                    for (int i2 = 0; i2 < ido; ++i2) {
                        int oidx1 = out_off + i2;
                        float i1r = in[in_off + i2 + idx13 + idx6];
                        float i2r2 = in[in_off + i2 + idx22 + idx6];
                        out[oidx1 + idx4] = i1r + i2r2;
                        out[oidx1 + idx5] = i1r - i2r2;
                    }
                }
            }
            for (int k4 = 0; k4 < l1; ++k4) {
                idxt1 = k4 * ido;
                idxt2 = idxt1 * ip;
                for (int i3 = 0; i3 < ido; ++i3) {
                    out[out_off + i3 + idxt1] = in[in_off + i3 + idxt2];
                }
            }
        } else {
            for (j4 = 1; j4 < ipph; ++j4) {
                jc = ip - j4;
                idxt1 = j4 * l1 * ido;
                idxt2 = jc * l1 * ido;
                idxt3 = j4 * ido;
                int idxt4 = jc * ido;
                for (int i4 = 0; i4 < ido; ++i4) {
                    for (int k5 = 0; k5 < l1; ++k5) {
                        int idx14 = k5 * ido;
                        int idx23 = idx14 * ip;
                        int idx33 = out_off + i4;
                        int idx4 = in_off + i4;
                        float i1r = in[idx4 + idxt3 + idx23];
                        i2r = in[idx4 + idxt4 + idx23];
                        out[idx33 + idx14 + idxt1] = i1r + i2r;
                        out[idx33 + idx14 + idxt2] = i1r - i2r;
                    }
                }
            }
            for (int i5 = 0; i5 < ido; ++i5) {
                for (int k6 = 0; k6 < l1; ++k6) {
                    idx12 = k6 * ido;
                    out[out_off + i5 + idx12] = in[in_off + i5 + idx12 * ip];
                }
            }
        }
        int idl = 2 - ido;
        int inc = 0;
        int idxt0 = (ip - 1) * idl1;
        for (int l2 = 1; l2 < ipph; ++l2) {
            int lc = ip - l2;
            idxt1 = l2 * idl1;
            idxt2 = lc * idl1;
            idxt3 = (idl += ido) + iw1;
            w1r = this.wtable[idxt3 - 2];
            w1i = (float)isign * this.wtable[idxt3 - 1];
            for (ik = 0; ik < idl1; ++ik) {
                int idx15 = in_off + ik;
                int idx24 = out_off + ik;
                in[idx15 + idxt1] = out[idx24] + w1r * out[idx24 + idl1];
                in[idx15 + idxt2] = w1i * out[idx24 + idxt0];
            }
            int idlj = idl;
            inc += ido;
            for (int j5 = 2; j5 < ipph; ++j5) {
                jc = ip - j5;
                if ((idlj += inc) > idp) {
                    idlj -= idp;
                }
                int idxt4 = idlj + iw1;
                float w2r = this.wtable[idxt4 - 2];
                float w2i = (float)isign * this.wtable[idxt4 - 1];
                int idxt5 = j5 * idl1;
                int idxt6 = jc * idl1;
                for (int ik2 = 0; ik2 < idl1; ++ik2) {
                    int idx16 = in_off + ik2;
                    int idx25 = out_off + ik2;
                    int n2 = idx16 + idxt1;
                    in[n2] = in[n2] + w2r * out[idx25 + idxt5];
                    int n3 = idx16 + idxt2;
                    in[n3] = in[n3] + w2i * out[idx25 + idxt6];
                }
            }
        }
        for (j3 = 1; j3 < ipph; ++j3) {
            int idxt12 = j3 * idl1;
            for (int ik3 = 0; ik3 < idl1; ++ik3) {
                int idx17;
                int n4 = idx17 = out_off + ik3;
                out[n4] = out[n4] + out[idx17 + idxt12];
            }
        }
        for (j3 = 1; j3 < ipph; ++j3) {
            jc = ip - j3;
            idx12 = j3 * idl1;
            int idx26 = jc * idl1;
            for (ik = 1; ik < idl1; ik += 2) {
                idx3 = out_off + ik;
                int idx4 = in_off + ik;
                iidx1 = idx4 + idx12;
                int iidx2 = idx4 + idx26;
                float i1i = in[iidx1 - 1];
                float i1r = in[iidx1];
                float i2i = in[iidx2 - 1];
                i2r = in[iidx2];
                int oidx1 = idx3 + idx12;
                int oidx2 = idx3 + idx26;
                out[oidx1 - 1] = i1i - i2r;
                out[oidx2 - 1] = i1i + i2r;
                out[oidx1] = i1r + i2i;
                out[oidx2] = i1r - i2i;
            }
        }
        nac[0] = 1;
        if (ido == 2) {
            return;
        }
        nac[0] = 0;
        System.arraycopy(out, out_off, in, in_off, idl1);
        int idx0 = l1 * ido;
        for (j2 = 1; j2 < ip; ++j2) {
            idx1 = j2 * idx0;
            for (k2 = 0; k2 < l1; ++k2) {
                idx2 = k2 * ido;
                int oidx1 = out_off + idx2 + idx1;
                iidx1 = in_off + idx2 + idx1;
                in[iidx1] = out[oidx1];
                in[iidx1 + 1] = out[oidx1 + 1];
            }
        }
        if (idot <= l1) {
            int idij = 0;
            for (j2 = 1; j2 < ip; ++j2) {
                idij += 2;
                idx1 = j2 * l1 * ido;
                for (int i6 = 3; i6 < ido; i6 += 2) {
                    idx2 = (idij += 2) + iw1 - 1;
                    w1r = this.wtable[idx2 - 1];
                    w1i = (float)isign * this.wtable[idx2];
                    int idx34 = in_off + i6;
                    int idx4 = out_off + i6;
                    for (int k7 = 0; k7 < l1; ++k7) {
                        int idx5 = k7 * ido + idx1;
                        int iidx12 = idx34 + idx5;
                        int oidx1 = idx4 + idx5;
                        float o1i = out[oidx1 - 1];
                        float o1r = out[oidx1];
                        in[iidx12 - 1] = w1r * o1i - w1i * o1r;
                        in[iidx12] = w1r * o1r + w1i * o1i;
                    }
                }
            }
        } else {
            int idj = 2 - ido;
            for (j2 = 1; j2 < ip; ++j2) {
                idj += ido;
                idx1 = j2 * l1 * ido;
                for (k2 = 0; k2 < l1; ++k2) {
                    int idij = idj;
                    idx3 = k2 * ido + idx1;
                    for (int i7 = 3; i7 < ido; i7 += 2) {
                        int idx27 = (idij += 2) - 1 + iw1;
                        w1r = this.wtable[idx27 - 1];
                        w1i = (float)isign * this.wtable[idx27];
                        int iidx13 = in_off + i7 + idx3;
                        int oidx1 = out_off + i7 + idx3;
                        float o1i = out[oidx1 - 1];
                        float o1r = out[oidx1];
                        in[iidx13 - 1] = w1r * o1i - w1i * o1r;
                        in[iidx13] = w1r * o1r + w1i * o1i;
                    }
                }
            }
        }
    }

    void passfg(int[] nac, long ido, long ip, long l1, long idl1, FloatLargeArray in, long in_off, FloatLargeArray out, long out_off, long offset, long isign) {
        long idx2;
        long k2;
        long idx1;
        long j2;
        long iidx1;
        long idx3;
        long j3;
        long ik;
        float w1i;
        float w1r;
        long idx12;
        long idxt3;
        long idxt2;
        long idxt1;
        float i2r;
        long jc;
        long j4;
        long iw1 = offset;
        long idot = ido / 2L;
        long ipph = (ip + 1L) / 2L;
        long idp = ip * ido;
        if (ido >= l1) {
            for (j4 = 1L; j4 < ipph; ++j4) {
                jc = ip - j4;
                long idx13 = j4 * ido;
                long idx22 = jc * ido;
                for (long k3 = 0L; k3 < l1; ++k3) {
                    long idx32 = k3 * ido;
                    long idx4 = idx32 + idx13 * l1;
                    long idx5 = idx32 + idx22 * l1;
                    long idx6 = idx32 * ip;
                    for (long i2 = 0L; i2 < ido; ++i2) {
                        long oidx1 = out_off + i2;
                        float i1r = in.getFloat(in_off + i2 + idx13 + idx6);
                        i2r = in.getFloat(in_off + i2 + idx22 + idx6);
                        out.setFloat(oidx1 + idx4, i1r + i2r);
                        out.setFloat(oidx1 + idx5, i1r - i2r);
                    }
                }
            }
            for (long k4 = 0L; k4 < l1; ++k4) {
                idxt1 = k4 * ido;
                idxt2 = idxt1 * ip;
                for (long i3 = 0L; i3 < ido; ++i3) {
                    out.setFloat(out_off + i3 + idxt1, in.getFloat(in_off + i3 + idxt2));
                }
            }
        } else {
            for (j4 = 1L; j4 < ipph; ++j4) {
                jc = ip - j4;
                idxt1 = j4 * l1 * ido;
                idxt2 = jc * l1 * ido;
                idxt3 = j4 * ido;
                long idxt4 = jc * ido;
                for (long i4 = 0L; i4 < ido; ++i4) {
                    for (long k5 = 0L; k5 < l1; ++k5) {
                        long idx14 = k5 * ido;
                        long idx23 = idx14 * ip;
                        long idx33 = out_off + i4;
                        long idx4 = in_off + i4;
                        float i1r = in.getFloat(idx4 + idxt3 + idx23);
                        float i2r2 = in.getFloat(idx4 + idxt4 + idx23);
                        out.setFloat(idx33 + idx14 + idxt1, i1r + i2r2);
                        out.setFloat(idx33 + idx14 + idxt2, i1r - i2r2);
                    }
                }
            }
            for (long i5 = 0L; i5 < ido; ++i5) {
                for (long k6 = 0L; k6 < l1; ++k6) {
                    idx12 = k6 * ido;
                    out.setFloat(out_off + i5 + idx12, in.getFloat(in_off + i5 + idx12 * ip));
                }
            }
        }
        long idl = 2L - ido;
        long inc = 0L;
        long idxt0 = (ip - 1L) * idl1;
        for (long l2 = 1L; l2 < ipph; ++l2) {
            long lc = ip - l2;
            idxt1 = l2 * idl1;
            idxt2 = lc * idl1;
            idxt3 = (idl += ido) + iw1;
            w1r = this.wtablel.getFloat(idxt3 - 2L);
            w1i = (float)isign * this.wtablel.getFloat(idxt3 - 1L);
            for (ik = 0L; ik < idl1; ++ik) {
                long idx15 = in_off + ik;
                long idx24 = out_off + ik;
                in.setFloat(idx15 + idxt1, out.getFloat(idx24) + w1r * out.getFloat(idx24 + idl1));
                in.setFloat(idx15 + idxt2, w1i * out.getFloat(idx24 + idxt0));
            }
            long idlj = idl;
            inc += ido;
            for (long j5 = 2L; j5 < ipph; ++j5) {
                jc = ip - j5;
                if ((idlj += inc) > idp) {
                    idlj -= idp;
                }
                long idxt4 = idlj + iw1;
                float w2r = this.wtablel.getFloat(idxt4 - 2L);
                float w2i = (float)isign * this.wtablel.getFloat(idxt4 - 1L);
                long idxt5 = j5 * idl1;
                long idxt6 = jc * idl1;
                for (long ik2 = 0L; ik2 < idl1; ++ik2) {
                    long idx16 = in_off + ik2;
                    long idx25 = out_off + ik2;
                    in.setFloat(idx16 + idxt1, in.getFloat(idx16 + idxt1) + w2r * out.getFloat(idx25 + idxt5));
                    in.setFloat(idx16 + idxt2, in.getFloat(idx16 + idxt2) + w2i * out.getFloat(idx25 + idxt6));
                }
            }
        }
        for (j3 = 1L; j3 < ipph; ++j3) {
            long idxt12 = j3 * idl1;
            for (long ik3 = 0L; ik3 < idl1; ++ik3) {
                long idx17 = out_off + ik3;
                out.setFloat(idx17, out.getFloat(idx17) + out.getFloat(idx17 + idxt12));
            }
        }
        for (j3 = 1L; j3 < ipph; ++j3) {
            jc = ip - j3;
            idx12 = j3 * idl1;
            long idx26 = jc * idl1;
            for (ik = 1L; ik < idl1; ik += 2L) {
                idx3 = out_off + ik;
                long idx4 = in_off + ik;
                iidx1 = idx4 + idx12;
                long iidx2 = idx4 + idx26;
                float i1i = in.getFloat(iidx1 - 1L);
                float i1r = in.getFloat(iidx1);
                float i2i = in.getFloat(iidx2 - 1L);
                i2r = in.getFloat(iidx2);
                long oidx1 = idx3 + idx12;
                long oidx2 = idx3 + idx26;
                out.setFloat(oidx1 - 1L, i1i - i2r);
                out.setFloat(oidx2 - 1L, i1i + i2r);
                out.setFloat(oidx1, i1r + i2i);
                out.setFloat(oidx2, i1r - i2i);
            }
        }
        nac[0] = 1;
        if (ido == 2L) {
            return;
        }
        nac[0] = 0;
        LargeArrayUtils.arraycopy(out, out_off, in, in_off, idl1);
        long idx0 = l1 * ido;
        for (j2 = 1L; j2 < ip; ++j2) {
            idx1 = j2 * idx0;
            for (k2 = 0L; k2 < l1; ++k2) {
                idx2 = k2 * ido;
                long oidx1 = out_off + idx2 + idx1;
                iidx1 = in_off + idx2 + idx1;
                in.setFloat(iidx1, out.getFloat(oidx1));
                in.setFloat(iidx1 + 1L, out.getFloat(oidx1 + 1L));
            }
        }
        if (idot <= l1) {
            long idij = 0L;
            for (j2 = 1L; j2 < ip; ++j2) {
                idij += 2L;
                idx1 = j2 * l1 * ido;
                for (long i6 = 3L; i6 < ido; i6 += 2L) {
                    idx2 = (idij += 2L) + iw1 - 1L;
                    w1r = this.wtablel.getFloat(idx2 - 1L);
                    w1i = (float)isign * this.wtablel.getFloat(idx2);
                    long idx34 = in_off + i6;
                    long idx4 = out_off + i6;
                    for (long k7 = 0L; k7 < l1; ++k7) {
                        long idx5 = k7 * ido + idx1;
                        long iidx12 = idx34 + idx5;
                        long oidx1 = idx4 + idx5;
                        float o1i = out.getFloat(oidx1 - 1L);
                        float o1r = out.getFloat(oidx1);
                        in.setFloat(iidx12 - 1L, w1r * o1i - w1i * o1r);
                        in.setFloat(iidx12, w1r * o1r + w1i * o1i);
                    }
                }
            }
        } else {
            long idj = 2L - ido;
            for (j2 = 1L; j2 < ip; ++j2) {
                idj += ido;
                idx1 = j2 * l1 * ido;
                for (k2 = 0L; k2 < l1; ++k2) {
                    long idij = idj;
                    idx3 = k2 * ido + idx1;
                    for (long i7 = 3L; i7 < ido; i7 += 2L) {
                        long idx27 = (idij += 2L) - 1L + iw1;
                        w1r = this.wtablel.getFloat(idx27 - 1L);
                        w1i = (float)isign * this.wtablel.getFloat(idx27);
                        long iidx13 = in_off + i7 + idx3;
                        long oidx1 = out_off + i7 + idx3;
                        float o1i = out.getFloat(oidx1 - 1L);
                        float o1r = out.getFloat(oidx1);
                        in.setFloat(iidx13 - 1L, w1r * o1i - w1i * o1r);
                        in.setFloat(iidx13, w1r * o1r + w1i * o1i);
                    }
                }
            }
        }
    }

    private static enum Plans {
        SPLIT_RADIX,
        MIXED_RADIX,
        BLUESTEIN;

    }
}

