/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.fft.FloatFFT_1D;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;

public class FloatFFT_2D {
    private int rows;
    private int columns;
    private long rowsl;
    private long columnsl;
    private FloatFFT_1D fftColumns;
    private FloatFFT_1D fftRows;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatFFT_2D(long rows, long columns) {
        if (rows <= 1L || columns <= 1L) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = (int)rows;
        this.columns = (int)columns;
        this.rowsl = rows;
        this.columnsl = columns;
        if (rows * columns >= CommonUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (CommonUtils.isPowerOf2(rows) && CommonUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
        }
        CommonUtils.setUseLargeArrays(2L * rows * columns > (long)LargeArray.getMaxSizeOf32bitArray());
        this.fftRows = new FloatFFT_1D(rows);
        this.fftColumns = rows == columns ? this.fftRows : new FloatFFT_1D(columns);
    }

    public void complexForward(final float[] a2) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            this.columns = 2 * this.columns;
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, -1, a2, true);
                this.cdft2d_subth(-1, a2, true);
            } else {
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    this.fftColumns.complexForward(a2, r2 * this.columns);
                }
                this.cdft2d_sub(-1, a2, true);
            }
            this.columns /= 2;
        } else {
            final int rowStride = 2 * this.columns;
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p2 = this.rows / nthreads;
                for (int l2 = 0; l2 < nthreads; ++l2) {
                    final int firstRow = l2 * p2;
                    final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p2;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int r2 = firstRow; r2 < lastRow; ++r2) {
                                FloatFFT_2D.this.fftColumns.complexForward(a2, r2 * rowStride);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p2 = this.columns / nthreads;
                for (int l3 = 0; l3 < nthreads; ++l3) {
                    final int firstColumn = l3 * p2;
                    final int lastColumn = l3 == nthreads - 1 ? this.columns : firstColumn + p2;
                    futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[2 * FloatFFT_2D.this.rows];
                            for (int c2 = firstColumn; c2 < lastColumn; ++c2) {
                                int idx2;
                                int idx1;
                                int r2;
                                int idx0 = 2 * c2;
                                for (r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                    idx1 = 2 * r2;
                                    idx2 = r2 * rowStride + idx0;
                                    temp[idx1] = a2[idx2];
                                    temp[idx1 + 1] = a2[idx2 + 1];
                                }
                                FloatFFT_2D.this.fftRows.complexForward(temp);
                                for (r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                    idx1 = 2 * r2;
                                    idx2 = r2 * rowStride + idx0;
                                    a2[idx2] = temp[idx1];
                                    a2[idx2 + 1] = temp[idx1 + 1];
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int r3 = 0; r3 < this.rows; ++r3) {
                    this.fftColumns.complexForward(a2, r3 * rowStride);
                }
                float[] temp = new float[2 * this.rows];
                for (int c2 = 0; c2 < this.columns; ++c2) {
                    int idx2;
                    int idx1;
                    int r4;
                    int idx0 = 2 * c2;
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        idx1 = 2 * r4;
                        idx2 = r4 * rowStride + idx0;
                        temp[idx1] = a2[idx2];
                        temp[idx1 + 1] = a2[idx2 + 1];
                    }
                    this.fftRows.complexForward(temp);
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        idx1 = 2 * r4;
                        idx2 = r4 * rowStride + idx0;
                        a2[idx2] = temp[idx1];
                        a2[idx2 + 1] = temp[idx1 + 1];
                    }
                }
            }
        }
    }

    public void complexForward(final FloatLargeArray a2) {
        if (!a2.isLarge() && !a2.isConstant()) {
            this.complexForward(a2.getData());
        } else {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (this.isPowerOfTwo) {
                this.columnsl = 2L * this.columnsl;
                if (nthreads > 1 && this.useThreads) {
                    this.xdft2d0_subth1(0L, -1, a2, true);
                    this.cdft2d_subth(-1, a2, true);
                } else {
                    int r2 = 0;
                    while ((long)r2 < this.rowsl) {
                        this.fftColumns.complexForward(a2, (long)r2 * this.columnsl);
                        ++r2;
                    }
                    this.cdft2d_sub(-1, a2, true);
                }
                this.columnsl /= 2L;
            } else {
                final long rowStride = 2L * this.columnsl;
                if (nthreads > 1 && this.useThreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                    Future[] futures = new Future[nthreads];
                    long p2 = this.rowsl / (long)nthreads;
                    for (int l2 = 0; l2 < nthreads; ++l2) {
                        final long firstRow = (long)l2 * p2;
                        final long lastRow = l2 == nthreads - 1 ? this.rowsl : firstRow + p2;
                        futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                            @Override
                            public void run() {
                                for (long r2 = firstRow; r2 < lastRow; ++r2) {
                                    FloatFFT_2D.this.fftColumns.complexForward(a2, r2 * rowStride);
                                }
                            }
                        });
                    }
                    try {
                        ConcurrencyUtils.waitForCompletion(futures);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (ExecutionException ex) {
                        Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    p2 = this.columnsl / (long)nthreads;
                    for (int l3 = 0; l3 < nthreads; ++l3) {
                        final long firstColumn = (long)l3 * p2;
                        final long lastColumn = l3 == nthreads - 1 ? this.columnsl : firstColumn + p2;
                        futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                            @Override
                            public void run() {
                                FloatLargeArray temp = new FloatLargeArray(2L * FloatFFT_2D.this.rowsl, false);
                                for (long c2 = firstColumn; c2 < lastColumn; ++c2) {
                                    long idx2;
                                    long idx1;
                                    long r2;
                                    long idx0 = 2L * c2;
                                    for (r2 = 0L; r2 < FloatFFT_2D.this.rowsl; ++r2) {
                                        idx1 = 2L * r2;
                                        idx2 = r2 * rowStride + idx0;
                                        temp.setDouble(idx1, a2.getFloat(idx2));
                                        temp.setDouble(idx1 + 1L, a2.getFloat(idx2 + 1L));
                                    }
                                    FloatFFT_2D.this.fftRows.complexForward(temp);
                                    for (r2 = 0L; r2 < FloatFFT_2D.this.rowsl; ++r2) {
                                        idx1 = 2L * r2;
                                        idx2 = r2 * rowStride + idx0;
                                        a2.setDouble(idx2, temp.getFloat(idx1));
                                        a2.setDouble(idx2 + 1L, temp.getFloat(idx1 + 1L));
                                    }
                                }
                            }
                        });
                    }
                    try {
                        ConcurrencyUtils.waitForCompletion(futures);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (ExecutionException ex) {
                        Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    for (long r3 = 0L; r3 < this.rowsl; ++r3) {
                        this.fftColumns.complexForward(a2, r3 * rowStride);
                    }
                    FloatLargeArray temp = new FloatLargeArray(2L * this.rowsl, false);
                    for (long c2 = 0L; c2 < this.columnsl; ++c2) {
                        long idx2;
                        long idx1;
                        long r4;
                        long idx0 = 2L * c2;
                        for (r4 = 0L; r4 < this.rowsl; ++r4) {
                            idx1 = 2L * r4;
                            idx2 = r4 * rowStride + idx0;
                            temp.setDouble(idx1, a2.getFloat(idx2));
                            temp.setDouble(idx1 + 1L, a2.getFloat(idx2 + 1L));
                        }
                        this.fftRows.complexForward(temp);
                        for (r4 = 0L; r4 < this.rowsl; ++r4) {
                            idx1 = 2L * r4;
                            idx2 = r4 * rowStride + idx0;
                            a2.setDouble(idx2, temp.getFloat(idx1));
                            a2.setDouble(idx2 + 1L, temp.getFloat(idx1 + 1L));
                        }
                    }
                }
            }
        }
    }

    public void complexForward(final float[][] a2) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            this.columns = 2 * this.columns;
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, -1, a2, true);
                this.cdft2d_subth(-1, a2, true);
            } else {
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    this.fftColumns.complexForward(a2[r2]);
                }
                this.cdft2d_sub(-1, a2, true);
            }
            this.columns /= 2;
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            Future[] futures = new Future[nthreads];
            int p2 = this.rows / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                final int firstRow = l2 * p2;
                final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            FloatFFT_2D.this.fftColumns.complexForward(a2[r2]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.columns / nthreads;
            for (int l3 = 0; l3 < nthreads; ++l3) {
                final int firstColumn = l3 * p2;
                final int lastColumn = l3 == nthreads - 1 ? this.columns : firstColumn + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[2 * FloatFFT_2D.this.rows];
                        for (int c2 = firstColumn; c2 < lastColumn; ++c2) {
                            int idx2;
                            int r2;
                            int idx1 = 2 * c2;
                            for (r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                idx2 = 2 * r2;
                                temp[idx2] = a2[r2][idx1];
                                temp[idx2 + 1] = a2[r2][idx1 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(temp);
                            for (r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                idx2 = 2 * r2;
                                a2[r2][idx1] = temp[idx2];
                                a2[r2][idx1 + 1] = temp[idx2 + 1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            for (int r3 = 0; r3 < this.rows; ++r3) {
                this.fftColumns.complexForward(a2[r3]);
            }
            float[] temp = new float[2 * this.rows];
            for (int c2 = 0; c2 < this.columns; ++c2) {
                int idx2;
                int r4;
                int idx1 = 2 * c2;
                for (r4 = 0; r4 < this.rows; ++r4) {
                    idx2 = 2 * r4;
                    temp[idx2] = a2[r4][idx1];
                    temp[idx2 + 1] = a2[r4][idx1 + 1];
                }
                this.fftRows.complexForward(temp);
                for (r4 = 0; r4 < this.rows; ++r4) {
                    idx2 = 2 * r4;
                    a2[r4][idx1] = temp[idx2];
                    a2[r4][idx1 + 1] = temp[idx2 + 1];
                }
            }
        }
    }

    public void complexInverse(final float[] a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            this.columns = 2 * this.columns;
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, 1, a2, scale);
                this.cdft2d_subth(1, a2, scale);
            } else {
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    this.fftColumns.complexInverse(a2, r2 * this.columns, scale);
                }
                this.cdft2d_sub(1, a2, scale);
            }
            this.columns /= 2;
        } else {
            final int rowspan = 2 * this.columns;
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p2 = this.rows / nthreads;
                for (int l2 = 0; l2 < nthreads; ++l2) {
                    final int firstRow = l2 * p2;
                    final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p2;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int r2 = firstRow; r2 < lastRow; ++r2) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a2, r2 * rowspan, scale);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p2 = this.columns / nthreads;
                for (int l3 = 0; l3 < nthreads; ++l3) {
                    final int firstColumn = l3 * p2;
                    final int lastColumn = l3 == nthreads - 1 ? this.columns : firstColumn + p2;
                    futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[2 * FloatFFT_2D.this.rows];
                            for (int c2 = firstColumn; c2 < lastColumn; ++c2) {
                                int idx3;
                                int idx2;
                                int r2;
                                int idx1 = 2 * c2;
                                for (r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                    idx2 = 2 * r2;
                                    idx3 = r2 * rowspan + idx1;
                                    temp[idx2] = a2[idx3];
                                    temp[idx2 + 1] = a2[idx3 + 1];
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(temp, scale);
                                for (r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                    idx2 = 2 * r2;
                                    idx3 = r2 * rowspan + idx1;
                                    a2[idx3] = temp[idx2];
                                    a2[idx3 + 1] = temp[idx2 + 1];
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int r3 = 0; r3 < this.rows; ++r3) {
                    this.fftColumns.complexInverse(a2, r3 * rowspan, scale);
                }
                float[] temp = new float[2 * this.rows];
                for (int c2 = 0; c2 < this.columns; ++c2) {
                    int idx3;
                    int idx2;
                    int r4;
                    int idx1 = 2 * c2;
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        idx2 = 2 * r4;
                        idx3 = r4 * rowspan + idx1;
                        temp[idx2] = a2[idx3];
                        temp[idx2 + 1] = a2[idx3 + 1];
                    }
                    this.fftRows.complexInverse(temp, scale);
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        idx2 = 2 * r4;
                        idx3 = r4 * rowspan + idx1;
                        a2[idx3] = temp[idx2];
                        a2[idx3 + 1] = temp[idx2 + 1];
                    }
                }
            }
        }
    }

    public void complexInverse(final FloatLargeArray a2, final boolean scale) {
        if (!a2.isLarge() && !a2.isConstant()) {
            this.complexInverse(a2.getData(), scale);
        } else {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (this.isPowerOfTwo) {
                this.columnsl = 2L * this.columnsl;
                if (nthreads > 1 && this.useThreads) {
                    this.xdft2d0_subth1(0L, 1, a2, scale);
                    this.cdft2d_subth(1, a2, scale);
                } else {
                    for (long r2 = 0L; r2 < this.rowsl; ++r2) {
                        this.fftColumns.complexInverse(a2, r2 * this.columnsl, scale);
                    }
                    this.cdft2d_sub(1, a2, scale);
                }
                this.columnsl /= 2L;
            } else {
                final long rowspan = 2L * this.columnsl;
                if (nthreads > 1 && this.useThreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                    Future[] futures = new Future[nthreads];
                    long p2 = this.rowsl / (long)nthreads;
                    for (int l2 = 0; l2 < nthreads; ++l2) {
                        final long firstRow = (long)l2 * p2;
                        final long lastRow = l2 == nthreads - 1 ? this.rowsl : firstRow + p2;
                        futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                            @Override
                            public void run() {
                                for (long r2 = firstRow; r2 < lastRow; ++r2) {
                                    FloatFFT_2D.this.fftColumns.complexInverse(a2, r2 * rowspan, scale);
                                }
                            }
                        });
                    }
                    try {
                        ConcurrencyUtils.waitForCompletion(futures);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (ExecutionException ex) {
                        Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    p2 = this.columnsl / (long)nthreads;
                    for (int l3 = 0; l3 < nthreads; ++l3) {
                        final long firstColumn = (long)l3 * p2;
                        final long lastColumn = l3 == nthreads - 1 ? this.columnsl : firstColumn + p2;
                        futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                            @Override
                            public void run() {
                                FloatLargeArray temp = new FloatLargeArray(2L * FloatFFT_2D.this.rowsl, false);
                                for (long c2 = firstColumn; c2 < lastColumn; ++c2) {
                                    long idx3;
                                    long idx2;
                                    long r2;
                                    long idx1 = 2L * c2;
                                    for (r2 = 0L; r2 < FloatFFT_2D.this.rowsl; ++r2) {
                                        idx2 = 2L * r2;
                                        idx3 = r2 * rowspan + idx1;
                                        temp.setDouble(idx2, a2.getFloat(idx3));
                                        temp.setDouble(idx2 + 1L, a2.getFloat(idx3 + 1L));
                                    }
                                    FloatFFT_2D.this.fftRows.complexInverse(temp, scale);
                                    for (r2 = 0L; r2 < FloatFFT_2D.this.rowsl; ++r2) {
                                        idx2 = 2L * r2;
                                        idx3 = r2 * rowspan + idx1;
                                        a2.setDouble(idx3, temp.getFloat(idx2));
                                        a2.setDouble(idx3 + 1L, temp.getFloat(idx2 + 1L));
                                    }
                                }
                            }
                        });
                    }
                    try {
                        ConcurrencyUtils.waitForCompletion(futures);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (ExecutionException ex) {
                        Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    for (long r3 = 0L; r3 < this.rowsl; ++r3) {
                        this.fftColumns.complexInverse(a2, r3 * rowspan, scale);
                    }
                    FloatLargeArray temp = new FloatLargeArray(2L * this.rowsl);
                    for (long c2 = 0L; c2 < this.columnsl; ++c2) {
                        long idx3;
                        long idx2;
                        long r4;
                        long idx1 = 2L * c2;
                        for (r4 = 0L; r4 < this.rowsl; ++r4) {
                            idx2 = 2L * r4;
                            idx3 = r4 * rowspan + idx1;
                            temp.setDouble(idx2, a2.getFloat(idx3));
                            temp.setDouble(idx2 + 1L, a2.getFloat(idx3 + 1L));
                        }
                        this.fftRows.complexInverse(temp, scale);
                        for (r4 = 0L; r4 < this.rowsl; ++r4) {
                            idx2 = 2L * r4;
                            idx3 = r4 * rowspan + idx1;
                            a2.setDouble(idx3, temp.getFloat(idx2));
                            a2.setDouble(idx3 + 1L, temp.getFloat(idx2 + 1L));
                        }
                    }
                }
            }
        }
    }

    public void complexInverse(final float[][] a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            this.columns = 2 * this.columns;
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, 1, a2, scale);
                this.cdft2d_subth(1, a2, scale);
            } else {
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    this.fftColumns.complexInverse(a2[r2], scale);
                }
                this.cdft2d_sub(1, a2, scale);
            }
            this.columns /= 2;
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            Future[] futures = new Future[nthreads];
            int p2 = this.rows / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                final int firstRow = l2 * p2;
                final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            FloatFFT_2D.this.fftColumns.complexInverse(a2[r2], scale);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.columns / nthreads;
            for (int l3 = 0; l3 < nthreads; ++l3) {
                final int firstColumn = l3 * p2;
                final int lastColumn = l3 == nthreads - 1 ? this.columns : firstColumn + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[2 * FloatFFT_2D.this.rows];
                        for (int c2 = firstColumn; c2 < lastColumn; ++c2) {
                            int idx2;
                            int r2;
                            int idx1 = 2 * c2;
                            for (r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                idx2 = 2 * r2;
                                temp[idx2] = a2[r2][idx1];
                                temp[idx2 + 1] = a2[r2][idx1 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(temp, scale);
                            for (r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                idx2 = 2 * r2;
                                a2[r2][idx1] = temp[idx2];
                                a2[r2][idx1 + 1] = temp[idx2 + 1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            for (int r3 = 0; r3 < this.rows; ++r3) {
                this.fftColumns.complexInverse(a2[r3], scale);
            }
            float[] temp = new float[2 * this.rows];
            for (int c2 = 0; c2 < this.columns; ++c2) {
                int idx2;
                int r4;
                int idx1 = 2 * c2;
                for (r4 = 0; r4 < this.rows; ++r4) {
                    idx2 = 2 * r4;
                    temp[idx2] = a2[r4][idx1];
                    temp[idx2 + 1] = a2[r4][idx1 + 1];
                }
                this.fftRows.complexInverse(temp, scale);
                for (r4 = 0; r4 < this.rows; ++r4) {
                    idx2 = 2 * r4;
                    a2[r4][idx1] = temp[idx2];
                    a2[r4][idx1 + 1] = temp[idx2 + 1];
                }
            }
        }
    }

    public void realForward(float[] a2) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.xdft2d0_subth1(1, 1, a2, true);
            this.cdft2d_subth(-1, a2, true);
            this.rdft2d_sub(1, a2);
        } else {
            for (int r2 = 0; r2 < this.rows; ++r2) {
                this.fftColumns.realForward(a2, r2 * this.columns);
            }
            this.cdft2d_sub(-1, a2, true);
            this.rdft2d_sub(1, a2);
        }
    }

    public void realForward(FloatLargeArray a2) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.xdft2d0_subth1(1L, 1, a2, true);
            this.cdft2d_subth(-1, a2, true);
            this.rdft2d_sub(1, a2);
        } else {
            for (long r2 = 0L; r2 < this.rowsl; ++r2) {
                this.fftColumns.realForward(a2, r2 * this.columnsl);
            }
            this.cdft2d_sub(-1, a2, true);
            this.rdft2d_sub(1, a2);
        }
    }

    public void realForward(float[][] a2) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.xdft2d0_subth1(1, 1, a2, true);
            this.cdft2d_subth(-1, a2, true);
            this.rdft2d_sub(1, a2);
        } else {
            for (int r2 = 0; r2 < this.rows; ++r2) {
                this.fftColumns.realForward(a2[r2]);
            }
            this.cdft2d_sub(-1, a2, true);
            this.rdft2d_sub(1, a2);
        }
    }

    public void realForwardFull(float[] a2) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(1, 1, a2, true);
                this.cdft2d_subth(-1, a2, true);
                this.rdft2d_sub(1, a2);
            } else {
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    this.fftColumns.realForward(a2, r2 * this.columns);
                }
                this.cdft2d_sub(-1, a2, true);
                this.rdft2d_sub(1, a2);
            }
            this.fillSymmetric(a2);
        } else {
            this.mixedRadixRealForwardFull(a2);
        }
    }

    public void realForwardFull(FloatLargeArray a2) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(1L, 1, a2, true);
                this.cdft2d_subth(-1, a2, true);
                this.rdft2d_sub(1, a2);
            } else {
                for (long r2 = 0L; r2 < this.rowsl; ++r2) {
                    this.fftColumns.realForward(a2, r2 * this.columnsl);
                }
                this.cdft2d_sub(-1, a2, true);
                this.rdft2d_sub(1, a2);
            }
            this.fillSymmetric(a2);
        } else {
            this.mixedRadixRealForwardFull(a2);
        }
    }

    public void realForwardFull(float[][] a2) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(1, 1, a2, true);
                this.cdft2d_subth(-1, a2, true);
                this.rdft2d_sub(1, a2);
            } else {
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    this.fftColumns.realForward(a2[r2]);
                }
                this.cdft2d_sub(-1, a2, true);
                this.rdft2d_sub(1, a2);
            }
            this.fillSymmetric(a2);
        } else {
            this.mixedRadixRealForwardFull(a2);
        }
    }

    public void realInverse(float[] a2, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.rdft2d_sub(-1, a2);
            this.cdft2d_subth(1, a2, scale);
            this.xdft2d0_subth1(1, -1, a2, scale);
        } else {
            this.rdft2d_sub(-1, a2);
            this.cdft2d_sub(1, a2, scale);
            for (int r2 = 0; r2 < this.rows; ++r2) {
                this.fftColumns.realInverse(a2, r2 * this.columns, scale);
            }
        }
    }

    public void realInverse(FloatLargeArray a2, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.rdft2d_sub(-1, a2);
            this.cdft2d_subth(1, a2, scale);
            this.xdft2d0_subth1(1L, -1, a2, scale);
        } else {
            this.rdft2d_sub(-1, a2);
            this.cdft2d_sub(1, a2, scale);
            for (long r2 = 0L; r2 < this.rowsl; ++r2) {
                this.fftColumns.realInverse(a2, r2 * this.columnsl, scale);
            }
        }
    }

    public void realInverse(float[][] a2, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.rdft2d_sub(-1, a2);
            this.cdft2d_subth(1, a2, scale);
            this.xdft2d0_subth1(1, -1, a2, scale);
        } else {
            this.rdft2d_sub(-1, a2);
            this.cdft2d_sub(1, a2, scale);
            for (int r2 = 0; r2 < this.rows; ++r2) {
                this.fftColumns.realInverse(a2[r2], scale);
            }
        }
    }

    public void realInverseFull(float[] a2, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth2(1, -1, a2, scale);
                this.cdft2d_subth(1, a2, scale);
                this.rdft2d_sub(1, a2);
            } else {
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    this.fftColumns.realInverse2(a2, r2 * this.columns, scale);
                }
                this.cdft2d_sub(1, a2, scale);
                this.rdft2d_sub(1, a2);
            }
            this.fillSymmetric(a2);
        } else {
            this.mixedRadixRealInverseFull(a2, scale);
        }
    }

    public void realInverseFull(FloatLargeArray a2, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth2(1L, -1, a2, scale);
                this.cdft2d_subth(1, a2, scale);
                this.rdft2d_sub(1, a2);
            } else {
                for (long r2 = 0L; r2 < this.rowsl; ++r2) {
                    this.fftColumns.realInverse2(a2, r2 * this.columnsl, scale);
                }
                this.cdft2d_sub(1, a2, scale);
                this.rdft2d_sub(1, a2);
            }
            this.fillSymmetric(a2);
        } else {
            this.mixedRadixRealInverseFull(a2, scale);
        }
    }

    public void realInverseFull(float[][] a2, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth2(1, -1, a2, scale);
                this.cdft2d_subth(1, a2, scale);
                this.rdft2d_sub(1, a2);
            } else {
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    this.fftColumns.realInverse2(a2[r2], 0, scale);
                }
                this.cdft2d_sub(1, a2, scale);
                this.rdft2d_sub(1, a2);
            }
            this.fillSymmetric(a2);
        } else {
            this.mixedRadixRealInverseFull(a2, scale);
        }
    }

    private void mixedRadixRealForwardFull(final float[][] a2) {
        final int n2d2 = this.columns / 2 + 1;
        final float[][] temp = new float[n2d2][2 * this.rows];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.rows >= nthreads && n2d2 - 2 >= nthreads) {
            int r2;
            int lastRow;
            int firstRow;
            Future[] futures = new Future[nthreads];
            int p2 = this.rows / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstRow = l2 * p2;
                lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i2 = firstRow; i2 < lastRow; ++i2) {
                            FloatFFT_2D.this.fftColumns.realForward(a2[i2]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int r3 = 0; r3 < this.rows; ++r3) {
                temp[0][r3] = a2[r3][0];
            }
            this.fftRows.realForwardFull(temp[0]);
            p2 = (n2d2 - 2) / nthreads;
            for (int l3 = 0; l3 < nthreads; ++l3) {
                final int firstColumn = 1 + l3 * p2;
                final int lastColumn = l3 == nthreads - 1 ? n2d2 - 1 : firstColumn + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int c2 = firstColumn; c2 < lastColumn; ++c2) {
                            int idx2 = 2 * c2;
                            for (int r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                int idx1 = 2 * r2;
                                temp[c2][idx1] = a2[r2][idx2];
                                temp[c2][idx1 + 1] = a2[r2][idx2 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(temp[c2]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.columns % 2 == 0) {
                for (r2 = 0; r2 < this.rows; ++r2) {
                    temp[n2d2 - 1][r2] = a2[r2][1];
                }
                this.fftRows.realForwardFull(temp[n2d2 - 1]);
            } else {
                for (r2 = 0; r2 < this.rows; ++r2) {
                    int idx1 = 2 * r2;
                    int idx2 = n2d2 - 1;
                    temp[idx2][idx1] = a2[r2][2 * idx2];
                    temp[idx2][idx1 + 1] = a2[r2][1];
                }
                this.fftRows.complexForward(temp[n2d2 - 1]);
            }
            p2 = this.rows / nthreads;
            for (int l4 = 0; l4 < nthreads; ++l4) {
                firstRow = l4 * p2;
                lastRow = l4 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            int idx1 = 2 * r2;
                            for (int c2 = 0; c2 < n2d2; ++c2) {
                                int idx2 = 2 * c2;
                                a2[r2][idx2] = temp[c2][idx1];
                                a2[r2][idx2 + 1] = temp[c2][idx1 + 1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l5 = 0; l5 < nthreads; ++l5) {
                firstRow = 1 + l5 * p2;
                lastRow = l5 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            int idx3 = FloatFFT_2D.this.rows - r2;
                            for (int c2 = n2d2; c2 < FloatFFT_2D.this.columns; ++c2) {
                                int idx1 = 2 * c2;
                                int idx2 = 2 * (FloatFFT_2D.this.columns - c2);
                                a2[0][idx1] = a2[0][idx2];
                                a2[0][idx1 + 1] = -a2[0][idx2 + 1];
                                a2[r2][idx1] = a2[idx3][idx2];
                                a2[r2][idx1 + 1] = -a2[idx3][idx2 + 1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int c2;
            int idx1;
            int idx12;
            int r4;
            for (r4 = 0; r4 < this.rows; ++r4) {
                this.fftColumns.realForward(a2[r4]);
            }
            for (r4 = 0; r4 < this.rows; ++r4) {
                temp[0][r4] = a2[r4][0];
            }
            this.fftRows.realForwardFull(temp[0]);
            for (int c3 = 1; c3 < n2d2 - 1; ++c3) {
                int idx2 = 2 * c3;
                for (int r5 = 0; r5 < this.rows; ++r5) {
                    idx12 = 2 * r5;
                    temp[c3][idx12] = a2[r5][idx2];
                    temp[c3][idx12 + 1] = a2[r5][idx2 + 1];
                }
                this.fftRows.complexForward(temp[c3]);
            }
            if (this.columns % 2 == 0) {
                for (r4 = 0; r4 < this.rows; ++r4) {
                    temp[n2d2 - 1][r4] = a2[r4][1];
                }
                this.fftRows.realForwardFull(temp[n2d2 - 1]);
            } else {
                for (r4 = 0; r4 < this.rows; ++r4) {
                    idx1 = 2 * r4;
                    int idx2 = n2d2 - 1;
                    temp[idx2][idx1] = a2[r4][2 * idx2];
                    temp[idx2][idx1 + 1] = a2[r4][1];
                }
                this.fftRows.complexForward(temp[n2d2 - 1]);
            }
            for (r4 = 0; r4 < this.rows; ++r4) {
                idx1 = 2 * r4;
                for (c2 = 0; c2 < n2d2; ++c2) {
                    int idx2 = 2 * c2;
                    a2[r4][idx2] = temp[c2][idx1];
                    a2[r4][idx2 + 1] = temp[c2][idx1 + 1];
                }
            }
            for (r4 = 1; r4 < this.rows; ++r4) {
                int idx3 = this.rows - r4;
                for (c2 = n2d2; c2 < this.columns; ++c2) {
                    idx12 = 2 * c2;
                    int idx2 = 2 * (this.columns - c2);
                    a2[0][idx12] = a2[0][idx2];
                    a2[0][idx12 + 1] = -a2[0][idx2 + 1];
                    a2[r4][idx12] = a2[idx3][idx2];
                    a2[r4][idx12 + 1] = -a2[idx3][idx2 + 1];
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final float[] a2) {
        final int rowStride = 2 * this.columns;
        final int n2d2 = this.columns / 2 + 1;
        final float[][] temp = new float[n2d2][2 * this.rows];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.rows >= nthreads && n2d2 - 2 >= nthreads) {
            int r2;
            int lastRow;
            int firstRow;
            Future[] futures = new Future[nthreads];
            int p2 = this.rows / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstRow = l2 * p2;
                lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i2 = firstRow; i2 < lastRow; ++i2) {
                            FloatFFT_2D.this.fftColumns.realForward(a2, i2 * FloatFFT_2D.this.columns);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int r3 = 0; r3 < this.rows; ++r3) {
                temp[0][r3] = a2[r3 * this.columns];
            }
            this.fftRows.realForwardFull(temp[0]);
            p2 = (n2d2 - 2) / nthreads;
            for (int l3 = 0; l3 < nthreads; ++l3) {
                final int firstColumn = 1 + l3 * p2;
                final int lastColumn = l3 == nthreads - 1 ? n2d2 - 1 : firstColumn + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int c2 = firstColumn; c2 < lastColumn; ++c2) {
                            int idx0 = 2 * c2;
                            for (int r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                int idx1 = 2 * r2;
                                int idx2 = r2 * FloatFFT_2D.this.columns + idx0;
                                temp[c2][idx1] = a2[idx2];
                                temp[c2][idx1 + 1] = a2[idx2 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(temp[c2]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.columns % 2 == 0) {
                for (r2 = 0; r2 < this.rows; ++r2) {
                    temp[n2d2 - 1][r2] = a2[r2 * this.columns + 1];
                }
                this.fftRows.realForwardFull(temp[n2d2 - 1]);
            } else {
                for (r2 = 0; r2 < this.rows; ++r2) {
                    int idx1 = 2 * r2;
                    int idx2 = r2 * this.columns;
                    int idx3 = n2d2 - 1;
                    temp[idx3][idx1] = a2[idx2 + 2 * idx3];
                    temp[idx3][idx1 + 1] = a2[idx2 + 1];
                }
                this.fftRows.complexForward(temp[n2d2 - 1]);
            }
            p2 = this.rows / nthreads;
            for (int l4 = 0; l4 < nthreads; ++l4) {
                firstRow = l4 * p2;
                lastRow = l4 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            int idx1 = 2 * r2;
                            for (int c2 = 0; c2 < n2d2; ++c2) {
                                int idx0 = 2 * c2;
                                int idx2 = r2 * rowStride + idx0;
                                a2[idx2] = temp[c2][idx1];
                                a2[idx2 + 1] = temp[c2][idx1 + 1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l5 = 0; l5 < nthreads; ++l5) {
                firstRow = 1 + l5 * p2;
                lastRow = l5 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            int idx5 = r2 * rowStride;
                            int idx6 = (FloatFFT_2D.this.rows - r2 + 1) * rowStride;
                            for (int c2 = n2d2; c2 < FloatFFT_2D.this.columns; ++c2) {
                                int idx1 = 2 * c2;
                                int idx2 = 2 * (FloatFFT_2D.this.columns - c2);
                                a2[idx1] = a2[idx2];
                                a2[idx1 + 1] = -a2[idx2 + 1];
                                int idx3 = idx5 + idx1;
                                int idx4 = idx6 - idx1;
                                a2[idx3] = a2[idx4];
                                a2[idx3 + 1] = -a2[idx4 + 1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx1;
            int idx2;
            int r4;
            for (r4 = 0; r4 < this.rows; ++r4) {
                this.fftColumns.realForward(a2, r4 * this.columns);
            }
            for (r4 = 0; r4 < this.rows; ++r4) {
                temp[0][r4] = a2[r4 * this.columns];
            }
            this.fftRows.realForwardFull(temp[0]);
            for (int c2 = 1; c2 < n2d2 - 1; ++c2) {
                int idx0 = 2 * c2;
                for (int r5 = 0; r5 < this.rows; ++r5) {
                    int idx12 = 2 * r5;
                    idx2 = r5 * this.columns + idx0;
                    temp[c2][idx12] = a2[idx2];
                    temp[c2][idx12 + 1] = a2[idx2 + 1];
                }
                this.fftRows.complexForward(temp[c2]);
            }
            if (this.columns % 2 == 0) {
                for (r4 = 0; r4 < this.rows; ++r4) {
                    temp[n2d2 - 1][r4] = a2[r4 * this.columns + 1];
                }
                this.fftRows.realForwardFull(temp[n2d2 - 1]);
            } else {
                for (r4 = 0; r4 < this.rows; ++r4) {
                    idx1 = 2 * r4;
                    int idx22 = r4 * this.columns;
                    int idx3 = n2d2 - 1;
                    temp[idx3][idx1] = a2[idx22 + 2 * idx3];
                    temp[idx3][idx1 + 1] = a2[idx22 + 1];
                }
                this.fftRows.complexForward(temp[n2d2 - 1]);
            }
            for (r4 = 0; r4 < this.rows; ++r4) {
                idx1 = 2 * r4;
                for (int c3 = 0; c3 < n2d2; ++c3) {
                    int idx0 = 2 * c3;
                    idx2 = r4 * rowStride + idx0;
                    a2[idx2] = temp[c3][idx1];
                    a2[idx2 + 1] = temp[c3][idx1 + 1];
                }
            }
            for (r4 = 1; r4 < this.rows; ++r4) {
                int idx5 = r4 * rowStride;
                int idx6 = (this.rows - r4 + 1) * rowStride;
                for (int c4 = n2d2; c4 < this.columns; ++c4) {
                    int idx13 = 2 * c4;
                    int idx23 = 2 * (this.columns - c4);
                    a2[idx13] = a2[idx23];
                    a2[idx13 + 1] = -a2[idx23 + 1];
                    int idx3 = idx5 + idx13;
                    int idx4 = idx6 - idx13;
                    a2[idx3] = a2[idx4];
                    a2[idx3 + 1] = -a2[idx4 + 1];
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final FloatLargeArray a2) {
        final long rowStride = 2L * this.columnsl;
        final long n2d2 = this.columnsl / 2L + 1L;
        final FloatLargeArray temp = new FloatLargeArray(n2d2 * 2L * this.rowsl);
        final long temp_stride = 2L * this.rowsl;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.rowsl >= (long)nthreads && n2d2 - 2L >= (long)nthreads) {
            long r2;
            long lastRow;
            long firstRow;
            Future[] futures = new Future[nthreads];
            long p2 = this.rowsl / (long)nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstRow = (long)l2 * p2;
                lastRow = l2 == nthreads - 1 ? this.rowsl : firstRow + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i2 = firstRow; i2 < lastRow; ++i2) {
                            FloatFFT_2D.this.fftColumns.realForward(a2, i2 * FloatFFT_2D.this.columnsl);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (long r3 = 0L; r3 < this.rowsl; ++r3) {
                temp.setDouble(r3, a2.getFloat(r3 * this.columnsl));
            }
            this.fftRows.realForwardFull(temp);
            p2 = (n2d2 - 2L) / (long)nthreads;
            for (int l3 = 0; l3 < nthreads; ++l3) {
                final long firstColumn = 1L + (long)l3 * p2;
                final long lastColumn = l3 == nthreads - 1 ? n2d2 - 1L : firstColumn + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long c2 = firstColumn; c2 < lastColumn; ++c2) {
                            long idx0 = 2L * c2;
                            for (long r2 = 0L; r2 < FloatFFT_2D.this.rowsl; ++r2) {
                                long idx1 = 2L * r2;
                                long idx2 = r2 * FloatFFT_2D.this.columnsl + idx0;
                                temp.setDouble(c2 * temp_stride + idx1, a2.getFloat(idx2));
                                temp.setDouble(c2 * temp_stride + idx1 + 1L, a2.getFloat(idx2 + 1L));
                            }
                            FloatFFT_2D.this.fftRows.complexForward(temp, c2 * temp_stride);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.columnsl % 2L == 0L) {
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    temp.setDouble((n2d2 - 1L) * temp_stride + r2, a2.getFloat(r2 * this.columnsl + 1L));
                }
                this.fftRows.realForwardFull(temp, (n2d2 - 1L) * temp_stride);
            } else {
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    long idx1 = 2L * r2;
                    long idx2 = r2 * this.columnsl;
                    long idx3 = n2d2 - 1L;
                    temp.setDouble(idx3 * temp_stride + idx1, a2.getFloat(idx2 + 2L * idx3));
                    temp.setDouble(idx3 * temp_stride + idx1 + 1L, a2.getFloat(idx2 + 1L));
                }
                this.fftRows.complexForward(temp, (n2d2 - 1L) * temp_stride);
            }
            p2 = this.rowsl / (long)nthreads;
            for (int l4 = 0; l4 < nthreads; ++l4) {
                firstRow = (long)l4 * p2;
                lastRow = l4 == nthreads - 1 ? this.rowsl : firstRow + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long r2 = firstRow; r2 < lastRow; ++r2) {
                            long idx1 = 2L * r2;
                            for (long c2 = 0L; c2 < n2d2; ++c2) {
                                long idx0 = 2L * c2;
                                long idx2 = r2 * rowStride + idx0;
                                a2.setDouble(idx2, temp.getFloat(c2 * temp_stride + idx1));
                                a2.setDouble(idx2 + 1L, temp.getFloat(c2 * temp_stride + idx1 + 1L));
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l5 = 0; l5 < nthreads; ++l5) {
                firstRow = 1L + (long)l5 * p2;
                lastRow = l5 == nthreads - 1 ? this.rowsl : firstRow + p2;
                futures[l5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long r2 = firstRow; r2 < lastRow; ++r2) {
                            long idx5 = r2 * rowStride;
                            long idx6 = (FloatFFT_2D.this.rowsl - r2 + 1L) * rowStride;
                            for (long c2 = n2d2; c2 < FloatFFT_2D.this.columnsl; ++c2) {
                                long idx1 = 2L * c2;
                                long idx2 = 2L * (FloatFFT_2D.this.columnsl - c2);
                                a2.setDouble(idx1, a2.getFloat(idx2));
                                a2.setDouble(idx1 + 1L, -a2.getFloat(idx2 + 1L));
                                long idx3 = idx5 + idx1;
                                long idx4 = idx6 - idx1;
                                a2.setDouble(idx3, a2.getFloat(idx4));
                                a2.setDouble(idx3 + 1L, -a2.getFloat(idx4 + 1L));
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx1;
            long idx2;
            long r4;
            for (r4 = 0L; r4 < this.rowsl; ++r4) {
                this.fftColumns.realForward(a2, r4 * this.columnsl);
            }
            for (r4 = 0L; r4 < this.rowsl; ++r4) {
                temp.setDouble(r4, a2.getFloat(r4 * this.columnsl));
            }
            this.fftRows.realForwardFull(temp);
            for (long c2 = 1L; c2 < n2d2 - 1L; ++c2) {
                long idx0 = 2L * c2;
                for (long r5 = 0L; r5 < this.rowsl; ++r5) {
                    long idx12 = 2L * r5;
                    idx2 = r5 * this.columnsl + idx0;
                    temp.setDouble(c2 * temp_stride + idx12, a2.getFloat(idx2));
                    temp.setDouble(c2 * temp_stride + idx12 + 1L, a2.getFloat(idx2 + 1L));
                }
                this.fftRows.complexForward(temp, c2 * temp_stride);
            }
            if (this.columnsl % 2L == 0L) {
                for (r4 = 0L; r4 < this.rowsl; ++r4) {
                    temp.setDouble((n2d2 - 1L) * temp_stride + r4, a2.getFloat(r4 * this.columnsl + 1L));
                }
                this.fftRows.realForwardFull(temp, (n2d2 - 1L) * temp_stride);
            } else {
                for (r4 = 0L; r4 < this.rowsl; ++r4) {
                    idx1 = 2L * r4;
                    long idx22 = r4 * this.columnsl;
                    long idx3 = n2d2 - 1L;
                    temp.setDouble(idx3 * temp_stride + idx1, a2.getFloat(idx22 + 2L * idx3));
                    temp.setDouble(idx3 * temp_stride + idx1 + 1L, a2.getFloat(idx22 + 1L));
                }
                this.fftRows.complexForward(temp, (n2d2 - 1L) * temp_stride);
            }
            for (r4 = 0L; r4 < this.rowsl; ++r4) {
                idx1 = 2L * r4;
                for (long c3 = 0L; c3 < n2d2; ++c3) {
                    long idx0 = 2L * c3;
                    idx2 = r4 * rowStride + idx0;
                    a2.setDouble(idx2, temp.getFloat(c3 * temp_stride + idx1));
                    a2.setDouble(idx2 + 1L, temp.getFloat(c3 * temp_stride + idx1 + 1L));
                }
            }
            for (r4 = 1L; r4 < this.rowsl; ++r4) {
                long idx5 = r4 * rowStride;
                long idx6 = (this.rowsl - r4 + 1L) * rowStride;
                for (long c4 = n2d2; c4 < this.columnsl; ++c4) {
                    long idx13 = 2L * c4;
                    long idx23 = 2L * (this.columnsl - c4);
                    a2.setDouble(idx13, a2.getFloat(idx23));
                    a2.setDouble(idx13 + 1L, -a2.getFloat(idx23 + 1L));
                    long idx3 = idx5 + idx13;
                    long idx4 = idx6 - idx13;
                    a2.setDouble(idx3, a2.getFloat(idx4));
                    a2.setDouble(idx3 + 1L, -a2.getFloat(idx4 + 1L));
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[][] a2, final boolean scale) {
        final int n2d2 = this.columns / 2 + 1;
        final float[][] temp = new float[n2d2][2 * this.rows];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.rows >= nthreads && n2d2 - 2 >= nthreads) {
            int r2;
            int lastRow;
            int firstRow;
            Future[] futures = new Future[nthreads];
            int p2 = this.rows / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstRow = l2 * p2;
                lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i2 = firstRow; i2 < lastRow; ++i2) {
                            FloatFFT_2D.this.fftColumns.realInverse2(a2[i2], 0, scale);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int r3 = 0; r3 < this.rows; ++r3) {
                temp[0][r3] = a2[r3][0];
            }
            this.fftRows.realInverseFull(temp[0], scale);
            p2 = (n2d2 - 2) / nthreads;
            for (int l3 = 0; l3 < nthreads; ++l3) {
                final int firstColumn = 1 + l3 * p2;
                final int lastColumn = l3 == nthreads - 1 ? n2d2 - 1 : firstColumn + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int c2 = firstColumn; c2 < lastColumn; ++c2) {
                            int idx2 = 2 * c2;
                            for (int r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                int idx1 = 2 * r2;
                                temp[c2][idx1] = a2[r2][idx2];
                                temp[c2][idx1 + 1] = a2[r2][idx2 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(temp[c2], scale);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.columns % 2 == 0) {
                for (r2 = 0; r2 < this.rows; ++r2) {
                    temp[n2d2 - 1][r2] = a2[r2][1];
                }
                this.fftRows.realInverseFull(temp[n2d2 - 1], scale);
            } else {
                for (r2 = 0; r2 < this.rows; ++r2) {
                    int idx1 = 2 * r2;
                    int idx2 = n2d2 - 1;
                    temp[idx2][idx1] = a2[r2][2 * idx2];
                    temp[idx2][idx1 + 1] = a2[r2][1];
                }
                this.fftRows.complexInverse(temp[n2d2 - 1], scale);
            }
            p2 = this.rows / nthreads;
            for (int l4 = 0; l4 < nthreads; ++l4) {
                firstRow = l4 * p2;
                lastRow = l4 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            int idx1 = 2 * r2;
                            for (int c2 = 0; c2 < n2d2; ++c2) {
                                int idx2 = 2 * c2;
                                a2[r2][idx2] = temp[c2][idx1];
                                a2[r2][idx2 + 1] = temp[c2][idx1 + 1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l5 = 0; l5 < nthreads; ++l5) {
                firstRow = 1 + l5 * p2;
                lastRow = l5 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            int idx3 = FloatFFT_2D.this.rows - r2;
                            for (int c2 = n2d2; c2 < FloatFFT_2D.this.columns; ++c2) {
                                int idx1 = 2 * c2;
                                int idx2 = 2 * (FloatFFT_2D.this.columns - c2);
                                a2[0][idx1] = a2[0][idx2];
                                a2[0][idx1 + 1] = -a2[0][idx2 + 1];
                                a2[r2][idx1] = a2[idx3][idx2];
                                a2[r2][idx1 + 1] = -a2[idx3][idx2 + 1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int c2;
            int idx1;
            int idx12;
            int r4;
            for (r4 = 0; r4 < this.rows; ++r4) {
                this.fftColumns.realInverse2(a2[r4], 0, scale);
            }
            for (r4 = 0; r4 < this.rows; ++r4) {
                temp[0][r4] = a2[r4][0];
            }
            this.fftRows.realInverseFull(temp[0], scale);
            for (int c3 = 1; c3 < n2d2 - 1; ++c3) {
                int idx2 = 2 * c3;
                for (int r5 = 0; r5 < this.rows; ++r5) {
                    idx12 = 2 * r5;
                    temp[c3][idx12] = a2[r5][idx2];
                    temp[c3][idx12 + 1] = a2[r5][idx2 + 1];
                }
                this.fftRows.complexInverse(temp[c3], scale);
            }
            if (this.columns % 2 == 0) {
                for (r4 = 0; r4 < this.rows; ++r4) {
                    temp[n2d2 - 1][r4] = a2[r4][1];
                }
                this.fftRows.realInverseFull(temp[n2d2 - 1], scale);
            } else {
                for (r4 = 0; r4 < this.rows; ++r4) {
                    idx1 = 2 * r4;
                    int idx2 = n2d2 - 1;
                    temp[idx2][idx1] = a2[r4][2 * idx2];
                    temp[idx2][idx1 + 1] = a2[r4][1];
                }
                this.fftRows.complexInverse(temp[n2d2 - 1], scale);
            }
            for (r4 = 0; r4 < this.rows; ++r4) {
                idx1 = 2 * r4;
                for (c2 = 0; c2 < n2d2; ++c2) {
                    int idx2 = 2 * c2;
                    a2[r4][idx2] = temp[c2][idx1];
                    a2[r4][idx2 + 1] = temp[c2][idx1 + 1];
                }
            }
            for (r4 = 1; r4 < this.rows; ++r4) {
                int idx3 = this.rows - r4;
                for (c2 = n2d2; c2 < this.columns; ++c2) {
                    idx12 = 2 * c2;
                    int idx2 = 2 * (this.columns - c2);
                    a2[0][idx12] = a2[0][idx2];
                    a2[0][idx12 + 1] = -a2[0][idx2 + 1];
                    a2[r4][idx12] = a2[idx3][idx2];
                    a2[r4][idx12 + 1] = -a2[idx3][idx2 + 1];
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[] a2, final boolean scale) {
        final int rowStride = 2 * this.columns;
        final int n2d2 = this.columns / 2 + 1;
        final float[][] temp = new float[n2d2][2 * this.rows];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.rows >= nthreads && n2d2 - 2 >= nthreads) {
            int r2;
            int lastRow;
            int firstRow;
            Future[] futures = new Future[nthreads];
            int p2 = this.rows / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstRow = l2 * p2;
                lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i2 = firstRow; i2 < lastRow; ++i2) {
                            FloatFFT_2D.this.fftColumns.realInverse2(a2, i2 * FloatFFT_2D.this.columns, scale);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int r3 = 0; r3 < this.rows; ++r3) {
                temp[0][r3] = a2[r3 * this.columns];
            }
            this.fftRows.realInverseFull(temp[0], scale);
            p2 = (n2d2 - 2) / nthreads;
            for (int l3 = 0; l3 < nthreads; ++l3) {
                final int firstColumn = 1 + l3 * p2;
                final int lastColumn = l3 == nthreads - 1 ? n2d2 - 1 : firstColumn + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int c2 = firstColumn; c2 < lastColumn; ++c2) {
                            int idx0 = 2 * c2;
                            for (int r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                int idx1 = 2 * r2;
                                int idx2 = r2 * FloatFFT_2D.this.columns + idx0;
                                temp[c2][idx1] = a2[idx2];
                                temp[c2][idx1 + 1] = a2[idx2 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(temp[c2], scale);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.columns % 2 == 0) {
                for (r2 = 0; r2 < this.rows; ++r2) {
                    temp[n2d2 - 1][r2] = a2[r2 * this.columns + 1];
                }
                this.fftRows.realInverseFull(temp[n2d2 - 1], scale);
            } else {
                for (r2 = 0; r2 < this.rows; ++r2) {
                    int idx1 = 2 * r2;
                    int idx2 = r2 * this.columns;
                    int idx3 = n2d2 - 1;
                    temp[idx3][idx1] = a2[idx2 + 2 * idx3];
                    temp[idx3][idx1 + 1] = a2[idx2 + 1];
                }
                this.fftRows.complexInverse(temp[n2d2 - 1], scale);
            }
            p2 = this.rows / nthreads;
            for (int l4 = 0; l4 < nthreads; ++l4) {
                firstRow = l4 * p2;
                lastRow = l4 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            int idx1 = 2 * r2;
                            for (int c2 = 0; c2 < n2d2; ++c2) {
                                int idx0 = 2 * c2;
                                int idx2 = r2 * rowStride + idx0;
                                a2[idx2] = temp[c2][idx1];
                                a2[idx2 + 1] = temp[c2][idx1 + 1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l5 = 0; l5 < nthreads; ++l5) {
                firstRow = 1 + l5 * p2;
                lastRow = l5 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            int idx5 = r2 * rowStride;
                            int idx6 = (FloatFFT_2D.this.rows - r2 + 1) * rowStride;
                            for (int c2 = n2d2; c2 < FloatFFT_2D.this.columns; ++c2) {
                                int idx1 = 2 * c2;
                                int idx2 = 2 * (FloatFFT_2D.this.columns - c2);
                                a2[idx1] = a2[idx2];
                                a2[idx1 + 1] = -a2[idx2 + 1];
                                int idx3 = idx5 + idx1;
                                int idx4 = idx6 - idx1;
                                a2[idx3] = a2[idx4];
                                a2[idx3 + 1] = -a2[idx4 + 1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx1;
            int idx2;
            int r4;
            for (r4 = 0; r4 < this.rows; ++r4) {
                this.fftColumns.realInverse2(a2, r4 * this.columns, scale);
            }
            for (r4 = 0; r4 < this.rows; ++r4) {
                temp[0][r4] = a2[r4 * this.columns];
            }
            this.fftRows.realInverseFull(temp[0], scale);
            for (int c2 = 1; c2 < n2d2 - 1; ++c2) {
                int idx0 = 2 * c2;
                for (int r5 = 0; r5 < this.rows; ++r5) {
                    int idx12 = 2 * r5;
                    idx2 = r5 * this.columns + idx0;
                    temp[c2][idx12] = a2[idx2];
                    temp[c2][idx12 + 1] = a2[idx2 + 1];
                }
                this.fftRows.complexInverse(temp[c2], scale);
            }
            if (this.columns % 2 == 0) {
                for (r4 = 0; r4 < this.rows; ++r4) {
                    temp[n2d2 - 1][r4] = a2[r4 * this.columns + 1];
                }
                this.fftRows.realInverseFull(temp[n2d2 - 1], scale);
            } else {
                for (r4 = 0; r4 < this.rows; ++r4) {
                    idx1 = 2 * r4;
                    int idx22 = r4 * this.columns;
                    int idx3 = n2d2 - 1;
                    temp[idx3][idx1] = a2[idx22 + 2 * idx3];
                    temp[idx3][idx1 + 1] = a2[idx22 + 1];
                }
                this.fftRows.complexInverse(temp[n2d2 - 1], scale);
            }
            for (r4 = 0; r4 < this.rows; ++r4) {
                idx1 = 2 * r4;
                for (int c3 = 0; c3 < n2d2; ++c3) {
                    int idx0 = 2 * c3;
                    idx2 = r4 * rowStride + idx0;
                    a2[idx2] = temp[c3][idx1];
                    a2[idx2 + 1] = temp[c3][idx1 + 1];
                }
            }
            for (r4 = 1; r4 < this.rows; ++r4) {
                int idx5 = r4 * rowStride;
                int idx6 = (this.rows - r4 + 1) * rowStride;
                for (int c4 = n2d2; c4 < this.columns; ++c4) {
                    int idx13 = 2 * c4;
                    int idx23 = 2 * (this.columns - c4);
                    a2[idx13] = a2[idx23];
                    a2[idx13 + 1] = -a2[idx23 + 1];
                    int idx3 = idx5 + idx13;
                    int idx4 = idx6 - idx13;
                    a2[idx3] = a2[idx4];
                    a2[idx3 + 1] = -a2[idx4 + 1];
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final FloatLargeArray a2, final boolean scale) {
        final long rowStride = 2L * this.columnsl;
        final long n2d2 = this.columnsl / 2L + 1L;
        final FloatLargeArray temp = new FloatLargeArray(n2d2 * 2L * this.rowsl);
        final long temp_stride = 2L * this.rowsl;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.rowsl >= (long)nthreads && n2d2 - 2L >= (long)nthreads) {
            long r2;
            long lastRow;
            long firstRow;
            Future[] futures = new Future[nthreads];
            long p2 = this.rowsl / (long)nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstRow = (long)l2 * p2;
                lastRow = l2 == nthreads - 1 ? this.rowsl : firstRow + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i2 = firstRow; i2 < lastRow; ++i2) {
                            FloatFFT_2D.this.fftColumns.realInverse2(a2, i2 * FloatFFT_2D.this.columnsl, scale);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (long r3 = 0L; r3 < this.rowsl; ++r3) {
                temp.setDouble(r3, a2.getFloat(r3 * this.columnsl));
            }
            this.fftRows.realInverseFull(temp, scale);
            p2 = (n2d2 - 2L) / (long)nthreads;
            for (int l3 = 0; l3 < nthreads; ++l3) {
                final long firstColumn = 1L + (long)l3 * p2;
                final long lastColumn = l3 == nthreads - 1 ? n2d2 - 1L : firstColumn + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long c2 = firstColumn; c2 < lastColumn; ++c2) {
                            long idx0 = 2L * c2;
                            for (long r2 = 0L; r2 < FloatFFT_2D.this.rowsl; ++r2) {
                                long idx1 = 2L * r2;
                                long idx2 = r2 * FloatFFT_2D.this.columnsl + idx0;
                                temp.setDouble(c2 * temp_stride + idx1, a2.getFloat(idx2));
                                temp.setDouble(c2 * temp_stride + idx1 + 1L, a2.getFloat(idx2 + 1L));
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(temp, c2 * temp_stride, scale);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.columnsl % 2L == 0L) {
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    temp.setDouble((n2d2 - 1L) * temp_stride + r2, a2.getFloat(r2 * this.columnsl + 1L));
                }
                this.fftRows.realInverseFull(temp, (n2d2 - 1L) * temp_stride, scale);
            } else {
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    long idx1 = 2L * r2;
                    long idx2 = r2 * this.columnsl;
                    long idx3 = n2d2 - 1L;
                    temp.setDouble(idx3 * temp_stride + idx1, a2.getFloat(idx2 + 2L * idx3));
                    temp.setDouble(idx3 * temp_stride + idx1 + 1L, a2.getFloat(idx2 + 1L));
                }
                this.fftRows.complexInverse(temp, (n2d2 - 1L) * temp_stride, scale);
            }
            p2 = this.rowsl / (long)nthreads;
            for (int l4 = 0; l4 < nthreads; ++l4) {
                firstRow = (long)l4 * p2;
                lastRow = l4 == nthreads - 1 ? this.rowsl : firstRow + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long r2 = firstRow; r2 < lastRow; ++r2) {
                            long idx1 = 2L * r2;
                            for (long c2 = 0L; c2 < n2d2; ++c2) {
                                long idx0 = 2L * c2;
                                long idx2 = r2 * rowStride + idx0;
                                a2.setDouble(idx2, temp.getFloat(c2 * temp_stride + idx1));
                                a2.setDouble(idx2 + 1L, temp.getFloat(c2 * temp_stride + idx1 + 1L));
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l5 = 0; l5 < nthreads; ++l5) {
                firstRow = 1L + (long)l5 * p2;
                lastRow = l5 == nthreads - 1 ? this.rowsl : firstRow + p2;
                futures[l5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long r2 = firstRow; r2 < lastRow; ++r2) {
                            long idx5 = r2 * rowStride;
                            long idx6 = (FloatFFT_2D.this.rowsl - r2 + 1L) * rowStride;
                            for (long c2 = n2d2; c2 < FloatFFT_2D.this.columnsl; ++c2) {
                                long idx1 = 2L * c2;
                                long idx2 = 2L * (FloatFFT_2D.this.columnsl - c2);
                                a2.setDouble(idx1, a2.getFloat(idx2));
                                a2.setDouble(idx1 + 1L, -a2.getFloat(idx2 + 1L));
                                long idx3 = idx5 + idx1;
                                long idx4 = idx6 - idx1;
                                a2.setDouble(idx3, a2.getFloat(idx4));
                                a2.setDouble(idx3 + 1L, -a2.getFloat(idx4 + 1L));
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx1;
            long idx2;
            long r4;
            for (r4 = 0L; r4 < this.rowsl; ++r4) {
                this.fftColumns.realInverse2(a2, r4 * this.columnsl, scale);
            }
            for (r4 = 0L; r4 < this.rowsl; ++r4) {
                temp.setDouble(r4, a2.getFloat(r4 * this.columnsl));
            }
            this.fftRows.realInverseFull(temp, scale);
            for (long c2 = 1L; c2 < n2d2 - 1L; ++c2) {
                long idx0 = 2L * c2;
                for (long r5 = 0L; r5 < this.rowsl; ++r5) {
                    long idx12 = 2L * r5;
                    idx2 = r5 * this.columnsl + idx0;
                    temp.setDouble(c2 * temp_stride + idx12, a2.getFloat(idx2));
                    temp.setDouble(c2 * temp_stride + idx12 + 1L, a2.getFloat(idx2 + 1L));
                }
                this.fftRows.complexInverse(temp, c2 * temp_stride, scale);
            }
            if (this.columnsl % 2L == 0L) {
                for (r4 = 0L; r4 < this.rowsl; ++r4) {
                    temp.setDouble((n2d2 - 1L) * temp_stride + r4, a2.getFloat(r4 * this.columnsl + 1L));
                }
                this.fftRows.realInverseFull(temp, (n2d2 - 1L) * temp_stride, scale);
            } else {
                for (r4 = 0L; r4 < this.rowsl; ++r4) {
                    idx1 = 2L * r4;
                    long idx22 = r4 * this.columnsl;
                    long idx3 = n2d2 - 1L;
                    temp.setDouble(idx3 * temp_stride + idx1, a2.getFloat(idx22 + 2L * idx3));
                    temp.setDouble(idx3 * temp_stride + idx1 + 1L, a2.getFloat(idx22 + 1L));
                }
                this.fftRows.complexInverse(temp, (n2d2 - 1L) * temp_stride, scale);
            }
            for (r4 = 0L; r4 < this.rowsl; ++r4) {
                idx1 = 2L * r4;
                for (long c3 = 0L; c3 < n2d2; ++c3) {
                    long idx0 = 2L * c3;
                    idx2 = r4 * rowStride + idx0;
                    a2.setDouble(idx2, temp.getFloat(c3 * temp_stride + idx1));
                    a2.setDouble(idx2 + 1L, temp.getFloat(c3 * temp_stride + idx1 + 1L));
                }
            }
            for (r4 = 1L; r4 < this.rowsl; ++r4) {
                long idx5 = r4 * rowStride;
                long idx6 = (this.rowsl - r4 + 1L) * rowStride;
                for (long c4 = n2d2; c4 < this.columnsl; ++c4) {
                    long idx13 = 2L * c4;
                    long idx23 = 2L * (this.columnsl - c4);
                    a2.setDouble(idx13, a2.getFloat(idx23));
                    a2.setDouble(idx13 + 1L, -a2.getFloat(idx23 + 1L));
                    long idx3 = idx5 + idx13;
                    long idx4 = idx6 - idx13;
                    a2.setDouble(idx3, a2.getFloat(idx4));
                    a2.setDouble(idx3 + 1L, -a2.getFloat(idx4 + 1L));
                }
            }
        }
    }

    private void rdft2d_sub(int isgn, float[] a2) {
        int n1h = this.rows >> 1;
        if (isgn < 0) {
            for (int i2 = 1; i2 < n1h; ++i2) {
                int j2 = this.rows - i2;
                int idx1 = i2 * this.columns;
                int idx2 = j2 * this.columns;
                float xi = a2[idx1] - a2[idx2];
                int n2 = idx1;
                a2[n2] = a2[n2] + a2[idx2];
                a2[idx2] = xi;
                xi = a2[idx2 + 1] - a2[idx1 + 1];
                int n3 = idx1 + 1;
                a2[n3] = a2[n3] + a2[idx2 + 1];
                a2[idx2 + 1] = xi;
            }
        } else {
            for (int i3 = 1; i3 < n1h; ++i3) {
                int j3 = this.rows - i3;
                int idx1 = i3 * this.columns;
                int idx2 = j3 * this.columns;
                a2[idx2] = 0.5f * (a2[idx1] - a2[idx2]);
                int n4 = idx1;
                a2[n4] = a2[n4] - a2[idx2];
                a2[idx2 + 1] = 0.5f * (a2[idx1 + 1] + a2[idx2 + 1]);
                int n5 = idx1 + 1;
                a2[n5] = a2[n5] - a2[idx2 + 1];
            }
        }
    }

    private void rdft2d_sub(int isgn, FloatLargeArray a2) {
        long n1h = this.rowsl >> 1;
        if (isgn < 0) {
            for (long i2 = 1L; i2 < n1h; ++i2) {
                long j2 = this.rowsl - i2;
                long idx1 = i2 * this.columnsl;
                long idx2 = j2 * this.columnsl;
                float xi = a2.getFloat(idx1) - a2.getFloat(idx2);
                a2.setDouble(idx1, a2.getFloat(idx1) + a2.getFloat(idx2));
                a2.setDouble(idx2, xi);
                xi = a2.getFloat(idx2 + 1L) - a2.getFloat(idx1 + 1L);
                a2.setDouble(idx1 + 1L, a2.getFloat(idx1 + 1L) + a2.getFloat(idx2 + 1L));
                a2.setDouble(idx2 + 1L, xi);
            }
        } else {
            for (long i3 = 1L; i3 < n1h; ++i3) {
                long j3 = this.rowsl - i3;
                long idx1 = i3 * this.columnsl;
                long idx2 = j3 * this.columnsl;
                a2.setDouble(idx2, 0.5f * (a2.getFloat(idx1) - a2.getFloat(idx2)));
                a2.setDouble(idx1, a2.getFloat(idx1) - a2.getFloat(idx2));
                a2.setDouble(idx2 + 1L, 0.5f * (a2.getFloat(idx1 + 1L) + a2.getFloat(idx2 + 1L)));
                a2.setDouble(idx1 + 1L, a2.getFloat(idx1 + 1L) - a2.getFloat(idx2 + 1L));
            }
        }
    }

    private void rdft2d_sub(int isgn, float[][] a2) {
        int n1h = this.rows >> 1;
        if (isgn < 0) {
            for (int i2 = 1; i2 < n1h; ++i2) {
                int j2 = this.rows - i2;
                float xi = a2[i2][0] - a2[j2][0];
                float[] fArray = a2[i2];
                fArray[0] = fArray[0] + a2[j2][0];
                a2[j2][0] = xi;
                xi = a2[j2][1] - a2[i2][1];
                float[] fArray2 = a2[i2];
                fArray2[1] = fArray2[1] + a2[j2][1];
                a2[j2][1] = xi;
            }
        } else {
            for (int i3 = 1; i3 < n1h; ++i3) {
                int j3 = this.rows - i3;
                a2[j3][0] = 0.5f * (a2[i3][0] - a2[j3][0]);
                float[] fArray = a2[i3];
                fArray[0] = fArray[0] - a2[j3][0];
                a2[j3][1] = 0.5f * (a2[i3][1] + a2[j3][1]);
                float[] fArray3 = a2[i3];
                fArray3[1] = fArray3[1] - a2[j3][1];
            }
        }
    }

    private void cdft2d_sub(int isgn, float[] a2, boolean scale) {
        block24: {
            float[] t2;
            block22: {
                int idx2;
                int idx1;
                int r2;
                block25: {
                    int idx3;
                    int idx22;
                    int idx12;
                    int r3;
                    block23: {
                        int nt = 8 * this.rows;
                        if (this.columns == 4) {
                            nt >>= 1;
                        } else if (this.columns < 4) {
                            nt >>= 2;
                        }
                        t2 = new float[nt];
                        if (isgn != -1) break block22;
                        if (this.columns <= 4) break block23;
                        for (int c2 = 0; c2 < this.columns; c2 += 8) {
                            int idx5;
                            int idx4;
                            int idx32;
                            int idx23;
                            int idx13;
                            int r4;
                            for (r4 = 0; r4 < this.rows; ++r4) {
                                idx13 = r4 * this.columns + c2;
                                idx23 = 2 * r4;
                                idx32 = 2 * this.rows + 2 * r4;
                                idx4 = idx32 + 2 * this.rows;
                                idx5 = idx4 + 2 * this.rows;
                                t2[idx23] = a2[idx13];
                                t2[idx23 + 1] = a2[idx13 + 1];
                                t2[idx32] = a2[idx13 + 2];
                                t2[idx32 + 1] = a2[idx13 + 3];
                                t2[idx4] = a2[idx13 + 4];
                                t2[idx4 + 1] = a2[idx13 + 5];
                                t2[idx5] = a2[idx13 + 6];
                                t2[idx5 + 1] = a2[idx13 + 7];
                            }
                            this.fftRows.complexForward(t2, 0);
                            this.fftRows.complexForward(t2, 2 * this.rows);
                            this.fftRows.complexForward(t2, 4 * this.rows);
                            this.fftRows.complexForward(t2, 6 * this.rows);
                            for (r4 = 0; r4 < this.rows; ++r4) {
                                idx13 = r4 * this.columns + c2;
                                idx23 = 2 * r4;
                                idx32 = 2 * this.rows + 2 * r4;
                                idx4 = idx32 + 2 * this.rows;
                                idx5 = idx4 + 2 * this.rows;
                                a2[idx13] = t2[idx23];
                                a2[idx13 + 1] = t2[idx23 + 1];
                                a2[idx13 + 2] = t2[idx32];
                                a2[idx13 + 3] = t2[idx32 + 1];
                                a2[idx13 + 4] = t2[idx4];
                                a2[idx13 + 5] = t2[idx4 + 1];
                                a2[idx13 + 6] = t2[idx5];
                                a2[idx13 + 7] = t2[idx5 + 1];
                            }
                        }
                        break block24;
                    }
                    if (this.columns != 4) break block25;
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        idx12 = r3 * this.columns;
                        idx22 = 2 * r3;
                        idx3 = 2 * this.rows + 2 * r3;
                        t2[idx22] = a2[idx12];
                        t2[idx22 + 1] = a2[idx12 + 1];
                        t2[idx3] = a2[idx12 + 2];
                        t2[idx3 + 1] = a2[idx12 + 3];
                    }
                    this.fftRows.complexForward(t2, 0);
                    this.fftRows.complexForward(t2, 2 * this.rows);
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        idx12 = r3 * this.columns;
                        idx22 = 2 * r3;
                        idx3 = 2 * this.rows + 2 * r3;
                        a2[idx12] = t2[idx22];
                        a2[idx12 + 1] = t2[idx22 + 1];
                        a2[idx12 + 2] = t2[idx3];
                        a2[idx12 + 3] = t2[idx3 + 1];
                    }
                    break block24;
                }
                if (this.columns != 2) break block24;
                for (r2 = 0; r2 < this.rows; ++r2) {
                    idx1 = r2 * this.columns;
                    idx2 = 2 * r2;
                    t2[idx2] = a2[idx1];
                    t2[idx2 + 1] = a2[idx1 + 1];
                }
                this.fftRows.complexForward(t2, 0);
                for (r2 = 0; r2 < this.rows; ++r2) {
                    idx1 = r2 * this.columns;
                    idx2 = 2 * r2;
                    a2[idx1] = t2[idx2];
                    a2[idx1 + 1] = t2[idx2 + 1];
                }
                break block24;
            }
            if (this.columns > 4) {
                for (int c3 = 0; c3 < this.columns; c3 += 8) {
                    int idx5;
                    int idx4;
                    int idx3;
                    int idx2;
                    int idx1;
                    int r5;
                    for (r5 = 0; r5 < this.rows; ++r5) {
                        idx1 = r5 * this.columns + c3;
                        idx2 = 2 * r5;
                        idx3 = 2 * this.rows + 2 * r5;
                        idx4 = idx3 + 2 * this.rows;
                        idx5 = idx4 + 2 * this.rows;
                        t2[idx2] = a2[idx1];
                        t2[idx2 + 1] = a2[idx1 + 1];
                        t2[idx3] = a2[idx1 + 2];
                        t2[idx3 + 1] = a2[idx1 + 3];
                        t2[idx4] = a2[idx1 + 4];
                        t2[idx4 + 1] = a2[idx1 + 5];
                        t2[idx5] = a2[idx1 + 6];
                        t2[idx5 + 1] = a2[idx1 + 7];
                    }
                    this.fftRows.complexInverse(t2, 0, scale);
                    this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                    this.fftRows.complexInverse(t2, 4 * this.rows, scale);
                    this.fftRows.complexInverse(t2, 6 * this.rows, scale);
                    for (r5 = 0; r5 < this.rows; ++r5) {
                        idx1 = r5 * this.columns + c3;
                        idx2 = 2 * r5;
                        idx3 = 2 * this.rows + 2 * r5;
                        idx4 = idx3 + 2 * this.rows;
                        idx5 = idx4 + 2 * this.rows;
                        a2[idx1] = t2[idx2];
                        a2[idx1 + 1] = t2[idx2 + 1];
                        a2[idx1 + 2] = t2[idx3];
                        a2[idx1 + 3] = t2[idx3 + 1];
                        a2[idx1 + 4] = t2[idx4];
                        a2[idx1 + 5] = t2[idx4 + 1];
                        a2[idx1 + 6] = t2[idx5];
                        a2[idx1 + 7] = t2[idx5 + 1];
                    }
                }
            } else if (this.columns == 4) {
                int idx3;
                int idx2;
                int idx1;
                int r6;
                for (r6 = 0; r6 < this.rows; ++r6) {
                    idx1 = r6 * this.columns;
                    idx2 = 2 * r6;
                    idx3 = 2 * this.rows + 2 * r6;
                    t2[idx2] = a2[idx1];
                    t2[idx2 + 1] = a2[idx1 + 1];
                    t2[idx3] = a2[idx1 + 2];
                    t2[idx3 + 1] = a2[idx1 + 3];
                }
                this.fftRows.complexInverse(t2, 0, scale);
                this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                for (r6 = 0; r6 < this.rows; ++r6) {
                    idx1 = r6 * this.columns;
                    idx2 = 2 * r6;
                    idx3 = 2 * this.rows + 2 * r6;
                    a2[idx1] = t2[idx2];
                    a2[idx1 + 1] = t2[idx2 + 1];
                    a2[idx1 + 2] = t2[idx3];
                    a2[idx1 + 3] = t2[idx3 + 1];
                }
            } else if (this.columns == 2) {
                int idx2;
                int idx1;
                int r7;
                for (r7 = 0; r7 < this.rows; ++r7) {
                    idx1 = r7 * this.columns;
                    idx2 = 2 * r7;
                    t2[idx2] = a2[idx1];
                    t2[idx2 + 1] = a2[idx1 + 1];
                }
                this.fftRows.complexInverse(t2, 0, scale);
                for (r7 = 0; r7 < this.rows; ++r7) {
                    idx1 = r7 * this.columns;
                    idx2 = 2 * r7;
                    a2[idx1] = t2[idx2];
                    a2[idx1 + 1] = t2[idx2 + 1];
                }
            }
        }
    }

    private void cdft2d_sub(int isgn, FloatLargeArray a2, boolean scale) {
        block24: {
            FloatLargeArray t2;
            block22: {
                long idx2;
                long idx1;
                long r2;
                block25: {
                    long idx3;
                    long idx22;
                    long idx12;
                    long r3;
                    block23: {
                        long nt = 8L * this.rowsl;
                        if (this.columnsl == 4L) {
                            nt >>= 1;
                        } else if (this.columnsl < 4L) {
                            nt >>= 2;
                        }
                        t2 = new FloatLargeArray(nt);
                        if (isgn != -1) break block22;
                        if (this.columnsl <= 4L) break block23;
                        for (long c2 = 0L; c2 < this.columnsl; c2 += 8L) {
                            long idx5;
                            long idx4;
                            long idx32;
                            long idx23;
                            long idx13;
                            long r4;
                            for (r4 = 0L; r4 < this.rowsl; ++r4) {
                                idx13 = r4 * this.columnsl + c2;
                                idx23 = 2L * r4;
                                idx32 = 2L * this.rowsl + 2L * r4;
                                idx4 = idx32 + 2L * this.rowsl;
                                idx5 = idx4 + 2L * this.rowsl;
                                t2.setDouble(idx23, a2.getFloat(idx13));
                                t2.setDouble(idx23 + 1L, a2.getFloat(idx13 + 1L));
                                t2.setDouble(idx32, a2.getFloat(idx13 + 2L));
                                t2.setDouble(idx32 + 1L, a2.getFloat(idx13 + 3L));
                                t2.setDouble(idx4, a2.getFloat(idx13 + 4L));
                                t2.setDouble(idx4 + 1L, a2.getFloat(idx13 + 5L));
                                t2.setDouble(idx5, a2.getFloat(idx13 + 6L));
                                t2.setDouble(idx5 + 1L, a2.getFloat(idx13 + 7L));
                            }
                            this.fftRows.complexForward(t2, 0L);
                            this.fftRows.complexForward(t2, 2L * this.rowsl);
                            this.fftRows.complexForward(t2, 4L * this.rowsl);
                            this.fftRows.complexForward(t2, 6L * this.rowsl);
                            for (r4 = 0L; r4 < this.rowsl; ++r4) {
                                idx13 = r4 * this.columnsl + c2;
                                idx23 = 2L * r4;
                                idx32 = 2L * this.rowsl + 2L * r4;
                                idx4 = idx32 + 2L * this.rowsl;
                                idx5 = idx4 + 2L * this.rowsl;
                                a2.setDouble(idx13, t2.getFloat(idx23));
                                a2.setDouble(idx13 + 1L, t2.getFloat(idx23 + 1L));
                                a2.setDouble(idx13 + 2L, t2.getFloat(idx32));
                                a2.setDouble(idx13 + 3L, t2.getFloat(idx32 + 1L));
                                a2.setDouble(idx13 + 4L, t2.getFloat(idx4));
                                a2.setDouble(idx13 + 5L, t2.getFloat(idx4 + 1L));
                                a2.setDouble(idx13 + 6L, t2.getFloat(idx5));
                                a2.setDouble(idx13 + 7L, t2.getFloat(idx5 + 1L));
                            }
                        }
                        break block24;
                    }
                    if (this.columnsl != 4L) break block25;
                    for (r3 = 0L; r3 < this.rowsl; ++r3) {
                        idx12 = r3 * this.columnsl;
                        idx22 = 2L * r3;
                        idx3 = 2L * this.rowsl + 2L * r3;
                        t2.setDouble(idx22, a2.getFloat(idx12));
                        t2.setDouble(idx22 + 1L, a2.getFloat(idx12 + 1L));
                        t2.setDouble(idx3, a2.getFloat(idx12 + 2L));
                        t2.setDouble(idx3 + 1L, a2.getFloat(idx12 + 3L));
                    }
                    this.fftRows.complexForward(t2, 0L);
                    this.fftRows.complexForward(t2, 2L * this.rowsl);
                    for (r3 = 0L; r3 < this.rowsl; ++r3) {
                        idx12 = r3 * this.columnsl;
                        idx22 = 2L * r3;
                        idx3 = 2L * this.rowsl + 2L * r3;
                        a2.setDouble(idx12, t2.getFloat(idx22));
                        a2.setDouble(idx12 + 1L, t2.getFloat(idx22 + 1L));
                        a2.setDouble(idx12 + 2L, t2.getFloat(idx3));
                        a2.setDouble(idx12 + 3L, t2.getFloat(idx3 + 1L));
                    }
                    break block24;
                }
                if (this.columnsl != 2L) break block24;
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    idx1 = r2 * this.columnsl;
                    idx2 = 2L * r2;
                    t2.setDouble(idx2, a2.getFloat(idx1));
                    t2.setDouble(idx2 + 1L, a2.getFloat(idx1 + 1L));
                }
                this.fftRows.complexForward(t2, 0L);
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    idx1 = r2 * this.columnsl;
                    idx2 = 2L * r2;
                    a2.setDouble(idx1, t2.getFloat(idx2));
                    a2.setDouble(idx1 + 1L, t2.getFloat(idx2 + 1L));
                }
                break block24;
            }
            if (this.columnsl > 4L) {
                for (long c3 = 0L; c3 < this.columnsl; c3 += 8L) {
                    long idx5;
                    long idx4;
                    long idx3;
                    long idx2;
                    long idx1;
                    long r5;
                    for (r5 = 0L; r5 < this.rowsl; ++r5) {
                        idx1 = r5 * this.columnsl + c3;
                        idx2 = 2L * r5;
                        idx3 = 2L * this.rowsl + 2L * r5;
                        idx4 = idx3 + 2L * this.rowsl;
                        idx5 = idx4 + 2L * this.rowsl;
                        t2.setDouble(idx2, a2.getFloat(idx1));
                        t2.setDouble(idx2 + 1L, a2.getFloat(idx1 + 1L));
                        t2.setDouble(idx3, a2.getFloat(idx1 + 2L));
                        t2.setDouble(idx3 + 1L, a2.getFloat(idx1 + 3L));
                        t2.setDouble(idx4, a2.getFloat(idx1 + 4L));
                        t2.setDouble(idx4 + 1L, a2.getFloat(idx1 + 5L));
                        t2.setDouble(idx5, a2.getFloat(idx1 + 6L));
                        t2.setDouble(idx5 + 1L, a2.getFloat(idx1 + 7L));
                    }
                    this.fftRows.complexInverse(t2, 0L, scale);
                    this.fftRows.complexInverse(t2, 2L * this.rowsl, scale);
                    this.fftRows.complexInverse(t2, 4L * this.rowsl, scale);
                    this.fftRows.complexInverse(t2, 6L * this.rowsl, scale);
                    for (r5 = 0L; r5 < this.rowsl; ++r5) {
                        idx1 = r5 * this.columnsl + c3;
                        idx2 = 2L * r5;
                        idx3 = 2L * this.rowsl + 2L * r5;
                        idx4 = idx3 + 2L * this.rowsl;
                        idx5 = idx4 + 2L * this.rowsl;
                        a2.setDouble(idx1, t2.getFloat(idx2));
                        a2.setDouble(idx1 + 1L, t2.getFloat(idx2 + 1L));
                        a2.setDouble(idx1 + 2L, t2.getFloat(idx3));
                        a2.setDouble(idx1 + 3L, t2.getFloat(idx3 + 1L));
                        a2.setDouble(idx1 + 4L, t2.getFloat(idx4));
                        a2.setDouble(idx1 + 5L, t2.getFloat(idx4 + 1L));
                        a2.setDouble(idx1 + 6L, t2.getFloat(idx5));
                        a2.setDouble(idx1 + 7L, t2.getFloat(idx5 + 1L));
                    }
                }
            } else if (this.columnsl == 4L) {
                long idx3;
                long idx2;
                long idx1;
                long r6;
                for (r6 = 0L; r6 < this.rowsl; ++r6) {
                    idx1 = r6 * this.columnsl;
                    idx2 = 2L * r6;
                    idx3 = 2L * this.rowsl + 2L * r6;
                    t2.setDouble(idx2, a2.getFloat(idx1));
                    t2.setDouble(idx2 + 1L, a2.getFloat(idx1 + 1L));
                    t2.setDouble(idx3, a2.getFloat(idx1 + 2L));
                    t2.setDouble(idx3 + 1L, a2.getFloat(idx1 + 3L));
                }
                this.fftRows.complexInverse(t2, 0L, scale);
                this.fftRows.complexInverse(t2, 2L * this.rowsl, scale);
                for (r6 = 0L; r6 < this.rowsl; ++r6) {
                    idx1 = r6 * this.columnsl;
                    idx2 = 2L * r6;
                    idx3 = 2L * this.rowsl + 2L * r6;
                    a2.setDouble(idx1, t2.getFloat(idx2));
                    a2.setDouble(idx1 + 1L, t2.getFloat(idx2 + 1L));
                    a2.setDouble(idx1 + 2L, t2.getFloat(idx3));
                    a2.setDouble(idx1 + 3L, t2.getFloat(idx3 + 1L));
                }
            } else if (this.columnsl == 2L) {
                long idx2;
                long idx1;
                long r7;
                for (r7 = 0L; r7 < this.rowsl; ++r7) {
                    idx1 = r7 * this.columnsl;
                    idx2 = 2L * r7;
                    t2.setDouble(idx2, a2.getFloat(idx1));
                    t2.setDouble(idx2 + 1L, a2.getFloat(idx1 + 1L));
                }
                this.fftRows.complexInverse(t2, 0L, scale);
                for (r7 = 0L; r7 < this.rowsl; ++r7) {
                    idx1 = r7 * this.columnsl;
                    idx2 = 2L * r7;
                    a2.setDouble(idx1, t2.getFloat(idx2));
                    a2.setDouble(idx1 + 1L, t2.getFloat(idx2 + 1L));
                }
            }
        }
    }

    private void cdft2d_sub(int isgn, float[][] a2, boolean scale) {
        block24: {
            float[] t2;
            block22: {
                int idx2;
                int r2;
                block25: {
                    int idx3;
                    int idx22;
                    int r3;
                    block23: {
                        int nt = 8 * this.rows;
                        if (this.columns == 4) {
                            nt >>= 1;
                        } else if (this.columns < 4) {
                            nt >>= 2;
                        }
                        t2 = new float[nt];
                        if (isgn != -1) break block22;
                        if (this.columns <= 4) break block23;
                        for (int c2 = 0; c2 < this.columns; c2 += 8) {
                            int idx5;
                            int idx4;
                            int idx32;
                            int idx23;
                            int r4;
                            for (r4 = 0; r4 < this.rows; ++r4) {
                                idx23 = 2 * r4;
                                idx32 = 2 * this.rows + 2 * r4;
                                idx4 = idx32 + 2 * this.rows;
                                idx5 = idx4 + 2 * this.rows;
                                t2[idx23] = a2[r4][c2];
                                t2[idx23 + 1] = a2[r4][c2 + 1];
                                t2[idx32] = a2[r4][c2 + 2];
                                t2[idx32 + 1] = a2[r4][c2 + 3];
                                t2[idx4] = a2[r4][c2 + 4];
                                t2[idx4 + 1] = a2[r4][c2 + 5];
                                t2[idx5] = a2[r4][c2 + 6];
                                t2[idx5 + 1] = a2[r4][c2 + 7];
                            }
                            this.fftRows.complexForward(t2, 0);
                            this.fftRows.complexForward(t2, 2 * this.rows);
                            this.fftRows.complexForward(t2, 4 * this.rows);
                            this.fftRows.complexForward(t2, 6 * this.rows);
                            for (r4 = 0; r4 < this.rows; ++r4) {
                                idx23 = 2 * r4;
                                idx32 = 2 * this.rows + 2 * r4;
                                idx4 = idx32 + 2 * this.rows;
                                idx5 = idx4 + 2 * this.rows;
                                a2[r4][c2] = t2[idx23];
                                a2[r4][c2 + 1] = t2[idx23 + 1];
                                a2[r4][c2 + 2] = t2[idx32];
                                a2[r4][c2 + 3] = t2[idx32 + 1];
                                a2[r4][c2 + 4] = t2[idx4];
                                a2[r4][c2 + 5] = t2[idx4 + 1];
                                a2[r4][c2 + 6] = t2[idx5];
                                a2[r4][c2 + 7] = t2[idx5 + 1];
                            }
                        }
                        break block24;
                    }
                    if (this.columns != 4) break block25;
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        idx22 = 2 * r3;
                        idx3 = 2 * this.rows + 2 * r3;
                        t2[idx22] = a2[r3][0];
                        t2[idx22 + 1] = a2[r3][1];
                        t2[idx3] = a2[r3][2];
                        t2[idx3 + 1] = a2[r3][3];
                    }
                    this.fftRows.complexForward(t2, 0);
                    this.fftRows.complexForward(t2, 2 * this.rows);
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        idx22 = 2 * r3;
                        idx3 = 2 * this.rows + 2 * r3;
                        a2[r3][0] = t2[idx22];
                        a2[r3][1] = t2[idx22 + 1];
                        a2[r3][2] = t2[idx3];
                        a2[r3][3] = t2[idx3 + 1];
                    }
                    break block24;
                }
                if (this.columns != 2) break block24;
                for (r2 = 0; r2 < this.rows; ++r2) {
                    idx2 = 2 * r2;
                    t2[idx2] = a2[r2][0];
                    t2[idx2 + 1] = a2[r2][1];
                }
                this.fftRows.complexForward(t2, 0);
                for (r2 = 0; r2 < this.rows; ++r2) {
                    idx2 = 2 * r2;
                    a2[r2][0] = t2[idx2];
                    a2[r2][1] = t2[idx2 + 1];
                }
                break block24;
            }
            if (this.columns > 4) {
                for (int c3 = 0; c3 < this.columns; c3 += 8) {
                    int idx5;
                    int idx4;
                    int idx3;
                    int idx2;
                    int r5;
                    for (r5 = 0; r5 < this.rows; ++r5) {
                        idx2 = 2 * r5;
                        idx3 = 2 * this.rows + 2 * r5;
                        idx4 = idx3 + 2 * this.rows;
                        idx5 = idx4 + 2 * this.rows;
                        t2[idx2] = a2[r5][c3];
                        t2[idx2 + 1] = a2[r5][c3 + 1];
                        t2[idx3] = a2[r5][c3 + 2];
                        t2[idx3 + 1] = a2[r5][c3 + 3];
                        t2[idx4] = a2[r5][c3 + 4];
                        t2[idx4 + 1] = a2[r5][c3 + 5];
                        t2[idx5] = a2[r5][c3 + 6];
                        t2[idx5 + 1] = a2[r5][c3 + 7];
                    }
                    this.fftRows.complexInverse(t2, 0, scale);
                    this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                    this.fftRows.complexInverse(t2, 4 * this.rows, scale);
                    this.fftRows.complexInverse(t2, 6 * this.rows, scale);
                    for (r5 = 0; r5 < this.rows; ++r5) {
                        idx2 = 2 * r5;
                        idx3 = 2 * this.rows + 2 * r5;
                        idx4 = idx3 + 2 * this.rows;
                        idx5 = idx4 + 2 * this.rows;
                        a2[r5][c3] = t2[idx2];
                        a2[r5][c3 + 1] = t2[idx2 + 1];
                        a2[r5][c3 + 2] = t2[idx3];
                        a2[r5][c3 + 3] = t2[idx3 + 1];
                        a2[r5][c3 + 4] = t2[idx4];
                        a2[r5][c3 + 5] = t2[idx4 + 1];
                        a2[r5][c3 + 6] = t2[idx5];
                        a2[r5][c3 + 7] = t2[idx5 + 1];
                    }
                }
            } else if (this.columns == 4) {
                int idx3;
                int idx2;
                int r6;
                for (r6 = 0; r6 < this.rows; ++r6) {
                    idx2 = 2 * r6;
                    idx3 = 2 * this.rows + 2 * r6;
                    t2[idx2] = a2[r6][0];
                    t2[idx2 + 1] = a2[r6][1];
                    t2[idx3] = a2[r6][2];
                    t2[idx3 + 1] = a2[r6][3];
                }
                this.fftRows.complexInverse(t2, 0, scale);
                this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                for (r6 = 0; r6 < this.rows; ++r6) {
                    idx2 = 2 * r6;
                    idx3 = 2 * this.rows + 2 * r6;
                    a2[r6][0] = t2[idx2];
                    a2[r6][1] = t2[idx2 + 1];
                    a2[r6][2] = t2[idx3];
                    a2[r6][3] = t2[idx3 + 1];
                }
            } else if (this.columns == 2) {
                int idx2;
                int r7;
                for (r7 = 0; r7 < this.rows; ++r7) {
                    idx2 = 2 * r7;
                    t2[idx2] = a2[r7][0];
                    t2[idx2 + 1] = a2[r7][1];
                }
                this.fftRows.complexInverse(t2, 0, scale);
                for (r7 = 0; r7 < this.rows; ++r7) {
                    idx2 = 2 * r7;
                    a2[r7][0] = t2[idx2];
                    a2[r7][1] = t2[idx2 + 1];
                }
            }
        }
    }

    private void xdft2d0_subth1(final int icr, final int isgn, final float[] a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (icr == 0) {
                        if (isgn == -1) {
                            for (int r2 = n0; r2 < FloatFFT_2D.this.rows; r2 += nthreads) {
                                FloatFFT_2D.this.fftColumns.complexForward(a2, r2 * FloatFFT_2D.this.columns);
                            }
                        } else {
                            for (int r3 = n0; r3 < FloatFFT_2D.this.rows; r3 += nthreads) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a2, r3 * FloatFFT_2D.this.columns, scale);
                            }
                        }
                    } else if (isgn == 1) {
                        for (int r4 = n0; r4 < FloatFFT_2D.this.rows; r4 += nthreads) {
                            FloatFFT_2D.this.fftColumns.realForward(a2, r4 * FloatFFT_2D.this.columns);
                        }
                    } else {
                        for (int r5 = n0; r5 < FloatFFT_2D.this.rows; r5 += nthreads) {
                            FloatFFT_2D.this.fftColumns.realInverse(a2, r5 * FloatFFT_2D.this.columns, scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void xdft2d0_subth1(final long icr, final int isgn, final FloatLargeArray a2, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (icr == 0L) {
                        if (isgn == -1) {
                            for (long r2 = (long)n0; r2 < FloatFFT_2D.this.rowsl; r2 += (long)nthreads) {
                                FloatFFT_2D.this.fftColumns.complexForward(a2, r2 * FloatFFT_2D.this.columnsl);
                            }
                        } else {
                            for (long r3 = (long)n0; r3 < FloatFFT_2D.this.rowsl; r3 += (long)nthreads) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a2, r3 * FloatFFT_2D.this.columnsl, scale);
                            }
                        }
                    } else if (isgn == 1) {
                        for (long r4 = (long)n0; r4 < FloatFFT_2D.this.rowsl; r4 += (long)nthreads) {
                            FloatFFT_2D.this.fftColumns.realForward(a2, r4 * FloatFFT_2D.this.columnsl);
                        }
                    } else {
                        for (long r5 = (long)n0; r5 < FloatFFT_2D.this.rowsl; r5 += (long)nthreads) {
                            FloatFFT_2D.this.fftColumns.realInverse(a2, r5 * FloatFFT_2D.this.columnsl, scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void xdft2d0_subth2(final int icr, final int isgn, final float[] a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (icr == 0) {
                        if (isgn == -1) {
                            for (int r2 = n0; r2 < FloatFFT_2D.this.rows; r2 += nthreads) {
                                FloatFFT_2D.this.fftColumns.complexForward(a2, r2 * FloatFFT_2D.this.columns);
                            }
                        } else {
                            for (int r3 = n0; r3 < FloatFFT_2D.this.rows; r3 += nthreads) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a2, r3 * FloatFFT_2D.this.columns, scale);
                            }
                        }
                    } else if (isgn == 1) {
                        for (int r4 = n0; r4 < FloatFFT_2D.this.rows; r4 += nthreads) {
                            FloatFFT_2D.this.fftColumns.realForward(a2, r4 * FloatFFT_2D.this.columns);
                        }
                    } else {
                        for (int r5 = n0; r5 < FloatFFT_2D.this.rows; r5 += nthreads) {
                            FloatFFT_2D.this.fftColumns.realInverse2(a2, r5 * FloatFFT_2D.this.columns, scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void xdft2d0_subth2(final long icr, final int isgn, final FloatLargeArray a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final long n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (icr == 0L) {
                        if (isgn == -1) {
                            for (long r2 = n0; r2 < FloatFFT_2D.this.rowsl; r2 += (long)nthreads) {
                                FloatFFT_2D.this.fftColumns.complexForward(a2, r2 * FloatFFT_2D.this.columnsl);
                            }
                        } else {
                            for (long r3 = n0; r3 < FloatFFT_2D.this.rowsl; r3 += (long)nthreads) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a2, r3 * FloatFFT_2D.this.columnsl, scale);
                            }
                        }
                    } else if (isgn == 1) {
                        for (long r4 = n0; r4 < FloatFFT_2D.this.rowsl; r4 += (long)nthreads) {
                            FloatFFT_2D.this.fftColumns.realForward(a2, r4 * FloatFFT_2D.this.columnsl);
                        }
                    } else {
                        for (long r5 = n0; r5 < FloatFFT_2D.this.rowsl; r5 += (long)nthreads) {
                            FloatFFT_2D.this.fftColumns.realInverse2(a2, r5 * FloatFFT_2D.this.columnsl, scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void xdft2d0_subth1(final int icr, final int isgn, final float[][] a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (icr == 0) {
                        if (isgn == -1) {
                            for (int r2 = n0; r2 < FloatFFT_2D.this.rows; r2 += nthreads) {
                                FloatFFT_2D.this.fftColumns.complexForward(a2[r2]);
                            }
                        } else {
                            for (int r3 = n0; r3 < FloatFFT_2D.this.rows; r3 += nthreads) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a2[r3], scale);
                            }
                        }
                    } else if (isgn == 1) {
                        for (int r4 = n0; r4 < FloatFFT_2D.this.rows; r4 += nthreads) {
                            FloatFFT_2D.this.fftColumns.realForward(a2[r4]);
                        }
                    } else {
                        for (int r5 = n0; r5 < FloatFFT_2D.this.rows; r5 += nthreads) {
                            FloatFFT_2D.this.fftColumns.realInverse(a2[r5], scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void xdft2d0_subth2(final int icr, final int isgn, final float[][] a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (icr == 0) {
                        if (isgn == -1) {
                            for (int r2 = n0; r2 < FloatFFT_2D.this.rows; r2 += nthreads) {
                                FloatFFT_2D.this.fftColumns.complexForward(a2[r2]);
                            }
                        } else {
                            for (int r3 = n0; r3 < FloatFFT_2D.this.rows; r3 += nthreads) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a2[r3], scale);
                            }
                        }
                    } else if (isgn == 1) {
                        for (int r4 = n0; r4 < FloatFFT_2D.this.rows; r4 += nthreads) {
                            FloatFFT_2D.this.fftColumns.realForward(a2[r4]);
                        }
                    } else {
                        for (int r5 = n0; r5 < FloatFFT_2D.this.rows; r5 += nthreads) {
                            FloatFFT_2D.this.fftColumns.realInverse2(a2[r5], 0, scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void cdft2d_subth(final int isgn, final float[] a2, final boolean scale) {
        int nthread = FastMath.min((int)(this.columns / 2), (int)ConcurrencyUtils.getNumberOfThreads());
        int nt = 8 * this.rows;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthread];
        final int nthreads = nthread;
        for (int i2 = 0; i2 < nthread; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block21: {
                        float[] t2;
                        block19: {
                            int idx2;
                            int idx1;
                            int r2;
                            block22: {
                                int idx3;
                                int idx22;
                                int idx12;
                                int r3;
                                block20: {
                                    t2 = new float[ntf];
                                    if (isgn != -1) break block19;
                                    if (FloatFFT_2D.this.columns <= 4 * nthreads) break block20;
                                    for (int c2 = 8 * n0; c2 < FloatFFT_2D.this.columns; c2 += 8 * nthreads) {
                                        int idx5;
                                        int idx4;
                                        int idx32;
                                        int idx23;
                                        int idx13;
                                        int r4;
                                        for (r4 = 0; r4 < FloatFFT_2D.this.rows; ++r4) {
                                            idx13 = r4 * FloatFFT_2D.this.columns + c2;
                                            idx23 = 2 * r4;
                                            idx32 = 2 * FloatFFT_2D.this.rows + 2 * r4;
                                            idx4 = idx32 + 2 * FloatFFT_2D.this.rows;
                                            idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                            t2[idx23] = a2[idx13];
                                            t2[idx23 + 1] = a2[idx13 + 1];
                                            t2[idx32] = a2[idx13 + 2];
                                            t2[idx32 + 1] = a2[idx13 + 3];
                                            t2[idx4] = a2[idx13 + 4];
                                            t2[idx4 + 1] = a2[idx13 + 5];
                                            t2[idx5] = a2[idx13 + 6];
                                            t2[idx5 + 1] = a2[idx13 + 7];
                                        }
                                        FloatFFT_2D.this.fftRows.complexForward(t2, 0);
                                        FloatFFT_2D.this.fftRows.complexForward(t2, 2 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(t2, 4 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(t2, 6 * FloatFFT_2D.this.rows);
                                        for (r4 = 0; r4 < FloatFFT_2D.this.rows; ++r4) {
                                            idx13 = r4 * FloatFFT_2D.this.columns + c2;
                                            idx23 = 2 * r4;
                                            idx32 = 2 * FloatFFT_2D.this.rows + 2 * r4;
                                            idx4 = idx32 + 2 * FloatFFT_2D.this.rows;
                                            idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                            a2[idx13] = t2[idx23];
                                            a2[idx13 + 1] = t2[idx23 + 1];
                                            a2[idx13 + 2] = t2[idx32];
                                            a2[idx13 + 3] = t2[idx32 + 1];
                                            a2[idx13 + 4] = t2[idx4];
                                            a2[idx13 + 5] = t2[idx4 + 1];
                                            a2[idx13 + 6] = t2[idx5];
                                            a2[idx13 + 7] = t2[idx5 + 1];
                                        }
                                    }
                                    break block21;
                                }
                                if (FloatFFT_2D.this.columns != 4 * nthreads) break block22;
                                for (r3 = 0; r3 < FloatFFT_2D.this.rows; ++r3) {
                                    idx12 = r3 * FloatFFT_2D.this.columns + 4 * n0;
                                    idx22 = 2 * r3;
                                    idx3 = 2 * FloatFFT_2D.this.rows + 2 * r3;
                                    t2[idx22] = a2[idx12];
                                    t2[idx22 + 1] = a2[idx12 + 1];
                                    t2[idx3] = a2[idx12 + 2];
                                    t2[idx3 + 1] = a2[idx12 + 3];
                                }
                                FloatFFT_2D.this.fftRows.complexForward(t2, 0);
                                FloatFFT_2D.this.fftRows.complexForward(t2, 2 * FloatFFT_2D.this.rows);
                                for (r3 = 0; r3 < FloatFFT_2D.this.rows; ++r3) {
                                    idx12 = r3 * FloatFFT_2D.this.columns + 4 * n0;
                                    idx22 = 2 * r3;
                                    idx3 = 2 * FloatFFT_2D.this.rows + 2 * r3;
                                    a2[idx12] = t2[idx22];
                                    a2[idx12 + 1] = t2[idx22 + 1];
                                    a2[idx12 + 2] = t2[idx3];
                                    a2[idx12 + 3] = t2[idx3 + 1];
                                }
                                break block21;
                            }
                            if (FloatFFT_2D.this.columns != 2 * nthreads) break block21;
                            for (r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                idx1 = r2 * FloatFFT_2D.this.columns + 2 * n0;
                                idx2 = 2 * r2;
                                t2[idx2] = a2[idx1];
                                t2[idx2 + 1] = a2[idx1 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(t2, 0);
                            for (r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                idx1 = r2 * FloatFFT_2D.this.columns + 2 * n0;
                                idx2 = 2 * r2;
                                a2[idx1] = t2[idx2];
                                a2[idx1 + 1] = t2[idx2 + 1];
                            }
                            break block21;
                        }
                        if (FloatFFT_2D.this.columns > 4 * nthreads) {
                            for (int c3 = 8 * n0; c3 < FloatFFT_2D.this.columns; c3 += 8 * nthreads) {
                                int idx5;
                                int idx4;
                                int idx3;
                                int idx2;
                                int idx1;
                                int r5;
                                for (r5 = 0; r5 < FloatFFT_2D.this.rows; ++r5) {
                                    idx1 = r5 * FloatFFT_2D.this.columns + c3;
                                    idx2 = 2 * r5;
                                    idx3 = 2 * FloatFFT_2D.this.rows + 2 * r5;
                                    idx4 = idx3 + 2 * FloatFFT_2D.this.rows;
                                    idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                    t2[idx2] = a2[idx1];
                                    t2[idx2 + 1] = a2[idx1 + 1];
                                    t2[idx3] = a2[idx1 + 2];
                                    t2[idx3 + 1] = a2[idx1 + 3];
                                    t2[idx4] = a2[idx1 + 4];
                                    t2[idx4 + 1] = a2[idx1 + 5];
                                    t2[idx5] = a2[idx1 + 6];
                                    t2[idx5 + 1] = a2[idx1 + 7];
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(t2, 0, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(t2, 2 * FloatFFT_2D.this.rows, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(t2, 4 * FloatFFT_2D.this.rows, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(t2, 6 * FloatFFT_2D.this.rows, scale);
                                for (r5 = 0; r5 < FloatFFT_2D.this.rows; ++r5) {
                                    idx1 = r5 * FloatFFT_2D.this.columns + c3;
                                    idx2 = 2 * r5;
                                    idx3 = 2 * FloatFFT_2D.this.rows + 2 * r5;
                                    idx4 = idx3 + 2 * FloatFFT_2D.this.rows;
                                    idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                    a2[idx1] = t2[idx2];
                                    a2[idx1 + 1] = t2[idx2 + 1];
                                    a2[idx1 + 2] = t2[idx3];
                                    a2[idx1 + 3] = t2[idx3 + 1];
                                    a2[idx1 + 4] = t2[idx4];
                                    a2[idx1 + 5] = t2[idx4 + 1];
                                    a2[idx1 + 6] = t2[idx5];
                                    a2[idx1 + 7] = t2[idx5 + 1];
                                }
                            }
                        } else if (FloatFFT_2D.this.columns == 4 * nthreads) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r6;
                            for (r6 = 0; r6 < FloatFFT_2D.this.rows; ++r6) {
                                idx1 = r6 * FloatFFT_2D.this.columns + 4 * n0;
                                idx2 = 2 * r6;
                                idx3 = 2 * FloatFFT_2D.this.rows + 2 * r6;
                                t2[idx2] = a2[idx1];
                                t2[idx2 + 1] = a2[idx1 + 1];
                                t2[idx3] = a2[idx1 + 2];
                                t2[idx3 + 1] = a2[idx1 + 3];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(t2, 0, scale);
                            FloatFFT_2D.this.fftRows.complexInverse(t2, 2 * FloatFFT_2D.this.rows, scale);
                            for (r6 = 0; r6 < FloatFFT_2D.this.rows; ++r6) {
                                idx1 = r6 * FloatFFT_2D.this.columns + 4 * n0;
                                idx2 = 2 * r6;
                                idx3 = 2 * FloatFFT_2D.this.rows + 2 * r6;
                                a2[idx1] = t2[idx2];
                                a2[idx1 + 1] = t2[idx2 + 1];
                                a2[idx1 + 2] = t2[idx3];
                                a2[idx1 + 3] = t2[idx3 + 1];
                            }
                        } else if (FloatFFT_2D.this.columns == 2 * nthreads) {
                            int idx2;
                            int idx1;
                            int r7;
                            for (r7 = 0; r7 < FloatFFT_2D.this.rows; ++r7) {
                                idx1 = r7 * FloatFFT_2D.this.columns + 2 * n0;
                                idx2 = 2 * r7;
                                t2[idx2] = a2[idx1];
                                t2[idx2 + 1] = a2[idx1 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(t2, 0, scale);
                            for (r7 = 0; r7 < FloatFFT_2D.this.rows; ++r7) {
                                idx1 = r7 * FloatFFT_2D.this.columns + 2 * n0;
                                idx2 = 2 * r7;
                                a2[idx1] = t2[idx2];
                                a2[idx1 + 1] = t2[idx2 + 1];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void cdft2d_subth(final int isgn, final FloatLargeArray a2, final boolean scale) {
        int nthread = (int)FastMath.min((long)(this.columnsl / 2L), (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 8L * this.rowsl;
        if (this.columnsl == 4L) {
            nt >>= 1;
        } else if (this.columnsl < 4L) {
            nt >>= 2;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthread];
        final int nthreads = nthread;
        for (int i2 = 0; i2 < nthread; ++i2) {
            final long n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block21: {
                        FloatLargeArray t2;
                        block19: {
                            long idx2;
                            long idx1;
                            long r2;
                            block22: {
                                long idx3;
                                long idx22;
                                long idx12;
                                long r3;
                                block20: {
                                    t2 = new FloatLargeArray(ntf);
                                    if (isgn != -1) break block19;
                                    if (FloatFFT_2D.this.columnsl <= (long)(4 * nthreads)) break block20;
                                    for (long c2 = 8L * n0; c2 < FloatFFT_2D.this.columnsl; c2 += (long)(8 * nthreads)) {
                                        long idx5;
                                        long idx4;
                                        long idx32;
                                        long idx23;
                                        long idx13;
                                        long r4;
                                        for (r4 = 0L; r4 < FloatFFT_2D.this.rowsl; ++r4) {
                                            idx13 = r4 * FloatFFT_2D.this.columnsl + c2;
                                            idx23 = 2L * r4;
                                            idx32 = 2L * FloatFFT_2D.this.rowsl + 2L * r4;
                                            idx4 = idx32 + 2L * FloatFFT_2D.this.rowsl;
                                            idx5 = idx4 + 2L * FloatFFT_2D.this.rowsl;
                                            t2.setDouble(idx23, a2.getFloat(idx13));
                                            t2.setDouble(idx23 + 1L, a2.getFloat(idx13 + 1L));
                                            t2.setDouble(idx32, a2.getFloat(idx13 + 2L));
                                            t2.setDouble(idx32 + 1L, a2.getFloat(idx13 + 3L));
                                            t2.setDouble(idx4, a2.getFloat(idx13 + 4L));
                                            t2.setDouble(idx4 + 1L, a2.getFloat(idx13 + 5L));
                                            t2.setDouble(idx5, a2.getFloat(idx13 + 6L));
                                            t2.setDouble(idx5 + 1L, a2.getFloat(idx13 + 7L));
                                        }
                                        FloatFFT_2D.this.fftRows.complexForward(t2, 0L);
                                        FloatFFT_2D.this.fftRows.complexForward(t2, 2L * FloatFFT_2D.this.rowsl);
                                        FloatFFT_2D.this.fftRows.complexForward(t2, 4L * FloatFFT_2D.this.rowsl);
                                        FloatFFT_2D.this.fftRows.complexForward(t2, 6L * FloatFFT_2D.this.rowsl);
                                        for (r4 = 0L; r4 < FloatFFT_2D.this.rowsl; ++r4) {
                                            idx13 = r4 * FloatFFT_2D.this.columnsl + c2;
                                            idx23 = 2L * r4;
                                            idx32 = 2L * FloatFFT_2D.this.rowsl + 2L * r4;
                                            idx4 = idx32 + 2L * FloatFFT_2D.this.rowsl;
                                            idx5 = idx4 + 2L * FloatFFT_2D.this.rowsl;
                                            a2.setDouble(idx13, t2.getFloat(idx23));
                                            a2.setDouble(idx13 + 1L, t2.getFloat(idx23 + 1L));
                                            a2.setDouble(idx13 + 2L, t2.getFloat(idx32));
                                            a2.setDouble(idx13 + 3L, t2.getFloat(idx32 + 1L));
                                            a2.setDouble(idx13 + 4L, t2.getFloat(idx4));
                                            a2.setDouble(idx13 + 5L, t2.getFloat(idx4 + 1L));
                                            a2.setDouble(idx13 + 6L, t2.getFloat(idx5));
                                            a2.setDouble(idx13 + 7L, t2.getFloat(idx5 + 1L));
                                        }
                                    }
                                    break block21;
                                }
                                if (FloatFFT_2D.this.columnsl != (long)(4 * nthreads)) break block22;
                                for (r3 = 0L; r3 < FloatFFT_2D.this.rowsl; ++r3) {
                                    idx12 = r3 * FloatFFT_2D.this.columnsl + 4L * n0;
                                    idx22 = 2L * r3;
                                    idx3 = 2L * FloatFFT_2D.this.rowsl + 2L * r3;
                                    t2.setDouble(idx22, a2.getFloat(idx12));
                                    t2.setDouble(idx22 + 1L, a2.getFloat(idx12 + 1L));
                                    t2.setDouble(idx3, a2.getFloat(idx12 + 2L));
                                    t2.setDouble(idx3 + 1L, a2.getFloat(idx12 + 3L));
                                }
                                FloatFFT_2D.this.fftRows.complexForward(t2, 0L);
                                FloatFFT_2D.this.fftRows.complexForward(t2, 2L * FloatFFT_2D.this.rowsl);
                                for (r3 = 0L; r3 < FloatFFT_2D.this.rowsl; ++r3) {
                                    idx12 = r3 * FloatFFT_2D.this.columnsl + 4L * n0;
                                    idx22 = 2L * r3;
                                    idx3 = 2L * FloatFFT_2D.this.rowsl + 2L * r3;
                                    a2.setDouble(idx12, t2.getFloat(idx22));
                                    a2.setDouble(idx12 + 1L, t2.getFloat(idx22 + 1L));
                                    a2.setDouble(idx12 + 2L, t2.getFloat(idx3));
                                    a2.setDouble(idx12 + 3L, t2.getFloat(idx3 + 1L));
                                }
                                break block21;
                            }
                            if (FloatFFT_2D.this.columnsl != (long)(2 * nthreads)) break block21;
                            for (r2 = 0L; r2 < FloatFFT_2D.this.rowsl; ++r2) {
                                idx1 = r2 * FloatFFT_2D.this.columnsl + 2L * n0;
                                idx2 = 2L * r2;
                                t2.setDouble(idx2, a2.getFloat(idx1));
                                t2.setDouble(idx2 + 1L, a2.getFloat(idx1 + 1L));
                            }
                            FloatFFT_2D.this.fftRows.complexForward(t2, 0L);
                            for (r2 = 0L; r2 < FloatFFT_2D.this.rowsl; ++r2) {
                                idx1 = r2 * FloatFFT_2D.this.columnsl + 2L * n0;
                                idx2 = 2L * r2;
                                a2.setDouble(idx1, t2.getFloat(idx2));
                                a2.setDouble(idx1 + 1L, t2.getFloat(idx2 + 1L));
                            }
                            break block21;
                        }
                        if (FloatFFT_2D.this.columnsl > (long)(4 * nthreads)) {
                            for (long c3 = 8L * n0; c3 < FloatFFT_2D.this.columnsl; c3 += (long)(8 * nthreads)) {
                                long idx5;
                                long idx4;
                                long idx3;
                                long idx2;
                                long idx1;
                                long r5;
                                for (r5 = 0L; r5 < FloatFFT_2D.this.rowsl; ++r5) {
                                    idx1 = r5 * FloatFFT_2D.this.columnsl + c3;
                                    idx2 = 2L * r5;
                                    idx3 = 2L * FloatFFT_2D.this.rowsl + 2L * r5;
                                    idx4 = idx3 + 2L * FloatFFT_2D.this.rowsl;
                                    idx5 = idx4 + 2L * FloatFFT_2D.this.rowsl;
                                    t2.setDouble(idx2, a2.getFloat(idx1));
                                    t2.setDouble(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                    t2.setDouble(idx3, a2.getFloat(idx1 + 2L));
                                    t2.setDouble(idx3 + 1L, a2.getFloat(idx1 + 3L));
                                    t2.setDouble(idx4, a2.getFloat(idx1 + 4L));
                                    t2.setDouble(idx4 + 1L, a2.getFloat(idx1 + 5L));
                                    t2.setDouble(idx5, a2.getFloat(idx1 + 6L));
                                    t2.setDouble(idx5 + 1L, a2.getFloat(idx1 + 7L));
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(t2, 0L, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(t2, 2L * FloatFFT_2D.this.rowsl, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(t2, 4L * FloatFFT_2D.this.rowsl, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(t2, 6L * FloatFFT_2D.this.rowsl, scale);
                                for (r5 = 0L; r5 < FloatFFT_2D.this.rowsl; ++r5) {
                                    idx1 = r5 * FloatFFT_2D.this.columnsl + c3;
                                    idx2 = 2L * r5;
                                    idx3 = 2L * FloatFFT_2D.this.rowsl + 2L * r5;
                                    idx4 = idx3 + 2L * FloatFFT_2D.this.rowsl;
                                    idx5 = idx4 + 2L * FloatFFT_2D.this.rowsl;
                                    a2.setDouble(idx1, t2.getFloat(idx2));
                                    a2.setDouble(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                    a2.setDouble(idx1 + 2L, t2.getFloat(idx3));
                                    a2.setDouble(idx1 + 3L, t2.getFloat(idx3 + 1L));
                                    a2.setDouble(idx1 + 4L, t2.getFloat(idx4));
                                    a2.setDouble(idx1 + 5L, t2.getFloat(idx4 + 1L));
                                    a2.setDouble(idx1 + 6L, t2.getFloat(idx5));
                                    a2.setDouble(idx1 + 7L, t2.getFloat(idx5 + 1L));
                                }
                            }
                        } else if (FloatFFT_2D.this.columnsl == (long)(4 * nthreads)) {
                            long idx3;
                            long idx2;
                            long idx1;
                            long r6;
                            for (r6 = 0L; r6 < FloatFFT_2D.this.rowsl; ++r6) {
                                idx1 = r6 * FloatFFT_2D.this.columnsl + 4L * n0;
                                idx2 = 2L * r6;
                                idx3 = 2L * FloatFFT_2D.this.rowsl + 2L * r6;
                                t2.setDouble(idx2, a2.getFloat(idx1));
                                t2.setDouble(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                t2.setDouble(idx3, a2.getFloat(idx1 + 2L));
                                t2.setDouble(idx3 + 1L, a2.getFloat(idx1 + 3L));
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(t2, 0L, scale);
                            FloatFFT_2D.this.fftRows.complexInverse(t2, 2L * FloatFFT_2D.this.rowsl, scale);
                            for (r6 = 0L; r6 < FloatFFT_2D.this.rowsl; ++r6) {
                                idx1 = r6 * FloatFFT_2D.this.columnsl + 4L * n0;
                                idx2 = 2L * r6;
                                idx3 = 2L * FloatFFT_2D.this.rowsl + 2L * r6;
                                a2.setDouble(idx1, t2.getFloat(idx2));
                                a2.setDouble(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                a2.setDouble(idx1 + 2L, t2.getFloat(idx3));
                                a2.setDouble(idx1 + 3L, t2.getFloat(idx3 + 1L));
                            }
                        } else if (FloatFFT_2D.this.columnsl == (long)(2 * nthreads)) {
                            long idx2;
                            long idx1;
                            long r7;
                            for (r7 = 0L; r7 < FloatFFT_2D.this.rowsl; ++r7) {
                                idx1 = r7 * FloatFFT_2D.this.columnsl + 2L * n0;
                                idx2 = 2L * r7;
                                t2.setDouble(idx2, a2.getFloat(idx1));
                                t2.setDouble(idx2 + 1L, a2.getFloat(idx1 + 1L));
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(t2, 0L, scale);
                            for (r7 = 0L; r7 < FloatFFT_2D.this.rowsl; ++r7) {
                                idx1 = r7 * FloatFFT_2D.this.columnsl + 2L * n0;
                                idx2 = 2L * r7;
                                a2.setDouble(idx1, t2.getFloat(idx2));
                                a2.setDouble(idx1 + 1L, t2.getFloat(idx2 + 1L));
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void cdft2d_subth(final int isgn, final float[][] a2, final boolean scale) {
        int nthread = FastMath.min((int)(this.columns / 2), (int)ConcurrencyUtils.getNumberOfThreads());
        int nt = 8 * this.rows;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthread];
        final int nthreads = nthread;
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block21: {
                        float[] t2;
                        block19: {
                            int idx2;
                            int r2;
                            block22: {
                                int idx3;
                                int idx22;
                                int r3;
                                block20: {
                                    t2 = new float[ntf];
                                    if (isgn != -1) break block19;
                                    if (FloatFFT_2D.this.columns <= 4 * nthreads) break block20;
                                    for (int c2 = 8 * n0; c2 < FloatFFT_2D.this.columns; c2 += 8 * nthreads) {
                                        int idx5;
                                        int idx4;
                                        int idx32;
                                        int idx23;
                                        int r4;
                                        for (r4 = 0; r4 < FloatFFT_2D.this.rows; ++r4) {
                                            idx23 = 2 * r4;
                                            idx32 = 2 * FloatFFT_2D.this.rows + 2 * r4;
                                            idx4 = idx32 + 2 * FloatFFT_2D.this.rows;
                                            idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                            t2[idx23] = a2[r4][c2];
                                            t2[idx23 + 1] = a2[r4][c2 + 1];
                                            t2[idx32] = a2[r4][c2 + 2];
                                            t2[idx32 + 1] = a2[r4][c2 + 3];
                                            t2[idx4] = a2[r4][c2 + 4];
                                            t2[idx4 + 1] = a2[r4][c2 + 5];
                                            t2[idx5] = a2[r4][c2 + 6];
                                            t2[idx5 + 1] = a2[r4][c2 + 7];
                                        }
                                        FloatFFT_2D.this.fftRows.complexForward(t2, 0);
                                        FloatFFT_2D.this.fftRows.complexForward(t2, 2 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(t2, 4 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(t2, 6 * FloatFFT_2D.this.rows);
                                        for (r4 = 0; r4 < FloatFFT_2D.this.rows; ++r4) {
                                            idx23 = 2 * r4;
                                            idx32 = 2 * FloatFFT_2D.this.rows + 2 * r4;
                                            idx4 = idx32 + 2 * FloatFFT_2D.this.rows;
                                            idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                            a2[r4][c2] = t2[idx23];
                                            a2[r4][c2 + 1] = t2[idx23 + 1];
                                            a2[r4][c2 + 2] = t2[idx32];
                                            a2[r4][c2 + 3] = t2[idx32 + 1];
                                            a2[r4][c2 + 4] = t2[idx4];
                                            a2[r4][c2 + 5] = t2[idx4 + 1];
                                            a2[r4][c2 + 6] = t2[idx5];
                                            a2[r4][c2 + 7] = t2[idx5 + 1];
                                        }
                                    }
                                    break block21;
                                }
                                if (FloatFFT_2D.this.columns != 4 * nthreads) break block22;
                                for (r3 = 0; r3 < FloatFFT_2D.this.rows; ++r3) {
                                    idx22 = 2 * r3;
                                    idx3 = 2 * FloatFFT_2D.this.rows + 2 * r3;
                                    t2[idx22] = a2[r3][4 * n0];
                                    t2[idx22 + 1] = a2[r3][4 * n0 + 1];
                                    t2[idx3] = a2[r3][4 * n0 + 2];
                                    t2[idx3 + 1] = a2[r3][4 * n0 + 3];
                                }
                                FloatFFT_2D.this.fftRows.complexForward(t2, 0);
                                FloatFFT_2D.this.fftRows.complexForward(t2, 2 * FloatFFT_2D.this.rows);
                                for (r3 = 0; r3 < FloatFFT_2D.this.rows; ++r3) {
                                    idx22 = 2 * r3;
                                    idx3 = 2 * FloatFFT_2D.this.rows + 2 * r3;
                                    a2[r3][4 * n0] = t2[idx22];
                                    a2[r3][4 * n0 + 1] = t2[idx22 + 1];
                                    a2[r3][4 * n0 + 2] = t2[idx3];
                                    a2[r3][4 * n0 + 3] = t2[idx3 + 1];
                                }
                                break block21;
                            }
                            if (FloatFFT_2D.this.columns != 2 * nthreads) break block21;
                            for (r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                idx2 = 2 * r2;
                                t2[idx2] = a2[r2][2 * n0];
                                t2[idx2 + 1] = a2[r2][2 * n0 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(t2, 0);
                            for (r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                idx2 = 2 * r2;
                                a2[r2][2 * n0] = t2[idx2];
                                a2[r2][2 * n0 + 1] = t2[idx2 + 1];
                            }
                            break block21;
                        }
                        if (FloatFFT_2D.this.columns > 4 * nthreads) {
                            for (int c3 = 8 * n0; c3 < FloatFFT_2D.this.columns; c3 += 8 * nthreads) {
                                int idx5;
                                int idx4;
                                int idx3;
                                int idx2;
                                int r5;
                                for (r5 = 0; r5 < FloatFFT_2D.this.rows; ++r5) {
                                    idx2 = 2 * r5;
                                    idx3 = 2 * FloatFFT_2D.this.rows + 2 * r5;
                                    idx4 = idx3 + 2 * FloatFFT_2D.this.rows;
                                    idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                    t2[idx2] = a2[r5][c3];
                                    t2[idx2 + 1] = a2[r5][c3 + 1];
                                    t2[idx3] = a2[r5][c3 + 2];
                                    t2[idx3 + 1] = a2[r5][c3 + 3];
                                    t2[idx4] = a2[r5][c3 + 4];
                                    t2[idx4 + 1] = a2[r5][c3 + 5];
                                    t2[idx5] = a2[r5][c3 + 6];
                                    t2[idx5 + 1] = a2[r5][c3 + 7];
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(t2, 0, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(t2, 2 * FloatFFT_2D.this.rows, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(t2, 4 * FloatFFT_2D.this.rows, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(t2, 6 * FloatFFT_2D.this.rows, scale);
                                for (r5 = 0; r5 < FloatFFT_2D.this.rows; ++r5) {
                                    idx2 = 2 * r5;
                                    idx3 = 2 * FloatFFT_2D.this.rows + 2 * r5;
                                    idx4 = idx3 + 2 * FloatFFT_2D.this.rows;
                                    idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                    a2[r5][c3] = t2[idx2];
                                    a2[r5][c3 + 1] = t2[idx2 + 1];
                                    a2[r5][c3 + 2] = t2[idx3];
                                    a2[r5][c3 + 3] = t2[idx3 + 1];
                                    a2[r5][c3 + 4] = t2[idx4];
                                    a2[r5][c3 + 5] = t2[idx4 + 1];
                                    a2[r5][c3 + 6] = t2[idx5];
                                    a2[r5][c3 + 7] = t2[idx5 + 1];
                                }
                            }
                        } else if (FloatFFT_2D.this.columns == 4 * nthreads) {
                            int idx3;
                            int idx2;
                            int r6;
                            for (r6 = 0; r6 < FloatFFT_2D.this.rows; ++r6) {
                                idx2 = 2 * r6;
                                idx3 = 2 * FloatFFT_2D.this.rows + 2 * r6;
                                t2[idx2] = a2[r6][4 * n0];
                                t2[idx2 + 1] = a2[r6][4 * n0 + 1];
                                t2[idx3] = a2[r6][4 * n0 + 2];
                                t2[idx3 + 1] = a2[r6][4 * n0 + 3];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(t2, 0, scale);
                            FloatFFT_2D.this.fftRows.complexInverse(t2, 2 * FloatFFT_2D.this.rows, scale);
                            for (r6 = 0; r6 < FloatFFT_2D.this.rows; ++r6) {
                                idx2 = 2 * r6;
                                idx3 = 2 * FloatFFT_2D.this.rows + 2 * r6;
                                a2[r6][4 * n0] = t2[idx2];
                                a2[r6][4 * n0 + 1] = t2[idx2 + 1];
                                a2[r6][4 * n0 + 2] = t2[idx3];
                                a2[r6][4 * n0 + 3] = t2[idx3 + 1];
                            }
                        } else if (FloatFFT_2D.this.columns == 2 * nthreads) {
                            int idx2;
                            int r7;
                            for (r7 = 0; r7 < FloatFFT_2D.this.rows; ++r7) {
                                idx2 = 2 * r7;
                                t2[idx2] = a2[r7][2 * n0];
                                t2[idx2 + 1] = a2[r7][2 * n0 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(t2, 0, scale);
                            for (r7 = 0; r7 < FloatFFT_2D.this.rows; ++r7) {
                                idx2 = 2 * r7;
                                a2[r7][2 * n0] = t2[idx2];
                                a2[r7][2 * n0 + 1] = t2[idx2 + 1];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void fillSymmetric(final float[] a2) {
        int idx2;
        int idx1;
        int twon2 = 2 * this.columns;
        int n1d2 = this.rows / 2;
        for (int r2 = this.rows - 1; r2 >= 1; --r2) {
            idx1 = r2 * this.columns;
            idx2 = 2 * idx1;
            for (int c2 = 0; c2 < this.columns; c2 += 2) {
                a2[idx2 + c2] = a2[idx1 + c2];
                a2[idx1 + c2] = 0.0f;
                a2[idx2 + c2 + 1] = a2[idx1 + c2 + 1];
                a2[idx1 + c2 + 1] = 0.0f;
            }
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= nthreads) {
            Future[] futures = new Future[nthreads];
            int l1k = n1d2 / nthreads;
            final int newn2 = 2 * this.columns;
            for (int i2 = 0; i2 < nthreads; ++i2) {
                final int l1offa = i2 == 0 ? i2 * l1k + 1 : i2 * l1k;
                final int l1stopa = i2 * l1k + l1k;
                final int l2offa = i2 * l1k;
                final int l2stopa = i2 == nthreads - 1 ? i2 * l1k + l1k + 1 : i2 * l1k + l1k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx4;
                        int c2;
                        int idx3;
                        int idx2;
                        int idx1;
                        int r2;
                        for (r2 = l1offa; r2 < l1stopa; ++r2) {
                            idx1 = r2 * newn2;
                            idx2 = (FloatFFT_2D.this.rows - r2) * newn2;
                            idx3 = idx1 + FloatFFT_2D.this.columns;
                            a2[idx3] = a2[idx2 + 1];
                            a2[idx3 + 1] = -a2[idx2];
                        }
                        for (r2 = l1offa; r2 < l1stopa; ++r2) {
                            idx1 = r2 * newn2;
                            idx3 = (FloatFFT_2D.this.rows - r2 + 1) * newn2;
                            for (c2 = FloatFFT_2D.this.columns + 2; c2 < newn2; c2 += 2) {
                                idx2 = idx3 - c2;
                                idx4 = idx1 + c2;
                                a2[idx4] = a2[idx2];
                                a2[idx4 + 1] = -a2[idx2 + 1];
                            }
                        }
                        for (r2 = l2offa; r2 < l2stopa; ++r2) {
                            idx3 = (FloatFFT_2D.this.rows - r2) % FloatFFT_2D.this.rows * newn2;
                            idx4 = r2 * newn2;
                            for (c2 = 0; c2 < newn2; c2 += 2) {
                                idx1 = idx3 + (newn2 - c2) % newn2;
                                idx2 = idx4 + c2;
                                a2[idx1] = a2[idx2];
                                a2[idx1 + 1] = -a2[idx2 + 1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int c3;
            int idx3;
            int r3;
            for (r3 = 1; r3 < n1d2; ++r3) {
                idx2 = r3 * twon2;
                idx3 = (this.rows - r3) * twon2;
                a2[idx2 + this.columns] = a2[idx3 + 1];
                a2[idx2 + this.columns + 1] = -a2[idx3];
            }
            for (r3 = 1; r3 < n1d2; ++r3) {
                idx2 = r3 * twon2;
                idx3 = (this.rows - r3 + 1) * twon2;
                for (c3 = this.columns + 2; c3 < twon2; c3 += 2) {
                    a2[idx2 + c3] = a2[idx3 - c3];
                    a2[idx2 + c3 + 1] = -a2[idx3 - c3 + 1];
                }
            }
            for (r3 = 0; r3 <= this.rows / 2; ++r3) {
                idx1 = r3 * twon2;
                int idx4 = (this.rows - r3) % this.rows * twon2;
                for (c3 = 0; c3 < twon2; c3 += 2) {
                    idx2 = idx1 + c3;
                    idx3 = idx4 + (twon2 - c3) % twon2;
                    a2[idx3] = a2[idx2];
                    a2[idx3 + 1] = -a2[idx2 + 1];
                }
            }
        }
        a2[this.columns] = -a2[1];
        a2[1] = 0.0f;
        idx1 = n1d2 * twon2;
        a2[idx1 + this.columns] = -a2[idx1 + 1];
        a2[idx1 + 1] = 0.0f;
        a2[idx1 + this.columns + 1] = 0.0f;
    }

    private void fillSymmetric(final FloatLargeArray a2) {
        long idx2;
        long idx1;
        long twon2 = 2L * this.columnsl;
        long n1d2 = this.rowsl / 2L;
        for (long r2 = this.rowsl - 1L; r2 >= 1L; --r2) {
            idx1 = r2 * this.columnsl;
            idx2 = 2L * idx1;
            for (long c2 = 0L; c2 < this.columnsl; c2 += 2L) {
                a2.setDouble(idx2 + c2, a2.getFloat(idx1 + c2));
                a2.setDouble(idx1 + c2, 0.0);
                a2.setDouble(idx2 + c2 + 1L, a2.getFloat(idx1 + c2 + 1L));
                a2.setDouble(idx1 + c2 + 1L, 0.0);
            }
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= (long)nthreads) {
            Future[] futures = new Future[nthreads];
            long l1k = n1d2 / (long)nthreads;
            final long newn2 = 2L * this.columnsl;
            for (int i2 = 0; i2 < nthreads; ++i2) {
                final long l1offa = i2 == 0 ? (long)i2 * l1k + 1L : (long)i2 * l1k;
                final long l1stopa = (long)i2 * l1k + l1k;
                final long l2offa = (long)i2 * l1k;
                final long l2stopa = i2 == nthreads - 1 ? (long)i2 * l1k + l1k + 1L : (long)i2 * l1k + l1k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        long idx4;
                        long c2;
                        long idx3;
                        long idx2;
                        long idx1;
                        long r2;
                        for (r2 = l1offa; r2 < l1stopa; ++r2) {
                            idx1 = r2 * newn2;
                            idx2 = (FloatFFT_2D.this.rowsl - r2) * newn2;
                            idx3 = idx1 + FloatFFT_2D.this.columnsl;
                            a2.setDouble(idx3, a2.getFloat(idx2 + 1L));
                            a2.setDouble(idx3 + 1L, -a2.getFloat(idx2));
                        }
                        for (r2 = l1offa; r2 < l1stopa; ++r2) {
                            idx1 = r2 * newn2;
                            idx3 = (FloatFFT_2D.this.rowsl - r2 + 1L) * newn2;
                            for (c2 = FloatFFT_2D.this.columnsl + 2L; c2 < newn2; c2 += 2L) {
                                idx2 = idx3 - c2;
                                idx4 = idx1 + c2;
                                a2.setDouble(idx4, a2.getFloat(idx2));
                                a2.setDouble(idx4 + 1L, -a2.getFloat(idx2 + 1L));
                            }
                        }
                        for (r2 = l2offa; r2 < l2stopa; ++r2) {
                            idx3 = (FloatFFT_2D.this.rowsl - r2) % FloatFFT_2D.this.rowsl * newn2;
                            idx4 = r2 * newn2;
                            for (c2 = 0L; c2 < newn2; c2 += 2L) {
                                idx1 = idx3 + (newn2 - c2) % newn2;
                                idx2 = idx4 + c2;
                                a2.setDouble(idx1, a2.getFloat(idx2));
                                a2.setDouble(idx1 + 1L, -a2.getFloat(idx2 + 1L));
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long c3;
            long idx3;
            long r3;
            for (r3 = 1L; r3 < n1d2; ++r3) {
                idx2 = r3 * twon2;
                idx3 = (this.rowsl - r3) * twon2;
                a2.setDouble(idx2 + this.columnsl, a2.getFloat(idx3 + 1L));
                a2.setDouble(idx2 + this.columnsl + 1L, -a2.getFloat(idx3));
            }
            for (r3 = 1L; r3 < n1d2; ++r3) {
                idx2 = r3 * twon2;
                idx3 = (this.rowsl - r3 + 1L) * twon2;
                for (c3 = this.columnsl + 2L; c3 < twon2; c3 += 2L) {
                    a2.setDouble(idx2 + c3, a2.getFloat(idx3 - c3));
                    a2.setDouble(idx2 + c3 + 1L, -a2.getFloat(idx3 - c3 + 1L));
                }
            }
            for (r3 = 0L; r3 <= this.rowsl / 2L; ++r3) {
                idx1 = r3 * twon2;
                long idx4 = (this.rowsl - r3) % this.rowsl * twon2;
                for (c3 = 0L; c3 < twon2; c3 += 2L) {
                    idx2 = idx1 + c3;
                    idx3 = idx4 + (twon2 - c3) % twon2;
                    a2.setDouble(idx3, a2.getFloat(idx2));
                    a2.setDouble(idx3 + 1L, -a2.getFloat(idx2 + 1L));
                }
            }
        }
        a2.setDouble(this.columnsl, -a2.getFloat(1L));
        a2.setDouble(1L, 0.0);
        idx1 = n1d2 * twon2;
        a2.setDouble(idx1 + this.columnsl, -a2.getFloat(idx1 + 1L));
        a2.setDouble(idx1 + 1L, 0.0);
        a2.setDouble(idx1 + this.columnsl + 1L, 0.0);
    }

    private void fillSymmetric(final float[][] a2) {
        final int newn2 = 2 * this.columns;
        int n1d2 = this.rows / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= nthreads) {
            Future[] futures = new Future[nthreads];
            int l1k = n1d2 / nthreads;
            for (int i2 = 0; i2 < nthreads; ++i2) {
                final int l1offa = i2 == 0 ? i2 * l1k + 1 : i2 * l1k;
                final int l1stopa = i2 * l1k + l1k;
                final int l2offa = i2 * l1k;
                final int l2stopa = i2 == nthreads - 1 ? i2 * l1k + l1k + 1 : i2 * l1k + l1k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx2;
                        int c2;
                        int idx1;
                        int r2;
                        for (r2 = l1offa; r2 < l1stopa; ++r2) {
                            idx1 = FloatFFT_2D.this.rows - r2;
                            a2[r2][((FloatFFT_2D)FloatFFT_2D.this).columns] = a2[idx1][1];
                            a2[r2][((FloatFFT_2D)FloatFFT_2D.this).columns + 1] = -a2[idx1][0];
                        }
                        for (r2 = l1offa; r2 < l1stopa; ++r2) {
                            idx1 = FloatFFT_2D.this.rows - r2;
                            for (c2 = FloatFFT_2D.this.columns + 2; c2 < newn2; c2 += 2) {
                                idx2 = newn2 - c2;
                                a2[r2][c2] = a2[idx1][idx2];
                                a2[r2][c2 + 1] = -a2[idx1][idx2 + 1];
                            }
                        }
                        for (r2 = l2offa; r2 < l2stopa; ++r2) {
                            idx1 = (FloatFFT_2D.this.rows - r2) % FloatFFT_2D.this.rows;
                            for (c2 = 0; c2 < newn2; c2 += 2) {
                                idx2 = (newn2 - c2) % newn2;
                                a2[idx1][idx2] = a2[r2][c2];
                                a2[idx1][idx2 + 1] = -a2[r2][c2 + 1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_2D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx2;
            int c2;
            int idx1;
            int r2;
            for (r2 = 1; r2 < n1d2; ++r2) {
                idx1 = this.rows - r2;
                a2[r2][this.columns] = a2[idx1][1];
                a2[r2][this.columns + 1] = -a2[idx1][0];
            }
            for (r2 = 1; r2 < n1d2; ++r2) {
                idx1 = this.rows - r2;
                for (c2 = this.columns + 2; c2 < newn2; c2 += 2) {
                    idx2 = newn2 - c2;
                    a2[r2][c2] = a2[idx1][idx2];
                    a2[r2][c2 + 1] = -a2[idx1][idx2 + 1];
                }
            }
            for (r2 = 0; r2 <= this.rows / 2; ++r2) {
                idx1 = (this.rows - r2) % this.rows;
                for (c2 = 0; c2 < newn2; c2 += 2) {
                    idx2 = (newn2 - c2) % newn2;
                    a2[idx1][idx2] = a2[r2][c2];
                    a2[idx1][idx2 + 1] = -a2[r2][c2 + 1];
                }
            }
        }
        a2[0][this.columns] = -a2[0][1];
        a2[0][1] = 0.0f;
        a2[n1d2][this.columns] = -a2[n1d2][1];
        a2[n1d2][1] = 0.0f;
        a2[n1d2][this.columns + 1] = 0.0f;
    }
}

