/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.fft.FloatFFT_1D;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayUtils;

public class FloatFFT_3D {
    private int slices;
    private long slicesl;
    private int rows;
    private long rowsl;
    private int columns;
    private long columnsl;
    private int sliceStride;
    private long sliceStridel;
    private int rowStride;
    private long rowStridel;
    private FloatFFT_1D fftSlices;
    private FloatFFT_1D fftRows;
    private FloatFFT_1D fftColumns;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatFFT_3D(long slices, long rows, long columns) {
        if (slices <= 1L || rows <= 1L || columns <= 1L) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = (int)slices;
        this.rows = (int)rows;
        this.columns = (int)columns;
        this.slicesl = slices;
        this.rowsl = rows;
        this.columnsl = columns;
        this.sliceStride = (int)(rows * columns);
        this.rowStride = (int)columns;
        this.sliceStridel = rows * columns;
        this.rowStridel = columns;
        if (slices * rows * columns >= CommonUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (CommonUtils.isPowerOf2(slices) && CommonUtils.isPowerOf2(rows) && CommonUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
        }
        CommonUtils.setUseLargeArrays(2L * slices * rows * columns > (long)LargeArray.getMaxSizeOf32bitArray());
        this.fftSlices = new FloatFFT_1D(slices);
        this.fftRows = slices == rows ? this.fftSlices : new FloatFFT_1D(rows);
        this.fftColumns = slices == columns ? this.fftSlices : (rows == columns ? this.fftRows : new FloatFFT_1D(columns));
    }

    public void complexForward(final float[] a2) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn3 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0, -1, a2, true);
                this.cdft3db_subth(-1, a2, true);
            } else {
                this.xdft3da_sub2(0, -1, a2, true);
                this.cdft3db_sub(-1, a2, true);
            }
            this.columns = oldn3;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else {
            this.sliceStride = 2 * this.rows * this.columns;
            this.rowStride = 2 * this.columns;
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p2 = this.slices / nthreads;
                for (int l2 = 0; l2 < nthreads; ++l2) {
                    firstSlice = l2 * p2;
                    lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p2;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                                int idx1 = s2 * FloatFFT_3D.this.sliceStride;
                                for (int r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    FloatFFT_3D.this.fftColumns.complexForward(a2, idx1 + r2 * FloatFFT_3D.this.rowStride);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l3 = 0; l3 < nthreads; ++l3) {
                    firstSlice = l3 * p2;
                    lastSlice = l3 == nthreads - 1 ? this.slices : firstSlice + p2;
                    futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[2 * FloatFFT_3D.this.rows];
                            for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                                int idx1 = s2 * FloatFFT_3D.this.sliceStride;
                                for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                    int idx4;
                                    int idx3;
                                    int r2;
                                    int idx2 = 2 * c2;
                                    for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                        idx3 = idx1 + idx2 + r2 * FloatFFT_3D.this.rowStride;
                                        idx4 = 2 * r2;
                                        temp[idx4] = a2[idx3];
                                        temp[idx4 + 1] = a2[idx3 + 1];
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(temp);
                                    for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                        idx3 = idx1 + idx2 + r2 * FloatFFT_3D.this.rowStride;
                                        idx4 = 2 * r2;
                                        a2[idx3] = temp[idx4];
                                        a2[idx3 + 1] = temp[idx4 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p2 = this.rows / nthreads;
                for (int l4 = 0; l4 < nthreads; ++l4) {
                    final int firstRow = l4 * p2;
                    final int lastRow = l4 == nthreads - 1 ? this.rows : firstRow + p2;
                    futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[2 * FloatFFT_3D.this.slices];
                            for (int r2 = firstRow; r2 < lastRow; ++r2) {
                                int idx1 = r2 * FloatFFT_3D.this.rowStride;
                                for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                    int idx4;
                                    int idx3;
                                    int s2;
                                    int idx2 = 2 * c2;
                                    for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                        idx3 = s2 * FloatFFT_3D.this.sliceStride + idx1 + idx2;
                                        idx4 = 2 * s2;
                                        temp[idx4] = a2[idx3];
                                        temp[idx4 + 1] = a2[idx3 + 1];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexForward(temp);
                                    for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                        idx3 = s2 * FloatFFT_3D.this.sliceStride + idx1 + idx2;
                                        idx4 = 2 * s2;
                                        a2[idx3] = temp[idx4];
                                        a2[idx3 + 1] = temp[idx4 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int idx4;
                int idx3;
                int idx2;
                int c2;
                int idx1;
                for (int s2 = 0; s2 < this.slices; ++s2) {
                    int idx12 = s2 * this.sliceStride;
                    for (int r2 = 0; r2 < this.rows; ++r2) {
                        this.fftColumns.complexForward(a2, idx12 + r2 * this.rowStride);
                    }
                }
                float[] temp = new float[2 * this.rows];
                for (int s3 = 0; s3 < this.slices; ++s3) {
                    idx1 = s3 * this.sliceStride;
                    for (c2 = 0; c2 < this.columns; ++c2) {
                        int r3;
                        idx2 = 2 * c2;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx3 = idx1 + idx2 + r3 * this.rowStride;
                            idx4 = 2 * r3;
                            temp[idx4] = a2[idx3];
                            temp[idx4 + 1] = a2[idx3 + 1];
                        }
                        this.fftRows.complexForward(temp);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx3 = idx1 + idx2 + r3 * this.rowStride;
                            idx4 = 2 * r3;
                            a2[idx3] = temp[idx4];
                            a2[idx3 + 1] = temp[idx4 + 1];
                        }
                    }
                }
                temp = new float[2 * this.slices];
                for (int r4 = 0; r4 < this.rows; ++r4) {
                    idx1 = r4 * this.rowStride;
                    for (c2 = 0; c2 < this.columns; ++c2) {
                        int s4;
                        idx2 = 2 * c2;
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx3 = s4 * this.sliceStride + idx1 + idx2;
                            idx4 = 2 * s4;
                            temp[idx4] = a2[idx3];
                            temp[idx4 + 1] = a2[idx3 + 1];
                        }
                        this.fftSlices.complexForward(temp);
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx3 = s4 * this.sliceStride + idx1 + idx2;
                            idx4 = 2 * s4;
                            a2[idx3] = temp[idx4];
                            a2[idx3 + 1] = temp[idx4 + 1];
                        }
                    }
                }
            }
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        }
    }

    public void complexForward(final FloatLargeArray a2) {
        if (!a2.isLarge() && !a2.isConstant()) {
            this.complexForward(a2.getData());
        } else {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (this.isPowerOfTwo) {
                long oldn3 = this.columnsl;
                this.columnsl = 2L * this.columnsl;
                this.sliceStridel = this.rowsl * this.columnsl;
                this.rowStridel = this.columnsl;
                if (nthreads > 1 && this.useThreads) {
                    this.xdft3da_subth2(0L, -1, a2, true);
                    this.cdft3db_subth(-1, a2, true);
                } else {
                    this.xdft3da_sub2(0L, -1, a2, true);
                    this.cdft3db_sub(-1, a2, true);
                }
                this.columnsl = oldn3;
                this.sliceStridel = this.rowsl * this.columnsl;
                this.rowStridel = this.columnsl;
            } else {
                this.sliceStridel = 2L * this.rowsl * this.columnsl;
                this.rowStridel = 2L * this.columnsl;
                if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                    long lastSlice;
                    long firstSlice;
                    Future[] futures = new Future[nthreads];
                    long p2 = this.slicesl / (long)nthreads;
                    for (int l2 = 0; l2 < nthreads; ++l2) {
                        firstSlice = (long)l2 * p2;
                        lastSlice = l2 == nthreads - 1 ? this.slicesl : firstSlice + p2;
                        futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                            @Override
                            public void run() {
                                for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                                    long idx1 = s2 * FloatFFT_3D.this.sliceStridel;
                                    for (long r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                        FloatFFT_3D.this.fftColumns.complexForward(a2, idx1 + r2 * FloatFFT_3D.this.rowStridel);
                                    }
                                }
                            }
                        });
                    }
                    try {
                        ConcurrencyUtils.waitForCompletion(futures);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (ExecutionException ex) {
                        Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    for (int l3 = 0; l3 < nthreads; ++l3) {
                        firstSlice = (long)l3 * p2;
                        lastSlice = l3 == nthreads - 1 ? this.slicesl : firstSlice + p2;
                        futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                            @Override
                            public void run() {
                                FloatLargeArray temp = new FloatLargeArray(2L * FloatFFT_3D.this.rowsl, false);
                                for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                                    long idx1 = s2 * FloatFFT_3D.this.sliceStridel;
                                    for (long c2 = 0L; c2 < FloatFFT_3D.this.columnsl; ++c2) {
                                        long idx4;
                                        long idx3;
                                        long r2;
                                        long idx2 = 2L * c2;
                                        for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                            idx3 = idx1 + idx2 + r2 * FloatFFT_3D.this.rowStridel;
                                            idx4 = 2L * r2;
                                            temp.setFloat(idx4, a2.getFloat(idx3));
                                            temp.setFloat(idx4 + 1L, a2.getFloat(idx3 + 1L));
                                        }
                                        FloatFFT_3D.this.fftRows.complexForward(temp);
                                        for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                            idx3 = idx1 + idx2 + r2 * FloatFFT_3D.this.rowStridel;
                                            idx4 = 2L * r2;
                                            a2.setFloat(idx3, temp.getFloat(idx4));
                                            a2.setFloat(idx3 + 1L, temp.getFloat(idx4 + 1L));
                                        }
                                    }
                                }
                            }
                        });
                    }
                    try {
                        ConcurrencyUtils.waitForCompletion(futures);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (ExecutionException ex) {
                        Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    p2 = this.rowsl / (long)nthreads;
                    for (int l4 = 0; l4 < nthreads; ++l4) {
                        final long firstRow = (long)l4 * p2;
                        final long lastRow = l4 == nthreads - 1 ? this.rowsl : firstRow + p2;
                        futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                            @Override
                            public void run() {
                                FloatLargeArray temp = new FloatLargeArray(2L * FloatFFT_3D.this.slicesl, false);
                                for (long r2 = firstRow; r2 < lastRow; ++r2) {
                                    long idx1 = r2 * FloatFFT_3D.this.rowStridel;
                                    for (long c2 = 0L; c2 < FloatFFT_3D.this.columnsl; ++c2) {
                                        long idx4;
                                        long idx3;
                                        long s2;
                                        long idx2 = 2L * c2;
                                        for (s2 = 0L; s2 < FloatFFT_3D.this.slicesl; ++s2) {
                                            idx3 = s2 * FloatFFT_3D.this.sliceStridel + idx1 + idx2;
                                            idx4 = 2L * s2;
                                            temp.setFloat(idx4, a2.getFloat(idx3));
                                            temp.setFloat(idx4 + 1L, a2.getFloat(idx3 + 1L));
                                        }
                                        FloatFFT_3D.this.fftSlices.complexForward(temp);
                                        for (s2 = 0L; s2 < FloatFFT_3D.this.slicesl; ++s2) {
                                            idx3 = s2 * FloatFFT_3D.this.sliceStridel + idx1 + idx2;
                                            idx4 = 2L * s2;
                                            a2.setFloat(idx3, temp.getFloat(idx4));
                                            a2.setFloat(idx3 + 1L, temp.getFloat(idx4 + 1L));
                                        }
                                    }
                                }
                            }
                        });
                    }
                    try {
                        ConcurrencyUtils.waitForCompletion(futures);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (ExecutionException ex) {
                        Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    long idx4;
                    long idx3;
                    long idx2;
                    long c2;
                    long idx1;
                    for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                        long idx12 = s2 * this.sliceStridel;
                        for (long r2 = 0L; r2 < this.rowsl; ++r2) {
                            this.fftColumns.complexForward(a2, idx12 + r2 * this.rowStridel);
                        }
                    }
                    FloatLargeArray temp = new FloatLargeArray(2L * this.rowsl, false);
                    for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                        idx1 = s3 * this.sliceStridel;
                        for (c2 = 0L; c2 < this.columnsl; ++c2) {
                            long r3;
                            idx2 = 2L * c2;
                            for (r3 = 0L; r3 < this.rowsl; ++r3) {
                                idx3 = idx1 + idx2 + r3 * this.rowStridel;
                                idx4 = 2L * r3;
                                temp.setFloat(idx4, a2.getFloat(idx3));
                                temp.setFloat(idx4 + 1L, a2.getFloat(idx3 + 1L));
                            }
                            this.fftRows.complexForward(temp);
                            for (r3 = 0L; r3 < this.rowsl; ++r3) {
                                idx3 = idx1 + idx2 + r3 * this.rowStridel;
                                idx4 = 2L * r3;
                                a2.setFloat(idx3, temp.getFloat(idx4));
                                a2.setFloat(idx3 + 1L, temp.getFloat(idx4 + 1L));
                            }
                        }
                    }
                    temp = new FloatLargeArray(2L * this.slicesl, false);
                    for (long r4 = 0L; r4 < this.rowsl; ++r4) {
                        idx1 = r4 * this.rowStridel;
                        for (c2 = 0L; c2 < this.columnsl; ++c2) {
                            long s4;
                            idx2 = 2L * c2;
                            for (s4 = 0L; s4 < this.slicesl; ++s4) {
                                idx3 = s4 * this.sliceStridel + idx1 + idx2;
                                idx4 = 2L * s4;
                                temp.setFloat(idx4, a2.getFloat(idx3));
                                temp.setFloat(idx4 + 1L, a2.getFloat(idx3 + 1L));
                            }
                            this.fftSlices.complexForward(temp);
                            for (s4 = 0L; s4 < this.slicesl; ++s4) {
                                idx3 = s4 * this.sliceStridel + idx1 + idx2;
                                idx4 = 2L * s4;
                                a2.setFloat(idx3, temp.getFloat(idx4));
                                a2.setFloat(idx3 + 1L, temp.getFloat(idx4 + 1L));
                            }
                        }
                    }
                }
                this.sliceStridel = this.rowsl * this.columnsl;
                this.rowStridel = this.columnsl;
            }
        }
    }

    public void complexForward(final float[][][] a2) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn3 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0, -1, a2, true);
                this.cdft3db_subth(-1, a2, true);
            } else {
                this.xdft3da_sub2(0, -1, a2, true);
                this.cdft3db_sub(-1, a2, true);
            }
            this.columns = oldn3;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p2 = this.slices / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstSlice = l2 * p2;
                lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                FloatFFT_3D.this.fftColumns.complexForward(a2[s2][r2]);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = l3 * p2;
                lastSlice = l3 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                int idx4;
                                int r2;
                                int idx2 = 2 * c2;
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx4 = 2 * r2;
                                    temp[idx4] = a2[s2][r2][idx2];
                                    temp[idx4 + 1] = a2[s2][r2][idx2 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(temp);
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx4 = 2 * r2;
                                    a2[s2][r2][idx2] = temp[idx4];
                                    a2[s2][r2][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.rows / nthreads;
            for (int l4 = 0; l4 < nthreads; ++l4) {
                final int firstRow = l4 * p2;
                final int lastRow = l4 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.slices];
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                int idx4;
                                int s2;
                                int idx2 = 2 * c2;
                                for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                    idx4 = 2 * s2;
                                    temp[idx4] = a2[s2][r2][idx2];
                                    temp[idx4 + 1] = a2[s2][r2][idx2 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(temp);
                                for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                    idx4 = 2 * s2;
                                    a2[s2][r2][idx2] = temp[idx4];
                                    a2[s2][r2][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx4;
            int idx2;
            int c2;
            int r2;
            for (int s2 = 0; s2 < this.slices; ++s2) {
                for (r2 = 0; r2 < this.rows; ++r2) {
                    this.fftColumns.complexForward(a2[s2][r2]);
                }
            }
            float[] temp = new float[2 * this.rows];
            for (int s3 = 0; s3 < this.slices; ++s3) {
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int r3;
                    idx2 = 2 * c2;
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        idx4 = 2 * r3;
                        temp[idx4] = a2[s3][r3][idx2];
                        temp[idx4 + 1] = a2[s3][r3][idx2 + 1];
                    }
                    this.fftRows.complexForward(temp);
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        idx4 = 2 * r3;
                        a2[s3][r3][idx2] = temp[idx4];
                        a2[s3][r3][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new float[2 * this.slices];
            for (r2 = 0; r2 < this.rows; ++r2) {
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int s4;
                    idx2 = 2 * c2;
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx4 = 2 * s4;
                        temp[idx4] = a2[s4][r2][idx2];
                        temp[idx4 + 1] = a2[s4][r2][idx2 + 1];
                    }
                    this.fftSlices.complexForward(temp);
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx4 = 2 * s4;
                        a2[s4][r2][idx2] = temp[idx4];
                        a2[s4][r2][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
        }
    }

    public void complexInverse(final float[] a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn3 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0, 1, a2, scale);
                this.cdft3db_subth(1, a2, scale);
            } else {
                this.xdft3da_sub2(0, 1, a2, scale);
                this.cdft3db_sub(1, a2, scale);
            }
            this.columns = oldn3;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else {
            this.sliceStride = 2 * this.rows * this.columns;
            this.rowStride = 2 * this.columns;
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p2 = this.slices / nthreads;
                for (int l2 = 0; l2 < nthreads; ++l2) {
                    firstSlice = l2 * p2;
                    lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p2;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                                int idx1 = s2 * FloatFFT_3D.this.sliceStride;
                                for (int r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(a2, idx1 + r2 * FloatFFT_3D.this.rowStride, scale);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l3 = 0; l3 < nthreads; ++l3) {
                    firstSlice = l3 * p2;
                    lastSlice = l3 == nthreads - 1 ? this.slices : firstSlice + p2;
                    futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[2 * FloatFFT_3D.this.rows];
                            for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                                int idx1 = s2 * FloatFFT_3D.this.sliceStride;
                                for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                    int idx4;
                                    int idx3;
                                    int r2;
                                    int idx2 = 2 * c2;
                                    for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                        idx3 = idx1 + idx2 + r2 * FloatFFT_3D.this.rowStride;
                                        idx4 = 2 * r2;
                                        temp[idx4] = a2[idx3];
                                        temp[idx4 + 1] = a2[idx3 + 1];
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(temp, scale);
                                    for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                        idx3 = idx1 + idx2 + r2 * FloatFFT_3D.this.rowStride;
                                        idx4 = 2 * r2;
                                        a2[idx3] = temp[idx4];
                                        a2[idx3 + 1] = temp[idx4 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p2 = this.rows / nthreads;
                for (int l4 = 0; l4 < nthreads; ++l4) {
                    final int firstRow = l4 * p2;
                    final int lastRow = l4 == nthreads - 1 ? this.rows : firstRow + p2;
                    futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[2 * FloatFFT_3D.this.slices];
                            for (int r2 = firstRow; r2 < lastRow; ++r2) {
                                int idx1 = r2 * FloatFFT_3D.this.rowStride;
                                for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                    int idx4;
                                    int idx3;
                                    int s2;
                                    int idx2 = 2 * c2;
                                    for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                        idx3 = s2 * FloatFFT_3D.this.sliceStride + idx1 + idx2;
                                        idx4 = 2 * s2;
                                        temp[idx4] = a2[idx3];
                                        temp[idx4 + 1] = a2[idx3 + 1];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                    for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                        idx3 = s2 * FloatFFT_3D.this.sliceStride + idx1 + idx2;
                                        idx4 = 2 * s2;
                                        a2[idx3] = temp[idx4];
                                        a2[idx3 + 1] = temp[idx4 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int idx4;
                int idx3;
                int idx2;
                int c2;
                int idx1;
                for (int s2 = 0; s2 < this.slices; ++s2) {
                    int idx12 = s2 * this.sliceStride;
                    for (int r2 = 0; r2 < this.rows; ++r2) {
                        this.fftColumns.complexInverse(a2, idx12 + r2 * this.rowStride, scale);
                    }
                }
                float[] temp = new float[2 * this.rows];
                for (int s3 = 0; s3 < this.slices; ++s3) {
                    idx1 = s3 * this.sliceStride;
                    for (c2 = 0; c2 < this.columns; ++c2) {
                        int r3;
                        idx2 = 2 * c2;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx3 = idx1 + idx2 + r3 * this.rowStride;
                            idx4 = 2 * r3;
                            temp[idx4] = a2[idx3];
                            temp[idx4 + 1] = a2[idx3 + 1];
                        }
                        this.fftRows.complexInverse(temp, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx3 = idx1 + idx2 + r3 * this.rowStride;
                            idx4 = 2 * r3;
                            a2[idx3] = temp[idx4];
                            a2[idx3 + 1] = temp[idx4 + 1];
                        }
                    }
                }
                temp = new float[2 * this.slices];
                for (int r4 = 0; r4 < this.rows; ++r4) {
                    idx1 = r4 * this.rowStride;
                    for (c2 = 0; c2 < this.columns; ++c2) {
                        int s4;
                        idx2 = 2 * c2;
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx3 = s4 * this.sliceStride + idx1 + idx2;
                            idx4 = 2 * s4;
                            temp[idx4] = a2[idx3];
                            temp[idx4 + 1] = a2[idx3 + 1];
                        }
                        this.fftSlices.complexInverse(temp, scale);
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx3 = s4 * this.sliceStride + idx1 + idx2;
                            idx4 = 2 * s4;
                            a2[idx3] = temp[idx4];
                            a2[idx3 + 1] = temp[idx4 + 1];
                        }
                    }
                }
            }
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        }
    }

    public void complexInverse(final FloatLargeArray a2, final boolean scale) {
        if (!a2.isLarge() && !a2.isConstant()) {
            this.complexInverse(a2.getData(), scale);
        } else {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (this.isPowerOfTwo) {
                long oldn3 = this.columnsl;
                this.columnsl = 2L * this.columnsl;
                this.sliceStridel = this.rowsl * this.columnsl;
                this.rowStridel = this.columnsl;
                if (nthreads > 1 && this.useThreads) {
                    this.xdft3da_subth2(0L, 1, a2, scale);
                    this.cdft3db_subth(1, a2, scale);
                } else {
                    this.xdft3da_sub2(0L, 1, a2, scale);
                    this.cdft3db_sub(1, a2, scale);
                }
                this.columnsl = oldn3;
                this.sliceStridel = this.rowsl * this.columnsl;
                this.rowStridel = this.columnsl;
            } else {
                this.sliceStridel = 2L * this.rowsl * this.columnsl;
                this.rowStridel = 2L * this.columnsl;
                if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                    long lastSlice;
                    long firstSlice;
                    Future[] futures = new Future[nthreads];
                    long p2 = this.slicesl / (long)nthreads;
                    for (int l2 = 0; l2 < nthreads; ++l2) {
                        firstSlice = (long)l2 * p2;
                        lastSlice = l2 == nthreads - 1 ? this.slicesl : firstSlice + p2;
                        futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                            @Override
                            public void run() {
                                for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                                    long idx1 = s2 * FloatFFT_3D.this.sliceStridel;
                                    for (long r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                        FloatFFT_3D.this.fftColumns.complexInverse(a2, idx1 + r2 * FloatFFT_3D.this.rowStridel, scale);
                                    }
                                }
                            }
                        });
                    }
                    try {
                        ConcurrencyUtils.waitForCompletion(futures);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (ExecutionException ex) {
                        Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    for (int l3 = 0; l3 < nthreads; ++l3) {
                        firstSlice = (long)l3 * p2;
                        lastSlice = l3 == nthreads - 1 ? this.slicesl : firstSlice + p2;
                        futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                            @Override
                            public void run() {
                                FloatLargeArray temp = new FloatLargeArray(2L * FloatFFT_3D.this.rowsl, false);
                                for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                                    long idx1 = s2 * FloatFFT_3D.this.sliceStridel;
                                    for (long c2 = 0L; c2 < FloatFFT_3D.this.columnsl; ++c2) {
                                        long idx4;
                                        long idx3;
                                        long r2;
                                        long idx2 = 2L * c2;
                                        for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                            idx3 = idx1 + idx2 + r2 * FloatFFT_3D.this.rowStridel;
                                            idx4 = 2L * r2;
                                            temp.setFloat(idx4, a2.getFloat(idx3));
                                            temp.setFloat(idx4 + 1L, a2.getFloat(idx3 + 1L));
                                        }
                                        FloatFFT_3D.this.fftRows.complexInverse(temp, scale);
                                        for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                            idx3 = idx1 + idx2 + r2 * FloatFFT_3D.this.rowStridel;
                                            idx4 = 2L * r2;
                                            a2.setFloat(idx3, temp.getFloat(idx4));
                                            a2.setFloat(idx3 + 1L, temp.getFloat(idx4 + 1L));
                                        }
                                    }
                                }
                            }
                        });
                    }
                    try {
                        ConcurrencyUtils.waitForCompletion(futures);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (ExecutionException ex) {
                        Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    p2 = this.rowsl / (long)nthreads;
                    for (int l4 = 0; l4 < nthreads; ++l4) {
                        final long firstRow = (long)l4 * p2;
                        final long lastRow = l4 == nthreads - 1 ? this.rowsl : firstRow + p2;
                        futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                            @Override
                            public void run() {
                                FloatLargeArray temp = new FloatLargeArray(2L * FloatFFT_3D.this.slicesl, false);
                                for (long r2 = firstRow; r2 < lastRow; ++r2) {
                                    long idx1 = r2 * FloatFFT_3D.this.rowStridel;
                                    for (long c2 = 0L; c2 < FloatFFT_3D.this.columnsl; ++c2) {
                                        long idx4;
                                        long idx3;
                                        long s2;
                                        long idx2 = 2L * c2;
                                        for (s2 = 0L; s2 < FloatFFT_3D.this.slicesl; ++s2) {
                                            idx3 = s2 * FloatFFT_3D.this.sliceStridel + idx1 + idx2;
                                            idx4 = 2L * s2;
                                            temp.setFloat(idx4, a2.getFloat(idx3));
                                            temp.setFloat(idx4 + 1L, a2.getFloat(idx3 + 1L));
                                        }
                                        FloatFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                        for (s2 = 0L; s2 < FloatFFT_3D.this.slicesl; ++s2) {
                                            idx3 = s2 * FloatFFT_3D.this.sliceStridel + idx1 + idx2;
                                            idx4 = 2L * s2;
                                            a2.setFloat(idx3, temp.getFloat(idx4));
                                            a2.setFloat(idx3 + 1L, temp.getFloat(idx4 + 1L));
                                        }
                                    }
                                }
                            }
                        });
                    }
                    try {
                        ConcurrencyUtils.waitForCompletion(futures);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (ExecutionException ex) {
                        Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    long idx4;
                    long idx3;
                    long idx2;
                    long c2;
                    long idx1;
                    for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                        long idx12 = s2 * this.sliceStridel;
                        for (long r2 = 0L; r2 < this.rowsl; ++r2) {
                            this.fftColumns.complexInverse(a2, idx12 + r2 * this.rowStridel, scale);
                        }
                    }
                    FloatLargeArray temp = new FloatLargeArray(2L * this.rowsl, false);
                    for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                        idx1 = s3 * this.sliceStridel;
                        for (c2 = 0L; c2 < this.columnsl; ++c2) {
                            long r3;
                            idx2 = 2L * c2;
                            for (r3 = 0L; r3 < this.rowsl; ++r3) {
                                idx3 = idx1 + idx2 + r3 * this.rowStridel;
                                idx4 = 2L * r3;
                                temp.setFloat(idx4, a2.getFloat(idx3));
                                temp.setFloat(idx4 + 1L, a2.getFloat(idx3 + 1L));
                            }
                            this.fftRows.complexInverse(temp, scale);
                            for (r3 = 0L; r3 < this.rowsl; ++r3) {
                                idx3 = idx1 + idx2 + r3 * this.rowStridel;
                                idx4 = 2L * r3;
                                a2.setFloat(idx3, temp.getFloat(idx4));
                                a2.setFloat(idx3 + 1L, temp.getFloat(idx4 + 1L));
                            }
                        }
                    }
                    temp = new FloatLargeArray(2L * this.slicesl, false);
                    for (long r4 = 0L; r4 < this.rowsl; ++r4) {
                        idx1 = r4 * this.rowStridel;
                        for (c2 = 0L; c2 < this.columnsl; ++c2) {
                            long s4;
                            idx2 = 2L * c2;
                            for (s4 = 0L; s4 < this.slicesl; ++s4) {
                                idx3 = s4 * this.sliceStridel + idx1 + idx2;
                                idx4 = 2L * s4;
                                temp.setFloat(idx4, a2.getFloat(idx3));
                                temp.setFloat(idx4 + 1L, a2.getFloat(idx3 + 1L));
                            }
                            this.fftSlices.complexInverse(temp, scale);
                            for (s4 = 0L; s4 < this.slicesl; ++s4) {
                                idx3 = s4 * this.sliceStridel + idx1 + idx2;
                                idx4 = 2L * s4;
                                a2.setFloat(idx3, temp.getFloat(idx4));
                                a2.setFloat(idx3 + 1L, temp.getFloat(idx4 + 1L));
                            }
                        }
                    }
                }
                this.sliceStridel = this.rowsl * this.columnsl;
                this.rowStridel = this.columnsl;
            }
        }
    }

    public void complexInverse(final float[][][] a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn3 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0, 1, a2, scale);
                this.cdft3db_subth(1, a2, scale);
            } else {
                this.xdft3da_sub2(0, 1, a2, scale);
                this.cdft3db_sub(1, a2, scale);
            }
            this.columns = oldn3;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p2 = this.slices / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstSlice = l2 * p2;
                lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                FloatFFT_3D.this.fftColumns.complexInverse(a2[s2][r2], scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = l3 * p2;
                lastSlice = l3 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                int idx4;
                                int r2;
                                int idx2 = 2 * c2;
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx4 = 2 * r2;
                                    temp[idx4] = a2[s2][r2][idx2];
                                    temp[idx4 + 1] = a2[s2][r2][idx2 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(temp, scale);
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx4 = 2 * r2;
                                    a2[s2][r2][idx2] = temp[idx4];
                                    a2[s2][r2][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.rows / nthreads;
            for (int l4 = 0; l4 < nthreads; ++l4) {
                final int firstRow = l4 * p2;
                final int lastRow = l4 == nthreads - 1 ? this.rows : firstRow + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.slices];
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                int idx4;
                                int s2;
                                int idx2 = 2 * c2;
                                for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                    idx4 = 2 * s2;
                                    temp[idx4] = a2[s2][r2][idx2];
                                    temp[idx4 + 1] = a2[s2][r2][idx2 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                    idx4 = 2 * s2;
                                    a2[s2][r2][idx2] = temp[idx4];
                                    a2[s2][r2][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx4;
            int idx2;
            int c2;
            int r2;
            for (int s2 = 0; s2 < this.slices; ++s2) {
                for (r2 = 0; r2 < this.rows; ++r2) {
                    this.fftColumns.complexInverse(a2[s2][r2], scale);
                }
            }
            float[] temp = new float[2 * this.rows];
            for (int s3 = 0; s3 < this.slices; ++s3) {
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int r3;
                    idx2 = 2 * c2;
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        idx4 = 2 * r3;
                        temp[idx4] = a2[s3][r3][idx2];
                        temp[idx4 + 1] = a2[s3][r3][idx2 + 1];
                    }
                    this.fftRows.complexInverse(temp, scale);
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        idx4 = 2 * r3;
                        a2[s3][r3][idx2] = temp[idx4];
                        a2[s3][r3][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new float[2 * this.slices];
            for (r2 = 0; r2 < this.rows; ++r2) {
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int s4;
                    idx2 = 2 * c2;
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx4 = 2 * s4;
                        temp[idx4] = a2[s4][r2][idx2];
                        temp[idx4 + 1] = a2[s4][r2][idx2 + 1];
                    }
                    this.fftSlices.complexInverse(temp, scale);
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx4 = 2 * s4;
                        a2[s4][r2][idx2] = temp[idx4];
                        a2[s4][r2][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
        }
    }

    public void realForward(float[] a2) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.xdft3da_subth1(1, -1, a2, true);
            this.cdft3db_subth(-1, a2, true);
            this.rdft3d_sub(1, a2);
        } else {
            this.xdft3da_sub1(1, -1, a2, true);
            this.cdft3db_sub(-1, a2, true);
            this.rdft3d_sub(1, a2);
        }
    }

    public void realForward(FloatLargeArray a2) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.xdft3da_subth1(1L, -1, a2, true);
            this.cdft3db_subth(-1, a2, true);
            this.rdft3d_sub(1, a2);
        } else {
            this.xdft3da_sub1(1L, -1, a2, true);
            this.cdft3db_sub(-1, a2, true);
            this.rdft3d_sub(1, a2);
        }
    }

    public void realForward(float[][][] a2) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.xdft3da_subth1(1, -1, a2, true);
            this.cdft3db_subth(-1, a2, true);
            this.rdft3d_sub(1, a2);
        } else {
            this.xdft3da_sub1(1, -1, a2, true);
            this.cdft3db_sub(-1, a2, true);
            this.rdft3d_sub(1, a2);
        }
    }

    public void realForwardFull(float[] a2) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1, -1, a2, true);
                this.cdft3db_subth(-1, a2, true);
                this.rdft3d_sub(1, a2);
            } else {
                this.xdft3da_sub2(1, -1, a2, true);
                this.cdft3db_sub(-1, a2, true);
                this.rdft3d_sub(1, a2);
            }
            this.fillSymmetric(a2);
        } else {
            this.mixedRadixRealForwardFull(a2);
        }
    }

    public void realForwardFull(FloatLargeArray a2) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1L, -1, a2, true);
                this.cdft3db_subth(-1, a2, true);
                this.rdft3d_sub(1, a2);
            } else {
                this.xdft3da_sub2(1L, -1, a2, true);
                this.cdft3db_sub(-1, a2, true);
                this.rdft3d_sub(1, a2);
            }
            this.fillSymmetric(a2);
        } else {
            this.mixedRadixRealForwardFull(a2);
        }
    }

    public void realForwardFull(float[][][] a2) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1, -1, a2, true);
                this.cdft3db_subth(-1, a2, true);
                this.rdft3d_sub(1, a2);
            } else {
                this.xdft3da_sub2(1, -1, a2, true);
                this.cdft3db_sub(-1, a2, true);
                this.rdft3d_sub(1, a2);
            }
            this.fillSymmetric(a2);
        } else {
            this.mixedRadixRealForwardFull(a2);
        }
    }

    public void realInverse(float[] a2, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.rdft3d_sub(-1, a2);
            this.cdft3db_subth(1, a2, scale);
            this.xdft3da_subth1(1, 1, a2, scale);
        } else {
            this.rdft3d_sub(-1, a2);
            this.cdft3db_sub(1, a2, scale);
            this.xdft3da_sub1(1, 1, a2, scale);
        }
    }

    public void realInverse(FloatLargeArray a2, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.rdft3d_sub(-1, a2);
            this.cdft3db_subth(1, a2, scale);
            this.xdft3da_subth1(1L, 1, a2, scale);
        } else {
            this.rdft3d_sub(-1, a2);
            this.cdft3db_sub(1, a2, scale);
            this.xdft3da_sub1(1L, 1, a2, scale);
        }
    }

    public void realInverse(float[][][] a2, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.rdft3d_sub(-1, a2);
            this.cdft3db_subth(1, a2, scale);
            this.xdft3da_subth1(1, 1, a2, scale);
        } else {
            this.rdft3d_sub(-1, a2);
            this.cdft3db_sub(1, a2, scale);
            this.xdft3da_sub1(1, 1, a2, scale);
        }
    }

    public void realInverseFull(float[] a2, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1, 1, a2, scale);
                this.cdft3db_subth(1, a2, scale);
                this.rdft3d_sub(1, a2);
            } else {
                this.xdft3da_sub2(1, 1, a2, scale);
                this.cdft3db_sub(1, a2, scale);
                this.rdft3d_sub(1, a2);
            }
            this.fillSymmetric(a2);
        } else {
            this.mixedRadixRealInverseFull(a2, scale);
        }
    }

    public void realInverseFull(FloatLargeArray a2, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1L, 1, a2, scale);
                this.cdft3db_subth(1, a2, scale);
                this.rdft3d_sub(1, a2);
            } else {
                this.xdft3da_sub2(1L, 1, a2, scale);
                this.cdft3db_sub(1, a2, scale);
                this.rdft3d_sub(1, a2);
            }
            this.fillSymmetric(a2);
        } else {
            this.mixedRadixRealInverseFull(a2, scale);
        }
    }

    public void realInverseFull(float[][][] a2, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1, 1, a2, scale);
                this.cdft3db_subth(1, a2, scale);
                this.rdft3d_sub(1, a2);
            } else {
                this.xdft3da_sub2(1, 1, a2, scale);
                this.cdft3db_sub(1, a2, scale);
                this.rdft3d_sub(1, a2);
            }
            this.fillSymmetric(a2);
        } else {
            this.mixedRadixRealInverseFull(a2, scale);
        }
    }

    private void mixedRadixRealForwardFull(final float[][][] a2) {
        float[] temp = new float[2 * this.rows];
        int ldimn2 = this.rows / 2 + 1;
        final int newn3 = 2 * this.columns;
        final int n2d2 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.columns >= nthreads && ldimn2 >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p2 = this.slices / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstSlice = l2 * p2;
                lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                FloatFFT_3D.this.fftColumns.realForwardFull(a2[s2][r2]);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = l3 * p2;
                lastSlice = l3 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                int idx4;
                                int r2;
                                int idx2 = 2 * c2;
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx4 = 2 * r2;
                                    temp[idx4] = a2[s2][r2][idx2];
                                    temp[idx4 + 1] = a2[s2][r2][idx2 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(temp);
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx4 = 2 * r2;
                                    a2[s2][r2][idx2] = temp[idx4];
                                    a2[s2][r2][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = ldimn2 / nthreads;
            for (int l4 = 0; l4 < nthreads; ++l4) {
                final int firstRow = l4 * p2;
                final int lastRow = l4 == nthreads - 1 ? ldimn2 : firstRow + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.slices];
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                int idx2;
                                int s2;
                                int idx1 = 2 * c2;
                                for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    temp[idx2] = a2[s2][r2][idx1];
                                    temp[idx2 + 1] = a2[s2][r2][idx1 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(temp);
                                for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    a2[s2][r2][idx1] = temp[idx2];
                                    a2[s2][r2][idx1 + 1] = temp[idx2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.slices / nthreads;
            for (int l5 = 0; l5 < nthreads; ++l5) {
                firstSlice = l5 * p2;
                lastSlice = l5 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx2 = (FloatFFT_3D.this.slices - s2) % FloatFFT_3D.this.slices;
                            for (int r2 = 1; r2 < n2d2; ++r2) {
                                int idx4 = FloatFFT_3D.this.rows - r2;
                                for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                    int idx1 = 2 * c2;
                                    int idx3 = newn3 - idx1;
                                    a2[idx2][idx4][idx3 % newn3] = a2[s2][r2][idx1];
                                    a2[idx2][idx4][(idx3 + 1) % newn3] = -a2[s2][r2][idx1 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int c2;
            int s2;
            for (s2 = 0; s2 < this.slices; ++s2) {
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    this.fftColumns.realForwardFull(a2[s2][r2]);
                }
            }
            for (s2 = 0; s2 < this.slices; ++s2) {
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int idx4;
                    int r3;
                    int idx2 = 2 * c2;
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        idx4 = 2 * r3;
                        temp[idx4] = a2[s2][r3][idx2];
                        temp[idx4 + 1] = a2[s2][r3][idx2 + 1];
                    }
                    this.fftRows.complexForward(temp);
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        idx4 = 2 * r3;
                        a2[s2][r3][idx2] = temp[idx4];
                        a2[s2][r3][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new float[2 * this.slices];
            for (int r4 = 0; r4 < ldimn2; ++r4) {
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int idx2;
                    int s3;
                    int idx1 = 2 * c2;
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx2 = 2 * s3;
                        temp[idx2] = a2[s3][r4][idx1];
                        temp[idx2 + 1] = a2[s3][r4][idx1 + 1];
                    }
                    this.fftSlices.complexForward(temp);
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx2 = 2 * s3;
                        a2[s3][r4][idx1] = temp[idx2];
                        a2[s3][r4][idx1 + 1] = temp[idx2 + 1];
                    }
                }
            }
            for (s2 = 0; s2 < this.slices; ++s2) {
                int idx2 = (this.slices - s2) % this.slices;
                for (int r5 = 1; r5 < n2d2; ++r5) {
                    int idx4 = this.rows - r5;
                    for (int c3 = 0; c3 < this.columns; ++c3) {
                        int idx1 = 2 * c3;
                        int idx3 = newn3 - idx1;
                        a2[idx2][idx4][idx3 % newn3] = a2[s2][r5][idx1];
                        a2[idx2][idx4][(idx3 + 1) % newn3] = -a2[s2][r5][idx1 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[][][] a2, final boolean scale) {
        float[] temp = new float[2 * this.rows];
        int ldimn2 = this.rows / 2 + 1;
        final int newn3 = 2 * this.columns;
        final int n2d2 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.columns >= nthreads && ldimn2 >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p2 = this.slices / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstSlice = l2 * p2;
                lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                FloatFFT_3D.this.fftColumns.realInverseFull(a2[s2][r2], scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = l3 * p2;
                lastSlice = l3 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                int idx4;
                                int r2;
                                int idx2 = 2 * c2;
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx4 = 2 * r2;
                                    temp[idx4] = a2[s2][r2][idx2];
                                    temp[idx4 + 1] = a2[s2][r2][idx2 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(temp, scale);
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx4 = 2 * r2;
                                    a2[s2][r2][idx2] = temp[idx4];
                                    a2[s2][r2][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = ldimn2 / nthreads;
            for (int l4 = 0; l4 < nthreads; ++l4) {
                final int firstRow = l4 * p2;
                final int lastRow = l4 == nthreads - 1 ? ldimn2 : firstRow + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.slices];
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                int idx2;
                                int s2;
                                int idx1 = 2 * c2;
                                for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    temp[idx2] = a2[s2][r2][idx1];
                                    temp[idx2 + 1] = a2[s2][r2][idx1 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    a2[s2][r2][idx1] = temp[idx2];
                                    a2[s2][r2][idx1 + 1] = temp[idx2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.slices / nthreads;
            for (int l5 = 0; l5 < nthreads; ++l5) {
                firstSlice = l5 * p2;
                lastSlice = l5 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx2 = (FloatFFT_3D.this.slices - s2) % FloatFFT_3D.this.slices;
                            for (int r2 = 1; r2 < n2d2; ++r2) {
                                int idx4 = FloatFFT_3D.this.rows - r2;
                                for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                    int idx1 = 2 * c2;
                                    int idx3 = newn3 - idx1;
                                    a2[idx2][idx4][idx3 % newn3] = a2[s2][r2][idx1];
                                    a2[idx2][idx4][(idx3 + 1) % newn3] = -a2[s2][r2][idx1 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int c2;
            int s2;
            for (s2 = 0; s2 < this.slices; ++s2) {
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    this.fftColumns.realInverseFull(a2[s2][r2], scale);
                }
            }
            for (s2 = 0; s2 < this.slices; ++s2) {
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int idx4;
                    int r3;
                    int idx2 = 2 * c2;
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        idx4 = 2 * r3;
                        temp[idx4] = a2[s2][r3][idx2];
                        temp[idx4 + 1] = a2[s2][r3][idx2 + 1];
                    }
                    this.fftRows.complexInverse(temp, scale);
                    for (r3 = 0; r3 < this.rows; ++r3) {
                        idx4 = 2 * r3;
                        a2[s2][r3][idx2] = temp[idx4];
                        a2[s2][r3][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new float[2 * this.slices];
            for (int r4 = 0; r4 < ldimn2; ++r4) {
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int idx2;
                    int s3;
                    int idx1 = 2 * c2;
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx2 = 2 * s3;
                        temp[idx2] = a2[s3][r4][idx1];
                        temp[idx2 + 1] = a2[s3][r4][idx1 + 1];
                    }
                    this.fftSlices.complexInverse(temp, scale);
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx2 = 2 * s3;
                        a2[s3][r4][idx1] = temp[idx2];
                        a2[s3][r4][idx1 + 1] = temp[idx2 + 1];
                    }
                }
            }
            for (s2 = 0; s2 < this.slices; ++s2) {
                int idx2 = (this.slices - s2) % this.slices;
                for (int r5 = 1; r5 < n2d2; ++r5) {
                    int idx4 = this.rows - r5;
                    for (int c3 = 0; c3 < this.columns; ++c3) {
                        int idx1 = 2 * c3;
                        int idx3 = newn3 - idx1;
                        a2[idx2][idx4][idx3 % newn3] = a2[s2][r5][idx1];
                        a2[idx2][idx4][(idx3 + 1) % newn3] = -a2[s2][r5][idx1 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final float[] a2) {
        final int twon3 = 2 * this.columns;
        float[] temp = new float[twon3];
        int ldimn2 = this.rows / 2 + 1;
        final int n2d2 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        final int twoSliceStride = 2 * this.sliceStride;
        final int twoRowStride = 2 * this.rowStride;
        int n1d2 = this.slices / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= nthreads && this.columns >= nthreads && ldimn2 >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p2 = n1d2 / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                final int firstSlice2 = this.slices - 1 - l2 * p2;
                final int lastSlice2 = l2 == nthreads - 1 ? n1d2 + 1 : firstSlice2 - p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[twon3];
                        for (int s2 = firstSlice2; s2 >= lastSlice2; --s2) {
                            int idx1 = s2 * FloatFFT_3D.this.sliceStride;
                            int idx2 = s2 * twoSliceStride;
                            for (int r2 = FloatFFT_3D.this.rows - 1; r2 >= 0; --r2) {
                                System.arraycopy(a2, idx1 + r2 * FloatFFT_3D.this.rowStride, temp, 0, FloatFFT_3D.this.columns);
                                FloatFFT_3D.this.fftColumns.realForwardFull(temp);
                                System.arraycopy(temp, 0, a2, idx2 + r2 * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            final float[][][] temp2 = new float[n1d2 + 1][this.rows][twon3];
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = l3 * p2;
                lastSlice = l3 == nthreads - 1 ? n1d2 + 1 : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * FloatFFT_3D.this.sliceStride;
                            for (int r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                System.arraycopy(a2, idx1 + r2 * FloatFFT_3D.this.rowStride, temp2[s2][r2], 0, FloatFFT_3D.this.columns);
                                FloatFFT_3D.this.fftColumns.realForwardFull(temp2[s2][r2]);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l4 = 0; l4 < nthreads; ++l4) {
                firstSlice = l4 * p2;
                lastSlice = l4 == nthreads - 1 ? n1d2 + 1 : firstSlice + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * twoSliceStride;
                            for (int r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                System.arraycopy(temp2[s2][r2], 0, a2, idx1 + r2 * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.slices / nthreads;
            for (int l5 = 0; l5 < nthreads; ++l5) {
                firstSlice = l5 * p2;
                lastSlice = l5 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * twoSliceStride;
                            for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                int idx4;
                                int idx3;
                                int r2;
                                int idx2 = 2 * c2;
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx3 = idx1 + r2 * twoRowStride + idx2;
                                    idx4 = 2 * r2;
                                    temp[idx4] = a2[idx3];
                                    temp[idx4 + 1] = a2[idx3 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(temp);
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx3 = idx1 + r2 * twoRowStride + idx2;
                                    idx4 = 2 * r2;
                                    a2[idx3] = temp[idx4];
                                    a2[idx3 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = ldimn2 / nthreads;
            for (int l6 = 0; l6 < nthreads; ++l6) {
                final int firstRow = l6 * p2;
                final int lastRow = l6 == nthreads - 1 ? ldimn2 : firstRow + p2;
                futures[l6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.slices];
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            int idx3 = r2 * twoRowStride;
                            for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                int idx4;
                                int idx2;
                                int s2;
                                int idx1 = 2 * c2;
                                for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    idx4 = s2 * twoSliceStride + idx3 + idx1;
                                    temp[idx2] = a2[idx4];
                                    temp[idx2 + 1] = a2[idx4 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(temp);
                                for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    idx4 = s2 * twoSliceStride + idx3 + idx1;
                                    a2[idx4] = temp[idx2];
                                    a2[idx4 + 1] = temp[idx2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.slices / nthreads;
            for (int l7 = 0; l7 < nthreads; ++l7) {
                firstSlice = l7 * p2;
                lastSlice = l7 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx2 = (FloatFFT_3D.this.slices - s2) % FloatFFT_3D.this.slices;
                            int idx5 = idx2 * twoSliceStride;
                            int idx6 = s2 * twoSliceStride;
                            for (int r2 = 1; r2 < n2d2; ++r2) {
                                int idx4 = FloatFFT_3D.this.rows - r2;
                                int idx7 = idx4 * twoRowStride;
                                int idx8 = r2 * twoRowStride;
                                int idx9 = idx5 + idx7;
                                for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                    int idx1 = 2 * c2;
                                    int idx3 = twon3 - idx1;
                                    int idx10 = idx6 + idx8 + idx1;
                                    a2[idx9 + idx3 % twon3] = a2[idx10];
                                    a2[idx9 + (idx3 + 1) % twon3] = -a2[idx10 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx4;
            int r2;
            int c2;
            int idx1;
            int s2;
            for (s2 = this.slices - 1; s2 >= 0; --s2) {
                idx1 = s2 * this.sliceStride;
                int idx2 = s2 * twoSliceStride;
                for (int r3 = this.rows - 1; r3 >= 0; --r3) {
                    System.arraycopy(a2, idx1 + r3 * this.rowStride, temp, 0, this.columns);
                    this.fftColumns.realForwardFull(temp);
                    System.arraycopy(temp, 0, a2, idx2 + r3 * twoRowStride, twon3);
                }
            }
            temp = new float[2 * this.rows];
            for (s2 = 0; s2 < this.slices; ++s2) {
                idx1 = s2 * twoSliceStride;
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int idx3;
                    int idx2 = 2 * c2;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx4 = 2 * r2;
                        idx3 = idx1 + r2 * twoRowStride + idx2;
                        temp[idx4] = a2[idx3];
                        temp[idx4 + 1] = a2[idx3 + 1];
                    }
                    this.fftRows.complexForward(temp);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx4 = 2 * r2;
                        idx3 = idx1 + r2 * twoRowStride + idx2;
                        a2[idx3] = temp[idx4];
                        a2[idx3 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new float[2 * this.slices];
            for (int r4 = 0; r4 < ldimn2; ++r4) {
                int idx3 = r4 * twoRowStride;
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int idx42;
                    int idx2;
                    int s3;
                    int idx12 = 2 * c2;
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx2 = 2 * s3;
                        idx42 = s3 * twoSliceStride + idx3 + idx12;
                        temp[idx2] = a2[idx42];
                        temp[idx2 + 1] = a2[idx42 + 1];
                    }
                    this.fftSlices.complexForward(temp);
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx2 = 2 * s3;
                        idx42 = s3 * twoSliceStride + idx3 + idx12;
                        a2[idx42] = temp[idx2];
                        a2[idx42 + 1] = temp[idx2 + 1];
                    }
                }
            }
            for (s2 = 0; s2 < this.slices; ++s2) {
                int idx2 = (this.slices - s2) % this.slices;
                int idx5 = idx2 * twoSliceStride;
                int idx6 = s2 * twoSliceStride;
                for (r2 = 1; r2 < n2d2; ++r2) {
                    idx4 = this.rows - r2;
                    int idx7 = idx4 * twoRowStride;
                    int idx8 = r2 * twoRowStride;
                    int idx9 = idx5 + idx7;
                    for (int c3 = 0; c3 < this.columns; ++c3) {
                        int idx13 = 2 * c3;
                        int idx3 = twon3 - idx13;
                        int idx10 = idx6 + idx8 + idx13;
                        a2[idx9 + idx3 % twon3] = a2[idx10];
                        a2[idx9 + (idx3 + 1) % twon3] = -a2[idx10 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final FloatLargeArray a2) {
        final long twon3 = 2L * this.columnsl;
        FloatLargeArray temp = new FloatLargeArray(twon3);
        long ldimn2 = this.rowsl / 2L + 1L;
        final long n2d2 = this.rowsl % 2L == 0L ? this.rowsl / 2L : (this.rowsl + 1L) / 2L;
        final long twoSliceStride = 2L * this.sliceStridel;
        final long twoRowStride = 2L * this.rowStridel;
        long n1d2 = this.slicesl / 2L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= (long)nthreads && this.columnsl >= (long)nthreads && ldimn2 >= (long)nthreads) {
            long lastSlice;
            long firstSlice;
            Future[] futures = new Future[nthreads];
            long p2 = n1d2 / (long)nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                final long firstSlice2 = this.slicesl - 1L - (long)l2 * p2;
                final long lastSlice2 = l2 == nthreads - 1 ? n1d2 + 1L : firstSlice2 - p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray temp = new FloatLargeArray(twon3);
                        for (long s2 = firstSlice2; s2 >= lastSlice2; --s2) {
                            long idx1 = s2 * FloatFFT_3D.this.sliceStridel;
                            long idx2 = s2 * twoSliceStride;
                            for (long r2 = FloatFFT_3D.this.rowsl - 1L; r2 >= 0L; --r2) {
                                LargeArrayUtils.arraycopy(a2, idx1 + r2 * FloatFFT_3D.this.rowStridel, temp, 0L, FloatFFT_3D.this.columnsl);
                                FloatFFT_3D.this.fftColumns.realForwardFull(temp);
                                LargeArrayUtils.arraycopy(temp, 0L, a2, idx2 + r2 * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            final FloatLargeArray temp2 = new FloatLargeArray((n1d2 + 1L) * this.rowsl * twon3);
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = (long)l3 * p2;
                lastSlice = l3 == nthreads - 1 ? n1d2 + 1L : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * FloatFFT_3D.this.sliceStridel;
                            for (long r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                LargeArrayUtils.arraycopy(a2, idx1 + r2 * FloatFFT_3D.this.rowStridel, temp2, s2 * FloatFFT_3D.this.rowsl * twon3 + r2 * twon3, FloatFFT_3D.this.columnsl);
                                FloatFFT_3D.this.fftColumns.realForwardFull(temp2, s2 * FloatFFT_3D.this.rowsl * twon3 + r2 * twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l4 = 0; l4 < nthreads; ++l4) {
                firstSlice = (long)l4 * p2;
                lastSlice = l4 == nthreads - 1 ? n1d2 + 1L : firstSlice + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * twoSliceStride;
                            for (long r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                LargeArrayUtils.arraycopy(temp2, s2 * FloatFFT_3D.this.rowsl * twon3 + r2 * twon3, a2, idx1 + r2 * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.slicesl / (long)nthreads;
            for (int l5 = 0; l5 < nthreads; ++l5) {
                firstSlice = (long)l5 * p2;
                lastSlice = l5 == nthreads - 1 ? this.slicesl : firstSlice + p2;
                futures[l5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray temp = new FloatLargeArray(2L * FloatFFT_3D.this.rowsl, false);
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * twoSliceStride;
                            for (long c2 = 0L; c2 < FloatFFT_3D.this.columnsl; ++c2) {
                                long idx4;
                                long idx3;
                                long r2;
                                long idx2 = 2L * c2;
                                for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                    idx3 = idx1 + r2 * twoRowStride + idx2;
                                    idx4 = 2L * r2;
                                    temp.setFloat(idx4, a2.getFloat(idx3));
                                    temp.setFloat(idx4 + 1L, a2.getFloat(idx3 + 1L));
                                }
                                FloatFFT_3D.this.fftRows.complexForward(temp);
                                for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                    idx3 = idx1 + r2 * twoRowStride + idx2;
                                    idx4 = 2L * r2;
                                    a2.setFloat(idx3, temp.getFloat(idx4));
                                    a2.setFloat(idx3 + 1L, temp.getFloat(idx4 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = ldimn2 / (long)nthreads;
            for (int l6 = 0; l6 < nthreads; ++l6) {
                final long firstRow = (long)l6 * p2;
                final long lastRow = l6 == nthreads - 1 ? ldimn2 : firstRow + p2;
                futures[l6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray temp = new FloatLargeArray(2L * FloatFFT_3D.this.slicesl, false);
                        for (long r2 = firstRow; r2 < lastRow; ++r2) {
                            long idx3 = r2 * twoRowStride;
                            for (long c2 = 0L; c2 < FloatFFT_3D.this.columnsl; ++c2) {
                                long idx4;
                                long idx2;
                                long s2;
                                long idx1 = 2L * c2;
                                for (s2 = 0L; s2 < FloatFFT_3D.this.slicesl; ++s2) {
                                    idx2 = 2L * s2;
                                    idx4 = s2 * twoSliceStride + idx3 + idx1;
                                    temp.setFloat(idx2, a2.getFloat(idx4));
                                    temp.setFloat(idx2 + 1L, a2.getFloat(idx4 + 1L));
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(temp);
                                for (s2 = 0L; s2 < FloatFFT_3D.this.slicesl; ++s2) {
                                    idx2 = 2L * s2;
                                    idx4 = s2 * twoSliceStride + idx3 + idx1;
                                    a2.setFloat(idx4, temp.getFloat(idx2));
                                    a2.setFloat(idx4 + 1L, temp.getFloat(idx2 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.slicesl / (long)nthreads;
            for (int l7 = 0; l7 < nthreads; ++l7) {
                firstSlice = (long)l7 * p2;
                lastSlice = l7 == nthreads - 1 ? this.slicesl : firstSlice + p2;
                futures[l7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx2 = (FloatFFT_3D.this.slicesl - s2) % FloatFFT_3D.this.slicesl;
                            long idx5 = idx2 * twoSliceStride;
                            long idx6 = s2 * twoSliceStride;
                            for (long r2 = 1L; r2 < n2d2; ++r2) {
                                long idx4 = FloatFFT_3D.this.rowsl - r2;
                                long idx7 = idx4 * twoRowStride;
                                long idx8 = r2 * twoRowStride;
                                long idx9 = idx5 + idx7;
                                for (long c2 = 0L; c2 < FloatFFT_3D.this.columnsl; ++c2) {
                                    long idx1 = 2L * c2;
                                    long idx3 = twon3 - idx1;
                                    long idx10 = idx6 + idx8 + idx1;
                                    a2.setFloat(idx9 + idx3 % twon3, a2.getFloat(idx10));
                                    a2.setFloat(idx9 + (idx3 + 1L) % twon3, -a2.getFloat(idx10 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx4;
            long r2;
            long c2;
            long idx1;
            long s2;
            for (s2 = this.slicesl - 1L; s2 >= 0L; --s2) {
                idx1 = s2 * this.sliceStridel;
                long idx2 = s2 * twoSliceStride;
                for (long r3 = this.rowsl - 1L; r3 >= 0L; --r3) {
                    LargeArrayUtils.arraycopy(a2, idx1 + r3 * this.rowStridel, temp, 0L, this.columnsl);
                    this.fftColumns.realForwardFull(temp);
                    LargeArrayUtils.arraycopy(temp, 0L, a2, idx2 + r3 * twoRowStride, twon3);
                }
            }
            temp = new FloatLargeArray(2L * this.rowsl, false);
            for (s2 = 0L; s2 < this.slicesl; ++s2) {
                idx1 = s2 * twoSliceStride;
                for (c2 = 0L; c2 < this.columnsl; ++c2) {
                    long idx3;
                    long idx2 = 2L * c2;
                    for (r2 = 0L; r2 < this.rowsl; ++r2) {
                        idx4 = 2L * r2;
                        idx3 = idx1 + r2 * twoRowStride + idx2;
                        temp.setFloat(idx4, a2.getFloat(idx3));
                        temp.setFloat(idx4 + 1L, a2.getFloat(idx3 + 1L));
                    }
                    this.fftRows.complexForward(temp);
                    for (r2 = 0L; r2 < this.rowsl; ++r2) {
                        idx4 = 2L * r2;
                        idx3 = idx1 + r2 * twoRowStride + idx2;
                        a2.setFloat(idx3, temp.getFloat(idx4));
                        a2.setFloat(idx3 + 1L, temp.getFloat(idx4 + 1L));
                    }
                }
            }
            temp = new FloatLargeArray(2L * this.slicesl, false);
            for (long r4 = 0L; r4 < ldimn2; ++r4) {
                long idx3 = r4 * twoRowStride;
                for (c2 = 0L; c2 < this.columnsl; ++c2) {
                    long idx42;
                    long idx2;
                    long s3;
                    long idx12 = 2L * c2;
                    for (s3 = 0L; s3 < this.slicesl; ++s3) {
                        idx2 = 2L * s3;
                        idx42 = s3 * twoSliceStride + idx3 + idx12;
                        temp.setFloat(idx2, a2.getFloat(idx42));
                        temp.setFloat(idx2 + 1L, a2.getFloat(idx42 + 1L));
                    }
                    this.fftSlices.complexForward(temp);
                    for (s3 = 0L; s3 < this.slicesl; ++s3) {
                        idx2 = 2L * s3;
                        idx42 = s3 * twoSliceStride + idx3 + idx12;
                        a2.setFloat(idx42, temp.getFloat(idx2));
                        a2.setFloat(idx42 + 1L, temp.getFloat(idx2 + 1L));
                    }
                }
            }
            for (s2 = 0L; s2 < this.slicesl; ++s2) {
                long idx2 = (this.slicesl - s2) % this.slicesl;
                long idx5 = idx2 * twoSliceStride;
                long idx6 = s2 * twoSliceStride;
                for (r2 = 1L; r2 < n2d2; ++r2) {
                    idx4 = this.rowsl - r2;
                    long idx7 = idx4 * twoRowStride;
                    long idx8 = r2 * twoRowStride;
                    long idx9 = idx5 + idx7;
                    for (long c3 = 0L; c3 < this.columnsl; ++c3) {
                        long idx13 = 2L * c3;
                        long idx3 = twon3 - idx13;
                        long idx10 = idx6 + idx8 + idx13;
                        a2.setFloat(idx9 + idx3 % twon3, a2.getFloat(idx10));
                        a2.setFloat(idx9 + (idx3 + 1L) % twon3, -a2.getFloat(idx10 + 1L));
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[] a2, final boolean scale) {
        final int twon3 = 2 * this.columns;
        float[] temp = new float[twon3];
        int ldimn2 = this.rows / 2 + 1;
        final int n2d2 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        final int twoSliceStride = 2 * this.sliceStride;
        final int twoRowStride = 2 * this.rowStride;
        int n1d2 = this.slices / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= nthreads && this.columns >= nthreads && ldimn2 >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p2 = n1d2 / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                final int firstSlice2 = this.slices - 1 - l2 * p2;
                final int lastSlice2 = l2 == nthreads - 1 ? n1d2 + 1 : firstSlice2 - p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[twon3];
                        for (int s2 = firstSlice2; s2 >= lastSlice2; --s2) {
                            int idx1 = s2 * FloatFFT_3D.this.sliceStride;
                            int idx2 = s2 * twoSliceStride;
                            for (int r2 = FloatFFT_3D.this.rows - 1; r2 >= 0; --r2) {
                                System.arraycopy(a2, idx1 + r2 * FloatFFT_3D.this.rowStride, temp, 0, FloatFFT_3D.this.columns);
                                FloatFFT_3D.this.fftColumns.realInverseFull(temp, scale);
                                System.arraycopy(temp, 0, a2, idx2 + r2 * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            final float[][][] temp2 = new float[n1d2 + 1][this.rows][twon3];
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = l3 * p2;
                lastSlice = l3 == nthreads - 1 ? n1d2 + 1 : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * FloatFFT_3D.this.sliceStride;
                            for (int r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                System.arraycopy(a2, idx1 + r2 * FloatFFT_3D.this.rowStride, temp2[s2][r2], 0, FloatFFT_3D.this.columns);
                                FloatFFT_3D.this.fftColumns.realInverseFull(temp2[s2][r2], scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l4 = 0; l4 < nthreads; ++l4) {
                firstSlice = l4 * p2;
                lastSlice = l4 == nthreads - 1 ? n1d2 + 1 : firstSlice + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * twoSliceStride;
                            for (int r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                System.arraycopy(temp2[s2][r2], 0, a2, idx1 + r2 * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.slices / nthreads;
            for (int l5 = 0; l5 < nthreads; ++l5) {
                firstSlice = l5 * p2;
                lastSlice = l5 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * twoSliceStride;
                            for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                int idx4;
                                int idx3;
                                int r2;
                                int idx2 = 2 * c2;
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx3 = idx1 + r2 * twoRowStride + idx2;
                                    idx4 = 2 * r2;
                                    temp[idx4] = a2[idx3];
                                    temp[idx4 + 1] = a2[idx3 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(temp, scale);
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx3 = idx1 + r2 * twoRowStride + idx2;
                                    idx4 = 2 * r2;
                                    a2[idx3] = temp[idx4];
                                    a2[idx3 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = ldimn2 / nthreads;
            for (int l6 = 0; l6 < nthreads; ++l6) {
                final int firstRow = l6 * p2;
                final int lastRow = l6 == nthreads - 1 ? ldimn2 : firstRow + p2;
                futures[l6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.slices];
                        for (int r2 = firstRow; r2 < lastRow; ++r2) {
                            int idx3 = r2 * twoRowStride;
                            for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                int idx4;
                                int idx2;
                                int s2;
                                int idx1 = 2 * c2;
                                for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    idx4 = s2 * twoSliceStride + idx3 + idx1;
                                    temp[idx2] = a2[idx4];
                                    temp[idx2 + 1] = a2[idx4 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    idx4 = s2 * twoSliceStride + idx3 + idx1;
                                    a2[idx4] = temp[idx2];
                                    a2[idx4 + 1] = temp[idx2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.slices / nthreads;
            for (int l7 = 0; l7 < nthreads; ++l7) {
                firstSlice = l7 * p2;
                lastSlice = l7 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx2 = (FloatFFT_3D.this.slices - s2) % FloatFFT_3D.this.slices;
                            int idx5 = idx2 * twoSliceStride;
                            int idx6 = s2 * twoSliceStride;
                            for (int r2 = 1; r2 < n2d2; ++r2) {
                                int idx4 = FloatFFT_3D.this.rows - r2;
                                int idx7 = idx4 * twoRowStride;
                                int idx8 = r2 * twoRowStride;
                                int idx9 = idx5 + idx7;
                                for (int c2 = 0; c2 < FloatFFT_3D.this.columns; ++c2) {
                                    int idx1 = 2 * c2;
                                    int idx3 = twon3 - idx1;
                                    int idx10 = idx6 + idx8 + idx1;
                                    a2[idx9 + idx3 % twon3] = a2[idx10];
                                    a2[idx9 + (idx3 + 1) % twon3] = -a2[idx10 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx4;
            int r2;
            int c2;
            int idx1;
            int s2;
            for (s2 = this.slices - 1; s2 >= 0; --s2) {
                idx1 = s2 * this.sliceStride;
                int idx2 = s2 * twoSliceStride;
                for (int r3 = this.rows - 1; r3 >= 0; --r3) {
                    System.arraycopy(a2, idx1 + r3 * this.rowStride, temp, 0, this.columns);
                    this.fftColumns.realInverseFull(temp, scale);
                    System.arraycopy(temp, 0, a2, idx2 + r3 * twoRowStride, twon3);
                }
            }
            temp = new float[2 * this.rows];
            for (s2 = 0; s2 < this.slices; ++s2) {
                idx1 = s2 * twoSliceStride;
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int idx3;
                    int idx2 = 2 * c2;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx4 = 2 * r2;
                        idx3 = idx1 + r2 * twoRowStride + idx2;
                        temp[idx4] = a2[idx3];
                        temp[idx4 + 1] = a2[idx3 + 1];
                    }
                    this.fftRows.complexInverse(temp, scale);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx4 = 2 * r2;
                        idx3 = idx1 + r2 * twoRowStride + idx2;
                        a2[idx3] = temp[idx4];
                        a2[idx3 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new float[2 * this.slices];
            for (int r4 = 0; r4 < ldimn2; ++r4) {
                int idx3 = r4 * twoRowStride;
                for (c2 = 0; c2 < this.columns; ++c2) {
                    int idx42;
                    int idx2;
                    int s3;
                    int idx12 = 2 * c2;
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx2 = 2 * s3;
                        idx42 = s3 * twoSliceStride + idx3 + idx12;
                        temp[idx2] = a2[idx42];
                        temp[idx2 + 1] = a2[idx42 + 1];
                    }
                    this.fftSlices.complexInverse(temp, scale);
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx2 = 2 * s3;
                        idx42 = s3 * twoSliceStride + idx3 + idx12;
                        a2[idx42] = temp[idx2];
                        a2[idx42 + 1] = temp[idx2 + 1];
                    }
                }
            }
            for (s2 = 0; s2 < this.slices; ++s2) {
                int idx2 = (this.slices - s2) % this.slices;
                int idx5 = idx2 * twoSliceStride;
                int idx6 = s2 * twoSliceStride;
                for (r2 = 1; r2 < n2d2; ++r2) {
                    idx4 = this.rows - r2;
                    int idx7 = idx4 * twoRowStride;
                    int idx8 = r2 * twoRowStride;
                    int idx9 = idx5 + idx7;
                    for (int c3 = 0; c3 < this.columns; ++c3) {
                        int idx13 = 2 * c3;
                        int idx3 = twon3 - idx13;
                        int idx10 = idx6 + idx8 + idx13;
                        a2[idx9 + idx3 % twon3] = a2[idx10];
                        a2[idx9 + (idx3 + 1) % twon3] = -a2[idx10 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final FloatLargeArray a2, final boolean scale) {
        final long twon3 = 2L * this.columnsl;
        FloatLargeArray temp = new FloatLargeArray(twon3);
        long ldimn2 = this.rowsl / 2L + 1L;
        final long n2d2 = this.rowsl % 2L == 0L ? this.rowsl / 2L : (this.rowsl + 1L) / 2L;
        final long twoSliceStride = 2L * this.sliceStridel;
        final long twoRowStride = 2L * this.rowStridel;
        long n1d2 = this.slicesl / 2L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= (long)nthreads && this.columnsl >= (long)nthreads && ldimn2 >= (long)nthreads) {
            long lastSlice;
            long firstSlice;
            Future[] futures = new Future[nthreads];
            long p2 = n1d2 / (long)nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                final long firstSlice2 = this.slicesl - 1L - (long)l2 * p2;
                final long lastSlice2 = l2 == nthreads - 1 ? n1d2 + 1L : firstSlice2 - p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray temp = new FloatLargeArray(twon3);
                        for (long s2 = firstSlice2; s2 >= lastSlice2; --s2) {
                            long idx1 = s2 * FloatFFT_3D.this.sliceStridel;
                            long idx2 = s2 * twoSliceStride;
                            for (long r2 = FloatFFT_3D.this.rowsl - 1L; r2 >= 0L; --r2) {
                                LargeArrayUtils.arraycopy(a2, idx1 + r2 * FloatFFT_3D.this.rowStridel, temp, 0L, FloatFFT_3D.this.columnsl);
                                FloatFFT_3D.this.fftColumns.realInverseFull(temp, scale);
                                LargeArrayUtils.arraycopy(temp, 0L, a2, idx2 + r2 * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            final FloatLargeArray temp2 = new FloatLargeArray((n1d2 + 1L) * this.rowsl * twon3);
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = (long)l3 * p2;
                lastSlice = l3 == nthreads - 1 ? n1d2 + 1L : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * FloatFFT_3D.this.sliceStridel;
                            for (long r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                LargeArrayUtils.arraycopy(a2, idx1 + r2 * FloatFFT_3D.this.rowStridel, temp2, s2 * FloatFFT_3D.this.rowsl * twon3 + r2 * twon3, FloatFFT_3D.this.columnsl);
                                FloatFFT_3D.this.fftColumns.realInverseFull(temp2, s2 * FloatFFT_3D.this.rowsl * twon3 + r2 * twon3, scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l4 = 0; l4 < nthreads; ++l4) {
                firstSlice = (long)l4 * p2;
                lastSlice = l4 == nthreads - 1 ? n1d2 + 1L : firstSlice + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * twoSliceStride;
                            for (long r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                LargeArrayUtils.arraycopy(temp2, s2 * FloatFFT_3D.this.rowsl * twon3 + r2 * twon3, a2, idx1 + r2 * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.slicesl / (long)nthreads;
            for (int l5 = 0; l5 < nthreads; ++l5) {
                firstSlice = (long)l5 * p2;
                lastSlice = l5 == nthreads - 1 ? this.slicesl : firstSlice + p2;
                futures[l5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray temp = new FloatLargeArray(2L * FloatFFT_3D.this.rowsl, false);
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * twoSliceStride;
                            for (long c2 = 0L; c2 < FloatFFT_3D.this.columnsl; ++c2) {
                                long idx4;
                                long idx3;
                                long r2;
                                long idx2 = 2L * c2;
                                for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                    idx3 = idx1 + r2 * twoRowStride + idx2;
                                    idx4 = 2L * r2;
                                    temp.setFloat(idx4, a2.getFloat(idx3));
                                    temp.setFloat(idx4 + 1L, a2.getFloat(idx3 + 1L));
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(temp, scale);
                                for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                    idx3 = idx1 + r2 * twoRowStride + idx2;
                                    idx4 = 2L * r2;
                                    a2.setFloat(idx3, temp.getFloat(idx4));
                                    a2.setFloat(idx3 + 1L, temp.getFloat(idx4 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = ldimn2 / (long)nthreads;
            for (int l6 = 0; l6 < nthreads; ++l6) {
                final long firstRow = (long)l6 * p2;
                final long lastRow = l6 == nthreads - 1 ? ldimn2 : firstRow + p2;
                futures[l6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray temp = new FloatLargeArray(2L * FloatFFT_3D.this.slicesl, false);
                        for (long r2 = firstRow; r2 < lastRow; ++r2) {
                            long idx3 = r2 * twoRowStride;
                            for (long c2 = 0L; c2 < FloatFFT_3D.this.columnsl; ++c2) {
                                long idx4;
                                long idx2;
                                long s2;
                                long idx1 = 2L * c2;
                                for (s2 = 0L; s2 < FloatFFT_3D.this.slicesl; ++s2) {
                                    idx2 = 2L * s2;
                                    idx4 = s2 * twoSliceStride + idx3 + idx1;
                                    temp.setFloat(idx2, a2.getFloat(idx4));
                                    temp.setFloat(idx2 + 1L, a2.getFloat(idx4 + 1L));
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                for (s2 = 0L; s2 < FloatFFT_3D.this.slicesl; ++s2) {
                                    idx2 = 2L * s2;
                                    idx4 = s2 * twoSliceStride + idx3 + idx1;
                                    a2.setFloat(idx4, temp.getFloat(idx2));
                                    a2.setFloat(idx4 + 1L, temp.getFloat(idx2 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p2 = this.slicesl / (long)nthreads;
            for (int l7 = 0; l7 < nthreads; ++l7) {
                firstSlice = (long)l7 * p2;
                lastSlice = l7 == nthreads - 1 ? this.slicesl : firstSlice + p2;
                futures[l7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx2 = (FloatFFT_3D.this.slicesl - s2) % FloatFFT_3D.this.slicesl;
                            long idx5 = idx2 * twoSliceStride;
                            long idx6 = s2 * twoSliceStride;
                            for (long r2 = 1L; r2 < n2d2; ++r2) {
                                long idx4 = FloatFFT_3D.this.rowsl - r2;
                                long idx7 = idx4 * twoRowStride;
                                long idx8 = r2 * twoRowStride;
                                long idx9 = idx5 + idx7;
                                for (long c2 = 0L; c2 < FloatFFT_3D.this.columnsl; ++c2) {
                                    long idx1 = 2L * c2;
                                    long idx3 = twon3 - idx1;
                                    long idx10 = idx6 + idx8 + idx1;
                                    a2.setFloat(idx9 + idx3 % twon3, a2.getFloat(idx10));
                                    a2.setFloat(idx9 + (idx3 + 1L) % twon3, -a2.getFloat(idx10 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx4;
            long r2;
            long c2;
            long idx1;
            long s2;
            for (s2 = this.slicesl - 1L; s2 >= 0L; --s2) {
                idx1 = s2 * this.sliceStridel;
                long idx2 = s2 * twoSliceStride;
                for (long r3 = this.rowsl - 1L; r3 >= 0L; --r3) {
                    LargeArrayUtils.arraycopy(a2, idx1 + r3 * this.rowStridel, temp, 0L, this.columnsl);
                    this.fftColumns.realInverseFull(temp, scale);
                    LargeArrayUtils.arraycopy(temp, 0L, a2, idx2 + r3 * twoRowStride, twon3);
                }
            }
            temp = new FloatLargeArray(2L * this.rowsl, false);
            for (s2 = 0L; s2 < this.slicesl; ++s2) {
                idx1 = s2 * twoSliceStride;
                for (c2 = 0L; c2 < this.columnsl; ++c2) {
                    long idx3;
                    long idx2 = 2L * c2;
                    for (r2 = 0L; r2 < this.rowsl; ++r2) {
                        idx4 = 2L * r2;
                        idx3 = idx1 + r2 * twoRowStride + idx2;
                        temp.setFloat(idx4, a2.getFloat(idx3));
                        temp.setFloat(idx4 + 1L, a2.getFloat(idx3 + 1L));
                    }
                    this.fftRows.complexInverse(temp, scale);
                    for (r2 = 0L; r2 < this.rowsl; ++r2) {
                        idx4 = 2L * r2;
                        idx3 = idx1 + r2 * twoRowStride + idx2;
                        a2.setFloat(idx3, temp.getFloat(idx4));
                        a2.setFloat(idx3 + 1L, temp.getFloat(idx4 + 1L));
                    }
                }
            }
            temp = new FloatLargeArray(2L * this.slicesl, false);
            for (long r4 = 0L; r4 < ldimn2; ++r4) {
                long idx3 = r4 * twoRowStride;
                for (c2 = 0L; c2 < this.columnsl; ++c2) {
                    long idx42;
                    long idx2;
                    long s3;
                    long idx12 = 2L * c2;
                    for (s3 = 0L; s3 < this.slicesl; ++s3) {
                        idx2 = 2L * s3;
                        idx42 = s3 * twoSliceStride + idx3 + idx12;
                        temp.setFloat(idx2, a2.getFloat(idx42));
                        temp.setFloat(idx2 + 1L, a2.getFloat(idx42 + 1L));
                    }
                    this.fftSlices.complexInverse(temp, scale);
                    for (s3 = 0L; s3 < this.slicesl; ++s3) {
                        idx2 = 2L * s3;
                        idx42 = s3 * twoSliceStride + idx3 + idx12;
                        a2.setFloat(idx42, temp.getFloat(idx2));
                        a2.setFloat(idx42 + 1L, temp.getFloat(idx2 + 1L));
                    }
                }
            }
            for (s2 = 0L; s2 < this.slicesl; ++s2) {
                long idx2 = (this.slicesl - s2) % this.slicesl;
                long idx5 = idx2 * twoSliceStride;
                long idx6 = s2 * twoSliceStride;
                for (r2 = 1L; r2 < n2d2; ++r2) {
                    idx4 = this.rowsl - r2;
                    long idx7 = idx4 * twoRowStride;
                    long idx8 = r2 * twoRowStride;
                    long idx9 = idx5 + idx7;
                    for (long c3 = 0L; c3 < this.columnsl; ++c3) {
                        long idx13 = 2L * c3;
                        long idx3 = twon3 - idx13;
                        long idx10 = idx6 + idx8 + idx13;
                        a2.setFloat(idx9 + idx3 % twon3, a2.getFloat(idx10));
                        a2.setFloat(idx9 + (idx3 + 1L) % twon3, -a2.getFloat(idx10 + 1L));
                    }
                }
            }
        }
    }

    private void xdft3da_sub1(int icr, int isgn, float[] a2, boolean scale) {
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        float[] t2 = new float[nt];
        if (isgn == -1) {
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int idx3;
                int idx2;
                int idx1;
                int r2;
                int idx0 = s2 * this.sliceStride;
                if (icr == 0) {
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        this.fftColumns.complexForward(a2, idx0 + r2 * this.rowStride);
                    }
                } else {
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        this.fftColumns.realForward(a2, idx0 + r2 * this.rowStride);
                    }
                }
                if (this.columns > 4) {
                    for (int c2 = 0; c2 < this.columns; c2 += 8) {
                        int idx5;
                        int idx4;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c2;
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            t2[idx2] = a2[idx1];
                            t2[idx2 + 1] = a2[idx1 + 1];
                            t2[idx3] = a2[idx1 + 2];
                            t2[idx3 + 1] = a2[idx1 + 3];
                            t2[idx4] = a2[idx1 + 4];
                            t2[idx4 + 1] = a2[idx1 + 5];
                            t2[idx5] = a2[idx1 + 6];
                            t2[idx5 + 1] = a2[idx1 + 7];
                        }
                        this.fftRows.complexForward(t2, 0);
                        this.fftRows.complexForward(t2, 2 * this.rows);
                        this.fftRows.complexForward(t2, 4 * this.rows);
                        this.fftRows.complexForward(t2, 6 * this.rows);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c2;
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a2[idx1] = t2[idx2];
                            a2[idx1 + 1] = t2[idx2 + 1];
                            a2[idx1 + 2] = t2[idx3];
                            a2[idx1 + 3] = t2[idx3 + 1];
                            a2[idx1 + 4] = t2[idx4];
                            a2[idx1 + 5] = t2[idx4 + 1];
                            a2[idx1 + 6] = t2[idx5];
                            a2[idx1 + 7] = t2[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx1 = idx0 + r2 * this.rowStride;
                        idx2 = 2 * r2;
                        idx3 = 2 * this.rows + 2 * r2;
                        t2[idx2] = a2[idx1];
                        t2[idx2 + 1] = a2[idx1 + 1];
                        t2[idx3] = a2[idx1 + 2];
                        t2[idx3 + 1] = a2[idx1 + 3];
                    }
                    this.fftRows.complexForward(t2, 0);
                    this.fftRows.complexForward(t2, 2 * this.rows);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx1 = idx0 + r2 * this.rowStride;
                        idx2 = 2 * r2;
                        idx3 = 2 * this.rows + 2 * r2;
                        a2[idx1] = t2[idx2];
                        a2[idx1 + 1] = t2[idx2 + 1];
                        a2[idx1 + 2] = t2[idx3];
                        a2[idx1 + 3] = t2[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r2 = 0; r2 < this.rows; ++r2) {
                    idx1 = idx0 + r2 * this.rowStride;
                    idx2 = 2 * r2;
                    t2[idx2] = a2[idx1];
                    t2[idx2 + 1] = a2[idx1 + 1];
                }
                this.fftRows.complexForward(t2, 0);
                for (r2 = 0; r2 < this.rows; ++r2) {
                    idx1 = idx0 + r2 * this.rowStride;
                    idx2 = 2 * r2;
                    a2[idx1] = t2[idx2];
                    a2[idx1 + 1] = t2[idx2 + 1];
                }
            }
        } else {
            for (int s3 = 0; s3 < this.slices; ++s3) {
                int idx3;
                int idx2;
                int idx1;
                int r4;
                int idx0 = s3 * this.sliceStride;
                if (icr == 0) {
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        this.fftColumns.complexInverse(a2, idx0 + r4 * this.rowStride, scale);
                    }
                }
                if (this.columns > 4) {
                    for (int c3 = 0; c3 < this.columns; c3 += 8) {
                        int idx5;
                        int idx4;
                        int r5;
                        for (r5 = 0; r5 < this.rows; ++r5) {
                            idx1 = idx0 + r5 * this.rowStride + c3;
                            idx2 = 2 * r5;
                            idx3 = 2 * this.rows + 2 * r5;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            t2[idx2] = a2[idx1];
                            t2[idx2 + 1] = a2[idx1 + 1];
                            t2[idx3] = a2[idx1 + 2];
                            t2[idx3 + 1] = a2[idx1 + 3];
                            t2[idx4] = a2[idx1 + 4];
                            t2[idx4 + 1] = a2[idx1 + 5];
                            t2[idx5] = a2[idx1 + 6];
                            t2[idx5 + 1] = a2[idx1 + 7];
                        }
                        this.fftRows.complexInverse(t2, 0, scale);
                        this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                        this.fftRows.complexInverse(t2, 4 * this.rows, scale);
                        this.fftRows.complexInverse(t2, 6 * this.rows, scale);
                        for (r5 = 0; r5 < this.rows; ++r5) {
                            idx1 = idx0 + r5 * this.rowStride + c3;
                            idx2 = 2 * r5;
                            idx3 = 2 * this.rows + 2 * r5;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a2[idx1] = t2[idx2];
                            a2[idx1 + 1] = t2[idx2 + 1];
                            a2[idx1 + 2] = t2[idx3];
                            a2[idx1 + 3] = t2[idx3 + 1];
                            a2[idx1 + 4] = t2[idx4];
                            a2[idx1 + 5] = t2[idx4 + 1];
                            a2[idx1 + 6] = t2[idx5];
                            a2[idx1 + 7] = t2[idx5 + 1];
                        }
                    }
                } else if (this.columns == 4) {
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        idx1 = idx0 + r4 * this.rowStride;
                        idx2 = 2 * r4;
                        idx3 = 2 * this.rows + 2 * r4;
                        t2[idx2] = a2[idx1];
                        t2[idx2 + 1] = a2[idx1 + 1];
                        t2[idx3] = a2[idx1 + 2];
                        t2[idx3 + 1] = a2[idx1 + 3];
                    }
                    this.fftRows.complexInverse(t2, 0, scale);
                    this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        idx1 = idx0 + r4 * this.rowStride;
                        idx2 = 2 * r4;
                        idx3 = 2 * this.rows + 2 * r4;
                        a2[idx1] = t2[idx2];
                        a2[idx1 + 1] = t2[idx2 + 1];
                        a2[idx1 + 2] = t2[idx3];
                        a2[idx1 + 3] = t2[idx3 + 1];
                    }
                } else if (this.columns == 2) {
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        idx1 = idx0 + r4 * this.rowStride;
                        idx2 = 2 * r4;
                        t2[idx2] = a2[idx1];
                        t2[idx2 + 1] = a2[idx1 + 1];
                    }
                    this.fftRows.complexInverse(t2, 0, scale);
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        idx1 = idx0 + r4 * this.rowStride;
                        idx2 = 2 * r4;
                        a2[idx1] = t2[idx2];
                        a2[idx1 + 1] = t2[idx2 + 1];
                    }
                }
                if (icr == 0) continue;
                for (r4 = 0; r4 < this.rows; ++r4) {
                    this.fftColumns.realInverse(a2, idx0 + r4 * this.rowStride, scale);
                }
            }
        }
    }

    private void xdft3da_sub1(long icr, int isgn, FloatLargeArray a2, boolean scale) {
        long nt = this.slicesl;
        if (nt < this.rowsl) {
            nt = this.rowsl;
        }
        nt *= 8L;
        if (this.columnsl == 4L) {
            nt >>= 1;
        } else if (this.columnsl < 4L) {
            nt >>= 2;
        }
        FloatLargeArray t2 = new FloatLargeArray(nt);
        if (isgn == -1) {
            for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                long idx3;
                long idx2;
                long idx1;
                long r2;
                long idx0 = s2 * this.sliceStridel;
                if (icr == 0L) {
                    for (r2 = 0L; r2 < this.rowsl; ++r2) {
                        this.fftColumns.complexForward(a2, idx0 + r2 * this.rowStridel);
                    }
                } else {
                    for (r2 = 0L; r2 < this.rowsl; ++r2) {
                        this.fftColumns.realForward(a2, idx0 + r2 * this.rowStridel);
                    }
                }
                if (this.columnsl > 4L) {
                    for (long c2 = 0L; c2 < this.columnsl; c2 += 8L) {
                        long idx5;
                        long idx4;
                        long r3;
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c2;
                            idx2 = 2L * r3;
                            idx3 = 2L * this.rowsl + 2L * r3;
                            idx4 = idx3 + 2L * this.rowsl;
                            idx5 = idx4 + 2L * this.rowsl;
                            t2.setFloat(idx2, a2.getFloat(idx1));
                            t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                            t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                            t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                            t2.setFloat(idx4, a2.getFloat(idx1 + 4L));
                            t2.setFloat(idx4 + 1L, a2.getFloat(idx1 + 5L));
                            t2.setFloat(idx5, a2.getFloat(idx1 + 6L));
                            t2.setFloat(idx5 + 1L, a2.getFloat(idx1 + 7L));
                        }
                        this.fftRows.complexForward(t2, 0L);
                        this.fftRows.complexForward(t2, 2L * this.rowsl);
                        this.fftRows.complexForward(t2, 4L * this.rowsl);
                        this.fftRows.complexForward(t2, 6L * this.rowsl);
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c2;
                            idx2 = 2L * r3;
                            idx3 = 2L * this.rowsl + 2L * r3;
                            idx4 = idx3 + 2L * this.rowsl;
                            idx5 = idx4 + 2L * this.rowsl;
                            a2.setFloat(idx1, t2.getFloat(idx2));
                            a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                            a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                            a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                            a2.setFloat(idx1 + 4L, t2.getFloat(idx4));
                            a2.setFloat(idx1 + 5L, t2.getFloat(idx4 + 1L));
                            a2.setFloat(idx1 + 6L, t2.getFloat(idx5));
                            a2.setFloat(idx1 + 7L, t2.getFloat(idx5 + 1L));
                        }
                    }
                    continue;
                }
                if (this.columnsl == 4L) {
                    for (r2 = 0L; r2 < this.rowsl; ++r2) {
                        idx1 = idx0 + r2 * this.rowStridel;
                        idx2 = 2L * r2;
                        idx3 = 2L * this.rowsl + 2L * r2;
                        t2.setFloat(idx2, a2.getFloat(idx1));
                        t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                        t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                        t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                    }
                    this.fftRows.complexForward(t2, 0L);
                    this.fftRows.complexForward(t2, 2L * this.rowsl);
                    for (r2 = 0L; r2 < this.rowsl; ++r2) {
                        idx1 = idx0 + r2 * this.rowStridel;
                        idx2 = 2L * r2;
                        idx3 = 2L * this.rowsl + 2L * r2;
                        a2.setFloat(idx1, t2.getFloat(idx2));
                        a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                        a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                        a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    idx1 = idx0 + r2 * this.rowStridel;
                    idx2 = 2L * r2;
                    t2.setFloat(idx2, a2.getFloat(idx1));
                    t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                }
                this.fftRows.complexForward(t2, 0L);
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    idx1 = idx0 + r2 * this.rowStridel;
                    idx2 = 2L * r2;
                    a2.setFloat(idx1, t2.getFloat(idx2));
                    a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                }
            }
        } else {
            for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                long idx3;
                long idx2;
                long idx1;
                long r4;
                long idx0 = s3 * this.sliceStridel;
                if (icr == 0L) {
                    for (r4 = 0L; r4 < this.rowsl; ++r4) {
                        this.fftColumns.complexInverse(a2, idx0 + r4 * this.rowStridel, scale);
                    }
                }
                if (this.columnsl > 4L) {
                    for (long c3 = 0L; c3 < this.columnsl; c3 += 8L) {
                        long idx5;
                        long idx4;
                        long r5;
                        for (r5 = 0L; r5 < this.rowsl; ++r5) {
                            idx1 = idx0 + r5 * this.rowStridel + c3;
                            idx2 = 2L * r5;
                            idx3 = 2L * this.rowsl + 2L * r5;
                            idx4 = idx3 + 2L * this.rowsl;
                            idx5 = idx4 + 2L * this.rowsl;
                            t2.setFloat(idx2, a2.getFloat(idx1));
                            t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                            t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                            t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                            t2.setFloat(idx4, a2.getFloat(idx1 + 4L));
                            t2.setFloat(idx4 + 1L, a2.getFloat(idx1 + 5L));
                            t2.setFloat(idx5, a2.getFloat(idx1 + 6L));
                            t2.setFloat(idx5 + 1L, a2.getFloat(idx1 + 7L));
                        }
                        this.fftRows.complexInverse(t2, 0L, scale);
                        this.fftRows.complexInverse(t2, 2L * this.rowsl, scale);
                        this.fftRows.complexInverse(t2, 4L * this.rowsl, scale);
                        this.fftRows.complexInverse(t2, 6L * this.rowsl, scale);
                        for (r5 = 0L; r5 < this.rowsl; ++r5) {
                            idx1 = idx0 + r5 * this.rowStridel + c3;
                            idx2 = 2L * r5;
                            idx3 = 2L * this.rowsl + 2L * r5;
                            idx4 = idx3 + 2L * this.rowsl;
                            idx5 = idx4 + 2L * this.rowsl;
                            a2.setFloat(idx1, t2.getFloat(idx2));
                            a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                            a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                            a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                            a2.setFloat(idx1 + 4L, t2.getFloat(idx4));
                            a2.setFloat(idx1 + 5L, t2.getFloat(idx4 + 1L));
                            a2.setFloat(idx1 + 6L, t2.getFloat(idx5));
                            a2.setFloat(idx1 + 7L, t2.getFloat(idx5 + 1L));
                        }
                    }
                } else if (this.columnsl == 4L) {
                    for (r4 = 0L; r4 < this.rowsl; ++r4) {
                        idx1 = idx0 + r4 * this.rowStridel;
                        idx2 = 2L * r4;
                        idx3 = 2L * this.rowsl + 2L * r4;
                        t2.setFloat(idx2, a2.getFloat(idx1));
                        t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                        t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                        t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                    }
                    this.fftRows.complexInverse(t2, 0L, scale);
                    this.fftRows.complexInverse(t2, 2L * this.rowsl, scale);
                    for (r4 = 0L; r4 < this.rowsl; ++r4) {
                        idx1 = idx0 + r4 * this.rowStridel;
                        idx2 = 2L * r4;
                        idx3 = 2L * this.rowsl + 2L * r4;
                        a2.setFloat(idx1, t2.getFloat(idx2));
                        a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                        a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                        a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                    }
                } else if (this.columnsl == 2L) {
                    for (r4 = 0L; r4 < this.rowsl; ++r4) {
                        idx1 = idx0 + r4 * this.rowStridel;
                        idx2 = 2L * r4;
                        t2.setFloat(idx2, a2.getFloat(idx1));
                        t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                    }
                    this.fftRows.complexInverse(t2, 0L, scale);
                    for (r4 = 0L; r4 < this.rowsl; ++r4) {
                        idx1 = idx0 + r4 * this.rowStridel;
                        idx2 = 2L * r4;
                        a2.setFloat(idx1, t2.getFloat(idx2));
                        a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                    }
                }
                if (icr == 0L) continue;
                for (r4 = 0L; r4 < this.rowsl; ++r4) {
                    this.fftColumns.realInverse(a2, idx0 + r4 * this.rowStridel, scale);
                }
            }
        }
    }

    private void xdft3da_sub2(int icr, int isgn, float[] a2, boolean scale) {
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        float[] t2 = new float[nt];
        if (isgn == -1) {
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int idx3;
                int idx2;
                int idx1;
                int r2;
                int idx0 = s2 * this.sliceStride;
                if (icr == 0) {
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        this.fftColumns.complexForward(a2, idx0 + r2 * this.rowStride);
                    }
                } else {
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        this.fftColumns.realForward(a2, idx0 + r2 * this.rowStride);
                    }
                }
                if (this.columns > 4) {
                    for (int c2 = 0; c2 < this.columns; c2 += 8) {
                        int idx5;
                        int idx4;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c2;
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            t2[idx2] = a2[idx1];
                            t2[idx2 + 1] = a2[idx1 + 1];
                            t2[idx3] = a2[idx1 + 2];
                            t2[idx3 + 1] = a2[idx1 + 3];
                            t2[idx4] = a2[idx1 + 4];
                            t2[idx4 + 1] = a2[idx1 + 5];
                            t2[idx5] = a2[idx1 + 6];
                            t2[idx5 + 1] = a2[idx1 + 7];
                        }
                        this.fftRows.complexForward(t2, 0);
                        this.fftRows.complexForward(t2, 2 * this.rows);
                        this.fftRows.complexForward(t2, 4 * this.rows);
                        this.fftRows.complexForward(t2, 6 * this.rows);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c2;
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a2[idx1] = t2[idx2];
                            a2[idx1 + 1] = t2[idx2 + 1];
                            a2[idx1 + 2] = t2[idx3];
                            a2[idx1 + 3] = t2[idx3 + 1];
                            a2[idx1 + 4] = t2[idx4];
                            a2[idx1 + 5] = t2[idx4 + 1];
                            a2[idx1 + 6] = t2[idx5];
                            a2[idx1 + 7] = t2[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx1 = idx0 + r2 * this.rowStride;
                        idx2 = 2 * r2;
                        idx3 = 2 * this.rows + 2 * r2;
                        t2[idx2] = a2[idx1];
                        t2[idx2 + 1] = a2[idx1 + 1];
                        t2[idx3] = a2[idx1 + 2];
                        t2[idx3 + 1] = a2[idx1 + 3];
                    }
                    this.fftRows.complexForward(t2, 0);
                    this.fftRows.complexForward(t2, 2 * this.rows);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx1 = idx0 + r2 * this.rowStride;
                        idx2 = 2 * r2;
                        idx3 = 2 * this.rows + 2 * r2;
                        a2[idx1] = t2[idx2];
                        a2[idx1 + 1] = t2[idx2 + 1];
                        a2[idx1 + 2] = t2[idx3];
                        a2[idx1 + 3] = t2[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r2 = 0; r2 < this.rows; ++r2) {
                    idx1 = idx0 + r2 * this.rowStride;
                    idx2 = 2 * r2;
                    t2[idx2] = a2[idx1];
                    t2[idx2 + 1] = a2[idx1 + 1];
                }
                this.fftRows.complexForward(t2, 0);
                for (r2 = 0; r2 < this.rows; ++r2) {
                    idx1 = idx0 + r2 * this.rowStride;
                    idx2 = 2 * r2;
                    a2[idx1] = t2[idx2];
                    a2[idx1 + 1] = t2[idx2 + 1];
                }
            }
        } else {
            for (int s3 = 0; s3 < this.slices; ++s3) {
                int idx3;
                int idx2;
                int idx1;
                int r4;
                int idx0 = s3 * this.sliceStride;
                if (icr == 0) {
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        this.fftColumns.complexInverse(a2, idx0 + r4 * this.rowStride, scale);
                    }
                } else {
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        this.fftColumns.realInverse2(a2, idx0 + r4 * this.rowStride, scale);
                    }
                }
                if (this.columns > 4) {
                    for (int c3 = 0; c3 < this.columns; c3 += 8) {
                        int idx5;
                        int idx4;
                        int r5;
                        for (r5 = 0; r5 < this.rows; ++r5) {
                            idx1 = idx0 + r5 * this.rowStride + c3;
                            idx2 = 2 * r5;
                            idx3 = 2 * this.rows + 2 * r5;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            t2[idx2] = a2[idx1];
                            t2[idx2 + 1] = a2[idx1 + 1];
                            t2[idx3] = a2[idx1 + 2];
                            t2[idx3 + 1] = a2[idx1 + 3];
                            t2[idx4] = a2[idx1 + 4];
                            t2[idx4 + 1] = a2[idx1 + 5];
                            t2[idx5] = a2[idx1 + 6];
                            t2[idx5 + 1] = a2[idx1 + 7];
                        }
                        this.fftRows.complexInverse(t2, 0, scale);
                        this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                        this.fftRows.complexInverse(t2, 4 * this.rows, scale);
                        this.fftRows.complexInverse(t2, 6 * this.rows, scale);
                        for (r5 = 0; r5 < this.rows; ++r5) {
                            idx1 = idx0 + r5 * this.rowStride + c3;
                            idx2 = 2 * r5;
                            idx3 = 2 * this.rows + 2 * r5;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a2[idx1] = t2[idx2];
                            a2[idx1 + 1] = t2[idx2 + 1];
                            a2[idx1 + 2] = t2[idx3];
                            a2[idx1 + 3] = t2[idx3 + 1];
                            a2[idx1 + 4] = t2[idx4];
                            a2[idx1 + 5] = t2[idx4 + 1];
                            a2[idx1 + 6] = t2[idx5];
                            a2[idx1 + 7] = t2[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        idx1 = idx0 + r4 * this.rowStride;
                        idx2 = 2 * r4;
                        idx3 = 2 * this.rows + 2 * r4;
                        t2[idx2] = a2[idx1];
                        t2[idx2 + 1] = a2[idx1 + 1];
                        t2[idx3] = a2[idx1 + 2];
                        t2[idx3 + 1] = a2[idx1 + 3];
                    }
                    this.fftRows.complexInverse(t2, 0, scale);
                    this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        idx1 = idx0 + r4 * this.rowStride;
                        idx2 = 2 * r4;
                        idx3 = 2 * this.rows + 2 * r4;
                        a2[idx1] = t2[idx2];
                        a2[idx1 + 1] = t2[idx2 + 1];
                        a2[idx1 + 2] = t2[idx3];
                        a2[idx1 + 3] = t2[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r4 = 0; r4 < this.rows; ++r4) {
                    idx1 = idx0 + r4 * this.rowStride;
                    idx2 = 2 * r4;
                    t2[idx2] = a2[idx1];
                    t2[idx2 + 1] = a2[idx1 + 1];
                }
                this.fftRows.complexInverse(t2, 0, scale);
                for (r4 = 0; r4 < this.rows; ++r4) {
                    idx1 = idx0 + r4 * this.rowStride;
                    idx2 = 2 * r4;
                    a2[idx1] = t2[idx2];
                    a2[idx1 + 1] = t2[idx2 + 1];
                }
            }
        }
    }

    private void xdft3da_sub2(long icr, int isgn, FloatLargeArray a2, boolean scale) {
        long nt = this.slicesl;
        if (nt < this.rowsl) {
            nt = this.rowsl;
        }
        nt *= 8L;
        if (this.columnsl == 4L) {
            nt >>= 1;
        } else if (this.columnsl < 4L) {
            nt >>= 2;
        }
        FloatLargeArray t2 = new FloatLargeArray(nt);
        if (isgn == -1) {
            for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                long idx3;
                long idx2;
                long idx1;
                long r2;
                long idx0 = s2 * this.sliceStridel;
                if (icr == 0L) {
                    for (r2 = 0L; r2 < this.rowsl; ++r2) {
                        this.fftColumns.complexForward(a2, idx0 + r2 * this.rowStridel);
                    }
                } else {
                    for (r2 = 0L; r2 < this.rowsl; ++r2) {
                        this.fftColumns.realForward(a2, idx0 + r2 * this.rowStridel);
                    }
                }
                if (this.columnsl > 4L) {
                    for (long c2 = 0L; c2 < this.columnsl; c2 += 8L) {
                        long idx5;
                        long idx4;
                        long r3;
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c2;
                            idx2 = 2L * r3;
                            idx3 = 2L * this.rowsl + 2L * r3;
                            idx4 = idx3 + 2L * this.rowsl;
                            idx5 = idx4 + 2L * this.rowsl;
                            t2.setFloat(idx2, a2.getFloat(idx1));
                            t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                            t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                            t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                            t2.setFloat(idx4, a2.getFloat(idx1 + 4L));
                            t2.setFloat(idx4 + 1L, a2.getFloat(idx1 + 5L));
                            t2.setFloat(idx5, a2.getFloat(idx1 + 6L));
                            t2.setFloat(idx5 + 1L, a2.getFloat(idx1 + 7L));
                        }
                        this.fftRows.complexForward(t2, 0L);
                        this.fftRows.complexForward(t2, 2L * this.rowsl);
                        this.fftRows.complexForward(t2, 4L * this.rowsl);
                        this.fftRows.complexForward(t2, 6L * this.rowsl);
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c2;
                            idx2 = 2L * r3;
                            idx3 = 2L * this.rowsl + 2L * r3;
                            idx4 = idx3 + 2L * this.rowsl;
                            idx5 = idx4 + 2L * this.rowsl;
                            a2.setFloat(idx1, t2.getFloat(idx2));
                            a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                            a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                            a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                            a2.setFloat(idx1 + 4L, t2.getFloat(idx4));
                            a2.setFloat(idx1 + 5L, t2.getFloat(idx4 + 1L));
                            a2.setFloat(idx1 + 6L, t2.getFloat(idx5));
                            a2.setFloat(idx1 + 7L, t2.getFloat(idx5 + 1L));
                        }
                    }
                    continue;
                }
                if (this.columnsl == 4L) {
                    for (r2 = 0L; r2 < this.rowsl; ++r2) {
                        idx1 = idx0 + r2 * this.rowStridel;
                        idx2 = 2L * r2;
                        idx3 = 2L * this.rowsl + 2L * r2;
                        t2.setFloat(idx2, a2.getFloat(idx1));
                        t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                        t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                        t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                    }
                    this.fftRows.complexForward(t2, 0L);
                    this.fftRows.complexForward(t2, 2L * this.rowsl);
                    for (r2 = 0L; r2 < this.rowsl; ++r2) {
                        idx1 = idx0 + r2 * this.rowStridel;
                        idx2 = 2L * r2;
                        idx3 = 2L * this.rowsl + 2L * r2;
                        a2.setFloat(idx1, t2.getFloat(idx2));
                        a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                        a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                        a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    idx1 = idx0 + r2 * this.rowStridel;
                    idx2 = 2L * r2;
                    t2.setFloat(idx2, a2.getFloat(idx1));
                    t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                }
                this.fftRows.complexForward(t2, 0L);
                for (r2 = 0L; r2 < this.rowsl; ++r2) {
                    idx1 = idx0 + r2 * this.rowStridel;
                    idx2 = 2L * r2;
                    a2.setFloat(idx1, t2.getFloat(idx2));
                    a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                }
            }
        } else {
            for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                long idx3;
                long idx2;
                long idx1;
                long r4;
                long idx0 = s3 * this.sliceStridel;
                if (icr == 0L) {
                    for (r4 = 0L; r4 < this.rowsl; ++r4) {
                        this.fftColumns.complexInverse(a2, idx0 + r4 * this.rowStridel, scale);
                    }
                } else {
                    for (r4 = 0L; r4 < this.rowsl; ++r4) {
                        this.fftColumns.realInverse2(a2, idx0 + r4 * this.rowStridel, scale);
                    }
                }
                if (this.columnsl > 4L) {
                    for (long c3 = 0L; c3 < this.columnsl; c3 += 8L) {
                        long idx5;
                        long idx4;
                        long r5;
                        for (r5 = 0L; r5 < this.rowsl; ++r5) {
                            idx1 = idx0 + r5 * this.rowStridel + c3;
                            idx2 = 2L * r5;
                            idx3 = 2L * this.rowsl + 2L * r5;
                            idx4 = idx3 + 2L * this.rowsl;
                            idx5 = idx4 + 2L * this.rowsl;
                            t2.setFloat(idx2, a2.getFloat(idx1));
                            t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                            t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                            t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                            t2.setFloat(idx4, a2.getFloat(idx1 + 4L));
                            t2.setFloat(idx4 + 1L, a2.getFloat(idx1 + 5L));
                            t2.setFloat(idx5, a2.getFloat(idx1 + 6L));
                            t2.setFloat(idx5 + 1L, a2.getFloat(idx1 + 7L));
                        }
                        this.fftRows.complexInverse(t2, 0L, scale);
                        this.fftRows.complexInverse(t2, 2L * this.rowsl, scale);
                        this.fftRows.complexInverse(t2, 4L * this.rowsl, scale);
                        this.fftRows.complexInverse(t2, 6L * this.rowsl, scale);
                        for (r5 = 0L; r5 < this.rowsl; ++r5) {
                            idx1 = idx0 + r5 * this.rowStridel + c3;
                            idx2 = 2L * r5;
                            idx3 = 2L * this.rowsl + 2L * r5;
                            idx4 = idx3 + 2L * this.rowsl;
                            idx5 = idx4 + 2L * this.rowsl;
                            a2.setFloat(idx1, t2.getFloat(idx2));
                            a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                            a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                            a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                            a2.setFloat(idx1 + 4L, t2.getFloat(idx4));
                            a2.setFloat(idx1 + 5L, t2.getFloat(idx4 + 1L));
                            a2.setFloat(idx1 + 6L, t2.getFloat(idx5));
                            a2.setFloat(idx1 + 7L, t2.getFloat(idx5 + 1L));
                        }
                    }
                    continue;
                }
                if (this.columnsl == 4L) {
                    for (r4 = 0L; r4 < this.rowsl; ++r4) {
                        idx1 = idx0 + r4 * this.rowStridel;
                        idx2 = 2L * r4;
                        idx3 = 2L * this.rowsl + 2L * r4;
                        t2.setFloat(idx2, a2.getFloat(idx1));
                        t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                        t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                        t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                    }
                    this.fftRows.complexInverse(t2, 0L, scale);
                    this.fftRows.complexInverse(t2, 2L * this.rowsl, scale);
                    for (r4 = 0L; r4 < this.rowsl; ++r4) {
                        idx1 = idx0 + r4 * this.rowStridel;
                        idx2 = 2L * r4;
                        idx3 = 2L * this.rowsl + 2L * r4;
                        a2.setFloat(idx1, t2.getFloat(idx2));
                        a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                        a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                        a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r4 = 0L; r4 < this.rowsl; ++r4) {
                    idx1 = idx0 + r4 * this.rowStridel;
                    idx2 = 2L * r4;
                    t2.setFloat(idx2, a2.getFloat(idx1));
                    t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                }
                this.fftRows.complexInverse(t2, 0L, scale);
                for (r4 = 0L; r4 < this.rowsl; ++r4) {
                    idx1 = idx0 + r4 * this.rowStridel;
                    idx2 = 2L * r4;
                    a2.setFloat(idx1, t2.getFloat(idx2));
                    a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                }
            }
        }
    }

    private void xdft3da_sub1(int icr, int isgn, float[][][] a2, boolean scale) {
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        float[] t2 = new float[nt];
        if (isgn == -1) {
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int idx3;
                int idx2;
                int r2;
                if (icr == 0) {
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        this.fftColumns.complexForward(a2[s2][r2]);
                    }
                } else {
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        this.fftColumns.realForward(a2[s2][r2], 0);
                    }
                }
                if (this.columns > 4) {
                    for (int c2 = 0; c2 < this.columns; c2 += 8) {
                        int idx5;
                        int idx4;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            t2[idx2] = a2[s2][r3][c2];
                            t2[idx2 + 1] = a2[s2][r3][c2 + 1];
                            t2[idx3] = a2[s2][r3][c2 + 2];
                            t2[idx3 + 1] = a2[s2][r3][c2 + 3];
                            t2[idx4] = a2[s2][r3][c2 + 4];
                            t2[idx4 + 1] = a2[s2][r3][c2 + 5];
                            t2[idx5] = a2[s2][r3][c2 + 6];
                            t2[idx5 + 1] = a2[s2][r3][c2 + 7];
                        }
                        this.fftRows.complexForward(t2, 0);
                        this.fftRows.complexForward(t2, 2 * this.rows);
                        this.fftRows.complexForward(t2, 4 * this.rows);
                        this.fftRows.complexForward(t2, 6 * this.rows);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a2[s2][r3][c2] = t2[idx2];
                            a2[s2][r3][c2 + 1] = t2[idx2 + 1];
                            a2[s2][r3][c2 + 2] = t2[idx3];
                            a2[s2][r3][c2 + 3] = t2[idx3 + 1];
                            a2[s2][r3][c2 + 4] = t2[idx4];
                            a2[s2][r3][c2 + 5] = t2[idx4 + 1];
                            a2[s2][r3][c2 + 6] = t2[idx5];
                            a2[s2][r3][c2 + 7] = t2[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx2 = 2 * r2;
                        idx3 = 2 * this.rows + 2 * r2;
                        t2[idx2] = a2[s2][r2][0];
                        t2[idx2 + 1] = a2[s2][r2][1];
                        t2[idx3] = a2[s2][r2][2];
                        t2[idx3 + 1] = a2[s2][r2][3];
                    }
                    this.fftRows.complexForward(t2, 0);
                    this.fftRows.complexForward(t2, 2 * this.rows);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx2 = 2 * r2;
                        idx3 = 2 * this.rows + 2 * r2;
                        a2[s2][r2][0] = t2[idx2];
                        a2[s2][r2][1] = t2[idx2 + 1];
                        a2[s2][r2][2] = t2[idx3];
                        a2[s2][r2][3] = t2[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r2 = 0; r2 < this.rows; ++r2) {
                    idx2 = 2 * r2;
                    t2[idx2] = a2[s2][r2][0];
                    t2[idx2 + 1] = a2[s2][r2][1];
                }
                this.fftRows.complexForward(t2, 0);
                for (r2 = 0; r2 < this.rows; ++r2) {
                    idx2 = 2 * r2;
                    a2[s2][r2][0] = t2[idx2];
                    a2[s2][r2][1] = t2[idx2 + 1];
                }
            }
        } else {
            for (int s3 = 0; s3 < this.slices; ++s3) {
                int idx3;
                int idx2;
                int r4;
                if (icr == 0) {
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        this.fftColumns.complexInverse(a2[s3][r4], scale);
                    }
                }
                if (this.columns > 4) {
                    for (int c3 = 0; c3 < this.columns; c3 += 8) {
                        int idx5;
                        int idx4;
                        int r5;
                        for (r5 = 0; r5 < this.rows; ++r5) {
                            idx2 = 2 * r5;
                            idx3 = 2 * this.rows + 2 * r5;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            t2[idx2] = a2[s3][r5][c3];
                            t2[idx2 + 1] = a2[s3][r5][c3 + 1];
                            t2[idx3] = a2[s3][r5][c3 + 2];
                            t2[idx3 + 1] = a2[s3][r5][c3 + 3];
                            t2[idx4] = a2[s3][r5][c3 + 4];
                            t2[idx4 + 1] = a2[s3][r5][c3 + 5];
                            t2[idx5] = a2[s3][r5][c3 + 6];
                            t2[idx5 + 1] = a2[s3][r5][c3 + 7];
                        }
                        this.fftRows.complexInverse(t2, 0, scale);
                        this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                        this.fftRows.complexInverse(t2, 4 * this.rows, scale);
                        this.fftRows.complexInverse(t2, 6 * this.rows, scale);
                        for (r5 = 0; r5 < this.rows; ++r5) {
                            idx2 = 2 * r5;
                            idx3 = 2 * this.rows + 2 * r5;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a2[s3][r5][c3] = t2[idx2];
                            a2[s3][r5][c3 + 1] = t2[idx2 + 1];
                            a2[s3][r5][c3 + 2] = t2[idx3];
                            a2[s3][r5][c3 + 3] = t2[idx3 + 1];
                            a2[s3][r5][c3 + 4] = t2[idx4];
                            a2[s3][r5][c3 + 5] = t2[idx4 + 1];
                            a2[s3][r5][c3 + 6] = t2[idx5];
                            a2[s3][r5][c3 + 7] = t2[idx5 + 1];
                        }
                    }
                } else if (this.columns == 4) {
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        idx2 = 2 * r4;
                        idx3 = 2 * this.rows + 2 * r4;
                        t2[idx2] = a2[s3][r4][0];
                        t2[idx2 + 1] = a2[s3][r4][1];
                        t2[idx3] = a2[s3][r4][2];
                        t2[idx3 + 1] = a2[s3][r4][3];
                    }
                    this.fftRows.complexInverse(t2, 0, scale);
                    this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        idx2 = 2 * r4;
                        idx3 = 2 * this.rows + 2 * r4;
                        a2[s3][r4][0] = t2[idx2];
                        a2[s3][r4][1] = t2[idx2 + 1];
                        a2[s3][r4][2] = t2[idx3];
                        a2[s3][r4][3] = t2[idx3 + 1];
                    }
                } else if (this.columns == 2) {
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        idx2 = 2 * r4;
                        t2[idx2] = a2[s3][r4][0];
                        t2[idx2 + 1] = a2[s3][r4][1];
                    }
                    this.fftRows.complexInverse(t2, 0, scale);
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        idx2 = 2 * r4;
                        a2[s3][r4][0] = t2[idx2];
                        a2[s3][r4][1] = t2[idx2 + 1];
                    }
                }
                if (icr == 0) continue;
                for (r4 = 0; r4 < this.rows; ++r4) {
                    this.fftColumns.realInverse(a2[s3][r4], scale);
                }
            }
        }
    }

    private void xdft3da_sub2(int icr, int isgn, float[][][] a2, boolean scale) {
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        float[] t2 = new float[nt];
        if (isgn == -1) {
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int idx3;
                int idx2;
                int r2;
                if (icr == 0) {
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        this.fftColumns.complexForward(a2[s2][r2]);
                    }
                } else {
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        this.fftColumns.realForward(a2[s2][r2]);
                    }
                }
                if (this.columns > 4) {
                    for (int c2 = 0; c2 < this.columns; c2 += 8) {
                        int idx5;
                        int idx4;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            t2[idx2] = a2[s2][r3][c2];
                            t2[idx2 + 1] = a2[s2][r3][c2 + 1];
                            t2[idx3] = a2[s2][r3][c2 + 2];
                            t2[idx3 + 1] = a2[s2][r3][c2 + 3];
                            t2[idx4] = a2[s2][r3][c2 + 4];
                            t2[idx4 + 1] = a2[s2][r3][c2 + 5];
                            t2[idx5] = a2[s2][r3][c2 + 6];
                            t2[idx5 + 1] = a2[s2][r3][c2 + 7];
                        }
                        this.fftRows.complexForward(t2, 0);
                        this.fftRows.complexForward(t2, 2 * this.rows);
                        this.fftRows.complexForward(t2, 4 * this.rows);
                        this.fftRows.complexForward(t2, 6 * this.rows);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a2[s2][r3][c2] = t2[idx2];
                            a2[s2][r3][c2 + 1] = t2[idx2 + 1];
                            a2[s2][r3][c2 + 2] = t2[idx3];
                            a2[s2][r3][c2 + 3] = t2[idx3 + 1];
                            a2[s2][r3][c2 + 4] = t2[idx4];
                            a2[s2][r3][c2 + 5] = t2[idx4 + 1];
                            a2[s2][r3][c2 + 6] = t2[idx5];
                            a2[s2][r3][c2 + 7] = t2[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx2 = 2 * r2;
                        idx3 = 2 * this.rows + 2 * r2;
                        t2[idx2] = a2[s2][r2][0];
                        t2[idx2 + 1] = a2[s2][r2][1];
                        t2[idx3] = a2[s2][r2][2];
                        t2[idx3 + 1] = a2[s2][r2][3];
                    }
                    this.fftRows.complexForward(t2, 0);
                    this.fftRows.complexForward(t2, 2 * this.rows);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx2 = 2 * r2;
                        idx3 = 2 * this.rows + 2 * r2;
                        a2[s2][r2][0] = t2[idx2];
                        a2[s2][r2][1] = t2[idx2 + 1];
                        a2[s2][r2][2] = t2[idx3];
                        a2[s2][r2][3] = t2[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r2 = 0; r2 < this.rows; ++r2) {
                    idx2 = 2 * r2;
                    t2[idx2] = a2[s2][r2][0];
                    t2[idx2 + 1] = a2[s2][r2][1];
                }
                this.fftRows.complexForward(t2, 0);
                for (r2 = 0; r2 < this.rows; ++r2) {
                    idx2 = 2 * r2;
                    a2[s2][r2][0] = t2[idx2];
                    a2[s2][r2][1] = t2[idx2 + 1];
                }
            }
        } else {
            for (int s3 = 0; s3 < this.slices; ++s3) {
                int idx3;
                int idx2;
                int r4;
                if (icr == 0) {
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        this.fftColumns.complexInverse(a2[s3][r4], scale);
                    }
                } else {
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        this.fftColumns.realInverse2(a2[s3][r4], 0, scale);
                    }
                }
                if (this.columns > 4) {
                    for (int c3 = 0; c3 < this.columns; c3 += 8) {
                        int idx5;
                        int idx4;
                        int r5;
                        for (r5 = 0; r5 < this.rows; ++r5) {
                            idx2 = 2 * r5;
                            idx3 = 2 * this.rows + 2 * r5;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            t2[idx2] = a2[s3][r5][c3];
                            t2[idx2 + 1] = a2[s3][r5][c3 + 1];
                            t2[idx3] = a2[s3][r5][c3 + 2];
                            t2[idx3 + 1] = a2[s3][r5][c3 + 3];
                            t2[idx4] = a2[s3][r5][c3 + 4];
                            t2[idx4 + 1] = a2[s3][r5][c3 + 5];
                            t2[idx5] = a2[s3][r5][c3 + 6];
                            t2[idx5 + 1] = a2[s3][r5][c3 + 7];
                        }
                        this.fftRows.complexInverse(t2, 0, scale);
                        this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                        this.fftRows.complexInverse(t2, 4 * this.rows, scale);
                        this.fftRows.complexInverse(t2, 6 * this.rows, scale);
                        for (r5 = 0; r5 < this.rows; ++r5) {
                            idx2 = 2 * r5;
                            idx3 = 2 * this.rows + 2 * r5;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a2[s3][r5][c3] = t2[idx2];
                            a2[s3][r5][c3 + 1] = t2[idx2 + 1];
                            a2[s3][r5][c3 + 2] = t2[idx3];
                            a2[s3][r5][c3 + 3] = t2[idx3 + 1];
                            a2[s3][r5][c3 + 4] = t2[idx4];
                            a2[s3][r5][c3 + 5] = t2[idx4 + 1];
                            a2[s3][r5][c3 + 6] = t2[idx5];
                            a2[s3][r5][c3 + 7] = t2[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        idx2 = 2 * r4;
                        idx3 = 2 * this.rows + 2 * r4;
                        t2[idx2] = a2[s3][r4][0];
                        t2[idx2 + 1] = a2[s3][r4][1];
                        t2[idx3] = a2[s3][r4][2];
                        t2[idx3 + 1] = a2[s3][r4][3];
                    }
                    this.fftRows.complexInverse(t2, 0, scale);
                    this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                    for (r4 = 0; r4 < this.rows; ++r4) {
                        idx2 = 2 * r4;
                        idx3 = 2 * this.rows + 2 * r4;
                        a2[s3][r4][0] = t2[idx2];
                        a2[s3][r4][1] = t2[idx2 + 1];
                        a2[s3][r4][2] = t2[idx3];
                        a2[s3][r4][3] = t2[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r4 = 0; r4 < this.rows; ++r4) {
                    idx2 = 2 * r4;
                    t2[idx2] = a2[s3][r4][0];
                    t2[idx2 + 1] = a2[s3][r4][1];
                }
                this.fftRows.complexInverse(t2, 0, scale);
                for (r4 = 0; r4 < this.rows; ++r4) {
                    idx2 = 2 * r4;
                    a2[s3][r4][0] = t2[idx2];
                    a2[s3][r4][1] = t2[idx2 + 1];
                }
            }
        }
    }

    private void cdft3db_sub(int isgn, float[] a2, boolean scale) {
        block31: {
            float[] t2;
            block29: {
                block32: {
                    block30: {
                        int nt = this.slices;
                        if (nt < this.rows) {
                            nt = this.rows;
                        }
                        nt *= 8;
                        if (this.columns == 4) {
                            nt >>= 1;
                        } else if (this.columns < 4) {
                            nt >>= 2;
                        }
                        t2 = new float[nt];
                        if (isgn != -1) break block29;
                        if (this.columns <= 4) break block30;
                        for (int r2 = 0; r2 < this.rows; ++r2) {
                            int idx0 = r2 * this.rowStride;
                            for (int c2 = 0; c2 < this.columns; c2 += 8) {
                                int idx5;
                                int idx4;
                                int idx3;
                                int idx2;
                                int idx1;
                                int s2;
                                for (s2 = 0; s2 < this.slices; ++s2) {
                                    idx1 = s2 * this.sliceStride + idx0 + c2;
                                    idx2 = 2 * s2;
                                    idx3 = 2 * this.slices + 2 * s2;
                                    idx4 = idx3 + 2 * this.slices;
                                    idx5 = idx4 + 2 * this.slices;
                                    t2[idx2] = a2[idx1];
                                    t2[idx2 + 1] = a2[idx1 + 1];
                                    t2[idx3] = a2[idx1 + 2];
                                    t2[idx3 + 1] = a2[idx1 + 3];
                                    t2[idx4] = a2[idx1 + 4];
                                    t2[idx4 + 1] = a2[idx1 + 5];
                                    t2[idx5] = a2[idx1 + 6];
                                    t2[idx5 + 1] = a2[idx1 + 7];
                                }
                                this.fftSlices.complexForward(t2, 0);
                                this.fftSlices.complexForward(t2, 2 * this.slices);
                                this.fftSlices.complexForward(t2, 4 * this.slices);
                                this.fftSlices.complexForward(t2, 6 * this.slices);
                                for (s2 = 0; s2 < this.slices; ++s2) {
                                    idx1 = s2 * this.sliceStride + idx0 + c2;
                                    idx2 = 2 * s2;
                                    idx3 = 2 * this.slices + 2 * s2;
                                    idx4 = idx3 + 2 * this.slices;
                                    idx5 = idx4 + 2 * this.slices;
                                    a2[idx1] = t2[idx2];
                                    a2[idx1 + 1] = t2[idx2 + 1];
                                    a2[idx1 + 2] = t2[idx3];
                                    a2[idx1 + 3] = t2[idx3 + 1];
                                    a2[idx1 + 4] = t2[idx4];
                                    a2[idx1 + 5] = t2[idx4 + 1];
                                    a2[idx1 + 6] = t2[idx5];
                                    a2[idx1 + 7] = t2[idx5 + 1];
                                }
                            }
                        }
                        break block31;
                    }
                    if (this.columns != 4) break block32;
                    for (int r3 = 0; r3 < this.rows; ++r3) {
                        int idx3;
                        int idx2;
                        int idx1;
                        int s3;
                        int idx0 = r3 * this.rowStride;
                        for (s3 = 0; s3 < this.slices; ++s3) {
                            idx1 = s3 * this.sliceStride + idx0;
                            idx2 = 2 * s3;
                            idx3 = 2 * this.slices + 2 * s3;
                            t2[idx2] = a2[idx1];
                            t2[idx2 + 1] = a2[idx1 + 1];
                            t2[idx3] = a2[idx1 + 2];
                            t2[idx3 + 1] = a2[idx1 + 3];
                        }
                        this.fftSlices.complexForward(t2, 0);
                        this.fftSlices.complexForward(t2, 2 * this.slices);
                        for (s3 = 0; s3 < this.slices; ++s3) {
                            idx1 = s3 * this.sliceStride + idx0;
                            idx2 = 2 * s3;
                            idx3 = 2 * this.slices + 2 * s3;
                            a2[idx1] = t2[idx2];
                            a2[idx1 + 1] = t2[idx2 + 1];
                            a2[idx1 + 2] = t2[idx3];
                            a2[idx1 + 3] = t2[idx3 + 1];
                        }
                    }
                    break block31;
                }
                if (this.columns != 2) break block31;
                for (int r4 = 0; r4 < this.rows; ++r4) {
                    int idx2;
                    int idx1;
                    int s4;
                    int idx0 = r4 * this.rowStride;
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx1 = s4 * this.sliceStride + idx0;
                        idx2 = 2 * s4;
                        t2[idx2] = a2[idx1];
                        t2[idx2 + 1] = a2[idx1 + 1];
                    }
                    this.fftSlices.complexForward(t2, 0);
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx1 = s4 * this.sliceStride + idx0;
                        idx2 = 2 * s4;
                        a2[idx1] = t2[idx2];
                        a2[idx1 + 1] = t2[idx2 + 1];
                    }
                }
                break block31;
            }
            if (this.columns > 4) {
                for (int r5 = 0; r5 < this.rows; ++r5) {
                    int idx0 = r5 * this.rowStride;
                    for (int c3 = 0; c3 < this.columns; c3 += 8) {
                        int idx5;
                        int idx4;
                        int idx3;
                        int idx2;
                        int idx1;
                        int s5;
                        for (s5 = 0; s5 < this.slices; ++s5) {
                            idx1 = s5 * this.sliceStride + idx0 + c3;
                            idx2 = 2 * s5;
                            idx3 = 2 * this.slices + 2 * s5;
                            idx4 = idx3 + 2 * this.slices;
                            idx5 = idx4 + 2 * this.slices;
                            t2[idx2] = a2[idx1];
                            t2[idx2 + 1] = a2[idx1 + 1];
                            t2[idx3] = a2[idx1 + 2];
                            t2[idx3 + 1] = a2[idx1 + 3];
                            t2[idx4] = a2[idx1 + 4];
                            t2[idx4 + 1] = a2[idx1 + 5];
                            t2[idx5] = a2[idx1 + 6];
                            t2[idx5 + 1] = a2[idx1 + 7];
                        }
                        this.fftSlices.complexInverse(t2, 0, scale);
                        this.fftSlices.complexInverse(t2, 2 * this.slices, scale);
                        this.fftSlices.complexInverse(t2, 4 * this.slices, scale);
                        this.fftSlices.complexInverse(t2, 6 * this.slices, scale);
                        for (s5 = 0; s5 < this.slices; ++s5) {
                            idx1 = s5 * this.sliceStride + idx0 + c3;
                            idx2 = 2 * s5;
                            idx3 = 2 * this.slices + 2 * s5;
                            idx4 = idx3 + 2 * this.slices;
                            idx5 = idx4 + 2 * this.slices;
                            a2[idx1] = t2[idx2];
                            a2[idx1 + 1] = t2[idx2 + 1];
                            a2[idx1 + 2] = t2[idx3];
                            a2[idx1 + 3] = t2[idx3 + 1];
                            a2[idx1 + 4] = t2[idx4];
                            a2[idx1 + 5] = t2[idx4 + 1];
                            a2[idx1 + 6] = t2[idx5];
                            a2[idx1 + 7] = t2[idx5 + 1];
                        }
                    }
                }
            } else if (this.columns == 4) {
                for (int r6 = 0; r6 < this.rows; ++r6) {
                    int idx3;
                    int idx2;
                    int idx1;
                    int s6;
                    int idx0 = r6 * this.rowStride;
                    for (s6 = 0; s6 < this.slices; ++s6) {
                        idx1 = s6 * this.sliceStride + idx0;
                        idx2 = 2 * s6;
                        idx3 = 2 * this.slices + 2 * s6;
                        t2[idx2] = a2[idx1];
                        t2[idx2 + 1] = a2[idx1 + 1];
                        t2[idx3] = a2[idx1 + 2];
                        t2[idx3 + 1] = a2[idx1 + 3];
                    }
                    this.fftSlices.complexInverse(t2, 0, scale);
                    this.fftSlices.complexInverse(t2, 2 * this.slices, scale);
                    for (s6 = 0; s6 < this.slices; ++s6) {
                        idx1 = s6 * this.sliceStride + idx0;
                        idx2 = 2 * s6;
                        idx3 = 2 * this.slices + 2 * s6;
                        a2[idx1] = t2[idx2];
                        a2[idx1 + 1] = t2[idx2 + 1];
                        a2[idx1 + 2] = t2[idx3];
                        a2[idx1 + 3] = t2[idx3 + 1];
                    }
                }
            } else if (this.columns == 2) {
                for (int r7 = 0; r7 < this.rows; ++r7) {
                    int idx2;
                    int idx1;
                    int s7;
                    int idx0 = r7 * this.rowStride;
                    for (s7 = 0; s7 < this.slices; ++s7) {
                        idx1 = s7 * this.sliceStride + idx0;
                        idx2 = 2 * s7;
                        t2[idx2] = a2[idx1];
                        t2[idx2 + 1] = a2[idx1 + 1];
                    }
                    this.fftSlices.complexInverse(t2, 0, scale);
                    for (s7 = 0; s7 < this.slices; ++s7) {
                        idx1 = s7 * this.sliceStride + idx0;
                        idx2 = 2 * s7;
                        a2[idx1] = t2[idx2];
                        a2[idx1 + 1] = t2[idx2 + 1];
                    }
                }
            }
        }
    }

    private void cdft3db_sub(int isgn, FloatLargeArray a2, boolean scale) {
        block31: {
            FloatLargeArray t2;
            block29: {
                block32: {
                    block30: {
                        long nt = this.slicesl;
                        if (nt < this.rowsl) {
                            nt = this.rowsl;
                        }
                        nt *= 8L;
                        if (this.columnsl == 4L) {
                            nt >>= 1;
                        } else if (this.columnsl < 4L) {
                            nt >>= 2;
                        }
                        t2 = new FloatLargeArray(nt);
                        if (isgn != -1) break block29;
                        if (this.columnsl <= 4L) break block30;
                        for (long r2 = 0L; r2 < this.rowsl; ++r2) {
                            long idx0 = r2 * this.rowStridel;
                            for (long c2 = 0L; c2 < this.columnsl; c2 += 8L) {
                                long idx5;
                                long idx4;
                                long idx3;
                                long idx2;
                                long idx1;
                                long s2;
                                for (s2 = 0L; s2 < this.slicesl; ++s2) {
                                    idx1 = s2 * this.sliceStridel + idx0 + c2;
                                    idx2 = 2L * s2;
                                    idx3 = 2L * this.slicesl + 2L * s2;
                                    idx4 = idx3 + 2L * this.slicesl;
                                    idx5 = idx4 + 2L * this.slicesl;
                                    t2.setFloat(idx2, a2.getFloat(idx1));
                                    t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                    t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                                    t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                                    t2.setFloat(idx4, a2.getFloat(idx1 + 4L));
                                    t2.setFloat(idx4 + 1L, a2.getFloat(idx1 + 5L));
                                    t2.setFloat(idx5, a2.getFloat(idx1 + 6L));
                                    t2.setFloat(idx5 + 1L, a2.getFloat(idx1 + 7L));
                                }
                                this.fftSlices.complexForward(t2, 0L);
                                this.fftSlices.complexForward(t2, 2L * this.slicesl);
                                this.fftSlices.complexForward(t2, 4L * this.slicesl);
                                this.fftSlices.complexForward(t2, 6L * this.slicesl);
                                for (s2 = 0L; s2 < this.slicesl; ++s2) {
                                    idx1 = s2 * this.sliceStridel + idx0 + c2;
                                    idx2 = 2L * s2;
                                    idx3 = 2L * this.slicesl + 2L * s2;
                                    idx4 = idx3 + 2L * this.slicesl;
                                    idx5 = idx4 + 2L * this.slicesl;
                                    a2.setFloat(idx1, t2.getFloat(idx2));
                                    a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                    a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                                    a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                                    a2.setFloat(idx1 + 4L, t2.getFloat(idx4));
                                    a2.setFloat(idx1 + 5L, t2.getFloat(idx4 + 1L));
                                    a2.setFloat(idx1 + 6L, t2.getFloat(idx5));
                                    a2.setFloat(idx1 + 7L, t2.getFloat(idx5 + 1L));
                                }
                            }
                        }
                        break block31;
                    }
                    if (this.columnsl != 4L) break block32;
                    for (long r3 = 0L; r3 < this.rowsl; ++r3) {
                        long idx3;
                        long idx2;
                        long idx1;
                        long s3;
                        long idx0 = r3 * this.rowStridel;
                        for (s3 = 0L; s3 < this.slicesl; ++s3) {
                            idx1 = s3 * this.sliceStridel + idx0;
                            idx2 = 2L * s3;
                            idx3 = 2L * this.slicesl + 2L * s3;
                            t2.setFloat(idx2, a2.getFloat(idx1));
                            t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                            t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                            t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                        }
                        this.fftSlices.complexForward(t2, 0L);
                        this.fftSlices.complexForward(t2, 2L * this.slicesl);
                        for (s3 = 0L; s3 < this.slicesl; ++s3) {
                            idx1 = s3 * this.sliceStridel + idx0;
                            idx2 = 2L * s3;
                            idx3 = 2L * this.slicesl + 2L * s3;
                            a2.setFloat(idx1, t2.getFloat(idx2));
                            a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                            a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                            a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                        }
                    }
                    break block31;
                }
                if (this.columnsl != 2L) break block31;
                for (long r4 = 0L; r4 < this.rowsl; ++r4) {
                    long idx2;
                    long idx1;
                    long s4;
                    long idx0 = r4 * this.rowStridel;
                    for (s4 = 0L; s4 < this.slicesl; ++s4) {
                        idx1 = s4 * this.sliceStridel + idx0;
                        idx2 = 2L * s4;
                        t2.setFloat(idx2, a2.getFloat(idx1));
                        t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                    }
                    this.fftSlices.complexForward(t2, 0L);
                    for (s4 = 0L; s4 < this.slicesl; ++s4) {
                        idx1 = s4 * this.sliceStridel + idx0;
                        idx2 = 2L * s4;
                        a2.setFloat(idx1, t2.getFloat(idx2));
                        a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                    }
                }
                break block31;
            }
            if (this.columnsl > 4L) {
                for (long r5 = 0L; r5 < this.rowsl; ++r5) {
                    long idx0 = r5 * this.rowStridel;
                    for (long c3 = 0L; c3 < this.columnsl; c3 += 8L) {
                        long idx5;
                        long idx4;
                        long idx3;
                        long idx2;
                        long idx1;
                        long s5;
                        for (s5 = 0L; s5 < this.slicesl; ++s5) {
                            idx1 = s5 * this.sliceStridel + idx0 + c3;
                            idx2 = 2L * s5;
                            idx3 = 2L * this.slicesl + 2L * s5;
                            idx4 = idx3 + 2L * this.slicesl;
                            idx5 = idx4 + 2L * this.slicesl;
                            t2.setFloat(idx2, a2.getFloat(idx1));
                            t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                            t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                            t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                            t2.setFloat(idx4, a2.getFloat(idx1 + 4L));
                            t2.setFloat(idx4 + 1L, a2.getFloat(idx1 + 5L));
                            t2.setFloat(idx5, a2.getFloat(idx1 + 6L));
                            t2.setFloat(idx5 + 1L, a2.getFloat(idx1 + 7L));
                        }
                        this.fftSlices.complexInverse(t2, 0L, scale);
                        this.fftSlices.complexInverse(t2, 2L * this.slicesl, scale);
                        this.fftSlices.complexInverse(t2, 4L * this.slicesl, scale);
                        this.fftSlices.complexInverse(t2, 6L * this.slicesl, scale);
                        for (s5 = 0L; s5 < this.slicesl; ++s5) {
                            idx1 = s5 * this.sliceStridel + idx0 + c3;
                            idx2 = 2L * s5;
                            idx3 = 2L * this.slicesl + 2L * s5;
                            idx4 = idx3 + 2L * this.slicesl;
                            idx5 = idx4 + 2L * this.slicesl;
                            a2.setFloat(idx1, t2.getFloat(idx2));
                            a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                            a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                            a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                            a2.setFloat(idx1 + 4L, t2.getFloat(idx4));
                            a2.setFloat(idx1 + 5L, t2.getFloat(idx4 + 1L));
                            a2.setFloat(idx1 + 6L, t2.getFloat(idx5));
                            a2.setFloat(idx1 + 7L, t2.getFloat(idx5 + 1L));
                        }
                    }
                }
            } else if (this.columnsl == 4L) {
                for (long r6 = 0L; r6 < this.rowsl; ++r6) {
                    long idx3;
                    long idx2;
                    long idx1;
                    long s6;
                    long idx0 = r6 * this.rowStridel;
                    for (s6 = 0L; s6 < this.slicesl; ++s6) {
                        idx1 = s6 * this.sliceStridel + idx0;
                        idx2 = 2L * s6;
                        idx3 = 2L * this.slicesl + 2L * s6;
                        t2.setFloat(idx2, a2.getFloat(idx1));
                        t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                        t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                        t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                    }
                    this.fftSlices.complexInverse(t2, 0L, scale);
                    this.fftSlices.complexInverse(t2, 2L * this.slicesl, scale);
                    for (s6 = 0L; s6 < this.slicesl; ++s6) {
                        idx1 = s6 * this.sliceStridel + idx0;
                        idx2 = 2L * s6;
                        idx3 = 2L * this.slicesl + 2L * s6;
                        a2.setFloat(idx1, t2.getFloat(idx2));
                        a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                        a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                        a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                    }
                }
            } else if (this.columnsl == 2L) {
                for (long r7 = 0L; r7 < this.rowsl; ++r7) {
                    long idx2;
                    long idx1;
                    long s7;
                    long idx0 = r7 * this.rowStridel;
                    for (s7 = 0L; s7 < this.slicesl; ++s7) {
                        idx1 = s7 * this.sliceStridel + idx0;
                        idx2 = 2L * s7;
                        t2.setFloat(idx2, a2.getFloat(idx1));
                        t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                    }
                    this.fftSlices.complexInverse(t2, 0L, scale);
                    for (s7 = 0L; s7 < this.slicesl; ++s7) {
                        idx1 = s7 * this.sliceStridel + idx0;
                        idx2 = 2L * s7;
                        a2.setFloat(idx1, t2.getFloat(idx2));
                        a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                    }
                }
            }
        }
    }

    private void cdft3db_sub(int isgn, float[][][] a2, boolean scale) {
        block31: {
            float[] t2;
            block29: {
                block32: {
                    block30: {
                        int nt = this.slices;
                        if (nt < this.rows) {
                            nt = this.rows;
                        }
                        nt *= 8;
                        if (this.columns == 4) {
                            nt >>= 1;
                        } else if (this.columns < 4) {
                            nt >>= 2;
                        }
                        t2 = new float[nt];
                        if (isgn != -1) break block29;
                        if (this.columns <= 4) break block30;
                        for (int r2 = 0; r2 < this.rows; ++r2) {
                            for (int c2 = 0; c2 < this.columns; c2 += 8) {
                                int idx5;
                                int idx4;
                                int idx3;
                                int idx2;
                                int s2;
                                for (s2 = 0; s2 < this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    idx3 = 2 * this.slices + 2 * s2;
                                    idx4 = idx3 + 2 * this.slices;
                                    idx5 = idx4 + 2 * this.slices;
                                    t2[idx2] = a2[s2][r2][c2];
                                    t2[idx2 + 1] = a2[s2][r2][c2 + 1];
                                    t2[idx3] = a2[s2][r2][c2 + 2];
                                    t2[idx3 + 1] = a2[s2][r2][c2 + 3];
                                    t2[idx4] = a2[s2][r2][c2 + 4];
                                    t2[idx4 + 1] = a2[s2][r2][c2 + 5];
                                    t2[idx5] = a2[s2][r2][c2 + 6];
                                    t2[idx5 + 1] = a2[s2][r2][c2 + 7];
                                }
                                this.fftSlices.complexForward(t2, 0);
                                this.fftSlices.complexForward(t2, 2 * this.slices);
                                this.fftSlices.complexForward(t2, 4 * this.slices);
                                this.fftSlices.complexForward(t2, 6 * this.slices);
                                for (s2 = 0; s2 < this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    idx3 = 2 * this.slices + 2 * s2;
                                    idx4 = idx3 + 2 * this.slices;
                                    idx5 = idx4 + 2 * this.slices;
                                    a2[s2][r2][c2] = t2[idx2];
                                    a2[s2][r2][c2 + 1] = t2[idx2 + 1];
                                    a2[s2][r2][c2 + 2] = t2[idx3];
                                    a2[s2][r2][c2 + 3] = t2[idx3 + 1];
                                    a2[s2][r2][c2 + 4] = t2[idx4];
                                    a2[s2][r2][c2 + 5] = t2[idx4 + 1];
                                    a2[s2][r2][c2 + 6] = t2[idx5];
                                    a2[s2][r2][c2 + 7] = t2[idx5 + 1];
                                }
                            }
                        }
                        break block31;
                    }
                    if (this.columns != 4) break block32;
                    for (int r3 = 0; r3 < this.rows; ++r3) {
                        int idx3;
                        int idx2;
                        int s3;
                        for (s3 = 0; s3 < this.slices; ++s3) {
                            idx2 = 2 * s3;
                            idx3 = 2 * this.slices + 2 * s3;
                            t2[idx2] = a2[s3][r3][0];
                            t2[idx2 + 1] = a2[s3][r3][1];
                            t2[idx3] = a2[s3][r3][2];
                            t2[idx3 + 1] = a2[s3][r3][3];
                        }
                        this.fftSlices.complexForward(t2, 0);
                        this.fftSlices.complexForward(t2, 2 * this.slices);
                        for (s3 = 0; s3 < this.slices; ++s3) {
                            idx2 = 2 * s3;
                            idx3 = 2 * this.slices + 2 * s3;
                            a2[s3][r3][0] = t2[idx2];
                            a2[s3][r3][1] = t2[idx2 + 1];
                            a2[s3][r3][2] = t2[idx3];
                            a2[s3][r3][3] = t2[idx3 + 1];
                        }
                    }
                    break block31;
                }
                if (this.columns != 2) break block31;
                for (int r4 = 0; r4 < this.rows; ++r4) {
                    int idx2;
                    int s4;
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx2 = 2 * s4;
                        t2[idx2] = a2[s4][r4][0];
                        t2[idx2 + 1] = a2[s4][r4][1];
                    }
                    this.fftSlices.complexForward(t2, 0);
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx2 = 2 * s4;
                        a2[s4][r4][0] = t2[idx2];
                        a2[s4][r4][1] = t2[idx2 + 1];
                    }
                }
                break block31;
            }
            if (this.columns > 4) {
                for (int r5 = 0; r5 < this.rows; ++r5) {
                    for (int c3 = 0; c3 < this.columns; c3 += 8) {
                        int idx5;
                        int idx4;
                        int idx3;
                        int idx2;
                        int s5;
                        for (s5 = 0; s5 < this.slices; ++s5) {
                            idx2 = 2 * s5;
                            idx3 = 2 * this.slices + 2 * s5;
                            idx4 = idx3 + 2 * this.slices;
                            idx5 = idx4 + 2 * this.slices;
                            t2[idx2] = a2[s5][r5][c3];
                            t2[idx2 + 1] = a2[s5][r5][c3 + 1];
                            t2[idx3] = a2[s5][r5][c3 + 2];
                            t2[idx3 + 1] = a2[s5][r5][c3 + 3];
                            t2[idx4] = a2[s5][r5][c3 + 4];
                            t2[idx4 + 1] = a2[s5][r5][c3 + 5];
                            t2[idx5] = a2[s5][r5][c3 + 6];
                            t2[idx5 + 1] = a2[s5][r5][c3 + 7];
                        }
                        this.fftSlices.complexInverse(t2, 0, scale);
                        this.fftSlices.complexInverse(t2, 2 * this.slices, scale);
                        this.fftSlices.complexInverse(t2, 4 * this.slices, scale);
                        this.fftSlices.complexInverse(t2, 6 * this.slices, scale);
                        for (s5 = 0; s5 < this.slices; ++s5) {
                            idx2 = 2 * s5;
                            idx3 = 2 * this.slices + 2 * s5;
                            idx4 = idx3 + 2 * this.slices;
                            idx5 = idx4 + 2 * this.slices;
                            a2[s5][r5][c3] = t2[idx2];
                            a2[s5][r5][c3 + 1] = t2[idx2 + 1];
                            a2[s5][r5][c3 + 2] = t2[idx3];
                            a2[s5][r5][c3 + 3] = t2[idx3 + 1];
                            a2[s5][r5][c3 + 4] = t2[idx4];
                            a2[s5][r5][c3 + 5] = t2[idx4 + 1];
                            a2[s5][r5][c3 + 6] = t2[idx5];
                            a2[s5][r5][c3 + 7] = t2[idx5 + 1];
                        }
                    }
                }
            } else if (this.columns == 4) {
                for (int r6 = 0; r6 < this.rows; ++r6) {
                    int idx3;
                    int idx2;
                    int s6;
                    for (s6 = 0; s6 < this.slices; ++s6) {
                        idx2 = 2 * s6;
                        idx3 = 2 * this.slices + 2 * s6;
                        t2[idx2] = a2[s6][r6][0];
                        t2[idx2 + 1] = a2[s6][r6][1];
                        t2[idx3] = a2[s6][r6][2];
                        t2[idx3 + 1] = a2[s6][r6][3];
                    }
                    this.fftSlices.complexInverse(t2, 0, scale);
                    this.fftSlices.complexInverse(t2, 2 * this.slices, scale);
                    for (s6 = 0; s6 < this.slices; ++s6) {
                        idx2 = 2 * s6;
                        idx3 = 2 * this.slices + 2 * s6;
                        a2[s6][r6][0] = t2[idx2];
                        a2[s6][r6][1] = t2[idx2 + 1];
                        a2[s6][r6][2] = t2[idx3];
                        a2[s6][r6][3] = t2[idx3 + 1];
                    }
                }
            } else if (this.columns == 2) {
                for (int r7 = 0; r7 < this.rows; ++r7) {
                    int idx2;
                    int s7;
                    for (s7 = 0; s7 < this.slices; ++s7) {
                        idx2 = 2 * s7;
                        t2[idx2] = a2[s7][r7][0];
                        t2[idx2 + 1] = a2[s7][r7][1];
                    }
                    this.fftSlices.complexInverse(t2, 0, scale);
                    for (s7 = 0; s7 < this.slices; ++s7) {
                        idx2 = 2 * s7;
                        a2[s7][r7][0] = t2[idx2];
                        a2[s7][r7][1] = t2[idx2 + 1];
                    }
                }
            }
        }
    }

    private void xdft3da_subth1(final int icr, final int isgn, final float[] a2, final boolean scale) {
        final int nthreads = FastMath.min((int)ConcurrencyUtils.getNumberOfThreads(), (int)this.slices);
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    float[] t2 = new float[ntf];
                    if (isgn == -1) {
                        for (int s2 = n0; s2 < FloatFFT_3D.this.slices; s2 += nthreads) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r2;
                            int idx0 = s2 * FloatFFT_3D.this.sliceStride;
                            if (icr == 0) {
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    FloatFFT_3D.this.fftColumns.complexForward(a2, idx0 + r2 * FloatFFT_3D.this.rowStride);
                                }
                            } else {
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    FloatFFT_3D.this.fftColumns.realForward(a2, idx0 + r2 * FloatFFT_3D.this.rowStride);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (int c2 = 0; c2 < FloatFFT_3D.this.columns; c2 += 8) {
                                    int idx5;
                                    int idx4;
                                    int r3;
                                    for (r3 = 0; r3 < FloatFFT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * FloatFFT_3D.this.rowStride + c2;
                                        idx2 = 2 * r3;
                                        idx3 = 2 * FloatFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        t2[idx2] = a2[idx1];
                                        t2[idx2 + 1] = a2[idx1 + 1];
                                        t2[idx3] = a2[idx1 + 2];
                                        t2[idx3 + 1] = a2[idx1 + 3];
                                        t2[idx4] = a2[idx1 + 4];
                                        t2[idx4 + 1] = a2[idx1 + 5];
                                        t2[idx5] = a2[idx1 + 6];
                                        t2[idx5 + 1] = a2[idx1 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 0);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 2 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 4 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 6 * FloatFFT_3D.this.rows);
                                    for (r3 = 0; r3 < FloatFFT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * FloatFFT_3D.this.rowStride + c2;
                                        idx2 = 2 * r3;
                                        idx3 = 2 * FloatFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        a2[idx1] = t2[idx2];
                                        a2[idx1 + 1] = t2[idx2 + 1];
                                        a2[idx1 + 2] = t2[idx3];
                                        a2[idx1 + 3] = t2[idx3 + 1];
                                        a2[idx1 + 4] = t2[idx4];
                                        a2[idx1 + 5] = t2[idx4 + 1];
                                        a2[idx1 + 6] = t2[idx5];
                                        a2[idx1 + 7] = t2[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx1 = idx0 + r2 * FloatFFT_3D.this.rowStride;
                                    idx2 = 2 * r2;
                                    idx3 = 2 * FloatFFT_3D.this.rows + 2 * r2;
                                    t2[idx2] = a2[idx1];
                                    t2[idx2 + 1] = a2[idx1 + 1];
                                    t2[idx3] = a2[idx1 + 2];
                                    t2[idx3 + 1] = a2[idx1 + 3];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(t2, 0);
                                FloatFFT_3D.this.fftRows.complexForward(t2, 2 * FloatFFT_3D.this.rows);
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx1 = idx0 + r2 * FloatFFT_3D.this.rowStride;
                                    idx2 = 2 * r2;
                                    idx3 = 2 * FloatFFT_3D.this.rows + 2 * r2;
                                    a2[idx1] = t2[idx2];
                                    a2[idx1 + 1] = t2[idx2 + 1];
                                    a2[idx1 + 2] = t2[idx3];
                                    a2[idx1 + 3] = t2[idx3 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                idx1 = idx0 + r2 * FloatFFT_3D.this.rowStride;
                                idx2 = 2 * r2;
                                t2[idx2] = a2[idx1];
                                t2[idx2 + 1] = a2[idx1 + 1];
                            }
                            FloatFFT_3D.this.fftRows.complexForward(t2, 0);
                            for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                idx1 = idx0 + r2 * FloatFFT_3D.this.rowStride;
                                idx2 = 2 * r2;
                                a2[idx1] = t2[idx2];
                                a2[idx1 + 1] = t2[idx2 + 1];
                            }
                        }
                    } else {
                        for (int s3 = n0; s3 < FloatFFT_3D.this.slices; s3 += nthreads) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r4;
                            int idx0 = s3 * FloatFFT_3D.this.sliceStride;
                            if (icr == 0) {
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(a2, idx0 + r4 * FloatFFT_3D.this.rowStride, scale);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (int c3 = 0; c3 < FloatFFT_3D.this.columns; c3 += 8) {
                                    int idx5;
                                    int idx4;
                                    int r5;
                                    for (r5 = 0; r5 < FloatFFT_3D.this.rows; ++r5) {
                                        idx1 = idx0 + r5 * FloatFFT_3D.this.rowStride + c3;
                                        idx2 = 2 * r5;
                                        idx3 = 2 * FloatFFT_3D.this.rows + 2 * r5;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        t2[idx2] = a2[idx1];
                                        t2[idx2 + 1] = a2[idx1 + 1];
                                        t2[idx3] = a2[idx1 + 2];
                                        t2[idx3 + 1] = a2[idx1 + 3];
                                        t2[idx4] = a2[idx1 + 4];
                                        t2[idx4 + 1] = a2[idx1 + 5];
                                        t2[idx5] = a2[idx1 + 6];
                                        t2[idx5 + 1] = a2[idx1 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 2 * FloatFFT_3D.this.rows, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 4 * FloatFFT_3D.this.rows, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 6 * FloatFFT_3D.this.rows, scale);
                                    for (r5 = 0; r5 < FloatFFT_3D.this.rows; ++r5) {
                                        idx1 = idx0 + r5 * FloatFFT_3D.this.rowStride + c3;
                                        idx2 = 2 * r5;
                                        idx3 = 2 * FloatFFT_3D.this.rows + 2 * r5;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        a2[idx1] = t2[idx2];
                                        a2[idx1 + 1] = t2[idx2 + 1];
                                        a2[idx1 + 2] = t2[idx3];
                                        a2[idx1 + 3] = t2[idx3 + 1];
                                        a2[idx1 + 4] = t2[idx4];
                                        a2[idx1 + 5] = t2[idx4 + 1];
                                        a2[idx1 + 6] = t2[idx5];
                                        a2[idx1 + 7] = t2[idx5 + 1];
                                    }
                                }
                            } else if (FloatFFT_3D.this.columns == 4) {
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    idx1 = idx0 + r4 * FloatFFT_3D.this.rowStride;
                                    idx2 = 2 * r4;
                                    idx3 = 2 * FloatFFT_3D.this.rows + 2 * r4;
                                    t2[idx2] = a2[idx1];
                                    t2[idx2 + 1] = a2[idx1 + 1];
                                    t2[idx3] = a2[idx1 + 2];
                                    t2[idx3 + 1] = a2[idx1 + 3];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                FloatFFT_3D.this.fftRows.complexInverse(t2, 2 * FloatFFT_3D.this.rows, scale);
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    idx1 = idx0 + r4 * FloatFFT_3D.this.rowStride;
                                    idx2 = 2 * r4;
                                    idx3 = 2 * FloatFFT_3D.this.rows + 2 * r4;
                                    a2[idx1] = t2[idx2];
                                    a2[idx1 + 1] = t2[idx2 + 1];
                                    a2[idx1 + 2] = t2[idx3];
                                    a2[idx1 + 3] = t2[idx3 + 1];
                                }
                            } else if (FloatFFT_3D.this.columns == 2) {
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    idx1 = idx0 + r4 * FloatFFT_3D.this.rowStride;
                                    idx2 = 2 * r4;
                                    t2[idx2] = a2[idx1];
                                    t2[idx2 + 1] = a2[idx1 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    idx1 = idx0 + r4 * FloatFFT_3D.this.rowStride;
                                    idx2 = 2 * r4;
                                    a2[idx1] = t2[idx2];
                                    a2[idx1 + 1] = t2[idx2 + 1];
                                }
                            }
                            if (icr == 0) continue;
                            for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                FloatFFT_3D.this.fftColumns.realInverse(a2, idx0 + r4 * FloatFFT_3D.this.rowStride, scale);
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void xdft3da_subth1(final long icr, final int isgn, final FloatLargeArray a2, final boolean scale) {
        final int nthreads = (int)FastMath.min((long)ConcurrencyUtils.getNumberOfThreads(), (long)this.slicesl);
        long nt = this.slicesl;
        if (nt < this.rowsl) {
            nt = this.rowsl;
        }
        nt *= 8L;
        if (this.columnsl == 4L) {
            nt >>= 1;
        } else if (this.columnsl < 4L) {
            nt >>= 2;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final long n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    FloatLargeArray t2 = new FloatLargeArray(ntf);
                    if (isgn == -1) {
                        for (long s2 = n0; s2 < FloatFFT_3D.this.slicesl; s2 += (long)nthreads) {
                            long idx3;
                            long idx2;
                            long idx1;
                            long r2;
                            long idx0 = s2 * FloatFFT_3D.this.sliceStridel;
                            if (icr == 0L) {
                                for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                    FloatFFT_3D.this.fftColumns.complexForward(a2, idx0 + r2 * FloatFFT_3D.this.rowStridel);
                                }
                            } else {
                                for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                    FloatFFT_3D.this.fftColumns.realForward(a2, idx0 + r2 * FloatFFT_3D.this.rowStridel);
                                }
                            }
                            if (FloatFFT_3D.this.columnsl > 4L) {
                                for (long c2 = 0L; c2 < FloatFFT_3D.this.columnsl; c2 += 8L) {
                                    long idx5;
                                    long idx4;
                                    long r3;
                                    for (r3 = 0L; r3 < FloatFFT_3D.this.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * FloatFFT_3D.this.rowStridel + c2;
                                        idx2 = 2L * r3;
                                        idx3 = 2L * FloatFFT_3D.this.rowsl + 2L * r3;
                                        idx4 = idx3 + 2L * FloatFFT_3D.this.rowsl;
                                        idx5 = idx4 + 2L * FloatFFT_3D.this.rowsl;
                                        t2.setFloat(idx2, a2.getFloat(idx1));
                                        t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                        t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                                        t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                                        t2.setFloat(idx4, a2.getFloat(idx1 + 4L));
                                        t2.setFloat(idx4 + 1L, a2.getFloat(idx1 + 5L));
                                        t2.setFloat(idx5, a2.getFloat(idx1 + 6L));
                                        t2.setFloat(idx5 + 1L, a2.getFloat(idx1 + 7L));
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 0L);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 2L * FloatFFT_3D.this.rowsl);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 4L * FloatFFT_3D.this.rowsl);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 6L * FloatFFT_3D.this.rowsl);
                                    for (r3 = 0L; r3 < FloatFFT_3D.this.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * FloatFFT_3D.this.rowStridel + c2;
                                        idx2 = 2L * r3;
                                        idx3 = 2L * FloatFFT_3D.this.rowsl + 2L * r3;
                                        idx4 = idx3 + 2L * FloatFFT_3D.this.rowsl;
                                        idx5 = idx4 + 2L * FloatFFT_3D.this.rowsl;
                                        a2.setFloat(idx1, t2.getFloat(idx2));
                                        a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                        a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                                        a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                                        a2.setFloat(idx1 + 4L, t2.getFloat(idx4));
                                        a2.setFloat(idx1 + 5L, t2.getFloat(idx4 + 1L));
                                        a2.setFloat(idx1 + 6L, t2.getFloat(idx5));
                                        a2.setFloat(idx1 + 7L, t2.getFloat(idx5 + 1L));
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columnsl == 4L) {
                                for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                    idx1 = idx0 + r2 * FloatFFT_3D.this.rowStridel;
                                    idx2 = 2L * r2;
                                    idx3 = 2L * FloatFFT_3D.this.rowsl + 2L * r2;
                                    t2.setFloat(idx2, a2.getFloat(idx1));
                                    t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                    t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                                    t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                                }
                                FloatFFT_3D.this.fftRows.complexForward(t2, 0L);
                                FloatFFT_3D.this.fftRows.complexForward(t2, 2L * FloatFFT_3D.this.rowsl);
                                for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                    idx1 = idx0 + r2 * FloatFFT_3D.this.rowStridel;
                                    idx2 = 2L * r2;
                                    idx3 = 2L * FloatFFT_3D.this.rowsl + 2L * r2;
                                    a2.setFloat(idx1, t2.getFloat(idx2));
                                    a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                    a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                                    a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columnsl != 2L) continue;
                            for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                idx1 = idx0 + r2 * FloatFFT_3D.this.rowStridel;
                                idx2 = 2L * r2;
                                t2.setFloat(idx2, a2.getFloat(idx1));
                                t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                            }
                            FloatFFT_3D.this.fftRows.complexForward(t2, 0L);
                            for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                idx1 = idx0 + r2 * FloatFFT_3D.this.rowStridel;
                                idx2 = 2L * r2;
                                a2.setFloat(idx1, t2.getFloat(idx2));
                                a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                            }
                        }
                    } else {
                        for (long s3 = n0; s3 < FloatFFT_3D.this.slicesl; s3 += (long)nthreads) {
                            long idx3;
                            long idx2;
                            long idx1;
                            long r4;
                            long idx0 = s3 * FloatFFT_3D.this.sliceStridel;
                            if (icr == 0L) {
                                for (r4 = 0L; r4 < FloatFFT_3D.this.rowsl; ++r4) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(a2, idx0 + r4 * FloatFFT_3D.this.rowStridel, scale);
                                }
                            }
                            if (FloatFFT_3D.this.columnsl > 4L) {
                                for (long c3 = 0L; c3 < FloatFFT_3D.this.columnsl; c3 += 8L) {
                                    long idx5;
                                    long idx4;
                                    long r5;
                                    for (r5 = 0L; r5 < FloatFFT_3D.this.rowsl; ++r5) {
                                        idx1 = idx0 + r5 * FloatFFT_3D.this.rowStridel + c3;
                                        idx2 = 2L * r5;
                                        idx3 = 2L * FloatFFT_3D.this.rowsl + 2L * r5;
                                        idx4 = idx3 + 2L * FloatFFT_3D.this.rowsl;
                                        idx5 = idx4 + 2L * FloatFFT_3D.this.rowsl;
                                        t2.setFloat(idx2, a2.getFloat(idx1));
                                        t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                        t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                                        t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                                        t2.setFloat(idx4, a2.getFloat(idx1 + 4L));
                                        t2.setFloat(idx4 + 1L, a2.getFloat(idx1 + 5L));
                                        t2.setFloat(idx5, a2.getFloat(idx1 + 6L));
                                        t2.setFloat(idx5 + 1L, a2.getFloat(idx1 + 7L));
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 0L, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 2L * FloatFFT_3D.this.rowsl, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 4L * FloatFFT_3D.this.rowsl, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 6L * FloatFFT_3D.this.rowsl, scale);
                                    for (r5 = 0L; r5 < FloatFFT_3D.this.rowsl; ++r5) {
                                        idx1 = idx0 + r5 * FloatFFT_3D.this.rowStridel + c3;
                                        idx2 = 2L * r5;
                                        idx3 = 2L * FloatFFT_3D.this.rowsl + 2L * r5;
                                        idx4 = idx3 + 2L * FloatFFT_3D.this.rowsl;
                                        idx5 = idx4 + 2L * FloatFFT_3D.this.rowsl;
                                        a2.setFloat(idx1, t2.getFloat(idx2));
                                        a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                        a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                                        a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                                        a2.setFloat(idx1 + 4L, t2.getFloat(idx4));
                                        a2.setFloat(idx1 + 5L, t2.getFloat(idx4 + 1L));
                                        a2.setFloat(idx1 + 6L, t2.getFloat(idx5));
                                        a2.setFloat(idx1 + 7L, t2.getFloat(idx5 + 1L));
                                    }
                                }
                            } else if (FloatFFT_3D.this.columnsl == 4L) {
                                for (r4 = 0L; r4 < FloatFFT_3D.this.rowsl; ++r4) {
                                    idx1 = idx0 + r4 * FloatFFT_3D.this.rowStridel;
                                    idx2 = 2L * r4;
                                    idx3 = 2L * FloatFFT_3D.this.rowsl + 2L * r4;
                                    t2.setFloat(idx2, a2.getFloat(idx1));
                                    t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                    t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                                    t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(t2, 0L, scale);
                                FloatFFT_3D.this.fftRows.complexInverse(t2, 2L * FloatFFT_3D.this.rowsl, scale);
                                for (r4 = 0L; r4 < FloatFFT_3D.this.rowsl; ++r4) {
                                    idx1 = idx0 + r4 * FloatFFT_3D.this.rowStridel;
                                    idx2 = 2L * r4;
                                    idx3 = 2L * FloatFFT_3D.this.rowsl + 2L * r4;
                                    a2.setFloat(idx1, t2.getFloat(idx2));
                                    a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                    a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                                    a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                                }
                            } else if (FloatFFT_3D.this.columnsl == 2L) {
                                for (r4 = 0L; r4 < FloatFFT_3D.this.rowsl; ++r4) {
                                    idx1 = idx0 + r4 * FloatFFT_3D.this.rowStridel;
                                    idx2 = 2L * r4;
                                    t2.setFloat(idx2, a2.getFloat(idx1));
                                    t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(t2, 0L, scale);
                                for (r4 = 0L; r4 < FloatFFT_3D.this.rowsl; ++r4) {
                                    idx1 = idx0 + r4 * FloatFFT_3D.this.rowStridel;
                                    idx2 = 2L * r4;
                                    a2.setFloat(idx1, t2.getFloat(idx2));
                                    a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                }
                            }
                            if (icr == 0L) continue;
                            for (r4 = 0L; r4 < FloatFFT_3D.this.rowsl; ++r4) {
                                FloatFFT_3D.this.fftColumns.realInverse(a2, idx0 + r4 * FloatFFT_3D.this.rowStridel, scale);
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void xdft3da_subth2(final int icr, final int isgn, final float[] a2, final boolean scale) {
        final int nthreads = FastMath.min((int)ConcurrencyUtils.getNumberOfThreads(), (int)this.slices);
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    float[] t2 = new float[ntf];
                    if (isgn == -1) {
                        for (int s2 = n0; s2 < FloatFFT_3D.this.slices; s2 += nthreads) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r2;
                            int idx0 = s2 * FloatFFT_3D.this.sliceStride;
                            if (icr == 0) {
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    FloatFFT_3D.this.fftColumns.complexForward(a2, idx0 + r2 * FloatFFT_3D.this.rowStride);
                                }
                            } else {
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    FloatFFT_3D.this.fftColumns.realForward(a2, idx0 + r2 * FloatFFT_3D.this.rowStride);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (int c2 = 0; c2 < FloatFFT_3D.this.columns; c2 += 8) {
                                    int idx5;
                                    int idx4;
                                    int r3;
                                    for (r3 = 0; r3 < FloatFFT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * FloatFFT_3D.this.rowStride + c2;
                                        idx2 = 2 * r3;
                                        idx3 = 2 * FloatFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        t2[idx2] = a2[idx1];
                                        t2[idx2 + 1] = a2[idx1 + 1];
                                        t2[idx3] = a2[idx1 + 2];
                                        t2[idx3 + 1] = a2[idx1 + 3];
                                        t2[idx4] = a2[idx1 + 4];
                                        t2[idx4 + 1] = a2[idx1 + 5];
                                        t2[idx5] = a2[idx1 + 6];
                                        t2[idx5 + 1] = a2[idx1 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 0);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 2 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 4 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 6 * FloatFFT_3D.this.rows);
                                    for (r3 = 0; r3 < FloatFFT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * FloatFFT_3D.this.rowStride + c2;
                                        idx2 = 2 * r3;
                                        idx3 = 2 * FloatFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        a2[idx1] = t2[idx2];
                                        a2[idx1 + 1] = t2[idx2 + 1];
                                        a2[idx1 + 2] = t2[idx3];
                                        a2[idx1 + 3] = t2[idx3 + 1];
                                        a2[idx1 + 4] = t2[idx4];
                                        a2[idx1 + 5] = t2[idx4 + 1];
                                        a2[idx1 + 6] = t2[idx5];
                                        a2[idx1 + 7] = t2[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx1 = idx0 + r2 * FloatFFT_3D.this.rowStride;
                                    idx2 = 2 * r2;
                                    idx3 = 2 * FloatFFT_3D.this.rows + 2 * r2;
                                    t2[idx2] = a2[idx1];
                                    t2[idx2 + 1] = a2[idx1 + 1];
                                    t2[idx3] = a2[idx1 + 2];
                                    t2[idx3 + 1] = a2[idx1 + 3];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(t2, 0);
                                FloatFFT_3D.this.fftRows.complexForward(t2, 2 * FloatFFT_3D.this.rows);
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx1 = idx0 + r2 * FloatFFT_3D.this.rowStride;
                                    idx2 = 2 * r2;
                                    idx3 = 2 * FloatFFT_3D.this.rows + 2 * r2;
                                    a2[idx1] = t2[idx2];
                                    a2[idx1 + 1] = t2[idx2 + 1];
                                    a2[idx1 + 2] = t2[idx3];
                                    a2[idx1 + 3] = t2[idx3 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                idx1 = idx0 + r2 * FloatFFT_3D.this.rowStride;
                                idx2 = 2 * r2;
                                t2[idx2] = a2[idx1];
                                t2[idx2 + 1] = a2[idx1 + 1];
                            }
                            FloatFFT_3D.this.fftRows.complexForward(t2, 0);
                            for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                idx1 = idx0 + r2 * FloatFFT_3D.this.rowStride;
                                idx2 = 2 * r2;
                                a2[idx1] = t2[idx2];
                                a2[idx1 + 1] = t2[idx2 + 1];
                            }
                        }
                    } else {
                        for (int s3 = n0; s3 < FloatFFT_3D.this.slices; s3 += nthreads) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r4;
                            int idx0 = s3 * FloatFFT_3D.this.sliceStride;
                            if (icr == 0) {
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(a2, idx0 + r4 * FloatFFT_3D.this.rowStride, scale);
                                }
                            } else {
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    FloatFFT_3D.this.fftColumns.realInverse2(a2, idx0 + r4 * FloatFFT_3D.this.rowStride, scale);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (int c3 = 0; c3 < FloatFFT_3D.this.columns; c3 += 8) {
                                    int idx5;
                                    int idx4;
                                    int r5;
                                    for (r5 = 0; r5 < FloatFFT_3D.this.rows; ++r5) {
                                        idx1 = idx0 + r5 * FloatFFT_3D.this.rowStride + c3;
                                        idx2 = 2 * r5;
                                        idx3 = 2 * FloatFFT_3D.this.rows + 2 * r5;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        t2[idx2] = a2[idx1];
                                        t2[idx2 + 1] = a2[idx1 + 1];
                                        t2[idx3] = a2[idx1 + 2];
                                        t2[idx3 + 1] = a2[idx1 + 3];
                                        t2[idx4] = a2[idx1 + 4];
                                        t2[idx4 + 1] = a2[idx1 + 5];
                                        t2[idx5] = a2[idx1 + 6];
                                        t2[idx5 + 1] = a2[idx1 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 2 * FloatFFT_3D.this.rows, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 4 * FloatFFT_3D.this.rows, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 6 * FloatFFT_3D.this.rows, scale);
                                    for (r5 = 0; r5 < FloatFFT_3D.this.rows; ++r5) {
                                        idx1 = idx0 + r5 * FloatFFT_3D.this.rowStride + c3;
                                        idx2 = 2 * r5;
                                        idx3 = 2 * FloatFFT_3D.this.rows + 2 * r5;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        a2[idx1] = t2[idx2];
                                        a2[idx1 + 1] = t2[idx2 + 1];
                                        a2[idx1 + 2] = t2[idx3];
                                        a2[idx1 + 3] = t2[idx3 + 1];
                                        a2[idx1 + 4] = t2[idx4];
                                        a2[idx1 + 5] = t2[idx4 + 1];
                                        a2[idx1 + 6] = t2[idx5];
                                        a2[idx1 + 7] = t2[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    idx1 = idx0 + r4 * FloatFFT_3D.this.rowStride;
                                    idx2 = 2 * r4;
                                    idx3 = 2 * FloatFFT_3D.this.rows + 2 * r4;
                                    t2[idx2] = a2[idx1];
                                    t2[idx2 + 1] = a2[idx1 + 1];
                                    t2[idx3] = a2[idx1 + 2];
                                    t2[idx3 + 1] = a2[idx1 + 3];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                FloatFFT_3D.this.fftRows.complexInverse(t2, 2 * FloatFFT_3D.this.rows, scale);
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    idx1 = idx0 + r4 * FloatFFT_3D.this.rowStride;
                                    idx2 = 2 * r4;
                                    idx3 = 2 * FloatFFT_3D.this.rows + 2 * r4;
                                    a2[idx1] = t2[idx2];
                                    a2[idx1 + 1] = t2[idx2 + 1];
                                    a2[idx1 + 2] = t2[idx3];
                                    a2[idx1 + 3] = t2[idx3 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                idx1 = idx0 + r4 * FloatFFT_3D.this.rowStride;
                                idx2 = 2 * r4;
                                t2[idx2] = a2[idx1];
                                t2[idx2 + 1] = a2[idx1 + 1];
                            }
                            FloatFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                            for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                idx1 = idx0 + r4 * FloatFFT_3D.this.rowStride;
                                idx2 = 2 * r4;
                                a2[idx1] = t2[idx2];
                                a2[idx1 + 1] = t2[idx2 + 1];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void xdft3da_subth2(final long icr, final int isgn, final FloatLargeArray a2, final boolean scale) {
        final int nthreads = (int)FastMath.min((long)ConcurrencyUtils.getNumberOfThreads(), (long)this.slicesl);
        long nt = this.slicesl;
        if (nt < this.rowsl) {
            nt = this.rowsl;
        }
        nt *= 8L;
        if (this.columnsl == 4L) {
            nt >>= 1;
        } else if (this.columnsl < 4L) {
            nt >>= 2;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final long n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    FloatLargeArray t2 = new FloatLargeArray(ntf);
                    if (isgn == -1) {
                        for (long s2 = n0; s2 < FloatFFT_3D.this.slicesl; s2 += (long)nthreads) {
                            long idx3;
                            long idx2;
                            long idx1;
                            long r2;
                            long idx0 = s2 * FloatFFT_3D.this.sliceStridel;
                            if (icr == 0L) {
                                for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                    FloatFFT_3D.this.fftColumns.complexForward(a2, idx0 + r2 * FloatFFT_3D.this.rowStridel);
                                }
                            } else {
                                for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                    FloatFFT_3D.this.fftColumns.realForward(a2, idx0 + r2 * FloatFFT_3D.this.rowStridel);
                                }
                            }
                            if (FloatFFT_3D.this.columnsl > 4L) {
                                for (long c2 = 0L; c2 < FloatFFT_3D.this.columnsl; c2 += 8L) {
                                    long idx5;
                                    long idx4;
                                    long r3;
                                    for (r3 = 0L; r3 < FloatFFT_3D.this.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * FloatFFT_3D.this.rowStridel + c2;
                                        idx2 = 2L * r3;
                                        idx3 = 2L * FloatFFT_3D.this.rowsl + 2L * r3;
                                        idx4 = idx3 + 2L * FloatFFT_3D.this.rowsl;
                                        idx5 = idx4 + 2L * FloatFFT_3D.this.rowsl;
                                        t2.setFloat(idx2, a2.getFloat(idx1));
                                        t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                        t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                                        t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                                        t2.setFloat(idx4, a2.getFloat(idx1 + 4L));
                                        t2.setFloat(idx4 + 1L, a2.getFloat(idx1 + 5L));
                                        t2.setFloat(idx5, a2.getFloat(idx1 + 6L));
                                        t2.setFloat(idx5 + 1L, a2.getFloat(idx1 + 7L));
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 0L);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 2L * FloatFFT_3D.this.rowsl);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 4L * FloatFFT_3D.this.rowsl);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 6L * FloatFFT_3D.this.rowsl);
                                    for (r3 = 0L; r3 < FloatFFT_3D.this.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * FloatFFT_3D.this.rowStridel + c2;
                                        idx2 = 2L * r3;
                                        idx3 = 2L * FloatFFT_3D.this.rowsl + 2L * r3;
                                        idx4 = idx3 + 2L * FloatFFT_3D.this.rowsl;
                                        idx5 = idx4 + 2L * FloatFFT_3D.this.rowsl;
                                        a2.setFloat(idx1, t2.getFloat(idx2));
                                        a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                        a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                                        a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                                        a2.setFloat(idx1 + 4L, t2.getFloat(idx4));
                                        a2.setFloat(idx1 + 5L, t2.getFloat(idx4 + 1L));
                                        a2.setFloat(idx1 + 6L, t2.getFloat(idx5));
                                        a2.setFloat(idx1 + 7L, t2.getFloat(idx5 + 1L));
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columnsl == 4L) {
                                for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                    idx1 = idx0 + r2 * FloatFFT_3D.this.rowStridel;
                                    idx2 = 2L * r2;
                                    idx3 = 2L * FloatFFT_3D.this.rowsl + 2L * r2;
                                    t2.setFloat(idx2, a2.getFloat(idx1));
                                    t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                    t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                                    t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                                }
                                FloatFFT_3D.this.fftRows.complexForward(t2, 0L);
                                FloatFFT_3D.this.fftRows.complexForward(t2, 2L * FloatFFT_3D.this.rowsl);
                                for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                    idx1 = idx0 + r2 * FloatFFT_3D.this.rowStridel;
                                    idx2 = 2L * r2;
                                    idx3 = 2L * FloatFFT_3D.this.rowsl + 2L * r2;
                                    a2.setFloat(idx1, t2.getFloat(idx2));
                                    a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                    a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                                    a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columnsl != 2L) continue;
                            for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                idx1 = idx0 + r2 * FloatFFT_3D.this.rowStridel;
                                idx2 = 2L * r2;
                                t2.setFloat(idx2, a2.getFloat(idx1));
                                t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                            }
                            FloatFFT_3D.this.fftRows.complexForward(t2, 0L);
                            for (r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                idx1 = idx0 + r2 * FloatFFT_3D.this.rowStridel;
                                idx2 = 2L * r2;
                                a2.setFloat(idx1, t2.getFloat(idx2));
                                a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                            }
                        }
                    } else {
                        for (long s3 = n0; s3 < FloatFFT_3D.this.slicesl; s3 += (long)nthreads) {
                            long idx3;
                            long idx2;
                            long idx1;
                            long r4;
                            long idx0 = s3 * FloatFFT_3D.this.sliceStridel;
                            if (icr == 0L) {
                                for (r4 = 0L; r4 < FloatFFT_3D.this.rowsl; ++r4) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(a2, idx0 + r4 * FloatFFT_3D.this.rowStridel, scale);
                                }
                            } else {
                                for (r4 = 0L; r4 < FloatFFT_3D.this.rowsl; ++r4) {
                                    FloatFFT_3D.this.fftColumns.realInverse2(a2, idx0 + r4 * FloatFFT_3D.this.rowStridel, scale);
                                }
                            }
                            if (FloatFFT_3D.this.columnsl > 4L) {
                                for (long c3 = 0L; c3 < FloatFFT_3D.this.columnsl; c3 += 8L) {
                                    long idx5;
                                    long idx4;
                                    long r5;
                                    for (r5 = 0L; r5 < FloatFFT_3D.this.rowsl; ++r5) {
                                        idx1 = idx0 + r5 * FloatFFT_3D.this.rowStridel + c3;
                                        idx2 = 2L * r5;
                                        idx3 = 2L * FloatFFT_3D.this.rowsl + 2L * r5;
                                        idx4 = idx3 + 2L * FloatFFT_3D.this.rowsl;
                                        idx5 = idx4 + 2L * FloatFFT_3D.this.rowsl;
                                        t2.setFloat(idx2, a2.getFloat(idx1));
                                        t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                        t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                                        t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                                        t2.setFloat(idx4, a2.getFloat(idx1 + 4L));
                                        t2.setFloat(idx4 + 1L, a2.getFloat(idx1 + 5L));
                                        t2.setFloat(idx5, a2.getFloat(idx1 + 6L));
                                        t2.setFloat(idx5 + 1L, a2.getFloat(idx1 + 7L));
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 0L, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 2L * FloatFFT_3D.this.rowsl, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 4L * FloatFFT_3D.this.rowsl, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 6L * FloatFFT_3D.this.rowsl, scale);
                                    for (r5 = 0L; r5 < FloatFFT_3D.this.rowsl; ++r5) {
                                        idx1 = idx0 + r5 * FloatFFT_3D.this.rowStridel + c3;
                                        idx2 = 2L * r5;
                                        idx3 = 2L * FloatFFT_3D.this.rowsl + 2L * r5;
                                        idx4 = idx3 + 2L * FloatFFT_3D.this.rowsl;
                                        idx5 = idx4 + 2L * FloatFFT_3D.this.rowsl;
                                        a2.setFloat(idx1, t2.getFloat(idx2));
                                        a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                        a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                                        a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                                        a2.setFloat(idx1 + 4L, t2.getFloat(idx4));
                                        a2.setFloat(idx1 + 5L, t2.getFloat(idx4 + 1L));
                                        a2.setFloat(idx1 + 6L, t2.getFloat(idx5));
                                        a2.setFloat(idx1 + 7L, t2.getFloat(idx5 + 1L));
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columnsl == 4L) {
                                for (r4 = 0L; r4 < FloatFFT_3D.this.rowsl; ++r4) {
                                    idx1 = idx0 + r4 * FloatFFT_3D.this.rowStridel;
                                    idx2 = 2L * r4;
                                    idx3 = 2L * FloatFFT_3D.this.rowsl + 2L * r4;
                                    t2.setFloat(idx2, a2.getFloat(idx1));
                                    t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                    t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                                    t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(t2, 0L, scale);
                                FloatFFT_3D.this.fftRows.complexInverse(t2, 2L * FloatFFT_3D.this.rowsl, scale);
                                for (r4 = 0L; r4 < FloatFFT_3D.this.rowsl; ++r4) {
                                    idx1 = idx0 + r4 * FloatFFT_3D.this.rowStridel;
                                    idx2 = 2L * r4;
                                    idx3 = 2L * FloatFFT_3D.this.rowsl + 2L * r4;
                                    a2.setFloat(idx1, t2.getFloat(idx2));
                                    a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                    a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                                    a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columnsl != 2L) continue;
                            for (r4 = 0L; r4 < FloatFFT_3D.this.rowsl; ++r4) {
                                idx1 = idx0 + r4 * FloatFFT_3D.this.rowStridel;
                                idx2 = 2L * r4;
                                t2.setFloat(idx2, a2.getFloat(idx1));
                                t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                            }
                            FloatFFT_3D.this.fftRows.complexInverse(t2, 0L, scale);
                            for (r4 = 0L; r4 < FloatFFT_3D.this.rowsl; ++r4) {
                                idx1 = idx0 + r4 * FloatFFT_3D.this.rowStridel;
                                idx2 = 2L * r4;
                                a2.setFloat(idx1, t2.getFloat(idx2));
                                a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void xdft3da_subth1(final int icr, final int isgn, final float[][][] a2, final boolean scale) {
        final int nthreads = FastMath.min((int)ConcurrencyUtils.getNumberOfThreads(), (int)this.slices);
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    float[] t2 = new float[ntf];
                    if (isgn == -1) {
                        for (int s2 = n0; s2 < FloatFFT_3D.this.slices; s2 += nthreads) {
                            int idx3;
                            int idx2;
                            int r2;
                            if (icr == 0) {
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    FloatFFT_3D.this.fftColumns.complexForward(a2[s2][r2]);
                                }
                            } else {
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    FloatFFT_3D.this.fftColumns.realForward(a2[s2][r2], 0);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (int c2 = 0; c2 < FloatFFT_3D.this.columns; c2 += 8) {
                                    int idx5;
                                    int idx4;
                                    int r3;
                                    for (r3 = 0; r3 < FloatFFT_3D.this.rows; ++r3) {
                                        idx2 = 2 * r3;
                                        idx3 = 2 * FloatFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        t2[idx2] = a2[s2][r3][c2];
                                        t2[idx2 + 1] = a2[s2][r3][c2 + 1];
                                        t2[idx3] = a2[s2][r3][c2 + 2];
                                        t2[idx3 + 1] = a2[s2][r3][c2 + 3];
                                        t2[idx4] = a2[s2][r3][c2 + 4];
                                        t2[idx4 + 1] = a2[s2][r3][c2 + 5];
                                        t2[idx5] = a2[s2][r3][c2 + 6];
                                        t2[idx5 + 1] = a2[s2][r3][c2 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 0);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 2 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 4 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 6 * FloatFFT_3D.this.rows);
                                    for (r3 = 0; r3 < FloatFFT_3D.this.rows; ++r3) {
                                        idx2 = 2 * r3;
                                        idx3 = 2 * FloatFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        a2[s2][r3][c2] = t2[idx2];
                                        a2[s2][r3][c2 + 1] = t2[idx2 + 1];
                                        a2[s2][r3][c2 + 2] = t2[idx3];
                                        a2[s2][r3][c2 + 3] = t2[idx3 + 1];
                                        a2[s2][r3][c2 + 4] = t2[idx4];
                                        a2[s2][r3][c2 + 5] = t2[idx4 + 1];
                                        a2[s2][r3][c2 + 6] = t2[idx5];
                                        a2[s2][r3][c2 + 7] = t2[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx2 = 2 * r2;
                                    idx3 = 2 * FloatFFT_3D.this.rows + 2 * r2;
                                    t2[idx2] = a2[s2][r2][0];
                                    t2[idx2 + 1] = a2[s2][r2][1];
                                    t2[idx3] = a2[s2][r2][2];
                                    t2[idx3 + 1] = a2[s2][r2][3];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(t2, 0);
                                FloatFFT_3D.this.fftRows.complexForward(t2, 2 * FloatFFT_3D.this.rows);
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx2 = 2 * r2;
                                    idx3 = 2 * FloatFFT_3D.this.rows + 2 * r2;
                                    a2[s2][r2][0] = t2[idx2];
                                    a2[s2][r2][1] = t2[idx2 + 1];
                                    a2[s2][r2][2] = t2[idx3];
                                    a2[s2][r2][3] = t2[idx3 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                idx2 = 2 * r2;
                                t2[idx2] = a2[s2][r2][0];
                                t2[idx2 + 1] = a2[s2][r2][1];
                            }
                            FloatFFT_3D.this.fftRows.complexForward(t2, 0);
                            for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                idx2 = 2 * r2;
                                a2[s2][r2][0] = t2[idx2];
                                a2[s2][r2][1] = t2[idx2 + 1];
                            }
                        }
                    } else {
                        for (int s3 = n0; s3 < FloatFFT_3D.this.slices; s3 += nthreads) {
                            int idx3;
                            int idx2;
                            int r4;
                            if (icr == 0) {
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(a2[s3][r4], scale);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (int c3 = 0; c3 < FloatFFT_3D.this.columns; c3 += 8) {
                                    int idx5;
                                    int idx4;
                                    int r5;
                                    for (r5 = 0; r5 < FloatFFT_3D.this.rows; ++r5) {
                                        idx2 = 2 * r5;
                                        idx3 = 2 * FloatFFT_3D.this.rows + 2 * r5;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        t2[idx2] = a2[s3][r5][c3];
                                        t2[idx2 + 1] = a2[s3][r5][c3 + 1];
                                        t2[idx3] = a2[s3][r5][c3 + 2];
                                        t2[idx3 + 1] = a2[s3][r5][c3 + 3];
                                        t2[idx4] = a2[s3][r5][c3 + 4];
                                        t2[idx4 + 1] = a2[s3][r5][c3 + 5];
                                        t2[idx5] = a2[s3][r5][c3 + 6];
                                        t2[idx5 + 1] = a2[s3][r5][c3 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 2 * FloatFFT_3D.this.rows, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 4 * FloatFFT_3D.this.rows, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 6 * FloatFFT_3D.this.rows, scale);
                                    for (r5 = 0; r5 < FloatFFT_3D.this.rows; ++r5) {
                                        idx2 = 2 * r5;
                                        idx3 = 2 * FloatFFT_3D.this.rows + 2 * r5;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        a2[s3][r5][c3] = t2[idx2];
                                        a2[s3][r5][c3 + 1] = t2[idx2 + 1];
                                        a2[s3][r5][c3 + 2] = t2[idx3];
                                        a2[s3][r5][c3 + 3] = t2[idx3 + 1];
                                        a2[s3][r5][c3 + 4] = t2[idx4];
                                        a2[s3][r5][c3 + 5] = t2[idx4 + 1];
                                        a2[s3][r5][c3 + 6] = t2[idx5];
                                        a2[s3][r5][c3 + 7] = t2[idx5 + 1];
                                    }
                                }
                            } else if (FloatFFT_3D.this.columns == 4) {
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    idx2 = 2 * r4;
                                    idx3 = 2 * FloatFFT_3D.this.rows + 2 * r4;
                                    t2[idx2] = a2[s3][r4][0];
                                    t2[idx2 + 1] = a2[s3][r4][1];
                                    t2[idx3] = a2[s3][r4][2];
                                    t2[idx3 + 1] = a2[s3][r4][3];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                FloatFFT_3D.this.fftRows.complexInverse(t2, 2 * FloatFFT_3D.this.rows, scale);
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    idx2 = 2 * r4;
                                    idx3 = 2 * FloatFFT_3D.this.rows + 2 * r4;
                                    a2[s3][r4][0] = t2[idx2];
                                    a2[s3][r4][1] = t2[idx2 + 1];
                                    a2[s3][r4][2] = t2[idx3];
                                    a2[s3][r4][3] = t2[idx3 + 1];
                                }
                            } else if (FloatFFT_3D.this.columns == 2) {
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    idx2 = 2 * r4;
                                    t2[idx2] = a2[s3][r4][0];
                                    t2[idx2 + 1] = a2[s3][r4][1];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    idx2 = 2 * r4;
                                    a2[s3][r4][0] = t2[idx2];
                                    a2[s3][r4][1] = t2[idx2 + 1];
                                }
                            }
                            if (icr == 0) continue;
                            for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                FloatFFT_3D.this.fftColumns.realInverse(a2[s3][r4], scale);
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void xdft3da_subth2(final int icr, final int isgn, final float[][][] a2, final boolean scale) {
        final int nthreads = FastMath.min((int)ConcurrencyUtils.getNumberOfThreads(), (int)this.slices);
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    float[] t2 = new float[ntf];
                    if (isgn == -1) {
                        for (int s2 = n0; s2 < FloatFFT_3D.this.slices; s2 += nthreads) {
                            int idx3;
                            int idx2;
                            int r2;
                            if (icr == 0) {
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    FloatFFT_3D.this.fftColumns.complexForward(a2[s2][r2]);
                                }
                            } else {
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    FloatFFT_3D.this.fftColumns.realForward(a2[s2][r2]);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (int c2 = 0; c2 < FloatFFT_3D.this.columns; c2 += 8) {
                                    int idx5;
                                    int idx4;
                                    int r3;
                                    for (r3 = 0; r3 < FloatFFT_3D.this.rows; ++r3) {
                                        idx2 = 2 * r3;
                                        idx3 = 2 * FloatFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        t2[idx2] = a2[s2][r3][c2];
                                        t2[idx2 + 1] = a2[s2][r3][c2 + 1];
                                        t2[idx3] = a2[s2][r3][c2 + 2];
                                        t2[idx3 + 1] = a2[s2][r3][c2 + 3];
                                        t2[idx4] = a2[s2][r3][c2 + 4];
                                        t2[idx4 + 1] = a2[s2][r3][c2 + 5];
                                        t2[idx5] = a2[s2][r3][c2 + 6];
                                        t2[idx5 + 1] = a2[s2][r3][c2 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 0);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 2 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 4 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(t2, 6 * FloatFFT_3D.this.rows);
                                    for (r3 = 0; r3 < FloatFFT_3D.this.rows; ++r3) {
                                        idx2 = 2 * r3;
                                        idx3 = 2 * FloatFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        a2[s2][r3][c2] = t2[idx2];
                                        a2[s2][r3][c2 + 1] = t2[idx2 + 1];
                                        a2[s2][r3][c2 + 2] = t2[idx3];
                                        a2[s2][r3][c2 + 3] = t2[idx3 + 1];
                                        a2[s2][r3][c2 + 4] = t2[idx4];
                                        a2[s2][r3][c2 + 5] = t2[idx4 + 1];
                                        a2[s2][r3][c2 + 6] = t2[idx5];
                                        a2[s2][r3][c2 + 7] = t2[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx2 = 2 * r2;
                                    idx3 = 2 * FloatFFT_3D.this.rows + 2 * r2;
                                    t2[idx2] = a2[s2][r2][0];
                                    t2[idx2 + 1] = a2[s2][r2][1];
                                    t2[idx3] = a2[s2][r2][2];
                                    t2[idx3 + 1] = a2[s2][r2][3];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(t2, 0);
                                FloatFFT_3D.this.fftRows.complexForward(t2, 2 * FloatFFT_3D.this.rows);
                                for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                    idx2 = 2 * r2;
                                    idx3 = 2 * FloatFFT_3D.this.rows + 2 * r2;
                                    a2[s2][r2][0] = t2[idx2];
                                    a2[s2][r2][1] = t2[idx2 + 1];
                                    a2[s2][r2][2] = t2[idx3];
                                    a2[s2][r2][3] = t2[idx3 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                idx2 = 2 * r2;
                                t2[idx2] = a2[s2][r2][0];
                                t2[idx2 + 1] = a2[s2][r2][1];
                            }
                            FloatFFT_3D.this.fftRows.complexForward(t2, 0);
                            for (r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                idx2 = 2 * r2;
                                a2[s2][r2][0] = t2[idx2];
                                a2[s2][r2][1] = t2[idx2 + 1];
                            }
                        }
                    } else {
                        for (int s3 = n0; s3 < FloatFFT_3D.this.slices; s3 += nthreads) {
                            int idx3;
                            int idx2;
                            int r4;
                            if (icr == 0) {
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(a2[s3][r4], scale);
                                }
                            } else {
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    FloatFFT_3D.this.fftColumns.realInverse2(a2[s3][r4], 0, scale);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (int c3 = 0; c3 < FloatFFT_3D.this.columns; c3 += 8) {
                                    int idx5;
                                    int idx4;
                                    int r5;
                                    for (r5 = 0; r5 < FloatFFT_3D.this.rows; ++r5) {
                                        idx2 = 2 * r5;
                                        idx3 = 2 * FloatFFT_3D.this.rows + 2 * r5;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        t2[idx2] = a2[s3][r5][c3];
                                        t2[idx2 + 1] = a2[s3][r5][c3 + 1];
                                        t2[idx3] = a2[s3][r5][c3 + 2];
                                        t2[idx3 + 1] = a2[s3][r5][c3 + 3];
                                        t2[idx4] = a2[s3][r5][c3 + 4];
                                        t2[idx4 + 1] = a2[s3][r5][c3 + 5];
                                        t2[idx5] = a2[s3][r5][c3 + 6];
                                        t2[idx5 + 1] = a2[s3][r5][c3 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 2 * FloatFFT_3D.this.rows, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 4 * FloatFFT_3D.this.rows, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(t2, 6 * FloatFFT_3D.this.rows, scale);
                                    for (r5 = 0; r5 < FloatFFT_3D.this.rows; ++r5) {
                                        idx2 = 2 * r5;
                                        idx3 = 2 * FloatFFT_3D.this.rows + 2 * r5;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        a2[s3][r5][c3] = t2[idx2];
                                        a2[s3][r5][c3 + 1] = t2[idx2 + 1];
                                        a2[s3][r5][c3 + 2] = t2[idx3];
                                        a2[s3][r5][c3 + 3] = t2[idx3 + 1];
                                        a2[s3][r5][c3 + 4] = t2[idx4];
                                        a2[s3][r5][c3 + 5] = t2[idx4 + 1];
                                        a2[s3][r5][c3 + 6] = t2[idx5];
                                        a2[s3][r5][c3 + 7] = t2[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    idx2 = 2 * r4;
                                    idx3 = 2 * FloatFFT_3D.this.rows + 2 * r4;
                                    t2[idx2] = a2[s3][r4][0];
                                    t2[idx2 + 1] = a2[s3][r4][1];
                                    t2[idx3] = a2[s3][r4][2];
                                    t2[idx3 + 1] = a2[s3][r4][3];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                FloatFFT_3D.this.fftRows.complexInverse(t2, 2 * FloatFFT_3D.this.rows, scale);
                                for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                    idx2 = 2 * r4;
                                    idx3 = 2 * FloatFFT_3D.this.rows + 2 * r4;
                                    a2[s3][r4][0] = t2[idx2];
                                    a2[s3][r4][1] = t2[idx2 + 1];
                                    a2[s3][r4][2] = t2[idx3];
                                    a2[s3][r4][3] = t2[idx3 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                idx2 = 2 * r4;
                                t2[idx2] = a2[s3][r4][0];
                                t2[idx2 + 1] = a2[s3][r4][1];
                            }
                            FloatFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                            for (r4 = 0; r4 < FloatFFT_3D.this.rows; ++r4) {
                                idx2 = 2 * r4;
                                a2[s3][r4][0] = t2[idx2];
                                a2[s3][r4][1] = t2[idx2 + 1];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void cdft3db_subth(final int isgn, final float[] a2, final boolean scale) {
        final int nthreads = FastMath.min((int)ConcurrencyUtils.getNumberOfThreads(), (int)this.rows);
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block27: {
                        float[] t2;
                        block25: {
                            block28: {
                                block26: {
                                    t2 = new float[ntf];
                                    if (isgn != -1) break block25;
                                    if (FloatFFT_3D.this.columns <= 4) break block26;
                                    for (int r2 = n0; r2 < FloatFFT_3D.this.rows; r2 += nthreads) {
                                        int idx0 = r2 * FloatFFT_3D.this.rowStride;
                                        for (int c2 = 0; c2 < FloatFFT_3D.this.columns; c2 += 8) {
                                            int idx5;
                                            int idx4;
                                            int idx3;
                                            int idx2;
                                            int idx1;
                                            int s2;
                                            for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                                idx1 = s2 * FloatFFT_3D.this.sliceStride + idx0 + c2;
                                                idx2 = 2 * s2;
                                                idx3 = 2 * FloatFFT_3D.this.slices + 2 * s2;
                                                idx4 = idx3 + 2 * FloatFFT_3D.this.slices;
                                                idx5 = idx4 + 2 * FloatFFT_3D.this.slices;
                                                t2[idx2] = a2[idx1];
                                                t2[idx2 + 1] = a2[idx1 + 1];
                                                t2[idx3] = a2[idx1 + 2];
                                                t2[idx3 + 1] = a2[idx1 + 3];
                                                t2[idx4] = a2[idx1 + 4];
                                                t2[idx4 + 1] = a2[idx1 + 5];
                                                t2[idx5] = a2[idx1 + 6];
                                                t2[idx5 + 1] = a2[idx1 + 7];
                                            }
                                            FloatFFT_3D.this.fftSlices.complexForward(t2, 0);
                                            FloatFFT_3D.this.fftSlices.complexForward(t2, 2 * FloatFFT_3D.this.slices);
                                            FloatFFT_3D.this.fftSlices.complexForward(t2, 4 * FloatFFT_3D.this.slices);
                                            FloatFFT_3D.this.fftSlices.complexForward(t2, 6 * FloatFFT_3D.this.slices);
                                            for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                                idx1 = s2 * FloatFFT_3D.this.sliceStride + idx0 + c2;
                                                idx2 = 2 * s2;
                                                idx3 = 2 * FloatFFT_3D.this.slices + 2 * s2;
                                                idx4 = idx3 + 2 * FloatFFT_3D.this.slices;
                                                idx5 = idx4 + 2 * FloatFFT_3D.this.slices;
                                                a2[idx1] = t2[idx2];
                                                a2[idx1 + 1] = t2[idx2 + 1];
                                                a2[idx1 + 2] = t2[idx3];
                                                a2[idx1 + 3] = t2[idx3 + 1];
                                                a2[idx1 + 4] = t2[idx4];
                                                a2[idx1 + 5] = t2[idx4 + 1];
                                                a2[idx1 + 6] = t2[idx5];
                                                a2[idx1 + 7] = t2[idx5 + 1];
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (FloatFFT_3D.this.columns != 4) break block28;
                                for (int r3 = n0; r3 < FloatFFT_3D.this.rows; r3 += nthreads) {
                                    int idx3;
                                    int idx2;
                                    int idx1;
                                    int s3;
                                    int idx0 = r3 * FloatFFT_3D.this.rowStride;
                                    for (s3 = 0; s3 < FloatFFT_3D.this.slices; ++s3) {
                                        idx1 = s3 * FloatFFT_3D.this.sliceStride + idx0;
                                        idx2 = 2 * s3;
                                        idx3 = 2 * FloatFFT_3D.this.slices + 2 * s3;
                                        t2[idx2] = a2[idx1];
                                        t2[idx2 + 1] = a2[idx1 + 1];
                                        t2[idx3] = a2[idx1 + 2];
                                        t2[idx3 + 1] = a2[idx1 + 3];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexForward(t2, 0);
                                    FloatFFT_3D.this.fftSlices.complexForward(t2, 2 * FloatFFT_3D.this.slices);
                                    for (s3 = 0; s3 < FloatFFT_3D.this.slices; ++s3) {
                                        idx1 = s3 * FloatFFT_3D.this.sliceStride + idx0;
                                        idx2 = 2 * s3;
                                        idx3 = 2 * FloatFFT_3D.this.slices + 2 * s3;
                                        a2[idx1] = t2[idx2];
                                        a2[idx1 + 1] = t2[idx2 + 1];
                                        a2[idx1 + 2] = t2[idx3];
                                        a2[idx1 + 3] = t2[idx3 + 1];
                                    }
                                }
                                break block27;
                            }
                            if (FloatFFT_3D.this.columns != 2) break block27;
                            for (int r4 = n0; r4 < FloatFFT_3D.this.rows; r4 += nthreads) {
                                int idx2;
                                int idx1;
                                int s4;
                                int idx0 = r4 * FloatFFT_3D.this.rowStride;
                                for (s4 = 0; s4 < FloatFFT_3D.this.slices; ++s4) {
                                    idx1 = s4 * FloatFFT_3D.this.sliceStride + idx0;
                                    idx2 = 2 * s4;
                                    t2[idx2] = a2[idx1];
                                    t2[idx2 + 1] = a2[idx1 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(t2, 0);
                                for (s4 = 0; s4 < FloatFFT_3D.this.slices; ++s4) {
                                    idx1 = s4 * FloatFFT_3D.this.sliceStride + idx0;
                                    idx2 = 2 * s4;
                                    a2[idx1] = t2[idx2];
                                    a2[idx1 + 1] = t2[idx2 + 1];
                                }
                            }
                            break block27;
                        }
                        if (FloatFFT_3D.this.columns > 4) {
                            for (int r5 = n0; r5 < FloatFFT_3D.this.rows; r5 += nthreads) {
                                int idx0 = r5 * FloatFFT_3D.this.rowStride;
                                for (int c3 = 0; c3 < FloatFFT_3D.this.columns; c3 += 8) {
                                    int idx5;
                                    int idx4;
                                    int idx3;
                                    int idx2;
                                    int idx1;
                                    int s5;
                                    for (s5 = 0; s5 < FloatFFT_3D.this.slices; ++s5) {
                                        idx1 = s5 * FloatFFT_3D.this.sliceStride + idx0 + c3;
                                        idx2 = 2 * s5;
                                        idx3 = 2 * FloatFFT_3D.this.slices + 2 * s5;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.slices;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.slices;
                                        t2[idx2] = a2[idx1];
                                        t2[idx2 + 1] = a2[idx1 + 1];
                                        t2[idx3] = a2[idx1 + 2];
                                        t2[idx3 + 1] = a2[idx1 + 3];
                                        t2[idx4] = a2[idx1 + 4];
                                        t2[idx4 + 1] = a2[idx1 + 5];
                                        t2[idx5] = a2[idx1 + 6];
                                        t2[idx5 + 1] = a2[idx1 + 7];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexInverse(t2, 0, scale);
                                    FloatFFT_3D.this.fftSlices.complexInverse(t2, 2 * FloatFFT_3D.this.slices, scale);
                                    FloatFFT_3D.this.fftSlices.complexInverse(t2, 4 * FloatFFT_3D.this.slices, scale);
                                    FloatFFT_3D.this.fftSlices.complexInverse(t2, 6 * FloatFFT_3D.this.slices, scale);
                                    for (s5 = 0; s5 < FloatFFT_3D.this.slices; ++s5) {
                                        idx1 = s5 * FloatFFT_3D.this.sliceStride + idx0 + c3;
                                        idx2 = 2 * s5;
                                        idx3 = 2 * FloatFFT_3D.this.slices + 2 * s5;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.slices;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.slices;
                                        a2[idx1] = t2[idx2];
                                        a2[idx1 + 1] = t2[idx2 + 1];
                                        a2[idx1 + 2] = t2[idx3];
                                        a2[idx1 + 3] = t2[idx3 + 1];
                                        a2[idx1 + 4] = t2[idx4];
                                        a2[idx1 + 5] = t2[idx4 + 1];
                                        a2[idx1 + 6] = t2[idx5];
                                        a2[idx1 + 7] = t2[idx5 + 1];
                                    }
                                }
                            }
                        } else if (FloatFFT_3D.this.columns == 4) {
                            for (int r6 = n0; r6 < FloatFFT_3D.this.rows; r6 += nthreads) {
                                int idx3;
                                int idx2;
                                int idx1;
                                int s6;
                                int idx0 = r6 * FloatFFT_3D.this.rowStride;
                                for (s6 = 0; s6 < FloatFFT_3D.this.slices; ++s6) {
                                    idx1 = s6 * FloatFFT_3D.this.sliceStride + idx0;
                                    idx2 = 2 * s6;
                                    idx3 = 2 * FloatFFT_3D.this.slices + 2 * s6;
                                    t2[idx2] = a2[idx1];
                                    t2[idx2 + 1] = a2[idx1 + 1];
                                    t2[idx3] = a2[idx1 + 2];
                                    t2[idx3 + 1] = a2[idx1 + 3];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(t2, 0, scale);
                                FloatFFT_3D.this.fftSlices.complexInverse(t2, 2 * FloatFFT_3D.this.slices, scale);
                                for (s6 = 0; s6 < FloatFFT_3D.this.slices; ++s6) {
                                    idx1 = s6 * FloatFFT_3D.this.sliceStride + idx0;
                                    idx2 = 2 * s6;
                                    idx3 = 2 * FloatFFT_3D.this.slices + 2 * s6;
                                    a2[idx1] = t2[idx2];
                                    a2[idx1 + 1] = t2[idx2 + 1];
                                    a2[idx1 + 2] = t2[idx3];
                                    a2[idx1 + 3] = t2[idx3 + 1];
                                }
                            }
                        } else if (FloatFFT_3D.this.columns == 2) {
                            for (int r7 = n0; r7 < FloatFFT_3D.this.rows; r7 += nthreads) {
                                int idx2;
                                int idx1;
                                int s7;
                                int idx0 = r7 * FloatFFT_3D.this.rowStride;
                                for (s7 = 0; s7 < FloatFFT_3D.this.slices; ++s7) {
                                    idx1 = s7 * FloatFFT_3D.this.sliceStride + idx0;
                                    idx2 = 2 * s7;
                                    t2[idx2] = a2[idx1];
                                    t2[idx2 + 1] = a2[idx1 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(t2, 0, scale);
                                for (s7 = 0; s7 < FloatFFT_3D.this.slices; ++s7) {
                                    idx1 = s7 * FloatFFT_3D.this.sliceStride + idx0;
                                    idx2 = 2 * s7;
                                    a2[idx1] = t2[idx2];
                                    a2[idx1 + 1] = t2[idx2 + 1];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void cdft3db_subth(final int isgn, final FloatLargeArray a2, final boolean scale) {
        final int nthreads = (int)FastMath.min((long)ConcurrencyUtils.getNumberOfThreads(), (long)this.rowsl);
        long nt = this.slicesl;
        if (nt < this.rowsl) {
            nt = this.rowsl;
        }
        nt *= 8L;
        if (this.columnsl == 4L) {
            nt >>= 1;
        } else if (this.columnsl < 4L) {
            nt >>= 2;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final long n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block27: {
                        FloatLargeArray t2;
                        block25: {
                            block28: {
                                block26: {
                                    t2 = new FloatLargeArray(ntf);
                                    if (isgn != -1) break block25;
                                    if (FloatFFT_3D.this.columnsl <= 4L) break block26;
                                    for (long r2 = n0; r2 < FloatFFT_3D.this.rowsl; r2 += (long)nthreads) {
                                        long idx0 = r2 * FloatFFT_3D.this.rowStridel;
                                        for (long c2 = 0L; c2 < FloatFFT_3D.this.columnsl; c2 += 8L) {
                                            long idx5;
                                            long idx4;
                                            long idx3;
                                            long idx2;
                                            long idx1;
                                            long s2;
                                            for (s2 = 0L; s2 < FloatFFT_3D.this.slicesl; ++s2) {
                                                idx1 = s2 * FloatFFT_3D.this.sliceStridel + idx0 + c2;
                                                idx2 = 2L * s2;
                                                idx3 = 2L * FloatFFT_3D.this.slicesl + 2L * s2;
                                                idx4 = idx3 + 2L * FloatFFT_3D.this.slicesl;
                                                idx5 = idx4 + 2L * FloatFFT_3D.this.slicesl;
                                                t2.setFloat(idx2, a2.getFloat(idx1));
                                                t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                                t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                                                t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                                                t2.setFloat(idx4, a2.getFloat(idx1 + 4L));
                                                t2.setFloat(idx4 + 1L, a2.getFloat(idx1 + 5L));
                                                t2.setFloat(idx5, a2.getFloat(idx1 + 6L));
                                                t2.setFloat(idx5 + 1L, a2.getFloat(idx1 + 7L));
                                            }
                                            FloatFFT_3D.this.fftSlices.complexForward(t2, 0L);
                                            FloatFFT_3D.this.fftSlices.complexForward(t2, 2L * FloatFFT_3D.this.slicesl);
                                            FloatFFT_3D.this.fftSlices.complexForward(t2, 4L * FloatFFT_3D.this.slicesl);
                                            FloatFFT_3D.this.fftSlices.complexForward(t2, 6L * FloatFFT_3D.this.slicesl);
                                            for (s2 = 0L; s2 < FloatFFT_3D.this.slicesl; ++s2) {
                                                idx1 = s2 * FloatFFT_3D.this.sliceStridel + idx0 + c2;
                                                idx2 = 2L * s2;
                                                idx3 = 2L * FloatFFT_3D.this.slicesl + 2L * s2;
                                                idx4 = idx3 + 2L * FloatFFT_3D.this.slicesl;
                                                idx5 = idx4 + 2L * FloatFFT_3D.this.slicesl;
                                                a2.setFloat(idx1, t2.getFloat(idx2));
                                                a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                                a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                                                a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                                                a2.setFloat(idx1 + 4L, t2.getFloat(idx4));
                                                a2.setFloat(idx1 + 5L, t2.getFloat(idx4 + 1L));
                                                a2.setFloat(idx1 + 6L, t2.getFloat(idx5));
                                                a2.setFloat(idx1 + 7L, t2.getFloat(idx5 + 1L));
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (FloatFFT_3D.this.columnsl != 4L) break block28;
                                for (long r3 = n0; r3 < FloatFFT_3D.this.rowsl; r3 += (long)nthreads) {
                                    long idx3;
                                    long idx2;
                                    long idx1;
                                    long s3;
                                    long idx0 = r3 * FloatFFT_3D.this.rowStridel;
                                    for (s3 = 0L; s3 < FloatFFT_3D.this.slicesl; ++s3) {
                                        idx1 = s3 * FloatFFT_3D.this.sliceStridel + idx0;
                                        idx2 = 2L * s3;
                                        idx3 = 2L * FloatFFT_3D.this.slicesl + 2L * s3;
                                        t2.setFloat(idx2, a2.getFloat(idx1));
                                        t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                        t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                                        t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                                    }
                                    FloatFFT_3D.this.fftSlices.complexForward(t2, 0L);
                                    FloatFFT_3D.this.fftSlices.complexForward(t2, 2L * FloatFFT_3D.this.slicesl);
                                    for (s3 = 0L; s3 < FloatFFT_3D.this.slicesl; ++s3) {
                                        idx1 = s3 * FloatFFT_3D.this.sliceStridel + idx0;
                                        idx2 = 2L * s3;
                                        idx3 = 2L * FloatFFT_3D.this.slicesl + 2L * s3;
                                        a2.setFloat(idx1, t2.getFloat(idx2));
                                        a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                        a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                                        a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                                    }
                                }
                                break block27;
                            }
                            if (FloatFFT_3D.this.columnsl != 2L) break block27;
                            for (long r4 = n0; r4 < FloatFFT_3D.this.rowsl; r4 += (long)nthreads) {
                                long idx2;
                                long idx1;
                                long s4;
                                long idx0 = r4 * FloatFFT_3D.this.rowStridel;
                                for (s4 = 0L; s4 < FloatFFT_3D.this.slicesl; ++s4) {
                                    idx1 = s4 * FloatFFT_3D.this.sliceStridel + idx0;
                                    idx2 = 2L * s4;
                                    t2.setFloat(idx2, a2.getFloat(idx1));
                                    t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(t2, 0L);
                                for (s4 = 0L; s4 < FloatFFT_3D.this.slicesl; ++s4) {
                                    idx1 = s4 * FloatFFT_3D.this.sliceStridel + idx0;
                                    idx2 = 2L * s4;
                                    a2.setFloat(idx1, t2.getFloat(idx2));
                                    a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                }
                            }
                            break block27;
                        }
                        if (FloatFFT_3D.this.columnsl > 4L) {
                            for (long r5 = n0; r5 < FloatFFT_3D.this.rowsl; r5 += (long)nthreads) {
                                long idx0 = r5 * FloatFFT_3D.this.rowStridel;
                                for (long c3 = 0L; c3 < FloatFFT_3D.this.columnsl; c3 += 8L) {
                                    long idx5;
                                    long idx4;
                                    long idx3;
                                    long idx2;
                                    long idx1;
                                    long s5;
                                    for (s5 = 0L; s5 < FloatFFT_3D.this.slicesl; ++s5) {
                                        idx1 = s5 * FloatFFT_3D.this.sliceStridel + idx0 + c3;
                                        idx2 = 2L * s5;
                                        idx3 = 2L * FloatFFT_3D.this.slicesl + 2L * s5;
                                        idx4 = idx3 + 2L * FloatFFT_3D.this.slicesl;
                                        idx5 = idx4 + 2L * FloatFFT_3D.this.slicesl;
                                        t2.setFloat(idx2, a2.getFloat(idx1));
                                        t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                        t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                                        t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                                        t2.setFloat(idx4, a2.getFloat(idx1 + 4L));
                                        t2.setFloat(idx4 + 1L, a2.getFloat(idx1 + 5L));
                                        t2.setFloat(idx5, a2.getFloat(idx1 + 6L));
                                        t2.setFloat(idx5 + 1L, a2.getFloat(idx1 + 7L));
                                    }
                                    FloatFFT_3D.this.fftSlices.complexInverse(t2, 0L, scale);
                                    FloatFFT_3D.this.fftSlices.complexInverse(t2, 2L * FloatFFT_3D.this.slicesl, scale);
                                    FloatFFT_3D.this.fftSlices.complexInverse(t2, 4L * FloatFFT_3D.this.slicesl, scale);
                                    FloatFFT_3D.this.fftSlices.complexInverse(t2, 6L * FloatFFT_3D.this.slicesl, scale);
                                    for (s5 = 0L; s5 < FloatFFT_3D.this.slicesl; ++s5) {
                                        idx1 = s5 * FloatFFT_3D.this.sliceStridel + idx0 + c3;
                                        idx2 = 2L * s5;
                                        idx3 = 2L * FloatFFT_3D.this.slicesl + 2L * s5;
                                        idx4 = idx3 + 2L * FloatFFT_3D.this.slicesl;
                                        idx5 = idx4 + 2L * FloatFFT_3D.this.slicesl;
                                        a2.setFloat(idx1, t2.getFloat(idx2));
                                        a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                        a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                                        a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                                        a2.setFloat(idx1 + 4L, t2.getFloat(idx4));
                                        a2.setFloat(idx1 + 5L, t2.getFloat(idx4 + 1L));
                                        a2.setFloat(idx1 + 6L, t2.getFloat(idx5));
                                        a2.setFloat(idx1 + 7L, t2.getFloat(idx5 + 1L));
                                    }
                                }
                            }
                        } else if (FloatFFT_3D.this.columnsl == 4L) {
                            for (long r6 = n0; r6 < FloatFFT_3D.this.rowsl; r6 += (long)nthreads) {
                                long idx3;
                                long idx2;
                                long idx1;
                                long s6;
                                long idx0 = r6 * FloatFFT_3D.this.rowStridel;
                                for (s6 = 0L; s6 < FloatFFT_3D.this.slicesl; ++s6) {
                                    idx1 = s6 * FloatFFT_3D.this.sliceStridel + idx0;
                                    idx2 = 2L * s6;
                                    idx3 = 2L * FloatFFT_3D.this.slicesl + 2L * s6;
                                    t2.setFloat(idx2, a2.getFloat(idx1));
                                    t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                    t2.setFloat(idx3, a2.getFloat(idx1 + 2L));
                                    t2.setFloat(idx3 + 1L, a2.getFloat(idx1 + 3L));
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(t2, 0L, scale);
                                FloatFFT_3D.this.fftSlices.complexInverse(t2, 2L * FloatFFT_3D.this.slicesl, scale);
                                for (s6 = 0L; s6 < FloatFFT_3D.this.slicesl; ++s6) {
                                    idx1 = s6 * FloatFFT_3D.this.sliceStridel + idx0;
                                    idx2 = 2L * s6;
                                    idx3 = 2L * FloatFFT_3D.this.slicesl + 2L * s6;
                                    a2.setFloat(idx1, t2.getFloat(idx2));
                                    a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                    a2.setFloat(idx1 + 2L, t2.getFloat(idx3));
                                    a2.setFloat(idx1 + 3L, t2.getFloat(idx3 + 1L));
                                }
                            }
                        } else if (FloatFFT_3D.this.columnsl == 2L) {
                            for (long r7 = n0; r7 < FloatFFT_3D.this.rowsl; r7 += (long)nthreads) {
                                long idx2;
                                long idx1;
                                long s7;
                                long idx0 = r7 * FloatFFT_3D.this.rowStridel;
                                for (s7 = 0L; s7 < FloatFFT_3D.this.slicesl; ++s7) {
                                    idx1 = s7 * FloatFFT_3D.this.sliceStridel + idx0;
                                    idx2 = 2L * s7;
                                    t2.setFloat(idx2, a2.getFloat(idx1));
                                    t2.setFloat(idx2 + 1L, a2.getFloat(idx1 + 1L));
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(t2, 0L, scale);
                                for (s7 = 0L; s7 < FloatFFT_3D.this.slicesl; ++s7) {
                                    idx1 = s7 * FloatFFT_3D.this.sliceStridel + idx0;
                                    idx2 = 2L * s7;
                                    a2.setFloat(idx1, t2.getFloat(idx2));
                                    a2.setFloat(idx1 + 1L, t2.getFloat(idx2 + 1L));
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void cdft3db_subth(final int isgn, final float[][][] a2, final boolean scale) {
        final int nthreads = FastMath.min((int)ConcurrencyUtils.getNumberOfThreads(), (int)this.rows);
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block27: {
                        float[] t2;
                        block25: {
                            block28: {
                                block26: {
                                    t2 = new float[ntf];
                                    if (isgn != -1) break block25;
                                    if (FloatFFT_3D.this.columns <= 4) break block26;
                                    for (int r2 = n0; r2 < FloatFFT_3D.this.rows; r2 += nthreads) {
                                        for (int c2 = 0; c2 < FloatFFT_3D.this.columns; c2 += 8) {
                                            int idx5;
                                            int idx4;
                                            int idx3;
                                            int idx2;
                                            int s2;
                                            for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                                idx2 = 2 * s2;
                                                idx3 = 2 * FloatFFT_3D.this.slices + 2 * s2;
                                                idx4 = idx3 + 2 * FloatFFT_3D.this.slices;
                                                idx5 = idx4 + 2 * FloatFFT_3D.this.slices;
                                                t2[idx2] = a2[s2][r2][c2];
                                                t2[idx2 + 1] = a2[s2][r2][c2 + 1];
                                                t2[idx3] = a2[s2][r2][c2 + 2];
                                                t2[idx3 + 1] = a2[s2][r2][c2 + 3];
                                                t2[idx4] = a2[s2][r2][c2 + 4];
                                                t2[idx4 + 1] = a2[s2][r2][c2 + 5];
                                                t2[idx5] = a2[s2][r2][c2 + 6];
                                                t2[idx5 + 1] = a2[s2][r2][c2 + 7];
                                            }
                                            FloatFFT_3D.this.fftSlices.complexForward(t2, 0);
                                            FloatFFT_3D.this.fftSlices.complexForward(t2, 2 * FloatFFT_3D.this.slices);
                                            FloatFFT_3D.this.fftSlices.complexForward(t2, 4 * FloatFFT_3D.this.slices);
                                            FloatFFT_3D.this.fftSlices.complexForward(t2, 6 * FloatFFT_3D.this.slices);
                                            for (s2 = 0; s2 < FloatFFT_3D.this.slices; ++s2) {
                                                idx2 = 2 * s2;
                                                idx3 = 2 * FloatFFT_3D.this.slices + 2 * s2;
                                                idx4 = idx3 + 2 * FloatFFT_3D.this.slices;
                                                idx5 = idx4 + 2 * FloatFFT_3D.this.slices;
                                                a2[s2][r2][c2] = t2[idx2];
                                                a2[s2][r2][c2 + 1] = t2[idx2 + 1];
                                                a2[s2][r2][c2 + 2] = t2[idx3];
                                                a2[s2][r2][c2 + 3] = t2[idx3 + 1];
                                                a2[s2][r2][c2 + 4] = t2[idx4];
                                                a2[s2][r2][c2 + 5] = t2[idx4 + 1];
                                                a2[s2][r2][c2 + 6] = t2[idx5];
                                                a2[s2][r2][c2 + 7] = t2[idx5 + 1];
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (FloatFFT_3D.this.columns != 4) break block28;
                                for (int r3 = n0; r3 < FloatFFT_3D.this.rows; r3 += nthreads) {
                                    int idx3;
                                    int idx2;
                                    int s3;
                                    for (s3 = 0; s3 < FloatFFT_3D.this.slices; ++s3) {
                                        idx2 = 2 * s3;
                                        idx3 = 2 * FloatFFT_3D.this.slices + 2 * s3;
                                        t2[idx2] = a2[s3][r3][0];
                                        t2[idx2 + 1] = a2[s3][r3][1];
                                        t2[idx3] = a2[s3][r3][2];
                                        t2[idx3 + 1] = a2[s3][r3][3];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexForward(t2, 0);
                                    FloatFFT_3D.this.fftSlices.complexForward(t2, 2 * FloatFFT_3D.this.slices);
                                    for (s3 = 0; s3 < FloatFFT_3D.this.slices; ++s3) {
                                        idx2 = 2 * s3;
                                        idx3 = 2 * FloatFFT_3D.this.slices + 2 * s3;
                                        a2[s3][r3][0] = t2[idx2];
                                        a2[s3][r3][1] = t2[idx2 + 1];
                                        a2[s3][r3][2] = t2[idx3];
                                        a2[s3][r3][3] = t2[idx3 + 1];
                                    }
                                }
                                break block27;
                            }
                            if (FloatFFT_3D.this.columns != 2) break block27;
                            for (int r4 = n0; r4 < FloatFFT_3D.this.rows; r4 += nthreads) {
                                int idx2;
                                int s4;
                                for (s4 = 0; s4 < FloatFFT_3D.this.slices; ++s4) {
                                    idx2 = 2 * s4;
                                    t2[idx2] = a2[s4][r4][0];
                                    t2[idx2 + 1] = a2[s4][r4][1];
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(t2, 0);
                                for (s4 = 0; s4 < FloatFFT_3D.this.slices; ++s4) {
                                    idx2 = 2 * s4;
                                    a2[s4][r4][0] = t2[idx2];
                                    a2[s4][r4][1] = t2[idx2 + 1];
                                }
                            }
                            break block27;
                        }
                        if (FloatFFT_3D.this.columns > 4) {
                            for (int r5 = n0; r5 < FloatFFT_3D.this.rows; r5 += nthreads) {
                                for (int c3 = 0; c3 < FloatFFT_3D.this.columns; c3 += 8) {
                                    int idx5;
                                    int idx4;
                                    int idx3;
                                    int idx2;
                                    int s5;
                                    for (s5 = 0; s5 < FloatFFT_3D.this.slices; ++s5) {
                                        idx2 = 2 * s5;
                                        idx3 = 2 * FloatFFT_3D.this.slices + 2 * s5;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.slices;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.slices;
                                        t2[idx2] = a2[s5][r5][c3];
                                        t2[idx2 + 1] = a2[s5][r5][c3 + 1];
                                        t2[idx3] = a2[s5][r5][c3 + 2];
                                        t2[idx3 + 1] = a2[s5][r5][c3 + 3];
                                        t2[idx4] = a2[s5][r5][c3 + 4];
                                        t2[idx4 + 1] = a2[s5][r5][c3 + 5];
                                        t2[idx5] = a2[s5][r5][c3 + 6];
                                        t2[idx5 + 1] = a2[s5][r5][c3 + 7];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexInverse(t2, 0, scale);
                                    FloatFFT_3D.this.fftSlices.complexInverse(t2, 2 * FloatFFT_3D.this.slices, scale);
                                    FloatFFT_3D.this.fftSlices.complexInverse(t2, 4 * FloatFFT_3D.this.slices, scale);
                                    FloatFFT_3D.this.fftSlices.complexInverse(t2, 6 * FloatFFT_3D.this.slices, scale);
                                    for (s5 = 0; s5 < FloatFFT_3D.this.slices; ++s5) {
                                        idx2 = 2 * s5;
                                        idx3 = 2 * FloatFFT_3D.this.slices + 2 * s5;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.slices;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.slices;
                                        a2[s5][r5][c3] = t2[idx2];
                                        a2[s5][r5][c3 + 1] = t2[idx2 + 1];
                                        a2[s5][r5][c3 + 2] = t2[idx3];
                                        a2[s5][r5][c3 + 3] = t2[idx3 + 1];
                                        a2[s5][r5][c3 + 4] = t2[idx4];
                                        a2[s5][r5][c3 + 5] = t2[idx4 + 1];
                                        a2[s5][r5][c3 + 6] = t2[idx5];
                                        a2[s5][r5][c3 + 7] = t2[idx5 + 1];
                                    }
                                }
                            }
                        } else if (FloatFFT_3D.this.columns == 4) {
                            for (int r6 = n0; r6 < FloatFFT_3D.this.rows; r6 += nthreads) {
                                int idx3;
                                int idx2;
                                int s6;
                                for (s6 = 0; s6 < FloatFFT_3D.this.slices; ++s6) {
                                    idx2 = 2 * s6;
                                    idx3 = 2 * FloatFFT_3D.this.slices + 2 * s6;
                                    t2[idx2] = a2[s6][r6][0];
                                    t2[idx2 + 1] = a2[s6][r6][1];
                                    t2[idx3] = a2[s6][r6][2];
                                    t2[idx3 + 1] = a2[s6][r6][3];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(t2, 0, scale);
                                FloatFFT_3D.this.fftSlices.complexInverse(t2, 2 * FloatFFT_3D.this.slices, scale);
                                for (s6 = 0; s6 < FloatFFT_3D.this.slices; ++s6) {
                                    idx2 = 2 * s6;
                                    idx3 = 2 * FloatFFT_3D.this.slices + 2 * s6;
                                    a2[s6][r6][0] = t2[idx2];
                                    a2[s6][r6][1] = t2[idx2 + 1];
                                    a2[s6][r6][2] = t2[idx3];
                                    a2[s6][r6][3] = t2[idx3 + 1];
                                }
                            }
                        } else if (FloatFFT_3D.this.columns == 2) {
                            for (int r7 = n0; r7 < FloatFFT_3D.this.rows; r7 += nthreads) {
                                int idx2;
                                int s7;
                                for (s7 = 0; s7 < FloatFFT_3D.this.slices; ++s7) {
                                    idx2 = 2 * s7;
                                    t2[idx2] = a2[s7][r7][0];
                                    t2[idx2 + 1] = a2[s7][r7][1];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(t2, 0, scale);
                                for (s7 = 0; s7 < FloatFFT_3D.this.slices; ++s7) {
                                    idx2 = 2 * s7;
                                    a2[s7][r7][0] = t2[idx2];
                                    a2[s7][r7][1] = t2[idx2 + 1];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void rdft3d_sub(int isgn, float[] a2) {
        int n1h = this.slices >> 1;
        int n2h = this.rows >> 1;
        if (isgn < 0) {
            int l2;
            int k2;
            float xi;
            int idx4;
            int idx3;
            int idx2;
            int idx1;
            for (int i2 = 1; i2 < n1h; ++i2) {
                int j2 = this.slices - i2;
                idx1 = i2 * this.sliceStride;
                idx2 = j2 * this.sliceStride;
                idx3 = i2 * this.sliceStride + n2h * this.rowStride;
                idx4 = j2 * this.sliceStride + n2h * this.rowStride;
                xi = a2[idx1] - a2[idx2];
                int n2 = idx1;
                a2[n2] = a2[n2] + a2[idx2];
                a2[idx2] = xi;
                xi = a2[idx2 + 1] - a2[idx1 + 1];
                int n3 = idx1 + 1;
                a2[n3] = a2[n3] + a2[idx2 + 1];
                a2[idx2 + 1] = xi;
                xi = a2[idx3] - a2[idx4];
                int n4 = idx3;
                a2[n4] = a2[n4] + a2[idx4];
                a2[idx4] = xi;
                xi = a2[idx4 + 1] - a2[idx3 + 1];
                int n5 = idx3 + 1;
                a2[n5] = a2[n5] + a2[idx4 + 1];
                a2[idx4 + 1] = xi;
                for (k2 = 1; k2 < n2h; ++k2) {
                    l2 = this.rows - k2;
                    idx1 = i2 * this.sliceStride + k2 * this.rowStride;
                    idx2 = j2 * this.sliceStride + l2 * this.rowStride;
                    xi = a2[idx1] - a2[idx2];
                    int n6 = idx1;
                    a2[n6] = a2[n6] + a2[idx2];
                    a2[idx2] = xi;
                    xi = a2[idx2 + 1] - a2[idx1 + 1];
                    int n7 = idx1 + 1;
                    a2[n7] = a2[n7] + a2[idx2 + 1];
                    a2[idx2 + 1] = xi;
                    idx3 = j2 * this.sliceStride + k2 * this.rowStride;
                    idx4 = i2 * this.sliceStride + l2 * this.rowStride;
                    xi = a2[idx3] - a2[idx4];
                    int n8 = idx3;
                    a2[n8] = a2[n8] + a2[idx4];
                    a2[idx4] = xi;
                    xi = a2[idx4 + 1] - a2[idx3 + 1];
                    int n9 = idx3 + 1;
                    a2[n9] = a2[n9] + a2[idx4 + 1];
                    a2[idx4 + 1] = xi;
                }
            }
            for (k2 = 1; k2 < n2h; ++k2) {
                l2 = this.rows - k2;
                idx1 = k2 * this.rowStride;
                idx2 = l2 * this.rowStride;
                xi = a2[idx1] - a2[idx2];
                int n10 = idx1;
                a2[n10] = a2[n10] + a2[idx2];
                a2[idx2] = xi;
                xi = a2[idx2 + 1] - a2[idx1 + 1];
                int n11 = idx1 + 1;
                a2[n11] = a2[n11] + a2[idx2 + 1];
                a2[idx2 + 1] = xi;
                idx3 = n1h * this.sliceStride + k2 * this.rowStride;
                idx4 = n1h * this.sliceStride + l2 * this.rowStride;
                xi = a2[idx3] - a2[idx4];
                int n12 = idx3;
                a2[n12] = a2[n12] + a2[idx4];
                a2[idx4] = xi;
                xi = a2[idx4 + 1] - a2[idx3 + 1];
                int n13 = idx3 + 1;
                a2[n13] = a2[n13] + a2[idx4 + 1];
                a2[idx4 + 1] = xi;
            }
        } else {
            int l3;
            int k3;
            int idx4;
            int idx3;
            int idx2;
            int idx1;
            for (int i3 = 1; i3 < n1h; ++i3) {
                int j3 = this.slices - i3;
                idx1 = j3 * this.sliceStride;
                idx2 = i3 * this.sliceStride;
                a2[idx1] = 0.5f * (a2[idx2] - a2[idx1]);
                int n14 = idx2;
                a2[n14] = a2[n14] - a2[idx1];
                a2[idx1 + 1] = 0.5f * (a2[idx2 + 1] + a2[idx1 + 1]);
                int n15 = idx2 + 1;
                a2[n15] = a2[n15] - a2[idx1 + 1];
                idx3 = j3 * this.sliceStride + n2h * this.rowStride;
                idx4 = i3 * this.sliceStride + n2h * this.rowStride;
                a2[idx3] = 0.5f * (a2[idx4] - a2[idx3]);
                int n16 = idx4;
                a2[n16] = a2[n16] - a2[idx3];
                a2[idx3 + 1] = 0.5f * (a2[idx4 + 1] + a2[idx3 + 1]);
                int n17 = idx4 + 1;
                a2[n17] = a2[n17] - a2[idx3 + 1];
                for (k3 = 1; k3 < n2h; ++k3) {
                    l3 = this.rows - k3;
                    idx1 = j3 * this.sliceStride + l3 * this.rowStride;
                    idx2 = i3 * this.sliceStride + k3 * this.rowStride;
                    a2[idx1] = 0.5f * (a2[idx2] - a2[idx1]);
                    int n18 = idx2;
                    a2[n18] = a2[n18] - a2[idx1];
                    a2[idx1 + 1] = 0.5f * (a2[idx2 + 1] + a2[idx1 + 1]);
                    int n19 = idx2 + 1;
                    a2[n19] = a2[n19] - a2[idx1 + 1];
                    idx3 = i3 * this.sliceStride + l3 * this.rowStride;
                    idx4 = j3 * this.sliceStride + k3 * this.rowStride;
                    a2[idx3] = 0.5f * (a2[idx4] - a2[idx3]);
                    int n20 = idx4;
                    a2[n20] = a2[n20] - a2[idx3];
                    a2[idx3 + 1] = 0.5f * (a2[idx4 + 1] + a2[idx3 + 1]);
                    int n21 = idx4 + 1;
                    a2[n21] = a2[n21] - a2[idx3 + 1];
                }
            }
            for (k3 = 1; k3 < n2h; ++k3) {
                l3 = this.rows - k3;
                idx1 = l3 * this.rowStride;
                idx2 = k3 * this.rowStride;
                a2[idx1] = 0.5f * (a2[idx2] - a2[idx1]);
                int n22 = idx2;
                a2[n22] = a2[n22] - a2[idx1];
                a2[idx1 + 1] = 0.5f * (a2[idx2 + 1] + a2[idx1 + 1]);
                int n23 = idx2 + 1;
                a2[n23] = a2[n23] - a2[idx1 + 1];
                idx3 = n1h * this.sliceStride + l3 * this.rowStride;
                idx4 = n1h * this.sliceStride + k3 * this.rowStride;
                a2[idx3] = 0.5f * (a2[idx4] - a2[idx3]);
                int n24 = idx4;
                a2[n24] = a2[n24] - a2[idx3];
                a2[idx3 + 1] = 0.5f * (a2[idx4 + 1] + a2[idx3 + 1]);
                int n25 = idx4 + 1;
                a2[n25] = a2[n25] - a2[idx3 + 1];
            }
        }
    }

    private void rdft3d_sub(int isgn, FloatLargeArray a2) {
        long n1h = this.slicesl >> 1;
        long n2h = this.rowsl >> 1;
        if (isgn < 0) {
            long l2;
            long k2;
            float xi;
            long idx4;
            long idx3;
            long idx2;
            long idx1;
            for (long i2 = 1L; i2 < n1h; ++i2) {
                long j2 = this.slicesl - i2;
                idx1 = i2 * this.sliceStridel;
                idx2 = j2 * this.sliceStridel;
                idx3 = i2 * this.sliceStridel + n2h * this.rowStridel;
                idx4 = j2 * this.sliceStridel + n2h * this.rowStridel;
                xi = a2.getFloat(idx1) - a2.getFloat(idx2);
                a2.setFloat(idx1, a2.getFloat(idx1) + a2.getFloat(idx2));
                a2.setFloat(idx2, xi);
                xi = a2.getFloat(idx2 + 1L) - a2.getFloat(idx1 + 1L);
                a2.setFloat(idx1 + 1L, a2.getFloat(idx1 + 1L) + a2.getFloat(idx2 + 1L));
                a2.setFloat(idx2 + 1L, xi);
                xi = a2.getFloat(idx3) - a2.getFloat(idx4);
                a2.setFloat(idx3, a2.getFloat(idx3) + a2.getFloat(idx4));
                a2.setFloat(idx4, xi);
                xi = a2.getFloat(idx4 + 1L) - a2.getFloat(idx3 + 1L);
                a2.setFloat(idx3 + 1L, a2.getFloat(idx3 + 1L) + a2.getFloat(idx4 + 1L));
                a2.setFloat(idx4 + 1L, xi);
                for (k2 = 1L; k2 < n2h; ++k2) {
                    l2 = this.rowsl - k2;
                    idx1 = i2 * this.sliceStridel + k2 * this.rowStridel;
                    idx2 = j2 * this.sliceStridel + l2 * this.rowStridel;
                    xi = a2.getFloat(idx1) - a2.getFloat(idx2);
                    a2.setFloat(idx1, a2.getFloat(idx1) + a2.getFloat(idx2));
                    a2.setFloat(idx2, xi);
                    xi = a2.getFloat(idx2 + 1L) - a2.getFloat(idx1 + 1L);
                    a2.setFloat(idx1 + 1L, a2.getFloat(idx1 + 1L) + a2.getFloat(idx2 + 1L));
                    a2.setFloat(idx2 + 1L, xi);
                    idx3 = j2 * this.sliceStridel + k2 * this.rowStridel;
                    idx4 = i2 * this.sliceStridel + l2 * this.rowStridel;
                    xi = a2.getFloat(idx3) - a2.getFloat(idx4);
                    a2.setFloat(idx3, a2.getFloat(idx3) + a2.getFloat(idx4));
                    a2.setFloat(idx4, xi);
                    xi = a2.getFloat(idx4 + 1L) - a2.getFloat(idx3 + 1L);
                    a2.setFloat(idx3 + 1L, a2.getFloat(idx3 + 1L) + a2.getFloat(idx4 + 1L));
                    a2.setFloat(idx4 + 1L, xi);
                }
            }
            for (k2 = 1L; k2 < n2h; ++k2) {
                l2 = this.rowsl - k2;
                idx1 = k2 * this.rowStridel;
                idx2 = l2 * this.rowStridel;
                xi = a2.getFloat(idx1) - a2.getFloat(idx2);
                a2.setFloat(idx1, a2.getFloat(idx1) + a2.getFloat(idx2));
                a2.setFloat(idx2, xi);
                xi = a2.getFloat(idx2 + 1L) - a2.getFloat(idx1 + 1L);
                a2.setFloat(idx1 + 1L, a2.getFloat(idx1 + 1L) + a2.getFloat(idx2 + 1L));
                a2.setFloat(idx2 + 1L, xi);
                idx3 = n1h * this.sliceStridel + k2 * this.rowStridel;
                idx4 = n1h * this.sliceStridel + l2 * this.rowStridel;
                xi = a2.getFloat(idx3) - a2.getFloat(idx4);
                a2.setFloat(idx3, a2.getFloat(idx3) + a2.getFloat(idx4));
                a2.setFloat(idx4, xi);
                xi = a2.getFloat(idx4 + 1L) - a2.getFloat(idx3 + 1L);
                a2.setFloat(idx3 + 1L, a2.getFloat(idx3 + 1L) + a2.getFloat(idx4 + 1L));
                a2.setFloat(idx4 + 1L, xi);
            }
        } else {
            long l3;
            long k3;
            long idx4;
            long idx3;
            long idx2;
            long idx1;
            for (long i3 = 1L; i3 < n1h; ++i3) {
                long j3 = this.slicesl - i3;
                idx1 = j3 * this.sliceStridel;
                idx2 = i3 * this.sliceStridel;
                a2.setFloat(idx1, 0.5f * (a2.getFloat(idx2) - a2.getFloat(idx1)));
                a2.setFloat(idx2, a2.getFloat(idx2) - a2.getFloat(idx1));
                a2.setFloat(idx1 + 1L, 0.5f * (a2.getFloat(idx2 + 1L) + a2.getFloat(idx1 + 1L)));
                a2.setFloat(idx2 + 1L, a2.getFloat(idx2 + 1L) - a2.getFloat(idx1 + 1L));
                idx3 = j3 * this.sliceStridel + n2h * this.rowStridel;
                idx4 = i3 * this.sliceStridel + n2h * this.rowStridel;
                a2.setFloat(idx3, 0.5f * (a2.getFloat(idx4) - a2.getFloat(idx3)));
                a2.setFloat(idx4, a2.getFloat(idx4) - a2.getFloat(idx3));
                a2.setFloat(idx3 + 1L, 0.5f * (a2.getFloat(idx4 + 1L) + a2.getFloat(idx3 + 1L)));
                a2.setFloat(idx4 + 1L, a2.getFloat(idx4 + 1L) - a2.getFloat(idx3 + 1L));
                for (k3 = 1L; k3 < n2h; ++k3) {
                    l3 = this.rowsl - k3;
                    idx1 = j3 * this.sliceStridel + l3 * this.rowStridel;
                    idx2 = i3 * this.sliceStridel + k3 * this.rowStridel;
                    a2.setFloat(idx1, 0.5f * (a2.getFloat(idx2) - a2.getFloat(idx1)));
                    a2.setFloat(idx2, a2.getFloat(idx2) - a2.getFloat(idx1));
                    a2.setFloat(idx1 + 1L, 0.5f * (a2.getFloat(idx2 + 1L) + a2.getFloat(idx1 + 1L)));
                    a2.setFloat(idx2 + 1L, a2.getFloat(idx2 + 1L) - a2.getFloat(idx1 + 1L));
                    idx3 = i3 * this.sliceStridel + l3 * this.rowStridel;
                    idx4 = j3 * this.sliceStridel + k3 * this.rowStridel;
                    a2.setFloat(idx3, 0.5f * (a2.getFloat(idx4) - a2.getFloat(idx3)));
                    a2.setFloat(idx4, a2.getFloat(idx4) - a2.getFloat(idx3));
                    a2.setFloat(idx3 + 1L, 0.5f * (a2.getFloat(idx4 + 1L) + a2.getFloat(idx3 + 1L)));
                    a2.setFloat(idx4 + 1L, a2.getFloat(idx4 + 1L) - a2.getFloat(idx3 + 1L));
                }
            }
            for (k3 = 1L; k3 < n2h; ++k3) {
                l3 = this.rowsl - k3;
                idx1 = l3 * this.rowStridel;
                idx2 = k3 * this.rowStridel;
                a2.setFloat(idx1, 0.5f * (a2.getFloat(idx2) - a2.getFloat(idx1)));
                a2.setFloat(idx2, a2.getFloat(idx2) - a2.getFloat(idx1));
                a2.setFloat(idx1 + 1L, 0.5f * (a2.getFloat(idx2 + 1L) + a2.getFloat(idx1 + 1L)));
                a2.setFloat(idx2 + 1L, a2.getFloat(idx2 + 1L) - a2.getFloat(idx1 + 1L));
                idx3 = n1h * this.sliceStridel + l3 * this.rowStridel;
                idx4 = n1h * this.sliceStridel + k3 * this.rowStridel;
                a2.setFloat(idx3, 0.5f * (a2.getFloat(idx4) - a2.getFloat(idx3)));
                a2.setFloat(idx4, a2.getFloat(idx4) - a2.getFloat(idx3));
                a2.setFloat(idx3 + 1L, 0.5f * (a2.getFloat(idx4 + 1L) + a2.getFloat(idx3 + 1L)));
                a2.setFloat(idx4 + 1L, a2.getFloat(idx4 + 1L) - a2.getFloat(idx3 + 1L));
            }
        }
    }

    private void rdft3d_sub(int isgn, float[][][] a2) {
        int n1h = this.slices >> 1;
        int n2h = this.rows >> 1;
        if (isgn < 0) {
            int l2;
            int k2;
            float xi;
            for (int i2 = 1; i2 < n1h; ++i2) {
                int j2 = this.slices - i2;
                xi = a2[i2][0][0] - a2[j2][0][0];
                float[] fArray = a2[i2][0];
                fArray[0] = fArray[0] + a2[j2][0][0];
                a2[j2][0][0] = xi;
                xi = a2[j2][0][1] - a2[i2][0][1];
                float[] fArray2 = a2[i2][0];
                fArray2[1] = fArray2[1] + a2[j2][0][1];
                a2[j2][0][1] = xi;
                xi = a2[i2][n2h][0] - a2[j2][n2h][0];
                float[] fArray3 = a2[i2][n2h];
                fArray3[0] = fArray3[0] + a2[j2][n2h][0];
                a2[j2][n2h][0] = xi;
                xi = a2[j2][n2h][1] - a2[i2][n2h][1];
                float[] fArray4 = a2[i2][n2h];
                fArray4[1] = fArray4[1] + a2[j2][n2h][1];
                a2[j2][n2h][1] = xi;
                for (k2 = 1; k2 < n2h; ++k2) {
                    l2 = this.rows - k2;
                    xi = a2[i2][k2][0] - a2[j2][l2][0];
                    float[] fArray5 = a2[i2][k2];
                    fArray5[0] = fArray5[0] + a2[j2][l2][0];
                    a2[j2][l2][0] = xi;
                    xi = a2[j2][l2][1] - a2[i2][k2][1];
                    float[] fArray6 = a2[i2][k2];
                    fArray6[1] = fArray6[1] + a2[j2][l2][1];
                    a2[j2][l2][1] = xi;
                    xi = a2[j2][k2][0] - a2[i2][l2][0];
                    float[] fArray7 = a2[j2][k2];
                    fArray7[0] = fArray7[0] + a2[i2][l2][0];
                    a2[i2][l2][0] = xi;
                    xi = a2[i2][l2][1] - a2[j2][k2][1];
                    float[] fArray8 = a2[j2][k2];
                    fArray8[1] = fArray8[1] + a2[i2][l2][1];
                    a2[i2][l2][1] = xi;
                }
            }
            for (k2 = 1; k2 < n2h; ++k2) {
                l2 = this.rows - k2;
                xi = a2[0][k2][0] - a2[0][l2][0];
                float[] fArray = a2[0][k2];
                fArray[0] = fArray[0] + a2[0][l2][0];
                a2[0][l2][0] = xi;
                xi = a2[0][l2][1] - a2[0][k2][1];
                float[] fArray9 = a2[0][k2];
                fArray9[1] = fArray9[1] + a2[0][l2][1];
                a2[0][l2][1] = xi;
                xi = a2[n1h][k2][0] - a2[n1h][l2][0];
                float[] fArray10 = a2[n1h][k2];
                fArray10[0] = fArray10[0] + a2[n1h][l2][0];
                a2[n1h][l2][0] = xi;
                xi = a2[n1h][l2][1] - a2[n1h][k2][1];
                float[] fArray11 = a2[n1h][k2];
                fArray11[1] = fArray11[1] + a2[n1h][l2][1];
                a2[n1h][l2][1] = xi;
            }
        } else {
            int l3;
            int k3;
            for (int i3 = 1; i3 < n1h; ++i3) {
                int j3 = this.slices - i3;
                a2[j3][0][0] = 0.5f * (a2[i3][0][0] - a2[j3][0][0]);
                float[] fArray = a2[i3][0];
                fArray[0] = fArray[0] - a2[j3][0][0];
                a2[j3][0][1] = 0.5f * (a2[i3][0][1] + a2[j3][0][1]);
                float[] fArray12 = a2[i3][0];
                fArray12[1] = fArray12[1] - a2[j3][0][1];
                a2[j3][n2h][0] = 0.5f * (a2[i3][n2h][0] - a2[j3][n2h][0]);
                float[] fArray13 = a2[i3][n2h];
                fArray13[0] = fArray13[0] - a2[j3][n2h][0];
                a2[j3][n2h][1] = 0.5f * (a2[i3][n2h][1] + a2[j3][n2h][1]);
                float[] fArray14 = a2[i3][n2h];
                fArray14[1] = fArray14[1] - a2[j3][n2h][1];
                for (k3 = 1; k3 < n2h; ++k3) {
                    l3 = this.rows - k3;
                    a2[j3][l3][0] = 0.5f * (a2[i3][k3][0] - a2[j3][l3][0]);
                    float[] fArray15 = a2[i3][k3];
                    fArray15[0] = fArray15[0] - a2[j3][l3][0];
                    a2[j3][l3][1] = 0.5f * (a2[i3][k3][1] + a2[j3][l3][1]);
                    float[] fArray16 = a2[i3][k3];
                    fArray16[1] = fArray16[1] - a2[j3][l3][1];
                    a2[i3][l3][0] = 0.5f * (a2[j3][k3][0] - a2[i3][l3][0]);
                    float[] fArray17 = a2[j3][k3];
                    fArray17[0] = fArray17[0] - a2[i3][l3][0];
                    a2[i3][l3][1] = 0.5f * (a2[j3][k3][1] + a2[i3][l3][1]);
                    float[] fArray18 = a2[j3][k3];
                    fArray18[1] = fArray18[1] - a2[i3][l3][1];
                }
            }
            for (k3 = 1; k3 < n2h; ++k3) {
                l3 = this.rows - k3;
                a2[0][l3][0] = 0.5f * (a2[0][k3][0] - a2[0][l3][0]);
                float[] fArray = a2[0][k3];
                fArray[0] = fArray[0] - a2[0][l3][0];
                a2[0][l3][1] = 0.5f * (a2[0][k3][1] + a2[0][l3][1]);
                float[] fArray19 = a2[0][k3];
                fArray19[1] = fArray19[1] - a2[0][l3][1];
                a2[n1h][l3][0] = 0.5f * (a2[n1h][k3][0] - a2[n1h][l3][0]);
                float[] fArray20 = a2[n1h][k3];
                fArray20[0] = fArray20[0] - a2[n1h][l3][0];
                a2[n1h][l3][1] = 0.5f * (a2[n1h][k3][1] + a2[n1h][l3][1]);
                float[] fArray21 = a2[n1h][k3];
                fArray21[1] = fArray21[1] - a2[n1h][l3][1];
            }
        }
    }

    private void fillSymmetric(final float[][][] a2) {
        int idx1;
        final int twon3 = 2 * this.columns;
        final int n2d2 = this.rows / 2;
        int n1d2 = this.slices / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slices >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p2 = this.slices / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstSlice = l2 * p2;
                lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = (FloatFFT_3D.this.slices - s2) % FloatFFT_3D.this.slices;
                            for (int r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                int idx2 = (FloatFFT_3D.this.rows - r2) % FloatFFT_3D.this.rows;
                                for (int c2 = 1; c2 < FloatFFT_3D.this.columns; c2 += 2) {
                                    int idx3 = twon3 - c2;
                                    a2[idx1][idx2][idx3] = -a2[s2][r2][c2 + 2];
                                    a2[idx1][idx2][idx3 - 1] = a2[s2][r2][c2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = l3 * p2;
                lastSlice = l3 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = (FloatFFT_3D.this.slices - s2) % FloatFFT_3D.this.slices;
                            for (int r2 = 1; r2 < n2d2; ++r2) {
                                int idx2 = FloatFFT_3D.this.rows - r2;
                                a2[idx1][r2][((FloatFFT_3D)FloatFFT_3D.this).columns] = a2[s2][idx2][1];
                                a2[s2][idx2][((FloatFFT_3D)FloatFFT_3D.this).columns] = a2[s2][idx2][1];
                                a2[idx1][r2][((FloatFFT_3D)FloatFFT_3D.this).columns + 1] = -a2[s2][idx2][0];
                                a2[s2][idx2][((FloatFFT_3D)FloatFFT_3D.this).columns + 1] = a2[s2][idx2][0];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l4 = 0; l4 < nthreads; ++l4) {
                firstSlice = l4 * p2;
                lastSlice = l4 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = (FloatFFT_3D.this.slices - s2) % FloatFFT_3D.this.slices;
                            for (int r2 = 1; r2 < n2d2; ++r2) {
                                int idx2 = FloatFFT_3D.this.rows - r2;
                                a2[idx1][idx2][0] = a2[s2][r2][0];
                                a2[idx1][idx2][1] = -a2[s2][r2][1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx2;
            int r2;
            int s2;
            for (s2 = 0; s2 < this.slices; ++s2) {
                idx1 = (this.slices - s2) % this.slices;
                for (r2 = 0; r2 < this.rows; ++r2) {
                    idx2 = (this.rows - r2) % this.rows;
                    for (int c2 = 1; c2 < this.columns; c2 += 2) {
                        int idx3 = twon3 - c2;
                        a2[idx1][idx2][idx3] = -a2[s2][r2][c2 + 2];
                        a2[idx1][idx2][idx3 - 1] = a2[s2][r2][c2 + 1];
                    }
                }
            }
            for (s2 = 0; s2 < this.slices; ++s2) {
                idx1 = (this.slices - s2) % this.slices;
                for (r2 = 1; r2 < n2d2; ++r2) {
                    idx2 = this.rows - r2;
                    a2[idx1][r2][this.columns] = a2[s2][idx2][1];
                    a2[s2][idx2][this.columns] = a2[s2][idx2][1];
                    a2[idx1][r2][this.columns + 1] = -a2[s2][idx2][0];
                    a2[s2][idx2][this.columns + 1] = a2[s2][idx2][0];
                }
            }
            for (s2 = 0; s2 < this.slices; ++s2) {
                idx1 = (this.slices - s2) % this.slices;
                for (r2 = 1; r2 < n2d2; ++r2) {
                    idx2 = this.rows - r2;
                    a2[idx1][idx2][0] = a2[s2][r2][0];
                    a2[idx1][idx2][1] = -a2[s2][r2][1];
                }
            }
        }
        for (int s3 = 1; s3 < n1d2; ++s3) {
            idx1 = this.slices - s3;
            a2[s3][0][this.columns] = a2[idx1][0][1];
            a2[idx1][0][this.columns] = a2[idx1][0][1];
            a2[s3][0][this.columns + 1] = -a2[idx1][0][0];
            a2[idx1][0][this.columns + 1] = a2[idx1][0][0];
            a2[s3][n2d2][this.columns] = a2[idx1][n2d2][1];
            a2[idx1][n2d2][this.columns] = a2[idx1][n2d2][1];
            a2[s3][n2d2][this.columns + 1] = -a2[idx1][n2d2][0];
            a2[idx1][n2d2][this.columns + 1] = a2[idx1][n2d2][0];
            a2[idx1][0][0] = a2[s3][0][0];
            a2[idx1][0][1] = -a2[s3][0][1];
            a2[idx1][n2d2][0] = a2[s3][n2d2][0];
            a2[idx1][n2d2][1] = -a2[s3][n2d2][1];
        }
        a2[0][0][this.columns] = a2[0][0][1];
        a2[0][0][1] = 0.0f;
        a2[0][n2d2][this.columns] = a2[0][n2d2][1];
        a2[0][n2d2][1] = 0.0f;
        a2[n1d2][0][this.columns] = a2[n1d2][0][1];
        a2[n1d2][0][1] = 0.0f;
        a2[n1d2][n2d2][this.columns] = a2[n1d2][n2d2][1];
        a2[n1d2][n2d2][1] = 0.0f;
        a2[n1d2][0][this.columns + 1] = 0.0f;
        a2[n1d2][n2d2][this.columns + 1] = 0.0f;
    }

    private void fillSymmetric(final float[] a2) {
        int idx2;
        int idx1;
        int idx6;
        int idx5;
        int idx4;
        int idx3;
        final int twon3 = 2 * this.columns;
        final int n2d2 = this.rows / 2;
        int n1d2 = this.slices / 2;
        final int twoSliceStride = this.rows * twon3;
        final int twoRowStride = twon3;
        for (int s2 = this.slices - 1; s2 >= 1; --s2) {
            idx3 = s2 * this.sliceStride;
            idx4 = 2 * idx3;
            for (int r2 = 0; r2 < this.rows; ++r2) {
                idx5 = r2 * this.rowStride;
                idx6 = 2 * idx5;
                for (int c2 = 0; c2 < this.columns; c2 += 2) {
                    idx1 = idx3 + idx5 + c2;
                    idx2 = idx4 + idx6 + c2;
                    a2[idx2] = a2[idx1];
                    a2[idx1] = 0.0f;
                    a2[++idx2] = a2[++idx1];
                    a2[idx1] = 0.0f;
                }
            }
        }
        for (int r3 = 1; r3 < this.rows; ++r3) {
            idx3 = (this.rows - r3) * this.rowStride;
            idx4 = (this.rows - r3) * twoRowStride;
            for (int c3 = 0; c3 < this.columns; c3 += 2) {
                idx1 = idx3 + c3;
                idx2 = idx4 + c3;
                a2[idx2] = a2[idx1];
                a2[idx1] = 0.0f;
                a2[++idx2] = a2[++idx1];
                a2[idx1] = 0.0f;
            }
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slices >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p2 = this.slices / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstSlice = l2 * p2;
                lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx3 = (FloatFFT_3D.this.slices - s2) % FloatFFT_3D.this.slices * twoSliceStride;
                            int idx5 = s2 * twoSliceStride;
                            for (int r2 = 0; r2 < FloatFFT_3D.this.rows; ++r2) {
                                int idx4 = (FloatFFT_3D.this.rows - r2) % FloatFFT_3D.this.rows * twoRowStride;
                                int idx6 = r2 * twoRowStride;
                                for (int c2 = 1; c2 < FloatFFT_3D.this.columns; c2 += 2) {
                                    int idx1 = idx3 + idx4 + twon3 - c2;
                                    int idx2 = idx5 + idx6 + c2;
                                    a2[idx1] = -a2[idx2 + 2];
                                    a2[idx1 - 1] = a2[idx2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = l3 * p2;
                lastSlice = l3 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx5 = (FloatFFT_3D.this.slices - s2) % FloatFFT_3D.this.slices * twoSliceStride;
                            int idx6 = s2 * twoSliceStride;
                            for (int r2 = 1; r2 < n2d2; ++r2) {
                                int idx4 = idx6 + (FloatFFT_3D.this.rows - r2) * twoRowStride;
                                int idx1 = idx5 + r2 * twoRowStride + FloatFFT_3D.this.columns;
                                int idx2 = idx4 + FloatFFT_3D.this.columns;
                                int idx3 = idx4 + 1;
                                a2[idx1] = a2[idx3];
                                a2[idx2] = a2[idx3];
                                a2[idx1 + 1] = -a2[idx4];
                                a2[idx2 + 1] = a2[idx4];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l4 = 0; l4 < nthreads; ++l4) {
                firstSlice = l4 * p2;
                lastSlice = l4 == nthreads - 1 ? this.slices : firstSlice + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx3 = (FloatFFT_3D.this.slices - s2) % FloatFFT_3D.this.slices * twoSliceStride;
                            int idx4 = s2 * twoSliceStride;
                            for (int r2 = 1; r2 < n2d2; ++r2) {
                                int idx1 = idx3 + (FloatFFT_3D.this.rows - r2) * twoRowStride;
                                int idx2 = idx4 + r2 * twoRowStride;
                                a2[idx1] = a2[idx2];
                                a2[idx1 + 1] = -a2[idx2 + 1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int r4;
            int s3;
            for (s3 = 0; s3 < this.slices; ++s3) {
                idx3 = (this.slices - s3) % this.slices * twoSliceStride;
                idx5 = s3 * twoSliceStride;
                for (r4 = 0; r4 < this.rows; ++r4) {
                    idx4 = (this.rows - r4) % this.rows * twoRowStride;
                    idx6 = r4 * twoRowStride;
                    for (int c4 = 1; c4 < this.columns; c4 += 2) {
                        idx1 = idx3 + idx4 + twon3 - c4;
                        idx2 = idx5 + idx6 + c4;
                        a2[idx1] = -a2[idx2 + 2];
                        a2[idx1 - 1] = a2[idx2 + 1];
                    }
                }
            }
            for (s3 = 0; s3 < this.slices; ++s3) {
                idx5 = (this.slices - s3) % this.slices * twoSliceStride;
                idx6 = s3 * twoSliceStride;
                for (r4 = 1; r4 < n2d2; ++r4) {
                    idx4 = idx6 + (this.rows - r4) * twoRowStride;
                    idx1 = idx5 + r4 * twoRowStride + this.columns;
                    idx2 = idx4 + this.columns;
                    idx3 = idx4 + 1;
                    a2[idx1] = a2[idx3];
                    a2[idx2] = a2[idx3];
                    a2[idx1 + 1] = -a2[idx4];
                    a2[idx2 + 1] = a2[idx4];
                }
            }
            for (s3 = 0; s3 < this.slices; ++s3) {
                idx3 = (this.slices - s3) % this.slices * twoSliceStride;
                idx4 = s3 * twoSliceStride;
                for (r4 = 1; r4 < n2d2; ++r4) {
                    idx1 = idx3 + (this.rows - r4) * twoRowStride;
                    idx2 = idx4 + r4 * twoRowStride;
                    a2[idx1] = a2[idx2];
                    a2[idx1 + 1] = -a2[idx2 + 1];
                }
            }
        }
        for (int s4 = 1; s4 < n1d2; ++s4) {
            idx1 = s4 * twoSliceStride;
            idx2 = (this.slices - s4) * twoSliceStride;
            idx3 = n2d2 * twoRowStride;
            idx4 = idx1 + idx3;
            idx5 = idx2 + idx3;
            a2[idx1 + this.columns] = a2[idx2 + 1];
            a2[idx2 + this.columns] = a2[idx2 + 1];
            a2[idx1 + this.columns + 1] = -a2[idx2];
            a2[idx2 + this.columns + 1] = a2[idx2];
            a2[idx4 + this.columns] = a2[idx5 + 1];
            a2[idx5 + this.columns] = a2[idx5 + 1];
            a2[idx4 + this.columns + 1] = -a2[idx5];
            a2[idx5 + this.columns + 1] = a2[idx5];
            a2[idx2] = a2[idx1];
            a2[idx2 + 1] = -a2[idx1 + 1];
            a2[idx5] = a2[idx4];
            a2[idx5 + 1] = -a2[idx4 + 1];
        }
        a2[this.columns] = a2[1];
        a2[1] = 0.0f;
        idx1 = n2d2 * twoRowStride;
        idx2 = n1d2 * twoSliceStride;
        idx3 = idx1 + idx2;
        a2[idx1 + this.columns] = a2[idx1 + 1];
        a2[idx1 + 1] = 0.0f;
        a2[idx2 + this.columns] = a2[idx2 + 1];
        a2[idx2 + 1] = 0.0f;
        a2[idx3 + this.columns] = a2[idx3 + 1];
        a2[idx3 + 1] = 0.0f;
        a2[idx2 + this.columns + 1] = 0.0f;
        a2[idx3 + this.columns + 1] = 0.0f;
    }

    private void fillSymmetric(final FloatLargeArray a2) {
        long idx2;
        long idx1;
        long idx6;
        long idx5;
        long idx4;
        long idx3;
        final long twon3 = 2L * this.columnsl;
        final long n2d2 = this.rowsl / 2L;
        long n1d2 = this.slicesl / 2L;
        final long twoSliceStride = this.rowsl * twon3;
        final long twoRowStride = twon3;
        for (long s2 = this.slicesl - 1L; s2 >= 1L; --s2) {
            idx3 = s2 * this.sliceStridel;
            idx4 = 2L * idx3;
            for (long r2 = 0L; r2 < this.rowsl; ++r2) {
                idx5 = r2 * this.rowStridel;
                idx6 = 2L * idx5;
                for (long c2 = 0L; c2 < this.columnsl; c2 += 2L) {
                    idx1 = idx3 + idx5 + c2;
                    idx2 = idx4 + idx6 + c2;
                    a2.setFloat(idx2, a2.getFloat(idx1));
                    a2.setFloat(idx1, 0.0f);
                    a2.setFloat(++idx2, a2.getFloat(++idx1));
                    a2.setFloat(idx1, 0.0f);
                }
            }
        }
        for (long r3 = 1L; r3 < this.rowsl; ++r3) {
            idx3 = (this.rowsl - r3) * this.rowStridel;
            idx4 = (this.rowsl - r3) * twoRowStride;
            for (long c3 = 0L; c3 < this.columnsl; c3 += 2L) {
                idx1 = idx3 + c3;
                idx2 = idx4 + c3;
                a2.setFloat(idx2, a2.getFloat(idx1));
                a2.setFloat(idx1, 0.0f);
                a2.setFloat(++idx2, a2.getFloat(++idx1));
                a2.setFloat(idx1, 0.0f);
            }
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads) {
            long lastSlice;
            long firstSlice;
            Future[] futures = new Future[nthreads];
            long p2 = this.slicesl / (long)nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                firstSlice = (long)l2 * p2;
                lastSlice = l2 == nthreads - 1 ? this.slicesl : firstSlice + p2;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx3 = (FloatFFT_3D.this.slicesl - s2) % FloatFFT_3D.this.slicesl * twoSliceStride;
                            long idx5 = s2 * twoSliceStride;
                            for (long r2 = 0L; r2 < FloatFFT_3D.this.rowsl; ++r2) {
                                long idx4 = (FloatFFT_3D.this.rowsl - r2) % FloatFFT_3D.this.rowsl * twoRowStride;
                                long idx6 = r2 * twoRowStride;
                                for (long c2 = 1L; c2 < FloatFFT_3D.this.columnsl; c2 += 2L) {
                                    long idx1 = idx3 + idx4 + twon3 - c2;
                                    long idx2 = idx5 + idx6 + c2;
                                    a2.setFloat(idx1, -a2.getFloat(idx2 + 2L));
                                    a2.setFloat(idx1 - 1L, a2.getFloat(idx2 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l3 = 0; l3 < nthreads; ++l3) {
                firstSlice = (long)l3 * p2;
                lastSlice = l3 == nthreads - 1 ? this.slicesl : firstSlice + p2;
                futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx5 = (FloatFFT_3D.this.slicesl - s2) % FloatFFT_3D.this.slicesl * twoSliceStride;
                            long idx6 = s2 * twoSliceStride;
                            for (long r2 = 1L; r2 < n2d2; ++r2) {
                                long idx4 = idx6 + (FloatFFT_3D.this.rowsl - r2) * twoRowStride;
                                long idx1 = idx5 + r2 * twoRowStride + FloatFFT_3D.this.columnsl;
                                long idx2 = idx4 + FloatFFT_3D.this.columnsl;
                                long idx3 = idx4 + 1L;
                                a2.setFloat(idx1, a2.getFloat(idx3));
                                a2.setFloat(idx2, a2.getFloat(idx3));
                                a2.setFloat(idx1 + 1L, -a2.getFloat(idx4));
                                a2.setFloat(idx2 + 1L, a2.getFloat(idx4));
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l4 = 0; l4 < nthreads; ++l4) {
                firstSlice = (long)l4 * p2;
                lastSlice = l4 == nthreads - 1 ? this.slicesl : firstSlice + p2;
                futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx3 = (FloatFFT_3D.this.slicesl - s2) % FloatFFT_3D.this.slicesl * twoSliceStride;
                            long idx4 = s2 * twoSliceStride;
                            for (long r2 = 1L; r2 < n2d2; ++r2) {
                                long idx1 = idx3 + (FloatFFT_3D.this.rowsl - r2) * twoRowStride;
                                long idx2 = idx4 + r2 * twoRowStride;
                                a2.setFloat(idx1, a2.getFloat(idx2));
                                a2.setFloat(idx1 + 1L, -a2.getFloat(idx2 + 1L));
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FloatFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long r4;
            long s3;
            for (s3 = 0L; s3 < this.slicesl; ++s3) {
                idx3 = (this.slicesl - s3) % this.slicesl * twoSliceStride;
                idx5 = s3 * twoSliceStride;
                for (r4 = 0L; r4 < this.rowsl; ++r4) {
                    idx4 = (this.rowsl - r4) % this.rowsl * twoRowStride;
                    idx6 = r4 * twoRowStride;
                    for (long c4 = 1L; c4 < this.columnsl; c4 += 2L) {
                        idx1 = idx3 + idx4 + twon3 - c4;
                        idx2 = idx5 + idx6 + c4;
                        a2.setFloat(idx1, -a2.getFloat(idx2 + 2L));
                        a2.setFloat(idx1 - 1L, a2.getFloat(idx2 + 1L));
                    }
                }
            }
            for (s3 = 0L; s3 < this.slicesl; ++s3) {
                idx5 = (this.slicesl - s3) % this.slicesl * twoSliceStride;
                idx6 = s3 * twoSliceStride;
                for (r4 = 1L; r4 < n2d2; ++r4) {
                    idx4 = idx6 + (this.rowsl - r4) * twoRowStride;
                    idx1 = idx5 + r4 * twoRowStride + this.columnsl;
                    idx2 = idx4 + this.columnsl;
                    idx3 = idx4 + 1L;
                    a2.setFloat(idx1, a2.getFloat(idx3));
                    a2.setFloat(idx2, a2.getFloat(idx3));
                    a2.setFloat(idx1 + 1L, -a2.getFloat(idx4));
                    a2.setFloat(idx2 + 1L, a2.getFloat(idx4));
                }
            }
            for (s3 = 0L; s3 < this.slicesl; ++s3) {
                idx3 = (this.slicesl - s3) % this.slicesl * twoSliceStride;
                idx4 = s3 * twoSliceStride;
                for (r4 = 1L; r4 < n2d2; ++r4) {
                    idx1 = idx3 + (this.rowsl - r4) * twoRowStride;
                    idx2 = idx4 + r4 * twoRowStride;
                    a2.setFloat(idx1, a2.getFloat(idx2));
                    a2.setFloat(idx1 + 1L, -a2.getFloat(idx2 + 1L));
                }
            }
        }
        for (long s4 = 1L; s4 < n1d2; ++s4) {
            idx1 = s4 * twoSliceStride;
            idx2 = (this.slicesl - s4) * twoSliceStride;
            idx3 = n2d2 * twoRowStride;
            idx4 = idx1 + idx3;
            idx5 = idx2 + idx3;
            a2.setFloat(idx1 + this.columnsl, a2.getFloat(idx2 + 1L));
            a2.setFloat(idx2 + this.columnsl, a2.getFloat(idx2 + 1L));
            a2.setFloat(idx1 + this.columnsl + 1L, -a2.getFloat(idx2));
            a2.setFloat(idx2 + this.columnsl + 1L, a2.getFloat(idx2));
            a2.setFloat(idx4 + this.columnsl, a2.getFloat(idx5 + 1L));
            a2.setFloat(idx5 + this.columnsl, a2.getFloat(idx5 + 1L));
            a2.setFloat(idx4 + this.columnsl + 1L, -a2.getFloat(idx5));
            a2.setFloat(idx5 + this.columnsl + 1L, a2.getFloat(idx5));
            a2.setFloat(idx2, a2.getFloat(idx1));
            a2.setFloat(idx2 + 1L, -a2.getFloat(idx1 + 1L));
            a2.setFloat(idx5, a2.getFloat(idx4));
            a2.setFloat(idx5 + 1L, -a2.getFloat(idx4 + 1L));
        }
        a2.setFloat(this.columnsl, a2.getFloat(1L));
        a2.setFloat(1L, 0.0f);
        idx1 = n2d2 * twoRowStride;
        idx2 = n1d2 * twoSliceStride;
        idx3 = idx1 + idx2;
        a2.setFloat(idx1 + this.columnsl, a2.getFloat(idx1 + 1L));
        a2.setFloat(idx1 + 1L, 0.0f);
        a2.setFloat(idx2 + this.columnsl, a2.getFloat(idx2 + 1L));
        a2.setFloat(idx2 + 1L, 0.0f);
        a2.setFloat(idx3 + this.columnsl, a2.getFloat(idx3 + 1L));
        a2.setFloat(idx3 + 1L, 0.0f);
        a2.setFloat(idx2 + this.columnsl + 1L, 0.0f);
        a2.setFloat(idx3 + this.columnsl + 1L, 0.0f);
    }
}

