/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.FloatLargeArray;

public class RealFFTUtils_3D {
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int ZERO = 0;
    private static final long ONEL = 1L;
    private static final long TWOL = 2L;
    private static final long ZEROL = 0L;
    private final int columns;
    private final long columnsl;
    private final int rows;
    private final long rowsl;
    private final int rowStride;
    private final long rowStridel;
    private final int slices;
    private final long slicesl;
    private final int sliceStride;
    private final long sliceStridel;

    public RealFFTUtils_3D(long slices, long rows, long columns) {
        this.slices = (int)slices;
        this.rows = (int)rows;
        this.columns = (int)columns;
        this.rowStride = (int)columns;
        this.sliceStride = (int)rows * this.rowStride;
        this.slicesl = slices;
        this.rowsl = rows;
        this.columnsl = columns;
        this.rowStridel = columns;
        this.sliceStridel = rows * this.rowStridel;
    }

    public int getIndex(int s2, int r2, int c2) {
        int rr;
        int cmod2 = c2 & 1;
        int rmul2 = r2 << 1;
        int smul2 = s2 << 1;
        int ss = s2 == 0 ? 0 : this.slices - s2;
        int n2 = rr = r2 == 0 ? 0 : this.rows - r2;
        if (c2 <= 1) {
            if (r2 == 0) {
                if (s2 == 0) {
                    return c2 == 0 ? 0 : Integer.MIN_VALUE;
                }
                if (smul2 < this.slices) {
                    return s2 * this.sliceStride + c2;
                }
                if (smul2 > this.slices) {
                    int index = ss * this.sliceStride;
                    return cmod2 == 0 ? index : -(index + 1);
                }
                return cmod2 == 0 ? s2 * this.sliceStride : Integer.MIN_VALUE;
            }
            if (rmul2 < this.rows) {
                return s2 * this.sliceStride + r2 * this.rowStride + c2;
            }
            if (rmul2 > this.rows) {
                int index = ss * this.sliceStride + rr * this.rowStride;
                return cmod2 == 0 ? index : -(index + 1);
            }
            if (s2 == 0) {
                return cmod2 == 0 ? r2 * this.rowStride : Integer.MIN_VALUE;
            }
            if (smul2 < this.slices) {
                return s2 * this.sliceStride + r2 * this.rowStride + c2;
            }
            if (smul2 > this.slices) {
                int index = ss * this.sliceStride + r2 * this.rowStride;
                return cmod2 == 0 ? index : -(index + 1);
            }
            int index = s2 * this.sliceStride + r2 * this.rowStride;
            return cmod2 == 0 ? index : Integer.MIN_VALUE;
        }
        if (c2 < this.columns) {
            return s2 * this.sliceStride + r2 * this.rowStride + c2;
        }
        if (c2 > this.columns + 1) {
            int cc = (this.columns << 1) - c2;
            int index = ss * this.sliceStride + rr * this.rowStride + cc;
            return cmod2 == 0 ? index : -(index + 2);
        }
        if (r2 == 0) {
            if (s2 == 0) {
                return cmod2 == 0 ? 1 : Integer.MIN_VALUE;
            }
            if (smul2 < this.slices) {
                int index = ss * this.sliceStride;
                return cmod2 == 0 ? index + 1 : -index;
            }
            if (smul2 > this.slices) {
                int index = s2 * this.sliceStride;
                return cmod2 == 0 ? index + 1 : index;
            }
            int index = s2 * this.sliceStride;
            return cmod2 == 0 ? index + 1 : Integer.MIN_VALUE;
        }
        if (rmul2 < this.rows) {
            int index = ss * this.sliceStride + rr * this.rowStride;
            return cmod2 == 0 ? index + 1 : -index;
        }
        if (rmul2 > this.rows) {
            int index = s2 * this.sliceStride + r2 * this.rowStride;
            return cmod2 == 0 ? index + 1 : index;
        }
        if (s2 == 0) {
            int index = r2 * this.rowStride + 1;
            return cmod2 == 0 ? index : Integer.MIN_VALUE;
        }
        if (smul2 < this.slices) {
            int index = ss * this.sliceStride + r2 * this.rowStride;
            return cmod2 == 0 ? index + 1 : -index;
        }
        if (smul2 > this.slices) {
            int index = s2 * this.sliceStride + r2 * this.rowStride;
            return cmod2 == 0 ? index + 1 : index;
        }
        int index = s2 * this.sliceStride + r2 * this.rowStride;
        return cmod2 == 0 ? index + 1 : Integer.MIN_VALUE;
    }

    public long getIndex(long s2, long r2, long c2) {
        long rr;
        long cmod2 = c2 & 1L;
        long rmul2 = r2 << 1;
        long smul2 = s2 << 1;
        long ss = s2 == 0L ? 0L : this.slicesl - s2;
        long l2 = rr = r2 == 0L ? 0L : this.rowsl - r2;
        if (c2 <= 1L) {
            if (r2 == 0L) {
                if (s2 == 0L) {
                    return c2 == 0L ? 0L : Long.MIN_VALUE;
                }
                if (smul2 < this.slicesl) {
                    return s2 * this.sliceStridel + c2;
                }
                if (smul2 > this.slicesl) {
                    long index = ss * this.sliceStridel;
                    return cmod2 == 0L ? index : -(index + 1L);
                }
                return cmod2 == 0L ? s2 * this.sliceStridel : Long.MIN_VALUE;
            }
            if (rmul2 < this.rowsl) {
                return s2 * this.sliceStridel + r2 * this.rowStridel + c2;
            }
            if (rmul2 > this.rowsl) {
                long index = ss * this.sliceStridel + rr * this.rowStridel;
                return cmod2 == 0L ? index : -(index + 1L);
            }
            if (s2 == 0L) {
                return cmod2 == 0L ? r2 * this.rowStridel : Long.MIN_VALUE;
            }
            if (smul2 < this.slicesl) {
                return s2 * this.sliceStridel + r2 * this.rowStridel + c2;
            }
            if (smul2 > this.slicesl) {
                long index = ss * this.sliceStridel + r2 * this.rowStridel;
                return cmod2 == 0L ? index : -(index + 1L);
            }
            long index = s2 * this.sliceStridel + r2 * this.rowStridel;
            return cmod2 == 0L ? index : Long.MIN_VALUE;
        }
        if (c2 < this.columnsl) {
            return s2 * this.sliceStridel + r2 * this.rowStridel + c2;
        }
        if (c2 > this.columnsl + 1L) {
            long cc = (this.columnsl << 1) - c2;
            long index = ss * this.sliceStridel + rr * this.rowStridel + cc;
            return cmod2 == 0L ? index : -(index + 2L);
        }
        if (r2 == 0L) {
            if (s2 == 0L) {
                return cmod2 == 0L ? 1L : Long.MIN_VALUE;
            }
            if (smul2 < this.slicesl) {
                long index = ss * this.sliceStridel;
                return cmod2 == 0L ? index + 1L : -index;
            }
            if (smul2 > this.slicesl) {
                long index = s2 * this.sliceStridel;
                return cmod2 == 0L ? index + 1L : index;
            }
            long index = s2 * this.sliceStridel;
            return cmod2 == 0L ? index + 1L : Long.MIN_VALUE;
        }
        if (rmul2 < this.rowsl) {
            long index = ss * this.sliceStridel + rr * this.rowStridel;
            return cmod2 == 0L ? index + 1L : -index;
        }
        if (rmul2 > this.rowsl) {
            long index = s2 * this.sliceStridel + r2 * this.rowStridel;
            return cmod2 == 0L ? index + 1L : index;
        }
        if (s2 == 0L) {
            long index = r2 * this.rowStridel + 1L;
            return cmod2 == 0L ? index : Long.MIN_VALUE;
        }
        if (smul2 < this.slicesl) {
            long index = ss * this.sliceStridel + r2 * this.rowStridel;
            return cmod2 == 0L ? index + 1L : -index;
        }
        if (smul2 > this.slicesl) {
            long index = s2 * this.sliceStridel + r2 * this.rowStridel;
            return cmod2 == 0L ? index + 1L : index;
        }
        long index = s2 * this.sliceStridel + r2 * this.rowStridel;
        return cmod2 == 0L ? index + 1L : Long.MIN_VALUE;
    }

    public void pack(double val, int s2, int r2, int c2, double[] packed, int pos) {
        int i2 = this.getIndex(s2, r2, c2);
        if (i2 >= 0) {
            packed[pos + i2] = val;
        } else if (i2 > Integer.MIN_VALUE) {
            packed[pos - i2] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", s2, r2, c2));
        }
    }

    public void pack(double val, long s2, long r2, long c2, DoubleLargeArray packed, long pos) {
        long i2 = this.getIndex(s2, r2, c2);
        if (i2 >= 0L) {
            packed.setDouble(pos + i2, val);
        } else if (i2 > Long.MIN_VALUE) {
            packed.setDouble(pos - i2, -val);
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", s2, r2, c2));
        }
    }

    public void pack(double val, int s2, int r2, int c2, double[][][] packed) {
        int i2 = this.getIndex(s2, r2, c2);
        int ii = FastMath.abs((int)i2);
        int ss = ii / this.sliceStride;
        int remainder = ii % this.sliceStride;
        int rr = remainder / this.rowStride;
        int cc = remainder % this.rowStride;
        if (i2 >= 0) {
            packed[ss][rr][cc] = val;
        } else if (i2 > Integer.MIN_VALUE) {
            packed[ss][rr][cc] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r2, c2));
        }
    }

    public void pack(float val, int s2, int r2, int c2, float[] packed, int pos) {
        int i2 = this.getIndex(s2, r2, c2);
        if (i2 >= 0) {
            packed[pos + i2] = val;
        } else if (i2 > Integer.MIN_VALUE) {
            packed[pos - i2] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", s2, r2, c2));
        }
    }

    public void pack(float val, long s2, long r2, long c2, FloatLargeArray packed, long pos) {
        long i2 = this.getIndex(s2, r2, c2);
        if (i2 >= 0L) {
            packed.setFloat(pos + i2, val);
        } else if (i2 > Long.MIN_VALUE) {
            packed.setFloat(pos - i2, -val);
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", s2, r2, c2));
        }
    }

    public void pack(float val, int s2, int r2, int c2, float[][][] packed) {
        int i2 = this.getIndex(s2, r2, c2);
        int ii = FastMath.abs((int)i2);
        int ss = ii / this.sliceStride;
        int remainder = ii % this.sliceStride;
        int rr = remainder / this.rowStride;
        int cc = remainder % this.rowStride;
        if (i2 >= 0) {
            packed[ss][rr][cc] = val;
        } else if (i2 > Integer.MIN_VALUE) {
            packed[ss][rr][cc] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", s2, r2, c2));
        }
    }

    public double unpack(int s2, int r2, int c2, double[] packed, int pos) {
        int i2 = this.getIndex(s2, r2, c2);
        if (i2 >= 0) {
            return packed[pos + i2];
        }
        if (i2 > Integer.MIN_VALUE) {
            return -packed[pos - i2];
        }
        return 0.0;
    }

    public double unpack(long s2, long r2, long c2, DoubleLargeArray packed, long pos) {
        long i2 = this.getIndex(s2, r2, c2);
        if (i2 >= 0L) {
            return packed.getDouble(pos + i2);
        }
        if (i2 > Long.MIN_VALUE) {
            return -packed.getDouble(pos - i2);
        }
        return 0.0;
    }

    public double unpack(int s2, int r2, int c2, double[][][] packed) {
        int i2 = this.getIndex(s2, r2, c2);
        int ii = FastMath.abs((int)i2);
        int ss = ii / this.sliceStride;
        int remainder = ii % this.sliceStride;
        int rr = remainder / this.rowStride;
        int cc = remainder % this.rowStride;
        if (i2 >= 0) {
            return packed[ss][rr][cc];
        }
        if (i2 > Integer.MIN_VALUE) {
            return -packed[ss][rr][cc];
        }
        return 0.0;
    }

    public float unpack(int s2, int r2, int c2, float[] packed, int pos) {
        int i2 = this.getIndex(s2, r2, c2);
        if (i2 >= 0) {
            return packed[pos + i2];
        }
        if (i2 > Integer.MIN_VALUE) {
            return -packed[pos - i2];
        }
        return 0.0f;
    }

    public float unpack(long s2, long r2, long c2, FloatLargeArray packed, long pos) {
        long i2 = this.getIndex(s2, r2, c2);
        if (i2 >= 0L) {
            return packed.getFloat(pos + i2);
        }
        if (i2 > Long.MIN_VALUE) {
            return -packed.getFloat(pos - i2);
        }
        return 0.0f;
    }

    public float unpack(int s2, int r2, int c2, float[][][] packed) {
        int i2 = this.getIndex(s2, r2, c2);
        int ii = FastMath.abs((int)i2);
        int ss = ii / this.sliceStride;
        int remainder = ii % this.sliceStride;
        int rr = remainder / this.rowStride;
        int cc = remainder % this.rowStride;
        if (i2 >= 0) {
            return packed[ss][rr][cc];
        }
        if (i2 > Integer.MIN_VALUE) {
            return -packed[ss][rr][cc];
        }
        return 0.0f;
    }
}

