/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.utils;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Random;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.FloatLargeArray;

public class IOUtils {
    private static final String FF = "%.4f";

    private IOUtils() {
    }

    public static double computeRMSE(float a2, float b2) {
        double tmp = a2 - b2;
        double rms = tmp * tmp;
        return FastMath.sqrt((double)rms);
    }

    public static double computeRMSE(float[] a2, float[] b2) {
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        for (int i2 = 0; i2 < a2.length; ++i2) {
            double tmp = a2[i2] - b2[i2];
            rms += tmp * tmp;
        }
        return FastMath.sqrt((double)(rms / (double)a2.length));
    }

    public static double computeRMSE(FloatLargeArray a2, FloatLargeArray b2) {
        if (a2.length() != b2.length()) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double rms = 0.0;
        for (long i2 = 0L; i2 < a2.length(); ++i2) {
            double tmp = a2.getFloat(i2) - b2.getFloat(i2);
            rms += tmp * tmp;
        }
        return FastMath.sqrt((double)(rms / (double)a2.length()));
    }

    public static double computeRMSE(float[][] a2, float[][] b2) {
        if (a2.length != b2.length || a2[0].length != b2[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        for (int r2 = 0; r2 < a2.length; ++r2) {
            for (int c2 = 0; c2 < a2[0].length; ++c2) {
                double tmp = a2[r2][c2] - b2[r2][c2];
                rms += tmp * tmp;
            }
        }
        return FastMath.sqrt((double)(rms / (double)(a2.length * a2[0].length)));
    }

    public static double computeRMSE(float[][][] a2, float[][][] b2) {
        if (a2.length != b2.length || a2[0].length != b2[0].length || a2[0][0].length != b2[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        for (int s2 = 0; s2 < a2.length; ++s2) {
            for (int r2 = 0; r2 < a2[0].length; ++r2) {
                for (int c2 = 0; c2 < a2[0][0].length; ++c2) {
                    double tmp = a2[s2][r2][c2] - b2[s2][r2][c2];
                    rms += tmp * tmp;
                }
            }
        }
        return FastMath.sqrt((double)(rms / (double)(a2.length * a2[0].length * a2[0][0].length)));
    }

    public static double computeRMSE(double a2, double b2) {
        double tmp = a2 - b2;
        double rms = tmp * tmp;
        return FastMath.sqrt((double)rms);
    }

    public static double computeRMSE(double[] a2, double[] b2) {
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        for (int i2 = 0; i2 < a2.length; ++i2) {
            double tmp = a2[i2] - b2[i2];
            rms += tmp * tmp;
        }
        return FastMath.sqrt((double)(rms / (double)a2.length));
    }

    public static double computeRMSE(DoubleLargeArray a2, DoubleLargeArray b2) {
        if (a2.length() != b2.length()) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double rms = 0.0;
        for (long i2 = 0L; i2 < a2.length(); ++i2) {
            double tmp = a2.getDouble(i2) - b2.getDouble(i2);
            rms += tmp * tmp;
        }
        return FastMath.sqrt((double)(rms / (double)a2.length()));
    }

    public static double computeRMSE(double[][] a2, double[][] b2) {
        if (a2.length != b2.length || a2[0].length != b2[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        for (int r2 = 0; r2 < a2.length; ++r2) {
            for (int c2 = 0; c2 < a2[0].length; ++c2) {
                double tmp = a2[r2][c2] - b2[r2][c2];
                rms += tmp * tmp;
            }
        }
        return FastMath.sqrt((double)(rms / (double)(a2.length * a2[0].length)));
    }

    public static double computeRMSE(double[][][] a2, double[][][] b2) {
        if (a2.length != b2.length || a2[0].length != b2[0].length || a2[0][0].length != b2[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        for (int s2 = 0; s2 < a2.length; ++s2) {
            for (int r2 = 0; r2 < a2[0].length; ++r2) {
                for (int c2 = 0; c2 < a2[0][0].length; ++c2) {
                    double tmp = a2[s2][r2][c2] - b2[s2][r2][c2];
                    rms += tmp * tmp;
                }
            }
        }
        return FastMath.sqrt((double)(rms / (double)(a2.length * a2[0].length * a2[0][0].length)));
    }

    public static void fillMatrix_1D(long N2, double[] m4) {
        Random r2 = new Random(2L);
        int i2 = 0;
        while ((long)i2 < N2) {
            m4[i2] = r2.nextDouble();
            ++i2;
        }
    }

    public static void fillMatrix_1D(long N2, DoubleLargeArray m4) {
        Random r2 = new Random(2L);
        for (long i2 = 0L; i2 < N2; ++i2) {
            m4.setDouble(i2, r2.nextDouble());
        }
    }

    public static void fillMatrix_1D(long N2, FloatLargeArray m4) {
        Random r2 = new Random(2L);
        for (long i2 = 0L; i2 < N2; ++i2) {
            m4.setDouble(i2, r2.nextFloat());
        }
    }

    public static void fillMatrix_1D(long N2, float[] m4) {
        Random r2 = new Random(2L);
        int i2 = 0;
        while ((long)i2 < N2) {
            m4[i2] = r2.nextFloat();
            ++i2;
        }
    }

    public static void fillMatrix_2D(long n1, long n2, double[] m4) {
        Random r2 = new Random(2L);
        int i2 = 0;
        while ((long)i2 < n1) {
            int j2 = 0;
            while ((long)j2 < n2) {
                m4[(int)((long)i2 * n2 + (long)j2)] = r2.nextDouble();
                ++j2;
            }
            ++i2;
        }
    }

    public static void fillMatrix_2D(long n1, long n2, FloatLargeArray m4) {
        Random r2 = new Random(2L);
        for (long i2 = 0L; i2 < n1; ++i2) {
            for (long j2 = 0L; j2 < n2; ++j2) {
                m4.setFloat(i2 * n2 + j2, r2.nextFloat());
            }
        }
    }

    public static void fillMatrix_2D(long n1, long n2, DoubleLargeArray m4) {
        Random r2 = new Random(2L);
        for (long i2 = 0L; i2 < n1; ++i2) {
            for (long j2 = 0L; j2 < n2; ++j2) {
                m4.setDouble(i2 * n2 + j2, r2.nextDouble());
            }
        }
    }

    public static void fillMatrix_2D(long n1, long n2, float[] m4) {
        Random r2 = new Random(2L);
        int i2 = 0;
        while ((long)i2 < n1) {
            int j2 = 0;
            while ((long)j2 < n2) {
                m4[(int)((long)i2 * n2 + (long)j2)] = r2.nextFloat();
                ++j2;
            }
            ++i2;
        }
    }

    public static void fillMatrix_2D(long n1, long n2, double[][] m4) {
        Random r2 = new Random(2L);
        int i2 = 0;
        while ((long)i2 < n1) {
            int j2 = 0;
            while ((long)j2 < n2) {
                m4[i2][j2] = r2.nextDouble();
                ++j2;
            }
            ++i2;
        }
    }

    public static void fillMatrix_2D(long n1, long n2, float[][] m4) {
        Random r2 = new Random(2L);
        int i2 = 0;
        while ((long)i2 < n1) {
            int j2 = 0;
            while ((long)j2 < n2) {
                m4[i2][j2] = r2.nextFloat();
                ++j2;
            }
            ++i2;
        }
    }

    public static void fillMatrix_3D(long n1, long n2, long n3, double[] m4) {
        Random r2 = new Random(2L);
        long sliceStride = n2 * n3;
        long rowStride = n3;
        int i2 = 0;
        while ((long)i2 < n1) {
            int j2 = 0;
            while ((long)j2 < n2) {
                int k2 = 0;
                while ((long)k2 < n3) {
                    m4[(int)((long)i2 * sliceStride + (long)j2 * rowStride + (long)k2)] = r2.nextDouble();
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
    }

    public static void fillMatrix_3D(long n1, long n2, long n3, DoubleLargeArray m4) {
        Random r2 = new Random(2L);
        long sliceStride = n2 * n3;
        long rowStride = n3;
        for (long i2 = 0L; i2 < n1; ++i2) {
            for (long j2 = 0L; j2 < n2; ++j2) {
                for (long k2 = 0L; k2 < n3; ++k2) {
                    m4.setDouble(i2 * sliceStride + j2 * rowStride + k2, r2.nextDouble());
                }
            }
        }
    }

    public static void fillMatrix_3D(long n1, long n2, long n3, FloatLargeArray m4) {
        Random r2 = new Random(2L);
        long sliceStride = n2 * n3;
        long rowStride = n3;
        for (long i2 = 0L; i2 < n1; ++i2) {
            for (long j2 = 0L; j2 < n2; ++j2) {
                for (long k2 = 0L; k2 < n3; ++k2) {
                    m4.setDouble(i2 * sliceStride + j2 * rowStride + k2, r2.nextFloat());
                }
            }
        }
    }

    public static void fillMatrix_3D(long n1, long n2, long n3, float[] m4) {
        Random r2 = new Random(2L);
        long sliceStride = n2 * n3;
        long rowStride = n3;
        int i2 = 0;
        while ((long)i2 < n1) {
            int j2 = 0;
            while ((long)j2 < n2) {
                int k2 = 0;
                while ((long)k2 < n3) {
                    m4[(int)((long)i2 * sliceStride + (long)j2 * rowStride + (long)k2)] = r2.nextFloat();
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
    }

    public static void fillMatrix_3D(long n1, long n2, long n3, double[][][] m4) {
        Random r2 = new Random(2L);
        int i2 = 0;
        while ((long)i2 < n1) {
            int j2 = 0;
            while ((long)j2 < n2) {
                int k2 = 0;
                while ((long)k2 < n3) {
                    m4[i2][j2][k2] = r2.nextDouble();
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
    }

    public static void fillMatrix_3D(long n1, long n2, long n3, float[][][] m4) {
        Random r2 = new Random(2L);
        int i2 = 0;
        while ((long)i2 < n1) {
            int j2 = 0;
            while ((long)j2 < n2) {
                int k2 = 0;
                while ((long)k2 < n3) {
                    m4[i2][j2][k2] = r2.nextFloat();
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
    }

    public static void showComplex_1D(double[] x2, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        for (int i2 = 0; i2 < x2.length; i2 += 2) {
            if (x2[i2 + 1] == 0.0) {
                System.out.println(String.format(FF, x2[i2]));
                continue;
            }
            if (x2[i2] == 0.0) {
                System.out.println(String.format(FF, x2[i2 + 1]) + "i");
                continue;
            }
            if (x2[i2 + 1] < 0.0) {
                System.out.println(String.format(FF, x2[i2]) + " - " + String.format(FF, -x2[i2 + 1]) + "i");
                continue;
            }
            System.out.println(String.format(FF, x2[i2]) + " + " + String.format(FF, x2[i2 + 1]) + "i");
        }
        System.out.println();
    }

    public static void showComplex_2D(int rows, int columns, double[] x2, String title) {
        StringBuilder s2 = new StringBuilder(String.format(title + ": complex array 2D: %d rows, %d columns\n\n", rows, columns));
        for (int r2 = 0; r2 < rows; ++r2) {
            for (int c2 = 0; c2 < 2 * columns; c2 += 2) {
                if (x2[r2 * 2 * columns + c2 + 1] == 0.0) {
                    s2.append(String.format("%.4f\t", x2[r2 * 2 * columns + c2]));
                    continue;
                }
                if (x2[r2 * 2 * columns + c2] == 0.0) {
                    s2.append(String.format("%.4fi\t", x2[r2 * 2 * columns + c2 + 1]));
                    continue;
                }
                if (x2[r2 * 2 * columns + c2 + 1] < 0.0) {
                    s2.append(String.format("%.4f - %.4fi\t", x2[r2 * 2 * columns + c2], -x2[r2 * 2 * columns + c2 + 1]));
                    continue;
                }
                s2.append(String.format("%.4f + %.4fi\t", x2[r2 * 2 * columns + c2], x2[r2 * 2 * columns + c2 + 1]));
            }
            s2.append("\n");
        }
        System.out.println(s2.toString());
    }

    public static void showComplex_2D(double[][] x2, String title) {
        int rows = x2.length;
        int columns = x2[0].length;
        StringBuilder s2 = new StringBuilder(String.format(title + ": complex array 2D: %d rows, %d columns\n\n", rows, columns));
        for (int r2 = 0; r2 < rows; ++r2) {
            for (int c2 = 0; c2 < columns; c2 += 2) {
                if (x2[r2][c2 + 1] == 0.0) {
                    s2.append(String.format("%.4f\t", x2[r2][c2]));
                    continue;
                }
                if (x2[r2][c2] == 0.0) {
                    s2.append(String.format("%.4fi\t", x2[r2][c2 + 1]));
                    continue;
                }
                if (x2[r2][c2 + 1] < 0.0) {
                    s2.append(String.format("%.4f - %.4fi\t", x2[r2][c2], -x2[r2][c2 + 1]));
                    continue;
                }
                s2.append(String.format("%.4f + %.4fi\t", x2[r2][c2], x2[r2][c2 + 1]));
            }
            s2.append("\n");
        }
        System.out.println(s2.toString());
    }

    public static void showComplex_3D(int n1, int n2, int n3, double[] x2, String title) {
        int sliceStride = n2 * 2 * n3;
        int rowStride = 2 * n3;
        System.out.println(title);
        System.out.println("-------------------");
        for (int k2 = 0; k2 < 2 * n3; k2 += 2) {
            System.out.println("(:,:," + k2 / 2 + ")=\n");
            for (int i2 = 0; i2 < n1; ++i2) {
                for (int j2 = 0; j2 < n2; ++j2) {
                    if (x2[i2 * sliceStride + j2 * rowStride + k2 + 1] == 0.0) {
                        System.out.print(String.format(FF, x2[i2 * sliceStride + j2 * rowStride + k2]) + "\t");
                        continue;
                    }
                    if (x2[i2 * sliceStride + j2 * rowStride + k2] == 0.0) {
                        System.out.print(String.format(FF, x2[i2 * sliceStride + j2 * rowStride + k2 + 1]) + "i\t");
                        continue;
                    }
                    if (x2[i2 * sliceStride + j2 * rowStride + k2 + 1] < 0.0) {
                        System.out.print(String.format(FF, x2[i2 * sliceStride + j2 * rowStride + k2]) + " - " + String.format(FF, -x2[i2 * sliceStride + j2 * rowStride + k2 + 1]) + "i\t");
                        continue;
                    }
                    System.out.print(String.format(FF, x2[i2 * sliceStride + j2 * rowStride + k2]) + " + " + String.format(FF, x2[i2 * sliceStride + j2 * rowStride + k2 + 1]) + "i\t");
                }
                System.out.println("");
            }
        }
        System.out.println("");
    }

    public static void showComplex_3D(double[][][] x2, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        int slices = x2.length;
        int rows = x2[0].length;
        int columns = x2[0][0].length;
        for (int k2 = 0; k2 < columns; k2 += 2) {
            System.out.println("(:,:," + k2 / 2 + ")=\n");
            for (int i2 = 0; i2 < slices; ++i2) {
                for (int j2 = 0; j2 < rows; ++j2) {
                    if (x2[i2][j2][k2 + 1] == 0.0) {
                        System.out.print(String.format(FF, x2[i2][j2][k2]) + "\t");
                        continue;
                    }
                    if (x2[i2][j2][k2] == 0.0) {
                        System.out.print(String.format(FF, x2[i2][j2][k2 + 1]) + "i\t");
                        continue;
                    }
                    if (x2[i2][j2][k2 + 1] < 0.0) {
                        System.out.print(String.format(FF, x2[i2][j2][k2]) + " - " + String.format(FF, -x2[i2][j2][k2 + 1]) + "i\t");
                        continue;
                    }
                    System.out.print(String.format(FF, x2[i2][j2][k2]) + " + " + String.format(FF, x2[i2][j2][k2 + 1]) + "i\t");
                }
                System.out.println("");
            }
        }
        System.out.println("");
    }

    public static void showComplex_3D(int n1, int n2, int n3, float[] x2, String title) {
        int sliceStride = n2 * 2 * n3;
        int rowStride = 2 * n3;
        System.out.println(title);
        System.out.println("-------------------");
        for (int k2 = 0; k2 < 2 * n3; k2 += 2) {
            System.out.println("(:,:," + k2 / 2 + ")=\n");
            for (int i2 = 0; i2 < n1; ++i2) {
                for (int j2 = 0; j2 < n2; ++j2) {
                    if (x2[i2 * sliceStride + j2 * rowStride + k2 + 1] == 0.0f) {
                        System.out.print(String.format(FF, Float.valueOf(x2[i2 * sliceStride + j2 * rowStride + k2])) + "\t");
                        continue;
                    }
                    if (x2[i2 * sliceStride + j2 * rowStride + k2] == 0.0f) {
                        System.out.print(String.format(FF, Float.valueOf(x2[i2 * sliceStride + j2 * rowStride + k2 + 1])) + "i\t");
                        continue;
                    }
                    if (x2[i2 * sliceStride + j2 * rowStride + k2 + 1] < 0.0f) {
                        System.out.print(String.format(FF, Float.valueOf(x2[i2 * sliceStride + j2 * rowStride + k2])) + " - " + String.format(FF, Float.valueOf(-x2[i2 * sliceStride + j2 * rowStride + k2 + 1])) + "i\t");
                        continue;
                    }
                    System.out.print(String.format(FF, Float.valueOf(x2[i2 * sliceStride + j2 * rowStride + k2])) + " + " + String.format(FF, Float.valueOf(x2[i2 * sliceStride + j2 * rowStride + k2 + 1])) + "i\t");
                }
                System.out.println("");
            }
        }
        System.out.println("");
    }

    public static void showReal_1D(double[] x2, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        for (int j2 = 0; j2 < x2.length; ++j2) {
            System.out.println(String.format(FF, x2[j2]));
        }
        System.out.println();
    }

    public static void showReal_2D(int n1, int n2, double[] x2, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        for (int i2 = 0; i2 < n1; ++i2) {
            for (int j2 = 0; j2 < n2; ++j2) {
                if (FastMath.abs((double)x2[i2 * n2 + j2]) < 5.0E-5) {
                    System.out.print("0\t");
                    continue;
                }
                System.out.print(String.format(FF, x2[i2 * n2 + j2]) + "\t");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void showReal_3D(int n1, int n2, int n3, double[] x2, String title) {
        int sliceStride = n2 * n3;
        int rowStride = n3;
        System.out.println(title);
        System.out.println("-------------------");
        for (int k2 = 0; k2 < n3; ++k2) {
            System.out.println();
            System.out.println("(:,:," + k2 + ")=\n");
            for (int i2 = 0; i2 < n1; ++i2) {
                for (int j2 = 0; j2 < n2; ++j2) {
                    if (FastMath.abs((double)x2[i2 * sliceStride + j2 * rowStride + k2]) <= 5.0E-5) {
                        System.out.print("0\t");
                        continue;
                    }
                    System.out.print(String.format(FF, x2[i2 * sliceStride + j2 * rowStride + k2]) + "\t");
                }
                System.out.println();
            }
        }
        System.out.println();
    }

    public static void showReal_3D(double[][][] x2, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        int slices = x2.length;
        int rows = x2[0].length;
        int columns = x2[0][0].length;
        for (int k2 = 0; k2 < columns; ++k2) {
            System.out.println();
            System.out.println("(:,:," + k2 + ")=\n");
            for (int i2 = 0; i2 < slices; ++i2) {
                for (int j2 = 0; j2 < rows; ++j2) {
                    if (FastMath.abs((double)x2[i2][j2][k2]) <= 5.0E-5) {
                        System.out.print("0\t");
                        continue;
                    }
                    System.out.print(String.format(FF, x2[i2][j2][k2]) + "\t");
                }
                System.out.println();
            }
        }
        System.out.println();
    }

    public static void writeToFileComplex_1D(double[] x2, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int i2 = 0; i2 < x2.length; i2 += 2) {
                if (x2[i2 + 1] == 0.0) {
                    out.write(String.format(FF, x2[i2]));
                    out.newLine();
                    continue;
                }
                if (x2[i2] == 0.0) {
                    out.write(String.format(FF, x2[i2 + 1]) + "i");
                    out.newLine();
                    continue;
                }
                if (x2[i2 + 1] < 0.0) {
                    out.write(String.format(FF, x2[i2]) + " - " + String.format(FF, -x2[i2 + 1]) + "i");
                    out.newLine();
                    continue;
                }
                out.write(String.format(FF, x2[i2]) + " + " + String.format(FF, x2[i2 + 1]) + "i");
                out.newLine();
            }
            out.newLine();
            out.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void writeToFileComplex_1D(float[] x2, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int i2 = 0; i2 < x2.length; i2 += 2) {
                if (x2[i2 + 1] == 0.0f) {
                    out.write(String.format(FF, Float.valueOf(x2[i2])));
                    out.newLine();
                    continue;
                }
                if (x2[i2] == 0.0f) {
                    out.write(String.format(FF, Float.valueOf(x2[i2 + 1])) + "i");
                    out.newLine();
                    continue;
                }
                if (x2[i2 + 1] < 0.0f) {
                    out.write(String.format(FF, Float.valueOf(x2[i2])) + " - " + String.format(FF, Float.valueOf(-x2[i2 + 1])) + "i");
                    out.newLine();
                    continue;
                }
                out.write(String.format(FF, Float.valueOf(x2[i2])) + " + " + String.format(FF, Float.valueOf(x2[i2 + 1])) + "i");
                out.newLine();
            }
            out.newLine();
            out.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void writeToFileComplex_2D(int n1, int n2, double[] x2, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int i2 = 0; i2 < n1; ++i2) {
                for (int j2 = 0; j2 < 2 * n2; j2 += 2) {
                    if (FastMath.abs((double)x2[i2 * 2 * n2 + j2]) < 5.0E-5 && FastMath.abs((double)x2[i2 * 2 * n2 + j2 + 1]) < 5.0E-5) {
                        if (x2[i2 * 2 * n2 + j2 + 1] >= 0.0) {
                            out.write("0 + 0i\t");
                            continue;
                        }
                        out.write("0 - 0i\t");
                        continue;
                    }
                    if (FastMath.abs((double)x2[i2 * 2 * n2 + j2 + 1]) < 5.0E-5) {
                        if (x2[i2 * 2 * n2 + j2 + 1] >= 0.0) {
                            out.write(String.format(FF, x2[i2 * 2 * n2 + j2]) + " + 0i\t");
                            continue;
                        }
                        out.write(String.format(FF, x2[i2 * 2 * n2 + j2]) + " - 0i\t");
                        continue;
                    }
                    if (FastMath.abs((double)x2[i2 * 2 * n2 + j2]) < 5.0E-5) {
                        if (x2[i2 * 2 * n2 + j2 + 1] >= 0.0) {
                            out.write("0 + " + String.format(FF, x2[i2 * 2 * n2 + j2 + 1]) + "i\t");
                            continue;
                        }
                        out.write("0 - " + String.format(FF, -x2[i2 * 2 * n2 + j2 + 1]) + "i\t");
                        continue;
                    }
                    if (x2[i2 * 2 * n2 + j2 + 1] < 0.0) {
                        out.write(String.format(FF, x2[i2 * 2 * n2 + j2]) + " - " + String.format(FF, -x2[i2 * 2 * n2 + j2 + 1]) + "i\t");
                        continue;
                    }
                    out.write(String.format(FF, x2[i2 * 2 * n2 + j2]) + " + " + String.format(FF, x2[i2 * 2 * n2 + j2 + 1]) + "i\t");
                }
                out.newLine();
            }
            out.newLine();
            out.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void writeToFileComplex_2D(int n1, int n2, float[] x2, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int i2 = 0; i2 < n1; ++i2) {
                for (int j2 = 0; j2 < 2 * n2; j2 += 2) {
                    if ((double)FastMath.abs((float)x2[i2 * 2 * n2 + j2]) < 5.0E-5 && (double)FastMath.abs((float)x2[i2 * 2 * n2 + j2 + 1]) < 5.0E-5) {
                        if ((double)x2[i2 * 2 * n2 + j2 + 1] >= 0.0) {
                            out.write("0 + 0i\t");
                            continue;
                        }
                        out.write("0 - 0i\t");
                        continue;
                    }
                    if ((double)FastMath.abs((float)x2[i2 * 2 * n2 + j2 + 1]) < 5.0E-5) {
                        if ((double)x2[i2 * 2 * n2 + j2 + 1] >= 0.0) {
                            out.write(String.format(FF, Float.valueOf(x2[i2 * 2 * n2 + j2])) + " + 0i\t");
                            continue;
                        }
                        out.write(String.format(FF, Float.valueOf(x2[i2 * 2 * n2 + j2])) + " - 0i\t");
                        continue;
                    }
                    if ((double)FastMath.abs((float)x2[i2 * 2 * n2 + j2]) < 5.0E-5) {
                        if ((double)x2[i2 * 2 * n2 + j2 + 1] >= 0.0) {
                            out.write("0 + " + String.format(FF, Float.valueOf(x2[i2 * 2 * n2 + j2 + 1])) + "i\t");
                            continue;
                        }
                        out.write("0 - " + String.format(FF, Float.valueOf(-x2[i2 * 2 * n2 + j2 + 1])) + "i\t");
                        continue;
                    }
                    if (x2[i2 * 2 * n2 + j2 + 1] < 0.0f) {
                        out.write(String.format(FF, Float.valueOf(x2[i2 * 2 * n2 + j2])) + " - " + String.format(FF, Float.valueOf(-x2[i2 * 2 * n2 + j2 + 1])) + "i\t");
                        continue;
                    }
                    out.write(String.format(FF, Float.valueOf(x2[i2 * 2 * n2 + j2])) + " + " + String.format(FF, Float.valueOf(x2[i2 * 2 * n2 + j2 + 1])) + "i\t");
                }
                out.newLine();
            }
            out.newLine();
            out.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void writeToFileComplex_2D(double[][] x2, String filename) {
        int n1 = x2.length;
        int n2 = x2[0].length;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int i2 = 0; i2 < n1; ++i2) {
                for (int j2 = 0; j2 < 2 * n2; j2 += 2) {
                    if (FastMath.abs((double)x2[i2][j2]) < 5.0E-5 && FastMath.abs((double)x2[i2][j2 + 1]) < 5.0E-5) {
                        if (x2[i2][j2 + 1] >= 0.0) {
                            out.write("0 + 0i\t");
                            continue;
                        }
                        out.write("0 - 0i\t");
                        continue;
                    }
                    if (FastMath.abs((double)x2[i2][j2 + 1]) < 5.0E-5) {
                        if (x2[i2][j2 + 1] >= 0.0) {
                            out.write(String.format(FF, x2[i2][j2]) + " + 0i\t");
                            continue;
                        }
                        out.write(String.format(FF, x2[i2][j2]) + " - 0i\t");
                        continue;
                    }
                    if (FastMath.abs((double)x2[i2][j2]) < 5.0E-5) {
                        if (x2[i2][j2 + 1] >= 0.0) {
                            out.write("0 + " + String.format(FF, x2[i2][j2 + 1]) + "i\t");
                            continue;
                        }
                        out.write("0 - " + String.format(FF, -x2[i2][j2 + 1]) + "i\t");
                        continue;
                    }
                    if (x2[i2][j2 + 1] < 0.0) {
                        out.write(String.format(FF, x2[i2][j2]) + " - " + String.format(FF, -x2[i2][j2 + 1]) + "i\t");
                        continue;
                    }
                    out.write(String.format(FF, x2[i2][j2]) + " + " + String.format(FF, x2[i2][j2 + 1]) + "i\t");
                }
                out.newLine();
            }
            out.newLine();
            out.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void writeToFileComplex_3D(int n1, int n2, int n3, double[] x2, String filename) {
        int sliceStride = n2 * n3 * 2;
        int rowStride = n3 * 2;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int k2 = 0; k2 < 2 * n3; k2 += 2) {
                out.newLine();
                out.write("(:,:," + k2 / 2 + ")=");
                out.newLine();
                out.newLine();
                for (int i2 = 0; i2 < n1; ++i2) {
                    for (int j2 = 0; j2 < n2; ++j2) {
                        if (x2[i2 * sliceStride + j2 * rowStride + k2 + 1] == 0.0) {
                            out.write(String.format(FF, x2[i2 * sliceStride + j2 * rowStride + k2]) + "\t");
                            continue;
                        }
                        if (x2[i2 * sliceStride + j2 * rowStride + k2] == 0.0) {
                            out.write(String.format(FF, x2[i2 * sliceStride + j2 * rowStride + k2 + 1]) + "i\t");
                            continue;
                        }
                        if (x2[i2 * sliceStride + j2 * rowStride + k2 + 1] < 0.0) {
                            out.write(String.format(FF, x2[i2 * sliceStride + j2 * rowStride + k2]) + " - " + String.format(FF, -x2[i2 * sliceStride + j2 * rowStride + k2 + 1]) + "i\t");
                            continue;
                        }
                        out.write(String.format(FF, x2[i2 * sliceStride + j2 * rowStride + k2]) + " + " + String.format(FF, x2[i2 * sliceStride + j2 * rowStride + k2 + 1]) + "i\t");
                    }
                    out.newLine();
                }
            }
            out.newLine();
            out.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void writeToFileComplex_3D(double[][][] x2, String filename) {
        int n1 = x2.length;
        int n2 = x2[0].length;
        int n3 = x2[0][0].length;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int k2 = 0; k2 < 2 * n3; k2 += 2) {
                out.newLine();
                out.write("(:,:," + k2 / 2 + ")=");
                out.newLine();
                out.newLine();
                for (int i2 = 0; i2 < n1; ++i2) {
                    for (int j2 = 0; j2 < n2; ++j2) {
                        if (x2[i2][j2][k2 + 1] == 0.0) {
                            out.write(String.format(FF, x2[i2][j2][k2]) + "\t");
                            continue;
                        }
                        if (x2[i2][j2][k2] == 0.0) {
                            out.write(String.format(FF, x2[i2][j2][k2 + 1]) + "i\t");
                            continue;
                        }
                        if (x2[i2][j2][k2 + 1] < 0.0) {
                            out.write(String.format(FF, x2[i2][j2][k2]) + " - " + String.format(FF, -x2[i2][j2][k2 + 1]) + "i\t");
                            continue;
                        }
                        out.write(String.format(FF, x2[i2][j2][k2]) + " + " + String.format(FF, x2[i2][j2][k2 + 1]) + "i\t");
                    }
                    out.newLine();
                }
            }
            out.newLine();
            out.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void writeToFileReal_1D(double[] x2, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int j2 = 0; j2 < x2.length; ++j2) {
                out.write(String.format(FF, x2[j2]));
                out.newLine();
            }
            out.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void writeToFileReal_1D(float[] x2, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int j2 = 0; j2 < x2.length; ++j2) {
                out.write(String.format(FF, Float.valueOf(x2[j2])));
                out.newLine();
            }
            out.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void writeToFileReal_2D(int n1, int n2, double[] x2, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int i2 = 0; i2 < n1; ++i2) {
                for (int j2 = 0; j2 < n2; ++j2) {
                    if (FastMath.abs((double)x2[i2 * n2 + j2]) < 5.0E-5) {
                        out.write("0\t");
                        continue;
                    }
                    out.write(String.format(FF, x2[i2 * n2 + j2]) + "\t");
                }
                out.newLine();
            }
            out.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void writeToFileReal_2D(int n1, int n2, float[] x2, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int i2 = 0; i2 < n1; ++i2) {
                for (int j2 = 0; j2 < n2; ++j2) {
                    if ((double)FastMath.abs((float)x2[i2 * n2 + j2]) < 5.0E-5) {
                        out.write("0\t");
                        continue;
                    }
                    out.write(String.format(FF, Float.valueOf(x2[i2 * n2 + j2])) + "\t");
                }
                out.newLine();
            }
            out.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void writeToFileReal_3D(int n1, int n2, int n3, double[] x2, String filename) {
        int sliceStride = n2 * n3;
        int rowStride = n3;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int k2 = 0; k2 < n3; ++k2) {
                out.newLine();
                out.write("(:,:," + k2 + ")=");
                out.newLine();
                out.newLine();
                for (int i2 = 0; i2 < n1; ++i2) {
                    for (int j2 = 0; j2 < n2; ++j2) {
                        out.write(String.format(FF, x2[i2 * sliceStride + j2 * rowStride + k2]) + "\t");
                    }
                    out.newLine();
                }
                out.newLine();
            }
            out.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void writeFFTBenchmarkResultsToFile(String filename, int nthread, int niter, boolean doWarmup, boolean doScaling, long[] sizes, double[] times_without_constructor, double[] times_with_constructor) {
        String[] properties = new String[]{"os.name", "os.version", "os.arch", "java.vendor", "java.version"};
        try {
            int i2;
            BufferedWriter out = new BufferedWriter(new FileWriter(filename, false));
            out.write(new Date().toString());
            out.newLine();
            out.write("System properties:");
            out.newLine();
            out.write("\tos.name = " + System.getProperty(properties[0]));
            out.newLine();
            out.write("\tos.version = " + System.getProperty(properties[1]));
            out.newLine();
            out.write("\tos.arch = " + System.getProperty(properties[2]));
            out.newLine();
            out.write("\tjava.vendor = " + System.getProperty(properties[3]));
            out.newLine();
            out.write("\tjava.version = " + System.getProperty(properties[4]));
            out.newLine();
            out.write("\tavailable processors = " + Runtime.getRuntime().availableProcessors());
            out.newLine();
            out.write("Settings:");
            out.newLine();
            out.write("\tused processors = " + nthread);
            out.newLine();
            out.write("\tTHREADS_BEGIN_N_2D = " + CommonUtils.getThreadsBeginN_2D());
            out.newLine();
            out.write("\tTHREADS_BEGIN_N_3D = " + CommonUtils.getThreadsBeginN_3D());
            out.newLine();
            out.write("\tnumber of iterations = " + niter);
            out.newLine();
            out.write("\twarm-up performed = " + doWarmup);
            out.newLine();
            out.write("\tscaling performed = " + doScaling);
            out.newLine();
            out.write("--------------------------------------------------------------------------------------------------");
            out.newLine();
            out.write("sizes=[");
            for (i2 = 0; i2 < sizes.length; ++i2) {
                out.write(Long.toString(sizes[i2]));
                if (i2 < sizes.length - 1) {
                    out.write(", ");
                    continue;
                }
                out.write("]");
            }
            out.newLine();
            out.write("times without constructor(in msec)=[");
            for (i2 = 0; i2 < times_without_constructor.length; ++i2) {
                out.write(String.format("%.2f", times_without_constructor[i2]));
                if (i2 < times_without_constructor.length - 1) {
                    out.write(", ");
                    continue;
                }
                out.write("]");
            }
            out.newLine();
            out.write("times with constructor(in msec)=[");
            for (i2 = 0; i2 < times_without_constructor.length; ++i2) {
                out.write(String.format("%.2f", times_with_constructor[i2]));
                if (i2 < times_with_constructor.length - 1) {
                    out.write(", ");
                    continue;
                }
                out.write("]");
            }
            out.newLine();
            out.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

