/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.libpam;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.Set;
import java.util.logging.Logger;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;
import org.jvnet.libpam.impl.CLibrary;
import org.jvnet.libpam.impl.PAMLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAM {
    private PAMLibrary.pam_handle_t pht;
    private int ret;
    private String password;
    private static final Logger LOGGER = Logger.getLogger(PAM.class.getName());

    public PAM(String serviceName) throws PAMException {
        PAMLibrary.pam_conv conv = new PAMLibrary.pam_conv(new PAMLibrary.pam_conv.PamCallback(){

            public int callback(int num_msg, Pointer msg, Pointer resp, Pointer _) {
                LOGGER.fine("pam_conv num_msg=" + num_msg);
                if (PAM.this.password == null) {
                    return 6;
                }
                Pointer m4 = CLibrary.libc.calloc(PAMLibrary.pam_response.SIZE, num_msg);
                resp.setPointer(0L, m4);
                for (int i2 = 0; i2 < num_msg; ++i2) {
                    PAMLibrary.pam_message pm = new PAMLibrary.pam_message(msg.getPointer(Native.POINTER_SIZE * i2));
                    LOGGER.fine(pm.msg_style + ":" + pm.msg);
                    if (pm.msg_style != 1) continue;
                    PAMLibrary.pam_response r2 = new PAMLibrary.pam_response(m4.share(PAMLibrary.pam_response.SIZE * i2));
                    r2.setResp(PAM.this.password);
                    r2.write();
                }
                return 0;
            }
        });
        PointerByReference phtr = new PointerByReference();
        this.check(PAMLibrary.libpam.pam_start(serviceName, null, conv, phtr), "pam_start failed");
        this.pht = new PAMLibrary.pam_handle_t(phtr.getValue());
    }

    private void check(int ret, String msg) throws PAMException {
        this.ret = ret;
        if (ret != 0) {
            if (this.pht != null) {
                throw new PAMException(msg + " : " + PAMLibrary.libpam.pam_strerror(this.pht, ret));
            }
            throw new PAMException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnixUser authenticate(String username, String password) throws PAMException {
        this.password = password;
        try {
            this.check(PAMLibrary.libpam.pam_set_item(this.pht, 2, username), "pam_set_item failed");
            this.check(PAMLibrary.libpam.pam_authenticate(this.pht, 0), "pam_authenticate failed");
            PointerByReference r2 = new PointerByReference();
            this.check(PAMLibrary.libpam.pam_get_item(this.pht, 2, r2), "pam_get_item failed");
            String userName = r2.getValue().getString(0L);
            CLibrary.passwd pwd = CLibrary.libc.getpwnam(userName);
            if (pwd == null) {
                throw new PAMException("Authentication succeeded but no user information is available");
            }
            UnixUser unixUser = new UnixUser(userName, pwd);
            return unixUser;
        }
        finally {
            this.password = null;
        }
    }

    public Set<String> getGroupsOfUser(String username) throws PAMException {
        return new UnixUser(username).getGroups();
    }

    public void dispose() {
        if (this.pht != null) {
            PAMLibrary.libpam.pam_end(this.pht, this.ret);
            this.pht = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }
}

