/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh;

import java.io.IOException;
import org.openjdk.jmh.runner.Defaults;
import org.openjdk.jmh.runner.NoBenchmarksException;
import org.openjdk.jmh.runner.ProfilersFailedException;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.CommandLineOptionException;
import org.openjdk.jmh.runner.options.CommandLineOptions;
import org.openjdk.jmh.runner.options.VerboseMode;

public class Main {
    public static void main(String[] argv) throws IOException {
        try {
            CommandLineOptions cmdOptions = new CommandLineOptions(argv);
            Runner runner = new Runner(cmdOptions);
            if (cmdOptions.shouldHelp()) {
                cmdOptions.showHelp();
                return;
            }
            if (cmdOptions.shouldList()) {
                runner.list();
                return;
            }
            if (cmdOptions.shouldListWithParams()) {
                runner.listWithParams(cmdOptions);
                return;
            }
            if (cmdOptions.shouldListProfilers()) {
                cmdOptions.listProfilers();
                return;
            }
            if (cmdOptions.shouldListResultFormats()) {
                cmdOptions.listResultFormats();
                return;
            }
            try {
                runner.run();
            }
            catch (NoBenchmarksException e2) {
                System.err.println("No matching benchmarks. Miss-spelled regexp?");
                if (cmdOptions.verbosity().orElse(Defaults.VERBOSITY) != VerboseMode.EXTRA) {
                    System.err.println("Use " + (Object)((Object)VerboseMode.EXTRA) + " verbose mode to debug the pattern matching.");
                } else {
                    runner.list();
                }
                System.exit(1);
            }
            catch (ProfilersFailedException e3) {
                System.err.println(e3.getMessage());
                System.exit(1);
            }
            catch (RunnerException e4) {
                System.err.print("ERROR: ");
                e4.printStackTrace(System.err);
                System.exit(1);
            }
        }
        catch (CommandLineOptionException e5) {
            System.err.println("Error parsing command line:");
            System.err.println(" " + e5.getMessage());
            System.exit(1);
        }
    }
}

