/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.IterationResultMetaData;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.util.Multimap;
import org.openjdk.jmh.util.TreeMultimap;

public class IterationResult
implements Serializable {
    private static final long serialVersionUID = 960397066774710819L;
    private static final Multimap<String, Result> EMPTY_MAP = new TreeMultimap<String, Result>();
    private static final List<Result> EMPTY_LIST = Collections.emptyList();
    private final BenchmarkParams benchmarkParams;
    private final IterationParams params;
    private final IterationResultMetaData metadata;
    private Collection<Result> primaryResults;
    private Multimap<String, Result> secondaryResults;

    public IterationResult(BenchmarkParams benchmarkParams, IterationParams params, IterationResultMetaData md) {
        this.benchmarkParams = benchmarkParams;
        this.params = params;
        this.metadata = md;
        this.primaryResults = EMPTY_LIST;
        this.secondaryResults = EMPTY_MAP;
    }

    public IterationResultMetaData getMetadata() {
        return this.metadata;
    }

    public void addResults(Collection<? extends Result> rs) {
        for (Result result : rs) {
            this.addResult(result);
        }
    }

    public void addResult(Result result) {
        if (result.getRole().isPrimary()) {
            if (this.primaryResults == EMPTY_LIST) {
                this.primaryResults = Collections.singleton(result);
            } else if (this.primaryResults.size() == 1) {
                ArrayList<Result> newResults = new ArrayList<Result>(2);
                newResults.addAll(this.primaryResults);
                newResults.add(result);
                this.primaryResults = newResults;
            } else {
                this.primaryResults.add(result);
            }
        }
        if (result.getRole().isSecondary()) {
            if (this.secondaryResults == EMPTY_MAP) {
                this.secondaryResults = new TreeMultimap<String, Result>();
            }
            this.secondaryResults.put(result.getLabel(), result);
        }
    }

    public Collection<Result> getRawPrimaryResults() {
        return this.primaryResults;
    }

    public Multimap<String, Result> getRawSecondaryResults() {
        return this.secondaryResults;
    }

    public Map<String, Result> getSecondaryResults() {
        TreeMap<String, Result> answer = new TreeMap<String, Result>();
        for (String label : this.secondaryResults.keys()) {
            Collection<Result> results = this.secondaryResults.get(label);
            Result next = results.iterator().next();
            Aggregator aggregator = next.getThreadAggregator();
            Result result = aggregator.aggregate(results);
            answer.put(label, result);
        }
        answer.putAll(this.produceDerivative(this.getPrimaryResult()));
        HashMap<String, Result> adds = new HashMap<String, Result>();
        for (Result r2 : answer.values()) {
            adds.putAll(this.produceDerivative(r2));
        }
        answer.putAll(adds);
        return answer;
    }

    private Map<String, Result> produceDerivative(Result r2) {
        HashMap<String, Result> map = new HashMap<String, Result>();
        for (Result rr : r2.getDerivativeResults()) {
            map.put(rr.getLabel(), rr);
        }
        return map;
    }

    public Result getPrimaryResult() {
        Aggregator aggregator = this.primaryResults.iterator().next().getThreadAggregator();
        return aggregator.aggregate(this.primaryResults);
    }

    public IterationParams getParams() {
        return this.params;
    }

    public BenchmarkParams getBenchmarkParams() {
        return this.benchmarkParams;
    }

    public String getScoreUnit() {
        return this.getPrimaryResult().getScoreUnit();
    }
}

