/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

class AbstractResourceReader {
    private final String file;
    private final String resource;
    private final String strings;

    protected AbstractResourceReader(String file, String resource, String strings) {
        this.file = file;
        this.resource = resource;
        this.strings = strings;
    }

    protected List<Reader> getReaders() {
        if (this.strings != null) {
            return Collections.singletonList(new StringReader(this.strings));
        }
        if (this.file != null) {
            try {
                return Collections.singletonList(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8));
            }
            catch (FileNotFoundException e2) {
                throw new RuntimeException("ERROR: Could not find resource", e2);
            }
        }
        if (this.resource != null) {
            Enumeration<URL> urls;
            try {
                urls = this.getClass().getClassLoader().getResources(this.resource.startsWith("/") ? this.resource.substring(1) : this.resource);
            }
            catch (IOException e3) {
                throw new RuntimeException("ERROR: While obtaining resource: " + this.resource, e3);
            }
            if (urls.hasMoreElements()) {
                ArrayList<Reader> readers = new ArrayList<Reader>();
                URL url = null;
                try {
                    while (urls.hasMoreElements()) {
                        url = urls.nextElement();
                        InputStream stream = url.openStream();
                        readers.add(new InputStreamReader(stream, StandardCharsets.UTF_8));
                    }
                }
                catch (IOException e4) {
                    for (Reader r2 : readers) {
                        try {
                            r2.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw new RuntimeException("ERROR: While opening resource: " + url, e4);
                }
                return readers;
            }
            throw new RuntimeException("ERROR: Unable to find the resource: " + this.resource);
        }
        throw new IllegalStateException();
    }
}

