/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.openjdk.jmh.util.Multimap;

public class DelegatingMultimap<K, V>
implements Multimap<K, V>,
Serializable {
    private static final long serialVersionUID = 7026540942232962263L;
    protected final Map<K, Collection<V>> map;

    public DelegatingMultimap(Map<K, Collection<V>> map) {
        this.map = map;
    }

    protected Collection<V> createValueCollection() {
        return new ArrayList();
    }

    @Override
    public void put(K key, V value) {
        Collection<V> vs = this.map.get(key);
        if (vs == null) {
            vs = this.createValueCollection();
            this.map.put(key, vs);
        }
        vs.add(value);
    }

    @Override
    public void putAll(K key, Collection<V> vvs) {
        Collection<V> vs = this.map.get(key);
        if (vs == null) {
            vs = this.createValueCollection();
            this.map.put(key, vs);
        }
        vs.addAll(vvs);
    }

    @Override
    public Collection<V> get(K key) {
        Collection<V> vs = this.map.get(key);
        return vs == null ? Collections.emptyList() : Collections.unmodifiableCollection(vs);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Collection<K> keys() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        Collection<V> result = this.createValueCollection();
        for (Collection<V> vs : this.map.values()) {
            result.addAll(vs);
        }
        return result;
    }

    @Override
    public Collection<Map.Entry<K, Collection<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public void remove(K key) {
        this.map.remove(key);
    }

    @Override
    public void merge(Multimap<K, V> other) {
        for (K k2 : other.keys()) {
            this.putAll(k2, other.get(k2));
        }
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DelegatingMultimap that = (DelegatingMultimap)o2;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

