/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

public class Interval
implements Comparable<Interval> {
    public final long src;
    public final long dst;

    public Interval(long src, long dst) {
        this.src = src;
        this.dst = dst;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Interval interval = (Interval)o2;
        if (this.dst != interval.dst) {
            return false;
        }
        return this.src == interval.src;
    }

    public int hashCode() {
        int result = (int)(this.src ^ this.src >>> 32);
        result = 31 * result + (int)(this.dst ^ this.dst >>> 32);
        return result;
    }

    @Override
    public int compareTo(Interval o2) {
        int c1 = Long.compare(this.src, o2.src);
        if (c1 != 0) {
            return c1;
        }
        return Long.compare(this.dst, o2.dst);
    }

    public String toString() {
        return "[" + this.src + ", " + this.dst + "]";
    }
}

