/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.openjdk.jmh.util.AbstractStatistics;

public class ListStatistics
extends AbstractStatistics {
    private static final long serialVersionUID = -90642978235578197L;
    private double[] values = new double[0];
    private int count = 0;

    public ListStatistics() {
    }

    public ListStatistics(double[] samples) {
        this();
        for (double d2 : samples) {
            this.addValue(d2);
        }
    }

    public ListStatistics(long[] samples) {
        this();
        for (long l2 : samples) {
            this.addValue(l2);
        }
    }

    public void addValue(double d2) {
        if (this.count >= this.values.length) {
            this.values = Arrays.copyOf(this.values, Math.max(1, this.values.length << 1));
        }
        this.values[this.count] = d2;
        ++this.count;
    }

    @Override
    public double getMax() {
        if (this.count > 0) {
            double m4 = Double.NEGATIVE_INFINITY;
            for (int i2 = 0; i2 < this.count; ++i2) {
                m4 = Math.max(m4, this.values[i2]);
            }
            return m4;
        }
        return Double.NaN;
    }

    @Override
    public double getMin() {
        if (this.count > 0) {
            double m4 = Double.POSITIVE_INFINITY;
            for (int i2 = 0; i2 < this.count; ++i2) {
                m4 = Math.min(m4, this.values[i2]);
            }
            return m4;
        }
        return Double.NaN;
    }

    @Override
    public long getN() {
        return this.count;
    }

    @Override
    public double getSum() {
        if (this.count > 0) {
            double s2 = 0.0;
            for (int i2 = 0; i2 < this.count; ++i2) {
                s2 += this.values[i2];
            }
            return s2;
        }
        return Double.NaN;
    }

    @Override
    public double getPercentile(double rank) {
        if (this.count == 0) {
            return Double.NaN;
        }
        if (rank == 0.0) {
            return this.getMin();
        }
        this.values = Arrays.copyOf(this.values, this.count);
        Percentile p2 = new Percentile();
        return p2.evaluate(this.values, rank);
    }

    @Override
    public int[] getHistogram(double[] levels) {
        if (levels.length < 2) {
            throw new IllegalArgumentException("Expected more than two levels");
        }
        double[] vs = Arrays.copyOf(this.values, this.count);
        Arrays.sort(vs);
        int[] result = new int[levels.length - 1];
        int c2 = 0;
        block0: for (double v2 : vs) {
            while (levels[c2] > v2 || v2 >= levels[c2 + 1]) {
                if (++c2 <= levels.length - 2) continue;
                break block0;
            }
            int n2 = c2;
            result[n2] = result[n2] + 1;
        }
        return result;
    }

    @Override
    public Iterator<Map.Entry<Double, Long>> getRawData() {
        return new ListStatisticsIterator();
    }

    @Override
    public double getVariance() {
        if (this.count > 1) {
            double v2 = 0.0;
            double m4 = this.getMean();
            for (int i2 = 0; i2 < this.count; ++i2) {
                v2 += Math.pow(this.values[i2] - m4, 2.0);
            }
            return v2 / (double)(this.count - 1);
        }
        return Double.NaN;
    }

    private class ListStatisticsIterator
    implements Iterator<Map.Entry<Double, Long>> {
        private int currentIndex = 0;

        private ListStatisticsIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < ListStatistics.this.count;
        }

        @Override
        public Map.Entry<Double, Long> next() {
            return new AbstractMap.SimpleImmutableEntry<Double, Long>(ListStatistics.this.values[this.currentIndex++], 1L);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Element cannot be removed.");
        }
    }
}

