/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.Serializable;
import java.util.Objects;

public class Optional<T>
implements Serializable {
    private static final long serialVersionUID = 5691070564925468961L;
    private final T val;

    private Optional(T val) {
        if (val == null) {
            throw new IllegalArgumentException("Val can not be null");
        }
        this.val = val;
    }

    private Optional() {
        this.val = null;
    }

    public T orElse(T elseVal) {
        return this.val == null ? elseVal : this.val;
    }

    public Optional<T> orAnother(Optional<T> alternative) {
        return this.val == null ? alternative : this;
    }

    public static <T> Optional<T> none() {
        return new Optional<T>();
    }

    public static <T> Optional<T> of(T val) {
        return new Optional<T>(val);
    }

    public static <T> Optional<T> eitherOf(T val) {
        if (val == null) {
            return Optional.none();
        }
        return Optional.of(val);
    }

    public boolean hasValue() {
        return this.val != null;
    }

    public String toString() {
        if (this.val == null) {
            return "[]";
        }
        return "[" + this.val + "]";
    }

    public T get() {
        if (this.val == null) {
            throw new IllegalStateException("Optional is null");
        }
        return this.val;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Optional optional = (Optional)o2;
        return Objects.equals(this.val, optional.val);
    }

    public int hashCode() {
        return this.val != null ? this.val.hashCode() : 0;
    }
}

