/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.Serializable;
import org.openjdk.jmh.util.MultisetStatistics;
import org.openjdk.jmh.util.Statistics;

public class SampleBuffer
implements Serializable {
    private static final long serialVersionUID = 6124923853916845327L;
    private static final int PRECISION_BITS = 10;
    private static final int BUCKETS = 54;
    private final int[][] hdr = new int[54][];

    public void half() {
        for (int[] bucket : this.hdr) {
            if (bucket == null) continue;
            for (int j2 = 0; j2 < bucket.length; ++j2) {
                int nV = bucket[j2] / 2;
                if (nV == 0) continue;
                bucket[j2] = nV;
            }
        }
    }

    public void add(long sample) {
        int bucket = Math.max(0, 54 - Long.numberOfLeadingZeros(sample));
        int subBucket = (int)(sample >> bucket);
        int[] b2 = this.hdr[bucket];
        if (b2 == null) {
            b2 = new int[1024];
            this.hdr[bucket] = b2;
        }
        int n2 = subBucket;
        b2[n2] = b2[n2] + 1;
    }

    public Statistics getStatistics(double multiplier) {
        MultisetStatistics stat = new MultisetStatistics();
        for (int i2 = 0; i2 < this.hdr.length; ++i2) {
            int[] bucket = this.hdr[i2];
            if (bucket == null) continue;
            for (int j2 = 0; j2 < bucket.length; ++j2) {
                long ns = (long)j2 << i2;
                stat.addValue(multiplier * (double)ns, bucket[j2]);
            }
        }
        return stat;
    }

    public void addAll(SampleBuffer other) {
        for (int i2 = 0; i2 < other.hdr.length; ++i2) {
            int[] otherBucket = other.hdr[i2];
            if (otherBucket == null) continue;
            int[] myBucket = this.hdr[i2];
            if (myBucket == null) {
                myBucket = new int[1024];
                this.hdr[i2] = myBucket;
            }
            for (int j2 = 0; j2 < otherBucket.length; ++j2) {
                int n2 = j2;
                myBucket[n2] = myBucket[n2] + otherBucket[j2];
            }
        }
    }

    public int count() {
        int count2 = 0;
        for (int[] bucket : this.hdr) {
            if (bucket == null) continue;
            for (int v2 : bucket) {
                count2 += v2;
            }
        }
        return count2;
    }
}

