/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr.runtime;

import java.util.List;

public class BitSet
implements Cloneable {
    protected static final int BITS = 64;
    protected static final int LOG_BITS = 6;
    protected static final int MOD_MASK = 63;
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] bits_) {
        this.bits = bits_;
    }

    public BitSet(List items) {
        this();
        for (int i2 = 0; i2 < items.size(); ++i2) {
            Integer v2 = (Integer)items.get(i2);
            this.add(v2);
        }
    }

    public BitSet(int nbits) {
        this.bits = new long[(nbits - 1 >> 6) + 1];
    }

    public static BitSet of(int el) {
        BitSet s2 = new BitSet(el + 1);
        s2.add(el);
        return s2;
    }

    public static BitSet of(int a2, int b2) {
        BitSet s2 = new BitSet(Math.max(a2, b2) + 1);
        s2.add(a2);
        s2.add(b2);
        return s2;
    }

    public static BitSet of(int a2, int b2, int c2) {
        BitSet s2 = new BitSet();
        s2.add(a2);
        s2.add(b2);
        s2.add(c2);
        return s2;
    }

    public static BitSet of(int a2, int b2, int c2, int d2) {
        BitSet s2 = new BitSet();
        s2.add(a2);
        s2.add(b2);
        s2.add(c2);
        s2.add(d2);
        return s2;
    }

    public BitSet or(BitSet a2) {
        if (a2 == null) {
            return this;
        }
        BitSet s2 = (BitSet)this.clone();
        s2.orInPlace(a2);
        return s2;
    }

    public void add(int el) {
        int n2 = BitSet.wordNumber(el);
        if (n2 >= this.bits.length) {
            this.growToInclude(el);
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] | BitSet.bitMask(el);
    }

    public void growToInclude(int bit) {
        int newSize = Math.max(this.bits.length << 1, this.numWordsToHold(bit));
        long[] newbits = new long[newSize];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        this.bits = newbits;
    }

    public void orInPlace(BitSet a2) {
        if (a2 == null) {
            return;
        }
        if (a2.bits.length > this.bits.length) {
            this.setSize(a2.bits.length);
        }
        int min2 = Math.min(this.bits.length, a2.bits.length);
        for (int i2 = min2 - 1; i2 >= 0; --i2) {
            int n2 = i2;
            this.bits[n2] = this.bits[n2] | a2.bits[i2];
        }
    }

    private void setSize(int nwords) {
        long[] newbits = new long[nwords];
        int n2 = Math.min(nwords, this.bits.length);
        System.arraycopy(this.bits, 0, newbits, 0, n2);
        this.bits = newbits;
    }

    private static final long bitMask(int bitNumber) {
        int bitPosition = bitNumber & 0x3F;
        return 1L << bitPosition;
    }

    public Object clone() {
        BitSet s2;
        try {
            s2 = (BitSet)super.clone();
            s2.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, s2.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
        return s2;
    }

    public int size() {
        int deg = 0;
        for (int i2 = this.bits.length - 1; i2 >= 0; --i2) {
            long word = this.bits[i2];
            if (word == 0L) continue;
            for (int bit = 63; bit >= 0; --bit) {
                if ((word & 1L << bit) == 0L) continue;
                ++deg;
            }
        }
        return deg;
    }

    public boolean equals(Object other) {
        block5: {
            int i2;
            int n2;
            BitSet otherSet;
            block4: {
                if (other == null || !(other instanceof BitSet)) {
                    return false;
                }
                otherSet = (BitSet)other;
                n2 = Math.min(this.bits.length, otherSet.bits.length);
                for (i2 = 0; i2 < n2; ++i2) {
                    if (this.bits[i2] == otherSet.bits[i2]) continue;
                    return false;
                }
                if (this.bits.length <= n2) break block4;
                for (i2 = n2 + 1; i2 < this.bits.length; ++i2) {
                    if (this.bits[i2] == 0L) continue;
                    return false;
                }
                break block5;
            }
            if (otherSet.bits.length <= n2) break block5;
            for (i2 = n2 + 1; i2 < otherSet.bits.length; ++i2) {
                if (otherSet.bits[i2] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean member(int el) {
        if (el < 0) {
            return false;
        }
        int n2 = BitSet.wordNumber(el);
        if (n2 >= this.bits.length) {
            return false;
        }
        return (this.bits[n2] & BitSet.bitMask(el)) != 0L;
    }

    public void remove(int el) {
        int n2 = BitSet.wordNumber(el);
        if (n2 < this.bits.length) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] & (BitSet.bitMask(el) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public boolean isNil() {
        for (int i2 = this.bits.length - 1; i2 >= 0; --i2) {
            if (this.bits[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    private final int numWordsToHold(int el) {
        return (el >> 6) + 1;
    }

    public int numBits() {
        return this.bits.length << 6;
    }

    public int lengthInLongWords() {
        return this.bits.length;
    }

    public int[] toArray() {
        int[] elems = new int[this.size()];
        int en = 0;
        for (int i2 = 0; i2 < this.bits.length << 6; ++i2) {
            if (!this.member(i2)) continue;
            elems[en++] = i2;
        }
        return elems;
    }

    public long[] toPackedArray() {
        return this.bits;
    }

    private static final int wordNumber(int bit) {
        return bit >> 6;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String[] tokenNames) {
        StringBuffer buf = new StringBuffer();
        String separator = ",";
        boolean havePrintedAnElement = false;
        buf.append('{');
        for (int i2 = 0; i2 < this.bits.length << 6; ++i2) {
            if (!this.member(i2)) continue;
            if (i2 > 0 && havePrintedAnElement) {
                buf.append(separator);
            }
            if (tokenNames != null) {
                buf.append(tokenNames[i2]);
            } else {
                buf.append(i2);
            }
            havePrintedAnElement = true;
        }
        buf.append('}');
        return buf.toString();
    }
}

