/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr.runtime.debug;

import org.python.antlr.runtime.TokenStream;
import org.python.antlr.runtime.debug.DebugEventListener;
import org.python.antlr.runtime.tree.TreeAdaptor;
import org.python.antlr.runtime.tree.TreeNodeStream;

public class DebugTreeNodeStream
implements TreeNodeStream {
    protected DebugEventListener dbg;
    protected TreeAdaptor adaptor;
    protected TreeNodeStream input;
    protected boolean initialStreamState = true;
    protected int lastMarker;

    public DebugTreeNodeStream(TreeNodeStream input, DebugEventListener dbg) {
        this.input = input;
        this.adaptor = input.getTreeAdaptor();
        this.input.setUniqueNavigationNodes(true);
        this.setDebugListener(dbg);
    }

    public void setDebugListener(DebugEventListener dbg) {
        this.dbg = dbg;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    public void consume() {
        Object node = this.input.LT(1);
        this.input.consume();
        this.dbg.consumeNode(node);
    }

    public Object get(int i2) {
        return this.input.get(i2);
    }

    public Object LT(int i2) {
        Object node = this.input.LT(i2);
        int ID = this.adaptor.getUniqueID(node);
        String text = this.adaptor.getText(node);
        int type = this.adaptor.getType(node);
        this.dbg.LT(i2, node);
        return node;
    }

    public int LA(int i2) {
        Object node = this.input.LT(i2);
        int ID = this.adaptor.getUniqueID(node);
        String text = this.adaptor.getText(node);
        int type = this.adaptor.getType(node);
        this.dbg.LT(i2, node);
        return type;
    }

    public int mark() {
        this.lastMarker = this.input.mark();
        this.dbg.mark(this.lastMarker);
        return this.lastMarker;
    }

    public int index() {
        return this.input.index();
    }

    public void rewind(int marker) {
        this.dbg.rewind(marker);
        this.input.rewind(marker);
    }

    public void rewind() {
        this.dbg.rewind();
        this.input.rewind(this.lastMarker);
    }

    public void release(int marker) {
    }

    public void seek(int index) {
        this.input.seek(index);
    }

    public int size() {
        return this.input.size();
    }

    public Object getTreeSource() {
        return this.input;
    }

    public String getSourceName() {
        return this.getTokenStream().getSourceName();
    }

    public TokenStream getTokenStream() {
        return this.input.getTokenStream();
    }

    public void setUniqueNavigationNodes(boolean uniqueNavigationNodes) {
        this.input.setUniqueNavigationNodes(uniqueNavigationNodes);
    }

    public void replaceChildren(Object parent, int startChildIndex, int stopChildIndex, Object t2) {
        this.input.replaceChildren(parent, startChildIndex, stopChildIndex, t2);
    }

    public String toString(Object start, Object stop2) {
        return this.input.toString(start, stop2);
    }
}

