/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.python.antlr.runtime.TokenStream;
import org.python.antlr.runtime.misc.IntArray;
import org.python.antlr.runtime.tree.CommonTree;
import org.python.antlr.runtime.tree.CommonTreeAdaptor;
import org.python.antlr.runtime.tree.TreeAdaptor;
import org.python.antlr.runtime.tree.TreeNodeStream;

public class BufferedTreeNodeStream
implements TreeNodeStream {
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 100;
    public static final int INITIAL_CALL_STACK_SIZE = 10;
    protected Object down;
    protected Object up;
    protected Object eof;
    protected List nodes;
    protected Object root;
    protected TokenStream tokens;
    TreeAdaptor adaptor;
    protected boolean uniqueNavigationNodes = false;
    protected int p = -1;
    protected int lastMarker;
    protected IntArray calls;

    public BufferedTreeNodeStream(Object tree) {
        this(new CommonTreeAdaptor(), tree);
    }

    public BufferedTreeNodeStream(TreeAdaptor adaptor, Object tree) {
        this(adaptor, tree, 100);
    }

    public BufferedTreeNodeStream(TreeAdaptor adaptor, Object tree, int initialBufferSize) {
        this.root = tree;
        this.adaptor = adaptor;
        this.nodes = new ArrayList(initialBufferSize);
        this.down = adaptor.create(2, "DOWN");
        this.up = adaptor.create(3, "UP");
        this.eof = adaptor.create(-1, "EOF");
    }

    protected void fillBuffer() {
        this.fillBuffer(this.root);
        this.p = 0;
    }

    public void fillBuffer(Object t2) {
        boolean nil = this.adaptor.isNil(t2);
        if (!nil) {
            this.nodes.add(t2);
        }
        int n2 = this.adaptor.getChildCount(t2);
        if (!nil && n2 > 0) {
            this.addNavigationNode(2);
        }
        for (int c2 = 0; c2 < n2; ++c2) {
            Object child = this.adaptor.getChild(t2, c2);
            this.fillBuffer(child);
        }
        if (!nil && n2 > 0) {
            this.addNavigationNode(3);
        }
    }

    protected int getNodeIndex(Object node) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        for (int i2 = 0; i2 < this.nodes.size(); ++i2) {
            Object t2 = this.nodes.get(i2);
            if (t2 != node) continue;
            return i2;
        }
        return -1;
    }

    protected void addNavigationNode(int ttype) {
        Object navNode = null;
        navNode = ttype == 2 ? (this.hasUniqueNavigationNodes() ? this.adaptor.create(2, "DOWN") : this.down) : (this.hasUniqueNavigationNodes() ? this.adaptor.create(3, "UP") : this.up);
        this.nodes.add(navNode);
    }

    public Object get(int i2) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return this.nodes.get(i2);
    }

    public Object LT(int k2) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (k2 == 0) {
            return null;
        }
        if (k2 < 0) {
            return this.LB(-k2);
        }
        if (this.p + k2 - 1 >= this.nodes.size()) {
            return this.eof;
        }
        return this.nodes.get(this.p + k2 - 1);
    }

    public Object getCurrentSymbol() {
        return this.LT(1);
    }

    protected Object LB(int k2) {
        if (k2 == 0) {
            return null;
        }
        if (this.p - k2 < 0) {
            return null;
        }
        return this.nodes.get(this.p - k2);
    }

    public Object getTreeSource() {
        return this.root;
    }

    public String getSourceName() {
        return this.getTokenStream().getSourceName();
    }

    public TokenStream getTokenStream() {
        return this.tokens;
    }

    public void setTokenStream(TokenStream tokens) {
        this.tokens = tokens;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    public void setTreeAdaptor(TreeAdaptor adaptor) {
        this.adaptor = adaptor;
    }

    public boolean hasUniqueNavigationNodes() {
        return this.uniqueNavigationNodes;
    }

    public void setUniqueNavigationNodes(boolean uniqueNavigationNodes) {
        this.uniqueNavigationNodes = uniqueNavigationNodes;
    }

    public void consume() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        ++this.p;
    }

    public int LA(int i2) {
        return this.adaptor.getType(this.LT(i2));
    }

    public int mark() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        this.lastMarker = this.index();
        return this.lastMarker;
    }

    public void release(int marker) {
    }

    public int index() {
        return this.p;
    }

    public void rewind(int marker) {
        this.seek(marker);
    }

    public void rewind() {
        this.seek(this.lastMarker);
    }

    public void seek(int index) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        this.p = index;
    }

    public void push(int index) {
        if (this.calls == null) {
            this.calls = new IntArray();
        }
        this.calls.push(this.p);
        this.seek(index);
    }

    public int pop() {
        int ret = this.calls.pop();
        this.seek(ret);
        return ret;
    }

    public void reset() {
        this.p = 0;
        this.lastMarker = 0;
        if (this.calls != null) {
            this.calls.clear();
        }
    }

    public int size() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return this.nodes.size();
    }

    public Iterator iterator() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return new StreamIterator();
    }

    public void replaceChildren(Object parent, int startChildIndex, int stopChildIndex, Object t2) {
        if (parent != null) {
            this.adaptor.replaceChildren(parent, startChildIndex, stopChildIndex, t2);
        }
    }

    public String toTokenTypeString() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < this.nodes.size(); ++i2) {
            Object t2 = this.nodes.get(i2);
            buf.append(" ");
            buf.append(this.adaptor.getType(t2));
        }
        return buf.toString();
    }

    public String toTokenString(int start, int stop2) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        StringBuffer buf = new StringBuffer();
        for (int i2 = start; i2 < this.nodes.size() && i2 <= stop2; ++i2) {
            Object t2 = this.nodes.get(i2);
            buf.append(" ");
            buf.append(this.adaptor.getToken(t2));
        }
        return buf.toString();
    }

    public String toString(Object start, Object stop2) {
        String text;
        int i2;
        System.out.println("toString");
        if (start == null || stop2 == null) {
            return null;
        }
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (start instanceof CommonTree) {
            System.out.print("toString: " + ((CommonTree)start).getToken() + ", ");
        } else {
            System.out.println(start);
        }
        if (stop2 instanceof CommonTree) {
            System.out.println(((CommonTree)stop2).getToken());
        } else {
            System.out.println(stop2);
        }
        if (this.tokens != null) {
            int beginTokenIndex = this.adaptor.getTokenStartIndex(start);
            int endTokenIndex = this.adaptor.getTokenStopIndex(stop2);
            if (this.adaptor.getType(stop2) == 3) {
                endTokenIndex = this.adaptor.getTokenStopIndex(start);
            } else if (this.adaptor.getType(stop2) == -1) {
                endTokenIndex = this.size() - 2;
            }
            return this.tokens.toString(beginTokenIndex, endTokenIndex);
        }
        Object t2 = null;
        for (i2 = 0; i2 < this.nodes.size() && (t2 = this.nodes.get(i2)) != start; ++i2) {
        }
        StringBuffer buf = new StringBuffer();
        t2 = this.nodes.get(i2);
        while (t2 != stop2) {
            text = this.adaptor.getText(t2);
            if (text == null) {
                text = " " + String.valueOf(this.adaptor.getType(t2));
            }
            buf.append(text);
            t2 = this.nodes.get(++i2);
        }
        text = this.adaptor.getText(stop2);
        if (text == null) {
            text = " " + String.valueOf(this.adaptor.getType(stop2));
        }
        buf.append(text);
        return buf.toString();
    }

    protected class StreamIterator
    implements Iterator {
        int i = 0;

        protected StreamIterator() {
        }

        public boolean hasNext() {
            return this.i < BufferedTreeNodeStream.this.nodes.size();
        }

        public Object next() {
            int current;
            if ((current = this.i++) < BufferedTreeNodeStream.this.nodes.size()) {
                return BufferedTreeNodeStream.this.nodes.get(current);
            }
            return BufferedTreeNodeStream.this.eof;
        }

        public void remove() {
            throw new RuntimeException("cannot remove nodes from stream");
        }
    }
}

